/* Any copyright is dedicated to the Public Domain.
 http://creativecommons.org/publicdomain/zero/1.0/ */
"use strict";

const TEST_URI = URL_ROOT_SSL + "doc_rules_imported_stylesheet_edit.html";
const SJS_URI = URL_ROOT_SSL + "sjs_imported_stylesheet_edit.sjs";
/**
 * Test that imported stylesheets are correctly handled by the inspector after
 * being updated.
 * The inspector used to retrieve an outdated version of the stylesheet text,
 * which triggered many issues: outdated values, blank panels etc...
 *
 * This test involves an imported CSS which is generated by a sjs file.
 * Using sjs here allows us to simulate an "update" of a stylesheet while still
 * fetching the same URL, which closely matches what a developer would experience
 * when manually editing a stylesheet in an IDE before reloading a page.
 */
add_task(async function() {
  info("Call `?setup` on the test sjs");
  await fetch(SJS_URI + "?setup");

  info("Add the test tab, open the rule-view and select the test node");
  await addTab(TEST_URI);

  const { inspector, view } = await openRuleView();

  await selectNode("div", inspector);
  const redColorProp = getTextProperty(view, 1, { color: "red" });
  ok(redColorProp, "RuleView displays a color:red property");

  // The "?update-stylesheet" call will change the CSS returned by sjs_imported_stylesheet_edit.sjs:
  // - some rules are added before the matching `div {}` rule
  // - the value of the `color` property changes
  info("Call `?update-stylesheet` on the test sjs");
  await fetch(SJS_URI + "?update-stylesheet");

  info("Reload the page to restore the initial state");
  await navigateTo(TEST_URI);

  info("Wait until a rule is displayed at index 1");
  await waitFor(() => view.element.children[1]);

  info("Check that the displayed rule has been correctly updated.");
  const goldColorProp = getTextProperty(view, 1, { color: "gold" });
  ok(goldColorProp, "RuleView displays a color:gold property");
});
