// For documentation of the format, see README in this directory.
var browserTests = [
["foo[]bar",
    [["forecolor","#0000FF"]],
    "foo[]bar",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<p><span style=\"color:rgb(0, 0, 255)\">[foo</span></p> <p><span style=\"color:rgb(0, 0, 255)\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<p><font color=\"#0000ff\">[foo</font></p> <p><font color=\"#0000ff\">bar]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\"><span>[foo</span> <span>bar]</span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\"><span>[foo</span> <span>bar]</span></font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<p><span style=\"color:rgb(0, 0, 255)\">[foo</span></p><p> <span style=\"color:rgb(0, 0, 255)\"><span>bar</span></span> </p><p><span style=\"color:rgb(0, 0, 255)\">baz]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<p><font color=\"#0000ff\">[foo</font></p><p> <font color=\"#0000ff\"><span>bar</span></font> </p><p><font color=\"#0000ff\">baz]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<p><span style=\"color:rgb(0, 0, 255)\">[foo</span></p><p><span style=\"color:rgb(0, 0, 255)\"><br></span></p><p><span style=\"color:rgb(0, 0, 255)\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<p><font color=\"#0000ff\">[foo</font></p><p><font color=\"#0000ff\"><br></font></p><p><font color=\"#0000ff\">bar]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<b>foo[]bar</b>",
    [["forecolor","#0000FF"]],
    "<b>foo[]bar</b>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<i>foo[]bar</i>",
    [["forecolor","#0000FF"]],
    "<i>foo[]bar</i>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span>foo</span>{}<span>bar</span>",
    [["forecolor","#0000FF"]],
    "<span>foo</span>{}<span>bar</span>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span>foo[</span><span>]bar</span>",
    [["forecolor","#0000FF"]],
    "<span>foo[</span><span>]bar</span>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar</span><b><span style=\"color:rgb(0, 0, 255)\">baz]</span>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"#0000ff\">[bar</font><b><font color=\"#0000ff\">baz]</font>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar</span><i><span style=\"color:rgb(0, 0, 255)\">baz]</span>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"#0000ff\">[bar</font><i><font color=\"#0000ff\">baz]</font>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "{<p></p><p> </p><p><span style=\"color:rgb(0, 0, 255)\">foo</span></p>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "{<p></p><p> </p><p><font color=\"#0000ff\">foo</font></p>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","blue"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","blue"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["forecolor","f"]],
    "foo[bar]baz",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
    [["forecolor","#f"]],
    "foo[bar]baz",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","00f"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","00f"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","#00f"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","#00f"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","0000ff"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","0000ff"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","#0000ff"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","#0000ff"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["forecolor","000000fff"]],
    "foo[bar]baz",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
    [["forecolor","#000000fff"]],
    "foo[bar]baz",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgb(0, 0, 255)"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgb(0, 0, 255)"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgb(0%, 0%, 100%)"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgb(0%, 0%, 100%)"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgb( 0 ,0 ,255)"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgb( 0 ,0 ,255)"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgba(0, 0, 255, 0.0)"]],
    "foo<span style=\"color:rgba(0, 0, 0, 0)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 255, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgba(0, 0, 255, 0.0)"]],
    "foo<span style=\"color:rgba(0, 0, 0, 0)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 255, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgb(15, -10, 375)"]],
    "foo<span style=\"color:rgb(15, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(15, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgb(15, -10, 375)"]],
    "foo<font color=\"#0f00ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(15, 0, 255)"]}],
["foo[bar]baz",
    [["forecolor","rgba(0, 0, 0, 1)"]],
    "foo[bar]baz",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgba(255, 255, 255, 1)"]],
    "foo<span style=\"color:rgb(255, 255, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(255, 255, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgba(255, 255, 255, 1)"]],
    "foo<font color=\"#ffffff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(255, 255, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","rgba(0, 0, 255, 0.5)"]],
    "foo<span style=\"color:rgba(0, 0, 255, 0.5)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 255, 0.5)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","rgba(0, 0, 255, 0.5)"]],
    "foo<span style=\"color:rgba(0, 0, 255, 0.5)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 255, 0.5)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","hsl(240, 100%, 50%)"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","hsl(240, 100%, 50%)"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","cornsilk"]],
    "foo<span style=\"color:rgb(255, 248, 220)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(255, 248, 220)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","cornsilk"]],
    "foo<font color=\"#fff8dc\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(255, 248, 220)"]}],
["foo[bar]baz",
    [["forecolor","potato quiche"]],
    "foo[bar]baz",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["forecolor","transparent"]],
    "foo<span style=\"color:rgba(0, 0, 0, 0)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 0, 0)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["forecolor","transparent"]],
    "foo<span style=\"color:rgba(0, 0, 0, 0)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 0, 0)"]}],
["foo[bar]baz",
    [["forecolor","currentColor"]],
    "foo[bar]baz",
    [false],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<table><tbody><tr><td>foo</td><td>b<span style=\"color:rgb(0, 0, 255)\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<table><tbody><tr><td>foo</td><td>b<font color=\"#0000ff\">[a]</font>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<table><tbody><tr><td>foo</td>{<td><span style=\"color:rgb(0, 0, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<table><tbody><tr><td>foo</td>{<td><font color=\"#0000ff\">bar</font></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<table><tbody><tr>{<td><span style=\"color:rgb(0, 0, 255)\">foo</span></td><td><span style=\"color:rgb(0, 0, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<table><tbody><tr>{<td><font color=\"#0000ff\">foo</font></td><td><font color=\"#0000ff\">bar</font></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<table><tbody>{<tr><td><span style=\"color:rgb(0, 0, 255)\">foo</span></td><td><span style=\"color:rgb(0, 0, 255)\">bar</span></td><td><span style=\"color:rgb(0, 0, 255)\">baz</span></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<table><tbody>{<tr><td><font color=\"#0000ff\">foo</font></td><td><font color=\"#0000ff\">bar</font></td><td><font color=\"#0000ff\">baz</font></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<table>{<tbody><tr><td><span style=\"color:rgb(0, 0, 255)\">foo</span></td><td><span style=\"color:rgb(0, 0, 255)\">bar</span></td><td><span style=\"color:rgb(0, 0, 255)\">baz</span></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<table>{<tbody><tr><td><font color=\"#0000ff\">foo</font></td><td><font color=\"#0000ff\">bar</font></td><td><font color=\"#0000ff\">baz</font></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "{<table><tbody><tr><td><span style=\"color:rgb(0, 0, 255)\">foo</span></td><td><span style=\"color:rgb(0, 0, 255)\">bar</span></td><td><span style=\"color:rgb(0, 0, 255)\">baz</span></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "{<table><tbody><tr><td><font color=\"#0000ff\">foo</font></td><td><font color=\"#0000ff\">bar</font></td><td><font color=\"#0000ff\">baz</font></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=blue>[bar]</font>baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=blue>[bar]</font>baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["foo{<font color=blue>bar</font>}baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo{<span style=\"color:rgb(0, 0, 255)\">bar}</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["foo{<font color=blue>bar</font>}baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo{<font color=\"#0000ff\">bar}</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
// Once the inner <span> style is updated, it has same style as the outer one.
// Therefore, it may be okay to use the outer one is the only container of the
// text nodes or it may be okay to split the outer one and keep 3 <span>s.
["<span style=\"color: blue\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    ["<span style=\"color:rgb(0, 0, 255)\">foo</span><span style=\"color:rgb(0, 0, 255)\">bar</span><span style=\"color:rgb(0, 0, 255)\">baz</span>",
     "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>"],
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: blue\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo</span><font color=\"#0000ff\">[bar]</font><span style=\"color:rgb(0, 0, 255)\">baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #00f\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #00f\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #0000ff\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #0000ff\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
// Use the inner <font> for the `style` attribute container.  Then, the outer
// <font> should be split and may be serialized.
["<font color=blue>foo<font color=brown>[bar]</font>baz</font>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    ["<span style=\"color:rgb(0, 0, 255)\">foo</span><font style=\"color:rgb(0, 0, 255)\">bar</font><span style=\"color:rgb(0, 0, 255)\">baz</span>",
     "<font color=\"blue\">foo</font><span style=\"color:rgb(0, 0, 255)\">bar</span><font color=\"blue\">baz</font>"],
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<font color=blue>foo<font color=brown>[bar]</font>baz</font>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"blue\">foo[bar]baz</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span style=\"color: brown\">b[ar]</span>baz</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo<span style=\"color:rgb(165, 42, 42)\">b</span>[ar]baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span style=\"color: brown\">b[ar]</span>baz</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo<font color=\"#a52a2a\">b</font>[ar]baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<span id=purple>ba[r</span>ba]z",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<span id=\"purple\">ba<span style=\"color:rgb(0, 0, 255)\">[r</span></span><span style=\"color:rgb(0, 0, 255)\">ba]</span>z",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(128, 0, 128)",false,false,"rgb(0, 0, 255)"]}],
["foo<span id=purple>ba[r</span>ba]z",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<span id=\"purple\">ba<font color=\"#0000ff\">[r</font></span><font color=\"#0000ff\">ba]</font>z",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(128, 0, 128)",false,false,"rgb(0, 0, 255)"]}],
// XXX Looks like that there is no good solution for this case because id=purple
// may affect the style, but it's unclear for builtin editors of the browsers.
["<span style=\"color: rgb(0, 0, 255)\">foo<span id=purple>b[a]r</span>baz</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo<span id=\"purple\">b<span style=\"color:rgb(0, 0, 255)\">[a]</span>r</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(128, 0, 128)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span id=purple>b[a]r</span>baz</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">foo<span id=\"purple\">b<font color=\"#0000ff\">[a]</font>r</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(128, 0, 128)",false,false,"rgb(0, 0, 255)"]}],
["<a href=http://www.google.com>foo[bar]baz</a>",
    [["forecolor","blue"]],
    "<a href=\"http://www.google.com\">foo[bar]baz</a>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<a href=http://www.google.com>foo[bar]baz</a>",
    [["forecolor","#0000ff"]],
    "<a href=\"http://www.google.com\">foo[bar]baz</a>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<a href=http://www.google.com>foo[bar]baz</a>",
    [["forecolor","rgb(0,0,255)"]],
    "<a href=\"http://www.google.com\">foo[bar]baz</a>",
    [true],
    {"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"blue\">[foo]</font>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"blue\">[foo]</font>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"0000ff\">[foo]</font>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"0000ff\">[foo]</font>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"#0000ff\">[foo]</font>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"#0000ff\">[foo]</font>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: blue\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: blue\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #0000ff\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #0000ff\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0%, 0%, 100%)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0%, 0%, 100%)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb( 0 ,0 ,255)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb( 0 ,0 ,255)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 255, 0.0)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgba(0, 0, 255, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 255, 0.0)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgba(0, 0, 255, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(15, -10, 375)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(15, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(15, -10, 375)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(15, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 0, 1)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 0, 1)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(255, 255, 255, 1)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(255, 255, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(255, 255, 255, 1)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(255, 255, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 255, 0.5)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgba(0, 0, 255, 0.5)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 255, 0.5)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgba(0, 0, 255, 0.5)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: hsl(240, 100%, 50%)\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: hsl(240, 100%, 50%)\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: cornsilk\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(255, 248, 220)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: cornsilk\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(255, 248, 220)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: transparent\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: transparent\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: currentColor\">[foo]</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: currentColor\">[foo]</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"#0000ff\">[foo]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["fo[o<font color=brown>b]ar</font>baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "fo<span style=\"color:rgb(0, 0, 255)\">[ob]</span><font color=\"brown\">ar</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["fo[o<font color=brown>b]ar</font>baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "fo<font color=\"#0000ff\">[ob]</font><font color=\"brown\">ar</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>ba[r</font>b]az",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<font color=\"brown\">ba</font><span style=\"color:rgb(0, 0, 255)\">[rb]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>ba[r</font>b]az",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"brown\">ba</font><font color=\"#0000ff\">[rb]</font>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["fo[o<font color=brown>bar</font>b]az",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "fo<span style=\"color:rgb(0, 0, 255)\">[obarb]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["fo[o<font color=brown>bar</font>b]az",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "fo<font color=\"#0000ff\">[obarb]</font>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[<font color=brown>b]ar</font>baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[b]</span><font color=\"brown\">ar</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo[<font color=brown>b]ar</font>baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"#0000ff\">[b]</font><font color=\"brown\">ar</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>ba[r</font>]baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<font color=\"brown\">ba</font><span style=\"color:rgb(0, 0, 255)\">[r]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>ba[r</font>]baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"brown\">ba</font><font color=\"#0000ff\">[r]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo[<font color=brown>bar</font>]baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo[<span style=\"color:rgb(0, 0, 255)\">bar</span>]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo[<font color=brown>bar</font>]baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo[<font color=\"#0000ff\">bar</font>]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>[bar]</font>baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>[bar]</font>baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo<font color=\"#0000ff\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo{<font color=brown>bar</font>}baz",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "foo{<span style=\"color:rgb(0, 0, 255)\">bar}</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo{<font color=brown>bar</font>}baz",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "foo{<font color=\"#0000ff\">bar}</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<font color=brown>fo[o</font><span style=color:brown>b]ar</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<font color=\"brown\">fo</font><span style=\"color:rgb(0, 0, 255)\">[ob]</span><span style=\"color:rgb(165, 42, 42)\">ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<font color=brown>fo[o</font><span style=color:brown>b]ar</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<font color=\"brown\">fo</font><font color=\"#0000ff\">ob</font><span style=\"color:rgb(165, 42, 42)\">ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=color:brown>fo[o</span><span style=color:#0000ff>b]ar</span>",
    [["stylewithcss","true"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(165, 42, 42)\">fo</span><span style=\"color:rgb(0, 0, 255)\">[ob]ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=color:brown>fo[o</span><span style=color:#0000ff>b]ar</span>",
    [["stylewithcss","false"],["forecolor","#0000FF"]],
    "<span style=\"color:rgb(165, 42, 42)\">fo</span><font color=\"#0000ff\">[ob]</font><span style=\"color:rgb(0, 0, 255)\">ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],

// If contents of <font> are entirely selected, it should be reused.
["<font size=7>[abc]</font>",
   [["styleWithCSS","false"],["foreColor","#ff0000"]],
   ["<font color=\"#ff0000\" size=\"7\">[abc]</font>",
    "<font size=\"7\" color=\"#ff0000\">[abc]</font>"],
   [true,true],
   {}],
["<font face=monospace>[abc]</font>",
   [["styleWithCSS","false"],["foreColor","#ff0000"]],
   ["<font face=\"monospace\" color=\"#ff0000\">[abc]</font>",
    "<font color=\"#ff0000\" face=\"monospace\">[abc]</font>"],
   [true,true],
   {}],
["<font size=\"7\" face=monospace>[abc]</font>",
   [["styleWithCSS","false"],["foreColor","#ff0000"]],
   ["<font color=\"#ff0000\" face=\"monospace\" size=\"7\">[abc]</font>",
    "<font color=\"#ff0000\" size=\"7\" face=\"monospace\">[abc]</font>",
    "<font face=\"monospace\" color=\"#ff0000\" size=\"7\">[abc]</font>",
    "<font face=\"monospace\" size=\"7\" color=\"#ff0000\">[abc]</font>",
    "<font size=\"7\" color=\"#ff0000\" face=\"monospace\">[abc]</font>",
    "<font size=\"7\" face=\"monospace\" color=\"#ff0000\">[abc]</font>"],
   [true,true],
   {}],
// but don't split existing <font> if partially selected.
["<font size=7>[a]bc</font>",
   [["styleWithCSS","false"],["foreColor","#ff0000"]],
   "<font size=\"7\"><font color=\"#ff0000\">[a]</font>bc</font>",
   [true,true],
   {}],
["<font size=7>ab[c]</font>",
   [["styleWithCSS","false"],["foreColor","#ff0000"]],
   "<font size=\"7\">ab<font color=\"#ff0000\">[c]</font></font>",
   [true,true],
   {}],
["<font face=monospace>[a]bc</font>",
   [["styleWithCSS","false"],["foreColor","#ff0000"]],
   "<font face=\"monospace\"><font color=\"#ff0000\">[a]</font>bc</font>",
   [true,true],
   {}],
["<font face=monospace>ab[c]</font>",
   [["styleWithCSS","false"],["foreColor","#ff0000"]],
   "<font face=\"monospace\">ab<font color=\"#ff0000\">[c]</font></font>",
   [true,true],
   {}],

// When typing text, `styleWithCSS` value may have been changed at setting the
// style.  In the cases, consider to use HTML or CSS style when typing text,
// but if it's impossible to set with `<font color="...">`, use
// `<span style="color:rgba(...)">` even if `styleWithCSS` is "false".
["a[]c",
    [["styleWithCSS","true"],["foreColor","#0000FF"],["styleWithCSS","false"],["insertText","b"]],
    "a<font color=\"#0000ff\">b</font>c",
    [true,true,true,true],
    {}],
["a[]c",
    [["styleWithCSS","true"],["foreColor","rgb(0, 0, 255)"],["styleWithCSS","false"],["insertText","b"]],
    "a<font color=\"#0000ff\">b</font>c",
    [true,true,true,true],
    {}],
["a[]c",
    [["styleWithCSS","true"],["foreColor","rgba(0, 0, 255, 0.5)"],["styleWithCSS","false"],["insertText","b"]],
    "a<span style=\"color:rgba(0, 0, 255, 0.5)\">b</span>c",
    [true,true,true,true],
    {}],
["a[]c",
    [["styleWithCSS","true"],["foreColor","transparent"],["styleWithCSS","false"],["insertText","b"]],
    "a<span style=\"color:rgba(0, 0, 0, 0)\">b</span>c",
    [true,true,true,true],
    {}],
["a[]c",
    [["styleWithCSS","false"],["foreColor","#0000FF"],["styleWithCSS","true"],["insertText","b"]],
    "a<span style=\"color:rgb(0, 0, 255)\">b</span>c",
    [true,true,true,true],
    {}],
["a[]c",
    [["styleWithCSS","false"],["foreColor","rgb(0, 0, 255)"],["styleWithCSS","true"],["insertText","b"]],
    "a<span style=\"color:rgb(0, 0, 255)\">b</span>c",
    [true,true,true,true],
    {}],
["a[]c",
    [["styleWithCSS","false"],["foreColor","rgba(0, 0, 255, 0.5)"],["styleWithCSS","true"],["insertText","b"]],
    "a<span style=\"color:rgba(0, 0, 255, 0.5)\">b</span>c",
    [true,true,true,true],
    {}],
["a[]c",
    [["styleWithCSS","false"],["foreColor","transparent"],["styleWithCSS","true"],["insertText","b"]],
    "a<span style=\"color:rgba(0, 0, 0, 0)\">b</span>c",
    [true,true,true,true],
    {}],
]
