// META: script=/resources/testdriver.js
// META: script=/resources/testdriver-vendor.js
// META: script=/common/gc.js
// META: script=/bluetooth/resources/bluetooth-test.js
// META: script=/bluetooth/resources/bluetooth-fake-devices.js
// Generated by //third_party/WebKit/LayoutTests/bluetooth/generate.py
'use strict';
const test_desc = 'Garbage Collection ran during getCharacteristics ' +
    'call that fails. Should not crash';
const expected = new DOMException(
    'GATT Server is disconnected. Cannot retrieve characteristics. ' +
    '(Re)connect first with `device.gatt.connect`.',
    'NetworkError');
let promise;

bluetooth_test(() => getHealthThermometerService()
    .then(({service}) => {
      promise = assert_promise_rejects_with_message(
          service.getCharacteristics('measurement_interval'), expected);
      // Disconnect called to clear attributeInstanceMap and allow the object to
      // get garbage collected.
      service.device.gatt.disconnect();
    })
    .then(garbageCollect)
    .then(() => promise),
    test_desc);

