/* THIS FILE IS AUTOGENERATED FROM IntersectionObserver.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_IntersectionObserverBinding_h
#define mozilla_dom_IntersectionObserverBinding_h

#include "DOMRectBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Element.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class DOMIntersectionObserver;
struct DOMIntersectionObserverAtoms;
class DOMIntersectionObserverEntry;
struct DOMIntersectionObserverEntryAtoms;
struct DOMRectInit;
class DoubleOrDoubleSequence;
class Element;
class IntersectionCallback;
struct IntersectionObserverEntryInitAtoms;
struct IntersectionObserverInitAtoms;
struct NativePropertyHooks;
class OwningDoubleOrDoubleSequence;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

class DoubleOrDoubleSequence
{
  friend class DoubleOrDoubleSequenceArgument;
  enum Type
  {
    eUninitialized,
    eDouble,
    eDoubleSequence
  };

  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<binding_detail::AutoSequence<double> > mDoubleSequence;

  };

  Type mType;
  Value mValue;

  DoubleOrDoubleSequence(const DoubleOrDoubleSequence&) = delete;
  void operator=(const DoubleOrDoubleSequence&) = delete;
public:
  explicit inline DoubleOrDoubleSequence()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrDoubleSequence()
  {
    Uninit();
  }

  inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline binding_detail::AutoSequence<double>&
  RawSetAsDoubleSequence()
  {
    if (mType == eDoubleSequence) {
      return mValue.mDoubleSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDoubleSequence;
    return mValue.mDoubleSequence.SetValue();
  }

  inline binding_detail::AutoSequence<double>&
  SetAsDoubleSequence()
  {
    if (mType == eDoubleSequence) {
      return mValue.mDoubleSequence.Value();
    }
    Uninit();
    mType = eDoubleSequence;
    return mValue.mDoubleSequence.SetValue();
  }

  inline bool
  IsDoubleSequence() const
  {
    return mType == eDoubleSequence;
  }

  inline binding_detail::AutoSequence<double>&
  GetAsDoubleSequence()
  {
    MOZ_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  inline const Sequence<double>&
  GetAsDoubleSequence() const
  {
    MOZ_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eDoubleSequence: {
        DestroyDoubleSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyDouble()
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyDoubleSequence()
  {
    MOZ_ASSERT(IsDoubleSequence(), "Wrong type!");
    mValue.mDoubleSequence.Destroy();
    mType = eUninitialized;
  }
};


class OwningDoubleOrDoubleSequence : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningDoubleOrDoubleSequence& aUnion);
  enum Type
  {
    eUninitialized,
    eDouble,
    eDoubleSequence
  };

  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<Sequence<double> > mDoubleSequence;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrDoubleSequence()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningDoubleOrDoubleSequence(const OwningDoubleOrDoubleSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrDoubleSequence()
  {
    Uninit();
  }

  double&
  RawSetAsDouble();

  double&
  SetAsDouble();

  bool
  TrySetToDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  Sequence<double>&
  RawSetAsDoubleSequence();

  Sequence<double>&
  SetAsDoubleSequence();

  bool
  TrySetToDoubleSequence(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsDoubleSequence() const
  {
    return mType == eDoubleSequence;
  }

  inline Sequence<double>&
  GetAsDoubleSequence()
  {
    MOZ_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  inline Sequence<double> const &
  GetAsDoubleSequence() const
  {
    MOZ_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningDoubleOrDoubleSequence& aOther);

private:
  void
  DestroyDouble();

  void
  DestroyDoubleSequence();
};


struct IntersectionObserverEntryInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR DOMRectInit mBoundingClientRect;
  MOZ_INIT_OUTSIDE_CTOR DOMRectInit mIntersectionRect;
  MOZ_INIT_OUTSIDE_CTOR DOMRectInit mRootBounds;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::dom::Element> mTarget;
  MOZ_INIT_OUTSIDE_CTOR double mTime;

  IntersectionObserverEntryInit();

  explicit inline IntersectionObserverEntryInit(const FastDictionaryInitializer& )
    : mBoundingClientRect(FastDictionaryInitializer()),
      mIntersectionRect(FastDictionaryInitializer()),
      mRootBounds(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline IntersectionObserverEntryInit(const IntersectionObserverEntryInit& aOther)
    : mBoundingClientRect(FastDictionaryInitializer()),
      mIntersectionRect(FastDictionaryInitializer()),
      mRootBounds(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const IntersectionObserverEntryInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, IntersectionObserverEntryInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastIntersectionObserverEntryInit : public IntersectionObserverEntryInit
{
  inline FastIntersectionObserverEntryInit()
    : IntersectionObserverEntryInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct IntersectionObserverInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR RefPtr<mozilla::dom::Element> mRoot;
  MOZ_INIT_OUTSIDE_CTOR nsString mRootMargin;
  MOZ_INIT_OUTSIDE_CTOR OwningDoubleOrDoubleSequence mThreshold;

  IntersectionObserverInit();

  explicit inline IntersectionObserverInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline IntersectionObserverInit(const IntersectionObserverInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const IntersectionObserverInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, IntersectionObserverInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastIntersectionObserverInit : public IntersectionObserverInit
{
  inline FastIntersectionObserverInit()
    : IntersectionObserverInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class IntersectionCallback : public CallbackFunction
{
public:
  explicit inline IntersectionCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IntersectionCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IntersectionCallback(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IntersectionCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const Sequence<OwningNonNull<DOMIntersectionObserverEntry>>& entries, DOMIntersectionObserver& observer, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "IntersectionCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, entries, observer, aRv);
  }

  inline void
  Call(const Sequence<OwningNonNull<DOMIntersectionObserverEntry>>& entries, DOMIntersectionObserver& observer, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "IntersectionCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, entries, observer, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const Sequence<OwningNonNull<DOMIntersectionObserverEntry>>& entries, DOMIntersectionObserver& observer, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, entries, observer, rv, aExecutionReason);
  }

  inline void
  Call(const Sequence<OwningNonNull<DOMIntersectionObserverEntry>>& entries, DOMIntersectionObserver& observer, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(entries, observer, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const IntersectionCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, const Sequence<OwningNonNull<DOMIntersectionObserverEntry>>& entries, DOMIntersectionObserver& observer, ErrorResult& aRv);
};


namespace binding_detail {
class FastIntersectionCallback : public IntersectionCallback
{
public:
  explicit inline FastIntersectionCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : IntersectionCallback(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    IntersectionCallback::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    IntersectionCallback::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


namespace IntersectionObserverBinding {

  typedef mozilla::dom::DOMIntersectionObserver NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::DOMIntersectionObserver* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace IntersectionObserverBinding



namespace IntersectionObserverEntryBinding {

  typedef mozilla::dom::DOMIntersectionObserverEntry NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::DOMIntersectionObserverEntry* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace IntersectionObserverEntryBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_IntersectionObserverBinding_h
