/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM ServiceWorkerMessageEvent.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_ServiceWorkerMessageEvent_h
#define mozilla_dom_ServiceWorkerMessageEvent_h

#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/ServiceWorkerMessageEventBinding.h"

struct JSContext;
namespace mozilla {
namespace dom {

class ServiceWorkerMessageEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(ServiceWorkerMessageEvent, Event)
protected:
  virtual ~ServiceWorkerMessageEvent();
  explicit ServiceWorkerMessageEvent(mozilla::dom::EventTarget* aOwner);

  JS::Heap<JS::Value> mData;
  nsString mOrigin;
  nsString mLastEventId;
  Nullable<OwningServiceWorkerOrMessagePort> mSource;
  nsTArray<RefPtr<MessagePort>> mPorts;

public:
  void
  GetData(JS::MutableHandle<JS::Value> aRetVal) const;

  virtual ServiceWorkerMessageEvent* AsServiceWorkerMessageEvent() override;

  virtual JSObject* WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  static already_AddRefed<ServiceWorkerMessageEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const ServiceWorkerMessageEventInit& aEventInitDict);

  static already_AddRefed<ServiceWorkerMessageEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const ServiceWorkerMessageEventInit& aEventInitDict, ErrorResult& aRv);

  void GetData(JSContext* cx, JS::MutableHandle<JS::Value> aRetVal) const;

  void GetOrigin(nsString& aRetVal) const;

  void GetLastEventId(nsString& aRetVal) const;

  void GetSource(Nullable<OwningServiceWorkerOrMessagePort>& aRetVal) const;

  void GetPorts(nsTArray<RefPtr<MessagePort>>& aRetVal) const;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_ServiceWorkerMessageEvent_h
