/* THIS FILE IS AUTOGENERATED FROM MediaStream.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_MediaStreamBinding_h
#define mozilla_dom_MediaStreamBinding_h

#include "MediaStreamTrackBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {

class DOMMediaStream;
struct DOMMediaStreamAtoms;

namespace dom {

class BooleanOrMediaTrackConstraints;
struct MediaStreamConstraintsAtoms;
struct NativePropertyHooks;
class OwningBooleanOrMediaTrackConstraints;
class ProtoAndIfaceCache;

} // namespace dom

} // namespace mozilla

namespace mozilla {
namespace dom {

class BooleanOrMediaTrackConstraints
{
  friend class BooleanOrMediaTrackConstraintsArgument;
  enum Type
  {
    eUninitialized,
    eBoolean,
    eMediaTrackConstraints
  };

  union Value
  {
    UnionMember<bool > mBoolean;
    UnionMember<binding_detail::FastMediaTrackConstraints > mMediaTrackConstraints;

  };

  Type mType;
  Value mValue;

  BooleanOrMediaTrackConstraints(const BooleanOrMediaTrackConstraints&) = delete;
  void operator=(const BooleanOrMediaTrackConstraints&) = delete;
public:
  explicit inline BooleanOrMediaTrackConstraints()
    : mType(eUninitialized)
  {
  }

  inline ~BooleanOrMediaTrackConstraints()
  {
    Uninit();
  }

  inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline binding_detail::FastMediaTrackConstraints&
  RawSetAsMediaTrackConstraints()
  {
    if (mType == eMediaTrackConstraints) {
      return mValue.mMediaTrackConstraints.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMediaTrackConstraints;
    return mValue.mMediaTrackConstraints.SetValue();
  }

  inline binding_detail::FastMediaTrackConstraints&
  SetAsMediaTrackConstraints()
  {
    if (mType == eMediaTrackConstraints) {
      return mValue.mMediaTrackConstraints.Value();
    }
    Uninit();
    mType = eMediaTrackConstraints;
    return mValue.mMediaTrackConstraints.SetValue();
  }

  inline bool
  IsMediaTrackConstraints() const
  {
    return mType == eMediaTrackConstraints;
  }

  inline binding_detail::FastMediaTrackConstraints&
  GetAsMediaTrackConstraints()
  {
    MOZ_ASSERT(IsMediaTrackConstraints(), "Wrong type!");
    return mValue.mMediaTrackConstraints.Value();
  }

  inline const MediaTrackConstraints&
  GetAsMediaTrackConstraints() const
  {
    MOZ_ASSERT(IsMediaTrackConstraints(), "Wrong type!");
    return mValue.mMediaTrackConstraints.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
      case eMediaTrackConstraints: {
        DestroyMediaTrackConstraints();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyBoolean()
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyMediaTrackConstraints()
  {
    MOZ_ASSERT(IsMediaTrackConstraints(), "Wrong type!");
    mValue.mMediaTrackConstraints.Destroy();
    mType = eUninitialized;
  }
};


class OwningBooleanOrMediaTrackConstraints : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningBooleanOrMediaTrackConstraints& aUnion);
  enum Type
  {
    eUninitialized,
    eBoolean,
    eMediaTrackConstraints
  };

  union Value
  {
    UnionMember<bool > mBoolean;
    UnionMember<MediaTrackConstraints > mMediaTrackConstraints;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningBooleanOrMediaTrackConstraints()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningBooleanOrMediaTrackConstraints(const OwningBooleanOrMediaTrackConstraints& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningBooleanOrMediaTrackConstraints()
  {
    Uninit();
  }

  bool&
  RawSetAsBoolean();

  bool&
  SetAsBoolean();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  MediaTrackConstraints&
  RawSetAsMediaTrackConstraints();

  MediaTrackConstraints&
  SetAsMediaTrackConstraints();

  bool
  TrySetToMediaTrackConstraints(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsMediaTrackConstraints() const
  {
    return mType == eMediaTrackConstraints;
  }

  inline MediaTrackConstraints&
  GetAsMediaTrackConstraints()
  {
    MOZ_ASSERT(IsMediaTrackConstraints(), "Wrong type!");
    return mValue.mMediaTrackConstraints.Value();
  }

  inline MediaTrackConstraints const &
  GetAsMediaTrackConstraints() const
  {
    MOZ_ASSERT(IsMediaTrackConstraints(), "Wrong type!");
    return mValue.mMediaTrackConstraints.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningBooleanOrMediaTrackConstraints& aOther);

private:
  void
  DestroyBoolean();

  void
  DestroyMediaTrackConstraints();
};


struct MediaStreamConstraints : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningBooleanOrMediaTrackConstraints mAudio;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mFake;
  MOZ_INIT_OUTSIDE_CTOR nsString mPeerIdentity;
  MOZ_INIT_OUTSIDE_CTOR bool mPicture;
  MOZ_INIT_OUTSIDE_CTOR OwningBooleanOrMediaTrackConstraints mVideo;

  MediaStreamConstraints();

  explicit inline MediaStreamConstraints(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MediaStreamConstraints(const MediaStreamConstraints& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MediaStreamConstraints& aOther);

private:
  static bool
  InitIds(JSContext* cx, MediaStreamConstraintsAtoms* atomsCache);
};

namespace binding_detail {
struct FastMediaStreamConstraints : public MediaStreamConstraints
{
  inline FastMediaStreamConstraints()
    : MediaStreamConstraints(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MediaStreamBinding {

  typedef mozilla::DOMMediaStream NativeType;

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::DOMMediaStream* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace MediaStreamBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_MediaStreamBinding_h
