/* THIS FILE IS AUTOGENERATED FROM AudioContext.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_AudioContextBinding_h
#define mozilla_dom_AudioContextBinding_h

#include "AudioChannelBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"

namespace mozilla {
namespace dom {

class AudioBuffer;
class AudioContext;
struct AudioContextAtoms;
class DOMException;
class DecodeErrorCallback;
class DecodeSuccessCallback;
struct NativePropertyHooks;
struct PeriodicWaveConstraintsAtoms;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class AudioContextState : uint32_t {
  Suspended,
  Running,
  Closed,
  EndGuard_
};

namespace AudioContextStateValues {
extern const EnumEntry strings[4];
} // namespace AudioContextStateValues

bool
ToJSValue(JSContext* aCx, AudioContextState aArgument, JS::MutableHandle<JS::Value> aValue);


struct PeriodicWaveConstraints : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mDisableNormalization;

  PeriodicWaveConstraints();

  explicit inline PeriodicWaveConstraints(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline PeriodicWaveConstraints(const PeriodicWaveConstraints& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const PeriodicWaveConstraints& aOther);

private:
  static bool
  InitIds(JSContext* cx, PeriodicWaveConstraintsAtoms* atomsCache);
};

namespace binding_detail {
struct FastPeriodicWaveConstraints : public PeriodicWaveConstraints
{
  inline FastPeriodicWaveConstraints()
    : PeriodicWaveConstraints(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class DecodeSuccessCallback : public CallbackFunction
{
public:
  explicit inline DecodeSuccessCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline DecodeSuccessCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline DecodeSuccessCallback(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline DecodeSuccessCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, AudioBuffer& decodedData, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "DecodeSuccessCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, decodedData, aRv);
  }

  inline void
  Call(AudioBuffer& decodedData, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "DecodeSuccessCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, decodedData, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, AudioBuffer& decodedData, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, decodedData, rv, aExecutionReason);
  }

  inline void
  Call(AudioBuffer& decodedData, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(decodedData, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const DecodeSuccessCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, AudioBuffer& decodedData, ErrorResult& aRv);
};


class DecodeErrorCallback : public CallbackFunction
{
public:
  explicit inline DecodeErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline DecodeErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline DecodeErrorCallback(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline DecodeErrorCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, DOMException& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "DecodeErrorCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, error, aRv);
  }

  inline void
  Call(DOMException& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "DecodeErrorCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, error, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, DOMException& error, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, error, rv, aExecutionReason);
  }

  inline void
  Call(DOMException& error, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(error, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const DecodeErrorCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, DOMException& error, ErrorResult& aRv);
};


namespace binding_detail {
class FastDecodeSuccessCallback : public DecodeSuccessCallback
{
public:
  explicit inline FastDecodeSuccessCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : DecodeSuccessCallback(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    DecodeSuccessCallback::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    DecodeSuccessCallback::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


namespace binding_detail {
class FastDecodeErrorCallback : public DecodeErrorCallback
{
public:
  explicit inline FastDecodeErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : DecodeErrorCallback(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    DecodeErrorCallback::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    DecodeErrorCallback::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


namespace AudioContextBinding {

  typedef mozilla::dom::AudioContext NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::AudioContext* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace AudioContextBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_AudioContextBinding_h
