/* THIS FILE IS AUTOGENERATED FROM Document.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_DocumentBinding_h
#define mozilla_dom_DocumentBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

class nsIDocument;
struct nsIDocumentAtoms;

namespace mozilla {
namespace dom {

struct ElementCreationOptionsAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class VisibilityState : uint32_t {
  Hidden,
  Visible,
  Prerender,
  EndGuard_
};

namespace VisibilityStateValues {
extern const EnumEntry strings[4];
} // namespace VisibilityStateValues

bool
ToJSValue(JSContext* aCx, VisibilityState aArgument, JS::MutableHandle<JS::Value> aValue);


struct ElementCreationOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mIs;

  ElementCreationOptions();

  explicit inline ElementCreationOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ElementCreationOptions(const ElementCreationOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ElementCreationOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ElementCreationOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastElementCreationOptions : public ElementCreationOptions
{
  inline FastElementCreationOptions()
    : ElementCreationOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class ElementCreationOptionsOrString
{
  friend class ElementCreationOptionsOrStringArgument;
  enum Type
  {
    eUninitialized,
    eElementCreationOptions,
    eString
  };

  union Value
  {
    UnionMember<binding_detail::FastElementCreationOptions > mElementCreationOptions;
    UnionMember<binding_detail::FakeString > mString;

  };

  Type mType;
  Value mValue;

  ElementCreationOptionsOrString(const ElementCreationOptionsOrString&) = delete;
  void operator=(const ElementCreationOptionsOrString&) = delete;
public:
  explicit inline ElementCreationOptionsOrString()
    : mType(eUninitialized)
  {
  }

  inline ~ElementCreationOptionsOrString()
  {
    Uninit();
  }

  inline binding_detail::FastElementCreationOptions&
  RawSetAsElementCreationOptions()
  {
    if (mType == eElementCreationOptions) {
      return mValue.mElementCreationOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eElementCreationOptions;
    return mValue.mElementCreationOptions.SetValue();
  }

  inline binding_detail::FastElementCreationOptions&
  SetAsElementCreationOptions()
  {
    if (mType == eElementCreationOptions) {
      return mValue.mElementCreationOptions.Value();
    }
    Uninit();
    mType = eElementCreationOptions;
    return mValue.mElementCreationOptions.SetValue();
  }

  inline bool
  IsElementCreationOptions() const
  {
    return mType == eElementCreationOptions;
  }

  inline binding_detail::FastElementCreationOptions&
  GetAsElementCreationOptions()
  {
    MOZ_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  inline const ElementCreationOptions&
  GetAsElementCreationOptions() const
  {
    MOZ_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  inline binding_detail::FakeString&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eElementCreationOptions: {
        DestroyElementCreationOptions();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyElementCreationOptions()
  {
    MOZ_ASSERT(IsElementCreationOptions(), "Wrong type!");
    mValue.mElementCreationOptions.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningElementCreationOptionsOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningElementCreationOptionsOrString& aUnion);
  enum Type
  {
    eUninitialized,
    eElementCreationOptions,
    eString
  };

  union Value
  {
    UnionMember<ElementCreationOptions > mElementCreationOptions;
    UnionMember<nsString > mString;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningElementCreationOptionsOrString()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningElementCreationOptionsOrString(const OwningElementCreationOptionsOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningElementCreationOptionsOrString()
  {
    Uninit();
  }

  ElementCreationOptions&
  RawSetAsElementCreationOptions();

  ElementCreationOptions&
  SetAsElementCreationOptions();

  bool
  TrySetToElementCreationOptions(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsElementCreationOptions() const
  {
    return mType == eElementCreationOptions;
  }

  inline ElementCreationOptions&
  GetAsElementCreationOptions()
  {
    MOZ_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  inline ElementCreationOptions const &
  GetAsElementCreationOptions() const
  {
    MOZ_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  SetStringData(const nsString::char_type* aData, nsString::size_type aLength)
  {
    RawSetAsString().Assign(aData, aLength);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningElementCreationOptionsOrString& aOther);

private:
  void
  DestroyElementCreationOptions();

  void
  DestroyString();
};


namespace DocumentBinding {

  typedef nsIDocument NativeType;

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, nsIDocument* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace DocumentBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_DocumentBinding_h
