/**
 * NOTE: This file is a work in progress.
 * Content was generated using a heavily patched TypeScript-DOM-lib-generator.
 *
 * Until this whole process is automated, when changing a WebIDL interface,
 * manually updating this file is *not* required (but doesn't hurt either).
 */

/// <reference no-default-lib="true" />
/// <reference types="gecko" />
/// <reference lib="es2023" />

interface ActivateMenuItemOptions {
    altKey?: boolean;
    button?: number;
    ctrlKey?: boolean;
    metaKey?: boolean;
    shiftKey?: boolean;
}

interface AddEventListenerOptions extends EventListenerOptions {
    once?: boolean;
    passive?: boolean;
    signal?: AbortSignal;
    wantUntrusted?: boolean;
}

interface AddonEventInit extends EventInit {
    id: string;
}

interface AddressErrors {
    addressLine?: string;
    city?: string;
    country?: string;
    dependentLocality?: string;
    organization?: string;
    phone?: string;
    postalCode?: string;
    recipient?: string;
    region?: string;
    regionCode?: string;
    sortingCode?: string;
}

interface AnalyserOptions extends AudioNodeOptions {
    fftSize?: number;
    maxDecibels?: number;
    minDecibels?: number;
    smoothingTimeConstant?: number;
}

interface AnimationEventInit extends EventInit {
    animationName?: string;
    elapsedTime?: number;
    pseudoElement?: string;
}

interface AnimationPlaybackEventInit extends EventInit {
    currentTime?: number | null;
    timelineTime?: number | null;
}

interface AnimationPropertyDetails {
    property: string;
    runningOnCompositor: boolean;
    values: AnimationPropertyValueDetails[];
    warning?: string;
}

interface AnimationPropertyValueDetails {
    composite: CompositeOperation;
    easing?: UTF8String;
    offset: number;
    value?: UTF8String;
}

interface AssignedNodesOptions {
    flatten?: boolean;
}

interface AttributeNameValue {
    name: UTF8String;
    value: UTF8String;
}

interface AudioBufferOptions {
    length: number;
    numberOfChannels?: number;
    sampleRate: number;
}

interface AudioBufferSourceOptions {
    buffer?: AudioBuffer | null;
    detune?: number;
    loop?: boolean;
    loopEnd?: number;
    loopStart?: number;
    playbackRate?: number;
}

interface AudioConfiguration {
    bitrate?: number;
    channels?: string;
    contentType: string;
    samplerate?: number;
}

interface AudioContextOptions {
    sampleRate?: number;
}

interface AudioNodeOptions {
    channelCount?: number;
    channelCountMode?: ChannelCountMode;
    channelInterpretation?: ChannelInterpretation;
}

interface AudioOutputOptions {
    deviceId?: string;
}

interface AudioSinkDebugInfo {
    audioEnded?: boolean;
    hasErrored?: boolean;
    isPlaying?: boolean;
    isStarted?: boolean;
    lastGoodPosition?: number;
    outputRate?: number;
    playbackComplete?: boolean;
    startTime?: number;
    written?: number;
}

interface AudioSinkWrapperDebugInfo {
    audioEnded?: boolean;
    audioSink?: AudioSinkDebugInfo;
    isPlaying?: boolean;
    isStarted?: boolean;
}

interface AudioTimestamp {
    contextTime?: number;
    performanceTime?: DOMHighResTimeStamp;
}

interface AudioWorkletNodeOptions extends AudioNodeOptions {
    numberOfInputs?: number;
    numberOfOutputs?: number;
    outputChannelCount?: number[];
    parameterData?: Record<string, number>;
    processorOptions?: any;
}

interface AuthenticationExtensionsClientInputs {
    appid?: string;
    credProps?: boolean;
    hmacCreateSecret?: boolean;
    minPinLength?: boolean;
}

interface AuthenticationExtensionsClientInputsJSON {
    appid?: string;
    credProps?: boolean;
    hmacCreateSecret?: boolean;
    minPinLength?: boolean;
}

interface AuthenticationExtensionsClientOutputs {
    appid?: boolean;
    credProps?: CredentialPropertiesOutput;
    hmacCreateSecret?: boolean;
}

interface AuthenticatorSelectionCriteria {
    authenticatorAttachment?: string;
    requireResidentKey?: boolean;
    residentKey?: string;
    userVerification?: string;
}

interface AutocompleteInfo {
    addressType?: string;
    canAutomaticallyPersist?: boolean;
    contactType?: string;
    credentialType?: string;
    fieldName?: string;
    section?: string;
}

interface AvcEncoderConfig {
    format?: AvcBitstreamFormat;
}

interface Base64URLDecodeOptions {
    padding: Base64URLDecodePadding;
}

interface Base64URLEncodeOptions {
    pad: boolean;
}

interface BiquadFilterOptions extends AudioNodeOptions {
    Q?: number;
    detune?: number;
    frequency?: number;
    gain?: number;
    type?: BiquadFilterType;
}

interface BlobEventInit extends EventInit {
    data: Blob;
}

interface BlobPropertyBag {
    endings?: EndingType;
    type?: string;
}

interface BlockParsingOptions {
    blockScriptCreated?: boolean;
}

interface BoxQuadOptions {
    box?: CSSBoxType;
    createFramesForSuppressedWhitespace?: boolean;
    relativeTo?: GeometryNode;
}

interface BufferRange {
    end?: number;
    start?: number;
}

interface CDMInformation {
    capabilities: string;
    clearlead: boolean;
    keySystemName: string;
}

interface CSSStyleSheetInit {
    baseURL?: UTF8String;
    disabled?: boolean;
    media?: MediaList | UTF8String;
}

interface CacheQueryOptions {
    ignoreMethod?: boolean;
    ignoreSearch?: boolean;
    ignoreVary?: boolean;
}

interface CanvasRenderingContext2DSettings {
    alpha?: boolean;
    colorSpace?: PredefinedColorSpace;
    desynchronized?: boolean;
    willReadFrequently?: boolean;
}

interface CaretStateChangedEventInit extends EventInit {
    boundingClientRect?: DOMRectReadOnly | null;
    caretVisible?: boolean;
    caretVisuallyVisible?: boolean;
    clientX?: number;
    clientY?: number;
    collapsed?: boolean;
    reason?: CaretChangedReason;
    selectedTextContent?: string;
    selectionEditable?: boolean;
    selectionVisible?: boolean;
}

interface ChannelMergerOptions extends AudioNodeOptions {
    numberOfInputs?: number;
}

interface ChannelSplitterOptions extends AudioNodeOptions {
    numberOfOutputs?: number;
}

interface CheckVisibilityOptions {
    checkOpacity?: boolean;
    checkVisibilityCSS?: boolean;
    contentVisibilityAuto?: boolean;
    flush?: boolean;
    opacityProperty?: boolean;
    visibilityProperty?: boolean;
}

interface CheckerboardReport {
    log?: string;
    reason?: CheckerboardReason;
    severity?: number;
    timestamp?: DOMTimeStamp;
}

interface ChildProcInfoDictionary {
    childID?: number;
    cpuCycleCount?: number;
    cpuTime?: number;
    memory?: number;
    origin?: UTF8String;
    pid?: number;
    threads?: ThreadInfoDictionary[];
    type?: WebIDLProcType;
    utilityActors?: UtilityActorsDictionary[];
    windows?: WindowInfoDictionary[];
}

interface ChromeFilePropertyBag extends FilePropertyBag {
    existenceCheck?: boolean;
    name?: string;
}

interface ClientQueryOptions {
    includeUncontrolled?: boolean;
    type?: ClientType;
}

interface ClientRectsAndTexts {
    rectList: DOMRectList;
    textList: string[];
}

interface ClipboardEventInit extends EventInit {
    data?: string;
    dataType?: string;
}

interface ClipboardItemOptions {
    presentationStyle?: PresentationStyle;
}

interface CloseEventInit extends EventInit {
    code?: number;
    reason?: string;
    wasClean?: boolean;
}

interface CollectedData {
    children?: any[];
    id?: Record<string, CollectedFormDataValue>;
    innerHTML?: string;
    scroll?: string;
    url?: string;
    xpath?: Record<string, CollectedFormDataValue>;
}

interface CompileScriptOptionsDictionary {
    charset?: string;
    hasReturnValue?: boolean;
    lazilyParse?: boolean;
}

interface CompositionEventInit extends UIEventInit {
    data?: string;
}

interface ComputedEffectTiming extends EffectTiming {
    activeDuration?: number;
    currentIteration?: number | null;
    endTime?: number;
    localTime?: number | null;
    progress?: number | null;
}

interface ConsoleInstanceOptions {
    consoleID?: string;
    dump?: ConsoleInstanceDumpCallback;
    innerID?: string;
    maxLogLevel?: ConsoleLogLevel;
    maxLogLevelPref?: string;
    prefix?: string;
}

interface ConstantSourceOptions {
    offset?: number;
}

interface ConstrainBooleanParameters {
    exact?: boolean;
    ideal?: boolean;
}

interface ConstrainDOMStringParameters {
    exact?: string | string[];
    ideal?: string | string[];
}

interface ConstrainDoubleRange {
    exact?: number;
    ideal?: number;
    max?: number;
    min?: number;
}

interface ConstrainLongRange {
    exact?: number;
    ideal?: number;
    max?: number;
    min?: number;
}

interface ContentVisibilityAutoStateChangeEventInit extends EventInit {
    skipped?: boolean;
}

interface ConvertCoordinateOptions {
    fromBox?: CSSBoxType;
    toBox?: CSSBoxType;
}

interface ConvolverOptions extends AudioNodeOptions {
    buffer?: AudioBuffer | null;
    disableNormalization?: boolean;
}

interface CopyOptions {
    noOverwrite?: boolean;
    recursive?: boolean;
}

interface CredentialCreationOptions {
    publicKey?: PublicKeyCredentialCreationOptions;
    signal?: AbortSignal;
}

interface CredentialPropertiesOutput {
    rk?: boolean;
}

interface CredentialRequestOptions {
    identity?: IdentityCredentialRequestOptions;
    mediation?: CredentialMediationRequirement;
    publicKey?: PublicKeyCredentialRequestOptions;
    signal?: AbortSignal;
}

interface CustomEventInit extends EventInit {
    detail?: any;
}

interface DOMMatrix2DInit {
    a?: number;
    b?: number;
    c?: number;
    d?: number;
    e?: number;
    f?: number;
    m11?: number;
    m12?: number;
    m21?: number;
    m22?: number;
    m41?: number;
    m42?: number;
}

interface DOMMatrixInit extends DOMMatrix2DInit {
    is2D?: boolean;
    m13?: number;
    m14?: number;
    m23?: number;
    m24?: number;
    m31?: number;
    m32?: number;
    m33?: number;
    m34?: number;
    m43?: number;
    m44?: number;
}

interface DOMPointInit {
    w?: number;
    x?: number;
    y?: number;
    z?: number;
}

interface DOMQuadInit {
    p1?: DOMPointInit;
    p2?: DOMPointInit;
    p3?: DOMPointInit;
    p4?: DOMPointInit;
}

interface DOMRectInit {
    height?: number;
    width?: number;
    x?: number;
    y?: number;
}

interface DateTimeValue {
    day?: number;
    hour?: number;
    minute?: number;
    month?: number;
    year?: number;
}

interface DecodedStreamDataDebugInfo {
    audioFramesWritten?: number;
    haveSentFinishAudio?: boolean;
    haveSentFinishVideo?: boolean;
    instance?: string;
    lastVideoEndTime?: number;
    lastVideoStartTime?: number;
    nextAudioTime?: number;
    streamAudioWritten?: number;
    streamVideoWritten?: number;
}

interface DecodedStreamDebugInfo {
    audioQueueFinished?: boolean;
    audioQueueSize?: number;
    data?: DecodedStreamDataDebugInfo;
    instance?: string;
    lastAudio?: number;
    lastOutputTime?: number;
    playing?: number;
    startTime?: number;
}

interface DelayOptions extends AudioNodeOptions {
    delayTime?: number;
    maxDelayTime?: number;
}

interface DeviceAccelerationInit {
    x?: number | null;
    y?: number | null;
    z?: number | null;
}

interface DeviceLightEventInit extends EventInit {
    value?: number;
}

interface DeviceMotionEventInit extends EventInit {
    acceleration?: DeviceAccelerationInit;
    accelerationIncludingGravity?: DeviceAccelerationInit;
    interval?: number | null;
    rotationRate?: DeviceRotationRateInit;
}

interface DeviceOrientationEventInit extends EventInit {
    absolute?: boolean;
    alpha?: number | null;
    beta?: number | null;
    gamma?: number | null;
}

interface DeviceRotationRateInit {
    alpha?: number | null;
    beta?: number | null;
    gamma?: number | null;
}

interface DictWithAllowSharedBufferSource {
    allowSharedArrayBuffer?: ArrayBuffer;
    allowSharedArrayBufferView?: ArrayBufferView;
    arrayBuffer?: ArrayBuffer;
    arrayBufferView?: ArrayBufferView;
}

interface DisplayMediaStreamConstraints {
    audio?: boolean | MediaTrackConstraints;
    video?: boolean | MediaTrackConstraints;
}

interface DisplayNameOptions {
    calendar?: string;
    keys?: string[];
    style?: string;
    type?: string;
}

interface DisplayNameResult {
    calendar?: string;
    locale?: string;
    style?: string;
    type?: string;
    values?: string[];
}

interface DocumentTimelineOptions {
    originTime?: DOMHighResTimeStamp;
}

interface DragEventInit extends MouseEventInit {
    dataTransfer?: DataTransfer | null;
}

interface DynamicsCompressorOptions extends AudioNodeOptions {
    attack?: number;
    knee?: number;
    ratio?: number;
    release?: number;
    threshold?: number;
}

interface EMEDebugInfo {
    keySystem?: string;
    sessionsInfo?: string;
}

interface EffectTiming {
    delay?: number;
    direction?: PlaybackDirection;
    duration?: number | string;
    easing?: UTF8String;
    endDelay?: number;
    fill?: FillMode;
    iterationStart?: number;
    iterations?: number;
}

interface ElementCreationOptions {
    is?: string;
    pseudo?: string;
}

interface ElementDefinitionOptions {
    extends?: string;
}

interface EncodedVideoChunkInit {
    data: ArrayBufferView | ArrayBuffer;
    duration?: number;
    timestamp: number;
    type: EncodedVideoChunkType;
}

interface EncodedVideoChunkMetadata {
    decoderConfig?: VideoDecoderConfig;
    svc?: SvcOutputMetadata;
}

interface ErrorEventInit extends EventInit {
    colno?: number;
    error?: any;
    filename?: string;
    lineno?: number;
    message?: string;
}

interface EventInit {
    bubbles?: boolean;
    cancelable?: boolean;
    composed?: boolean;
}

interface EventListenerOptions {
    capture?: boolean;
    mozSystemGroup?: boolean;
}

interface EventModifierInit extends UIEventInit {
    altKey?: boolean;
    ctrlKey?: boolean;
    metaKey?: boolean;
    modifierAltGraph?: boolean;
    modifierCapsLock?: boolean;
    modifierFn?: boolean;
    modifierFnLock?: boolean;
    modifierNumLock?: boolean;
    modifierOS?: boolean;
    modifierScrollLock?: boolean;
    modifierSymbol?: boolean;
    modifierSymbolLock?: boolean;
    shiftKey?: boolean;
}

interface EventSourceInit {
    withCredentials?: boolean;
}

interface ExecuteInGlobalOptions {
    reportExceptions?: boolean;
}

interface ExtendableEventInit extends EventInit {
}

interface ExtendableMessageEventInit extends ExtendableEventInit {
    data?: any;
    lastEventId?: string;
    origin?: string;
    ports?: MessagePort[];
    source?: Client | ServiceWorker | MessagePort | null;
}

interface FailedCertSecurityInfo {
    certChainStrings?: string[];
    certValidityRangeNotAfter?: DOMTimeStamp;
    certValidityRangeNotBefore?: DOMTimeStamp;
    errorCodeString?: string;
    errorMessage?: string;
    hasHPKP?: boolean;
    hasHSTS?: boolean;
    issuerCommonName?: string;
    overridableErrorCategory?: OverridableErrorCategory;
    validNotAfter?: DOMTimeStamp;
    validNotBefore?: DOMTimeStamp;
}

interface FdMapping {
    dst: number;
    src: number;
}

interface FetchEventInit extends EventInit {
    clientId?: string;
    request: Request;
    resultingClientId?: string;
}

interface FileInfo {
    creationTime?: number;
    lastAccessed?: number;
    lastModified?: number;
    path?: string;
    permissions?: number;
    size?: number;
    type?: FileType;
}

interface FilePropertyBag extends BlobPropertyBag {
    lastModified?: number;
}

interface FileSourceOptions {
    addResourceOptions?: FluentBundleAddResourceOptions;
}

interface FileSystemCreateWritableOptions {
    keepExistingData?: boolean;
}

interface FileSystemFlags {
    create?: boolean;
    exclusive?: boolean;
}

interface FileSystemGetDirectoryOptions {
    create?: boolean;
}

interface FileSystemGetFileOptions {
    create?: boolean;
}

interface FileSystemReadWriteOptions {
    at?: number;
}

interface FileSystemRemoveOptions {
    recursive?: boolean;
}

interface FluentBundleAddResourceOptions {
    allowOverrides?: boolean;
}

interface FluentBundleIteratorResult {
    done: boolean;
    value: FluentBundle | null;
}

interface FluentBundleOptions {
    pseudoStrategy?: UTF8String;
    useIsolating?: boolean;
}

interface FluentMessage {
    attributes: Record<UTF8String, FluentPattern>;
    value?: FluentPattern | null;
}

interface FluentTextElementItem {
    attr?: UTF8String;
    id?: UTF8String;
    text?: UTF8String;
}

interface FocusEventInit extends UIEventInit {
    relatedTarget?: EventTarget | null;
}

interface FocusOptions {
    focusVisible?: boolean;
    preventScroll?: boolean;
}

interface FontFaceDescriptors {
    ascentOverride?: UTF8String;
    descentOverride?: UTF8String;
    display?: UTF8String;
    featureSettings?: UTF8String;
    lineGapOverride?: UTF8String;
    sizeAdjust?: UTF8String;
    stretch?: UTF8String;
    style?: UTF8String;
    unicodeRange?: UTF8String;
    variant?: UTF8String;
    variationSettings?: UTF8String;
    weight?: UTF8String;
}

interface FontFaceSetIteratorResult {
    done: boolean;
    value: any;
}

interface FontFaceSetLoadEventInit extends EventInit {
    fontfaces?: FontFace[];
}

interface FormAutofillConfidences {
    ccName?: number;
    ccNumber?: number;
}

interface FormDataEventInit extends EventInit {
    formData: FormData;
}

interface FrameCrashedEventInit extends EventInit {
    browsingContextId?: number;
    childID?: number;
    isTopFrame?: boolean;
}

interface GPUBindGroupDescriptor extends GPUObjectDescriptorBase {
    entries: GPUBindGroupEntry[];
    layout: GPUBindGroupLayout;
}

interface GPUBindGroupEntry {
    binding: GPUIndex32;
    resource: GPUBindingResource;
}

interface GPUBindGroupLayoutDescriptor extends GPUObjectDescriptorBase {
    entries: GPUBindGroupLayoutEntry[];
}

interface GPUBindGroupLayoutEntry {
    binding: GPUIndex32;
    buffer?: GPUBufferBindingLayout;
    sampler?: GPUSamplerBindingLayout;
    storageTexture?: GPUStorageTextureBindingLayout;
    texture?: GPUTextureBindingLayout;
    visibility: GPUShaderStageFlags;
}

interface GPUBlendComponent {
    dstFactor?: GPUBlendFactor;
    operation?: GPUBlendOperation;
    srcFactor?: GPUBlendFactor;
}

interface GPUBlendState {
    alpha: GPUBlendComponent;
    color: GPUBlendComponent;
}

interface GPUBufferBinding {
    buffer: GPUBuffer;
    offset?: GPUSize64;
    size?: GPUSize64;
}

interface GPUBufferBindingLayout {
    hasDynamicOffset?: boolean;
    minBindingSize?: GPUSize64;
    type?: GPUBufferBindingType;
}

interface GPUBufferDescriptor extends GPUObjectDescriptorBase {
    mappedAtCreation?: boolean;
    size: GPUSize64;
    usage: GPUBufferUsageFlags;
}

interface GPUCanvasConfiguration {
    alphaMode?: GPUCanvasAlphaMode;
    device: GPUDevice;
    format: GPUTextureFormat;
    usage?: GPUTextureUsageFlags;
    viewFormats?: GPUTextureFormat[];
}

interface GPUColorDict {
    a: number;
    b: number;
    g: number;
    r: number;
}

interface GPUColorTargetState {
    blend?: GPUBlendState;
    format: GPUTextureFormat;
    writeMask?: GPUColorWriteFlags;
}

interface GPUCommandBufferDescriptor extends GPUObjectDescriptorBase {
}

interface GPUCommandEncoderDescriptor extends GPUObjectDescriptorBase {
}

interface GPUComputePassDescriptor extends GPUObjectDescriptorBase {
}

interface GPUComputePipelineDescriptor extends GPUPipelineDescriptorBase {
    compute: GPUProgrammableStage;
}

interface GPUDepthStencilState {
    depthBias?: GPUDepthBias;
    depthBiasClamp?: number;
    depthBiasSlopeScale?: number;
    depthCompare?: GPUCompareFunction;
    depthWriteEnabled?: boolean;
    format: GPUTextureFormat;
    stencilBack?: GPUStencilFaceState;
    stencilFront?: GPUStencilFaceState;
    stencilReadMask?: GPUStencilValue;
    stencilWriteMask?: GPUStencilValue;
}

interface GPUDeviceDescriptor extends GPUObjectDescriptorBase {
    defaultQueue?: GPUQueueDescriptor;
    requiredFeatures?: GPUFeatureName[];
    requiredLimits?: Record<string, GPUSize64>;
}

interface GPUExtent3DDict {
    depthOrArrayLayers?: GPUIntegerCoordinate;
    height?: GPUIntegerCoordinate;
    width: GPUIntegerCoordinate;
}

interface GPUFragmentState extends GPUProgrammableStage {
    targets: GPUColorTargetState[];
}

interface GPUImageCopyBuffer extends GPUImageDataLayout {
    buffer: GPUBuffer;
}

interface GPUImageCopyExternalImage {
    flipY?: boolean;
    origin?: GPUOrigin2D;
    source: ImageBitmap | HTMLCanvasElement | OffscreenCanvas;
}

interface GPUImageCopyTexture {
    aspect?: GPUTextureAspect;
    mipLevel?: GPUIntegerCoordinate;
    origin?: GPUOrigin3D;
    texture: GPUTexture;
}

interface GPUImageCopyTextureTagged extends GPUImageCopyTexture {
    premultipliedAlpha?: boolean;
}

interface GPUImageDataLayout {
    bytesPerRow?: GPUSize32;
    offset?: GPUSize64;
    rowsPerImage?: GPUSize32;
}

interface GPUMultisampleState {
    alphaToCoverageEnabled?: boolean;
    count?: GPUSize32;
    mask?: GPUSampleMask;
}

interface GPUObjectDescriptorBase {
    label?: string;
}

interface GPUOrigin2DDict {
    x?: GPUIntegerCoordinate;
    y?: GPUIntegerCoordinate;
}

interface GPUOrigin3DDict {
    x?: GPUIntegerCoordinate;
    y?: GPUIntegerCoordinate;
    z?: GPUIntegerCoordinate;
}

interface GPUPipelineDescriptorBase extends GPUObjectDescriptorBase {
    layout: GPUPipelineLayout | GPUAutoLayoutMode;
}

interface GPUPipelineLayoutDescriptor extends GPUObjectDescriptorBase {
    bindGroupLayouts: GPUBindGroupLayout[];
}

interface GPUPrimitiveState {
    cullMode?: GPUCullMode;
    frontFace?: GPUFrontFace;
    stripIndexFormat?: GPUIndexFormat;
    topology?: GPUPrimitiveTopology;
    unclippedDepth?: boolean;
}

interface GPUProgrammableStage {
    entryPoint: string;
    module: GPUShaderModule;
}

interface GPUQueueDescriptor extends GPUObjectDescriptorBase {
}

interface GPURenderBundleDescriptor extends GPUObjectDescriptorBase {
}

interface GPURenderBundleEncoderDescriptor extends GPURenderPassLayout {
    depthReadOnly?: boolean;
    stencilReadOnly?: boolean;
}

interface GPURenderPassColorAttachment {
    clearValue?: GPUColor;
    loadOp: GPULoadOp;
    resolveTarget?: GPUTextureView;
    storeOp: GPUStoreOp;
    view: GPUTextureView;
}

interface GPURenderPassDepthStencilAttachment {
    depthClearValue?: number;
    depthLoadOp?: GPULoadOp;
    depthReadOnly?: boolean;
    depthStoreOp?: GPUStoreOp;
    stencilClearValue?: GPUStencilValue;
    stencilLoadOp?: GPULoadOp;
    stencilReadOnly?: boolean;
    stencilStoreOp?: GPUStoreOp;
    view: GPUTextureView;
}

interface GPURenderPassDescriptor extends GPUObjectDescriptorBase {
    colorAttachments: GPURenderPassColorAttachment[];
    depthStencilAttachment?: GPURenderPassDepthStencilAttachment;
    occlusionQuerySet?: GPUQuerySet;
}

interface GPURenderPassLayout extends GPUObjectDescriptorBase {
    colorFormats: GPUTextureFormat[];
    depthStencilFormat?: GPUTextureFormat;
    sampleCount?: GPUSize32;
}

interface GPURenderPipelineDescriptor extends GPUPipelineDescriptorBase {
    depthStencil?: GPUDepthStencilState;
    fragment?: GPUFragmentState;
    multisample?: GPUMultisampleState;
    primitive?: GPUPrimitiveState;
    vertex: GPUVertexState;
}

interface GPURequestAdapterOptions {
    forceFallbackAdapter?: boolean;
    powerPreference?: GPUPowerPreference;
}

interface GPUSamplerBindingLayout {
    type?: GPUSamplerBindingType;
}

interface GPUSamplerDescriptor extends GPUObjectDescriptorBase {
    addressModeU?: GPUAddressMode;
    addressModeV?: GPUAddressMode;
    addressModeW?: GPUAddressMode;
    compare?: GPUCompareFunction;
    lodMaxClamp?: number;
    lodMinClamp?: number;
    magFilter?: GPUFilterMode;
    maxAnisotropy?: number;
    minFilter?: GPUFilterMode;
    mipmapFilter?: GPUMipmapFilterMode;
}

interface GPUShaderModuleDescriptor extends GPUObjectDescriptorBase {
    code: UTF8String;
    sourceMap?: any;
}

interface GPUStencilFaceState {
    compare?: GPUCompareFunction;
    depthFailOp?: GPUStencilOperation;
    failOp?: GPUStencilOperation;
    passOp?: GPUStencilOperation;
}

interface GPUStorageTextureBindingLayout {
    access?: GPUStorageTextureAccess;
    format: GPUTextureFormat;
    viewDimension?: GPUTextureViewDimension;
}

interface GPUTextureBindingLayout {
    multisampled?: boolean;
    sampleType?: GPUTextureSampleType;
    viewDimension?: GPUTextureViewDimension;
}

interface GPUTextureDescriptor extends GPUObjectDescriptorBase {
    dimension?: GPUTextureDimension;
    format: GPUTextureFormat;
    mipLevelCount?: GPUIntegerCoordinate;
    sampleCount?: GPUSize32;
    size: GPUExtent3D;
    usage: GPUTextureUsageFlags;
    viewFormats?: GPUTextureFormat[];
}

interface GPUTextureViewDescriptor extends GPUObjectDescriptorBase {
    arrayLayerCount?: GPUIntegerCoordinate;
    aspect?: GPUTextureAspect;
    baseArrayLayer?: GPUIntegerCoordinate;
    baseMipLevel?: GPUIntegerCoordinate;
    dimension?: GPUTextureViewDimension;
    format?: GPUTextureFormat;
    mipLevelCount?: GPUIntegerCoordinate;
}

interface GPUUncapturedErrorEventInit extends EventInit {
    error: GPUError;
}

interface GPUVertexAttribute {
    format: GPUVertexFormat;
    offset: GPUSize64;
    shaderLocation: GPUIndex32;
}

interface GPUVertexBufferLayout {
    arrayStride: GPUSize64;
    attributes: GPUVertexAttribute[];
    stepMode?: GPUVertexStepMode;
}

interface GPUVertexState extends GPUProgrammableStage {
    buffers?: (GPUVertexBufferLayout | null)[];
}

interface GainOptions extends AudioNodeOptions {
    gain?: number;
}

interface GamepadAxisMoveEventInit extends GamepadEventInit {
    axis?: number;
    value?: number;
}

interface GamepadButtonEventInit extends GamepadEventInit {
    button?: number;
}

interface GamepadEventInit extends EventInit {
    gamepad?: Gamepad | null;
}

interface GamepadLightColor {
    blue: number;
    green: number;
    red: number;
}

interface GetAnimationsOptions {
    subtree?: boolean;
}

interface GetChildrenOptions {
    ignoreAbsent?: boolean;
}

interface GetNotificationOptions {
    tag?: string;
}

interface GetRootNodeOptions {
    composed?: boolean;
}

interface GleanDistributionData {
    sum: number;
    values: Record<UTF8String, number>;
}

interface GleanEventRecord {
    category: UTF8String;
    extra?: Record<UTF8String, UTF8String>;
    name: UTF8String;
    timestamp: number;
}

interface GleanRateData {
    denominator: number;
    numerator: number;
}

interface HTMLMediaElementDebugInfo {
    EMEInfo?: EMEDebugInfo;
    compositorDroppedFrames?: number;
    decoder?: MediaDecoderDebugInfo;
}

interface HashChangeEventInit extends EventInit {
    newURL?: string;
    oldURL?: string;
}

interface HeapSnapshotBoundaries {
    debugger?: any;
    globals?: any[];
    runtime?: boolean;
}

interface IDBIndexParameters {
    locale?: string | null;
    multiEntry?: boolean;
    unique?: boolean;
}

interface IDBObjectStoreParameters {
    autoIncrement?: boolean;
    keyPath?: string | string[] | null;
}

interface IDBOpenDBOptions {
    version?: number;
}

interface IDBVersionChangeEventInit extends EventInit {
    newVersion?: number | null;
    oldVersion?: number;
}

interface IIRFilterOptions extends AudioNodeOptions {
    feedback: number[];
    feedforward: number[];
}

interface IOActivityDataDictionary {
    location?: string;
    rx?: number;
    tx?: number;
}

interface IdentityCredentialLogoutRPsRequest {
    accountId: UTF8String;
    url: UTF8String;
}

interface IdentityCredentialRequestOptions {
    providers?: IdentityProviderConfig[];
}

interface IdentityProviderConfig {
    clientId: string;
    configURL: UTF8String;
    nonce?: string;
}

interface IdleRequestOptions {
    timeout?: number;
}

interface ImageBitmapOptions {
    colorSpaceConversion?: ColorSpaceConversion;
    imageOrientation?: ImageOrientation;
    premultiplyAlpha?: PremultiplyAlpha;
    resizeHeight?: number;
    resizeWidth?: number;
}

interface ImageCaptureErrorEventInit extends EventInit {
    imageCaptureError?: ImageCaptureError | null;
}

interface ImageEncodeOptions {
    quality?: number;
    type?: string;
}

interface ImageText {
    confidence: number;
    quad: DOMQuad;
    string: string;
}

interface ImportESModuleOptionsDictionary {
    loadInDevToolsLoader?: boolean;
}

interface InputEventInit extends UIEventInit {
    data?: string | null;
    dataTransfer?: DataTransfer | null;
    inputType?: string;
    isComposing?: boolean;
    targetRanges?: StaticRange[];
}

interface InspectorCSSPropertyDefinition {
    fromJS: boolean;
    inherits: boolean;
    initialValue: UTF8String | null;
    name: UTF8String;
    syntax: UTF8String;
}

interface InspectorFontFeature {
    languageSystem: string;
    script: string;
    tag: string;
}

interface InspectorRGBATuple {
    a?: number;
    b?: number;
    g?: number;
    r?: number;
}

interface InspectorVariationAxis {
    defaultValue: number;
    maxValue: number;
    minValue: number;
    name: string;
    tag: string;
}

interface InspectorVariationInstance {
    name: string;
    values: InspectorVariationValue[];
}

interface InspectorVariationValue {
    axis: string;
    value: number;
}

interface InstallTriggerData {
    Hash?: string | null;
    IconURL?: string | null;
    URL?: string;
}

interface InteractionData {
    interactionCount?: number;
    interactionTimeInMilliseconds?: number;
    scrollingDistanceInPixels?: number;
}

interface IntersectionObserverInit {
    root?: Element | Document | null;
    rootMargin?: UTF8String;
    threshold?: number | number[];
}

interface InvokeEventInit extends EventInit {
    action?: string;
    invoker?: Element | null;
}

interface KeyboardEventInit extends EventModifierInit {
    charCode?: number;
    code?: string;
    isComposing?: boolean;
    key?: string;
    keyCode?: number;
    location?: number;
    repeat?: boolean;
    which?: number;
}

interface KeyframeAnimationOptions extends KeyframeEffectOptions {
    id?: string;
}

interface KeyframeEffectOptions extends EffectTiming {
    composite?: CompositeOperation;
    iterationComposite?: IterationCompositeOperation;
    pseudoElement?: string | null;
}

interface L10nFileSourceMockFile {
    path: UTF8String;
    source: UTF8String;
}

interface L10nIdArgs {
    args?: L10nArgs | null;
    id?: UTF8String | null;
}

interface L10nMessage {
    attributes?: AttributeNameValue[] | null;
    value?: UTF8String | null;
}

interface L10nOverlaysError {
    code?: number;
    l10nName?: string;
    sourceElementName?: string;
    translatedElementName?: string;
}

interface L10nRegistryOptions {
    bundleOptions?: FluentBundleOptions;
}

interface LaunchOptions {
    disclaim?: boolean;
    environment: UnixString[];
    fdMap?: FdMapping[];
    workdir?: UnixString;
}

interface LibcConstants {
    AT_EACCESS?: number;
    EACCES?: number;
    EAGAIN?: number;
    EINTR?: number;
    EINVAL?: number;
    ENOSYS?: number;
    FD_CLOEXEC?: number;
    F_SETFD?: number;
    F_SETFL?: number;
    O_CREAT?: number;
    O_NONBLOCK?: number;
    O_WRONLY?: number;
    POLLERR?: number;
    POLLHUP?: number;
    POLLIN?: number;
    POLLNVAL?: number;
    POLLOUT?: number;
    PR_CAPBSET_READ?: number;
    WNOHANG?: number;
}

interface LoadURIOptions {
    baseURI?: URI | null;
    cancelContentJSEpoch?: number;
    csp?: ContentSecurityPolicy | null;
    hasValidUserGestureActivation?: boolean;
    headers?: InputStream | null;
    loadFlags?: number;
    postData?: InputStream | null;
    referrerInfo?: ReferrerInfo | null;
    remoteTypeOverride?: UTF8String | null;
    triggeringPrincipal?: Principal | null;
    triggeringRemoteType?: UTF8String | null;
    triggeringSandboxFlags?: number;
    triggeringStorageAccess?: boolean;
    triggeringWindowId?: number;
    wasSchemelessInput?: boolean;
}

interface LockInfo {
    clientId?: string;
    mode?: LockMode;
    name?: string;
}

interface LockManagerSnapshot {
    held?: LockInfo[];
    pending?: LockInfo[];
}

interface LockOptions {
    ifAvailable?: boolean;
    mode?: LockMode;
    signal?: AbortSignal;
    steal?: boolean;
}

interface MIDIConnectionEventInit extends EventInit {
    port?: MIDIPort | null;
}

interface MIDIMessageEventInit extends EventInit {
    data?: Uint8Array;
}

interface MIDIOptions {
    software?: boolean;
    sysex?: boolean;
}

interface MakeDirectoryOptions {
    createAncestors?: boolean;
    ignoreExisting?: boolean;
    permissions?: number;
}

interface MatchPatternOptions {
    ignorePath?: boolean;
    restrictSchemes?: boolean;
}

interface MediaCacheStreamDebugInfo {
    cacheSuspended?: boolean;
    channelEnded?: boolean;
    channelOffset?: number;
    loadID?: number;
    streamLength?: number;
}

interface MediaConfiguration {
    audio?: AudioConfiguration;
    video?: VideoConfiguration;
}

interface MediaDecoderDebugInfo {
    PlayState?: string;
    channels?: number;
    containerType?: string;
    hasAudio?: boolean;
    hasVideo?: boolean;
    instance?: string;
    rate?: number;
    reader?: MediaFormatReaderDebugInfo;
    resource?: MediaResourceDebugInfo;
    stateMachine?: MediaDecoderStateMachineDebugInfo;
}

interface MediaDecoderStateMachineDebugInfo {
    audioCompleted?: boolean;
    audioRequestStatus?: string;
    clock?: number;
    decodedAudioEndTime?: number;
    decodedVideoEndTime?: number;
    duration?: number;
    isPlaying?: boolean;
    mediaSink?: MediaSinkDebugInfo;
    mediaTime?: number;
    playState?: number;
    sentFirstFrameLoadedEvent?: boolean;
    state?: string;
    stateObj?: MediaDecoderStateMachineDecodingStateDebugInfo;
    videoCompleted?: boolean;
    videoRequestStatus?: string;
}

interface MediaDecoderStateMachineDecodingStateDebugInfo {
    isPrerolling?: boolean;
}

interface MediaDecodingConfiguration extends MediaConfiguration {
    type: MediaDecodingType;
}

interface MediaElementAudioSourceOptions {
    mediaElement: HTMLMediaElement;
}

interface MediaEncodingConfiguration extends MediaConfiguration {
    type: MediaEncodingType;
}

interface MediaFormatReaderDebugInfo {
    audioChannels?: number;
    audioDecoderName?: string;
    audioFramesDecoded?: number;
    audioRate?: number;
    audioState?: MediaStateDebugInfo;
    audioType?: string;
    frameStats?: MediaFrameStats;
    videoDecoderName?: string;
    videoHardwareAccelerated?: boolean;
    videoHeight?: number;
    videoNumSamplesOutputTotal?: number;
    videoNumSamplesSkippedTotal?: number;
    videoRate?: number;
    videoState?: MediaStateDebugInfo;
    videoType?: string;
    videoWidth?: number;
}

interface MediaFrameStats {
    droppedCompositorFrames?: number;
    droppedDecodedFrames?: number;
    droppedSinkFrames?: number;
}

interface MediaImage {
    sizes?: string;
    src: string;
    type?: string;
}

interface MediaKeyMessageEventInit extends EventInit {
    message: ArrayBuffer;
    messageType: MediaKeyMessageType;
}

interface MediaKeyNeededEventInit extends EventInit {
    initData?: ArrayBuffer | null;
    initDataType?: string;
}

interface MediaKeySystemConfiguration {
    audioCapabilities?: MediaKeySystemMediaCapability[];
    distinctiveIdentifier?: MediaKeysRequirement;
    initDataTypes?: string[];
    label?: string;
    persistentState?: MediaKeysRequirement;
    sessionTypes?: string[];
    videoCapabilities?: MediaKeySystemMediaCapability[];
}

interface MediaKeySystemMediaCapability {
    contentType?: string;
    encryptionScheme?: string | null;
    robustness?: string;
}

interface MediaKeysPolicy {
    minHdcpVersion?: string;
}

interface MediaMetadataInit {
    album?: string;
    artist?: string;
    artwork?: MediaImage[];
    title?: string;
}

interface MediaPositionState {
    duration?: number;
    playbackRate?: number;
    position?: number;
}

interface MediaQueryListEventInit extends EventInit {
    matches?: boolean;
    media?: UTF8String;
}

interface MediaRecorderErrorEventInit extends EventInit {
    error: DOMException;
}

interface MediaRecorderOptions {
    audioBitsPerSecond?: number;
    bitsPerSecond?: number;
    mimeType?: string;
    videoBitsPerSecond?: number;
}

interface MediaResourceDebugInfo {
    cacheStream?: MediaCacheStreamDebugInfo;
}

interface MediaSessionActionDetails {
    action: MediaSessionAction;
    fastSeek?: boolean;
    seekOffset?: number;
    seekTime?: number;
}

interface MediaSinkDebugInfo {
    audioSinkWrapper?: AudioSinkWrapperDebugInfo;
    decodedStream?: DecodedStreamDebugInfo;
    videoSink?: VideoSinkDebugInfo;
}

interface MediaSourceDecoderDebugInfo {
    demuxer?: MediaSourceDemuxerDebugInfo;
    reader?: MediaFormatReaderDebugInfo;
}

interface MediaSourceDemuxerDebugInfo {
    audioTrack?: TrackBuffersManagerDebugInfo;
    videoTrack?: TrackBuffersManagerDebugInfo;
}

interface MediaStateDebugInfo {
    demuxEOS?: number;
    demuxQueueSize?: number;
    drainState?: number;
    hasDecoder?: boolean;
    hasDemuxRequest?: boolean;
    hasPromise?: boolean;
    lastStreamSourceID?: number;
    needInput?: boolean;
    numSamplesInput?: number;
    numSamplesOutput?: number;
    pending?: number;
    queueSize?: number;
    timeTreshold?: number;
    timeTresholdHasSeeked?: boolean;
    waitingForData?: boolean;
    waitingForKey?: boolean;
    waitingPromise?: boolean;
}

interface MediaStreamAudioSourceOptions {
    mediaStream: MediaStream;
}

interface MediaStreamConstraints {
    audio?: boolean | MediaTrackConstraints;
    fake?: boolean;
    peerIdentity?: string | null;
    picture?: boolean;
    video?: boolean | MediaTrackConstraints;
}

interface MediaStreamEventInit extends EventInit {
    stream?: MediaStream | null;
}

interface MediaStreamTrackAudioSourceOptions {
    mediaStreamTrack: MediaStreamTrack;
}

interface MediaStreamTrackEventInit extends EventInit {
    track: MediaStreamTrack;
}

interface MediaTrackConstraintSet {
    autoGainControl?: ConstrainBoolean;
    browserWindow?: number;
    channelCount?: ConstrainLong;
    deviceId?: ConstrainDOMString;
    echoCancellation?: ConstrainBoolean;
    facingMode?: ConstrainDOMString;
    frameRate?: ConstrainDouble;
    groupId?: ConstrainDOMString;
    height?: ConstrainLong;
    mediaSource?: string;
    noiseSuppression?: ConstrainBoolean;
    scrollWithPage?: boolean;
    viewportHeight?: ConstrainLong;
    viewportOffsetX?: ConstrainLong;
    viewportOffsetY?: ConstrainLong;
    viewportWidth?: ConstrainLong;
    width?: ConstrainLong;
}

interface MediaTrackConstraints extends MediaTrackConstraintSet {
    advanced?: MediaTrackConstraintSet[];
}

interface MediaTrackSettings {
    autoGainControl?: boolean;
    browserWindow?: number;
    channelCount?: number;
    deviceId?: string;
    echoCancellation?: boolean;
    facingMode?: string;
    frameRate?: number;
    groupId?: string;
    height?: number;
    mediaSource?: string;
    noiseSuppression?: boolean;
    scrollWithPage?: boolean;
    viewportHeight?: number;
    viewportOffsetX?: number;
    viewportOffsetY?: number;
    viewportWidth?: number;
    width?: number;
}

interface MediaTrackSupportedConstraints {
    aspectRatio?: boolean;
    autoGainControl?: boolean;
    browserWindow?: boolean;
    channelCount?: boolean;
    deviceId?: boolean;
    echoCancellation?: boolean;
    facingMode?: boolean;
    frameRate?: boolean;
    groupId?: boolean;
    height?: boolean;
    latency?: boolean;
    mediaSource?: boolean;
    noiseSuppression?: boolean;
    sampleRate?: boolean;
    sampleSize?: boolean;
    scrollWithPage?: boolean;
    viewportHeight?: boolean;
    viewportOffsetX?: boolean;
    viewportOffsetY?: boolean;
    viewportWidth?: boolean;
    volume?: boolean;
    width?: boolean;
}

interface MerchantValidationEventInit extends EventInit {
    methodName?: string;
    validationURL?: string;
}

interface MessageEventInit extends EventInit {
    data?: any;
    lastEventId?: string;
    origin?: string;
    ports?: MessagePort[];
    source?: MessageEventSource | null;
}

interface MouseEventInit extends EventModifierInit {
    button?: number;
    buttons?: number;
    clientX?: number;
    clientY?: number;
    movementX?: number;
    movementY?: number;
    relatedTarget?: EventTarget | null;
    screenX?: number;
    screenY?: number;
}

interface MoveOptions {
    noOverwrite?: boolean;
}

interface MozApplicationEventInit extends EventInit {
    application?: DOMApplication | null;
}

interface MozDocumentMatcherInit {
    allFrames?: boolean;
    checkPermissions?: boolean;
    excludeGlobs?: MatchGlobOrString[] | null;
    excludeMatches?: MatchPatternSetOrStringSequence | null;
    frameID?: number | null;
    hasActiveTabPermission?: boolean;
    includeGlobs?: MatchGlobOrString[] | null;
    matchAboutBlank?: boolean;
    matches: MatchPatternSetOrStringSequence;
    originAttributesPatterns?: OriginAttributesPatternDictionary[] | null;
}

interface MozFrameAncestorInfo {
    frameId: number;
    url: string;
}

interface MozHTTPHeader {
    name: string;
    value: string;
}

interface MozPluginParameter {
    name?: string;
    value?: string;
}

interface MozProxyInfo {
    connectionIsolationKey?: string | null;
    failoverTimeout?: number;
    host: string;
    port: number;
    proxyAuthorizationHeader?: string | null;
    proxyDNS: boolean;
    type: string;
    username?: string | null;
}

interface MozRequestFilter {
    incognito?: boolean | null;
    types?: MozContentPolicyType[] | null;
    urls?: MatchPatternSet | null;
}

interface MozRequestMatchOptions {
    isProxy?: boolean;
}

interface MozUrlClassification {
    firstParty: MozUrlClassificationFlags[];
    thirdParty: MozUrlClassificationFlags[];
}

interface MozXMLHttpRequestParameters {
    mozAnon?: boolean;
    mozSystem?: boolean;
}

interface MultiCacheQueryOptions extends CacheQueryOptions {
    cacheName?: string;
}

interface MutationObserverInit {
    animations?: boolean;
    attributeFilter?: string[];
    attributeOldValue?: boolean;
    attributes?: boolean;
    characterData?: boolean;
    characterDataOldValue?: boolean;
    childList?: boolean;
    chromeOnlyNodes?: boolean;
    subtree?: boolean;
}

interface MutationObservingInfo extends MutationObserverInit {
    observedNode?: Node | null;
}

interface NavigationPreloadState {
    enabled?: boolean;
    headerValue?: string;
}

interface NetErrorInfo {
    errorCodeString?: string;
}

interface NotificationBehavior {
    noclear?: boolean;
    noscreen?: boolean;
    showOnlyOnce?: boolean;
    soundFile?: string;
    vibrationPattern?: number[];
}

interface NotificationEventInit extends ExtendableEventInit {
    notification: Notification;
}

interface NotificationOptions {
    body?: string;
    data?: any;
    dir?: NotificationDirection;
    icon?: string;
    lang?: string;
    mozbehavior?: NotificationBehavior;
    requireInteraction?: boolean;
    silent?: boolean;
    tag?: string;
    vibrate?: VibratePattern;
}

interface ObservableArrayCallbacks {
    deleteBooleanCallback?: SetDeleteBooleanCallback;
    deleteInterfaceCallback?: SetDeleteInterfaceCallback;
    deleteObjectCallback?: SetDeleteObjectCallback;
    setBooleanCallback?: SetDeleteBooleanCallback;
    setInterfaceCallback?: SetDeleteInterfaceCallback;
    setObjectCallback?: SetDeleteObjectCallback;
}

interface OfflineAudioCompletionEventInit extends EventInit {
    renderedBuffer: AudioBuffer;
}

interface OfflineAudioContextOptions {
    length: number;
    numberOfChannels?: number;
    sampleRate: number;
}

interface OpenPopupOptions {
    attributesOverride?: boolean;
    isContextMenu?: boolean;
    position?: string;
    triggerEvent?: Event | null;
    x?: number;
    y?: number;
}

interface OptionalEffectTiming {
    delay?: number;
    direction?: PlaybackDirection;
    duration?: number | string;
    easing?: UTF8String;
    endDelay?: number;
    fill?: FillMode;
    iterationStart?: number;
    iterations?: number;
}

interface OriginAttributesDictionary {
    firstPartyDomain?: string;
    geckoViewSessionContextId?: string;
    inIsolatedMozBrowser?: boolean;
    partitionKey?: string;
    privateBrowsingId?: number;
    userContextId?: number;
}

interface OriginAttributesPatternDictionary {
    firstPartyDomain?: string;
    geckoViewSessionContextId?: string;
    inIsolatedMozBrowser?: boolean;
    partitionKey?: string;
    partitionKeyPattern?: PartitionKeyPatternDictionary;
    privateBrowsingId?: number;
    userContextId?: number;
}

interface OscillatorOptions extends AudioNodeOptions {
    detune?: number;
    frequency?: number;
    periodicWave?: PeriodicWave;
    type?: OscillatorType;
}

interface PCErrorData {
    message: string;
    name: PCError;
}

interface PageTransitionEventInit extends EventInit {
    inFrameSwap?: boolean;
    persisted?: boolean;
}

interface PannerOptions extends AudioNodeOptions {
    coneInnerAngle?: number;
    coneOuterAngle?: number;
    coneOuterGain?: number;
    distanceModel?: DistanceModelType;
    maxDistance?: number;
    orientationX?: number;
    orientationY?: number;
    orientationZ?: number;
    panningModel?: PanningModelType;
    positionX?: number;
    positionY?: number;
    positionZ?: number;
    refDistance?: number;
    rolloffFactor?: number;
}

interface ParentProcInfoDictionary {
    children?: ChildProcInfoDictionary[];
    cpuCycleCount?: number;
    cpuTime?: number;
    memory?: number;
    pid?: number;
    threads?: ThreadInfoDictionary[];
    type?: WebIDLProcType;
}

interface PartitionKeyPatternDictionary {
    baseDomain?: string;
    port?: number;
    scheme?: string;
}

interface PayerErrors {
    email?: string;
    name?: string;
    phone?: string;
}

interface PaymentCurrencyAmount {
    currency: string;
    value: string;
}

interface PaymentDetailsBase {
    displayItems?: PaymentItem[];
    modifiers?: PaymentDetailsModifier[];
    shippingOptions?: PaymentShippingOption[];
}

interface PaymentDetailsInit extends PaymentDetailsBase {
    id?: string;
    total: PaymentItem;
}

interface PaymentDetailsModifier {
    additionalDisplayItems?: PaymentItem[];
    data?: any;
    supportedMethods: string;
    total?: PaymentItem;
}

interface PaymentDetailsUpdate extends PaymentDetailsBase {
    error?: string;
    payerErrors?: PayerErrors;
    paymentMethodErrors?: any;
    shippingAddressErrors?: AddressErrors;
    total?: PaymentItem;
}

interface PaymentItem {
    amount: PaymentCurrencyAmount;
    label: string;
    pending?: boolean;
}

interface PaymentMethodChangeEventInit extends PaymentRequestUpdateEventInit {
    methodDetails?: any;
    methodName?: string;
}

interface PaymentMethodData {
    data?: any;
    supportedMethods: string;
}

interface PaymentOptions {
    requestBillingAddress?: boolean;
    requestPayerEmail?: boolean;
    requestPayerName?: boolean;
    requestPayerPhone?: boolean;
    requestShipping?: boolean;
    shippingType?: PaymentShippingType;
}

interface PaymentRequestUpdateEventInit extends EventInit {
}

interface PaymentShippingOption {
    amount: PaymentCurrencyAmount;
    id: string;
    label: string;
    selected?: boolean;
}

interface PaymentValidationErrors {
    error?: string;
    payer?: PayerErrors;
    paymentMethod?: any;
    shippingAddress?: AddressErrors;
}

interface PerformanceEntryEventInit extends EventInit {
    duration?: DOMHighResTimeStamp;
    entryType?: string;
    epoch?: number;
    name?: string;
    origin?: string;
    startTime?: DOMHighResTimeStamp;
}

interface PerformanceEntryFilterOptions {
    entryType?: string;
    initiatorType?: string;
    name?: string;
}

interface PerformanceMarkOptions {
    detail?: any;
    startTime?: DOMHighResTimeStamp;
}

interface PerformanceMeasureOptions {
    detail?: any;
    duration?: DOMHighResTimeStamp;
    end?: string | DOMHighResTimeStamp;
    start?: string | DOMHighResTimeStamp;
}

interface PerformanceObserverInit {
    buffered?: boolean;
    durationThreshold?: DOMHighResTimeStamp;
    entryTypes?: string[];
    type?: string;
}

interface PeriodicWaveConstraints {
    disableNormalization?: boolean;
}

interface PeriodicWaveOptions extends PeriodicWaveConstraints {
    imag?: number[] | Float32Array;
    real?: number[] | Float32Array;
}

interface PlacesBookmarkAdditionInit {
    dateAdded: number;
    frecency: number;
    guid: string;
    hidden: boolean;
    id: number;
    index: number;
    isTagging: boolean;
    itemType: number;
    lastVisitDate: number | null;
    parentGuid: string;
    parentId: number;
    source: number;
    tags: string | null;
    targetFolderGuid: string | null;
    targetFolderItemId: number;
    targetFolderTitle: string | null;
    title: string;
    url: string;
    visitCount: number;
}

interface PlacesBookmarkGuidInit {
    guid: string;
    id: number;
    isTagging: boolean;
    itemType: number;
    lastModified: number;
    parentGuid: string;
    source: number;
    url?: string | null;
}

interface PlacesBookmarkKeywordInit {
    guid: string;
    id: number;
    isTagging: boolean;
    itemType: number;
    keyword: string;
    lastModified: number;
    parentGuid: string;
    source: number;
    url?: string | null;
}

interface PlacesBookmarkMovedInit {
    dateAdded: number;
    frecency: number;
    guid: string;
    hidden: boolean;
    id: number;
    index: number;
    isTagging: boolean;
    itemType: number;
    lastVisitDate: number | null;
    oldIndex: number;
    oldParentGuid: string;
    parentGuid: string;
    source: number;
    tags: string | null;
    title: string;
    url?: string | null;
    visitCount: number;
}

interface PlacesBookmarkRemovedInit {
    guid: string;
    id: number;
    index: number;
    isDescendantRemoval?: boolean;
    isTagging: boolean;
    itemType: number;
    parentGuid: string;
    parentId: number;
    source: number;
    title: string;
    url: string;
}

interface PlacesBookmarkTagsInit {
    guid: string;
    id: number;
    isTagging: boolean;
    itemType: number;
    lastModified: number;
    parentGuid: string;
    source: number;
    tags: string[];
    url?: string | null;
}

interface PlacesBookmarkTimeInit {
    dateAdded: number;
    guid: string;
    id: number;
    isTagging: boolean;
    itemType: number;
    lastModified: number;
    parentGuid: string;
    source: number;
    url?: string | null;
}

interface PlacesBookmarkTitleInit {
    guid: string;
    id: number;
    isTagging: boolean;
    itemType: number;
    lastModified: number;
    parentGuid: string;
    source: number;
    title: string;
    url?: string | null;
}

interface PlacesBookmarkUrlInit {
    guid: string;
    id: number;
    isTagging: boolean;
    itemType: number;
    lastModified: number;
    parentGuid: string;
    source: number;
    url: string;
}

interface PlacesFaviconInit {
    faviconUrl: string;
    pageGuid: string;
    url: string;
}

interface PlacesVisitRemovedInit {
    isPartialVisistsRemoval?: boolean;
    isRemovedFromStore?: boolean;
    pageGuid: string;
    reason: number;
    transitionType?: number;
    url: string;
}

interface PlacesVisitTitleInit {
    pageGuid: string;
    title: string;
    url: string;
}

interface PlaneLayout {
    offset: number;
    stride: number;
}

interface PluginCrashedEventInit extends EventInit {
    gmpPlugin?: boolean;
    pluginDumpID?: string;
    pluginFilename?: string | null;
    pluginID?: number;
    pluginName?: string;
    submittedCrashReport?: boolean;
}

interface PointerEventInit extends MouseEventInit {
    coalescedEvents?: PointerEvent[];
    height?: number;
    isPrimary?: boolean;
    pointerId?: number;
    pointerType?: string;
    predictedEvents?: PointerEvent[];
    pressure?: number;
    tangentialPressure?: number;
    tiltX?: number;
    tiltY?: number;
    twist?: number;
    width?: number;
}

interface PopStateEventInit extends EventInit {
    state?: any;
}

interface PopupBlockedEventInit extends EventInit {
    popupWindowFeatures?: string;
    popupWindowName?: string;
    popupWindowURI?: URI | null;
    requestingWindow?: Window | null;
}

interface PopupPositionedEventInit extends EventInit {
    alignmentOffset?: number;
    alignmentPosition?: string;
    isAnchored?: boolean;
    popupAlignment?: string;
}

interface PositionOptions {
    enableHighAccuracy?: boolean;
    maximumAge?: number;
    timeout?: number;
}

interface PositionStateEventInit extends EventInit {
    duration: number;
    playbackRate: number;
    position: number;
}

interface ProcessActorChildOptions extends ProcessActorSidedOptions {
    observers?: string[];
}

interface ProcessActorOptions {
    child?: ProcessActorChildOptions;
    includeParent?: boolean;
    loadInDevToolsLoader?: boolean;
    parent?: ProcessActorSidedOptions;
    remoteTypes?: UTF8String[];
}

interface ProcessActorSidedOptions {
    esModuleURI?: string;
    moduleURI?: string;
}

interface ProfilerMarkerOptions {
    captureStack?: boolean;
    category?: string;
    innerWindowId?: number;
    startTime?: DOMHighResTimeStamp;
}

interface ProgressEventInit extends EventInit {
    lengthComputable?: boolean;
    loaded?: number;
    total?: number;
}

interface PromiseDebuggingStateHolder {
    reason?: any;
    state?: PromiseDebuggingState;
    value?: any;
}

interface PromiseRejectionEventInit extends EventInit {
    promise: Promise<any>;
    reason?: any;
}

interface PropertyDefinition {
    inherits: boolean;
    initialValue?: UTF8String;
    name: UTF8String;
    syntax?: UTF8String;
}

interface PropertyNamesOptions {
    includeAliases?: boolean;
    includeExperimentals?: boolean;
    includeShorthands?: boolean;
}

interface PropertyPref {
    name: string;
    pref: string;
}

interface PublicKeyCredentialCreationOptions {
    attestation?: string;
    authenticatorSelection?: AuthenticatorSelectionCriteria;
    challenge: BufferSource;
    excludeCredentials?: PublicKeyCredentialDescriptor[];
    extensions?: AuthenticationExtensionsClientInputs;
    pubKeyCredParams: PublicKeyCredentialParameters[];
    rp: PublicKeyCredentialRpEntity;
    timeout?: number;
    user: PublicKeyCredentialUserEntity;
}

interface PublicKeyCredentialCreationOptionsJSON {
    attestation?: string;
    attestationFormats?: string[];
    authenticatorSelection?: AuthenticatorSelectionCriteria;
    challenge: Base64URLString;
    excludeCredentials?: PublicKeyCredentialDescriptorJSON[];
    extensions?: AuthenticationExtensionsClientInputsJSON;
    hints?: string[];
    pubKeyCredParams: PublicKeyCredentialParameters[];
    rp: PublicKeyCredentialRpEntity;
    timeout?: number;
    user: PublicKeyCredentialUserEntityJSON;
}

interface PublicKeyCredentialDescriptor {
    id: BufferSource;
    transports?: string[];
    type: string;
}

interface PublicKeyCredentialDescriptorJSON {
    id: Base64URLString;
    transports?: string[];
    type: string;
}

interface PublicKeyCredentialEntity {
    name: string;
}

interface PublicKeyCredentialParameters {
    alg: COSEAlgorithmIdentifier;
    type: string;
}

interface PublicKeyCredentialRequestOptions {
    allowCredentials?: PublicKeyCredentialDescriptor[];
    challenge: BufferSource;
    extensions?: AuthenticationExtensionsClientInputs;
    rpId?: string;
    timeout?: number;
    userVerification?: string;
}

interface PublicKeyCredentialRequestOptionsJSON {
    allowCredentials?: PublicKeyCredentialDescriptorJSON[];
    attestation?: string;
    attestationFormats?: string[];
    challenge: Base64URLString;
    extensions?: AuthenticationExtensionsClientInputsJSON;
    hints?: string[];
    rpId?: string;
    timeout?: number;
    userVerification?: string;
}

interface PublicKeyCredentialRpEntity extends PublicKeyCredentialEntity {
    id?: string;
}

interface PublicKeyCredentialUserEntity extends PublicKeyCredentialEntity {
    displayName: string;
    id: BufferSource;
}

interface PublicKeyCredentialUserEntityJSON {
    displayName: string;
    id: Base64URLString;
    name: string;
}

interface PushEventInit extends ExtendableEventInit {
    data?: PushMessageDataInit;
}

interface PushSubscriptionInit {
    appServerKey?: BufferSource | null;
    authSecret?: ArrayBuffer | null;
    endpoint: string;
    expirationTime?: EpochTimeStamp | null;
    p256dhKey?: ArrayBuffer | null;
    scope: string;
}

interface PushSubscriptionJSON {
    endpoint?: string;
    expirationTime?: EpochTimeStamp | null;
    keys?: PushSubscriptionKeys;
}

interface PushSubscriptionKeys {
    auth?: string;
    p256dh?: string;
}

interface PushSubscriptionOptionsInit {
    applicationServerKey?: BufferSource | string | null;
}

interface QueuingStrategy {
    highWaterMark?: number;
    size?: QueuingStrategySize;
}

interface QueuingStrategyInit {
    highWaterMark: number;
}

interface RTCBandwidthEstimationInternal {
    maxPaddingBps?: number;
    pacerDelayMs?: number;
    receiveBandwidthBps?: number;
    rttMs?: number;
    sendBandwidthBps?: number;
    trackIdentifier: string;
}

interface RTCCodecStats extends RTCStats {
    channels?: number;
    clockRate?: number;
    codecType?: RTCCodecType;
    mimeType: string;
    payloadType: number;
    sdpFmtpLine?: string;
    transportId: string;
}

interface RTCConfiguration {
    bundlePolicy?: RTCBundlePolicy;
    certificates?: RTCCertificate[];
    iceServers?: RTCIceServer[];
    iceTransportPolicy?: RTCIceTransportPolicy;
    peerIdentity?: string | null;
    sdpSemantics?: string;
}

interface RTCConfigurationInternal {
    bundlePolicy?: RTCBundlePolicy;
    certificatesProvided: boolean;
    iceServers?: RTCIceServerInternal[];
    iceTransportPolicy?: RTCIceTransportPolicy;
    peerIdentityProvided: boolean;
    sdpSemantics?: string;
}

interface RTCDTMFToneChangeEventInit extends EventInit {
    tone?: string;
}

interface RTCDataChannelEventInit extends EventInit {
    channel: RTCDataChannel;
}

interface RTCDataChannelInit {
    id?: number;
    maxPacketLifeTime?: number;
    maxRetransmitTime?: number;
    maxRetransmits?: number;
    negotiated?: boolean;
    ordered?: boolean;
    protocol?: string;
}

interface RTCDataChannelStats extends RTCStats {
    bytesReceived?: number;
    bytesSent?: number;
    dataChannelIdentifier?: number;
    label?: string;
    messagesReceived?: number;
    messagesSent?: number;
    protocol?: string;
    state?: RTCDataChannelState;
}

interface RTCEncodedAudioFrameMetadata {
    contributingSources?: number[];
    payloadType?: number;
    sequenceNumber?: number;
    synchronizationSource?: number;
}

interface RTCEncodedVideoFrameMetadata {
    contributingSources?: number[];
    dependencies?: number[];
    frameId?: number;
    height?: number;
    payloadType?: number;
    spatialIndex?: number;
    synchronizationSource?: number;
    temporalIndex?: number;
    timestamp?: number;
    width?: number;
}

interface RTCFecParameters {
    ssrc?: number;
}

interface RTCIceCandidateInit {
    candidate?: string;
    sdpMLineIndex?: number | null;
    sdpMid?: string | null;
    usernameFragment?: string | null;
}

interface RTCIceCandidatePairStats extends RTCStats {
    bytesReceived?: number;
    bytesSent?: number;
    componentId?: number;
    lastPacketReceivedTimestamp?: DOMHighResTimeStamp;
    lastPacketSentTimestamp?: DOMHighResTimeStamp;
    localCandidateId?: string;
    nominated?: boolean;
    priority?: number;
    readable?: boolean;
    remoteCandidateId?: string;
    selected?: boolean;
    state?: RTCStatsIceCandidatePairState;
    transportId?: string;
    writable?: boolean;
}

interface RTCIceCandidateStats extends RTCStats {
    address?: string;
    candidateType?: RTCIceCandidateType;
    port?: number;
    priority?: number;
    protocol?: string;
    proxied?: string;
    relayProtocol?: string;
    transportId?: string;
}

interface RTCIceServer {
    credential?: string;
    credentialType?: RTCIceCredentialType;
    url?: string;
    urls?: string | string[];
    username?: string;
}

interface RTCIceServerInternal {
    credentialProvided: boolean;
    urls?: string[];
    userNameProvided: boolean;
}

interface RTCIdentityAssertion {
    idp?: string;
    name?: string;
}

interface RTCIdentityAssertionResult {
    assertion: string;
    idp: RTCIdentityProviderDetails;
}

interface RTCIdentityProvider {
    generateAssertion: GenerateAssertionCallback;
    validateAssertion: ValidateAssertionCallback;
}

interface RTCIdentityProviderDetails {
    domain: string;
    protocol?: string;
}

interface RTCIdentityProviderOptions {
    peerIdentity?: string;
    protocol?: string;
    usernameHint?: string;
}

interface RTCIdentityValidationResult {
    contents: string;
    identity: string;
}

interface RTCInboundRtpStreamStats extends RTCReceivedRtpStreamStats {
    audioLevel?: number;
    bytesReceived?: number;
    concealedSamples?: number;
    concealmentEvents?: number;
    fecPacketsDiscarded?: number;
    fecPacketsReceived?: number;
    firCount?: number;
    frameHeight?: number;
    frameWidth?: number;
    framesDecoded?: number;
    framesDropped?: number;
    framesPerSecond?: number;
    framesReceived?: number;
    headerBytesReceived?: number;
    insertedSamplesForDeceleration?: number;
    jitterBufferDelay?: number;
    jitterBufferEmittedCount?: number;
    lastPacketReceivedTimestamp?: DOMHighResTimeStamp;
    nackCount?: number;
    pliCount?: number;
    qpSum?: number;
    remoteId?: string;
    removedSamplesForAcceleration?: number;
    silentConcealedSamples?: number;
    totalAudioEnergy?: number;
    totalDecodeTime?: number;
    totalInterFrameDelay?: number;
    totalProcessingDelay?: number;
    totalSamplesDuration?: number;
    totalSamplesReceived?: number;
    totalSquaredInterFrameDelay?: number;
    trackIdentifier: string;
}

interface RTCMediaSourceStats extends RTCStats {
    kind: string;
    trackIdentifier: string;
}

interface RTCOfferAnswerOptions {
}

interface RTCOfferOptions extends RTCOfferAnswerOptions {
    iceRestart?: boolean;
    offerToReceiveAudio?: boolean;
    offerToReceiveVideo?: boolean;
}

interface RTCOutboundRtpStreamStats extends RTCSentRtpStreamStats {
    firCount?: number;
    frameHeight?: number;
    frameWidth?: number;
    framesEncoded?: number;
    framesPerSecond?: number;
    framesSent?: number;
    headerBytesSent?: number;
    hugeFramesSent?: number;
    nackCount?: number;
    pliCount?: number;
    qpSum?: number;
    remoteId?: string;
    retransmittedBytesSent?: number;
    retransmittedPacketsSent?: number;
    totalEncodeTime?: number;
    totalEncodedBytesTarget?: number;
}

interface RTCPeerConnectionIceEventInit extends EventInit {
    candidate?: RTCIceCandidate | null;
}

interface RTCPeerConnectionStats extends RTCStats {
    dataChannelsClosed?: number;
    dataChannelsOpened?: number;
}

interface RTCRTPContributingSourceStats extends RTCStats {
    contributorSsrc?: number;
    inboundRtpStreamId?: string;
}

interface RTCReceivedRtpStreamStats extends RTCRtpStreamStats {
    discardedPackets?: number;
    jitter?: number;
    packetsDiscarded?: number;
    packetsLost?: number;
    packetsReceived?: number;
}

interface RTCRemoteInboundRtpStreamStats extends RTCReceivedRtpStreamStats {
    fractionLost?: number;
    localId?: string;
    roundTripTime?: number;
    roundTripTimeMeasurements?: number;
    totalRoundTripTime?: number;
}

interface RTCRemoteOutboundRtpStreamStats extends RTCSentRtpStreamStats {
    localId?: string;
    remoteTimestamp?: DOMHighResTimeStamp;
}

interface RTCRtcpParameters {
    cname?: string;
    reducedSize?: boolean;
}

interface RTCRtpCapabilities {
    codecs: RTCRtpCodecCapability[];
    headerExtensions: RTCRtpHeaderExtensionCapability[];
}

interface RTCRtpCodec {
    channels?: number;
    clockRate: number;
    mimeType: string;
    sdpFmtpLine?: string;
}

interface RTCRtpCodecCapability extends RTCRtpCodec {
}

interface RTCRtpCodecParameters {
    channels?: number;
    clockRate?: number;
    mimeType?: string;
    payloadType?: number;
    sdpFmtpLine?: string;
}

interface RTCRtpContributingSource {
    audioLevel?: number;
    rtpTimestamp: number;
    source: number;
    timestamp: DOMHighResTimeStamp;
}

interface RTCRtpEncodingParameters {
    active?: boolean;
    fec?: RTCFecParameters;
    maxBitrate?: number;
    maxFramerate?: number;
    priority?: RTCPriorityType;
    rid?: string;
    rtx?: RTCRtxParameters;
    scaleResolutionDownBy?: number;
    ssrc?: number;
}

interface RTCRtpHeaderExtensionCapability {
    uri: string;
}

interface RTCRtpHeaderExtensionParameters {
    encrypted?: boolean;
    id?: number;
    uri?: string;
}

interface RTCRtpParameters {
    codecs?: RTCRtpCodecParameters[];
    headerExtensions?: RTCRtpHeaderExtensionParameters[];
    rtcp?: RTCRtcpParameters;
}

interface RTCRtpSendParameters extends RTCRtpParameters {
    encodings: RTCRtpEncodingParameters[];
    transactionId?: string;
}

interface RTCRtpStreamStats extends RTCStats {
    codecId?: string;
    kind: string;
    mediaType?: string;
    ssrc: number;
    transportId?: string;
}

interface RTCRtpSynchronizationSource extends RTCRtpContributingSource {
    voiceActivityFlag?: boolean | null;
}

interface RTCRtpTransceiverInit {
    direction?: RTCRtpTransceiverDirection;
    sendEncodings?: RTCRtpEncodingParameters[];
    streams?: MediaStream[];
}

interface RTCRtxParameters {
    ssrc?: number;
}

interface RTCSdpHistoryEntryInternal {
    errors?: RTCSdpParsingErrorInternal[];
    isLocal: boolean;
    sdp: string;
    timestamp: DOMHighResTimeStamp;
}

interface RTCSdpHistoryInternal {
    pcid: string;
    sdpHistory?: RTCSdpHistoryEntryInternal[];
}

interface RTCSdpParsingErrorInternal {
    error: string;
    lineNumber: number;
}

interface RTCSentRtpStreamStats extends RTCRtpStreamStats {
    bytesSent?: number;
    packetsSent?: number;
}

interface RTCSessionDescriptionInit {
    sdp?: string;
    type?: RTCSdpType;
}

interface RTCStats {
    id?: string;
    timestamp?: DOMHighResTimeStamp;
    type?: RTCStatsType;
}

interface RTCStatsCollection {
    bandwidthEstimations?: RTCBandwidthEstimationInternal[];
    codecStats?: RTCCodecStats[];
    dataChannelStats?: RTCDataChannelStats[];
    iceCandidatePairStats?: RTCIceCandidatePairStats[];
    iceCandidateStats?: RTCIceCandidateStats[];
    inboundRtpStreamStats?: RTCInboundRtpStreamStats[];
    mediaSourceStats?: RTCMediaSourceStats[];
    outboundRtpStreamStats?: RTCOutboundRtpStreamStats[];
    peerConnectionStats?: RTCPeerConnectionStats[];
    rawLocalCandidates?: string[];
    rawRemoteCandidates?: string[];
    remoteInboundRtpStreamStats?: RTCRemoteInboundRtpStreamStats[];
    remoteOutboundRtpStreamStats?: RTCRemoteOutboundRtpStreamStats[];
    rtpContributingSourceStats?: RTCRTPContributingSourceStats[];
    trickledIceCandidateStats?: RTCIceCandidateStats[];
    videoFrameHistories?: RTCVideoFrameHistoryInternal[];
    videoSourceStats?: RTCVideoSourceStats[];
}

interface RTCStatsReportInternal extends RTCStatsCollection {
    browserId: number;
    callDurationMs?: number;
    closed: boolean;
    configuration?: RTCConfigurationInternal;
    iceRestarts: number;
    iceRollbacks: number;
    jsepSessionErrors?: string;
    offerer?: boolean;
    pcid: string;
    sdpHistory?: RTCSdpHistoryEntryInternal[];
    timestamp: DOMHighResTimeStamp;
}

interface RTCTrackEventInit extends EventInit {
    receiver: RTCRtpReceiver;
    streams?: MediaStream[];
    track: MediaStreamTrack;
    transceiver: RTCRtpTransceiver;
}

interface RTCTransformEventInit extends EventInit {
    transformer: RTCRtpScriptTransformer;
}

interface RTCVideoFrameHistoryEntryInternal {
    consecutiveFrames: number;
    firstFrameTimestamp: DOMHighResTimeStamp;
    height: number;
    lastFrameTimestamp: DOMHighResTimeStamp;
    localSsrc: number;
    remoteSsrc: number;
    rotationAngle: number;
    width: number;
}

interface RTCVideoFrameHistoryInternal {
    entries?: RTCVideoFrameHistoryEntryInternal[];
    trackIdentifier: string;
}

interface RTCVideoSourceStats extends RTCMediaSourceStats {
    frames?: number;
    framesPerSecond?: number;
    height?: number;
    width?: number;
}

interface ReadOptions extends ReadUTF8Options {
    maxBytes?: number | null;
    offset?: number;
}

interface ReadUTF8Options {
    decompress?: boolean;
}

interface ReadableStreamGetReaderOptions {
    mode?: ReadableStreamReaderMode;
}

interface ReadableStreamIteratorOptions {
    preventCancel?: boolean;
}

interface ReadableStreamReadResult {
    done?: boolean;
    value?: any;
}

interface ReadableWritablePair {
    readable: ReadableStream;
    writable: WritableStream;
}

interface ReceiveMessageArgument {
    data?: any;
    json?: any;
    name: string;
    ports?: MessagePort[];
    sync: boolean;
    target: nsISupports;
    targetFrameLoader?: FrameLoader;
}

interface RegistrationOptions {
    scope?: string;
    updateViaCache?: ServiceWorkerUpdateViaCache;
}

interface RemotenessOptions {
    pendingSwitchID?: number;
    remoteType: UTF8String | null;
    switchingInProgressLoad?: boolean;
}

interface RemoveOptions {
    ignoreAbsent?: boolean;
    recursive?: boolean;
    retryReadonly?: boolean;
}

interface ReportingObserverOptions {
    buffered?: boolean;
    types?: string[];
}

interface RequestInit {
    body?: BodyInit | null;
    cache?: RequestCache;
    credentials?: RequestCredentials;
    headers?: HeadersInit;
    integrity?: string;
    method?: string;
    mode?: RequestMode;
    mozErrors?: boolean;
    observe?: ObserverCallback;
    redirect?: RequestRedirect;
    referrer?: string;
    referrerPolicy?: ReferrerPolicy;
    signal?: AbortSignal | null;
}

interface ResizeObserverOptions {
    box?: ResizeObserverBoxOptions;
}

interface ResourceId {
    optional?: boolean;
    path: UTF8String;
}

interface ResponseInit {
    headers?: HeadersInit;
    status?: number;
    statusText?: string;
}

interface SVGBoundingBoxOptions {
    clipped?: boolean;
    fill?: boolean;
    markers?: boolean;
    stroke?: boolean;
}

interface SanitizerAttributeNamespace {
    name: string;
    namespace?: string | null;
}

interface SanitizerConfig {
    attributes?: SanitizerAttribute[];
    comments?: boolean;
    customElements?: boolean;
    elements?: SanitizerElementWithAttributes[];
    removeAttributes?: SanitizerAttribute[];
    removeElements?: SanitizerElement[];
    replaceWithChildrenElements?: SanitizerElement[];
    unknownMarkup?: boolean;
}

interface SanitizerElementNamespace {
    name: string;
    namespace?: string | null;
}

interface SanitizerElementNamespaceWithAttributes extends SanitizerElementNamespace {
    attributes?: SanitizerAttribute[];
    removeAttributes?: SanitizerAttribute[];
}

interface SchedulerPostTaskOptions {
    delay?: number;
    priority?: TaskPriority;
    signal?: AbortSignal;
}

interface ScrollIntoViewOptions extends ScrollOptions {
    block?: ScrollLogicalPosition;
    inline?: ScrollLogicalPosition;
}

interface ScrollOptions {
    behavior?: ScrollBehavior;
}

interface ScrollToOptions extends ScrollOptions {
    left?: number;
    top?: number;
}

interface ScrollViewChangeEventInit extends EventInit {
    state?: ScrollState;
}

interface SecurityPolicyViolationEventInit extends EventInit {
    blockedURI?: string;
    columnNumber?: number;
    disposition?: SecurityPolicyViolationEventDisposition;
    documentURI?: string;
    effectiveDirective?: string;
    lineNumber?: number;
    originalPolicy?: string;
    referrer?: string;
    sample?: string;
    sourceFile?: string;
    statusCode?: number;
    violatedDirective?: string;
}

interface SelectorWarning {
    index: number;
    kind: SelectorWarningKind;
}

interface ServerSocketOptions {
    binaryType?: TCPSocketBinaryType;
}

interface SetHTMLOptions {
    sanitizer?: SanitizerConfig;
}

interface ShadowRootInit {
    clonable?: boolean;
    delegatesFocus?: boolean;
    mode: ShadowRootMode;
    slotAssignment?: SlotAssignmentMode;
}

interface ShareData {
    files?: File[];
    text?: string;
    title?: string;
    url?: string;
}

interface SizeToContentConstraints {
    maxHeight?: number;
    maxWidth?: number;
    prefWidth?: number;
}

interface SocketOptions {
    binaryType?: TCPSocketBinaryType;
    useSecureTransport?: boolean;
}

interface SpeechRecognitionErrorInit extends EventInit {
    error?: SpeechRecognitionErrorCode;
    message?: string;
}

interface SpeechRecognitionEventInit extends EventInit {
    emma?: Document | null;
    interpretation?: any;
    resultIndex?: number;
    results?: SpeechRecognitionResultList | null;
}

interface SpeechSynthesisErrorEventInit extends SpeechSynthesisEventInit {
    error: SpeechSynthesisErrorCode;
}

interface SpeechSynthesisEventInit extends EventInit {
    charIndex?: number;
    charLength?: number | null;
    elapsedTime?: number;
    name?: string;
    utterance: SpeechSynthesisUtterance;
}

interface SplitRelativeOptions {
    allowCurrentDir?: boolean;
    allowEmpty?: boolean;
    allowParentDir?: boolean;
}

interface StaticRangeInit {
    endContainer: Node;
    endOffset: number;
    startContainer: Node;
    startOffset: number;
}

interface StereoPannerOptions extends AudioNodeOptions {
    pan?: number;
}

interface StorageEstimate {
    quota?: number;
    usage?: number;
}

interface StorageEventInit extends EventInit {
    key?: string | null;
    newValue?: string | null;
    oldValue?: string | null;
    storageArea?: Storage | null;
    url?: string;
}

interface StreamFilterDataEventInit extends EventInit {
    data: ArrayBuffer;
}

interface StreamPipeOptions {
    preventAbort?: boolean;
    preventCancel?: boolean;
    preventClose?: boolean;
    signal?: AbortSignal;
}

interface StructuredSerializeOptions {
    transfer?: any[];
}

interface StyleSheetApplicableStateChangeEventInit extends EventInit {
    applicable?: boolean;
    stylesheet?: CSSStyleSheet | null;
}

interface StyleSheetRemovedEventInit extends EventInit {
    stylesheet?: CSSStyleSheet | null;
}

interface SubmitEventInit extends EventInit {
    submitter?: HTMLElement | null;
}

interface SupportsOptions {
    chrome?: boolean;
    quirks?: boolean;
    userAgent?: boolean;
}

interface SvcOutputMetadata {
    temporalLayerId?: number;
}

interface TCPServerSocketEventInit extends EventInit {
    socket?: TCPSocket | null;
}

interface TCPSocketErrorEventInit extends EventInit {
    errorCode?: number;
    message?: string;
    name?: string;
}

interface TCPSocketEventInit extends EventInit {
    data?: any;
}

interface TaskControllerInit {
    priority?: TaskPriority;
}

interface TaskPriorityChangeEventInit extends EventInit {
    previousPriority: TaskPriority;
}

interface TelemetryStopwatchOptions {
    inSeconds?: boolean;
}

interface TestInterfaceAsyncIterableSingleOptions {
    failToInit?: boolean;
}

interface TestInterfaceAsyncIteratorOptions {
    blockingPromises?: Promise<any>[];
    failNextAfter?: number;
    multiplier?: number;
    throwFromNext?: boolean;
    throwFromReturn?: TestThrowingCallback;
}

interface TestInterfaceJSDictionary {
    anyMember?: any;
    anySequenceMember?: any[];
    innerDictionary?: TestInterfaceJSDictionary2;
    objectMember?: any;
    objectOrStringMember?: any;
    objectRecordMember?: Record<string, any>;
}

interface TestInterfaceJSDictionary2 {
    innerObject?: any;
}

interface TestInterfaceJSUnionableDictionary {
    anyMember?: any;
    objectMember?: any;
}

interface TextDecodeOptions {
    stream?: boolean;
}

interface TextDecoderOptions {
    fatal?: boolean;
    ignoreBOM?: boolean;
}

interface TextEncoderEncodeIntoResult {
    read?: number;
    written?: number;
}

interface ThreadInfoDictionary {
    cpuCycleCount?: number;
    cpuTime?: number;
    name?: string;
    tid?: number;
}

interface ToggleEventInit extends EventInit {
    newState?: string;
    oldState?: string;
}

interface TouchEventInit extends EventModifierInit {
    changedTouches?: Touch[];
    targetTouches?: Touch[];
    touches?: Touch[];
}

interface TouchInit {
    clientX?: number;
    clientY?: number;
    force?: number;
    identifier: number;
    pageX?: number;
    pageY?: number;
    radiusX?: number;
    radiusY?: number;
    rotationAngle?: number;
    screenX?: number;
    screenY?: number;
    target: EventTarget;
}

interface TrackBuffersManagerDebugInfo {
    bufferSize?: number;
    evictable?: number;
    nextGetSampleIndex?: number;
    nextInsertionIndex?: number;
    nextSampleTime?: number;
    numSamples?: number;
    ranges?: BufferRange[];
    type?: string;
}

interface TrackEventInit extends EventInit {
    track?: VideoTrack | AudioTrack | TextTrack | null;
}

interface TransitionEventInit extends EventInit {
    elapsedTime?: number;
    propertyName?: string;
    pseudoElement?: string;
}

interface TreeCellInfo {
    childElt?: string;
    col?: TreeColumn | null;
    row?: number;
}

interface UDPMessageEventInit extends EventInit {
    data?: any;
    remoteAddress?: string;
    remotePort?: number;
}

interface UDPOptions {
    addressReuse?: boolean;
    localAddress?: string;
    localPort?: number;
    loopback?: boolean;
    remoteAddress?: string;
    remotePort?: number;
}

interface UIEventInit extends EventInit {
    detail?: number;
    view?: Window | null;
}

interface UniFFIScaffoldingCallResult {
    code: UniFFIScaffoldingCallCode;
    data?: UniFFIScaffoldingType;
    internalErrorMessage?: string;
}

interface UserProximityEventInit extends EventInit {
    near?: boolean;
}

interface UtilityActorsDictionary {
    actorName?: WebIDLUtilityActorName;
}

interface VRDisplayEventInit extends EventInit {
    display: VRDisplay;
    reason?: VRDisplayEventReason;
}

interface VRLayer {
    leftBounds?: number[] | Float32Array;
    rightBounds?: number[] | Float32Array;
    source?: HTMLCanvasElement | null;
}

interface ValidityStateFlags {
    badInput?: boolean;
    customError?: boolean;
    patternMismatch?: boolean;
    rangeOverflow?: boolean;
    rangeUnderflow?: boolean;
    stepMismatch?: boolean;
    tooLong?: boolean;
    tooShort?: boolean;
    typeMismatch?: boolean;
    valueMissing?: boolean;
}

interface VideoColorSpaceInit {
    fullRange?: boolean | null;
    matrix?: VideoMatrixCoefficients | null;
    primaries?: VideoColorPrimaries | null;
    transfer?: VideoTransferCharacteristics | null;
}

interface VideoConfiguration {
    bitrate: number;
    colorGamut?: ColorGamut;
    contentType: string;
    framerate: number;
    hasAlphaChannel?: boolean;
    hdrMetadataType?: HdrMetadataType;
    height: number;
    scalabilityMode?: string;
    transferFunction?: TransferFunction;
    width: number;
}

interface VideoDecoderConfig {
    codec: string;
    codedHeight?: number;
    codedWidth?: number;
    colorSpace?: VideoColorSpaceInit;
    description?: ArrayBufferView | ArrayBuffer;
    displayAspectHeight?: number;
    displayAspectWidth?: number;
    hardwareAcceleration?: HardwareAcceleration;
    optimizeForLatency?: boolean;
}

interface VideoDecoderInit {
    error: WebCodecsErrorCallback;
    output: VideoFrameOutputCallback;
}

interface VideoDecoderSupport {
    config?: VideoDecoderConfig;
    supported?: boolean;
}

interface VideoEncoderConfig {
    alpha?: AlphaOption;
    avc?: AvcEncoderConfig;
    bitrate?: number;
    bitrateMode?: VideoEncoderBitrateMode;
    codec: string;
    contentHint?: string;
    displayHeight?: number;
    displayWidth?: number;
    framerate?: number;
    hardwareAcceleration?: HardwareAcceleration;
    height: number;
    latencyMode?: LatencyMode;
    scalabilityMode?: string;
    width: number;
}

interface VideoEncoderEncodeOptions {
    avc?: VideoEncoderEncodeOptionsForAvc;
    keyFrame?: boolean;
}

interface VideoEncoderEncodeOptionsForAvc {
    quantizer?: number | null;
}

interface VideoEncoderInit {
    error: WebCodecsErrorCallback;
    output: EncodedVideoChunkOutputCallback;
}

interface VideoEncoderSupport {
    config?: VideoEncoderConfig;
    supported?: boolean;
}

interface VideoFrameBufferInit {
    codedHeight: number;
    codedWidth: number;
    colorSpace?: VideoColorSpaceInit;
    displayHeight?: number;
    displayWidth?: number;
    duration?: number;
    format: VideoPixelFormat;
    layout?: PlaneLayout[];
    timestamp: number;
    visibleRect?: DOMRectInit;
}

interface VideoFrameCopyToOptions {
    layout?: PlaneLayout[];
    rect?: DOMRectInit;
}

interface VideoFrameInit {
    alpha?: AlphaOption;
    displayHeight?: number;
    displayWidth?: number;
    duration?: number;
    timestamp?: number;
    visibleRect?: DOMRectInit;
}

interface VideoSinkDebugInfo {
    endPromiseHolderIsEmpty?: boolean;
    finished?: boolean;
    hasVideo?: boolean;
    isPlaying?: boolean;
    isStarted?: boolean;
    size?: number;
    videoFrameEndTime?: number;
    videoSinkEndRequestExists?: boolean;
}

interface WaveShaperOptions extends AudioNodeOptions {
    curve?: number[] | Float32Array;
    oversample?: OverSampleType;
}

interface WebAccessibleResourceInit {
    extension_ids?: string[] | null;
    matches?: MatchPatternSetOrStringSequence | null;
    resources: MatchGlobOrString[];
}

interface WebExtensionContentScriptInit extends MozDocumentMatcherInit {
    cssPaths?: string[];
    jsPaths?: string[];
    runAt?: ContentScriptRunAt;
}

interface WebExtensionInit {
    allowedOrigins: MatchPatternSetOrStringSequence;
    backgroundScripts?: string[] | null;
    backgroundTypeModule?: boolean;
    backgroundWorkerScript?: string | null;
    baseURL: string;
    contentScripts?: WebExtensionContentScriptInit[];
    extensionPageCSP?: string | null;
    id: string;
    ignoreQuarantine?: boolean;
    isPrivileged?: boolean;
    localizeCallback: WebExtensionLocalizeCallback;
    manifestVersion?: number;
    mozExtensionHostname: string;
    name?: string;
    permissions?: string[];
    readyPromise?: Promise<WebExtensionPolicy | null>;
    temporarilyInstalled?: boolean;
    type?: string;
    webAccessibleResources?: WebAccessibleResourceInit[];
}

interface WebGLContextAttributes {
    alpha?: GLboolean;
    antialias?: GLboolean;
    colorSpace?: PredefinedColorSpace;
    depth?: GLboolean;
    failIfMajorPerformanceCaveat?: GLboolean;
    powerPreference?: WebGLPowerPreference;
    premultipliedAlpha?: GLboolean;
    preserveDrawingBuffer?: GLboolean;
    stencil?: GLboolean;
    xrCompatible?: boolean;
}

interface WebGLContextEventInit extends EventInit {
    statusMessage?: string;
}

interface WebTransportCloseInfo {
    closeCode?: number;
    reason?: UTF8String;
}

interface WebTransportDatagramStats {
    droppedIncoming?: number;
    expiredOutgoing?: number;
    lostOutgoing?: number;
    timestamp?: DOMHighResTimeStamp;
}

interface WebTransportErrorInit {
    message?: string;
    streamErrorCode?: number;
}

interface WebTransportHash {
    algorithm?: string;
    value?: BufferSource;
}

interface WebTransportOptions {
    allowPooling?: boolean;
    congestionControl?: WebTransportCongestionControl;
    requireUnreliable?: boolean;
    serverCertificateHashes?: WebTransportHash[];
}

interface WebTransportReceiveStreamStats {
    bytesRead?: number;
    bytesReceived?: number;
    timestamp?: DOMHighResTimeStamp;
}

interface WebTransportSendStreamOptions {
    sendOrder?: number | null;
}

interface WebTransportSendStreamStats {
    bytesAcknowledged?: number;
    bytesSent?: number;
    bytesWritten?: number;
    timestamp?: DOMHighResTimeStamp;
}

interface WebTransportStats {
    bytesReceived?: number;
    bytesSent?: number;
    datagrams?: WebTransportDatagramStats;
    minRtt?: DOMHighResTimeStamp;
    numIncomingStreamsCreated?: number;
    numOutgoingStreamsCreated?: number;
    packetsLost?: number;
    packetsReceived?: number;
    packetsSent?: number;
    rttVariation?: DOMHighResTimeStamp;
    smoothedRtt?: DOMHighResTimeStamp;
    timestamp?: DOMHighResTimeStamp;
}

interface WebrtcGlobalMediaContext {
    hasH264Hardware: boolean;
}

interface WebrtcGlobalStatisticsReport {
    reports?: RTCStatsReportInternal[];
    sdpHistories?: RTCSdpHistoryInternal[];
}

interface WheelEventInit extends MouseEventInit {
    deltaMode?: number;
    deltaX?: number;
    deltaY?: number;
    deltaZ?: number;
}

interface WindowActorChildOptions extends WindowActorSidedOptions {
    events?: Record<string, WindowActorEventListenerOptions>;
    observers?: string[];
}

interface WindowActorEventListenerOptions extends AddEventListenerOptions {
    createActor?: boolean;
}

interface WindowActorOptions {
    allFrames?: boolean;
    child?: WindowActorChildOptions;
    includeChrome?: boolean;
    matches?: string[];
    messageManagerGroups?: string[];
    parent?: WindowActorSidedOptions;
    remoteTypes?: UTF8String[];
}

interface WindowActorSidedOptions {
    esModuleURI?: string;
    moduleURI?: string;
}

interface WindowInfoDictionary {
    documentTitle?: string;
    documentURI?: URI | null;
    isInProcess?: boolean;
    isProcessRoot?: boolean;
    outerWindowId?: number;
}

interface WindowPostMessageOptions extends StructuredSerializeOptions {
    targetOrigin?: string;
}

interface WindowsFileAttributes {
    hidden?: boolean;
    readOnly?: boolean;
    system?: boolean;
}

interface Wireframe {
    canvasBackground?: number;
    rects?: WireframeTaggedRect[];
    version?: number;
}

interface WireframeTaggedRect {
    color?: number;
    height?: number;
    node?: Node | null;
    type?: WireframeRectType;
    width?: number;
    x?: number;
    y?: number;
}

interface WorkerOptions {
    credentials?: RequestCredentials;
    name?: string;
    type?: WorkerType;
}

interface WorkletOptions {
    credentials?: RequestCredentials;
}

interface WriteOptions {
    backupFile?: string;
    compress?: boolean;
    flush?: boolean;
    mode?: WriteMode;
    tmpPath?: string;
}

interface WriteParams {
    data?: BufferSource | Blob | UTF8String | null;
    position?: number | null;
    size?: number | null;
    type: WriteCommandType;
}

interface XRInputSourceEventInit extends EventInit {
    frame: XRFrame;
    inputSource: XRInputSource;
}

interface XRInputSourcesChangeEventInit extends EventInit {
    added: XRInputSource[];
    removed: XRInputSource[];
    session: XRSession;
}

interface XRReferenceSpaceEventInit extends EventInit {
    referenceSpace: XRReferenceSpace;
    transform?: XRRigidTransform | null;
}

interface XRRenderStateInit {
    baseLayer?: XRWebGLLayer | null;
    depthFar?: number;
    depthNear?: number;
    inlineVerticalFieldOfView?: number;
}

interface XRSessionEventInit extends EventInit {
    session: XRSession;
}

interface XRSessionInit {
    optionalFeatures?: any[];
    requiredFeatures?: any[];
}

interface XRWebGLLayerInit {
    alpha?: boolean;
    antialias?: boolean;
    depth?: boolean;
    framebufferScaleFactor?: number;
    ignoreDepthValues?: boolean;
    stencil?: boolean;
}

interface addonInstallOptions {
    hash?: string | null;
    url: string;
}

type EventListener = ((event: Event) => void) | { handleEvent(event: Event): void; };

type MessageListener = ((argument: ReceiveMessageArgument) => any) | { receiveMessage(argument: ReceiveMessageArgument): any; };

type MozDocumentCallback = ((matcher: MozDocumentMatcher, window: WindowProxy) => void) | { onNewDocument(matcher: MozDocumentMatcher, window: WindowProxy): void; };

type NodeFilter = ((node: Node) => number) | { acceptNode(node: Node): number; };

declare var NodeFilter: {
    readonly FILTER_ACCEPT: 1;
    readonly FILTER_REJECT: 2;
    readonly FILTER_SKIP: 3;
    readonly SHOW_ALL: 0xFFFFFFFF;
    readonly SHOW_ELEMENT: 0x1;
    readonly SHOW_ATTRIBUTE: 0x2;
    readonly SHOW_TEXT: 0x4;
    readonly SHOW_CDATA_SECTION: 0x8;
    readonly SHOW_ENTITY_REFERENCE: 0x10;
    readonly SHOW_ENTITY: 0x20;
    readonly SHOW_PROCESSING_INSTRUCTION: 0x40;
    readonly SHOW_COMMENT: 0x80;
    readonly SHOW_DOCUMENT: 0x100;
    readonly SHOW_DOCUMENT_TYPE: 0x200;
    readonly SHOW_DOCUMENT_FRAGMENT: 0x400;
    readonly SHOW_NOTATION: 0x800;
};

type ObserverCallback = ((observer: FetchObserver) => void) | { handleEvent(observer: FetchObserver): void; };

type UncaughtRejectionObserver = ((p: any) => boolean) | { onLeftUncaught(p: any): boolean; };

type XPathNSResolver = ((prefix: string | null) => string | null) | { lookupNamespaceURI(prefix: string | null): string | null; };

/**
 * The ANGLE_instanced_arrays extension is part of the WebGL API and allows to draw the same object, or groups of similar objects multiple times, if they share the same vertex data, primitive count and type.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ANGLE_instanced_arrays)
 */
interface ANGLE_instanced_arrays {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ANGLE_instanced_arrays/drawArraysInstancedANGLE) */
    drawArraysInstancedANGLE(mode: GLenum, first: GLint, count: GLsizei, primcount: GLsizei): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ANGLE_instanced_arrays/drawElementsInstancedANGLE) */
    drawElementsInstancedANGLE(mode: GLenum, count: GLsizei, type: GLenum, offset: GLintptr, primcount: GLsizei): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ANGLE_instanced_arrays/vertexAttribDivisorANGLE) */
    vertexAttribDivisorANGLE(index: GLuint, divisor: GLuint): void;
    readonly VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE: 0x88FE;
}

/**
 * A controller object that allows you to abort one or more DOM requests as and when desired.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortController)
 */
interface AbortController {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortController/signal) */
    readonly signal: AbortSignal;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortController/abort) */
    abort(reason?: any): void;
}

declare var AbortController: {
    prototype: AbortController;
    new(): AbortController;
    isInstance(obj): obj is AbortController;
};

interface AbortSignalEventMap {
    "abort": Event;
}

/**
 * A signal object that allows you to communicate with a DOM request (such as a Fetch) and abort it if required via an AbortController object.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal)
 */
interface AbortSignal extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal/aborted) */
    readonly aborted: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal/abort_event) */
    onabort: ((this: AbortSignal, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal/reason) */
    readonly reason: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal/throwIfAborted) */
    throwIfAborted(): void;
    addEventListener<K extends keyof AbortSignalEventMap>(type: K, listener: (this: AbortSignal, ev: AbortSignalEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof AbortSignalEventMap>(type: K, listener: (this: AbortSignal, ev: AbortSignalEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var AbortSignal: {
    prototype: AbortSignal;
    new(): AbortSignal;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal/abort_static) */
    abort(reason?: any): AbortSignal;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal/timeout_static) */
    timeout(milliseconds: number): AbortSignal;
    isInstance(obj): obj is AbortSignal;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbstractRange) */
interface AbstractRange {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbstractRange/collapsed) */
    readonly collapsed: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbstractRange/endContainer) */
    readonly endContainer: Node;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbstractRange/endOffset) */
    readonly endOffset: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbstractRange/startContainer) */
    readonly startContainer: Node;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbstractRange/startOffset) */
    readonly startOffset: number;
}

declare var AbstractRange: {
    prototype: AbstractRange;
    new(): AbstractRange;
    isInstance(obj): obj is AbstractRange;
};

interface AbstractWorkerEventMap {
    "error": ErrorEvent;
}

interface AbstractWorker {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ServiceWorker/error_event) */
    onerror: OnErrorEventHandler;
    addEventListener<K extends keyof AbstractWorkerEventMap>(type: K, listener: (this: AbstractWorker, ev: AbstractWorkerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof AbstractWorkerEventMap>(type: K, listener: (this: AbstractWorker, ev: AbstractWorkerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

interface AccessibilityRole {
    role: string | null;
}

interface AccessibleNode {
    readonly DOMNode: Node | null;
    activeDescendant: AccessibleNode | null;
    atomic: boolean | null;
    readonly attributes: string[];
    autocomplete: string | null;
    busy: boolean | null;
    checked: string | null;
    colCount: number | null;
    colIndex: number | null;
    colSpan: number | null;
    readonly computedRole: string;
    current: string | null;
    details: AccessibleNode | null;
    disabled: boolean | null;
    errorMessage: AccessibleNode | null;
    expanded: boolean | null;
    hasPopUp: string | null;
    hidden: boolean | null;
    invalid: string | null;
    keyShortcuts: string | null;
    label: string | null;
    level: number | null;
    live: string | null;
    modal: boolean | null;
    multiline: boolean | null;
    multiselectable: boolean | null;
    orientation: string | null;
    placeholder: string | null;
    posInSet: number | null;
    pressed: string | null;
    readOnly: boolean | null;
    relevant: string | null;
    required: boolean | null;
    role: string | null;
    roleDescription: string | null;
    rowCount: number | null;
    rowIndex: number | null;
    rowSpan: number | null;
    selected: boolean | null;
    setSize: number | null;
    sort: string | null;
    readonly states: string[];
    valueMax: number | null;
    valueMin: number | null;
    valueNow: number | null;
    valueText: string | null;
    get(attribute: string): any;
    has(...attributes: string[]): boolean;
    is(...states: string[]): boolean;
}

declare var AccessibleNode: {
    prototype: AccessibleNode;
    new(): AccessibleNode;
    isInstance(obj): obj is AccessibleNode;
};

interface Addon {
    readonly canUninstall: boolean;
    readonly description: string;
    readonly id: string;
    readonly isActive: boolean;
    readonly isEnabled: boolean;
    readonly name: string;
    readonly type: string;
    readonly version: string;
    setEnabled(value: boolean): Promise<void>;
    uninstall(): Promise<boolean>;
}

declare var Addon: {
    prototype: Addon;
    new(): Addon;
    isInstance(obj): obj is Addon;
};

interface AddonEvent extends Event {
    readonly id: string;
}

declare var AddonEvent: {
    prototype: AddonEvent;
    new(type: string, eventInitDict: AddonEventInit): AddonEvent;
    isInstance(obj): obj is AddonEvent;
};

interface AddonInstall extends EventTarget {
    "error": ErrorEvent;
    readonly maxProgress: number;
    readonly progress: number;
    readonly state: string;
    cancel(): Promise<void>;
    install(): Promise<void>;
}

declare var AddonInstall: {
    prototype: AddonInstall;
    new(): AddonInstall;
    isInstance(obj): obj is AddonInstall;
};

interface AddonManager extends EventTarget {
    readonly abuseReportPanelEnabled: boolean;
    createInstall(options?: addonInstallOptions): Promise<AddonInstall>;
    getAddonByID(id: string): Promise<Addon>;
    reportAbuse(id: string): Promise<boolean>;
}

declare var AddonManager: {
    prototype: AddonManager;
    new(): AddonManager;
    isInstance(obj): obj is AddonManager;
};

/**
 * A node able to provide real-time frequency and time-domain analysis information. It is an AudioNode that passes the audio stream unchanged from the input to the output, but allows you to take the generated data, process it, and create audio visualizations.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode)
 */
interface AnalyserNode extends AudioNode, AudioNodePassThrough {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/fftSize) */
    fftSize: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/frequencyBinCount) */
    readonly frequencyBinCount: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/maxDecibels) */
    maxDecibels: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/minDecibels) */
    minDecibels: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/smoothingTimeConstant) */
    smoothingTimeConstant: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/getByteFrequencyData) */
    getByteFrequencyData(array: Uint8Array): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/getByteTimeDomainData) */
    getByteTimeDomainData(array: Uint8Array): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/getFloatFrequencyData) */
    getFloatFrequencyData(array: Float32Array): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/getFloatTimeDomainData) */
    getFloatTimeDomainData(array: Float32Array): void;
}

declare var AnalyserNode: {
    prototype: AnalyserNode;
    new(context: BaseAudioContext, options?: AnalyserOptions): AnalyserNode;
    isInstance(obj): obj is AnalyserNode;
};

interface Animatable {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animate) */
    animate(keyframes: any, options?: UnrestrictedDoubleOrKeyframeAnimationOptions): Animation;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getAnimations) */
    getAnimations(options?: GetAnimationsOptions): Animation[];
}

interface AnimationEventMap {
    "cancel": Event;
    "finish": Event;
    "remove": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation) */
interface Animation extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/currentTime) */
    currentTime: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/effect) */
    effect: AnimationEffect | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/finished) */
    readonly finished: Promise<Animation>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/id) */
    id: string;
    readonly isRunningOnCompositor: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/cancel_event) */
    oncancel: ((this: Animation, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/finish_event) */
    onfinish: ((this: Animation, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/remove_event) */
    onremove: ((this: Animation, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/pending) */
    readonly pending: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/playState) */
    readonly playState: AnimationPlayState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/playbackRate) */
    playbackRate: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/ready) */
    readonly ready: Promise<Animation>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/replaceState) */
    readonly replaceState: AnimationReplaceState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/startTime) */
    startTime: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/timeline) */
    timeline: AnimationTimeline | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/cancel) */
    cancel(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/commitStyles) */
    commitStyles(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/finish) */
    finish(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/pause) */
    pause(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/persist) */
    persist(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/play) */
    play(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/reverse) */
    reverse(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/updatePlaybackRate) */
    updatePlaybackRate(playbackRate: number): void;
    addEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: Animation, ev: AnimationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: Animation, ev: AnimationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var Animation: {
    prototype: Animation;
    new(effect?: AnimationEffect | null, timeline?: AnimationTimeline | null): Animation;
    isInstance(obj): obj is Animation;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEffect) */
interface AnimationEffect {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEffect/getComputedTiming) */
    getComputedTiming(): ComputedEffectTiming;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEffect/getTiming) */
    getTiming(): EffectTiming;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEffect/updateTiming) */
    updateTiming(timing?: OptionalEffectTiming): void;
}

declare var AnimationEffect: {
    prototype: AnimationEffect;
    new(): AnimationEffect;
    isInstance(obj): obj is AnimationEffect;
};

/**
 * Events providing information related to animations.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEvent)
 */
interface AnimationEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEvent/animationName) */
    readonly animationName: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEvent/elapsedTime) */
    readonly elapsedTime: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEvent/pseudoElement) */
    readonly pseudoElement: string;
}

declare var AnimationEvent: {
    prototype: AnimationEvent;
    new(type: string, eventInitDict?: AnimationEventInit): AnimationEvent;
    isInstance(obj): obj is AnimationEvent;
};

interface AnimationFrameProvider {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DedicatedWorkerGlobalScope/cancelAnimationFrame) */
    cancelAnimationFrame(handle: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DedicatedWorkerGlobalScope/requestAnimationFrame) */
    requestAnimationFrame(callback: FrameRequestCallback): number;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationPlaybackEvent) */
interface AnimationPlaybackEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationPlaybackEvent/currentTime) */
    readonly currentTime: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationPlaybackEvent/timelineTime) */
    readonly timelineTime: number | null;
}

declare var AnimationPlaybackEvent: {
    prototype: AnimationPlaybackEvent;
    new(type: string, eventInitDict?: AnimationPlaybackEventInit): AnimationPlaybackEvent;
    isInstance(obj): obj is AnimationPlaybackEvent;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationTimeline) */
interface AnimationTimeline {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationTimeline/currentTime) */
    readonly currentTime: number | null;
}

declare var AnimationTimeline: {
    prototype: AnimationTimeline;
    new(): AnimationTimeline;
    isInstance(obj): obj is AnimationTimeline;
};

interface AnonymousContent {
    readonly root: ShadowRoot;
}

declare var AnonymousContent: {
    prototype: AnonymousContent;
    new(): AnonymousContent;
    isInstance(obj): obj is AnonymousContent;
};

interface AriaAttributes {
    ariaAtomic: string | null;
    ariaAutoComplete: string | null;
    ariaBusy: string | null;
    ariaChecked: string | null;
    ariaColCount: string | null;
    ariaColIndex: string | null;
    ariaColIndexText: string | null;
    ariaColSpan: string | null;
    ariaCurrent: string | null;
    ariaDescription: string | null;
    ariaDisabled: string | null;
    ariaExpanded: string | null;
    ariaHasPopup: string | null;
    ariaHidden: string | null;
    ariaInvalid: string | null;
    ariaKeyShortcuts: string | null;
    ariaLabel: string | null;
    ariaLevel: string | null;
    ariaLive: string | null;
    ariaModal: string | null;
    ariaMultiLine: string | null;
    ariaMultiSelectable: string | null;
    ariaOrientation: string | null;
    ariaPlaceholder: string | null;
    ariaPosInSet: string | null;
    ariaPressed: string | null;
    ariaReadOnly: string | null;
    ariaRelevant: string | null;
    ariaRequired: string | null;
    ariaRoleDescription: string | null;
    ariaRowCount: string | null;
    ariaRowIndex: string | null;
    ariaRowIndexText: string | null;
    ariaRowSpan: string | null;
    ariaSelected: string | null;
    ariaSetSize: string | null;
    ariaSort: string | null;
    ariaValueMax: string | null;
    ariaValueMin: string | null;
    ariaValueNow: string | null;
    ariaValueText: string | null;
}

/**
 * A DOM element's attribute as an object. In most DOM methods, you will probably directly retrieve the attribute as a string (e.g., Element.getAttribute(), but certain functions (e.g., Element.getAttributeNode()) or means of iterating give Attr types.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr)
 */
interface Attr extends Node {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/localName) */
    readonly localName: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/name) */
    readonly name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/namespaceURI) */
    readonly namespaceURI: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/ownerElement) */
    readonly ownerElement: Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/prefix) */
    readonly prefix: string | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/specified)
     */
    readonly specified: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/value) */
    value: string;
}

declare var Attr: {
    prototype: Attr;
    new(): Attr;
    isInstance(obj): obj is Attr;
};

/**
 * A short audio asset residing in memory, created from an audio file using the AudioContext.decodeAudioData() method, or from raw data using AudioContext.createBuffer(). Once put into an AudioBuffer, the audio can then be played by being passed into an AudioBufferSourceNode.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer)
 */
interface AudioBuffer {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/duration) */
    readonly duration: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/numberOfChannels) */
    readonly numberOfChannels: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/sampleRate) */
    readonly sampleRate: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/copyFromChannel) */
    copyFromChannel(destination: Float32Array, channelNumber: number, startInChannel?: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/copyToChannel) */
    copyToChannel(source: Float32Array, channelNumber: number, startInChannel?: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/getChannelData) */
    getChannelData(channel: number): Float32Array;
}

declare var AudioBuffer: {
    prototype: AudioBuffer;
    new(options: AudioBufferOptions): AudioBuffer;
    isInstance(obj): obj is AudioBuffer;
};

/**
 * An AudioScheduledSourceNode which represents an audio source consisting of in-memory audio data, stored in an AudioBuffer. It's especially useful for playing back audio which has particularly stringent timing accuracy requirements, such as for sounds that must match a specific rhythm and can be kept in memory rather than being played from disk or the network.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode)
 */
interface AudioBufferSourceNode extends AudioScheduledSourceNode, AudioNodePassThrough {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/buffer) */
    buffer: AudioBuffer | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/detune) */
    readonly detune: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/loop) */
    loop: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/loopEnd) */
    loopEnd: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/loopStart) */
    loopStart: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/playbackRate) */
    readonly playbackRate: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/start) */
    start(when?: number, grainOffset?: number, grainDuration?: number): void;
    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioBufferSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioBufferSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var AudioBufferSourceNode: {
    prototype: AudioBufferSourceNode;
    new(context: BaseAudioContext, options?: AudioBufferSourceOptions): AudioBufferSourceNode;
    isInstance(obj): obj is AudioBufferSourceNode;
};

/**
 * An audio-processing graph built from audio modules linked together, each represented by an AudioNode.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext)
 */
interface AudioContext extends BaseAudioContext {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/baseLatency) */
    readonly baseLatency: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/outputLatency) */
    readonly outputLatency: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/close) */
    close(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/createMediaElementSource) */
    createMediaElementSource(mediaElement: HTMLMediaElement): MediaElementAudioSourceNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/createMediaStreamDestination) */
    createMediaStreamDestination(): MediaStreamAudioDestinationNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/createMediaStreamSource) */
    createMediaStreamSource(mediaStream: MediaStream): MediaStreamAudioSourceNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/createMediaStreamTrackSource) */
    createMediaStreamTrackSource(mediaStreamTrack: MediaStreamTrack): MediaStreamTrackAudioSourceNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/getOutputTimestamp) */
    getOutputTimestamp(): AudioTimestamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/suspend) */
    suspend(): Promise<void>;
    addEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: AudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: AudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var AudioContext: {
    prototype: AudioContext;
    new(contextOptions?: AudioContextOptions): AudioContext;
    isInstance(obj): obj is AudioContext;
};

/**
 * AudioDestinationNode has no output (as it is the output, no more AudioNode can be linked after it in the audio graph) and one input. The number of channels in the input must be between 0 and the maxChannelCount value or an exception is raised.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDestinationNode)
 */
interface AudioDestinationNode extends AudioNode {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDestinationNode/maxChannelCount) */
    readonly maxChannelCount: number;
}

declare var AudioDestinationNode: {
    prototype: AudioDestinationNode;
    new(): AudioDestinationNode;
    isInstance(obj): obj is AudioDestinationNode;
};

/**
 * The position and orientation of the unique person listening to the audio scene, and is used in audio spatialization. All PannerNodes spatialize in relation to the AudioListener stored in the BaseAudioContext.listener attribute.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener)
 */
interface AudioListener {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener/setOrientation)
     */
    setOrientation(x: number, y: number, z: number, xUp: number, yUp: number, zUp: number): void;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener/setPosition)
     */
    setPosition(x: number, y: number, z: number): void;
}

declare var AudioListener: {
    prototype: AudioListener;
    new(): AudioListener;
    isInstance(obj): obj is AudioListener;
};

/**
 * A generic interface for representing an audio processing module. Examples include:
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode)
 */
interface AudioNode extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/channelCount) */
    channelCount: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/channelCountMode) */
    channelCountMode: ChannelCountMode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/channelInterpretation) */
    channelInterpretation: ChannelInterpretation;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/context) */
    readonly context: BaseAudioContext;
    readonly id: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/numberOfInputs) */
    readonly numberOfInputs: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/numberOfOutputs) */
    readonly numberOfOutputs: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/connect) */
    connect(destination: AudioNode, output?: number, input?: number): AudioNode;
    connect(destination: AudioParam, output?: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/disconnect) */
    disconnect(): void;
    disconnect(output: number): void;
    disconnect(destination: AudioNode): void;
    disconnect(destination: AudioNode, output: number): void;
    disconnect(destination: AudioNode, output: number, input: number): void;
    disconnect(destination: AudioParam): void;
    disconnect(destination: AudioParam, output: number): void;
}

declare var AudioNode: {
    prototype: AudioNode;
    new(): AudioNode;
    isInstance(obj): obj is AudioNode;
};

interface AudioNodePassThrough {
    passThrough: boolean;
}

/**
 * The Web Audio API's AudioParam interface represents an audio-related parameter, usually a parameter of an AudioNode (such as GainNode.gain).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam)
 */
interface AudioParam {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/defaultValue) */
    readonly defaultValue: number;
    readonly isTrackSuspended: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/maxValue) */
    readonly maxValue: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/minValue) */
    readonly minValue: number;
    readonly name: string;
    readonly parentNodeId: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/value) */
    value: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/cancelScheduledValues) */
    cancelScheduledValues(startTime: number): AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/exponentialRampToValueAtTime) */
    exponentialRampToValueAtTime(value: number, endTime: number): AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/linearRampToValueAtTime) */
    linearRampToValueAtTime(value: number, endTime: number): AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/setTargetAtTime) */
    setTargetAtTime(target: number, startTime: number, timeConstant: number): AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/setValueAtTime) */
    setValueAtTime(value: number, startTime: number): AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/setValueCurveAtTime) */
    setValueCurveAtTime(values: number[] | Float32Array, startTime: number, duration: number): AudioParam;
}

declare var AudioParam: {
    prototype: AudioParam;
    new(): AudioParam;
    isInstance(obj): obj is AudioParam;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParamMap)
 */
interface AudioParamMap {
    forEach(callbackfn: (value: AudioParam, key: string, parent: AudioParamMap) => void, thisArg?: any): void;
}

declare var AudioParamMap: {
    prototype: AudioParamMap;
    new(): AudioParamMap;
    isInstance(obj): obj is AudioParamMap;
};

/**
 * The Web Audio API events that occur when a ScriptProcessorNode input buffer is ready to be processed.
 * @deprecated As of the August 29 2014 Web Audio API spec publication, this feature has been marked as deprecated, and is soon to be replaced by AudioWorklet.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioProcessingEvent)
 */
interface AudioProcessingEvent extends Event {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioProcessingEvent/inputBuffer)
     */
    readonly inputBuffer: AudioBuffer;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioProcessingEvent/outputBuffer)
     */
    readonly outputBuffer: AudioBuffer;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioProcessingEvent/playbackTime)
     */
    readonly playbackTime: number;
}

/** @deprecated */
declare var AudioProcessingEvent: {
    prototype: AudioProcessingEvent;
    new(): AudioProcessingEvent;
    isInstance(obj): obj is AudioProcessingEvent;
};

interface AudioScheduledSourceNodeEventMap {
    "ended": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioScheduledSourceNode) */
interface AudioScheduledSourceNode extends AudioNode {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioScheduledSourceNode/ended_event) */
    onended: ((this: AudioScheduledSourceNode, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioScheduledSourceNode/start) */
    start(when?: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioScheduledSourceNode/stop) */
    stop(when?: number): void;
    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioScheduledSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioScheduledSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var AudioScheduledSourceNode: {
    prototype: AudioScheduledSourceNode;
    new(): AudioScheduledSourceNode;
    isInstance(obj): obj is AudioScheduledSourceNode;
};

/**
 * A single audio track from one of the HTML media elements, <audio> or <video>.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioTrack)
 */
interface AudioTrack {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioTrack/enabled) */
    enabled: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioTrack/id) */
    readonly id: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioTrack/kind) */
    readonly kind: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioTrack/label) */
    readonly label: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioTrack/language) */
    readonly language: string;
}

declare var AudioTrack: {
    prototype: AudioTrack;
    new(): AudioTrack;
    isInstance(obj): obj is AudioTrack;
};

interface AudioTrackListEventMap {
    "addtrack": Event;
    "change": Event;
    "removetrack": Event;
}

/**
 * Used to represent a list of the audio tracks contained within a given HTML media element, with each track represented by a separate AudioTrack object in the list.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioTrackList)
 */
interface AudioTrackList extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioTrackList/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioTrackList/addtrack_event) */
    onaddtrack: ((this: AudioTrackList, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioTrackList/change_event) */
    onchange: ((this: AudioTrackList, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioTrackList/removetrack_event) */
    onremovetrack: ((this: AudioTrackList, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioTrackList/getTrackById) */
    getTrackById(id: string): AudioTrack | null;
    addEventListener<K extends keyof AudioTrackListEventMap>(type: K, listener: (this: AudioTrackList, ev: AudioTrackListEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof AudioTrackListEventMap>(type: K, listener: (this: AudioTrackList, ev: AudioTrackListEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
    [index: number]: AudioTrack;
}

declare var AudioTrackList: {
    prototype: AudioTrackList;
    new(): AudioTrackList;
    isInstance(obj): obj is AudioTrackList;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorklet)
 */
interface AudioWorklet extends Worklet {
}

declare var AudioWorklet: {
    prototype: AudioWorklet;
    new(): AudioWorklet;
    isInstance(obj): obj is AudioWorklet;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletGlobalScope) */
interface AudioWorkletGlobalScope extends WorkletGlobalScope {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletGlobalScope/currentFrame) */
    readonly currentFrame: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletGlobalScope/currentTime) */
    readonly currentTime: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletGlobalScope/sampleRate) */
    readonly sampleRate: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletGlobalScope/registerProcessor) */
    registerProcessor(name: string, processorCtor: AudioWorkletProcessorConstructor): void;
}

declare var AudioWorkletGlobalScope: {
    prototype: AudioWorkletGlobalScope;
    new(): AudioWorkletGlobalScope;
    isInstance(obj): obj is AudioWorkletGlobalScope;
};

interface AudioWorkletNodeEventMap {
    "processorerror": Event;
}

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletNode)
 */
interface AudioWorkletNode extends AudioNode {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletNode/processorerror_event) */
    onprocessorerror: ((this: AudioWorkletNode, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletNode/parameters) */
    readonly parameters: AudioParamMap;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletNode/port) */
    readonly port: MessagePort;
    addEventListener<K extends keyof AudioWorkletNodeEventMap>(type: K, listener: (this: AudioWorkletNode, ev: AudioWorkletNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof AudioWorkletNodeEventMap>(type: K, listener: (this: AudioWorkletNode, ev: AudioWorkletNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var AudioWorkletNode: {
    prototype: AudioWorkletNode;
    new(context: BaseAudioContext, name: string, options?: AudioWorkletNodeOptions): AudioWorkletNode;
    isInstance(obj): obj is AudioWorkletNode;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletProcessor) */
interface AudioWorkletProcessor {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletProcessor/port) */
    readonly port: MessagePort;
}

declare var AudioWorkletProcessor: {
    prototype: AudioWorkletProcessor;
    new(): AudioWorkletProcessor;
    isInstance(obj): obj is AudioWorkletProcessor;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAssertionResponse)
 */
interface AuthenticatorAssertionResponse extends AuthenticatorResponse {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAssertionResponse/authenticatorData) */
    readonly authenticatorData: ArrayBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAssertionResponse/signature) */
    readonly signature: ArrayBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAssertionResponse/userHandle) */
    readonly userHandle: ArrayBuffer | null;
}

declare var AuthenticatorAssertionResponse: {
    prototype: AuthenticatorAssertionResponse;
    new(): AuthenticatorAssertionResponse;
    isInstance(obj): obj is AuthenticatorAssertionResponse;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAttestationResponse)
 */
interface AuthenticatorAttestationResponse extends AuthenticatorResponse {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAttestationResponse/attestationObject) */
    readonly attestationObject: ArrayBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAttestationResponse/getAuthenticatorData) */
    getAuthenticatorData(): ArrayBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAttestationResponse/getPublicKey) */
    getPublicKey(): ArrayBuffer | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAttestationResponse/getPublicKeyAlgorithm) */
    getPublicKeyAlgorithm(): COSEAlgorithmIdentifier;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAttestationResponse/getTransports) */
    getTransports(): string[];
}

declare var AuthenticatorAttestationResponse: {
    prototype: AuthenticatorAttestationResponse;
    new(): AuthenticatorAttestationResponse;
    isInstance(obj): obj is AuthenticatorAttestationResponse;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorResponse)
 */
interface AuthenticatorResponse {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorResponse/clientDataJSON) */
    readonly clientDataJSON: ArrayBuffer;
}

declare var AuthenticatorResponse: {
    prototype: AuthenticatorResponse;
    new(): AuthenticatorResponse;
    isInstance(obj): obj is AuthenticatorResponse;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BarProp) */
interface BarProp {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BarProp/visible) */
    visible: boolean;
}

declare var BarProp: {
    prototype: BarProp;
    new(): BarProp;
    isInstance(obj): obj is BarProp;
};

interface BaseAudioContextEventMap {
    "statechange": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext) */
interface BaseAudioContext extends EventTarget {
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/audioWorklet)
     */
    readonly audioWorklet: AudioWorklet;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/currentTime) */
    readonly currentTime: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/destination) */
    readonly destination: AudioDestinationNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/listener) */
    readonly listener: AudioListener;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/statechange_event) */
    onstatechange: ((this: BaseAudioContext, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/sampleRate) */
    readonly sampleRate: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/state) */
    readonly state: AudioContextState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createAnalyser) */
    createAnalyser(): AnalyserNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createBiquadFilter) */
    createBiquadFilter(): BiquadFilterNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createBuffer) */
    createBuffer(numberOfChannels: number, length: number, sampleRate: number): AudioBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createBufferSource) */
    createBufferSource(): AudioBufferSourceNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createChannelMerger) */
    createChannelMerger(numberOfInputs?: number): ChannelMergerNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createChannelSplitter) */
    createChannelSplitter(numberOfOutputs?: number): ChannelSplitterNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createConstantSource) */
    createConstantSource(): ConstantSourceNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createConvolver) */
    createConvolver(): ConvolverNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createDelay) */
    createDelay(maxDelayTime?: number): DelayNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createDynamicsCompressor) */
    createDynamicsCompressor(): DynamicsCompressorNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createGain) */
    createGain(): GainNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createIIRFilter) */
    createIIRFilter(feedforward: number[], feedback: number[]): IIRFilterNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createOscillator) */
    createOscillator(): OscillatorNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createPanner) */
    createPanner(): PannerNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createPeriodicWave) */
    createPeriodicWave(real: number[] | Float32Array, imag: number[] | Float32Array, constraints?: PeriodicWaveConstraints): PeriodicWave;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createScriptProcessor)
     */
    createScriptProcessor(bufferSize?: number, numberOfInputChannels?: number, numberOfOutputChannels?: number): ScriptProcessorNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createStereoPanner) */
    createStereoPanner(): StereoPannerNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createWaveShaper) */
    createWaveShaper(): WaveShaperNode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/decodeAudioData) */
    decodeAudioData(audioData: ArrayBuffer, successCallback?: DecodeSuccessCallback, errorCallback?: DecodeErrorCallback): Promise<AudioBuffer>;
    resume(): Promise<void>;
    addEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: BaseAudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: BaseAudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var BaseAudioContext: {
    prototype: BaseAudioContext;
    new(): BaseAudioContext;
    isInstance(obj): obj is BaseAudioContext;
};

interface BatteryManagerEventMap {
    "chargingchange": Event;
    "chargingtimechange": Event;
    "dischargingtimechange": Event;
    "levelchange": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BatteryManager) */
interface BatteryManager extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BatteryManager/charging) */
    readonly charging: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BatteryManager/chargingTime) */
    readonly chargingTime: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BatteryManager/dischargingTime) */
    readonly dischargingTime: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BatteryManager/level) */
    readonly level: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BatteryManager/chargingchange_event) */
    onchargingchange: ((this: BatteryManager, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BatteryManager/chargingtimechange_event) */
    onchargingtimechange: ((this: BatteryManager, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BatteryManager/dischargingtimechange_event) */
    ondischargingtimechange: ((this: BatteryManager, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BatteryManager/levelchange_event) */
    onlevelchange: ((this: BatteryManager, ev: Event) => any) | null;
    addEventListener<K extends keyof BatteryManagerEventMap>(type: K, listener: (this: BatteryManager, ev: BatteryManagerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof BatteryManagerEventMap>(type: K, listener: (this: BatteryManager, ev: BatteryManagerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var BatteryManager: {
    prototype: BatteryManager;
    new(): BatteryManager;
    isInstance(obj): obj is BatteryManager;
};

/**
 * The beforeunload event is fired when the window, the document and its resources are about to be unloaded.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BeforeUnloadEvent)
 */
interface BeforeUnloadEvent extends Event {
    /** @deprecated */
    returnValue: boolean;
}

declare var BeforeUnloadEvent: {
    prototype: BeforeUnloadEvent;
    new(): BeforeUnloadEvent;
    isInstance(obj): obj is BeforeUnloadEvent;
};

/**
 * A simple low-order filter, and is created using the AudioContext.createBiquadFilter() method. It is an AudioNode that can represent different kinds of filters, tone control devices, and graphic equalizers.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode)
 */
interface BiquadFilterNode extends AudioNode, AudioNodePassThrough {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode/Q) */
    readonly Q: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode/detune) */
    readonly detune: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode/frequency) */
    readonly frequency: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode/gain) */
    readonly gain: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode/type) */
    type: BiquadFilterType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode/getFrequencyResponse) */
    getFrequencyResponse(frequencyHz: Float32Array, magResponse: Float32Array, phaseResponse: Float32Array): void;
}

declare var BiquadFilterNode: {
    prototype: BiquadFilterNode;
    new(context: BaseAudioContext, options?: BiquadFilterOptions): BiquadFilterNode;
    isInstance(obj): obj is BiquadFilterNode;
};

/**
 * A file-like object of immutable, raw data. Blobs represent data that isn't necessarily in a JavaScript-native format. The File interface is based on Blob, inheriting blob functionality and expanding it to support files on the user's system.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob)
 */
interface Blob {
    readonly blobImplType: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/size) */
    readonly size: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/type) */
    readonly type: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/arrayBuffer) */
    arrayBuffer(): Promise<ArrayBuffer>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/slice) */
    slice(start?: number, end?: number, contentType?: string): Blob;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/stream) */
    stream(): ReadableStream;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/text) */
    text(): Promise<string>;
}

declare var Blob: {
    prototype: Blob;
    new(blobParts?: BlobPart[], options?: BlobPropertyBag): Blob;
    isInstance(obj): obj is Blob;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BlobEvent) */
interface BlobEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BlobEvent/data) */
    readonly data: Blob;
}

declare var BlobEvent: {
    prototype: BlobEvent;
    new(type: string, eventInitDict: BlobEventInit): BlobEvent;
    isInstance(obj): obj is BlobEvent;
};

interface Body {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/bodyUsed) */
    readonly bodyUsed: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/arrayBuffer) */
    arrayBuffer(): Promise<ArrayBuffer>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/blob) */
    blob(): Promise<Blob>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/formData) */
    formData(): Promise<FormData>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/json) */
    json(): Promise<JSON>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/text) */
    text(): Promise<string>;
}

interface BroadcastChannelEventMap {
    "message": Event;
    "messageerror": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BroadcastChannel) */
interface BroadcastChannel extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BroadcastChannel/name) */
    readonly name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BroadcastChannel/message_event) */
    onmessage: ((this: BroadcastChannel, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BroadcastChannel/messageerror_event) */
    onmessageerror: ((this: BroadcastChannel, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BroadcastChannel/close) */
    close(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BroadcastChannel/postMessage) */
    postMessage(message: any): void;
    addEventListener<K extends keyof BroadcastChannelEventMap>(type: K, listener: (this: BroadcastChannel, ev: BroadcastChannelEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof BroadcastChannelEventMap>(type: K, listener: (this: BroadcastChannel, ev: BroadcastChannelEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var BroadcastChannel: {
    prototype: BroadcastChannel;
    new(channel: string): BroadcastChannel;
    isInstance(obj): obj is BroadcastChannel;
};

interface BrowsingContext extends LoadContextMixin {
    allowJavascript: boolean;
    readonly ancestorsAreCurrent: boolean;
    authorStyleDisabledDefault: boolean;
    browserId: number;
    readonly childOffset: number;
    readonly childSessionHistory: ChildSHistory | null;
    readonly children: BrowsingContext[];
    readonly createdDynamically: boolean;
    readonly currentWindowContext: WindowContext | null;
    customPlatform: string;
    customUserAgent: string;
    defaultLoadFlags: number;
    displayMode: DisplayMode;
    readonly docShell: nsIDocShell | null;
    readonly embedderElement: XULFrameElement | null;
    readonly embedderElementType: string;
    forceDesktopViewport: boolean;
    forceOffline: boolean;
    fullZoom: number;
    readonly group: BrowsingContextGroup;
    hasSiblings: boolean;
    readonly historyID: any;
    readonly id: number;
    inRDMPane: boolean;
    isActive: boolean;
    isAppTab: boolean;
    readonly isDiscarded: boolean;
    readonly isInBFCache: boolean;
    mediumOverride: string;
    readonly name: string;
    readonly opener: BrowsingContext | null;
    overrideDPPX: number;
    readonly parent: BrowsingContext | null;
    readonly parentWindowContext: WindowContext | null;
    prefersColorSchemeOverride: PrefersColorSchemeOverride;
    sandboxFlags: number;
    serviceWorkersTestingEnabled: boolean;
    suspendMediaWhenInactive: boolean;
    readonly targetTopLevelLinkClicksToBlank: boolean;
    textZoom: number;
    readonly top: BrowsingContext;
    readonly topWindowContext: WindowContext | null;
    readonly touchEventsOverride: TouchEventsOverride;
    useGlobalHistory: boolean;
    watchedByDevTools: boolean;
    readonly window: WindowProxy | null;
    getAllBrowsingContextsInSubtree(): BrowsingContext[];
    resetLocationChangeRateLimit(): void;
    setRDMPaneMaxTouchPoints(maxTouchPoints: number): void;
    setRDMPaneOrientation(type: OrientationType, rotationAngle: number): void;
}

declare var BrowsingContext: {
    prototype: BrowsingContext;
    new(): BrowsingContext;
    get(aId: number): CanonicalBrowsingContext | null;
    getCurrentTopByBrowserId(aId: number): BrowsingContext | null;
    getFromWindow(window: WindowProxy): BrowsingContext | null;
    isInstance(obj): obj is BrowsingContext;
};

interface BrowsingContextGroup {
    readonly id: number;
    getToplevels(): BrowsingContext[];
}

declare var BrowsingContextGroup: {
    prototype: BrowsingContextGroup;
    new(): BrowsingContextGroup;
    isInstance(obj): obj is BrowsingContextGroup;
};

/**
 * This Streams API interface provides a built-in byte length queuing strategy that can be used when constructing streams.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ByteLengthQueuingStrategy)
 */
interface ByteLengthQueuingStrategy {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ByteLengthQueuingStrategy/highWaterMark) */
    readonly highWaterMark: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ByteLengthQueuingStrategy/size) */
    readonly size: Function;
}

declare var ByteLengthQueuingStrategy: {
    prototype: ByteLengthQueuingStrategy;
    new(init: QueuingStrategyInit): ByteLengthQueuingStrategy;
    isInstance(obj): obj is ByteLengthQueuingStrategy;
};

/**
 * A CDATA section that can be used within XML to include extended portions of unescaped text. The symbols < and & don’t need escaping as they normally do when inside a CDATA section.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CDATASection)
 */
interface CDATASection extends Text {
}

declare var CDATASection: {
    prototype: CDATASection;
    new(): CDATASection;
    isInstance(obj): obj is CDATASection;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSAnimation) */
interface CSSAnimation extends Animation {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSAnimation/animationName) */
    readonly animationName: string;
    addEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: CSSAnimation, ev: AnimationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: CSSAnimation, ev: AnimationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var CSSAnimation: {
    prototype: CSSAnimation;
    new(): CSSAnimation;
    isInstance(obj): obj is CSSAnimation;
};

/**
 * A single condition CSS at-rule, which consists of a condition and a statement block. It is a child of CSSGroupingRule.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSConditionRule)
 */
interface CSSConditionRule extends CSSGroupingRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSConditionRule/conditionText) */
    readonly conditionText: UTF8String;
}

declare var CSSConditionRule: {
    prototype: CSSConditionRule;
    new(): CSSConditionRule;
    isInstance(obj): obj is CSSConditionRule;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSContainerRule) */
interface CSSContainerRule extends CSSConditionRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSContainerRule/containerName) */
    readonly containerName: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSContainerRule/containerQuery) */
    readonly containerQuery: UTF8String;
    queryContainerFor(element: Element): Element | null;
}

declare var CSSContainerRule: {
    prototype: CSSContainerRule;
    new(): CSSContainerRule;
    isInstance(obj): obj is CSSContainerRule;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule) */
interface CSSCounterStyleRule extends CSSRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/additiveSymbols) */
    additiveSymbols: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/fallback) */
    fallback: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/name) */
    name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/negative) */
    negative: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/pad) */
    pad: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/prefix) */
    prefix: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/range) */
    range: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/speakAs) */
    speakAs: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/suffix) */
    suffix: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/symbols) */
    symbols: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/system) */
    system: UTF8String;
}

declare var CSSCounterStyleRule: {
    prototype: CSSCounterStyleRule;
    new(): CSSCounterStyleRule;
    isInstance(obj): obj is CSSCounterStyleRule;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontFaceRule) */
interface CSSFontFaceRule extends CSSRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontFaceRule/style) */
    readonly style: CSSStyleDeclaration;
}

declare var CSSFontFaceRule: {
    prototype: CSSFontFaceRule;
    new(): CSSFontFaceRule;
    isInstance(obj): obj is CSSFontFaceRule;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontFeatureValuesRule) */
interface CSSFontFeatureValuesRule extends CSSRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontFeatureValuesRule/fontFamily) */
    fontFamily: UTF8String;
    valueText: UTF8String;
}

declare var CSSFontFeatureValuesRule: {
    prototype: CSSFontFeatureValuesRule;
    new(): CSSFontFeatureValuesRule;
    isInstance(obj): obj is CSSFontFeatureValuesRule;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontPaletteValuesRule) */
interface CSSFontPaletteValuesRule extends CSSRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontPaletteValuesRule/basePalette) */
    readonly basePalette: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontPaletteValuesRule/fontFamily) */
    readonly fontFamily: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontPaletteValuesRule/name) */
    readonly name: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontPaletteValuesRule/overrideColors) */
    readonly overrideColors: UTF8String;
}

declare var CSSFontPaletteValuesRule: {
    prototype: CSSFontPaletteValuesRule;
    new(): CSSFontPaletteValuesRule;
    isInstance(obj): obj is CSSFontPaletteValuesRule;
};

/**
 * Any CSS at-rule that contains other rules nested within it.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSGroupingRule)
 */
interface CSSGroupingRule extends CSSRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSGroupingRule/cssRules) */
    readonly cssRules: CSSRuleList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSGroupingRule/deleteRule) */
    deleteRule(index: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSGroupingRule/insertRule) */
    insertRule(rule: UTF8String, index?: number): number;
}

declare var CSSGroupingRule: {
    prototype: CSSGroupingRule;
    new(): CSSGroupingRule;
    isInstance(obj): obj is CSSGroupingRule;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSImportRule) */
interface CSSImportRule extends CSSRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSImportRule/href) */
    readonly href: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSImportRule/layerName) */
    readonly layerName: UTF8String | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSImportRule/media) */
    readonly media: MediaList | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSImportRule/styleSheet) */
    readonly styleSheet: CSSStyleSheet | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSImportRule/supportsText) */
    readonly supportsText: UTF8String | null;
}

declare var CSSImportRule: {
    prototype: CSSImportRule;
    new(): CSSImportRule;
    isInstance(obj): obj is CSSImportRule;
};

/**
 * An object representing a set of style for a given keyframe. It corresponds to the contains of a single keyframe of a @keyframes at-rule. It implements the CSSRule interface with a type value of 8 (CSSRule.KEYFRAME_RULE).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframeRule)
 */
interface CSSKeyframeRule extends CSSRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframeRule/keyText) */
    keyText: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframeRule/style) */
    readonly style: CSSStyleDeclaration;
}

declare var CSSKeyframeRule: {
    prototype: CSSKeyframeRule;
    new(): CSSKeyframeRule;
    isInstance(obj): obj is CSSKeyframeRule;
};

/**
 * An object representing a complete set of keyframes for a CSS animation. It corresponds to the contains of a whole @keyframes at-rule. It implements the CSSRule interface with a type value of 7 (CSSRule.KEYFRAMES_RULE).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframesRule)
 */
interface CSSKeyframesRule extends CSSRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframesRule/cssRules) */
    readonly cssRules: CSSRuleList;
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframesRule/name) */
    name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframesRule/appendRule) */
    appendRule(rule: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframesRule/deleteRule) */
    deleteRule(select: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframesRule/findRule) */
    findRule(select: string): CSSKeyframeRule | null;
    [index: number]: CSSKeyframeRule;
}

declare var CSSKeyframesRule: {
    prototype: CSSKeyframesRule;
    new(): CSSKeyframesRule;
    isInstance(obj): obj is CSSKeyframesRule;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSLayerBlockRule) */
interface CSSLayerBlockRule extends CSSGroupingRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSLayerBlockRule/name) */
    readonly name: UTF8String;
}

declare var CSSLayerBlockRule: {
    prototype: CSSLayerBlockRule;
    new(): CSSLayerBlockRule;
    isInstance(obj): obj is CSSLayerBlockRule;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSLayerStatementRule) */
interface CSSLayerStatementRule extends CSSRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSLayerStatementRule/nameList) */
    readonly nameList: UTF8String[];
}

declare var CSSLayerStatementRule: {
    prototype: CSSLayerStatementRule;
    new(): CSSLayerStatementRule;
    isInstance(obj): obj is CSSLayerStatementRule;
};

/**
 * A single CSS @media rule. It implements the CSSConditionRule interface, and therefore the CSSGroupingRule and the CSSRule interface with a type value of 4 (CSSRule.MEDIA_RULE).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMediaRule)
 */
interface CSSMediaRule extends CSSConditionRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMediaRule/media) */
    readonly media: MediaList;
}

declare var CSSMediaRule: {
    prototype: CSSMediaRule;
    new(): CSSMediaRule;
    isInstance(obj): obj is CSSMediaRule;
};

interface CSSMozDocumentRule extends CSSConditionRule {
}

declare var CSSMozDocumentRule: {
    prototype: CSSMozDocumentRule;
    new(): CSSMozDocumentRule;
    isInstance(obj): obj is CSSMozDocumentRule;
};

/**
 * An object representing a single CSS @namespace at-rule. It implements the CSSRule interface, with a type value of 10 (CSSRule.NAMESPACE_RULE).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNamespaceRule)
 */
interface CSSNamespaceRule extends CSSRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNamespaceRule/namespaceURI) */
    readonly namespaceURI: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNamespaceRule/prefix) */
    readonly prefix: string;
}

declare var CSSNamespaceRule: {
    prototype: CSSNamespaceRule;
    new(): CSSNamespaceRule;
    isInstance(obj): obj is CSSNamespaceRule;
};

/**
 * CSSPageRule is an interface representing a single CSS @page rule. It implements the CSSRule interface with a type value of 6 (CSSRule.PAGE_RULE).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPageRule)
 */
interface CSSPageRule extends CSSRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPageRule/selectorText) */
    selectorText: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPageRule/style) */
    readonly style: CSSStyleDeclaration;
}

declare var CSSPageRule: {
    prototype: CSSPageRule;
    new(): CSSPageRule;
    isInstance(obj): obj is CSSPageRule;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPropertyRule) */
interface CSSPropertyRule extends CSSRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPropertyRule/inherits) */
    readonly inherits: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPropertyRule/initialValue) */
    readonly initialValue: UTF8String | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPropertyRule/name) */
    readonly name: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPropertyRule/syntax) */
    readonly syntax: UTF8String;
}

declare var CSSPropertyRule: {
    prototype: CSSPropertyRule;
    new(): CSSPropertyRule;
    isInstance(obj): obj is CSSPropertyRule;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPseudoElement) */
interface CSSPseudoElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPseudoElement/element) */
    readonly element: Element;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPseudoElement/type) */
    readonly type: string;
}

declare var CSSPseudoElement: {
    prototype: CSSPseudoElement;
    new(): CSSPseudoElement;
    isInstance(obj): obj is CSSPseudoElement;
};

/**
 * A single CSS rule. There are several types of rules, listed in the Type constants section below.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRule)
 */
interface CSSRule {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRule/cssText) */
    cssText: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRule/parentRule) */
    readonly parentRule: CSSRule | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRule/parentStyleSheet) */
    readonly parentStyleSheet: CSSStyleSheet | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRule/type)
     */
    readonly type: number;
    readonly STYLE_RULE: 1;
    readonly CHARSET_RULE: 2;
    readonly IMPORT_RULE: 3;
    readonly MEDIA_RULE: 4;
    readonly FONT_FACE_RULE: 5;
    readonly PAGE_RULE: 6;
    readonly NAMESPACE_RULE: 10;
    readonly KEYFRAMES_RULE: 7;
    readonly KEYFRAME_RULE: 8;
    readonly COUNTER_STYLE_RULE: 11;
    readonly SUPPORTS_RULE: 12;
    readonly DOCUMENT_RULE: 13;
    readonly FONT_FEATURE_VALUES_RULE: 14;
}

declare var CSSRule: {
    prototype: CSSRule;
    new(): CSSRule;
    readonly STYLE_RULE: 1;
    readonly CHARSET_RULE: 2;
    readonly IMPORT_RULE: 3;
    readonly MEDIA_RULE: 4;
    readonly FONT_FACE_RULE: 5;
    readonly PAGE_RULE: 6;
    readonly NAMESPACE_RULE: 10;
    readonly KEYFRAMES_RULE: 7;
    readonly KEYFRAME_RULE: 8;
    readonly COUNTER_STYLE_RULE: 11;
    readonly SUPPORTS_RULE: 12;
    readonly DOCUMENT_RULE: 13;
    readonly FONT_FEATURE_VALUES_RULE: 14;
    isInstance(obj): obj is CSSRule;
};

/**
 * A CSSRuleList is an (indirect-modify only) array-like object containing an ordered collection of CSSRule objects.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRuleList)
 */
interface CSSRuleList {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRuleList/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRuleList/item) */
    item(index: number): CSSRule | null;
    [index: number]: CSSRule;
}

declare var CSSRuleList: {
    prototype: CSSRuleList;
    new(): CSSRuleList;
    isInstance(obj): obj is CSSRuleList;
};

/**
 * An object that is a CSS declaration block, and exposes style information and various style-related methods and properties.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration)
 */
interface CSSStyleDeclaration {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/accent-color) */
    accentColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/align-content) */
    alignContent: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/align-items) */
    alignItems: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/align-self) */
    alignSelf: string;
    alignmentBaseline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/all) */
    all: string;
    anchorDefault: string;
    anchorName: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation) */
    animation: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-composition) */
    animationComposition: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-delay) */
    animationDelay: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-direction) */
    animationDirection: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-duration) */
    animationDuration: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-fill-mode) */
    animationFillMode: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-iteration-count) */
    animationIterationCount: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-name) */
    animationName: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-play-state) */
    animationPlayState: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-range) */
    animationRange: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-range-end) */
    animationRangeEnd: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-range-start) */
    animationRangeStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-timeline) */
    animationTimeline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-timing-function) */
    animationTimingFunction: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/appearance) */
    appearance: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/aspect-ratio) */
    aspectRatio: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/backdrop-filter) */
    backdropFilter: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/backface-visibility) */
    backfaceVisibility: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background) */
    background: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-attachment) */
    backgroundAttachment: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-blend-mode) */
    backgroundBlendMode: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-clip) */
    backgroundClip: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-color) */
    backgroundColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-image) */
    backgroundImage: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-origin) */
    backgroundOrigin: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-position) */
    backgroundPosition: string;
    backgroundPositionBlock: string;
    backgroundPositionInline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-position-x) */
    backgroundPositionX: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-position-y) */
    backgroundPositionY: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-repeat) */
    backgroundRepeat: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-size) */
    backgroundSize: string;
    backgroundTbd: string;
    baselineShift: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/baseline-source) */
    baselineSource: string;
    blockEllipsis: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/block-size) */
    blockSize: string;
    blockStep: string;
    blockStepAlign: string;
    blockStepInsert: string;
    blockStepRound: string;
    blockStepSize: string;
    bookmarkLabel: string;
    bookmarkLevel: string;
    bookmarkState: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border) */
    border: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block) */
    borderBlock: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-color) */
    borderBlockColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-end) */
    borderBlockEnd: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-end-color) */
    borderBlockEndColor: string;
    borderBlockEndRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-end-style) */
    borderBlockEndStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-end-width) */
    borderBlockEndWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-start) */
    borderBlockStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-start-color) */
    borderBlockStartColor: string;
    borderBlockStartRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-start-style) */
    borderBlockStartStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-start-width) */
    borderBlockStartWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-style) */
    borderBlockStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-width) */
    borderBlockWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom) */
    borderBottom: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-color) */
    borderBottomColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-left-radius) */
    borderBottomLeftRadius: string;
    borderBottomRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-right-radius) */
    borderBottomRightRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-style) */
    borderBottomStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-width) */
    borderBottomWidth: string;
    borderBoundary: string;
    borderClip: string;
    borderClipBottom: string;
    borderClipLeft: string;
    borderClipRight: string;
    borderClipTop: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-collapse) */
    borderCollapse: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-color) */
    borderColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-end-end-radius) */
    borderEndEndRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-end-start-radius) */
    borderEndStartRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-image) */
    borderImage: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-image-outset) */
    borderImageOutset: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-image-repeat) */
    borderImageRepeat: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-image-slice) */
    borderImageSlice: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-image-source) */
    borderImageSource: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-image-width) */
    borderImageWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline) */
    borderInline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-color) */
    borderInlineColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-end) */
    borderInlineEnd: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-end-color) */
    borderInlineEndColor: string;
    borderInlineEndRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-end-style) */
    borderInlineEndStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-end-width) */
    borderInlineEndWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-start) */
    borderInlineStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-start-color) */
    borderInlineStartColor: string;
    borderInlineStartRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-start-style) */
    borderInlineStartStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-start-width) */
    borderInlineStartWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-style) */
    borderInlineStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-width) */
    borderInlineWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-left) */
    borderLeft: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-left-color) */
    borderLeftColor: string;
    borderLeftRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-left-style) */
    borderLeftStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-left-width) */
    borderLeftWidth: string;
    borderLimit: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-radius) */
    borderRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-right) */
    borderRight: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-right-color) */
    borderRightColor: string;
    borderRightRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-right-style) */
    borderRightStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-right-width) */
    borderRightWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-spacing) */
    borderSpacing: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-start-end-radius) */
    borderStartEndRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-start-start-radius) */
    borderStartStartRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-style) */
    borderStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top) */
    borderTop: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-color) */
    borderTopColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-left-radius) */
    borderTopLeftRadius: string;
    borderTopRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-right-radius) */
    borderTopRightRadius: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-style) */
    borderTopStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-width) */
    borderTopWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-width) */
    borderWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/bottom) */
    bottom: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-decoration-break) */
    boxDecorationBreak: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-shadow) */
    boxShadow: string;
    boxShadowBlur: string;
    boxShadowColor: string;
    boxShadowOffset: string;
    boxShadowPosition: string;
    boxShadowSpread: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-sizing) */
    boxSizing: string;
    boxSnap: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/break-after) */
    breakAfter: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/break-before) */
    breakBefore: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/break-inside) */
    breakInside: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/caption-side) */
    captionSide: string;
    caret: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/caret-color) */
    caretColor: string;
    caretShape: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/clear) */
    clear: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/clip)
     */
    clip: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/clip-path) */
    clipPath: string;
    clipRule: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/color) */
    color: string;
    /**
     * @deprecated This is a legacy alias of `printColorAdjust`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/print-color-adjust)
     */
    colorAdjust: string;
    colorInterpolation: string;
    colorInterpolationFilters: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/color-scheme) */
    colorScheme: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-count) */
    columnCount: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-fill) */
    columnFill: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-gap) */
    columnGap: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-rule) */
    columnRule: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-rule-color) */
    columnRuleColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-rule-style) */
    columnRuleStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-rule-width) */
    columnRuleWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-span) */
    columnSpan: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-width) */
    columnWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/columns) */
    columns: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/contain) */
    contain: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-contain-intrinsic-block-size) */
    containIntrinsicBlockSize: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-height) */
    containIntrinsicHeight: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-contain-intrinsic-inline-size) */
    containIntrinsicInlineSize: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-size) */
    containIntrinsicSize: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-width) */
    containIntrinsicWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/container) */
    container: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/container-name) */
    containerName: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/container-type) */
    containerType: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/content) */
    content: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/content-visibility) */
    contentVisibility: string;
    continue: string;
    copyInto: string;
    cornerShape: string;
    corners: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/counter-increment) */
    counterIncrement: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/counter-reset) */
    counterReset: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/counter-set) */
    counterSet: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/cssText) */
    cssText: UTF8String;
    cue: string;
    cueAfter: string;
    cueBefore: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/cursor) */
    cursor: string;
    cx: string;
    cy: string;
    d: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/direction) */
    direction: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/display) */
    display: string;
    dominantBaseline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/empty-cells) */
    emptyCells: string;
    fieldSizing: string;
    fill: string;
    fillBreak: string;
    fillColor: string;
    fillImage: string;
    fillOpacity: string;
    fillOrigin: string;
    fillPosition: string;
    fillRepeat: string;
    fillRule: string;
    fillSize: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/filter) */
    filter: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex) */
    flex: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-basis) */
    flexBasis: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-direction) */
    flexDirection: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-flow) */
    flexFlow: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-grow) */
    flexGrow: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-shrink) */
    flexShrink: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-wrap) */
    flexWrap: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/float) */
    float: string;
    floatDefer: string;
    floatOffset: string;
    floatReference: string;
    floodColor: string;
    floodOpacity: string;
    flowFrom: string;
    flowInto: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font) */
    font: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-family) */
    fontFamily: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-feature-settings) */
    fontFeatureSettings: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-kerning) */
    fontKerning: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-language-override) */
    fontLanguageOverride: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-optical-sizing) */
    fontOpticalSizing: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-palette) */
    fontPalette: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-size) */
    fontSize: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-size-adjust) */
    fontSizeAdjust: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-stretch) */
    fontStretch: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-style) */
    fontStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-synthesis) */
    fontSynthesis: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-synthesis-position) */
    fontSynthesisPosition: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-synthesis-small-caps) */
    fontSynthesisSmallCaps: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-synthesis-style) */
    fontSynthesisStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-synthesis-weight) */
    fontSynthesisWeight: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant) */
    fontVariant: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant-alternates) */
    fontVariantAlternates: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant-caps) */
    fontVariantCaps: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant-east-asian) */
    fontVariantEastAsian: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant-emoji) */
    fontVariantEmoji: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant-ligatures) */
    fontVariantLigatures: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant-numeric) */
    fontVariantNumeric: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant-position) */
    fontVariantPosition: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variation-settings) */
    fontVariationSettings: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-weight) */
    fontWeight: string;
    footnoteDisplay: string;
    footnotePolicy: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/forced-color-adjust) */
    forcedColorAdjust: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/gap) */
    gap: string;
    /** @deprecated */
    glyphOrientationVertical: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid) */
    grid: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-area) */
    gridArea: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-auto-columns) */
    gridAutoColumns: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-auto-flow) */
    gridAutoFlow: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-auto-rows) */
    gridAutoRows: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-column) */
    gridColumn: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-column-end) */
    gridColumnEnd: string;
    /** @deprecated This is a legacy alias of `columnGap`. */
    gridColumnGap: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-column-start) */
    gridColumnStart: string;
    /** @deprecated This is a legacy alias of `gap`. */
    gridGap: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-row) */
    gridRow: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-row-end) */
    gridRowEnd: string;
    /** @deprecated This is a legacy alias of `rowGap`. */
    gridRowGap: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-row-start) */
    gridRowStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-template) */
    gridTemplate: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-template-areas) */
    gridTemplateAreas: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-template-columns) */
    gridTemplateColumns: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-template-rows) */
    gridTemplateRows: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/hanging-punctuation) */
    hangingPunctuation: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/height) */
    height: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/hyphenate-character) */
    hyphenateCharacter: string;
    hyphenateLimitChars: string;
    hyphenateLimitLast: string;
    hyphenateLimitLines: string;
    hyphenateLimitZone: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/hyphens) */
    hyphens: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/image-orientation) */
    imageOrientation: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/image-rendering) */
    imageRendering: string;
    imageResolution: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/initial-letter) */
    initialLetter: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/initial-letter-align) */
    initialLetterAlign: string;
    initialLetterWrap: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inline-size) */
    inlineSize: string;
    inlineSizing: string;
    inputSecurity: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset) */
    inset: string;
    insetArea: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset-block) */
    insetBlock: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset-block-end) */
    insetBlockEnd: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset-block-start) */
    insetBlockStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset-inline) */
    insetInline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset-inline-end) */
    insetInlineEnd: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset-inline-start) */
    insetInlineStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/isolation) */
    isolation: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/justify-content) */
    justifyContent: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/justify-items) */
    justifyItems: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/justify-self) */
    justifySelf: string;
    layoutOrder: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/left) */
    left: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/letter-spacing) */
    letterSpacing: string;
    lightingColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/line-break) */
    lineBreak: string;
    lineClamp: string;
    lineGrid: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/line-height) */
    lineHeight: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/line-height-step) */
    lineHeightStep: string;
    linePadding: string;
    lineSnap: string;
    linkParameters: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/list-style) */
    listStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/list-style-image) */
    listStyleImage: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/list-style-position) */
    listStylePosition: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/list-style-type) */
    listStyleType: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin) */
    margin: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-block) */
    marginBlock: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-block-end) */
    marginBlockEnd: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-block-start) */
    marginBlockStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-bottom) */
    marginBottom: string;
    marginBreak: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-inline) */
    marginInline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-inline-end) */
    marginInlineEnd: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-inline-start) */
    marginInlineStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-left) */
    marginLeft: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-right) */
    marginRight: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-top) */
    marginTop: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-trim) */
    marginTrim: string;
    marker: string;
    markerEnd: string;
    markerMid: string;
    markerSide: string;
    markerStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask) */
    mask: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border) */
    maskBorder: string;
    maskBorderMode: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-outset) */
    maskBorderOutset: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-repeat) */
    maskBorderRepeat: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-slice) */
    maskBorderSlice: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-source) */
    maskBorderSource: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-width) */
    maskBorderWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-clip) */
    maskClip: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-composite) */
    maskComposite: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-image) */
    maskImage: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-mode) */
    maskMode: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-origin) */
    maskOrigin: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-position) */
    maskPosition: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-repeat) */
    maskRepeat: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-size) */
    maskSize: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-type) */
    maskType: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/masonry-auto-flow) */
    masonryAutoFlow: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/math-depth) */
    mathDepth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/math-shift) */
    mathShift: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/math-style) */
    mathStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/max-block-size) */
    maxBlockSize: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/max-height) */
    maxHeight: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/max-inline-size) */
    maxInlineSize: string;
    maxLines: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/max-width) */
    maxWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/min-block-size) */
    minBlockSize: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/min-height) */
    minHeight: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/min-inline-size) */
    minInlineSize: string;
    minIntrinsicSizing: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/min-width) */
    minWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mix-blend-mode) */
    mixBlendMode: string;
    navDown: string;
    navLeft: string;
    navRight: string;
    navUp: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/object-fit) */
    objectFit: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/object-position) */
    objectPosition: string;
    objectViewBox: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/offset) */
    offset: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/offset-anchor) */
    offsetAnchor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/offset-distance) */
    offsetDistance: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/offset-path) */
    offsetPath: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/offset-position) */
    offsetPosition: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/offset-rotate) */
    offsetRotate: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/opacity) */
    opacity: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/order) */
    order: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/orphans) */
    orphans: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/outline) */
    outline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/outline-color) */
    outlineColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/outline-offset) */
    outlineOffset: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/outline-style) */
    outlineStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/outline-width) */
    outlineWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow) */
    overflow: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-anchor) */
    overflowAnchor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-block) */
    overflowBlock: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-clip-margin) */
    overflowClipMargin: string;
    overflowClipMarginBlock: string;
    overflowClipMarginBlockEnd: string;
    overflowClipMarginBlockStart: string;
    overflowClipMarginBottom: string;
    overflowClipMarginInline: string;
    overflowClipMarginInlineEnd: string;
    overflowClipMarginInlineStart: string;
    overflowClipMarginLeft: string;
    overflowClipMarginRight: string;
    overflowClipMarginTop: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-inline) */
    overflowInline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-wrap) */
    overflowWrap: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-x) */
    overflowX: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-y) */
    overflowY: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overlay) */
    overlay: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior) */
    overscrollBehavior: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-block) */
    overscrollBehaviorBlock: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-inline) */
    overscrollBehaviorInline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-x) */
    overscrollBehaviorX: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-y) */
    overscrollBehaviorY: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding) */
    padding: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-block) */
    paddingBlock: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-block-end) */
    paddingBlockEnd: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-block-start) */
    paddingBlockStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-bottom) */
    paddingBottom: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-inline) */
    paddingInline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-inline-end) */
    paddingInlineEnd: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-inline-start) */
    paddingInlineStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-left) */
    paddingLeft: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-right) */
    paddingRight: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-top) */
    paddingTop: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/page) */
    page: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/page-break-after) */
    pageBreakAfter: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/page-break-before) */
    pageBreakBefore: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/page-break-inside) */
    pageBreakInside: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/paint-order) */
    paintOrder: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/parentRule) */
    readonly parentRule: CSSRule | null;
    pause: string;
    pauseAfter: string;
    pauseBefore: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/perspective) */
    perspective: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/perspective-origin) */
    perspectiveOrigin: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/place-content) */
    placeContent: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/place-items) */
    placeItems: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/place-self) */
    placeSelf: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/pointer-events) */
    pointerEvents: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/position) */
    position: string;
    positionFallback: string;
    positionFallbackBounds: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/print-color-adjust) */
    printColorAdjust: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/quotes) */
    quotes: string;
    r: string;
    readingOrder: string;
    regionFragment: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/resize) */
    resize: string;
    rest: string;
    restAfter: string;
    restBefore: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/right) */
    right: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/rotate) */
    rotate: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/row-gap) */
    rowGap: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/ruby-align) */
    rubyAlign: string;
    rubyMerge: string;
    rubyOverhang: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/ruby-position) */
    rubyPosition: string;
    rx: string;
    ry: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scale) */
    scale: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-behavior) */
    scrollBehavior: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin) */
    scrollMargin: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block) */
    scrollMarginBlock: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block-end) */
    scrollMarginBlockEnd: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block-start) */
    scrollMarginBlockStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-bottom) */
    scrollMarginBottom: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline) */
    scrollMarginInline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline-end) */
    scrollMarginInlineEnd: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline-start) */
    scrollMarginInlineStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-left) */
    scrollMarginLeft: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-right) */
    scrollMarginRight: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-top) */
    scrollMarginTop: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding) */
    scrollPadding: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block) */
    scrollPaddingBlock: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block-end) */
    scrollPaddingBlockEnd: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block-start) */
    scrollPaddingBlockStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-bottom) */
    scrollPaddingBottom: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline) */
    scrollPaddingInline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline-end) */
    scrollPaddingInlineEnd: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline-start) */
    scrollPaddingInlineStart: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-left) */
    scrollPaddingLeft: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-right) */
    scrollPaddingRight: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-top) */
    scrollPaddingTop: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-snap-align) */
    scrollSnapAlign: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-snap-stop) */
    scrollSnapStop: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-snap-type) */
    scrollSnapType: string;
    scrollStart: string;
    scrollStartBlock: string;
    scrollStartInline: string;
    scrollStartTarget: string;
    scrollStartTargetBlock: string;
    scrollStartTargetInline: string;
    scrollStartTargetX: string;
    scrollStartTargetY: string;
    scrollStartX: string;
    scrollStartY: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-timeline) */
    scrollTimeline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-timeline-axis) */
    scrollTimelineAxis: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-timeline-name) */
    scrollTimelineName: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scrollbar-color) */
    scrollbarColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scrollbar-gutter) */
    scrollbarGutter: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scrollbar-width) */
    scrollbarWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/shape-image-threshold) */
    shapeImageThreshold: string;
    shapeInside: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/shape-margin) */
    shapeMargin: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/shape-outside) */
    shapeOutside: string;
    shapePadding: string;
    shapeRendering: string;
    shapeSubtract: string;
    spatialNavigationAction: string;
    spatialNavigationContain: string;
    spatialNavigationFunction: string;
    speak: string;
    speakAs: string;
    stopColor: string;
    stopOpacity: string;
    stringSet: string;
    stroke: string;
    strokeAlign: string;
    strokeAlignment: string;
    strokeBreak: string;
    strokeColor: string;
    strokeDashCorner: string;
    strokeDashJustify: string;
    strokeDashadjust: string;
    strokeDasharray: string;
    strokeDashcorner: string;
    strokeDashoffset: string;
    strokeImage: string;
    strokeLinecap: string;
    strokeLinejoin: string;
    strokeMiterlimit: string;
    strokeOpacity: string;
    strokeOrigin: string;
    strokePosition: string;
    strokeRepeat: string;
    strokeSize: string;
    strokeWidth: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/tab-size) */
    tabSize: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/table-layout) */
    tableLayout: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-align) */
    textAlign: string;
    textAlignAll: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-align-last) */
    textAlignLast: string;
    textAnchor: string;
    textAutospace: string;
    textBoxEdge: string;
    textBoxTrim: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-combine-upright) */
    textCombineUpright: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-decoration) */
    textDecoration: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-decoration-color) */
    textDecorationColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-decoration-line) */
    textDecorationLine: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-decoration-skip) */
    textDecorationSkip: string;
    textDecorationSkipBox: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-decoration-skip-ink) */
    textDecorationSkipInk: string;
    textDecorationSkipSelf: string;
    textDecorationSkipSpaces: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-decoration-style) */
    textDecorationStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-decoration-thickness) */
    textDecorationThickness: string;
    textDecorationTrim: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-emphasis) */
    textEmphasis: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-emphasis-color) */
    textEmphasisColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-emphasis-position) */
    textEmphasisPosition: string;
    textEmphasisSkip: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-emphasis-style) */
    textEmphasisStyle: string;
    textGroupAlign: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-indent) */
    textIndent: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-justify) */
    textJustify: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-orientation) */
    textOrientation: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-overflow) */
    textOverflow: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-rendering) */
    textRendering: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-shadow) */
    textShadow: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-size-adjust) */
    textSizeAdjust: string;
    textSpacing: string;
    textSpacingTrim: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-transform) */
    textTransform: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-underline-offset) */
    textUnderlineOffset: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-underline-position) */
    textUnderlinePosition: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-wrap) */
    textWrap: string;
    textWrapMode: string;
    textWrapStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/timeline-scope) */
    timelineScope: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/top) */
    top: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/touch-action) */
    touchAction: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform) */
    transform: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform-box) */
    transformBox: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform-origin) */
    transformOrigin: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform-style) */
    transformStyle: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition) */
    transition: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-behavior) */
    transitionBehavior: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-delay) */
    transitionDelay: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-duration) */
    transitionDuration: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-property) */
    transitionProperty: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-timing-function) */
    transitionTimingFunction: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/translate) */
    translate: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/unicode-bidi) */
    unicodeBidi: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/user-select) */
    userSelect: string;
    vectorEffect: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/vertical-align) */
    verticalAlign: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/view-timeline) */
    viewTimeline: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/view-timeline-axis) */
    viewTimelineAxis: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/view-timeline-inset) */
    viewTimelineInset: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/view-timeline-name) */
    viewTimelineName: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/view-transition-name) */
    viewTransitionName: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/visibility) */
    visibility: string;
    voiceBalance: string;
    voiceDuration: string;
    voiceFamily: string;
    voicePitch: string;
    voiceRange: string;
    voiceRate: string;
    voiceStress: string;
    voiceVolume: string;
    /**
     * @deprecated This is a legacy alias of `alignContent`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/align-content)
     */
    webkitAlignContent: string;
    /**
     * @deprecated This is a legacy alias of `alignItems`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/align-items)
     */
    webkitAlignItems: string;
    /**
     * @deprecated This is a legacy alias of `alignSelf`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/align-self)
     */
    webkitAlignSelf: string;
    /**
     * @deprecated This is a legacy alias of `animation`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation)
     */
    webkitAnimation: string;
    /**
     * @deprecated This is a legacy alias of `animationDelay`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-delay)
     */
    webkitAnimationDelay: string;
    /**
     * @deprecated This is a legacy alias of `animationDirection`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-direction)
     */
    webkitAnimationDirection: string;
    /**
     * @deprecated This is a legacy alias of `animationDuration`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-duration)
     */
    webkitAnimationDuration: string;
    /**
     * @deprecated This is a legacy alias of `animationFillMode`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-fill-mode)
     */
    webkitAnimationFillMode: string;
    /**
     * @deprecated This is a legacy alias of `animationIterationCount`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-iteration-count)
     */
    webkitAnimationIterationCount: string;
    /**
     * @deprecated This is a legacy alias of `animationName`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-name)
     */
    webkitAnimationName: string;
    /**
     * @deprecated This is a legacy alias of `animationPlayState`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-play-state)
     */
    webkitAnimationPlayState: string;
    /**
     * @deprecated This is a legacy alias of `animationTimingFunction`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-timing-function)
     */
    webkitAnimationTimingFunction: string;
    /**
     * @deprecated This is a legacy alias of `appearance`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/appearance)
     */
    webkitAppearance: string;
    /**
     * @deprecated This is a legacy alias of `backfaceVisibility`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/backface-visibility)
     */
    webkitBackfaceVisibility: string;
    /**
     * @deprecated This is a legacy alias of `backgroundClip`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-clip)
     */
    webkitBackgroundClip: string;
    /**
     * @deprecated This is a legacy alias of `backgroundOrigin`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-origin)
     */
    webkitBackgroundOrigin: string;
    /**
     * @deprecated This is a legacy alias of `backgroundSize`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-size)
     */
    webkitBackgroundSize: string;
    /**
     * @deprecated This is a legacy alias of `borderBottomLeftRadius`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-left-radius)
     */
    webkitBorderBottomLeftRadius: string;
    /**
     * @deprecated This is a legacy alias of `borderBottomRightRadius`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-right-radius)
     */
    webkitBorderBottomRightRadius: string;
    /**
     * @deprecated This is a legacy alias of `borderRadius`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-radius)
     */
    webkitBorderRadius: string;
    /**
     * @deprecated This is a legacy alias of `borderTopLeftRadius`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-left-radius)
     */
    webkitBorderTopLeftRadius: string;
    /**
     * @deprecated This is a legacy alias of `borderTopRightRadius`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-right-radius)
     */
    webkitBorderTopRightRadius: string;
    /**
     * @deprecated This is a legacy alias of `boxAlign`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-align)
     */
    webkitBoxAlign: string;
    /**
     * @deprecated This is a legacy alias of `boxFlex`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-flex)
     */
    webkitBoxFlex: string;
    /**
     * @deprecated This is a legacy alias of `boxOrdinalGroup`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-ordinal-group)
     */
    webkitBoxOrdinalGroup: string;
    /**
     * @deprecated This is a legacy alias of `boxOrient`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-orient)
     */
    webkitBoxOrient: string;
    /**
     * @deprecated This is a legacy alias of `boxPack`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-pack)
     */
    webkitBoxPack: string;
    /**
     * @deprecated This is a legacy alias of `boxShadow`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-shadow)
     */
    webkitBoxShadow: string;
    /**
     * @deprecated This is a legacy alias of `boxSizing`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-sizing)
     */
    webkitBoxSizing: string;
    /**
     * @deprecated This is a legacy alias of `filter`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/filter)
     */
    webkitFilter: string;
    /**
     * @deprecated This is a legacy alias of `flex`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex)
     */
    webkitFlex: string;
    /**
     * @deprecated This is a legacy alias of `flexBasis`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-basis)
     */
    webkitFlexBasis: string;
    /**
     * @deprecated This is a legacy alias of `flexDirection`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-direction)
     */
    webkitFlexDirection: string;
    /**
     * @deprecated This is a legacy alias of `flexFlow`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-flow)
     */
    webkitFlexFlow: string;
    /**
     * @deprecated This is a legacy alias of `flexGrow`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-grow)
     */
    webkitFlexGrow: string;
    /**
     * @deprecated This is a legacy alias of `flexShrink`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-shrink)
     */
    webkitFlexShrink: string;
    /**
     * @deprecated This is a legacy alias of `flexWrap`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-wrap)
     */
    webkitFlexWrap: string;
    /**
     * @deprecated This is a legacy alias of `justifyContent`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/justify-content)
     */
    webkitJustifyContent: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/-webkit-line-clamp) */
    webkitLineClamp: string;
    /**
     * @deprecated This is a legacy alias of `mask`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask)
     */
    webkitMask: string;
    /**
     * @deprecated This is a legacy alias of `maskBorder`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border)
     */
    webkitMaskBoxImage: string;
    /**
     * @deprecated This is a legacy alias of `maskBorderOutset`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-outset)
     */
    webkitMaskBoxImageOutset: string;
    /**
     * @deprecated This is a legacy alias of `maskBorderRepeat`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-repeat)
     */
    webkitMaskBoxImageRepeat: string;
    /**
     * @deprecated This is a legacy alias of `maskBorderSlice`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-slice)
     */
    webkitMaskBoxImageSlice: string;
    /**
     * @deprecated This is a legacy alias of `maskBorderSource`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-source)
     */
    webkitMaskBoxImageSource: string;
    /**
     * @deprecated This is a legacy alias of `maskBorderWidth`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-width)
     */
    webkitMaskBoxImageWidth: string;
    /**
     * @deprecated This is a legacy alias of `maskClip`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-clip)
     */
    webkitMaskClip: string;
    /**
     * @deprecated This is a legacy alias of `maskComposite`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-composite)
     */
    webkitMaskComposite: string;
    /**
     * @deprecated This is a legacy alias of `maskImage`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-image)
     */
    webkitMaskImage: string;
    /**
     * @deprecated This is a legacy alias of `maskOrigin`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-origin)
     */
    webkitMaskOrigin: string;
    /**
     * @deprecated This is a legacy alias of `maskPosition`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-position)
     */
    webkitMaskPosition: string;
    /**
     * @deprecated This is a legacy alias of `maskRepeat`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-repeat)
     */
    webkitMaskRepeat: string;
    /**
     * @deprecated This is a legacy alias of `maskSize`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-size)
     */
    webkitMaskSize: string;
    /**
     * @deprecated This is a legacy alias of `order`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/order)
     */
    webkitOrder: string;
    /**
     * @deprecated This is a legacy alias of `perspective`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/perspective)
     */
    webkitPerspective: string;
    /**
     * @deprecated This is a legacy alias of `perspectiveOrigin`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/perspective-origin)
     */
    webkitPerspectiveOrigin: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/-webkit-text-fill-color) */
    webkitTextFillColor: string;
    /**
     * @deprecated This is a legacy alias of `textSizeAdjust`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-size-adjust)
     */
    webkitTextSizeAdjust: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke) */
    webkitTextStroke: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke-color) */
    webkitTextStrokeColor: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke-width) */
    webkitTextStrokeWidth: string;
    /**
     * @deprecated This is a legacy alias of `transform`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform)
     */
    webkitTransform: string;
    /**
     * @deprecated This is a legacy alias of `transformOrigin`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform-origin)
     */
    webkitTransformOrigin: string;
    /**
     * @deprecated This is a legacy alias of `transformStyle`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform-style)
     */
    webkitTransformStyle: string;
    /**
     * @deprecated This is a legacy alias of `transition`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition)
     */
    webkitTransition: string;
    /**
     * @deprecated This is a legacy alias of `transitionDelay`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-delay)
     */
    webkitTransitionDelay: string;
    /**
     * @deprecated This is a legacy alias of `transitionDuration`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-duration)
     */
    webkitTransitionDuration: string;
    /**
     * @deprecated This is a legacy alias of `transitionProperty`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-property)
     */
    webkitTransitionProperty: string;
    /**
     * @deprecated This is a legacy alias of `transitionTimingFunction`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-timing-function)
     */
    webkitTransitionTimingFunction: string;
    /**
     * @deprecated This is a legacy alias of `userSelect`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/user-select)
     */
    webkitUserSelect: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/white-space) */
    whiteSpace: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/white-space-collapse) */
    whiteSpaceCollapse: string;
    whiteSpaceTrim: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/widows) */
    widows: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/width) */
    width: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/will-change) */
    willChange: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/word-break) */
    wordBreak: string;
    wordSpaceTransform: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/word-spacing) */
    wordSpacing: string;
    wordWrap: string;
    wrapAfter: string;
    wrapBefore: string;
    wrapFlow: string;
    wrapInside: string;
    wrapThrough: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/writing-mode) */
    writingMode: string;
    x: string;
    y: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/z-index) */
    zIndex: string;
    getCSSImageURLs(property: UTF8String): UTF8String[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/getPropertyPriority) */
    getPropertyPriority(property: UTF8String): UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/getPropertyValue) */
    getPropertyValue(property: UTF8String): UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/item) */
    item(index: number): UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/removeProperty) */
    removeProperty(property: UTF8String): UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/setProperty) */
    setProperty(property: UTF8String, value: UTF8String | null, priority?: UTF8String): void;
    [index: number]: UTF8String;
}

declare var CSSStyleDeclaration: {
    prototype: CSSStyleDeclaration;
    new(): CSSStyleDeclaration;
    isInstance(obj): obj is CSSStyleDeclaration;
};

/**
 * CSSStyleRule represents a single CSS style rule. It implements the CSSRule interface with a type value of 1 (CSSRule.STYLE_RULE).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleRule)
 */
interface CSSStyleRule extends CSSGroupingRule {
    readonly selectorCount: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleRule/selectorText) */
    selectorText: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleRule/style) */
    readonly style: CSSStyleDeclaration;
    getSelectorWarnings(): SelectorWarning[];
    selectorMatchesElement(selectorIndex: number, element: Element, pseudo?: string, includeVisitedStyle?: boolean): boolean;
    selectorSpecificityAt(index: number, desugared?: boolean): number;
    selectorTextAt(index: number, desugared?: boolean): UTF8String;
}

declare var CSSStyleRule: {
    prototype: CSSStyleRule;
    new(): CSSStyleRule;
    isInstance(obj): obj is CSSStyleRule;
};

/**
 * A single CSS style sheet. It inherits properties and methods from its parent, StyleSheet.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet)
 */
interface CSSStyleSheet extends StyleSheet {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/cssRules) */
    readonly cssRules: CSSRuleList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/ownerRule) */
    readonly ownerRule: CSSRule | null;
    readonly parsingMode: CSSStyleSheetParsingMode;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/rules)
     */
    readonly rules: CSSRuleList;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/addRule)
     */
    addRule(selector?: UTF8String, style?: UTF8String, index?: number): number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/deleteRule) */
    deleteRule(index: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/insertRule) */
    insertRule(rule: UTF8String, index?: number): number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/removeRule)
     */
    removeRule(index?: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/replace) */
    replace(text: UTF8String): Promise<CSSStyleSheet>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/replaceSync) */
    replaceSync(text: UTF8String): void;
}

declare var CSSStyleSheet: {
    prototype: CSSStyleSheet;
    new(options?: CSSStyleSheetInit): CSSStyleSheet;
    isInstance(obj): obj is CSSStyleSheet;
};

/**
 * An object representing a single CSS @supports at-rule. It implements the CSSConditionRule interface, and therefore the CSSRule and CSSGroupingRule interfaces with a type value of 12 (CSSRule.SUPPORTS_RULE).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSSupportsRule)
 */
interface CSSSupportsRule extends CSSConditionRule {
}

declare var CSSSupportsRule: {
    prototype: CSSSupportsRule;
    new(): CSSSupportsRule;
    isInstance(obj): obj is CSSSupportsRule;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTransition) */
interface CSSTransition extends Animation {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTransition/transitionProperty) */
    readonly transitionProperty: string;
    addEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: CSSTransition, ev: AnimationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: CSSTransition, ev: AnimationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var CSSTransition: {
    prototype: CSSTransition;
    new(): CSSTransition;
    isInstance(obj): obj is CSSTransition;
};

/**
 * Provides a storage mechanism for Request / Response object pairs that are cached, for example as part of the ServiceWorker life cycle. Note that the Cache interface is exposed to windowed scopes as well as workers. You don't have to use it in conjunction with service workers, even though it is defined in the service worker spec.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache)
 */
interface Cache {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/add) */
    add(request: RequestInfo | URL): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/addAll) */
    addAll(requests: RequestInfo[]): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/delete) */
    delete(request: RequestInfo | URL, options?: CacheQueryOptions): Promise<boolean>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/keys) */
    keys(request?: RequestInfo | URL, options?: CacheQueryOptions): Promise<Request[]>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/match) */
    match(request: RequestInfo | URL, options?: CacheQueryOptions): Promise<Response>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/matchAll) */
    matchAll(request?: RequestInfo | URL, options?: CacheQueryOptions): Promise<Response[]>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/put) */
    put(request: RequestInfo | URL, response: Response): Promise<void>;
}

declare var Cache: {
    prototype: Cache;
    new(): Cache;
    isInstance(obj): obj is Cache;
};

/**
 * The storage for Cache objects.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CacheStorage)
 */
interface CacheStorage {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CacheStorage/delete) */
    delete(cacheName: string): Promise<boolean>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CacheStorage/has) */
    has(cacheName: string): Promise<boolean>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CacheStorage/keys) */
    keys(): Promise<string[]>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CacheStorage/match) */
    match(request: RequestInfo | URL, options?: MultiCacheQueryOptions): Promise<Response>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CacheStorage/open) */
    open(cacheName: string): Promise<Cache>;
}

declare var CacheStorage: {
    prototype: CacheStorage;
    new(namespace: CacheStorageNamespace, principal: Principal): CacheStorage;
    isInstance(obj): obj is CacheStorage;
};

interface CallbackDebuggerNotification extends DebuggerNotification {
    readonly phase: CallbackDebuggerNotificationPhase;
}

declare var CallbackDebuggerNotification: {
    prototype: CallbackDebuggerNotification;
    new(): CallbackDebuggerNotification;
    isInstance(obj): obj is CallbackDebuggerNotification;
};

interface CanonicalBrowsingContext extends BrowsingContext {
    readonly activeSessionHistoryEntry: nsISHEntry | null;
    readonly currentRemoteType: UTF8String | null;
    readonly currentURI: URI | null;
    readonly currentWindowGlobal: WindowGlobalParent | null;
    readonly embedderWindowGlobal: WindowGlobalParent | null;
    forceAppWindowActive: boolean;
    readonly isReplaced: boolean;
    readonly isUnderHiddenEmbedderElement: boolean;
    readonly mediaController: MediaController | null;
    readonly mostRecentLoadingSessionHistoryEntry: nsISHEntry | null;
    readonly secureBrowserUI: nsISecureBrowserUI | null;
    readonly sessionHistory: nsISHistory | null;
    targetTopLevelLinkClicksToBlank: boolean;
    readonly topChromeWindow: WindowProxy | null;
    touchEventsOverride: TouchEventsOverride;
    readonly webProgress: nsIWebProgress | null;
    clearRestoreState(): void;
    fixupAndLoadURIString(aURI: string, aOptions?: LoadURIOptions): void;
    getWindowGlobals(): WindowGlobalParent[];
    goBack(aCancelContentJSEpoch?: number, aRequireUserInteraction?: boolean, aUserActivation?: boolean): void;
    goForward(aCancelContentJSEpoch?: number, aRequireUserInteraction?: boolean, aUserActivation?: boolean): void;
    goToIndex(aIndex: number, aCancelContentJSEpoch?: number, aUserActivation?: boolean): void;
    loadURI(aURI: URI, aOptions?: LoadURIOptions): void;
    notifyMediaMutedChanged(muted: boolean): void;
    notifyStartDelayedAutoplayMedia(): void;
    print(aPrintSettings: nsIPrintSettings): Promise<void>;
    reload(aReloadFlags: number): void;
    resetScalingZoom(): void;
    setCrossGroupOpener(crossGroupOpener: CanonicalBrowsingContext): void;
    startApzAutoscroll(aAnchorX: number, aAnchorY: number, aScrollId: number, aPresShellId: number): boolean;
    stop(aStopFlags: number): void;
    stopApzAutoscroll(aScrollId: number, aPresShellId: number): void;
}

declare var CanonicalBrowsingContext: {
    prototype: CanonicalBrowsingContext;
    new(): CanonicalBrowsingContext;
    countSiteOrigins(roots: BrowsingContext[]): number;
    isInstance(obj): obj is CanonicalBrowsingContext;
};

interface CanvasCaptureMediaStream extends MediaStream {
    readonly canvas: HTMLCanvasElement;
    requestFrame(): void;
    addEventListener<K extends keyof MediaStreamEventMap>(type: K, listener: (this: CanvasCaptureMediaStream, ev: MediaStreamEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MediaStreamEventMap>(type: K, listener: (this: CanvasCaptureMediaStream, ev: MediaStreamEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var CanvasCaptureMediaStream: {
    prototype: CanvasCaptureMediaStream;
    new(): CanvasCaptureMediaStream;
    isInstance(obj): obj is CanvasCaptureMediaStream;
};

interface CanvasCompositing {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/globalAlpha) */
    globalAlpha: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/globalCompositeOperation) */
    globalCompositeOperation: string;
}

interface CanvasDrawImage {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/drawImage) */
    drawImage(image: CanvasImageSource, dx: number, dy: number): void;
    drawImage(image: CanvasImageSource, dx: number, dy: number, dw: number, dh: number): void;
    drawImage(image: CanvasImageSource, sx: number, sy: number, sw: number, sh: number, dx: number, dy: number, dw: number, dh: number): void;
}

interface CanvasDrawPath {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/beginPath) */
    beginPath(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/clip) */
    clip(winding?: CanvasWindingRule): void;
    clip(path: Path2D, winding?: CanvasWindingRule): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fill) */
    fill(winding?: CanvasWindingRule): void;
    fill(path: Path2D, winding?: CanvasWindingRule): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/isPointInPath) */
    isPointInPath(x: number, y: number, winding?: CanvasWindingRule): boolean;
    isPointInPath(path: Path2D, x: number, y: number, winding?: CanvasWindingRule): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/isPointInStroke) */
    isPointInStroke(x: number, y: number): boolean;
    isPointInStroke(path: Path2D, x: number, y: number): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/stroke) */
    stroke(): void;
    stroke(path: Path2D): void;
}

interface CanvasFillStrokeStyles {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fillStyle) */
    fillStyle: UTF8String | CanvasGradient | CanvasPattern;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/strokeStyle) */
    strokeStyle: UTF8String | CanvasGradient | CanvasPattern;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/createConicGradient) */
    createConicGradient(angle: number, cx: number, cy: number): CanvasGradient;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/createLinearGradient) */
    createLinearGradient(x0: number, y0: number, x1: number, y1: number): CanvasGradient;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/createPattern) */
    createPattern(image: CanvasImageSource, repetition: string | null): CanvasPattern | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/createRadialGradient) */
    createRadialGradient(x0: number, y0: number, r0: number, x1: number, y1: number, r1: number): CanvasGradient;
}

interface CanvasFilters {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/filter) */
    filter: UTF8String;
}

/**
 * An opaque object describing a gradient. It is returned by the methods CanvasRenderingContext2D.createLinearGradient() or CanvasRenderingContext2D.createRadialGradient().
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasGradient)
 */
interface CanvasGradient {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasGradient/addColorStop) */
    addColorStop(offset: number, color: UTF8String): void;
}

declare var CanvasGradient: {
    prototype: CanvasGradient;
    new(): CanvasGradient;
    isInstance(obj): obj is CanvasGradient;
};

interface CanvasImageData {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/createImageData) */
    createImageData(sw: number, sh: number): ImageData;
    createImageData(imagedata: ImageData): ImageData;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/getImageData) */
    getImageData(sx: number, sy: number, sw: number, sh: number): ImageData;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/putImageData) */
    putImageData(imagedata: ImageData, dx: number, dy: number): void;
    putImageData(imagedata: ImageData, dx: number, dy: number, dirtyX: number, dirtyY: number, dirtyWidth: number, dirtyHeight: number): void;
}

interface CanvasImageSmoothing {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/imageSmoothingEnabled) */
    imageSmoothingEnabled: boolean;
}

interface CanvasPathDrawingStyles {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/lineCap) */
    lineCap: CanvasLineCap;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/lineDashOffset) */
    lineDashOffset: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/lineJoin) */
    lineJoin: CanvasLineJoin;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/lineWidth) */
    lineWidth: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/miterLimit) */
    miterLimit: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/getLineDash) */
    getLineDash(): number[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/setLineDash) */
    setLineDash(segments: number[]): void;
}

interface CanvasPathMethods {
    arc(x: number, y: number, radius: number, startAngle: number, endAngle: number, anticlockwise?: boolean): void;
    arcTo(x1: number, y1: number, x2: number, y2: number, radius: number): void;
    bezierCurveTo(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number): void;
    closePath(): void;
    ellipse(x: number, y: number, radiusX: number, radiusY: number, rotation: number, startAngle: number, endAngle: number, anticlockwise?: boolean): void;
    lineTo(x: number, y: number): void;
    moveTo(x: number, y: number): void;
    quadraticCurveTo(cpx: number, cpy: number, x: number, y: number): void;
    rect(x: number, y: number, w: number, h: number): void;
    roundRect(x: number, y: number, w: number, h: number, radii?: number | DOMPointInit | (number | DOMPointInit)[]): void;
}

/**
 * An opaque object describing a pattern, based on an image, a canvas, or a video, created by the CanvasRenderingContext2D.createPattern() method.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasPattern)
 */
interface CanvasPattern {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasPattern/setTransform) */
    setTransform(matrix?: DOMMatrix2DInit): void;
}

declare var CanvasPattern: {
    prototype: CanvasPattern;
    new(): CanvasPattern;
    isInstance(obj): obj is CanvasPattern;
};

interface CanvasRect {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/clearRect) */
    clearRect(x: number, y: number, w: number, h: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fillRect) */
    fillRect(x: number, y: number, w: number, h: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/strokeRect) */
    strokeRect(x: number, y: number, w: number, h: number): void;
}

/**
 * The CanvasRenderingContext2D interface, part of the Canvas API, provides the 2D rendering context for the drawing surface of a <canvas> element. It is used for drawing shapes, text, images, and other objects.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D)
 */
interface CanvasRenderingContext2D extends CanvasCompositing, CanvasDrawImage, CanvasDrawPath, CanvasFillStrokeStyles, CanvasFilters, CanvasImageData, CanvasImageSmoothing, CanvasPathDrawingStyles, CanvasPathMethods, CanvasRect, CanvasShadowStyles, CanvasState, CanvasText, CanvasTextDrawingStyles, CanvasTransform, CanvasUserInterface {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/canvas) */
    readonly canvas: HTMLCanvasElement | null;
    demote(): void;
    drawWindow(window: Window, x: number, y: number, w: number, h: number, bgColor: UTF8String, flags?: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/getContextAttributes) */
    getContextAttributes(): CanvasRenderingContext2DSettings;
    readonly DRAWWINDOW_DRAW_CARET: 0x01;
    readonly DRAWWINDOW_DO_NOT_FLUSH: 0x02;
    readonly DRAWWINDOW_DRAW_VIEW: 0x04;
    readonly DRAWWINDOW_USE_WIDGET_LAYERS: 0x08;
    readonly DRAWWINDOW_ASYNC_DECODE_IMAGES: 0x10;
}

declare var CanvasRenderingContext2D: {
    prototype: CanvasRenderingContext2D;
    new(): CanvasRenderingContext2D;
    readonly DRAWWINDOW_DRAW_CARET: 0x01;
    readonly DRAWWINDOW_DO_NOT_FLUSH: 0x02;
    readonly DRAWWINDOW_DRAW_VIEW: 0x04;
    readonly DRAWWINDOW_USE_WIDGET_LAYERS: 0x08;
    readonly DRAWWINDOW_ASYNC_DECODE_IMAGES: 0x10;
    isInstance(obj): obj is CanvasRenderingContext2D;
};

interface CanvasShadowStyles {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/shadowBlur) */
    shadowBlur: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/shadowColor) */
    shadowColor: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/shadowOffsetX) */
    shadowOffsetX: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/shadowOffsetY) */
    shadowOffsetY: number;
}

interface CanvasState {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/reset) */
    reset(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/restore) */
    restore(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/save) */
    save(): void;
}

interface CanvasText {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fillText) */
    fillText(text: string, x: number, y: number, maxWidth?: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/measureText) */
    measureText(text: string): TextMetrics;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/strokeText) */
    strokeText(text: string, x: number, y: number, maxWidth?: number): void;
}

interface CanvasTextDrawingStyles {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/direction) */
    direction: CanvasDirection;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/font) */
    font: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fontKerning) */
    fontKerning: CanvasFontKerning;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fontStretch) */
    fontStretch: CanvasFontStretch;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fontVariantCaps) */
    fontVariantCaps: CanvasFontVariantCaps;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/letterSpacing) */
    letterSpacing: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/textAlign) */
    textAlign: CanvasTextAlign;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/textBaseline) */
    textBaseline: CanvasTextBaseline;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/textRendering) */
    textRendering: CanvasTextRendering;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/wordSpacing) */
    wordSpacing: UTF8String;
}

interface CanvasTransform {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/getTransform) */
    getTransform(): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/resetTransform) */
    resetTransform(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/rotate) */
    rotate(angle: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/scale) */
    scale(x: number, y: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/setTransform) */
    setTransform(a: number, b: number, c: number, d: number, e: number, f: number): void;
    setTransform(transform?: DOMMatrix2DInit): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/transform) */
    transform(a: number, b: number, c: number, d: number, e: number, f: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/translate) */
    translate(x: number, y: number): void;
}

interface CanvasUserInterface {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/drawFocusIfNeeded) */
    drawFocusIfNeeded(element: Element): void;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CaretPosition) */
interface CaretPosition {
    readonly offset: number;
    readonly offsetNode: Node | null;
    getClientRect(): DOMRect | null;
}

declare var CaretPosition: {
    prototype: CaretPosition;
    new(): CaretPosition;
    isInstance(obj): obj is CaretPosition;
};

interface CaretStateChangedEvent extends Event {
    readonly boundingClientRect: DOMRectReadOnly | null;
    readonly caretVisible: boolean;
    readonly caretVisuallyVisible: boolean;
    readonly clientX: number;
    readonly clientY: number;
    readonly collapsed: boolean;
    readonly reason: CaretChangedReason;
    readonly selectedTextContent: string;
    readonly selectionEditable: boolean;
    readonly selectionVisible: boolean;
}

declare var CaretStateChangedEvent: {
    prototype: CaretStateChangedEvent;
    new(type: string, eventInit?: CaretStateChangedEventInit): CaretStateChangedEvent;
    isInstance(obj): obj is CaretStateChangedEvent;
};

/**
 * The ChannelMergerNode interface, often used in conjunction with its opposite, ChannelSplitterNode, reunites different mono inputs into a single output. Each input is used to fill a channel of the output. This is useful for accessing each channels separately, e.g. for performing channel mixing where gain must be separately controlled on each channel.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ChannelMergerNode)
 */
interface ChannelMergerNode extends AudioNode {
}

declare var ChannelMergerNode: {
    prototype: ChannelMergerNode;
    new(context: BaseAudioContext, options?: ChannelMergerOptions): ChannelMergerNode;
    isInstance(obj): obj is ChannelMergerNode;
};

/**
 * The ChannelSplitterNode interface, often used in conjunction with its opposite, ChannelMergerNode, separates the different channels of an audio source into a set of mono outputs. This is useful for accessing each channel separately, e.g. for performing channel mixing where gain must be separately controlled on each channel.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ChannelSplitterNode)
 */
interface ChannelSplitterNode extends AudioNode {
}

declare var ChannelSplitterNode: {
    prototype: ChannelSplitterNode;
    new(context: BaseAudioContext, options?: ChannelSplitterOptions): ChannelSplitterNode;
    isInstance(obj): obj is ChannelSplitterNode;
};

interface ChannelWrapperEventMap {
    "error": ErrorEvent;
    "start": Event;
    "stop": Event;
}

interface ChannelWrapper extends EventTarget {
    readonly browserElement: nsISupports | null;
    readonly canModify: boolean;
    channel: MozChannel | null;
    contentType: string;
    readonly documentURI: URI | null;
    readonly documentURL: string | null;
    readonly errorString: string | null;
    readonly finalURI: URI;
    readonly finalURL: string;
    readonly frameAncestors: MozFrameAncestorInfo[] | null;
    readonly frameId: number;
    readonly id: number;
    readonly isServiceWorkerScript: boolean;
    readonly isSystemLoad: boolean;
    readonly loadInfo: LoadInfo | null;
    readonly method: string;
    onerror: OnErrorEventHandler;
    onstart: ((this: ChannelWrapper, ev: Event) => any) | null;
    onstop: ((this: ChannelWrapper, ev: Event) => any) | null;
    readonly originURI: URI | null;
    readonly originURL: string | null;
    readonly parentFrameId: number;
    readonly proxyInfo: MozProxyInfo | null;
    readonly remoteAddress: string | null;
    readonly requestSize: number;
    readonly responseSize: number;
    readonly statusCode: number;
    readonly statusLine: string;
    readonly suspended: boolean;
    readonly thirdParty: boolean;
    readonly type: MozContentPolicyType;
    readonly urlClassification: MozUrlClassification | null;
    cancel(result: number, reason?: number): void;
    errorCheck(): void;
    getRequestHeader(header: string): string | null;
    getRequestHeaders(): MozHTTPHeader[];
    getResponseHeaders(): MozHTTPHeader[];
    matches(filter?: MozRequestFilter, extension?: WebExtensionPolicy | null, options?: MozRequestMatchOptions): boolean;
    redirectTo(url: URI): void;
    registerTraceableChannel(extension: WebExtensionPolicy, remoteTab: RemoteTab | null): void;
    resume(): void;
    setRequestHeader(header: string, value: string, merge?: boolean): void;
    setResponseHeader(header: string, value: string, merge?: boolean): void;
    suspend(profileMarkerText: string): void;
    upgradeToSecure(): void;
    addEventListener<K extends keyof ChannelWrapperEventMap>(type: K, listener: (this: ChannelWrapper, ev: ChannelWrapperEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof ChannelWrapperEventMap>(type: K, listener: (this: ChannelWrapper, ev: ChannelWrapperEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var ChannelWrapper: {
    prototype: ChannelWrapper;
    new(): ChannelWrapper;
    get(channel: MozChannel): ChannelWrapper;
    getRegisteredChannel(aChannelId: number, extension: WebExtensionPolicy, remoteTab: RemoteTab | null): ChannelWrapper | null;
    isInstance(obj): obj is ChannelWrapper;
};

/**
 * The CharacterData abstract interface represents a Node object that contains characters. This is an abstract interface, meaning there aren't any object of type CharacterData: it is implemented by other interfaces, like Text, Comment, or ProcessingInstruction which aren't abstract.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData)
 */
interface CharacterData extends Node, ChildNode, NonDocumentTypeChildNode {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/data) */
    data: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/appendData) */
    appendData(data: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/deleteData) */
    deleteData(offset: number, count: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/insertData) */
    insertData(offset: number, data: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/replaceData) */
    replaceData(offset: number, count: number, data: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/substringData) */
    substringData(offset: number, count: number): string;
}

declare var CharacterData: {
    prototype: CharacterData;
    new(): CharacterData;
    isInstance(obj): obj is CharacterData;
};

interface CheckerboardReportService {
    flushActiveReports(): void;
    getReports(): CheckerboardReport[];
    isRecordingEnabled(): boolean;
    setRecordingEnabled(aEnabled: boolean): void;
}

declare var CheckerboardReportService: {
    prototype: CheckerboardReportService;
    new(): CheckerboardReportService;
    isInstance(obj): obj is CheckerboardReportService;
};

interface ChildNode {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/after) */
    after(...nodes: (Node | string)[]): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/before) */
    before(...nodes: (Node | string)[]): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/remove) */
    remove(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/replaceWith) */
    replaceWith(...nodes: (Node | string)[]): void;
}

interface ChildProcessMessageManager extends SyncMessageSender {
}

declare var ChildProcessMessageManager: {
    prototype: ChildProcessMessageManager;
    new(): ChildProcessMessageManager;
    isInstance(obj): obj is ChildProcessMessageManager;
};

interface ChildSHistory {
    readonly count: number;
    readonly index: number;
    readonly legacySHistory: nsISHistory;
    canGo(aOffset: number): boolean;
    go(aOffset: number, aRequireUserInteraction?: boolean, aUserActivation?: boolean): void;
    reload(aReloadFlags: number): void;
}

declare var ChildSHistory: {
    prototype: ChildSHistory;
    new(): ChildSHistory;
    isInstance(obj): obj is ChildSHistory;
};

interface ChromeMessageBroadcaster extends MessageBroadcaster, FrameScriptLoader {
}

declare var ChromeMessageBroadcaster: {
    prototype: ChromeMessageBroadcaster;
    new(): ChromeMessageBroadcaster;
    isInstance(obj): obj is ChromeMessageBroadcaster;
};

interface ChromeMessageSender extends MessageSender, FrameScriptLoader {
}

declare var ChromeMessageSender: {
    prototype: ChromeMessageSender;
    new(): ChromeMessageSender;
    isInstance(obj): obj is ChromeMessageSender;
};

interface ChromeNodeList extends NodeList {
    append(aNode: Node): void;
    remove(aNode: Node): void;
}

declare var ChromeNodeList: {
    prototype: ChromeNodeList;
    new(): ChromeNodeList;
    isInstance(obj): obj is ChromeNodeList;
};

interface ChromeWorker extends Worker {
    addEventListener<K extends keyof WorkerEventMap>(type: K, listener: (this: ChromeWorker, ev: WorkerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof WorkerEventMap>(type: K, listener: (this: ChromeWorker, ev: WorkerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var ChromeWorker: {
    prototype: ChromeWorker;
    new(scriptURL: string | URL, options?: WorkerOptions): ChromeWorker;
    isInstance(obj): obj is ChromeWorker;
};

/**
 * The Client interface represents an executable context such as a Worker, or a SharedWorker. Window clients are represented by the more-specific WindowClient. You can get Client/WindowClient objects from methods such as Clients.matchAll() and Clients.get().
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Client)
 */
interface Client {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Client/frameType) */
    readonly frameType: FrameType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Client/id) */
    readonly id: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Client/type) */
    readonly type: ClientType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Client/url) */
    readonly url: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Client/postMessage) */
    postMessage(message: any, transfer: any[]): void;
    postMessage(message: any, aOptions?: StructuredSerializeOptions): void;
}

declare var Client: {
    prototype: Client;
    new(): Client;
    isInstance(obj): obj is Client;
};

/**
 * Provides access to Client objects. Access it via self.clients within a service worker.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clients)
 */
interface Clients {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clients/claim) */
    claim(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clients/get) */
    get(id: string): Promise<Client | undefined>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clients/matchAll) */
    matchAll(options?: ClientQueryOptions): Promise<Client[]>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clients/openWindow) */
    openWindow(url: string | URL): Promise<WindowClient | null>;
}

declare var Clients: {
    prototype: Clients;
    new(): Clients;
    isInstance(obj): obj is Clients;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clipboard)
 */
interface Clipboard extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clipboard/read) */
    read(): Promise<ClipboardItems>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clipboard/readText) */
    readText(): Promise<string>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clipboard/write) */
    write(data: ClipboardItems): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clipboard/writeText) */
    writeText(data: string): Promise<void>;
}

declare var Clipboard: {
    prototype: Clipboard;
    new(): Clipboard;
    isInstance(obj): obj is Clipboard;
};

/**
 * Events providing information related to modification of the clipboard, that is cut, copy, and paste events.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ClipboardEvent)
 */
interface ClipboardEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ClipboardEvent/clipboardData) */
    readonly clipboardData: DataTransfer | null;
}

declare var ClipboardEvent: {
    prototype: ClipboardEvent;
    new(type: string, eventInitDict?: ClipboardEventInit): ClipboardEvent;
    isInstance(obj): obj is ClipboardEvent;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ClipboardItem)
 */
interface ClipboardItem {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ClipboardItem/presentationStyle) */
    readonly presentationStyle: PresentationStyle;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ClipboardItem/types) */
    readonly types: string[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ClipboardItem/getType) */
    getType(type: string): Promise<Blob>;
}

declare var ClipboardItem: {
    prototype: ClipboardItem;
    new(items: Record<string, ClipboardItemDataType | PromiseLike<ClipboardItemDataType>>, options?: ClipboardItemOptions): ClipboardItem;
    isInstance(obj): obj is ClipboardItem;
};

interface ClonedErrorHolder {
}

declare var ClonedErrorHolder: {
    prototype: ClonedErrorHolder;
    new(aError: any): ClonedErrorHolder;
    isInstance(obj): obj is ClonedErrorHolder;
};

/**
 * A CloseEvent is sent to clients using WebSockets when the connection is closed. This is delivered to the listener indicated by the WebSocket object's onclose attribute.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CloseEvent)
 */
interface CloseEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CloseEvent/code) */
    readonly code: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CloseEvent/reason) */
    readonly reason: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CloseEvent/wasClean) */
    readonly wasClean: boolean;
}

declare var CloseEvent: {
    prototype: CloseEvent;
    new(type: string, eventInitDict?: CloseEventInit): CloseEvent;
    isInstance(obj): obj is CloseEvent;
};

interface CommandEvent extends Event {
    readonly command: string | null;
}

declare var CommandEvent: {
    prototype: CommandEvent;
    new(): CommandEvent;
    isInstance(obj): obj is CommandEvent;
};

/**
 * Textual notations within markup; although it is generally not visually shown, such comments are available to be read in the source view.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Comment)
 */
interface Comment extends CharacterData {
}

declare var Comment: {
    prototype: Comment;
    new(data?: string): Comment;
    isInstance(obj): obj is Comment;
};

/**
 * The DOM CompositionEvent represents events that occur due to the user indirectly entering text.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CompositionEvent)
 */
interface CompositionEvent extends UIEvent {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CompositionEvent/data) */
    readonly data: string | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CompositionEvent/locale)
     */
    readonly locale: string;
    readonly ranges: TextClause[];
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CompositionEvent/initCompositionEvent)
     */
    initCompositionEvent(typeArg: string, canBubbleArg?: boolean, cancelableArg?: boolean, viewArg?: Window | null, dataArg?: string | null, localeArg?: string): void;
}

declare var CompositionEvent: {
    prototype: CompositionEvent;
    new(type: string, eventInitDict?: CompositionEventInit): CompositionEvent;
    isInstance(obj): obj is CompositionEvent;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CompressionStream) */
interface CompressionStream extends GenericTransformStream {
}

declare var CompressionStream: {
    prototype: CompressionStream;
    new(format: CompressionFormat): CompressionStream;
    isInstance(obj): obj is CompressionStream;
};

interface ConsoleInstance {
    assert(condition?: boolean, ...data: any[]): void;
    clear(): void;
    count(label?: string): void;
    countReset(label?: string): void;
    debug(...data: any[]): void;
    dir(...data: any[]): void;
    dirxml(...data: any[]): void;
    error(...data: any[]): void;
    exception(...data: any[]): void;
    group(...data: any[]): void;
    groupCollapsed(...data: any[]): void;
    groupEnd(): void;
    info(...data: any[]): void;
    log(...data: any[]): void;
    profile(...data: any[]): void;
    profileEnd(...data: any[]): void;
    reportForServiceWorkerScope(scope: string, message: string, filename: string, lineNumber: number, columnNumber: number, level: ConsoleLevel): void;
    table(...data: any[]): void;
    time(label?: string): void;
    timeEnd(label?: string): void;
    timeLog(label?: string, ...data: any[]): void;
    timeStamp(data?: any): void;
    trace(...data: any[]): void;
    warn(...data: any[]): void;
}

declare var ConsoleInstance: {
    prototype: ConsoleInstance;
    new(): ConsoleInstance;
    isInstance(obj): obj is ConsoleInstance;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ConstantSourceNode) */
interface ConstantSourceNode extends AudioScheduledSourceNode {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ConstantSourceNode/offset) */
    readonly offset: AudioParam;
    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: ConstantSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: ConstantSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var ConstantSourceNode: {
    prototype: ConstantSourceNode;
    new(context: BaseAudioContext, options?: ConstantSourceOptions): ConstantSourceNode;
    isInstance(obj): obj is ConstantSourceNode;
};

interface ContentFrameMessageManager extends EventTarget, MessageListenerManagerMixin, MessageManagerGlobal, MessageSenderMixin, SyncMessageSenderMixin {
    readonly content: WindowProxy | null;
    readonly docShell: nsIDocShell | null;
    readonly tabEventTarget: nsIEventTarget | null;
}

declare var ContentFrameMessageManager: {
    prototype: ContentFrameMessageManager;
    new(): ContentFrameMessageManager;
    isInstance(obj): obj is ContentFrameMessageManager;
};

interface ContentProcessMessageManager extends MessageListenerManagerMixin, MessageManagerGlobal, MessageSenderMixin, SyncMessageSenderMixin {
    readonly initialProcessData: any;
    readonly sharedData: MozSharedMap | null;
}

declare var ContentProcessMessageManager: {
    prototype: ContentProcessMessageManager;
    new(): ContentProcessMessageManager;
    isInstance(obj): obj is ContentProcessMessageManager;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ContentVisibilityAutoStateChangeEvent) */
interface ContentVisibilityAutoStateChangeEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ContentVisibilityAutoStateChangeEvent/skipped) */
    readonly skipped: boolean;
}

declare var ContentVisibilityAutoStateChangeEvent: {
    prototype: ContentVisibilityAutoStateChangeEvent;
    new(type: string, eventInitDict?: ContentVisibilityAutoStateChangeEventInit): ContentVisibilityAutoStateChangeEvent;
    isInstance(obj): obj is ContentVisibilityAutoStateChangeEvent;
};

/**
 * An AudioNode that performs a Linear Convolution on a given AudioBuffer, often used to achieve a reverb effect. A ConvolverNode always has exactly one input and one output.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ConvolverNode)
 */
interface ConvolverNode extends AudioNode, AudioNodePassThrough {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ConvolverNode/buffer) */
    buffer: AudioBuffer | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ConvolverNode/normalize) */
    normalize: boolean;
}

declare var ConvolverNode: {
    prototype: ConvolverNode;
    new(context: BaseAudioContext, options?: ConvolverOptions): ConvolverNode;
    isInstance(obj): obj is ConvolverNode;
};

/**
 * This Streams API interface provides a built-in byte length queuing strategy that can be used when constructing streams.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CountQueuingStrategy)
 */
interface CountQueuingStrategy {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CountQueuingStrategy/highWaterMark) */
    readonly highWaterMark: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CountQueuingStrategy/size) */
    readonly size: Function;
}

declare var CountQueuingStrategy: {
    prototype: CountQueuingStrategy;
    new(init: QueuingStrategyInit): CountQueuingStrategy;
    isInstance(obj): obj is CountQueuingStrategy;
};

interface CreateOfferRequest {
    readonly callID: string;
    readonly innerWindowID: number;
    readonly isSecure: boolean;
    readonly windowID: number;
}

declare var CreateOfferRequest: {
    prototype: CreateOfferRequest;
    new(): CreateOfferRequest;
    isInstance(obj): obj is CreateOfferRequest;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Credential)
 */
interface Credential {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Credential/id) */
    readonly id: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Credential/type) */
    readonly type: string;
}

declare var Credential: {
    prototype: Credential;
    new(): Credential;
    isInstance(obj): obj is Credential;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CredentialsContainer)
 */
interface CredentialsContainer {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CredentialsContainer/create) */
    create(options?: CredentialCreationOptions): Promise<Credential | null>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CredentialsContainer/get) */
    get(options?: CredentialRequestOptions): Promise<Credential | null>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CredentialsContainer/preventSilentAccess) */
    preventSilentAccess(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CredentialsContainer/store) */
    store(credential: Credential): Promise<Credential>;
}

declare var CredentialsContainer: {
    prototype: CredentialsContainer;
    new(): CredentialsContainer;
    isInstance(obj): obj is CredentialsContainer;
};

/**
 * Basic cryptography features available in the current context. It allows access to a cryptographically strong random number generator and to cryptographic primitives.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Crypto)
 */
interface Crypto {
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Crypto/subtle)
     */
    readonly subtle: SubtleCrypto;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Crypto/getRandomValues) */
    getRandomValues(array: ArrayBufferView): ArrayBufferView;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Crypto/randomUUID)
     */
    randomUUID(): UTF8String;
}

declare var Crypto: {
    prototype: Crypto;
    new(): Crypto;
    isInstance(obj): obj is Crypto;
};

/**
 * The CryptoKey dictionary of the Web Crypto API represents a cryptographic key.
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CryptoKey)
 */
interface CryptoKey {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CryptoKey/algorithm) */
    readonly algorithm: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CryptoKey/extractable) */
    readonly extractable: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CryptoKey/type) */
    readonly type: KeyType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CryptoKey/usages) */
    readonly usages: KeyUsage[];
}

declare var CryptoKey: {
    prototype: CryptoKey;
    new(): CryptoKey;
    isInstance(obj): obj is CryptoKey;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomElementRegistry) */
interface CustomElementRegistry {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomElementRegistry/define) */
    define(name: string, constructor: CustomElementConstructor, options?: ElementDefinitionOptions): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomElementRegistry/get) */
    get(name: string): CustomElementConstructor | undefined;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomElementRegistry/getName) */
    getName(constructor: CustomElementConstructor): string | null;
    setElementCreationCallback(name: string, callback: CustomElementCreationCallback): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomElementRegistry/upgrade) */
    upgrade(root: Node): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomElementRegistry/whenDefined) */
    whenDefined(name: string): Promise<CustomElementConstructor>;
}

declare var CustomElementRegistry: {
    prototype: CustomElementRegistry;
    new(): CustomElementRegistry;
    isInstance(obj): obj is CustomElementRegistry;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomEvent) */
interface CustomEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomEvent/detail) */
    readonly detail: any;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomEvent/initCustomEvent)
     */
    initCustomEvent(type: string, canBubble?: boolean, cancelable?: boolean, detail?: any): void;
}

declare var CustomEvent: {
    prototype: CustomEvent;
    new(type: string, eventInitDict?: CustomEventInit): CustomEvent;
    isInstance(obj): obj is CustomEvent;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomStateSet) */
interface CustomStateSet {
    forEach(callbackfn: (value: string, key: string, parent: CustomStateSet) => void, thisArg?: any): void;
}

declare var CustomStateSet: {
    prototype: CustomStateSet;
    new(): CustomStateSet;
    isInstance(obj): obj is CustomStateSet;
};

/**
 * An abnormal event (called an exception) which occurs as a result of calling a method or accessing a property of a web API.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMException)
 */
interface DOMException extends ExceptionMembers {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMException/code)
     */
    readonly code: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMException/message) */
    readonly message: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMException/name) */
    readonly name: string;
    readonly INDEX_SIZE_ERR: 1;
    readonly DOMSTRING_SIZE_ERR: 2;
    readonly HIERARCHY_REQUEST_ERR: 3;
    readonly WRONG_DOCUMENT_ERR: 4;
    readonly INVALID_CHARACTER_ERR: 5;
    readonly NO_DATA_ALLOWED_ERR: 6;
    readonly NO_MODIFICATION_ALLOWED_ERR: 7;
    readonly NOT_FOUND_ERR: 8;
    readonly NOT_SUPPORTED_ERR: 9;
    readonly INUSE_ATTRIBUTE_ERR: 10;
    readonly INVALID_STATE_ERR: 11;
    readonly SYNTAX_ERR: 12;
    readonly INVALID_MODIFICATION_ERR: 13;
    readonly NAMESPACE_ERR: 14;
    readonly INVALID_ACCESS_ERR: 15;
    readonly VALIDATION_ERR: 16;
    readonly TYPE_MISMATCH_ERR: 17;
    readonly SECURITY_ERR: 18;
    readonly NETWORK_ERR: 19;
    readonly ABORT_ERR: 20;
    readonly URL_MISMATCH_ERR: 21;
    readonly QUOTA_EXCEEDED_ERR: 22;
    readonly TIMEOUT_ERR: 23;
    readonly INVALID_NODE_TYPE_ERR: 24;
    readonly DATA_CLONE_ERR: 25;
}

declare var DOMException: {
    prototype: DOMException;
    new(message?: string, name?: string): DOMException;
    readonly INDEX_SIZE_ERR: 1;
    readonly DOMSTRING_SIZE_ERR: 2;
    readonly HIERARCHY_REQUEST_ERR: 3;
    readonly WRONG_DOCUMENT_ERR: 4;
    readonly INVALID_CHARACTER_ERR: 5;
    readonly NO_DATA_ALLOWED_ERR: 6;
    readonly NO_MODIFICATION_ALLOWED_ERR: 7;
    readonly NOT_FOUND_ERR: 8;
    readonly NOT_SUPPORTED_ERR: 9;
    readonly INUSE_ATTRIBUTE_ERR: 10;
    readonly INVALID_STATE_ERR: 11;
    readonly SYNTAX_ERR: 12;
    readonly INVALID_MODIFICATION_ERR: 13;
    readonly NAMESPACE_ERR: 14;
    readonly INVALID_ACCESS_ERR: 15;
    readonly VALIDATION_ERR: 16;
    readonly TYPE_MISMATCH_ERR: 17;
    readonly SECURITY_ERR: 18;
    readonly NETWORK_ERR: 19;
    readonly ABORT_ERR: 20;
    readonly URL_MISMATCH_ERR: 21;
    readonly QUOTA_EXCEEDED_ERR: 22;
    readonly TIMEOUT_ERR: 23;
    readonly INVALID_NODE_TYPE_ERR: 24;
    readonly DATA_CLONE_ERR: 25;
    isInstance(obj): obj is DOMException;
};

/**
 * An object providing methods which are not dependent on any particular document. Such an object is returned by the Document.implementation property.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMImplementation)
 */
interface DOMImplementation {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMImplementation/createDocument) */
    createDocument(namespace: string | null, qualifiedName: string | null, doctype?: DocumentType | null): Document;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMImplementation/createDocumentType) */
    createDocumentType(qualifiedName: string, publicId: string, systemId: string): DocumentType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMImplementation/createHTMLDocument) */
    createHTMLDocument(title?: string): Document;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMImplementation/hasFeature)
     */
    hasFeature(): boolean;
}

declare var DOMImplementation: {
    prototype: DOMImplementation;
    new(): DOMImplementation;
    isInstance(obj): obj is DOMImplementation;
};

interface DOMLocalization extends Localization {
    connectRoot(aElement: Node): void;
    disconnectRoot(aElement: Node): void;
    getAttributes(aElement: Element): L10nIdArgs;
    pauseObserving(): void;
    resumeObserving(): void;
    setArgs(aElement: Element, aArgs?: any): void;
    setAttributes(aElement: Element, aId: string, aArgs?: any): void;
    translateElements(aElements: Element[]): Promise<void>;
    translateFragment(aNode: Node): Promise<any>;
    translateRoots(): Promise<void>;
}

declare var DOMLocalization: {
    prototype: DOMLocalization;
    new(aResourceIds: L10nResourceId[], aSync?: boolean, aRegistry?: L10nRegistry, aLocales?: UTF8String[]): DOMLocalization;
    isInstance(obj): obj is DOMLocalization;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix) */
interface DOMMatrix extends DOMMatrixReadOnly {
    a: number;
    b: number;
    c: number;
    d: number;
    e: number;
    f: number;
    m11: number;
    m12: number;
    m13: number;
    m14: number;
    m21: number;
    m22: number;
    m23: number;
    m24: number;
    m31: number;
    m32: number;
    m33: number;
    m34: number;
    m41: number;
    m42: number;
    m43: number;
    m44: number;
    invertSelf(): DOMMatrix;
    multiplySelf(other?: DOMMatrixInit): DOMMatrix;
    preMultiplySelf(other?: DOMMatrixInit): DOMMatrix;
    rotateAxisAngleSelf(x?: number, y?: number, z?: number, angle?: number): DOMMatrix;
    rotateFromVectorSelf(x?: number, y?: number): DOMMatrix;
    rotateSelf(rotX?: number, rotY?: number, rotZ?: number): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/scale3dSelf) */
    scale3dSelf(scale?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/scaleSelf) */
    scaleSelf(scaleX?: number, scaleY?: number, scaleZ?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;
    setMatrixValue(transformList: UTF8String): DOMMatrix;
    skewXSelf(sx?: number): DOMMatrix;
    skewYSelf(sy?: number): DOMMatrix;
    translateSelf(tx?: number, ty?: number, tz?: number): DOMMatrix;
}

declare var DOMMatrix: {
    prototype: DOMMatrix;
    new(init?: UTF8String | number[] | DOMMatrixReadOnly): DOMMatrix;
    fromFloat32Array(array32: Float32Array): DOMMatrix;
    fromFloat64Array(array64: Float64Array): DOMMatrix;
    fromMatrix(other?: DOMMatrixInit): DOMMatrix;
    isInstance(obj): obj is DOMMatrix;
};

type WebKitCSSMatrix = DOMMatrix;
declare var WebKitCSSMatrix: typeof DOMMatrix;

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly) */
interface DOMMatrixReadOnly {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/a) */
    readonly a: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/b) */
    readonly b: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/c) */
    readonly c: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/d) */
    readonly d: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/e) */
    readonly e: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/f) */
    readonly f: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/is2D) */
    readonly is2D: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/isIdentity) */
    readonly isIdentity: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m11) */
    readonly m11: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m12) */
    readonly m12: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m13) */
    readonly m13: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m14) */
    readonly m14: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m21) */
    readonly m21: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m22) */
    readonly m22: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m23) */
    readonly m23: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m24) */
    readonly m24: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m31) */
    readonly m31: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m32) */
    readonly m32: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m33) */
    readonly m33: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m34) */
    readonly m34: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m41) */
    readonly m41: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m42) */
    readonly m42: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m43) */
    readonly m43: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/m44) */
    readonly m44: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/flipX) */
    flipX(): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/flipY) */
    flipY(): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/inverse) */
    inverse(): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/multiply) */
    multiply(other?: DOMMatrixInit): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/rotate) */
    rotate(rotX?: number, rotY?: number, rotZ?: number): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/rotateAxisAngle) */
    rotateAxisAngle(x?: number, y?: number, z?: number, angle?: number): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/rotateFromVector) */
    rotateFromVector(x?: number, y?: number): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/scale) */
    scale(scaleX?: number, scaleY?: number, scaleZ?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/scale3d) */
    scale3d(scale?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/scaleNonUniform)
     */
    scaleNonUniform(scaleX?: number, scaleY?: number): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/skewX) */
    skewX(sx?: number): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/skewY) */
    skewY(sy?: number): DOMMatrix;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/toFloat32Array) */
    toFloat32Array(): Float32Array;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/toFloat64Array) */
    toFloat64Array(): Float64Array;
    toJSON(): any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/transformPoint) */
    transformPoint(point?: DOMPointInit): DOMPoint;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/translate) */
    translate(tx?: number, ty?: number, tz?: number): DOMMatrix;
    toString(): string;
}

declare var DOMMatrixReadOnly: {
    prototype: DOMMatrixReadOnly;
    new(init?: UTF8String | number[] | DOMMatrixReadOnly): DOMMatrixReadOnly;
    fromFloat32Array(array32: Float32Array): DOMMatrixReadOnly;
    fromFloat64Array(array64: Float64Array): DOMMatrixReadOnly;
    fromMatrix(other?: DOMMatrixInit): DOMMatrixReadOnly;
    isInstance(obj): obj is DOMMatrixReadOnly;
};

/**
 * Provides the ability to parse XML or HTML source code from a string into a DOM Document.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMParser)
 */
interface DOMParser {
    forceEnableDTD(): void;
    forceEnableXULXBL(): void;
    parseFromBuffer(buf: number[], type: SupportedType): Document;
    parseFromBuffer(buf: Uint8Array, type: SupportedType): Document;
    parseFromSafeString(str: string, type: SupportedType): Document;
    parseFromStream(stream: InputStream, charset: string | null, contentLength: number, type: SupportedType): Document;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMParser/parseFromString) */
    parseFromString(str: string, type: SupportedType): Document;
}

declare var DOMParser: {
    prototype: DOMParser;
    new(): DOMParser;
    isInstance(obj): obj is DOMParser;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPoint) */
interface DOMPoint extends DOMPointReadOnly {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPoint/w) */
    w: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPoint/x) */
    x: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPoint/y) */
    y: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPoint/z) */
    z: number;
}

declare var DOMPoint: {
    prototype: DOMPoint;
    new(x?: number, y?: number, z?: number, w?: number): DOMPoint;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPoint/fromPoint_static) */
    fromPoint(other?: DOMPointInit): DOMPoint;
    isInstance(obj): obj is DOMPoint;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly) */
interface DOMPointReadOnly {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/w) */
    readonly w: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/x) */
    readonly x: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/y) */
    readonly y: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/z) */
    readonly z: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/matrixTransform) */
    matrixTransform(matrix?: DOMMatrixInit): DOMPoint;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/toJSON) */
    toJSON(): any;
}

declare var DOMPointReadOnly: {
    prototype: DOMPointReadOnly;
    new(x?: number, y?: number, z?: number, w?: number): DOMPointReadOnly;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/fromPoint_static) */
    fromPoint(other?: DOMPointInit): DOMPointReadOnly;
    isInstance(obj): obj is DOMPointReadOnly;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMQuad) */
interface DOMQuad {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMQuad/p1) */
    readonly p1: DOMPoint;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMQuad/p2) */
    readonly p2: DOMPoint;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMQuad/p3) */
    readonly p3: DOMPoint;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMQuad/p4) */
    readonly p4: DOMPoint;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMQuad/getBounds) */
    getBounds(): DOMRectReadOnly;
    toJSON(): any;
}

declare var DOMQuad: {
    prototype: DOMQuad;
    new(p1?: DOMPointInit, p2?: DOMPointInit, p3?: DOMPointInit, p4?: DOMPointInit): DOMQuad;
    new(rect: DOMRectReadOnly): DOMQuad;
    fromQuad(other?: DOMQuadInit): DOMQuad;
    fromRect(other?: DOMRectInit): DOMQuad;
    isInstance(obj): obj is DOMQuad;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRect) */
interface DOMRect extends DOMRectReadOnly {
    height: number;
    width: number;
    x: number;
    y: number;
}

declare var DOMRect: {
    prototype: DOMRect;
    new(x?: number, y?: number, width?: number, height?: number): DOMRect;
    fromRect(other?: DOMRectInit): DOMRect;
    isInstance(obj): obj is DOMRect;
};

interface DOMRectList {
    readonly length: number;
    item(index: number): DOMRect | null;
    [index: number]: DOMRect;
}

declare var DOMRectList: {
    prototype: DOMRectList;
    new(): DOMRectList;
    isInstance(obj): obj is DOMRectList;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly) */
interface DOMRectReadOnly {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/bottom) */
    readonly bottom: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/height) */
    readonly height: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/left) */
    readonly left: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/right) */
    readonly right: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/top) */
    readonly top: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/width) */
    readonly width: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/x) */
    readonly x: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/y) */
    readonly y: number;
    toJSON(): any;
}

declare var DOMRectReadOnly: {
    prototype: DOMRectReadOnly;
    new(x?: number, y?: number, width?: number, height?: number): DOMRectReadOnly;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/fromRect_static) */
    fromRect(other?: DOMRectInit): DOMRectReadOnly;
    isInstance(obj): obj is DOMRectReadOnly;
};

interface DOMRequest extends EventTarget, DOMRequestShared {
    fireDetailedError(aError: DOMException): void;
    then(fulfillCallback?: AnyCallback | null, rejectCallback?: AnyCallback | null): any;
    addEventListener<K extends keyof DOMRequestSharedEventMap>(type: K, listener: (this: DOMRequest, ev: DOMRequestSharedEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof DOMRequestSharedEventMap>(type: K, listener: (this: DOMRequest, ev: DOMRequestSharedEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var DOMRequest: {
    prototype: DOMRequest;
    new(): DOMRequest;
    isInstance(obj): obj is DOMRequest;
};

interface DOMRequestSharedEventMap {
    "error": ErrorEvent;
    "success": Event;
}

interface DOMRequestShared {
    "error": ErrorEvent;
    onerror: OnErrorEventHandler;
    onsuccess: ((this: DOMRequestShared, ev: Event) => any) | null;
    readonly readyState: DOMRequestReadyState;
    readonly result: any;
    addEventListener<K extends keyof DOMRequestSharedEventMap>(type: K, listener: (this: DOMRequestShared, ev: DOMRequestSharedEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof DOMRequestSharedEventMap>(type: K, listener: (this: DOMRequestShared, ev: DOMRequestSharedEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

/**
 * A type returned by some APIs which contains a list of DOMString (strings).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMStringList)
 */
interface DOMStringList {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMStringList/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMStringList/contains) */
    contains(string: string): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMStringList/item) */
    item(index: number): string | null;
    [index: number]: string;
}

declare var DOMStringList: {
    prototype: DOMStringList;
    new(): DOMStringList;
    isInstance(obj): obj is DOMStringList;
};

/**
 * Used by the dataset HTML attribute to represent data for custom attributes added to elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMStringMap)
 */
interface DOMStringMap {
}

declare var DOMStringMap: {
    prototype: DOMStringMap;
    new(): DOMStringMap;
    isInstance(obj): obj is DOMStringMap;
};

/**
 * A set of space-separated tokens. Such a set is returned by Element.classList, HTMLLinkElement.relList, HTMLAnchorElement.relList, HTMLAreaElement.relList, HTMLIframeElement.sandbox, or HTMLOutputElement.htmlFor. It is indexed beginning with 0 as with JavaScript Array objects. DOMTokenList is always case-sensitive.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList)
 */
interface DOMTokenList {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/value) */
    value: string;
    toString(): string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/add) */
    add(...tokens: string[]): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/contains) */
    contains(token: string): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/item) */
    item(index: number): string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/remove) */
    remove(...tokens: string[]): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/replace) */
    replace(token: string, newToken: string): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/supports) */
    supports(token: string): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/toggle) */
    toggle(token: string, force?: boolean): boolean;
    forEach(callbackfn: (value: string | null, key: number, parent: DOMTokenList) => void, thisArg?: any): void;
    [index: number]: string;
}

declare var DOMTokenList: {
    prototype: DOMTokenList;
    new(): DOMTokenList;
    isInstance(obj): obj is DOMTokenList;
};

/**
 * Used to hold the data that is being dragged during a drag and drop operation. It may hold one or more data items, each of one or more data types. For more information about drag and drop, see HTML Drag and Drop API.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer)
 */
interface DataTransfer {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/dropEffect) */
    dropEffect: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/effectAllowed) */
    effectAllowed: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/files) */
    readonly files: FileList | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/items) */
    readonly items: DataTransferItemList;
    readonly mozCSP: ContentSecurityPolicy | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/mozCursor) */
    mozCursor: string;
    readonly mozItemCount: number;
    mozShowFailAnimation: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/mozSourceNode) */
    readonly mozSourceNode: Node | null;
    readonly mozTriggeringPrincipalURISpec: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/mozUserCancelled) */
    readonly mozUserCancelled: boolean;
    readonly sourceTopWindowContext: WindowContext | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/types) */
    readonly types: string[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/addElement) */
    addElement(element: Element): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/clearData) */
    clearData(format?: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/getData) */
    getData(format: string): string;
    mozClearDataAt(format: string, index: number): void;
    mozCloneForEvent(event: string): DataTransfer;
    mozGetDataAt(format: string, index: number): any;
    mozSetDataAt(format: string, data: any, index: number): void;
    mozTypesAt(index: number): DOMStringList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/setData) */
    setData(format: string, data: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/setDragImage) */
    setDragImage(image: Element, x: number, y: number): void;
    updateDragImage(image: Element, x: number, y: number): void;
}

declare var DataTransfer: {
    prototype: DataTransfer;
    new(): DataTransfer;
    isInstance(obj): obj is DataTransfer;
};

/**
 * One drag data item. During a drag operation, each drag event has a dataTransfer property which contains a list of drag data items. Each item in the list is a DataTransferItem object.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItem)
 */
interface DataTransferItem {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItem/kind) */
    readonly kind: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItem/type) */
    readonly type: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItem/getAsFile) */
    getAsFile(): File | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItem/getAsString) */
    getAsString(callback: FunctionStringCallback | null): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItem/webkitGetAsEntry) */
    webkitGetAsEntry(): FileSystemEntry | null;
}

declare var DataTransferItem: {
    prototype: DataTransferItem;
    new(): DataTransferItem;
    isInstance(obj): obj is DataTransferItem;
};

/**
 * A list of DataTransferItem objects representing items being dragged. During a drag operation, each DragEvent has a dataTransfer property and that property is a DataTransferItemList.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItemList)
 */
interface DataTransferItemList {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItemList/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItemList/add) */
    add(data: string, type: string): DataTransferItem | null;
    add(data: File): DataTransferItem | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItemList/clear) */
    clear(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItemList/remove) */
    remove(index: number): void;
    [index: number]: DataTransferItem;
}

declare var DataTransferItemList: {
    prototype: DataTransferItemList;
    new(): DataTransferItemList;
    isInstance(obj): obj is DataTransferItemList;
};

interface DebuggerNotification {
    readonly global: any;
    readonly type: DebuggerNotificationType;
}

declare var DebuggerNotification: {
    prototype: DebuggerNotification;
    new(): DebuggerNotification;
    isInstance(obj): obj is DebuggerNotification;
};

interface DebuggerNotificationObserver {
    addListener(handler: DebuggerNotificationCallback): boolean;
    connect(global: any): boolean;
    disconnect(global: any): boolean;
    removeListener(handler: DebuggerNotificationCallback): boolean;
}

declare var DebuggerNotificationObserver: {
    prototype: DebuggerNotificationObserver;
    new(): DebuggerNotificationObserver;
    isInstance(obj): obj is DebuggerNotificationObserver;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DecompressionStream) */
interface DecompressionStream extends GenericTransformStream {
}

declare var DecompressionStream: {
    prototype: DecompressionStream;
    new(format: CompressionFormat): DecompressionStream;
    isInstance(obj): obj is DecompressionStream;
};

interface DedicatedWorkerGlobalScopeEventMap extends WorkerGlobalScopeEventMap {
    "message": Event;
    "messageerror": Event;
    "rtctransform": Event;
}

/**
 * (the Worker global scope) is accessible through the self keyword. Some additional global functions, namespaces objects, and constructors, not typically associated with the worker global scope, but available on it, are listed in the JavaScript Reference. See also: Functions available to workers.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DedicatedWorkerGlobalScope)
 */
interface DedicatedWorkerGlobalScope extends WorkerGlobalScope, AnimationFrameProvider {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DedicatedWorkerGlobalScope/name) */
    readonly name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DedicatedWorkerGlobalScope/message_event) */
    onmessage: ((this: DedicatedWorkerGlobalScope, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DedicatedWorkerGlobalScope/messageerror_event) */
    onmessageerror: ((this: DedicatedWorkerGlobalScope, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DedicatedWorkerGlobalScope/rtctransform_event) */
    onrtctransform: ((this: DedicatedWorkerGlobalScope, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DedicatedWorkerGlobalScope/close) */
    close(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DedicatedWorkerGlobalScope/postMessage) */
    postMessage(message: any, transfer: any[]): void;
    postMessage(message: any, options?: StructuredSerializeOptions): void;
    addEventListener<K extends keyof DedicatedWorkerGlobalScopeEventMap>(type: K, listener: (this: DedicatedWorkerGlobalScope, ev: DedicatedWorkerGlobalScopeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof DedicatedWorkerGlobalScopeEventMap>(type: K, listener: (this: DedicatedWorkerGlobalScope, ev: DedicatedWorkerGlobalScopeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var DedicatedWorkerGlobalScope: {
    prototype: DedicatedWorkerGlobalScope;
    new(): DedicatedWorkerGlobalScope;
    isInstance(obj): obj is DedicatedWorkerGlobalScope;
};

/**
 * A delay-line; an AudioNode audio-processing module that causes a delay between the arrival of an input data and its propagation to the output.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DelayNode)
 */
interface DelayNode extends AudioNode, AudioNodePassThrough {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DelayNode/delayTime) */
    readonly delayTime: AudioParam;
}

declare var DelayNode: {
    prototype: DelayNode;
    new(context: BaseAudioContext, options?: DelayOptions): DelayNode;
    isInstance(obj): obj is DelayNode;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeprecationReportBody) */
interface DeprecationReportBody extends ReportBody {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeprecationReportBody/anticipatedRemoval) */
    readonly anticipatedRemoval: DOMTimeStamp | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeprecationReportBody/columnNumber) */
    readonly columnNumber: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeprecationReportBody/id) */
    readonly id: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeprecationReportBody/lineNumber) */
    readonly lineNumber: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeprecationReportBody/message) */
    readonly message: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeprecationReportBody/sourceFile) */
    readonly sourceFile: string | null;
}

declare var DeprecationReportBody: {
    prototype: DeprecationReportBody;
    new(): DeprecationReportBody;
    isInstance(obj): obj is DeprecationReportBody;
};

/** Provides information about the amount of acceleration the device is experiencing along all three axes. */
interface DeviceAcceleration {
    readonly x: number | null;
    readonly y: number | null;
    readonly z: number | null;
}

/** The DeviceLightEvent provides web developers with information from photo sensors or similiar detectors about ambient light levels near the device. For example this may be useful to adjust the screen's brightness based on the current ambient light level in order to save energy or provide better readability. */
interface DeviceLightEvent extends Event {
    readonly value: number;
}

declare var DeviceLightEvent: {
    prototype: DeviceLightEvent;
    new(type: string, eventInitDict?: DeviceLightEventInit): DeviceLightEvent;
    isInstance(obj): obj is DeviceLightEvent;
};

/**
 * The DeviceMotionEvent provides web developers with information about the speed of changes for the device's position and orientation.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEvent)
 */
interface DeviceMotionEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEvent/acceleration) */
    readonly acceleration: DeviceAcceleration | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEvent/accelerationIncludingGravity) */
    readonly accelerationIncludingGravity: DeviceAcceleration | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEvent/interval) */
    readonly interval: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEvent/rotationRate) */
    readonly rotationRate: DeviceRotationRate | null;
    initDeviceMotionEvent(type: string, canBubble?: boolean, cancelable?: boolean, acceleration?: DeviceAccelerationInit, accelerationIncludingGravity?: DeviceAccelerationInit, rotationRate?: DeviceRotationRateInit, interval?: number | null): void;
}

declare var DeviceMotionEvent: {
    prototype: DeviceMotionEvent;
    new(type: string, eventInitDict?: DeviceMotionEventInit): DeviceMotionEvent;
    isInstance(obj): obj is DeviceMotionEvent;
};

/**
 * The DeviceOrientationEvent provides web developers with information from the physical orientation of the device running the web page.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceOrientationEvent)
 */
interface DeviceOrientationEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceOrientationEvent/absolute) */
    readonly absolute: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceOrientationEvent/alpha) */
    readonly alpha: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceOrientationEvent/beta) */
    readonly beta: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceOrientationEvent/gamma) */
    readonly gamma: number | null;
    initDeviceOrientationEvent(type: string, canBubble?: boolean, cancelable?: boolean, alpha?: number | null, beta?: number | null, gamma?: number | null, absolute?: boolean): void;
}

declare var DeviceOrientationEvent: {
    prototype: DeviceOrientationEvent;
    new(type: string, eventInitDict?: DeviceOrientationEventInit): DeviceOrientationEvent;
    isInstance(obj): obj is DeviceOrientationEvent;
};

/** Provides information about the rate at which the device is rotating around all three axes. */
interface DeviceRotationRate {
    readonly alpha: number | null;
    readonly beta: number | null;
    readonly gamma: number | null;
}

interface Directory {
    readonly name: string;
    readonly path: string;
    getFiles(recursiveFlag?: boolean): Promise<File[]>;
    getFilesAndDirectories(): Promise<(File | Directory)[]>;
}

declare var Directory: {
    prototype: Directory;
    new(path: string): Directory;
    isInstance(obj): obj is Directory;
};

interface DocumentEventMap extends GlobalEventHandlersEventMap, OnErrorEventHandlerForNodesEventMap, TouchEventHandlersEventMap {
    "afterscriptexecute": Event;
    "beforescriptexecute": Event;
    "fullscreenchange": Event;
    "fullscreenerror": Event;
    "pointerlockchange": Event;
    "pointerlockerror": Event;
    "readystatechange": Event;
    "visibilitychange": Event;
}

/**
 * Any web page loaded in the browser and serves as an entry point into the web page's content, which is the DOM tree.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document)
 */
interface Document extends Node, DocumentOrShadowRoot, FontFaceSource, GeometryUtils, GlobalEventHandlers, OnErrorEventHandlerForNodes, ParentNode, TouchEventHandlers, XPathEvaluatorMixin {
    /**
     * Sets or gets the URL for the current document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/URL)
     */
    readonly URL: string;
    /**
     * Sets or gets the color of all active links in the document.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/alinkColor)
     */
    alinkColor: string;
    /**
     * Returns a reference to the collection of elements contained by the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/all)
     */
    readonly all: HTMLAllCollection;
    /**
     * Retrieves a collection of all a objects that have a name and/or id property. Objects in this collection are in HTML source order.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/anchors)
     */
    readonly anchors: HTMLCollection;
    /**
     * Retrieves a collection of all applet objects in the document.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/applets)
     */
    readonly applets: HTMLCollection;
    /**
     * Deprecated. Sets or retrieves a value that indicates the background color behind the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/bgColor)
     */
    bgColor: string;
    readonly blockedNodeByClassifierCount: number;
    readonly blockedNodesByClassifier: NodeList;
    /**
     * Specifies the beginning and end of the document body.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/body)
     */
    body: HTMLElement | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/characterSet) */
    readonly characterSet: string;
    /**
     * Gets or sets the character set used to encode the object.
     * @deprecated This is a legacy alias of `characterSet`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/characterSet)
     */
    readonly charset: string;
    readonly commandDispatcher: XULCommandDispatcher | null;
    /**
     * Gets a value that indicates whether standards-compliant mode is switched on for the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/compatMode)
     */
    readonly compatMode: string;
    readonly contentLanguage: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/contentType) */
    readonly contentType: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/cookie) */
    cookie: string;
    readonly cookieJarSettings: nsICookieJarSettings;
    readonly csp: ContentSecurityPolicy | null;
    readonly cspJSON: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/currentScript) */
    readonly currentScript: Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/defaultView) */
    readonly defaultView: WindowProxy | null;
    /**
     * Sets or gets a value that indicates whether the document can be edited.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/designMode)
     */
    designMode: string;
    devToolsAnonymousAndShadowEventsEnabled: boolean;
    devToolsWatchingDOMMutations: boolean;
    /**
     * Sets or retrieves a value that indicates the reading order of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/dir)
     */
    dir: string;
    /**
     * Gets an object representing the document type declaration associated with the current document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/doctype)
     */
    readonly doctype: DocumentType | null;
    /**
     * Gets a reference to the root node of the document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/documentElement)
     */
    readonly documentElement: Element | null;
    readonly documentLoadGroup: nsILoadGroup | null;
    readonly documentReadyForIdle: Promise<undefined>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/documentURI) */
    readonly documentURI: string;
    readonly documentURIObject: URI | null;
    /**
     * Sets or gets the security domain of the document.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/domain)
     */
    domain: string;
    readonly effectiveStoragePrincipal: Principal;
    /**
     * Retrieves a collection of all embed objects in the document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/embeds)
     */
    readonly embeds: HTMLCollection;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/featurePolicy) */
    readonly featurePolicy: FeaturePolicy;
    /**
     * Sets or gets the foreground (text) color of the document.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fgColor)
     */
    fgColor: string;
    /**
     * Retrieves a collection, in source order, of all form objects in the document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/forms)
     */
    readonly forms: HTMLCollection;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fullscreen)
     */
    readonly fullscreen: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fullscreenEnabled) */
    readonly fullscreenEnabled: boolean;
    readonly hasBeenUserGestureActivated: boolean;
    readonly hasPendingL10nMutations: boolean;
    readonly hasValidTransientUserGestureActivation: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/head) */
    readonly head: HTMLHeadElement | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/hidden) */
    readonly hidden: boolean;
    /**
     * Retrieves a collection, in source order, of img objects in the document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/images)
     */
    readonly images: HTMLCollection;
    /**
     * Gets the implementation object of the current document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/implementation)
     */
    readonly implementation: DOMImplementation;
    /**
     * Returns the character encoding used to create the webpage that is loaded into the document object.
     * @deprecated This is a legacy alias of `characterSet`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/characterSet)
     */
    readonly inputEncoding: string;
    readonly isInitialDocument: boolean;
    readonly isSrcdocDocument: boolean;
    readonly l10n: DocumentL10n | null;
    /**
     * Gets the date that the page was last modified, if the page supplies one.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/lastModified)
     */
    readonly lastModified: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/lastStyleSheetSet)
     */
    readonly lastStyleSheetSet: string | null;
    readonly lastUserGestureTimeStamp: DOMHighResTimeStamp;
    /**
     * Sets or gets the color of the document links.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/linkColor)
     */
    linkColor: string;
    /**
     * Retrieves a collection of all a objects that specify the href property and all area objects in the document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/links)
     */
    readonly links: HTMLCollection;
    readonly loadedFromPrototype: boolean;
    /**
     * Contains information about the current URL.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/location)
     */
    readonly location: Location | null;
    readonly mozDocumentURIIfNotForErrorPages: URI | null;
    /**
     * @deprecated This is a legacy alias of `fullscreen`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fullscreen)
     */
    readonly mozFullScreen: boolean;
    /**
     * @deprecated This is a legacy alias of `fullscreenEnabled`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fullscreenEnabled)
     */
    readonly mozFullScreenEnabled: boolean;
    readonly mozSyntheticDocument: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/afterscriptexecute_event) */
    onafterscriptexecute: ((this: Document, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/beforescriptexecute_event) */
    onbeforescriptexecute: ((this: Document, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fullscreenchange_event) */
    onfullscreenchange: ((this: Document, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fullscreenerror_event) */
    onfullscreenerror: ((this: Document, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/pointerlockchange_event) */
    onpointerlockchange: ((this: Document, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/pointerlockerror_event) */
    onpointerlockerror: ((this: Document, ev: Event) => any) | null;
    /**
     * Fires when the state of the object has changed.
     * @param ev The event
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/readystatechange_event)
     */
    onreadystatechange: ((this: Document, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/visibilitychange_event) */
    onvisibilitychange: ((this: Document, ev: Event) => any) | null;
    readonly partitionedPrincipal: Principal;
    readonly permDelegateHandler: nsIPermissionDelegateHandler;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/plugins) */
    readonly plugins: HTMLCollection;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/preferredStyleSheetSet)
     */
    readonly preferredStyleSheetSet: string | null;
    /**
     * Retrieves a value that indicates the current state of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/readyState)
     */
    readonly readyState: string;
    /**
     * Gets the URL of the location that referred the user to the current page.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/referrer)
     */
    readonly referrer: string;
    readonly referrerInfo: nsIReferrerInfo;
    readonly referrerPolicy: ReferrerPolicy;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/rootElement)
     */
    readonly rootElement: SVGSVGElement | null;
    readonly sandboxFlagsAsString: string | null;
    /**
     * Retrieves a collection of all script objects in the document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/scripts)
     */
    readonly scripts: HTMLCollection;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/scrollingElement) */
    readonly scrollingElement: Element | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/selectedStyleSheetSet)
     */
    selectedStyleSheetSet: string | null;
    styleSheetChangeEventsEnabled: boolean;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/styleSheetSets)
     */
    readonly styleSheetSets: DOMStringList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/timeline) */
    readonly timeline: DocumentTimeline;
    /**
     * Contains the title of the document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/title)
     */
    title: string;
    readonly userHasInteracted: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/visibilityState) */
    readonly visibilityState: VisibilityState;
    /**
     * Sets or gets the color of the links that the user has visited.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/vlinkColor)
     */
    vlinkColor: string;
    addCertException(isTemporary: boolean): Promise<any>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/adoptNode) */
    adoptNode(node: Node): Node;
    blockParsing(promise: any, options?: BlockParsingOptions): Promise<any>;
    blockUnblockOnload(block: boolean): void;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/captureEvents)
     */
    captureEvents(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/caretPositionFromPoint) */
    caretPositionFromPoint(x: number, y: number): CaretPosition | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/clear)
     */
    clear(): void;
    clearUserGestureActivation(): void;
    /**
     * Closes an output stream and forces the sent data to display.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/close)
     */
    close(): void;
    completeStorageAccessRequestFromSite(serializedSite: string): Promise<void>;
    consumeTransientUserGestureActivation(): boolean;
    /**
     * Creates an attribute object with a specified name.
     * @param name String that sets the attribute object's name.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createAttribute)
     */
    createAttribute(name: string): Attr;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createAttributeNS) */
    createAttributeNS(namespace: string | null, name: string): Attr;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createCDATASection) */
    createCDATASection(data: string): CDATASection;
    /**
     * Creates a comment object with the specified data.
     * @param data Sets the comment object's data.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createComment)
     */
    createComment(data: string): Comment;
    /**
     * Creates a new document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createDocumentFragment)
     */
    createDocumentFragment(): DocumentFragment;
    /**
     * Creates an instance of the element for the specified tag.
     * @param tagName The name of an element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createElement)
     */
    createElement<K extends keyof HTMLElementTagNameMap>(tagName: K, options?: ElementCreationOptions): HTMLElementTagNameMap[K];
    /** @deprecated */
    createElement<K extends keyof HTMLElementDeprecatedTagNameMap>(tagName: K, options?: ElementCreationOptions): HTMLElementDeprecatedTagNameMap[K];
    createElement(tagName: string, options?: ElementCreationOptions): HTMLElement;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createElementNS) */
    createElementNS(namespace: string | null, qualifiedName: string, options?: ElementCreationOptions | string): Element;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createEvent) */
    createEvent(eventInterface: "AddonEvent"): AddonEvent;
    createEvent(eventInterface: "AnimationEvent"): AnimationEvent;
    createEvent(eventInterface: "AnimationPlaybackEvent"): AnimationPlaybackEvent;
    createEvent(eventInterface: "AudioProcessingEvent"): AudioProcessingEvent;
    createEvent(eventInterface: "BeforeUnloadEvent"): BeforeUnloadEvent;
    createEvent(eventInterface: "BlobEvent"): BlobEvent;
    createEvent(eventInterface: "CaretStateChangedEvent"): CaretStateChangedEvent;
    createEvent(eventInterface: "ClipboardEvent"): ClipboardEvent;
    createEvent(eventInterface: "CloseEvent"): CloseEvent;
    createEvent(eventInterface: "CommandEvent"): CommandEvent;
    createEvent(eventInterface: "CompositionEvent"): CompositionEvent;
    createEvent(eventInterface: "ContentVisibilityAutoStateChangeEvent"): ContentVisibilityAutoStateChangeEvent;
    createEvent(eventInterface: "CustomEvent"): CustomEvent;
    createEvent(eventInterface: "DeviceLightEvent"): DeviceLightEvent;
    createEvent(eventInterface: "DeviceMotionEvent"): DeviceMotionEvent;
    createEvent(eventInterface: "DeviceOrientationEvent"): DeviceOrientationEvent;
    createEvent(eventInterface: "DragEvent"): DragEvent;
    createEvent(eventInterface: "ErrorEvent"): ErrorEvent;
    createEvent(eventInterface: "ExtendableEvent"): ExtendableEvent;
    createEvent(eventInterface: "ExtendableMessageEvent"): ExtendableMessageEvent;
    createEvent(eventInterface: "FetchEvent"): FetchEvent;
    createEvent(eventInterface: "FocusEvent"): FocusEvent;
    createEvent(eventInterface: "FontFaceSetLoadEvent"): FontFaceSetLoadEvent;
    createEvent(eventInterface: "FormDataEvent"): FormDataEvent;
    createEvent(eventInterface: "FrameCrashedEvent"): FrameCrashedEvent;
    createEvent(eventInterface: "GPUUncapturedErrorEvent"): GPUUncapturedErrorEvent;
    createEvent(eventInterface: "GamepadAxisMoveEvent"): GamepadAxisMoveEvent;
    createEvent(eventInterface: "GamepadButtonEvent"): GamepadButtonEvent;
    createEvent(eventInterface: "GamepadEvent"): GamepadEvent;
    createEvent(eventInterface: "HashChangeEvent"): HashChangeEvent;
    createEvent(eventInterface: "IDBVersionChangeEvent"): IDBVersionChangeEvent;
    createEvent(eventInterface: "ImageCaptureErrorEvent"): ImageCaptureErrorEvent;
    createEvent(eventInterface: "InputEvent"): InputEvent;
    createEvent(eventInterface: "InvokeEvent"): InvokeEvent;
    createEvent(eventInterface: "KeyboardEvent"): KeyboardEvent;
    createEvent(eventInterface: "MIDIConnectionEvent"): MIDIConnectionEvent;
    createEvent(eventInterface: "MIDIMessageEvent"): MIDIMessageEvent;
    createEvent(eventInterface: "MediaEncryptedEvent"): MediaEncryptedEvent;
    createEvent(eventInterface: "MediaKeyMessageEvent"): MediaKeyMessageEvent;
    createEvent(eventInterface: "MediaQueryListEvent"): MediaQueryListEvent;
    createEvent(eventInterface: "MediaRecorderErrorEvent"): MediaRecorderErrorEvent;
    createEvent(eventInterface: "MediaStreamEvent"): MediaStreamEvent;
    createEvent(eventInterface: "MediaStreamTrackEvent"): MediaStreamTrackEvent;
    createEvent(eventInterface: "MerchantValidationEvent"): MerchantValidationEvent;
    createEvent(eventInterface: "MessageEvent"): MessageEvent;
    createEvent(eventInterface: "MouseEvent"): MouseEvent;
    createEvent(eventInterface: "MouseEvents"): MouseEvent;
    createEvent(eventInterface: "MouseScrollEvent"): MouseScrollEvent;
    createEvent(eventInterface: "MozApplicationEvent"): MozApplicationEvent;
    createEvent(eventInterface: "MozSharedMapChangeEvent"): MozSharedMapChangeEvent;
    createEvent(eventInterface: "MutationEvent"): MutationEvent;
    createEvent(eventInterface: "MutationEvents"): MutationEvent;
    createEvent(eventInterface: "NotificationEvent"): NotificationEvent;
    createEvent(eventInterface: "NotifyPaintEvent"): NotifyPaintEvent;
    createEvent(eventInterface: "OfflineAudioCompletionEvent"): OfflineAudioCompletionEvent;
    createEvent(eventInterface: "PageTransitionEvent"): PageTransitionEvent;
    createEvent(eventInterface: "PaymentMethodChangeEvent"): PaymentMethodChangeEvent;
    createEvent(eventInterface: "PaymentRequestUpdateEvent"): PaymentRequestUpdateEvent;
    createEvent(eventInterface: "PerformanceEntryEvent"): PerformanceEntryEvent;
    createEvent(eventInterface: "PluginCrashedEvent"): PluginCrashedEvent;
    createEvent(eventInterface: "PointerEvent"): PointerEvent;
    createEvent(eventInterface: "PopStateEvent"): PopStateEvent;
    createEvent(eventInterface: "PopupBlockedEvent"): PopupBlockedEvent;
    createEvent(eventInterface: "PopupPositionedEvent"): PopupPositionedEvent;
    createEvent(eventInterface: "PositionStateEvent"): PositionStateEvent;
    createEvent(eventInterface: "ProgressEvent"): ProgressEvent;
    createEvent(eventInterface: "PromiseRejectionEvent"): PromiseRejectionEvent;
    createEvent(eventInterface: "PushEvent"): PushEvent;
    createEvent(eventInterface: "RTCDTMFToneChangeEvent"): RTCDTMFToneChangeEvent;
    createEvent(eventInterface: "RTCDataChannelEvent"): RTCDataChannelEvent;
    createEvent(eventInterface: "RTCPeerConnectionIceEvent"): RTCPeerConnectionIceEvent;
    createEvent(eventInterface: "RTCTrackEvent"): RTCTrackEvent;
    createEvent(eventInterface: "RTCTransformEvent"): RTCTransformEvent;
    createEvent(eventInterface: "ScrollAreaEvent"): ScrollAreaEvent;
    createEvent(eventInterface: "ScrollViewChangeEvent"): ScrollViewChangeEvent;
    createEvent(eventInterface: "SecurityPolicyViolationEvent"): SecurityPolicyViolationEvent;
    createEvent(eventInterface: "SimpleGestureEvent"): SimpleGestureEvent;
    createEvent(eventInterface: "SpeechRecognitionEvent"): SpeechRecognitionEvent;
    createEvent(eventInterface: "SpeechSynthesisErrorEvent"): SpeechSynthesisErrorEvent;
    createEvent(eventInterface: "SpeechSynthesisEvent"): SpeechSynthesisEvent;
    createEvent(eventInterface: "StorageEvent"): StorageEvent;
    createEvent(eventInterface: "StreamFilterDataEvent"): StreamFilterDataEvent;
    createEvent(eventInterface: "StyleSheetApplicableStateChangeEvent"): StyleSheetApplicableStateChangeEvent;
    createEvent(eventInterface: "StyleSheetRemovedEvent"): StyleSheetRemovedEvent;
    createEvent(eventInterface: "SubmitEvent"): SubmitEvent;
    createEvent(eventInterface: "TCPServerSocketEvent"): TCPServerSocketEvent;
    createEvent(eventInterface: "TCPSocketErrorEvent"): TCPSocketErrorEvent;
    createEvent(eventInterface: "TCPSocketEvent"): TCPSocketEvent;
    createEvent(eventInterface: "TaskPriorityChangeEvent"): TaskPriorityChangeEvent;
    createEvent(eventInterface: "TimeEvent"): TimeEvent;
    createEvent(eventInterface: "ToggleEvent"): ToggleEvent;
    createEvent(eventInterface: "TouchEvent"): TouchEvent;
    createEvent(eventInterface: "TrackEvent"): TrackEvent;
    createEvent(eventInterface: "TransitionEvent"): TransitionEvent;
    createEvent(eventInterface: "UDPMessageEvent"): UDPMessageEvent;
    createEvent(eventInterface: "UIEvent"): UIEvent;
    createEvent(eventInterface: "UIEvents"): UIEvent;
    createEvent(eventInterface: "UserProximityEvent"): UserProximityEvent;
    createEvent(eventInterface: "VRDisplayEvent"): VRDisplayEvent;
    createEvent(eventInterface: "WebGLContextEvent"): WebGLContextEvent;
    createEvent(eventInterface: "WheelEvent"): WheelEvent;
    createEvent(eventInterface: "XRInputSourceEvent"): XRInputSourceEvent;
    createEvent(eventInterface: "XRInputSourcesChangeEvent"): XRInputSourcesChangeEvent;
    createEvent(eventInterface: "XRReferenceSpaceEvent"): XRReferenceSpaceEvent;
    createEvent(eventInterface: "XRSessionEvent"): XRSessionEvent;
    createEvent(eventInterface: "XULCommandEvent"): XULCommandEvent;
    createEvent(eventInterface: string): Event;
    /**
     * Creates a NodeIterator object that you can use to traverse filtered lists of nodes or elements in a document.
     * @param root The root element or node to start traversing on.
     * @param whatToShow The type of nodes or elements to appear in the node list
     * @param filter A custom NodeFilter function to use. For more information, see filter. Use null for no filter.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createNodeIterator)
     */
    createNodeIterator(root: Node, whatToShow?: number, filter?: NodeFilter | null): NodeIterator;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createProcessingInstruction) */
    createProcessingInstruction(target: string, data: string): ProcessingInstruction;
    /**
     *  Returns an empty range object that has both of its boundary points positioned at the beginning of the document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createRange)
     */
    createRange(): Range;
    /**
     * Creates a text string from the specified value.
     * @param data String that specifies the nodeValue property of the text node.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createTextNode)
     */
    createTextNode(data: string): Text;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createTouch)
     */
    createTouch(view?: Window | null, target?: EventTarget | null, identifier?: number, pageX?: number, pageY?: number, screenX?: number, screenY?: number, clientX?: number, clientY?: number, radiusX?: number, radiusY?: number, rotationAngle?: number, force?: number): Touch;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createTouchList)
     */
    createTouchList(touch: Touch, ...touches: Touch[]): TouchList;
    createTouchList(): TouchList;
    createTouchList(touches: Touch[]): TouchList;
    /**
     * Creates a TreeWalker object that you can use to traverse filtered lists of nodes or elements in a document.
     * @param root The root element or node to start traversing on.
     * @param whatToShow The type of nodes or elements to appear in the node list. For more information, see whatToShow.
     * @param filter A custom NodeFilter function to use.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createTreeWalker)
     */
    createTreeWalker(root: Node, whatToShow?: number, filter?: NodeFilter | null): TreeWalker;
    createXULElement(localName: string, options?: ElementCreationOptions | string): Element;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/enableStyleSheetsForSet)
     */
    enableStyleSheetsForSet(name: string | null): void;
    /**
     * Executes a command on the current document, current selection, or the given range.
     * @param commandId String that specifies the command to execute. This command can be any of the command identifiers that can be executed in script.
     * @param showUI Display the user interface, defaults to false.
     * @param value Value to assign.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/execCommand)
     */
    execCommand(commandId: string, showUI?: boolean, value?: string): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/exitFullscreen) */
    exitFullscreen(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/exitPointerLock) */
    exitPointerLock(): void;
    getConnectedShadowRoots(): ShadowRoot[];
    /**
     * Returns a reference to the first object with the specified value of the ID attribute.
     * @param elementId String that specifies the ID value.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/getElementById)
     */
    getElementById(elementId: string): Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/getElementsByClassName) */
    getElementsByClassName(classNames: string): HTMLCollection;
    /**
     * Gets a collection of objects based on the value of the NAME or ID attribute.
     * @param elementName Gets a collection of objects based on the value of the NAME or ID attribute.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/getElementsByName)
     */
    getElementsByName(elementName: string): NodeList;
    /**
     * Retrieves a collection of objects based on the specified element name.
     * @param name Specifies the name of an element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/getElementsByTagName)
     */
    getElementsByTagName<K extends keyof HTMLElementTagNameMap>(localName: K): HTMLCollectionOf<HTMLElementTagNameMap[K]>;
    getElementsByTagName<K extends keyof SVGElementTagNameMap>(localName: K): HTMLCollectionOf<SVGElementTagNameMap[K]>;
    getElementsByTagName<K extends keyof MathMLElementTagNameMap>(localName: K): HTMLCollectionOf<MathMLElementTagNameMap[K]>;
    /** @deprecated */
    getElementsByTagName<K extends keyof HTMLElementDeprecatedTagNameMap>(localName: K): HTMLCollectionOf<HTMLElementDeprecatedTagNameMap[K]>;
    getElementsByTagName(localName: string): HTMLCollectionOf<Element>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/getElementsByTagNameNS) */
    getElementsByTagNameNS(namespace: string | null, localName: string): HTMLCollection;
    getFailedCertSecurityInfo(): FailedCertSecurityInfo;
    getNetErrorInfo(): NetErrorInfo;
    /**
     * Returns an object representing the current selection of the document that is loaded into the object displaying a webpage.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/getSelection)
     */
    getSelection(): Selection | null;
    getWireframe(aIncludeNodes?: boolean): Wireframe | null;
    /**
     * Gets a value indicating whether the object currently has focus.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/hasFocus)
     */
    hasFocus(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/hasStorageAccess) */
    hasStorageAccess(): Promise<boolean>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/importNode) */
    importNode(node: Node, deep?: boolean): Node;
    insertAnonymousContent(aForce?: boolean): AnonymousContent;
    isActive(): boolean;
    /**
     * @deprecated This is a legacy alias of `exitFullscreen`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/exitFullscreen)
     */
    mozCancelFullScreen(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/mozSetImageElement) */
    mozSetImageElement(aImageElementId: string, aImageElement: Element | null): void;
    notifyUserGestureActivation(): void;
    /**
     * Opens a new window and loads a document specified by a given URL. Also, opens a new window that uses the url parameter and the name parameter to collect the output of the write method and the writeln method.
     * @param url Specifies a MIME type for the document.
     * @param name Specifies the name of the window. This name is used as the value for the TARGET attribute on a form or an anchor element.
     * @param features Contains a list of items separated by commas. Each item consists of an option and a value, separated by an equals sign (for example, "fullscreen=yes, toolbar=yes"). The following values are supported.
     * @param replace Specifies whether the existing entry for the document is replaced in the history list.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/open)
     */
    open(unused1?: string, unused2?: string): Document;
    open(url: string | URL, name: string, features: string): WindowProxy | null;
    /**
     * Returns a Boolean value that indicates whether a specified command can be successfully executed using execCommand, given the current state of the document.
     * @param commandId Specifies a command identifier.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/queryCommandEnabled)
     */
    queryCommandEnabled(commandId: string): boolean;
    /**
     * Returns a Boolean value that indicates whether the specified command is in the indeterminate state.
     * @param commandId String that specifies a command identifier.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/queryCommandIndeterm)
     */
    queryCommandIndeterm(commandId: string): boolean;
    /**
     * Returns a Boolean value that indicates the current state of the command.
     * @param commandId String that specifies a command identifier.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/queryCommandState)
     */
    queryCommandState(commandId: string): boolean;
    /**
     * Returns a Boolean value that indicates whether the current command is supported on the current range.
     * @param commandId Specifies a command identifier.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/queryCommandSupported)
     */
    queryCommandSupported(commandId: string): boolean;
    /**
     * Returns the current value of the document, range, or current selection for the given command.
     * @param commandId String that specifies a command identifier.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/queryCommandValue)
     */
    queryCommandValue(commandId: string): string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/querySelector) */
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/querySelectorAll) */
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/releaseCapture) */
    releaseCapture(): void;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/releaseEvents)
     */
    releaseEvents(): void;
    reloadWithHttpsOnlyException(): void;
    removeAnonymousContent(aContent: AnonymousContent): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/requestStorageAccess) */
    requestStorageAccess(): Promise<void>;
    requestStorageAccessForOrigin(thirdPartyOrigin: string, requireUserInteraction?: boolean): Promise<void>;
    requestStorageAccessUnderSite(serializedSite: string): Promise<void>;
    setKeyPressEventModel(aKeyPressEventModel: number): void;
    setNotifyFetchSuccess(aShouldNotify: boolean): void;
    setNotifyFormOrPasswordRemoved(aShouldNotify: boolean): void;
    setSuppressedEventListener(aListener: EventListener | null): void;
    userInteractionForTesting(): void;
    /**
     * Writes one or more HTML expressions to a document in the specified window.
     * @param content Specifies the text and HTML tags to write.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/write)
     */
    write(...text: string[]): void;
    /**
     * Writes one or more HTML expressions, followed by a carriage return, to a document in the specified window.
     * @param content The text and HTML tags to write.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/writeln)
     */
    writeln(...text: string[]): void;
    readonly KEYPRESS_EVENT_MODEL_DEFAULT: 0;
    readonly KEYPRESS_EVENT_MODEL_SPLIT: 1;
    readonly KEYPRESS_EVENT_MODEL_CONFLATED: 2;
    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: Document, ev: DocumentEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: Document, ev: DocumentEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var Document: {
    prototype: Document;
    new(): Document;
    readonly KEYPRESS_EVENT_MODEL_DEFAULT: 0;
    readonly KEYPRESS_EVENT_MODEL_SPLIT: 1;
    readonly KEYPRESS_EVENT_MODEL_CONFLATED: 2;
    parseHTMLUnsafe(html: string): Document;
    isInstance(obj): obj is Document;
};

/**
 * A minimal document object that has no parent. It is used as a lightweight version of Document that stores a segment of a document structure comprised of nodes just like a standard document. The key difference is that because the document fragment isn't part of the active document tree structure, changes made to the fragment don't affect the document, cause reflow, or incur any performance impact that can occur when changes are made.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentFragment)
 */
interface DocumentFragment extends Node, ParentNode {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentFragment/getElementById) */
    getElementById(elementId: string): Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentFragment/querySelector) */
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentFragment/querySelectorAll) */
}

declare var DocumentFragment: {
    prototype: DocumentFragment;
    new(): DocumentFragment;
    isInstance(obj): obj is DocumentFragment;
};

interface DocumentL10n extends DOMLocalization {
    readonly ready: Promise<any>;
    connectRoot(aElement: Node, aTranslate?: boolean): void;
}

interface DocumentOrShadowRoot {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/activeElement) */
    readonly activeElement: Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/adoptedStyleSheets) */
    adoptedStyleSheets: CSSStyleSheet[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fullscreenElement) */
    readonly fullscreenElement: Element | null;
    readonly mozFullScreenElement: Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/pointerLockElement) */
    readonly pointerLockElement: Element | null;
    /**
     * Retrieves a collection of styleSheet objects representing the style sheets that correspond to each instance of a link or style object in the document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/styleSheets)
     */
    readonly styleSheets: StyleSheetList;
    /**
     * Returns the element for the specified x coordinate and the specified y coordinate.
     * @param x The x-offset
     * @param y The y-offset
     */
    elementFromPoint(x: number, y: number): Element | null;
    elementsFromPoint(x: number, y: number): Element[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/getAnimations) */
    getAnimations(): Animation[];
    nodeFromPoint(x: number, y: number): Node | null;
    nodesFromPoint(x: number, y: number): Node[];
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentTimeline) */
interface DocumentTimeline extends AnimationTimeline {
}

declare var DocumentTimeline: {
    prototype: DocumentTimeline;
    new(options?: DocumentTimelineOptions): DocumentTimeline;
    isInstance(obj): obj is DocumentTimeline;
};

/**
 * A Node containing a doctype.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentType)
 */
interface DocumentType extends Node, ChildNode {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentType/name) */
    readonly name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentType/publicId) */
    readonly publicId: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentType/systemId) */
    readonly systemId: string;
}

declare var DocumentType: {
    prototype: DocumentType;
    new(): DocumentType;
    isInstance(obj): obj is DocumentType;
};

interface DominatorTree {
    readonly root: NodeId;
    getImmediateDominator(node: NodeId): NodeId | null;
    getImmediatelyDominated(node: NodeId): NodeId[] | null;
    getRetainedSize(node: NodeId): NodeSize | null;
}

declare var DominatorTree: {
    prototype: DominatorTree;
    new(): DominatorTree;
    isInstance(obj): obj is DominatorTree;
};

/**
 * A DOM event that represents a drag and drop interaction. The user initiates a drag by placing a pointer device (such as a mouse) on the touch surface and then dragging the pointer to a new location (such as another DOM element). Applications are free to interpret a drag and drop interaction in an application-specific way.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DragEvent)
 */
interface DragEvent extends MouseEvent {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DragEvent/dataTransfer) */
    readonly dataTransfer: DataTransfer | null;
    initDragEvent(type: string, canBubble?: boolean, cancelable?: boolean, aView?: Window | null, aDetail?: number, aScreenX?: number, aScreenY?: number, aClientX?: number, aClientY?: number, aCtrlKey?: boolean, aAltKey?: boolean, aShiftKey?: boolean, aMetaKey?: boolean, aButton?: number, aRelatedTarget?: EventTarget | null, aDataTransfer?: DataTransfer | null): void;
}

declare var DragEvent: {
    prototype: DragEvent;
    new(type: string, eventInitDict?: DragEventInit): DragEvent;
    isInstance(obj): obj is DragEvent;
};

/**
 * Inherits properties from its parent, AudioNode.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode)
 */
interface DynamicsCompressorNode extends AudioNode, AudioNodePassThrough {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode/attack) */
    readonly attack: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode/knee) */
    readonly knee: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode/ratio) */
    readonly ratio: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode/reduction) */
    readonly reduction: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode/release) */
    readonly release: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode/threshold) */
    readonly threshold: AudioParam;
}

declare var DynamicsCompressorNode: {
    prototype: DynamicsCompressorNode;
    new(context: BaseAudioContext, options?: DynamicsCompressorOptions): DynamicsCompressorNode;
    isInstance(obj): obj is DynamicsCompressorNode;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_blend_minmax) */
interface EXT_blend_minmax {
    readonly MIN_EXT: 0x8007;
    readonly MAX_EXT: 0x8008;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_color_buffer_float) */
interface EXT_color_buffer_float {
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_color_buffer_half_float) */
interface EXT_color_buffer_half_float {
    readonly RGBA16F_EXT: 0x881A;
    readonly RGB16F_EXT: 0x881B;
    readonly FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT: 0x8211;
    readonly UNSIGNED_NORMALIZED_EXT: 0x8C17;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_disjoint_timer_query) */
interface EXT_disjoint_timer_query {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_disjoint_timer_query/beginQueryEXT) */
    beginQueryEXT(target: GLenum, query: WebGLQuery): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_disjoint_timer_query/createQueryEXT) */
    createQueryEXT(): WebGLQuery | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_disjoint_timer_query/deleteQueryEXT) */
    deleteQueryEXT(query: WebGLQuery | null): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_disjoint_timer_query/endQueryEXT) */
    endQueryEXT(target: GLenum): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_disjoint_timer_query/getQueryEXT) */
    getQueryEXT(target: GLenum, pname: GLenum): any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_disjoint_timer_query/getQueryObjectEXT) */
    getQueryObjectEXT(query: WebGLQuery, pname: GLenum): any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_disjoint_timer_query/isQueryEXT) */
    isQueryEXT(query: WebGLQuery | null): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_disjoint_timer_query/queryCounterEXT) */
    queryCounterEXT(query: WebGLQuery, target: GLenum): void;
    readonly QUERY_COUNTER_BITS_EXT: 0x8864;
    readonly CURRENT_QUERY_EXT: 0x8865;
    readonly QUERY_RESULT_EXT: 0x8866;
    readonly QUERY_RESULT_AVAILABLE_EXT: 0x8867;
    readonly TIME_ELAPSED_EXT: 0x88BF;
    readonly TIMESTAMP_EXT: 0x8E28;
    readonly GPU_DISJOINT_EXT: 0x8FBB;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_float_blend) */
interface EXT_float_blend {
}

/**
 * The EXT_frag_depth extension is part of the WebGL API and enables to set a depth value of a fragment from within the fragment shader.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_frag_depth)
 */
interface EXT_frag_depth {
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_sRGB) */
interface EXT_sRGB {
    readonly SRGB_EXT: 0x8C40;
    readonly SRGB_ALPHA_EXT: 0x8C42;
    readonly SRGB8_ALPHA8_EXT: 0x8C43;
    readonly FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT: 0x8210;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_shader_texture_lod) */
interface EXT_shader_texture_lod {
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_texture_compression_bptc) */
interface EXT_texture_compression_bptc {
    readonly COMPRESSED_RGBA_BPTC_UNORM_EXT: 0x8E8C;
    readonly COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT: 0x8E8D;
    readonly COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT: 0x8E8E;
    readonly COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT: 0x8E8F;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_texture_compression_rgtc) */
interface EXT_texture_compression_rgtc {
    readonly COMPRESSED_RED_RGTC1_EXT: 0x8DBB;
    readonly COMPRESSED_SIGNED_RED_RGTC1_EXT: 0x8DBC;
    readonly COMPRESSED_RED_GREEN_RGTC2_EXT: 0x8DBD;
    readonly COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT: 0x8DBE;
}

/**
 * The EXT_texture_filter_anisotropic extension is part of the WebGL API and exposes two constants for anisotropic filtering (AF).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_texture_filter_anisotropic)
 */
interface EXT_texture_filter_anisotropic {
    readonly TEXTURE_MAX_ANISOTROPY_EXT: 0x84FE;
    readonly MAX_TEXTURE_MAX_ANISOTROPY_EXT: 0x84FF;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_texture_norm16) */
interface EXT_texture_norm16 {
    readonly R16_EXT: 0x822A;
    readonly RG16_EXT: 0x822C;
    readonly RGB16_EXT: 0x8054;
    readonly RGBA16_EXT: 0x805B;
    readonly R16_SNORM_EXT: 0x8F98;
    readonly RG16_SNORM_EXT: 0x8F99;
    readonly RGB16_SNORM_EXT: 0x8F9A;
    readonly RGBA16_SNORM_EXT: 0x8F9B;
}

interface ElementEventMap {
    "fullscreenchange": Event;
    "fullscreenerror": Event;
}

/**
 * Element is the most general base class from which all objects in a Document inherit. It only has methods and properties common to all kinds of elements. More specific classes inherit from Element.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element)
 */
interface Element extends Node, AccessibilityRole, Animatable, AriaAttributes, ChildNode, GeometryUtils, NonDocumentTypeChildNode, ParentNode {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/assignedSlot) */
    readonly assignedSlot: HTMLSlotElement | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/attributes) */
    readonly attributes: NamedNodeMap;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/classList) */
    readonly classList: DOMTokenList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/className) */
    //classNme
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/clientHeight) */
    readonly clientHeight: number;
    readonly clientHeightDouble: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/clientLeft) */
    readonly clientLeft: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/clientTop) */
    readonly clientTop: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/clientWidth) */
    readonly clientWidth: number;
    readonly clientWidthDouble: number;
    readonly firstLineBoxBSize: number;
    readonly fontSizeInflation: number;
    readonly hasVisibleScrollbars: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/id) */
    id: string;
    readonly implementedPseudoElement: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/innerHTML) */
    innerHTML: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/localName) */
    readonly localName: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/namespaceURI) */
    readonly namespaceURI: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/fullscreenchange_event) */
    onfullscreenchange: ((this: Element, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/fullscreenerror_event) */
    onfullscreenerror: ((this: Element, ev: Event) => any) | null;
    readonly openOrClosedAssignedSlot: HTMLSlotElement | null;
    readonly openOrClosedShadowRoot: ShadowRoot | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/outerHTML) */
    outerHTML: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/part) */
    readonly part: DOMTokenList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/prefix) */
    readonly prefix: string | null;
    readonly screen: nsIScreen | null;
    readonly screenX: number;
    readonly screenY: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollHeight) */
    readonly scrollHeight: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollLeft) */
    scrollLeft: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollLeftMax) */
    readonly scrollLeftMax: number;
    readonly scrollLeftMin: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollTop) */
    scrollTop: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollTopMax) */
    readonly scrollTopMax: number;
    readonly scrollTopMin: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollWidth) */
    readonly scrollWidth: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/shadowRoot) */
    readonly shadowRoot: ShadowRoot | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/slot) */
    slot: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/tagName) */
    readonly tagName: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/attachShadow) */
    attachShadow(shadowRootInitDict: ShadowRootInit): ShadowRoot;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/checkVisibility) */
    checkVisibility(options?: CheckVisibilityOptions): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/closest) */
    closest(selector: UTF8String): Element | null;
    getAsFlexContainer(): Flex | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getAttribute) */
    getAttribute(name: string): string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getAttributeNS) */
    getAttributeNS(namespace: string | null, localName: string): string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getAttributeNames) */
    getAttributeNames(): string[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getAttributeNode) */
    getAttributeNode(name: string): Attr | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getAttributeNodeNS) */
    getAttributeNodeNS(namespaceURI: string | null, localName: string): Attr | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getBoundingClientRect) */
    getBoundingClientRect(): DOMRect;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getClientRects) */
    getClientRects(): DOMRectList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getElementsByClassName) */
    getElementsByClassName(classNames: string): HTMLCollection;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getElementsByTagName) */
    getElementsByTagName<K extends keyof HTMLElementTagNameMap>(localName: K): HTMLCollectionOf<HTMLElementTagNameMap[K]>;
    getElementsByTagName<K extends keyof SVGElementTagNameMap>(localName: K): HTMLCollectionOf<SVGElementTagNameMap[K]>;
    getElementsByTagName<K extends keyof MathMLElementTagNameMap>(localName: K): HTMLCollectionOf<MathMLElementTagNameMap[K]>;
    /** @deprecated */
    getElementsByTagName<K extends keyof HTMLElementDeprecatedTagNameMap>(localName: K): HTMLCollectionOf<HTMLElementDeprecatedTagNameMap[K]>;
    getElementsByTagName(localName: string): HTMLCollectionOf<Element>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getElementsByTagNameNS) */
    getElementsByTagNameNS(namespace: string | null, localName: string): HTMLCollection;
    getElementsWithGrid(): Element[];
    getGridFragments(): Grid[];
    getTransformToAncestor(ancestor: Element): DOMMatrixReadOnly;
    getTransformToParent(): DOMMatrixReadOnly;
    getTransformToViewport(): DOMMatrixReadOnly;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/hasAttribute) */
    hasAttribute(name: string): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/hasAttributeNS) */
    hasAttributeNS(namespace: string | null, localName: string): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/hasAttributes) */
    hasAttributes(): boolean;
    hasGridFragments(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/hasPointerCapture) */
    hasPointerCapture(pointerId: number): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/insertAdjacentElement) */
    insertAdjacentElement(where: string, element: Element): Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/insertAdjacentHTML) */
    insertAdjacentHTML(position: string, text: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/insertAdjacentText) */
    insertAdjacentText(where: string, data: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/matches) */
    matches(selector: UTF8String): boolean;
    /**
     * @deprecated This is a legacy alias of `matches`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/matches)
     */
    mozMatchesSelector(selector: UTF8String): boolean;
    /**
     * @deprecated This is a legacy alias of `requestFullscreen`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/requestFullscreen)
     */
    mozRequestFullScreen(): Promise<void>;
    mozScrollSnap(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/querySelector) */
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/querySelectorAll) */
    releaseCapture(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/releasePointerCapture) */
    releasePointerCapture(pointerId: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/removeAttribute) */
    removeAttribute(name: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/removeAttributeNS) */
    removeAttributeNS(namespace: string | null, localName: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/removeAttributeNode) */
    removeAttributeNode(oldAttr: Attr): Attr | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/requestFullscreen) */
    requestFullscreen(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/requestPointerLock) */
    requestPointerLock(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scroll) */
    scroll(x: number, y: number): void;
    scroll(options?: ScrollToOptions): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollBy) */
    scrollBy(x: number, y: number): void;
    scrollBy(options?: ScrollToOptions): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollIntoView) */
    scrollIntoView(arg?: boolean | ScrollIntoViewOptions): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollTo) */
    scrollTo(x: number, y: number): void;
    scrollTo(options?: ScrollToOptions): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/setAttribute) */
    setAttribute(name: string, value: string): void;
    setAttributeDevtools(name: string, value: string): void;
    setAttributeDevtoolsNS(namespace: string | null, name: string, value: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/setAttributeNS) */
    setAttributeNS(namespace: string | null, name: string, value: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/setAttributeNode) */
    setAttributeNode(newAttr: Attr): Attr | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/setAttributeNodeNS) */
    setAttributeNodeNS(newAttr: Attr): Attr | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/setCapture)
     */
    setCapture(retargetToElement?: boolean): void;
    setCaptureAlways(retargetToElement?: boolean): void;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/setHTML)
     */
    setHTML(aInnerHTML: string, options?: SetHTMLOptions): void;
    setHTMLUnsafe(html: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/setPointerCapture) */
    setPointerCapture(pointerId: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/toggleAttribute) */
    toggleAttribute(name: string, force?: boolean): boolean;
    /**
     * @deprecated This is a legacy alias of `matches`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/matches)
     */
    webkitMatchesSelector(selector: UTF8String): boolean;
    addEventListener<K extends keyof ElementEventMap>(type: K, listener: (this: Element, ev: ElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof ElementEventMap>(type: K, listener: (this: Element, ev: ElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var Element: {
    prototype: Element;
    new(): Element;
    isInstance(obj): obj is Element;
};

interface ElementCSSInlineStyle {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/style) */
    readonly style: CSSStyleDeclaration;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals) */
interface ElementInternals extends AccessibilityRole, AriaAttributes {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/form) */
    readonly form: HTMLFormElement | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/labels) */
    readonly labels: NodeList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/shadowRoot) */
    readonly shadowRoot: ShadowRoot | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/states) */
    readonly states: CustomStateSet;
    readonly validationAnchor: HTMLElement | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/validationMessage) */
    readonly validationMessage: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/validity) */
    readonly validity: ValidityState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/willValidate) */
    readonly willValidate: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/checkValidity) */
    checkValidity(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/reportValidity) */
    reportValidity(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/setFormValue) */
    setFormValue(value: File | string | FormData | null, state?: File | string | FormData | null): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/setValidity) */
    setValidity(flags?: ValidityStateFlags, message?: string, anchor?: HTMLElement): void;
}

declare var ElementInternals: {
    prototype: ElementInternals;
    new(): ElementInternals;
    isInstance(obj): obj is ElementInternals;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedVideoChunk) */
interface EncodedVideoChunk {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedVideoChunk/byteLength) */
    readonly byteLength: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedVideoChunk/duration) */
    readonly duration: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedVideoChunk/timestamp) */
    readonly timestamp: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedVideoChunk/type) */
    readonly type: EncodedVideoChunkType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedVideoChunk/copyTo) */
    copyTo(destination: ArrayBufferView | ArrayBuffer): void;
}

declare var EncodedVideoChunk: {
    prototype: EncodedVideoChunk;
    new(init: EncodedVideoChunkInit): EncodedVideoChunk;
    isInstance(obj): obj is EncodedVideoChunk;
};

/**
 * Events providing information related to errors in scripts or in files.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ErrorEvent)
 */
interface ErrorEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ErrorEvent/colno) */
    readonly colno: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ErrorEvent/error) */
    "error": ErrorEvent;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ErrorEvent/filename) */
    readonly filename: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ErrorEvent/lineno) */
    readonly lineno: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ErrorEvent/message) */
    readonly message: string;
}

declare var ErrorEvent: {
    prototype: ErrorEvent;
    new(type: string, eventInitDict?: ErrorEventInit): ErrorEvent;
    isInstance(obj): obj is ErrorEvent;
};

/**
 * An event which takes place in the DOM.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event)
 */
interface Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/bubbles) */
    readonly bubbles: boolean;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/cancelBubble)
     */
    cancelBubble: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/cancelable) */
    readonly cancelable: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/composed) */
    readonly composed: boolean;
    readonly composedTarget: EventTarget | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/currentTarget) */
    readonly currentTarget: EventTarget | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/defaultPrevented) */
    readonly defaultPrevented: boolean;
    readonly defaultPreventedByChrome: boolean;
    readonly defaultPreventedByContent: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/eventPhase) */
    readonly eventPhase: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/explicitOriginalTarget) */
    readonly explicitOriginalTarget: EventTarget | null;
    readonly isReplyEventFromRemoteContent: boolean;
    readonly isSynthesized: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/isTrusted) */
    readonly isTrusted: boolean;
    readonly isWaitingReplyFromRemoteContent: boolean;
    readonly multipleActionsPrevented: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/originalTarget) */
    readonly originalTarget: EventTarget | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/returnValue)
     */
    returnValue: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/target) */
    readonly target: EventTarget | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/timeStamp) */
    readonly timeStamp: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/type) */
    readonly type: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/composedPath) */
    composedPath(): EventTarget[];
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/initEvent)
     */
    initEvent(type: string, bubbles?: boolean, cancelable?: boolean): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/preventDefault) */
    preventDefault(): void;
    preventMultipleActions(): void;
    requestReplyFromRemoteContent(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/stopImmediatePropagation) */
    stopImmediatePropagation(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/stopPropagation) */
    stopPropagation(): void;
    readonly NONE: 0;
    readonly CAPTURING_PHASE: 1;
    readonly AT_TARGET: 2;
    readonly BUBBLING_PHASE: 3;
    readonly ALT_MASK: 0x00000001;
    readonly CONTROL_MASK: 0x00000002;
    readonly SHIFT_MASK: 0x00000004;
    readonly META_MASK: 0x00000008;
}

declare var Event: {
    prototype: Event;
    new(type: string, eventInitDict?: EventInit): Event;
    readonly NONE: 0;
    readonly CAPTURING_PHASE: 1;
    readonly AT_TARGET: 2;
    readonly BUBBLING_PHASE: 3;
    readonly ALT_MASK: 0x00000001;
    readonly CONTROL_MASK: 0x00000002;
    readonly SHIFT_MASK: 0x00000004;
    readonly META_MASK: 0x00000008;
    isInstance(obj): obj is Event;
};

interface EventCallbackDebuggerNotification extends CallbackDebuggerNotification {
    readonly event: Event;
    readonly targetType: EventCallbackDebuggerNotificationType;
}

declare var EventCallbackDebuggerNotification: {
    prototype: EventCallbackDebuggerNotification;
    new(): EventCallbackDebuggerNotification;
    isInstance(obj): obj is EventCallbackDebuggerNotification;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventCounts) */
interface EventCounts {
    forEach(callbackfn: (value: number, key: string, parent: EventCounts) => void, thisArg?: any): void;
}

declare var EventCounts: {
    prototype: EventCounts;
    new(): EventCounts;
    isInstance(obj): obj is EventCounts;
};

interface EventSourceEventMap {
    "error": ErrorEvent;
    "message": Event;
    "open": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource) */
interface EventSource extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/error_event) */
    onerror: OnErrorEventHandler;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/message_event) */
    onmessage: ((this: EventSource, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/open_event) */
    onopen: ((this: EventSource, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/readyState) */
    readonly readyState: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/url) */
    readonly url: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/withCredentials) */
    readonly withCredentials: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/close) */
    close(): void;
    readonly CONNECTING: 0;
    readonly OPEN: 1;
    readonly CLOSED: 2;
    addEventListener<K extends keyof EventSourceEventMap>(type: K, listener: (this: EventSource, ev: EventSourceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: (this: EventSource, event: MessageEvent) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof EventSourceEventMap>(type: K, listener: (this: EventSource, ev: EventSourceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: (this: EventSource, event: MessageEvent) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var EventSource: {
    prototype: EventSource;
    new(url: string | URL, eventSourceInitDict?: EventSourceInit): EventSource;
    readonly CONNECTING: 0;
    readonly OPEN: 1;
    readonly CLOSED: 2;
    isInstance(obj): obj is EventSource;
};

/**
 * EventTarget is a DOM interface implemented by objects that can receive events and may have listeners for them.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventTarget)
 */
interface EventTarget {
    readonly ownerGlobal: WindowProxy | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventTarget/addEventListener) */
    addEventListener(type: string, listener: EventListener | null, options?: AddEventListenerOptions | boolean, wantsUntrusted?: boolean | null): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventTarget/dispatchEvent) */
    dispatchEvent(event: Event): boolean;
    getEventHandler(type: string): EventHandler;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventTarget/removeEventListener) */
    removeEventListener(type: string, listener: EventListener | null, options?: EventListenerOptions | boolean): void;
    setEventHandler(type: string, handler: EventHandler): void;
}

declare var EventTarget: {
    prototype: EventTarget;
    new(): EventTarget;
    isInstance(obj): obj is EventTarget;
};

interface Exception extends ExceptionMembers {
    readonly message: string;
    readonly name: string;
    toString(): string;
}

interface ExceptionMembers {
    readonly columnNumber: number;
    readonly data: nsISupports | null;
    readonly filename: string;
    readonly lineNumber: number;
    readonly location: StackFrame | null;
    readonly result: number;
    stack?: string;
}

/**
 * Extends the lifetime of the install and activate events dispatched on the global scope as part of the service worker lifecycle. This ensures that any functional events (like FetchEvent) are not dispatched until it upgrades database schemas and deletes the outdated cache entries.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ExtendableEvent)
 */
interface ExtendableEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ExtendableEvent/waitUntil) */
    waitUntil(p: any): void;
}

declare var ExtendableEvent: {
    prototype: ExtendableEvent;
    new(type: string, eventInitDict?: ExtendableEventInit): ExtendableEvent;
    isInstance(obj): obj is ExtendableEvent;
};

/**
 * This ServiceWorker API interface represents the event object of a message event fired on a service worker (when a channel message is received on the ServiceWorkerGlobalScope from another context) — extends the lifetime of such events.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ExtendableMessageEvent)
 */
interface ExtendableMessageEvent extends ExtendableEvent {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ExtendableMessageEvent/data) */
    readonly data: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ExtendableMessageEvent/lastEventId) */
    readonly lastEventId: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ExtendableMessageEvent/origin) */
    readonly origin: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ExtendableMessageEvent/ports) */
    readonly ports: MessagePort[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ExtendableMessageEvent/source) */
    readonly source: Client | ServiceWorker | MessagePort | null;
}

declare var ExtendableMessageEvent: {
    prototype: ExtendableMessageEvent;
    new(type: string, eventInitDict?: ExtendableMessageEventInit): ExtendableMessageEvent;
    isInstance(obj): obj is ExtendableMessageEvent;
};

interface ExtensionAlarms {
    readonly onAlarm: ExtensionEventManager;
    clear(name: string, callback?: Function): any;
    clear(callback?: Function): any;
    clearAll(callback?: Function): any;
    create(name: string, alarmInfo: any): void;
    create(alarmInfo: any): void;
    get(name: string, callback?: Function): any;
    get(callback?: Function): any;
    getAll(callback?: Function): any;
}

interface ExtensionBrowser {
    readonly alarms: ExtensionAlarms;
    readonly browserSettings: ExtensionBrowserSettings;
    readonly dns: ExtensionDns;
    readonly mockExtensionAPI: ExtensionMockAPI;
    readonly proxy: ExtensionProxy;
    readonly runtime: ExtensionRuntime;
    readonly scripting: ExtensionScripting;
    readonly test: ExtensionTest;
}

interface ExtensionBrowserSettings {
    readonly allowPopupsForUserEvents: ExtensionSetting;
    readonly cacheEnabled: ExtensionSetting;
    readonly closeTabsByDoubleClick: ExtensionSetting;
    readonly colorManagement: ExtensionBrowserSettingsColorManagement;
    readonly contextMenuShowEvent: ExtensionSetting;
    readonly ftpProtocolEnabled: ExtensionSetting;
    readonly homepageOverride: ExtensionSetting;
    readonly imageAnimationBehavior: ExtensionSetting;
    readonly newTabPageOverride: ExtensionSetting;
    readonly newTabPosition: ExtensionSetting;
    readonly openBookmarksInNewTabs: ExtensionSetting;
    readonly openSearchResultsInNewTabs: ExtensionSetting;
    readonly openUrlbarResultsInNewTabs: ExtensionSetting;
    readonly overrideContentColorScheme: ExtensionSetting;
    readonly overrideDocumentColors: ExtensionSetting;
    readonly useDocumentFonts: ExtensionSetting;
    readonly webNotificationsDisabled: ExtensionSetting;
    readonly zoomFullPage: ExtensionSetting;
    readonly zoomSiteSpecific: ExtensionSetting;
}

interface ExtensionBrowserSettingsColorManagement {
    readonly mode: ExtensionSetting;
    readonly useNativeSRGB: ExtensionSetting;
    readonly useWebRenderCompositor: ExtensionSetting;
}

interface ExtensionDns {
    resolve(...args: any[]): any;
}

interface ExtensionEventManager {
    addListener(callback: Function, listenerOptions?: any): void;
    hasListener(callback: Function): boolean;
    hasListeners(): boolean;
    removeListener(callback: Function): void;
}

interface ExtensionGlobalsMixin {
    readonly browser: ExtensionBrowser;
}

interface ExtensionMockAPI {
    readonly onTestEvent: ExtensionEventManager;
    readonly propertyAsErrorObject: any;
    readonly propertyAsString: string;
    methodAmbiguousArgsAsync(...args: any[]): any;
    methodAsync(arg0: any, cb?: Function): any;
    methodNoReturn(...args: any[]): void;
    methodReturnsPort(testName: string): ExtensionPort;
    methodSyncWithReturn(...args: any[]): any;
}

interface ExtensionPort {
    "error": ErrorEvent;
    readonly name: string;
    readonly onDisconnect: ExtensionEventManager;
    readonly onMessage: ExtensionEventManager;
    readonly sender: any;
    disconnect(): void;
    postMessage(message: any): void;
}

interface ExtensionProxy {
    readonly onError: ExtensionEventManager;
    readonly onRequest: ExtensionEventManager;
    readonly settings: ExtensionSetting;
}

interface ExtensionRuntime {
    readonly id: string;
    readonly lastError: any;
    readonly onConnect: ExtensionEventManager;
    readonly onConnectExternal: ExtensionEventManager;
    readonly onInstalled: ExtensionEventManager;
    readonly onMessage: ExtensionEventManager;
    readonly onMessageExternal: ExtensionEventManager;
    readonly onStartup: ExtensionEventManager;
    readonly onUpdateAvailable: ExtensionEventManager;
    connect(extensionId: string, connectInfo: any): ExtensionPort;
    connect(connectInfo: any): ExtensionPort;
    connect(): ExtensionPort;
    connectNative(application: string): ExtensionPort;
    getBrowserInfo(callback?: Function): any;
    getManifest(): any;
    getPlatformInfo(callback?: Function): any;
    getURL(path: string): string;
    openOptionsPage(callback?: Function): any;
    reload(): void;
    sendMessage(...args: any[]): any;
    sendNativeMessage(application: string, message: any, responseCallback?: Function): any;
    setUninstallURL(url: string, callback?: Function): any;
    setUninstallURL(callback?: Function): any;
}

interface ExtensionScripting {
    executeScript(injection: any, callback?: Function): any;
    getRegisteredContentScripts(...args: any[]): any;
    insertCSS(injection: any, callback?: Function): any;
    registerContentScripts(scripts: any, callback?: Function): any;
    removeCSS(injection: any, callback?: Function): any;
    unregisterContentScripts(...args: any[]): any;
    updateContentScripts(scripts: any, callback?: Function): any;
}

interface ExtensionSetting {
    readonly onChange: ExtensionEventManager;
    clear(details: any, callback?: Function): any;
    get(details: any, callback?: Function): any;
    set(details: any, callback?: Function): any;
}

interface ExtensionTest {
    readonly onMessage: ExtensionEventManager;
    assertDeepEq(...args: any[]): void;
    assertEq(...args: any[]): void;
    assertFalse(...args: any[]): void;
    assertRejects(promise: any, expectedError: any, message: string, callback?: Function): any;
    assertRejects(promise: any, expectedError: any, callback?: Function): any;
    assertThrows(func: Function, expectedError: any, message: string): void;
    assertThrows(func: Function, expectedError: any): void;
    assertTrue(...args: any[]): void;
    fail(message: any): void;
    fail(): void;
    log(message: string): void;
    notifyFail(message: string): void;
    notifyPass(message: string): void;
    notifyPass(): void;
    sendMessage(...args: any[]): void;
    succeed(message: any): void;
    succeed(): void;
    withHandlingUserInput(callback: Function): void;
}

/**
 * @deprecated
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/External)
 */
interface External {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/External/AddSearchProvider)
     */
    AddSearchProvider(): void;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/External/IsSearchProviderInstalled)
     */
    IsSearchProviderInstalled(): void;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FeaturePolicy) */
interface FeaturePolicy {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FeaturePolicy/allowedFeatures) */
    allowedFeatures(): string[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FeaturePolicy/allowsFeature) */
    allowsFeature(feature: string, origin?: string): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FeaturePolicy/features) */
    features(): string[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FeaturePolicy/getAllowlistForFeature) */
    getAllowlistForFeature(feature: string): string[];
}

interface FeaturePolicyViolationReportBody extends ReportBody {
    readonly columnNumber: number | null;
    readonly disposition: string;
    readonly featureId: string;
    readonly lineNumber: number | null;
    readonly sourceFile: string | null;
}

declare var FeaturePolicyViolationReportBody: {
    prototype: FeaturePolicyViolationReportBody;
    new(): FeaturePolicyViolationReportBody;
    isInstance(obj): obj is FeaturePolicyViolationReportBody;
};

/**
 * This is the event type for fetch events dispatched on the service worker global scope. It contains information about the fetch, including the request and how the receiver will treat the response. It provides the event.respondWith() method, which allows us to provide a response to this fetch.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FetchEvent)
 */
interface FetchEvent extends ExtendableEvent {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FetchEvent/clientId) */
    readonly clientId: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FetchEvent/handled) */
    readonly handled: Promise<undefined>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FetchEvent/preloadResponse) */
    readonly preloadResponse: Promise<any>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FetchEvent/request) */
    readonly request: Request;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FetchEvent/resultingClientId) */
    readonly resultingClientId: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FetchEvent/respondWith) */
    respondWith(r: Response | PromiseLike<Response>): void;
}

declare var FetchEvent: {
    prototype: FetchEvent;
    new(type: string, eventInitDict: FetchEventInit): FetchEvent;
    isInstance(obj): obj is FetchEvent;
};

interface FetchObserverEventMap {
    "requestprogress": Event;
    "responseprogress": Event;
    "statechange": Event;
}

interface FetchObserver extends EventTarget {
    onrequestprogress: ((this: FetchObserver, ev: Event) => any) | null;
    onresponseprogress: ((this: FetchObserver, ev: Event) => any) | null;
    onstatechange: ((this: FetchObserver, ev: Event) => any) | null;
    readonly state: FetchState;
    addEventListener<K extends keyof FetchObserverEventMap>(type: K, listener: (this: FetchObserver, ev: FetchObserverEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof FetchObserverEventMap>(type: K, listener: (this: FetchObserver, ev: FetchObserverEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var FetchObserver: {
    prototype: FetchObserver;
    new(): FetchObserver;
    isInstance(obj): obj is FetchObserver;
};

/**
 * Provides information about files and allows JavaScript in a web page to access their content.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/File)
 */
interface File extends Blob {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/File/lastModified) */
    readonly lastModified: number;
    readonly mozFullPath: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/File/name) */
    readonly name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/File/webkitRelativePath) */
    readonly webkitRelativePath: string;
}

declare var File: {
    prototype: File;
    new(fileBits: BlobPart[], fileName: string, options?: FilePropertyBag): File;
    createFromFileName(fileName: string, options?: ChromeFilePropertyBag): Promise<File>;
    createFromNsIFile(file: nsIFile, options?: ChromeFilePropertyBag): Promise<File>;
    isInstance(obj): obj is File;
};

/**
 * An object of this type is returned by the files property of the HTML <input> element; this lets you access the list of files selected with the <input type="file"> element. It's also used for a list of files dropped into web content when using the drag and drop API; see the DataTransfer object for details on this usage.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileList)
 */
interface FileList {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileList/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileList/item) */
    item(index: number): File | null;
    [index: number]: File;
}

declare var FileList: {
    prototype: FileList;
    new(): FileList;
    isInstance(obj): obj is FileList;
};

interface FileReaderEventMap {
    "abort": Event;
    "error": ErrorEvent;
    "load": Event;
    "loadend": Event;
    "loadstart": Event;
    "progress": Event;
}

/**
 * Lets web applications asynchronously read the contents of files (or raw data buffers) stored on the user's computer, using File or Blob objects to specify the file or data to read.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader)
 */
interface FileReader extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/error) */
    "error": ErrorEvent;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/abort_event) */
    onabort: ((this: FileReader, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/error_event) */
    onerror: OnErrorEventHandler;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/load_event) */
    onload: ((this: FileReader, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/loadend_event) */
    onloadend: ((this: FileReader, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/loadstart_event) */
    onloadstart: ((this: FileReader, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/progress_event) */
    onprogress: ((this: FileReader, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/readyState) */
    readonly readyState: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/result) */
    readonly result: string | ArrayBuffer | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/abort) */
    abort(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/readAsArrayBuffer) */
    readAsArrayBuffer(blob: Blob): void;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/readAsBinaryString)
     */
    readAsBinaryString(filedata: Blob): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/readAsDataURL) */
    readAsDataURL(blob: Blob): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/readAsText) */
    readAsText(blob: Blob, label?: string): void;
    readonly EMPTY: 0;
    readonly LOADING: 1;
    readonly DONE: 2;
    addEventListener<K extends keyof FileReaderEventMap>(type: K, listener: (this: FileReader, ev: FileReaderEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof FileReaderEventMap>(type: K, listener: (this: FileReader, ev: FileReaderEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var FileReader: {
    prototype: FileReader;
    new(): FileReader;
    readonly EMPTY: 0;
    readonly LOADING: 1;
    readonly DONE: 2;
    isInstance(obj): obj is FileReader;
};

/**
 * Allows to read File or Blob objects in a synchronous way.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReaderSync)
 */
interface FileReaderSync {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReaderSync/readAsArrayBuffer) */
    readAsArrayBuffer(blob: Blob): ArrayBuffer;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReaderSync/readAsBinaryString)
     */
    readAsBinaryString(blob: Blob): string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReaderSync/readAsDataURL) */
    readAsDataURL(blob: Blob): string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReaderSync/readAsText) */
    readAsText(blob: Blob, encoding?: string): string;
}

declare var FileReaderSync: {
    prototype: FileReaderSync;
    new(): FileReaderSync;
    isInstance(obj): obj is FileReaderSync;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystem) */
interface FileSystem {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystem/name) */
    readonly name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystem/root) */
    readonly root: FileSystemDirectoryEntry;
}

declare var FileSystem: {
    prototype: FileSystem;
    new(): FileSystem;
    isInstance(obj): obj is FileSystem;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryEntry) */
interface FileSystemDirectoryEntry extends FileSystemEntry {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryEntry/createReader) */
    createReader(): FileSystemDirectoryReader;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryEntry/getDirectory) */
    getDirectory(path?: string | null, options?: FileSystemFlags, successCallback?: FileSystemEntryCallback, errorCallback?: ErrorCallback): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryEntry/getFile) */
    getFile(path?: string | null, options?: FileSystemFlags, successCallback?: FileSystemEntryCallback, errorCallback?: ErrorCallback): void;
}

declare var FileSystemDirectoryEntry: {
    prototype: FileSystemDirectoryEntry;
    new(): FileSystemDirectoryEntry;
    isInstance(obj): obj is FileSystemDirectoryEntry;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryHandle)
 */
interface FileSystemDirectoryHandle extends FileSystemHandle {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryHandle/getDirectoryHandle) */
    getDirectoryHandle(name: string, options?: FileSystemGetDirectoryOptions): Promise<FileSystemDirectoryHandle>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryHandle/getFileHandle) */
    getFileHandle(name: string, options?: FileSystemGetFileOptions): Promise<FileSystemFileHandle>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryHandle/removeEntry) */
    removeEntry(name: string, options?: FileSystemRemoveOptions): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryHandle/resolve) */
    resolve(possibleDescendant: FileSystemHandle): Promise<string[] | null>;
}

declare var FileSystemDirectoryHandle: {
    prototype: FileSystemDirectoryHandle;
    new(): FileSystemDirectoryHandle;
    isInstance(obj): obj is FileSystemDirectoryHandle;
};

/** Available only in secure contexts. */
interface FileSystemDirectoryIterator {
    next(): Promise<any>;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryReader) */
interface FileSystemDirectoryReader {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryReader/readEntries) */
    readEntries(successCallback: FileSystemEntriesCallback, errorCallback?: ErrorCallback): void;
}

declare var FileSystemDirectoryReader: {
    prototype: FileSystemDirectoryReader;
    new(): FileSystemDirectoryReader;
    isInstance(obj): obj is FileSystemDirectoryReader;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry) */
interface FileSystemEntry {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry/filesystem) */
    readonly filesystem: FileSystem;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry/fullPath) */
    readonly fullPath: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry/isDirectory) */
    readonly isDirectory: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry/isFile) */
    readonly isFile: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry/name) */
    readonly name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry/getParent) */
    getParent(successCallback?: FileSystemEntryCallback, errorCallback?: ErrorCallback): void;
}

declare var FileSystemEntry: {
    prototype: FileSystemEntry;
    new(): FileSystemEntry;
    isInstance(obj): obj is FileSystemEntry;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemFileEntry) */
interface FileSystemFileEntry extends FileSystemEntry {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemFileEntry/file) */
    file(successCallback: FileCallback, errorCallback?: ErrorCallback): void;
}

declare var FileSystemFileEntry: {
    prototype: FileSystemFileEntry;
    new(): FileSystemFileEntry;
    isInstance(obj): obj is FileSystemFileEntry;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemFileHandle)
 */
interface FileSystemFileHandle extends FileSystemHandle {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemFileHandle/createSyncAccessHandle) */
    createSyncAccessHandle(): Promise<FileSystemSyncAccessHandle>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemFileHandle/createWritable) */
    createWritable(options?: FileSystemCreateWritableOptions): Promise<FileSystemWritableFileStream>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemFileHandle/getFile) */
    getFile(): Promise<File>;
}

declare var FileSystemFileHandle: {
    prototype: FileSystemFileHandle;
    new(): FileSystemFileHandle;
    isInstance(obj): obj is FileSystemFileHandle;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemHandle)
 */
interface FileSystemHandle {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemHandle/kind) */
    readonly kind: FileSystemHandleKind;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemHandle/name) */
    readonly name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemHandle/isSameEntry) */
    isSameEntry(other: FileSystemHandle): Promise<boolean>;
    move(name: string): Promise<void>;
    move(parent: FileSystemDirectoryHandle): Promise<void>;
    move(parent: FileSystemDirectoryHandle, name: string): Promise<void>;
}

declare var FileSystemHandle: {
    prototype: FileSystemHandle;
    new(): FileSystemHandle;
    isInstance(obj): obj is FileSystemHandle;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemSyncAccessHandle)
 */
interface FileSystemSyncAccessHandle {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemSyncAccessHandle/close) */
    close(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemSyncAccessHandle/flush) */
    flush(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemSyncAccessHandle/getSize) */
    getSize(): number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemSyncAccessHandle/read) */
    read(buffer: ArrayBufferView | ArrayBuffer, options?: FileSystemReadWriteOptions): number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemSyncAccessHandle/truncate) */
    truncate(size: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemSyncAccessHandle/write) */
    write(buffer: ArrayBufferView | ArrayBuffer, options?: FileSystemReadWriteOptions): number;
}

declare var FileSystemSyncAccessHandle: {
    prototype: FileSystemSyncAccessHandle;
    new(): FileSystemSyncAccessHandle;
    isInstance(obj): obj is FileSystemSyncAccessHandle;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemWritableFileStream)
 */
interface FileSystemWritableFileStream extends WritableStream {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemWritableFileStream/seek) */
    seek(position: number): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemWritableFileStream/truncate) */
    truncate(size: number): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemWritableFileStream/write) */
    write(data: FileSystemWriteChunkType): Promise<void>;
}

declare var FileSystemWritableFileStream: {
    prototype: FileSystemWritableFileStream;
    new(): FileSystemWritableFileStream;
    isInstance(obj): obj is FileSystemWritableFileStream;
};

interface Flex {
    readonly crossAxisDirection: FlexPhysicalDirection;
    readonly mainAxisDirection: FlexPhysicalDirection;
    getLines(): FlexLineValues[];
}

declare var Flex: {
    prototype: Flex;
    new(): Flex;
    isInstance(obj): obj is Flex;
};

interface FlexItemValues {
    readonly clampState: FlexItemClampState;
    readonly crossMaxSize: number;
    readonly crossMinSize: number;
    readonly frameRect: DOMRectReadOnly;
    readonly mainBaseSize: number;
    readonly mainDeltaSize: number;
    readonly mainMaxSize: number;
    readonly mainMinSize: number;
    readonly node: Node | null;
}

declare var FlexItemValues: {
    prototype: FlexItemValues;
    new(): FlexItemValues;
    isInstance(obj): obj is FlexItemValues;
};

interface FlexLineValues {
    readonly crossSize: number;
    readonly crossStart: number;
    readonly firstBaselineOffset: number;
    readonly growthState: FlexLineGrowthState;
    readonly lastBaselineOffset: number;
    getItems(): FlexItemValues[];
}

declare var FlexLineValues: {
    prototype: FlexLineValues;
    new(): FlexLineValues;
    isInstance(obj): obj is FlexLineValues;
};

interface FluentBundle {
    readonly locales: UTF8String[];
    addResource(aResource: FluentResource, aOptions?: FluentBundleAddResourceOptions): void;
    formatPattern(pattern: FluentPattern, aArgs?: L10nArgs | null, aErrors?: any): UTF8String;
    getMessage(id: UTF8String): FluentMessage | null;
    hasMessage(id: UTF8String): boolean;
}

declare var FluentBundle: {
    prototype: FluentBundle;
    new(aLocales: UTF8String | UTF8String[], aOptions?: FluentBundleOptions): FluentBundle;
    isInstance(obj): obj is FluentBundle;
};

interface FluentBundleAsyncIterator {
    next(): Promise<FluentBundleIteratorResult>;
    values(): FluentBundleAsyncIterator;
}

interface FluentBundleIterator {
    next(): FluentBundleIteratorResult;
    values(): FluentBundleIterator;
}

interface FluentPattern {
}

declare var FluentPattern: {
    prototype: FluentPattern;
    new(): FluentPattern;
    isInstance(obj): obj is FluentPattern;
};

interface FluentResource {
    textElements(): FluentTextElementItem[];
}

declare var FluentResource: {
    prototype: FluentResource;
    new(source: UTF8String): FluentResource;
    isInstance(obj): obj is FluentResource;
};

/**
 * Focus-related events like focus, blur, focusin, or focusout.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FocusEvent)
 */
interface FocusEvent extends UIEvent {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FocusEvent/relatedTarget) */
    readonly relatedTarget: EventTarget | null;
}

declare var FocusEvent: {
    prototype: FocusEvent;
    new(typeArg: string, focusEventInitDict?: FocusEventInit): FocusEvent;
    isInstance(obj): obj is FocusEvent;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace) */
interface FontFace {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/ascentOverride) */
    ascentOverride: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/descentOverride) */
    descentOverride: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/display) */
    display: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/family) */
    family: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/featureSettings) */
    featureSettings: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/lineGapOverride) */
    lineGapOverride: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/loaded) */
    readonly loaded: Promise<FontFace>;
    sizeAdjust: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/status) */
    readonly status: FontFaceLoadStatus;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/stretch) */
    stretch: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/style) */
    style: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/unicodeRange) */
    unicodeRange: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/variant) */
    variant: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/variationSettings) */
    variationSettings: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/weight) */
    weight: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/load) */
    load(): Promise<FontFace>;
}

declare var FontFace: {
    prototype: FontFace;
    new(family: UTF8String, source: UTF8String | BinaryData, descriptors?: FontFaceDescriptors): FontFace;
    isInstance(obj): obj is FontFace;
};

interface FontFaceSetEventMap {
    "loading": Event;
    "loadingdone": Event;
    "loadingerror": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet) */
interface FontFaceSet extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/loading_event) */
    onloading: ((this: FontFaceSet, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/loadingdone_event) */
    onloadingdone: ((this: FontFaceSet, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/loadingerror_event) */
    onloadingerror: ((this: FontFaceSet, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/ready) */
    readonly ready: Promise<undefined>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/size) */
    readonly size: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/status) */
    readonly status: FontFaceSetLoadStatus;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/add) */
    add(font: FontFace): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/check) */
    check(font: UTF8String, text?: string): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/clear) */
    clear(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/delete) */
    delete(font: FontFace): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/entries) */
    entries(): FontFaceSetIterator;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/forEach) */
    forEach(cb: FontFaceSetForEachCallback, thisArg?: any): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/has) */
    has(font: FontFace): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/load) */
    load(font: UTF8String, text?: string): Promise<FontFace[]>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/values) */
    values(): FontFaceSetIterator;
    addEventListener<K extends keyof FontFaceSetEventMap>(type: K, listener: (this: FontFaceSet, ev: FontFaceSetEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof FontFaceSetEventMap>(type: K, listener: (this: FontFaceSet, ev: FontFaceSetEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var FontFaceSet: {
    prototype: FontFaceSet;
    new(): FontFaceSet;
    isInstance(obj): obj is FontFaceSet;
};

interface FontFaceSetIterator {
    next(): FontFaceSetIteratorResult;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSetLoadEvent) */
interface FontFaceSetLoadEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSetLoadEvent/fontfaces) */
    readonly fontfaces: FontFace[];
}

declare var FontFaceSetLoadEvent: {
    prototype: FontFaceSetLoadEvent;
    new(type: string, eventInitDict?: FontFaceSetLoadEventInit): FontFaceSetLoadEvent;
    isInstance(obj): obj is FontFaceSetLoadEvent;
};

interface FontFaceSource {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fonts) */
    readonly fonts: FontFaceSet;
}

/**
 * Provides a way to easily construct a set of key/value pairs representing form fields and their values, which can then be easily sent using the XMLHttpRequest.send() method. It uses the same format a form would use if the encoding type were set to "multipart/form-data".
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData)
 */
interface FormData {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData/append) */
    append(name: string, value: Blob, filename?: string): void;
    append(name: string, value: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData/delete) */
    delete(name: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData/get) */
    get(name: string): FormDataEntryValue | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData/getAll) */
    getAll(name: string): FormDataEntryValue[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData/has) */
    has(name: string): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData/set) */
    set(name: string, value: Blob, filename?: string): void;
    set(name: string, value: string): void;
    forEach(callbackfn: (value: FormDataEntryValue, key: string, parent: FormData) => void, thisArg?: any): void;
}

declare var FormData: {
    prototype: FormData;
    new(form?: HTMLFormElement, submitter?: HTMLElement | null): FormData;
    isInstance(obj): obj is FormData;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormDataEvent) */
interface FormDataEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormDataEvent/formData) */
    readonly formData: FormData;
}

declare var FormDataEvent: {
    prototype: FormDataEvent;
    new(type: string, eventInitDict?: FormDataEventInit): FormDataEvent;
    isInstance(obj): obj is FormDataEvent;
};

interface FrameCrashedEvent extends Event {
    readonly browsingContextId: number;
    readonly childID: number;
    readonly isTopFrame: boolean;
}

declare var FrameCrashedEvent: {
    prototype: FrameCrashedEvent;
    new(type: string, eventInitDict?: FrameCrashedEventInit): FrameCrashedEvent;
    isInstance(obj): obj is FrameCrashedEvent;
};

interface FrameLoader extends WebBrowserPersistable {
    readonly browsingContext: BrowsingContext | null;
    readonly childID: number;
    readonly depthTooGreat: boolean;
    readonly docShell: nsIDocShell | null;
    readonly isDead: boolean;
    readonly isRemoteFrame: boolean;
    readonly lazyHeight: number;
    readonly lazyWidth: number;
    readonly loadContext: LoadContext | null;
    readonly messageManager: MessageSender | null;
    readonly ownerElement: Element | null;
    readonly ownerIsMozBrowserFrame: boolean;
    readonly remoteTab: RemoteTab | null;
    exitPrintPreview(): void;
    printPreview(aPrintSettings: nsIPrintSettings, aSourceBrowsingContext: BrowsingContext | null): Promise<number>;
    requestEpochUpdate(aEpoch: number): void;
    requestSHistoryUpdate(): void;
    requestTabStateFlush(): Promise<void>;
    requestUpdatePosition(): void;
}

declare var FrameLoader: {
    prototype: FrameLoader;
    new(): FrameLoader;
    isInstance(obj): obj is FrameLoader;
};

interface FrameScriptLoader {
    getDelayedFrameScripts(): any[][];
    loadFrameScript(url: string, allowDelayedLoad: boolean, runInGlobalScope?: boolean): void;
    removeDelayedFrameScript(url: string): void;
}

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPU)
 */
interface GPU {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPU/getPreferredCanvasFormat) */
    getPreferredCanvasFormat(): GPUTextureFormat;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPU/requestAdapter) */
    requestAdapter(options?: GPURequestAdapterOptions): Promise<GPUAdapter | null>;
}

declare var GPU: {
    prototype: GPU;
    new(): GPU;
    isInstance(obj): obj is GPU;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUAdapter)
 */
interface GPUAdapter {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUAdapter/features) */
    readonly features: GPUSupportedFeatures;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUAdapter/isFallbackAdapter) */
    readonly isFallbackAdapter: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUAdapter/limits) */
    readonly limits: GPUSupportedLimits;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUAdapter/requestAdapterInfo) */
    requestAdapterInfo(unmaskHints?: string[]): Promise<GPUAdapterInfo>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUAdapter/requestDevice) */
    requestDevice(descriptor?: GPUDeviceDescriptor): Promise<GPUDevice>;
}

declare var GPUAdapter: {
    prototype: GPUAdapter;
    new(): GPUAdapter;
    isInstance(obj): obj is GPUAdapter;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUAdapterInfo)
 */
interface GPUAdapterInfo {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUAdapterInfo/architecture) */
    readonly architecture: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUAdapterInfo/description) */
    readonly description: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUAdapterInfo/device) */
    readonly device: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUAdapterInfo/vendor) */
    readonly vendor: string;
    readonly wgpuBackend: string;
    readonly wgpuDevice: number;
    readonly wgpuDeviceType: string;
    readonly wgpuDriver: string;
    readonly wgpuDriverInfo: string;
    readonly wgpuName: string;
    readonly wgpuVendor: number;
}

declare var GPUAdapterInfo: {
    prototype: GPUAdapterInfo;
    new(): GPUAdapterInfo;
    isInstance(obj): obj is GPUAdapterInfo;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUBindGroup)
 */
interface GPUBindGroup extends GPUObjectBase {
}

declare var GPUBindGroup: {
    prototype: GPUBindGroup;
    new(): GPUBindGroup;
    isInstance(obj): obj is GPUBindGroup;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUBindGroupLayout)
 */
interface GPUBindGroupLayout extends GPUObjectBase {
}

declare var GPUBindGroupLayout: {
    prototype: GPUBindGroupLayout;
    new(): GPUBindGroupLayout;
    isInstance(obj): obj is GPUBindGroupLayout;
};

interface GPUBindingCommandsMixin {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUComputePassEncoder/setBindGroup) */
    setBindGroup(index: GPUIndex32, bindGroup: GPUBindGroup, dynamicOffsets?: GPUBufferDynamicOffset[]): void;
}

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUBuffer)
 */
interface GPUBuffer extends GPUObjectBase {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUBuffer/mapState) */
    readonly mapState: GPUBufferMapState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUBuffer/size) */
    readonly size: GPUSize64Out;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUBuffer/usage) */
    readonly usage: GPUFlagsConstant;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUBuffer/destroy) */
    destroy(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUBuffer/getMappedRange) */
    getMappedRange(offset?: GPUSize64, size?: GPUSize64): ArrayBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUBuffer/mapAsync) */
    mapAsync(mode: GPUMapModeFlags, offset?: GPUSize64, size?: GPUSize64): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUBuffer/unmap) */
    unmap(): void;
}

declare var GPUBuffer: {
    prototype: GPUBuffer;
    new(): GPUBuffer;
    isInstance(obj): obj is GPUBuffer;
};

/** Available only in secure contexts. */
interface GPUBufferUsage {
    readonly MAP_READ: 0x0001;
    readonly MAP_WRITE: 0x0002;
    readonly COPY_SRC: 0x0004;
    readonly COPY_DST: 0x0008;
    readonly INDEX: 0x0010;
    readonly VERTEX: 0x0020;
    readonly UNIFORM: 0x0040;
    readonly STORAGE: 0x0080;
    readonly INDIRECT: 0x0100;
    readonly QUERY_RESOLVE: 0x0200;
}

declare var GPUBufferUsage: {
    prototype: GPUBufferUsage;
    new(): GPUBufferUsage;
    readonly MAP_READ: 0x0001;
    readonly MAP_WRITE: 0x0002;
    readonly COPY_SRC: 0x0004;
    readonly COPY_DST: 0x0008;
    readonly INDEX: 0x0010;
    readonly VERTEX: 0x0020;
    readonly UNIFORM: 0x0040;
    readonly STORAGE: 0x0080;
    readonly INDIRECT: 0x0100;
    readonly QUERY_RESOLVE: 0x0200;
    isInstance(obj): obj is GPUBufferUsage;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCanvasContext)
 */
interface GPUCanvasContext {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCanvasContext/canvas) */
    readonly canvas: HTMLCanvasElement | OffscreenCanvas;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCanvasContext/configure) */
    configure(configuration: GPUCanvasConfiguration): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCanvasContext/getCurrentTexture) */
    getCurrentTexture(): GPUTexture;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCanvasContext/unconfigure) */
    unconfigure(): void;
}

declare var GPUCanvasContext: {
    prototype: GPUCanvasContext;
    new(): GPUCanvasContext;
    isInstance(obj): obj is GPUCanvasContext;
};

/** Available only in secure contexts. */
interface GPUColorWrite {
    readonly RED: 0x1;
    readonly GREEN: 0x2;
    readonly BLUE: 0x4;
    readonly ALPHA: 0x8;
    readonly ALL: 0xF;
}

declare var GPUColorWrite: {
    prototype: GPUColorWrite;
    new(): GPUColorWrite;
    readonly RED: 0x1;
    readonly GREEN: 0x2;
    readonly BLUE: 0x4;
    readonly ALPHA: 0x8;
    readonly ALL: 0xF;
    isInstance(obj): obj is GPUColorWrite;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCommandBuffer)
 */
interface GPUCommandBuffer extends GPUObjectBase {
}

declare var GPUCommandBuffer: {
    prototype: GPUCommandBuffer;
    new(): GPUCommandBuffer;
    isInstance(obj): obj is GPUCommandBuffer;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCommandEncoder)
 */
interface GPUCommandEncoder extends GPUDebugCommandsMixin, GPUObjectBase {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCommandEncoder/beginComputePass) */
    beginComputePass(descriptor?: GPUComputePassDescriptor): GPUComputePassEncoder;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCommandEncoder/beginRenderPass) */
    beginRenderPass(descriptor: GPURenderPassDescriptor): GPURenderPassEncoder;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCommandEncoder/clearBuffer) */
    clearBuffer(buffer: GPUBuffer, offset?: GPUSize64, size?: GPUSize64): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCommandEncoder/copyBufferToBuffer) */
    copyBufferToBuffer(source: GPUBuffer, sourceOffset: GPUSize64, destination: GPUBuffer, destinationOffset: GPUSize64, size: GPUSize64): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCommandEncoder/copyBufferToTexture) */
    copyBufferToTexture(source: GPUImageCopyBuffer, destination: GPUImageCopyTexture, copySize: GPUExtent3D): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCommandEncoder/copyTextureToBuffer) */
    copyTextureToBuffer(source: GPUImageCopyTexture, destination: GPUImageCopyBuffer, copySize: GPUExtent3D): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCommandEncoder/copyTextureToTexture) */
    copyTextureToTexture(source: GPUImageCopyTexture, destination: GPUImageCopyTexture, copySize: GPUExtent3D): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCommandEncoder/finish) */
    finish(descriptor?: GPUCommandBufferDescriptor): GPUCommandBuffer;
}

declare var GPUCommandEncoder: {
    prototype: GPUCommandEncoder;
    new(): GPUCommandEncoder;
    isInstance(obj): obj is GPUCommandEncoder;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCompilationInfo)
 */
interface GPUCompilationInfo {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCompilationInfo/messages) */
    readonly messages: GPUCompilationMessage[];
}

declare var GPUCompilationInfo: {
    prototype: GPUCompilationInfo;
    new(): GPUCompilationInfo;
    isInstance(obj): obj is GPUCompilationInfo;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCompilationMessage)
 */
interface GPUCompilationMessage {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCompilationMessage/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCompilationMessage/lineNum) */
    readonly lineNum: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCompilationMessage/linePos) */
    readonly linePos: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCompilationMessage/message) */
    readonly message: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCompilationMessage/offset) */
    readonly offset: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCompilationMessage/type) */
    readonly type: GPUCompilationMessageType;
}

declare var GPUCompilationMessage: {
    prototype: GPUCompilationMessage;
    new(): GPUCompilationMessage;
    isInstance(obj): obj is GPUCompilationMessage;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUComputePassEncoder)
 */
interface GPUComputePassEncoder extends GPUBindingCommandsMixin, GPUDebugCommandsMixin, GPUObjectBase {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUComputePassEncoder/dispatchWorkgroups) */
    dispatchWorkgroups(workgroupCountX: GPUSize32, workgroupCountY?: GPUSize32, workgroupCountZ?: GPUSize32): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUComputePassEncoder/dispatchWorkgroupsIndirect) */
    dispatchWorkgroupsIndirect(indirectBuffer: GPUBuffer, indirectOffset: GPUSize64): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUComputePassEncoder/end) */
    end(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUComputePassEncoder/setPipeline) */
    setPipeline(pipeline: GPUComputePipeline): void;
}

declare var GPUComputePassEncoder: {
    prototype: GPUComputePassEncoder;
    new(): GPUComputePassEncoder;
    isInstance(obj): obj is GPUComputePassEncoder;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUComputePipeline)
 */
interface GPUComputePipeline extends GPUObjectBase, GPUPipelineBase {
}

declare var GPUComputePipeline: {
    prototype: GPUComputePipeline;
    new(): GPUComputePipeline;
    isInstance(obj): obj is GPUComputePipeline;
};

interface GPUDebugCommandsMixin {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCommandEncoder/insertDebugMarker) */
    insertDebugMarker(markerLabel: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCommandEncoder/popDebugGroup) */
    popDebugGroup(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUCommandEncoder/pushDebugGroup) */
    pushDebugGroup(groupLabel: string): void;
}

interface GPUDeviceEventMap {
    "uncapturederror": Event;
}

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice)
 */
interface GPUDevice extends EventTarget, GPUObjectBase {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/features) */
    readonly features: GPUSupportedFeatures;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/limits) */
    readonly limits: GPUSupportedLimits;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/lost) */
    readonly lost: Promise<GPUDeviceLostInfo>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/uncapturederror_event) */
    onuncapturederror: ((this: GPUDevice, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/queue) */
    readonly queue: GPUQueue;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/createBindGroup) */
    createBindGroup(descriptor: GPUBindGroupDescriptor): GPUBindGroup;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/createBindGroupLayout) */
    createBindGroupLayout(descriptor: GPUBindGroupLayoutDescriptor): GPUBindGroupLayout;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/createBuffer) */
    createBuffer(descriptor: GPUBufferDescriptor): GPUBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/createCommandEncoder) */
    createCommandEncoder(descriptor?: GPUCommandEncoderDescriptor): GPUCommandEncoder;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/createComputePipeline) */
    createComputePipeline(descriptor: GPUComputePipelineDescriptor): GPUComputePipeline;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/createComputePipelineAsync) */
    createComputePipelineAsync(descriptor: GPUComputePipelineDescriptor): Promise<GPUComputePipeline>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/createPipelineLayout) */
    createPipelineLayout(descriptor: GPUPipelineLayoutDescriptor): GPUPipelineLayout;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/createRenderBundleEncoder) */
    createRenderBundleEncoder(descriptor: GPURenderBundleEncoderDescriptor): GPURenderBundleEncoder;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/createRenderPipeline) */
    createRenderPipeline(descriptor: GPURenderPipelineDescriptor): GPURenderPipeline;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/createRenderPipelineAsync) */
    createRenderPipelineAsync(descriptor: GPURenderPipelineDescriptor): Promise<GPURenderPipeline>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/createSampler) */
    createSampler(descriptor?: GPUSamplerDescriptor): GPUSampler;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/createShaderModule) */
    createShaderModule(descriptor: GPUShaderModuleDescriptor): GPUShaderModule;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/createTexture) */
    createTexture(descriptor: GPUTextureDescriptor): GPUTexture;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/destroy) */
    destroy(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/popErrorScope) */
    popErrorScope(): Promise<GPUError | null>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDevice/pushErrorScope) */
    pushErrorScope(filter: GPUErrorFilter): void;
    addEventListener<K extends keyof GPUDeviceEventMap>(type: K, listener: (this: GPUDevice, ev: GPUDeviceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof GPUDeviceEventMap>(type: K, listener: (this: GPUDevice, ev: GPUDeviceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var GPUDevice: {
    prototype: GPUDevice;
    new(): GPUDevice;
    isInstance(obj): obj is GPUDevice;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDeviceLostInfo)
 */
interface GPUDeviceLostInfo {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDeviceLostInfo/message) */
    readonly message: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUDeviceLostInfo/reason) */
    readonly reason: any;
}

declare var GPUDeviceLostInfo: {
    prototype: GPUDeviceLostInfo;
    new(): GPUDeviceLostInfo;
    isInstance(obj): obj is GPUDeviceLostInfo;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUError)
 */
interface GPUError {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUError/message) */
    readonly message: string;
}

declare var GPUError: {
    prototype: GPUError;
    new(): GPUError;
    isInstance(obj): obj is GPUError;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUInternalError)
 */
interface GPUInternalError extends GPUError {
}

declare var GPUInternalError: {
    prototype: GPUInternalError;
    new(message: string): GPUInternalError;
    isInstance(obj): obj is GPUInternalError;
};

/** Available only in secure contexts. */
interface GPUMapMode {
    readonly READ: 0x0001;
    readonly WRITE: 0x0002;
}

declare var GPUMapMode: {
    prototype: GPUMapMode;
    new(): GPUMapMode;
    readonly READ: 0x0001;
    readonly WRITE: 0x0002;
    isInstance(obj): obj is GPUMapMode;
};

interface GPUObjectBase {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUBindGroup/label) */
    label: string | null;
}

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUOutOfMemoryError)
 */
interface GPUOutOfMemoryError extends GPUError {
}

declare var GPUOutOfMemoryError: {
    prototype: GPUOutOfMemoryError;
    new(message: string): GPUOutOfMemoryError;
    isInstance(obj): obj is GPUOutOfMemoryError;
};

interface GPUPipelineBase {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUComputePipeline/getBindGroupLayout) */
    getBindGroupLayout(index: number): GPUBindGroupLayout;
}

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUPipelineLayout)
 */
interface GPUPipelineLayout extends GPUObjectBase {
}

declare var GPUPipelineLayout: {
    prototype: GPUPipelineLayout;
    new(): GPUPipelineLayout;
    isInstance(obj): obj is GPUPipelineLayout;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUQuerySet)
 */
interface GPUQuerySet extends GPUObjectBase {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUQuerySet/destroy) */
    destroy(): void;
}

declare var GPUQuerySet: {
    prototype: GPUQuerySet;
    new(): GPUQuerySet;
    isInstance(obj): obj is GPUQuerySet;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUQueue)
 */
interface GPUQueue extends GPUObjectBase {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUQueue/copyExternalImageToTexture) */
    copyExternalImageToTexture(source: GPUImageCopyExternalImage, destination: GPUImageCopyTextureTagged, copySize: GPUExtent3D): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUQueue/onSubmittedWorkDone) */
    onSubmittedWorkDone(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUQueue/submit) */
    submit(buffers: GPUCommandBuffer[]): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUQueue/writeBuffer) */
    writeBuffer(buffer: GPUBuffer, bufferOffset: GPUSize64, data: BufferSource, dataOffset?: GPUSize64, size?: GPUSize64): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUQueue/writeTexture) */
    writeTexture(destination: GPUImageCopyTexture, data: BufferSource, dataLayout: GPUImageDataLayout, size: GPUExtent3D): void;
}

declare var GPUQueue: {
    prototype: GPUQueue;
    new(): GPUQueue;
    isInstance(obj): obj is GPUQueue;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderBundle)
 */
interface GPURenderBundle extends GPUObjectBase {
}

declare var GPURenderBundle: {
    prototype: GPURenderBundle;
    new(): GPURenderBundle;
    isInstance(obj): obj is GPURenderBundle;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderBundleEncoder)
 */
interface GPURenderBundleEncoder extends GPUBindingCommandsMixin, GPUDebugCommandsMixin, GPUObjectBase, GPURenderCommandsMixin {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderBundleEncoder/finish) */
    finish(descriptor?: GPURenderBundleDescriptor): GPURenderBundle;
}

declare var GPURenderBundleEncoder: {
    prototype: GPURenderBundleEncoder;
    new(): GPURenderBundleEncoder;
    isInstance(obj): obj is GPURenderBundleEncoder;
};

interface GPURenderCommandsMixin {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderBundleEncoder/draw) */
    draw(vertexCount: GPUSize32, instanceCount?: GPUSize32, firstVertex?: GPUSize32, firstInstance?: GPUSize32): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderBundleEncoder/drawIndexed) */
    drawIndexed(indexCount: GPUSize32, instanceCount?: GPUSize32, firstIndex?: GPUSize32, baseVertex?: GPUSignedOffset32, firstInstance?: GPUSize32): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderBundleEncoder/drawIndexedIndirect) */
    drawIndexedIndirect(indirectBuffer: GPUBuffer, indirectOffset: GPUSize64): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderBundleEncoder/drawIndirect) */
    drawIndirect(indirectBuffer: GPUBuffer, indirectOffset: GPUSize64): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderBundleEncoder/setIndexBuffer) */
    setIndexBuffer(buffer: GPUBuffer, indexFormat: GPUIndexFormat, offset?: GPUSize64, size?: GPUSize64): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderBundleEncoder/setPipeline) */
    setPipeline(pipeline: GPURenderPipeline): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderBundleEncoder/setVertexBuffer) */
    setVertexBuffer(slot: GPUIndex32, buffer: GPUBuffer, offset?: GPUSize64, size?: GPUSize64): void;
}

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderPassEncoder)
 */
interface GPURenderPassEncoder extends GPUBindingCommandsMixin, GPUDebugCommandsMixin, GPUObjectBase, GPURenderCommandsMixin {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderPassEncoder/end) */
    end(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderPassEncoder/executeBundles) */
    executeBundles(bundles: GPURenderBundle[]): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderPassEncoder/setBlendConstant) */
    setBlendConstant(color: GPUColor): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderPassEncoder/setScissorRect) */
    setScissorRect(x: GPUIntegerCoordinate, y: GPUIntegerCoordinate, width: GPUIntegerCoordinate, height: GPUIntegerCoordinate): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderPassEncoder/setStencilReference) */
    setStencilReference(reference: GPUStencilValue): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderPassEncoder/setViewport) */
    setViewport(x: number, y: number, width: number, height: number, minDepth: number, maxDepth: number): void;
}

declare var GPURenderPassEncoder: {
    prototype: GPURenderPassEncoder;
    new(): GPURenderPassEncoder;
    isInstance(obj): obj is GPURenderPassEncoder;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPURenderPipeline)
 */
interface GPURenderPipeline extends GPUObjectBase, GPUPipelineBase {
}

declare var GPURenderPipeline: {
    prototype: GPURenderPipeline;
    new(): GPURenderPipeline;
    isInstance(obj): obj is GPURenderPipeline;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUSampler)
 */
interface GPUSampler extends GPUObjectBase {
}

declare var GPUSampler: {
    prototype: GPUSampler;
    new(): GPUSampler;
    isInstance(obj): obj is GPUSampler;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUShaderModule)
 */
interface GPUShaderModule extends GPUObjectBase {
    compilationInfo(): Promise<GPUCompilationInfo>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUShaderModule/getCompilationInfo) */
    getCompilationInfo(): Promise<GPUCompilationInfo>;
}

declare var GPUShaderModule: {
    prototype: GPUShaderModule;
    new(): GPUShaderModule;
    isInstance(obj): obj is GPUShaderModule;
};

/** Available only in secure contexts. */
interface GPUShaderStage {
    readonly VERTEX: 0x1;
    readonly FRAGMENT: 0x2;
    readonly COMPUTE: 0x4;
}

declare var GPUShaderStage: {
    prototype: GPUShaderStage;
    new(): GPUShaderStage;
    readonly VERTEX: 0x1;
    readonly FRAGMENT: 0x2;
    readonly COMPUTE: 0x4;
    isInstance(obj): obj is GPUShaderStage;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUSupportedFeatures)
 */
interface GPUSupportedFeatures {
    forEach(callbackfn: (value: string, key: string, parent: GPUSupportedFeatures) => void, thisArg?: any): void;
}

declare var GPUSupportedFeatures: {
    prototype: GPUSupportedFeatures;
    new(): GPUSupportedFeatures;
    isInstance(obj): obj is GPUSupportedFeatures;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUSupportedLimits)
 */
interface GPUSupportedLimits {
    readonly maxBindGroups: number;
    readonly maxBindGroupsPlusVertexBuffers: number;
    readonly maxBindingsPerBindGroup: number;
    readonly maxBufferSize: number;
    readonly maxColorAttachmentBytesPerSample: number;
    readonly maxColorAttachments: number;
    readonly maxComputeInvocationsPerWorkgroup: number;
    readonly maxComputeWorkgroupSizeX: number;
    readonly maxComputeWorkgroupSizeY: number;
    readonly maxComputeWorkgroupSizeZ: number;
    readonly maxComputeWorkgroupStorageSize: number;
    readonly maxComputeWorkgroupsPerDimension: number;
    readonly maxDynamicStorageBuffersPerPipelineLayout: number;
    readonly maxDynamicUniformBuffersPerPipelineLayout: number;
    readonly maxInterStageShaderComponents: number;
    readonly maxInterStageShaderVariables: number;
    readonly maxSampledTexturesPerShaderStage: number;
    readonly maxSamplersPerShaderStage: number;
    readonly maxStorageBufferBindingSize: number;
    readonly maxStorageBuffersPerShaderStage: number;
    readonly maxStorageTexturesPerShaderStage: number;
    readonly maxTextureArrayLayers: number;
    readonly maxTextureDimension1D: number;
    readonly maxTextureDimension2D: number;
    readonly maxTextureDimension3D: number;
    readonly maxUniformBufferBindingSize: number;
    readonly maxUniformBuffersPerShaderStage: number;
    readonly maxVertexAttributes: number;
    readonly maxVertexBufferArrayStride: number;
    readonly maxVertexBuffers: number;
    readonly minStorageBufferOffsetAlignment: number;
    readonly minUniformBufferOffsetAlignment: number;
}

declare var GPUSupportedLimits: {
    prototype: GPUSupportedLimits;
    new(): GPUSupportedLimits;
    isInstance(obj): obj is GPUSupportedLimits;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUTexture)
 */
interface GPUTexture extends GPUObjectBase {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUTexture/depthOrArrayLayers) */
    readonly depthOrArrayLayers: GPUIntegerCoordinateOut;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUTexture/dimension) */
    readonly dimension: GPUTextureDimension;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUTexture/format) */
    readonly format: GPUTextureFormat;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUTexture/height) */
    readonly height: GPUIntegerCoordinateOut;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUTexture/mipLevelCount) */
    readonly mipLevelCount: GPUIntegerCoordinateOut;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUTexture/sampleCount) */
    readonly sampleCount: GPUSize32Out;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUTexture/usage) */
    readonly usage: GPUFlagsConstant;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUTexture/width) */
    readonly width: GPUIntegerCoordinateOut;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUTexture/createView) */
    createView(descriptor?: GPUTextureViewDescriptor): GPUTextureView;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUTexture/destroy) */
    destroy(): void;
}

declare var GPUTexture: {
    prototype: GPUTexture;
    new(): GPUTexture;
    isInstance(obj): obj is GPUTexture;
};

/** Available only in secure contexts. */
interface GPUTextureUsage {
    readonly COPY_SRC: 0x01;
    readonly COPY_DST: 0x02;
    readonly TEXTURE_BINDING: 0x04;
    readonly STORAGE_BINDING: 0x08;
    readonly RENDER_ATTACHMENT: 0x10;
}

declare var GPUTextureUsage: {
    prototype: GPUTextureUsage;
    new(): GPUTextureUsage;
    readonly COPY_SRC: 0x01;
    readonly COPY_DST: 0x02;
    readonly TEXTURE_BINDING: 0x04;
    readonly STORAGE_BINDING: 0x08;
    readonly RENDER_ATTACHMENT: 0x10;
    isInstance(obj): obj is GPUTextureUsage;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUTextureView)
 */
interface GPUTextureView extends GPUObjectBase {
}

declare var GPUTextureView: {
    prototype: GPUTextureView;
    new(): GPUTextureView;
    isInstance(obj): obj is GPUTextureView;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUUncapturedErrorEvent)
 */
interface GPUUncapturedErrorEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUUncapturedErrorEvent/error) */
    "error": ErrorEvent;
}

declare var GPUUncapturedErrorEvent: {
    prototype: GPUUncapturedErrorEvent;
    new(type: string, gpuUncapturedErrorEventInitDict: GPUUncapturedErrorEventInit): GPUUncapturedErrorEvent;
    isInstance(obj): obj is GPUUncapturedErrorEvent;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUValidationError)
 */
interface GPUValidationError extends GPUError {
}

declare var GPUValidationError: {
    prototype: GPUValidationError;
    new(message: string): GPUValidationError;
    isInstance(obj): obj is GPUValidationError;
};

/**
 * A change in volume. It is an AudioNode audio-processing module that causes a given gain to be applied to the input data before its propagation to the output. A GainNode always has exactly one input and one output, both with the same number of channels.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GainNode)
 */
interface GainNode extends AudioNode, AudioNodePassThrough {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GainNode/gain) */
    readonly gain: AudioParam;
}

declare var GainNode: {
    prototype: GainNode;
    new(context: BaseAudioContext, options?: GainOptions): GainNode;
    isInstance(obj): obj is GainNode;
};

/**
 * This Gamepad API interface defines an individual gamepad or other controller, allowing access to information such as button presses, axis positions, and id.
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad)
 */
interface Gamepad {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/axes) */
    readonly axes: number[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/buttons) */
    readonly buttons: GamepadButton[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/connected) */
    readonly connected: boolean;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/displayId)
     */
    readonly displayId: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/hand) */
    readonly hand: GamepadHand;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/hapticActuators) */
    readonly hapticActuators: GamepadHapticActuator[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/id) */
    readonly id: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/index) */
    readonly index: number;
    readonly lightIndicators: GamepadLightIndicator[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/mapping) */
    readonly mapping: GamepadMappingType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/pose) */
    readonly pose: GamepadPose | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/timestamp) */
    readonly timestamp: DOMHighResTimeStamp;
    readonly touchEvents: GamepadTouch[];
}

declare var Gamepad: {
    prototype: Gamepad;
    new(): Gamepad;
    isInstance(obj): obj is Gamepad;
};

/** Available only in secure contexts. */
interface GamepadAxisMoveEvent extends GamepadEvent {
    readonly axis: number;
    readonly value: number;
}

declare var GamepadAxisMoveEvent: {
    prototype: GamepadAxisMoveEvent;
    new(type: string, eventInitDict?: GamepadAxisMoveEventInit): GamepadAxisMoveEvent;
    isInstance(obj): obj is GamepadAxisMoveEvent;
};

/**
 * An individual button of a gamepad or other controller, allowing access to the current state of different types of buttons available on the control device.
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadButton)
 */
interface GamepadButton {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadButton/pressed) */
    readonly pressed: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadButton/touched) */
    readonly touched: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadButton/value) */
    readonly value: number;
}

declare var GamepadButton: {
    prototype: GamepadButton;
    new(): GamepadButton;
    isInstance(obj): obj is GamepadButton;
};

/** Available only in secure contexts. */
interface GamepadButtonEvent extends GamepadEvent {
    readonly button: number;
}

declare var GamepadButtonEvent: {
    prototype: GamepadButtonEvent;
    new(type: string, eventInitDict?: GamepadButtonEventInit): GamepadButtonEvent;
    isInstance(obj): obj is GamepadButtonEvent;
};

/**
 * This Gamepad API interface contains references to gamepads connected to the system, which is what the gamepad events Window.gamepadconnected and Window.gamepaddisconnected are fired in response to.
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadEvent)
 */
interface GamepadEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadEvent/gamepad) */
    readonly gamepad: Gamepad | null;
}

declare var GamepadEvent: {
    prototype: GamepadEvent;
    new(type: string, eventInitDict?: GamepadEventInit): GamepadEvent;
    isInstance(obj): obj is GamepadEvent;
};

/**
 * This Gamepad API interface represents hardware in the controller designed to provide haptic feedback to the user (if available), most commonly vibration hardware.
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadHapticActuator)
 */
interface GamepadHapticActuator {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadHapticActuator/type) */
    readonly type: GamepadHapticActuatorType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadHapticActuator/pulse) */
    pulse(value: number, duration: number): Promise<boolean>;
}

declare var GamepadHapticActuator: {
    prototype: GamepadHapticActuator;
    new(): GamepadHapticActuator;
    isInstance(obj): obj is GamepadHapticActuator;
};

/** Available only in secure contexts. */
interface GamepadLightIndicator {
    readonly type: GamepadLightIndicatorType;
    setColor(color: GamepadLightColor): Promise<boolean>;
}

declare var GamepadLightIndicator: {
    prototype: GamepadLightIndicator;
    new(): GamepadLightIndicator;
    isInstance(obj): obj is GamepadLightIndicator;
};

/**
 * This Gamepad API interface represents the pose of a WebVR controller at a given timestamp (which includes orientation, position, velocity, and acceleration information.)
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadPose)
 */
interface GamepadPose {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadPose/angularAcceleration) */
    readonly angularAcceleration: Float32Array | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadPose/angularVelocity) */
    readonly angularVelocity: Float32Array | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadPose/hasOrientation) */
    readonly hasOrientation: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadPose/hasPosition) */
    readonly hasPosition: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadPose/linearAcceleration) */
    readonly linearAcceleration: Float32Array | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadPose/linearVelocity) */
    readonly linearVelocity: Float32Array | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadPose/orientation) */
    readonly orientation: Float32Array | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadPose/position) */
    readonly position: Float32Array | null;
}

declare var GamepadPose: {
    prototype: GamepadPose;
    new(): GamepadPose;
    isInstance(obj): obj is GamepadPose;
};

interface GamepadServiceTest {
    readonly leftHand: GamepadHand;
    readonly noHand: GamepadHand;
    readonly noMapping: GamepadMappingType;
    readonly rightHand: GamepadHand;
    readonly standardMapping: GamepadMappingType;
    addGamepad(id: string, mapping: GamepadMappingType, hand: GamepadHand, numButtons: number, numAxes: number, numHaptics: number, numLightIndicator: number, numTouchEvents: number): Promise<number>;
    newAxisMoveEvent(index: number, axis: number, value: number): Promise<number>;
    newButtonEvent(index: number, button: number, pressed: boolean, touched: boolean): Promise<number>;
    newButtonValueEvent(index: number, button: number, pressed: boolean, touched: boolean, value: number): Promise<number>;
    newPoseMove(index: number, orient: Float32Array | null, pos: Float32Array | null, angVelocity: Float32Array | null, angAcceleration: Float32Array | null, linVelocity: Float32Array | null, linAcceleration: Float32Array | null): Promise<number>;
    newTouch(index: number, aTouchArrayIndex: number, touchId: number, surfaceId: number, position: Float32Array, surfaceDimension: Float32Array | null): Promise<number>;
    removeGamepad(index: number): Promise<number>;
}

declare var GamepadServiceTest: {
    prototype: GamepadServiceTest;
    new(): GamepadServiceTest;
    isInstance(obj): obj is GamepadServiceTest;
};

/** Available only in secure contexts. */
interface GamepadTouch {
    readonly position: Float32Array;
    readonly surfaceDimensions: Uint32Array | null;
    readonly surfaceId: number;
    readonly touchId: number;
}

declare var GamepadTouch: {
    prototype: GamepadTouch;
    new(): GamepadTouch;
    isInstance(obj): obj is GamepadTouch;
};

interface GenericTransformStream {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CompressionStream/readable) */
    readonly readable: ReadableStream;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CompressionStream/writable) */
    readonly writable: WritableStream;
}

/**
 * An object able to programmatically obtain the position of the device. It gives Web content access to the location of the device. This allows a Web site or app to offer customized results based on the user's location.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Geolocation)
 */
interface Geolocation {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Geolocation/clearWatch) */
    clearWatch(watchId: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Geolocation/getCurrentPosition) */
    getCurrentPosition(successCallback: PositionCallback, errorCallback?: PositionErrorCallback | null, options?: PositionOptions): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Geolocation/watchPosition) */
    watchPosition(successCallback: PositionCallback, errorCallback?: PositionErrorCallback | null, options?: PositionOptions): number;
}

declare var Geolocation: {
    prototype: Geolocation;
    new(): Geolocation;
    isInstance(obj): obj is Geolocation;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates)
 */
interface GeolocationCoordinates {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/accuracy) */
    readonly accuracy: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/altitude) */
    readonly altitude: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/altitudeAccuracy) */
    readonly altitudeAccuracy: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/heading) */
    readonly heading: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/latitude) */
    readonly latitude: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/longitude) */
    readonly longitude: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/speed) */
    readonly speed: number | null;
}

declare var GeolocationCoordinates: {
    prototype: GeolocationCoordinates;
    new(): GeolocationCoordinates;
    isInstance(obj): obj is GeolocationCoordinates;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationPosition)
 */
interface GeolocationPosition {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationPosition/coords) */
    readonly coords: GeolocationCoordinates;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationPosition/timestamp) */
    readonly timestamp: EpochTimeStamp;
}

declare var GeolocationPosition: {
    prototype: GeolocationPosition;
    new(): GeolocationPosition;
    isInstance(obj): obj is GeolocationPosition;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationPositionError) */
interface GeolocationPositionError {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationPositionError/code) */
    readonly code: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationPositionError/message) */
    readonly message: string;
    readonly PERMISSION_DENIED: 1;
    readonly POSITION_UNAVAILABLE: 2;
    readonly TIMEOUT: 3;
}

declare var GeolocationPositionError: {
    prototype: GeolocationPositionError;
    new(): GeolocationPositionError;
    readonly PERMISSION_DENIED: 1;
    readonly POSITION_UNAVAILABLE: 2;
    readonly TIMEOUT: 3;
    isInstance(obj): obj is GeolocationPositionError;
};

interface GeometryUtils {
    convertPointFromNode(point: DOMPointInit, from: GeometryNode, options?: ConvertCoordinateOptions): DOMPoint;
    convertQuadFromNode(quad: DOMQuad, from: GeometryNode, options?: ConvertCoordinateOptions): DOMQuad;
    convertRectFromNode(rect: DOMRectReadOnly, from: GeometryNode, options?: ConvertCoordinateOptions): DOMQuad;
    getBoxQuads(options?: BoxQuadOptions): DOMQuad[];
    getBoxQuadsFromWindowOrigin(options?: BoxQuadOptions): DOMQuad[];
}

interface GetUserMediaRequest {
    readonly callID: string;
    readonly devices: nsIMediaDevice[];
    readonly innerWindowID: number;
    readonly isHandlingUserInput: boolean;
    readonly isSecure: boolean;
    readonly mediaSource: string;
    readonly rawID: string;
    readonly type: GetUserMediaRequestType;
    readonly windowID: number;
    getAudioOutputOptions(): AudioOutputOptions;
    getConstraints(): MediaStreamConstraints;
}

interface GleanBoolean extends GleanMetric {
    set(value: boolean): void;
    testGetValue(aPingName?: UTF8String): boolean | null;
}

declare var GleanBoolean: {
    prototype: GleanBoolean;
    new(): GleanBoolean;
    isInstance(obj): obj is GleanBoolean;
};

interface GleanCategory {
    [identifier: string]: GleanMetric;
}

declare var GleanCategory: {
    prototype: GleanCategory;
    new(): GleanCategory;
    isInstance(obj): obj is GleanCategory;
};

interface GleanCounter extends GleanMetric {
    add(aAmount?: number): void;
    testGetValue(aPingName?: UTF8String): number | null;
}

declare var GleanCounter: {
    prototype: GleanCounter;
    new(): GleanCounter;
    isInstance(obj): obj is GleanCounter;
};

interface GleanCustomDistribution extends GleanMetric {
    accumulateSamples(aSamples: number[]): void;
    testGetValue(aPingName?: UTF8String): GleanDistributionData | null;
}

declare var GleanCustomDistribution: {
    prototype: GleanCustomDistribution;
    new(): GleanCustomDistribution;
    isInstance(obj): obj is GleanCustomDistribution;
};

interface GleanDatetime extends GleanMetric {
    set(aValue?: number): void;
    testGetValue(aPingName?: UTF8String): any;
}

declare var GleanDatetime: {
    prototype: GleanDatetime;
    new(): GleanDatetime;
    isInstance(obj): obj is GleanDatetime;
};

interface GleanDenominator extends GleanMetric {
    add(aAmount?: number): void;
    testGetValue(aPingName?: UTF8String): number | null;
}

declare var GleanDenominator: {
    prototype: GleanDenominator;
    new(): GleanDenominator;
    isInstance(obj): obj is GleanDenominator;
};

interface GleanEvent extends GleanMetric {
    record(aExtra?: Record<UTF8String, UTF8String | null>): void;
    testGetValue(aPingName?: UTF8String): GleanEventRecord[] | null;
}

declare var GleanEvent: {
    prototype: GleanEvent;
    new(): GleanEvent;
    isInstance(obj): obj is GleanEvent;
};

interface GleanImpl {
    [identifier: string]: GleanCategory;
}

declare var GleanImpl: {
    prototype: GleanImpl;
    new(): GleanImpl;
    isInstance(obj): obj is GleanImpl;
};

interface GleanLabeled {
    [identifier: string]: GleanMetric;
}

declare var GleanLabeled: {
    prototype: GleanLabeled;
    new(): GleanLabeled;
    isInstance(obj): obj is GleanLabeled;
};

interface GleanMemoryDistribution extends GleanMetric {
    accumulate(aSample: number): void;
    testGetValue(aPingName?: UTF8String): GleanDistributionData | null;
}

declare var GleanMemoryDistribution: {
    prototype: GleanMemoryDistribution;
    new(): GleanMemoryDistribution;
    isInstance(obj): obj is GleanMemoryDistribution;
};

interface GleanMetric {
}

declare var GleanMetric: {
    prototype: GleanMetric;
    new(): GleanMetric;
    isInstance(obj): obj is GleanMetric;
};

interface GleanNumerator extends GleanMetric {
    addToNumerator(aAmount?: number): void;
    testGetValue(aPingName?: UTF8String): GleanRateData | null;
}

declare var GleanNumerator: {
    prototype: GleanNumerator;
    new(): GleanNumerator;
    isInstance(obj): obj is GleanNumerator;
};

interface GleanPingsImpl {
    [identifier: string]: nsIGleanPing;
}

declare var GleanPingsImpl: {
    prototype: GleanPingsImpl;
    new(): GleanPingsImpl;
    isInstance(obj): obj is GleanPingsImpl;
};

interface GleanQuantity extends GleanMetric {
    set(aValue: number): void;
    testGetValue(aPingName?: UTF8String): number | null;
}

declare var GleanQuantity: {
    prototype: GleanQuantity;
    new(): GleanQuantity;
    isInstance(obj): obj is GleanQuantity;
};

interface GleanRate extends GleanMetric {
    addToDenominator(aAmount?: number): void;
    addToNumerator(aAmount?: number): void;
    testGetValue(aPingName?: UTF8String): GleanRateData | null;
}

declare var GleanRate: {
    prototype: GleanRate;
    new(): GleanRate;
    isInstance(obj): obj is GleanRate;
};

interface GleanString extends GleanMetric {
    set(aValue: UTF8String | null): void;
    testGetValue(aPingName?: UTF8String): UTF8String | null;
}

declare var GleanString: {
    prototype: GleanString;
    new(): GleanString;
    isInstance(obj): obj is GleanString;
};

interface GleanStringList extends GleanMetric {
    add(value: UTF8String): void;
    set(aValue: UTF8String[]): void;
    testGetValue(aPingName?: UTF8String): UTF8String[] | null;
}

declare var GleanStringList: {
    prototype: GleanStringList;
    new(): GleanStringList;
    isInstance(obj): obj is GleanStringList;
};

interface GleanText extends GleanMetric {
    set(aValue: UTF8String): void;
    testGetValue(aPingName?: UTF8String): UTF8String | null;
}

declare var GleanText: {
    prototype: GleanText;
    new(): GleanText;
    isInstance(obj): obj is GleanText;
};

interface GleanTimespan extends GleanMetric {
    cancel(): void;
    setRaw(aDuration: number): void;
    start(): void;
    stop(): void;
    testGetValue(aPingName?: UTF8String): number | null;
}

declare var GleanTimespan: {
    prototype: GleanTimespan;
    new(): GleanTimespan;
    isInstance(obj): obj is GleanTimespan;
};

interface GleanTimingDistribution extends GleanMetric {
    cancel(aId: number): void;
    start(): number;
    stopAndAccumulate(aId: number): void;
    testAccumulateRawMillis(aSample: number): void;
    testGetValue(aPingName?: UTF8String): GleanDistributionData | null;
}

declare var GleanTimingDistribution: {
    prototype: GleanTimingDistribution;
    new(): GleanTimingDistribution;
    isInstance(obj): obj is GleanTimingDistribution;
};

interface GleanUrl extends GleanMetric {
    set(aValue: UTF8String): void;
    testGetValue(aPingName?: UTF8String): UTF8String | null;
}

declare var GleanUrl: {
    prototype: GleanUrl;
    new(): GleanUrl;
    isInstance(obj): obj is GleanUrl;
};

interface GleanUuid extends GleanMetric {
    generateAndSet(): void;
    set(aValue: UTF8String): void;
    testGetValue(aPingName?: UTF8String): UTF8String | null;
}

declare var GleanUuid: {
    prototype: GleanUuid;
    new(): GleanUuid;
    isInstance(obj): obj is GleanUuid;
};

interface GlobalCrypto {
    readonly crypto: Crypto;
}

interface GlobalEventHandlersEventMap {
    "abort": Event;
    "animationcancel": Event;
    "animationend": Event;
    "animationiteration": Event;
    "animationstart": Event;
    "auxclick": Event;
    "beforeinput": Event;
    "beforetoggle": Event;
    "blur": Event;
    "cancel": Event;
    "canplay": Event;
    "canplaythrough": Event;
    "change": Event;
    "click": Event;
    "close": Event;
    "contextmenu": Event;
    "copy": Event;
    "cuechange": Event;
    "cut": Event;
    "dblclick": Event;
    "drag": Event;
    "dragend": Event;
    "dragenter": Event;
    "dragexit": Event;
    "dragleave": Event;
    "dragover": Event;
    "dragstart": Event;
    "drop": Event;
    "durationchange": Event;
    "emptied": Event;
    "ended": Event;
    "focus": Event;
    "formdata": Event;
    "gotpointercapture": Event;
    "input": Event;
    "invalid": Event;
    "keydown": Event;
    "keypress": Event;
    "keyup": Event;
    "load": Event;
    "loadeddata": Event;
    "loadedmetadata": Event;
    "loadstart": Event;
    "lostpointercapture": Event;
    "mousedown": Event;
    "mouseenter": Event;
    "mouseleave": Event;
    "mousemove": Event;
    "mouseout": Event;
    "mouseover": Event;
    "mouseup": Event;
    "mozfullscreenchange": Event;
    "mozfullscreenerror": Event;
    "paste": Event;
    "pause": Event;
    "play": Event;
    "playing": Event;
    "pointercancel": Event;
    "pointerdown": Event;
    "pointerenter": Event;
    "pointerleave": Event;
    "pointermove": Event;
    "pointerout": Event;
    "pointerover": Event;
    "pointerup": Event;
    "progress": Event;
    "ratechange": Event;
    "reset": Event;
    "resize": Event;
    "scroll": Event;
    "scrollend": Event;
    "securitypolicyviolation": Event;
    "seeked": Event;
    "seeking": Event;
    "select": Event;
    "selectionchange": Event;
    "selectstart": Event;
    "slotchange": Event;
    "stalled": Event;
    "submit": Event;
    "suspend": Event;
    "timeupdate": Event;
    "toggle": Event;
    "transitioncancel": Event;
    "transitionend": Event;
    "transitionrun": Event;
    "transitionstart": Event;
    "volumechange": Event;
    "waiting": Event;
    "webkitanimationend": Event;
    "webkitanimationiteration": Event;
    "webkitanimationstart": Event;
    "webkittransitionend": Event;
    "wheel": Event;
}

interface GlobalEventHandlers {
    /**
     * Fires when the user aborts the download.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/abort_event)
     */
    onabort: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationcancel_event) */
    onanimationcancel: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationend_event) */
    onanimationend: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationiteration_event) */
    onanimationiteration: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationstart_event) */
    onanimationstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/auxclick_event) */
    onauxclick: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/beforeinput_event) */
    onbeforeinput: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/beforetoggle_event) */
    onbeforetoggle: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the object loses the input focus.
     * @param ev The focus event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/blur_event)
     */
    onblur: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/cancel_event) */
    oncancel: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when playback is possible, but would require further buffering.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/canplay_event)
     */
    oncanplay: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/canplaythrough_event) */
    oncanplaythrough: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the contents of the object or selection have changed.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/change_event)
     */
    onchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the user clicks the left mouse button on the object
     * @param ev The mouse event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/click_event)
     */
    onclick: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/close_event) */
    onclose: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the user clicks the right mouse button in the client area, opening the context menu.
     * @param ev The mouse event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/contextmenu_event)
     */
    oncontextmenu: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/copy_event) */
    oncopy: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/cuechange_event) */
    oncuechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/cut_event) */
    oncut: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the user double-clicks the object.
     * @param ev The mouse event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/dblclick_event)
     */
    ondblclick: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires on the source object continuously during a drag operation.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/drag_event)
     */
    ondrag: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires on the source object when the user releases the mouse at the close of a drag operation.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/dragend_event)
     */
    ondragend: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires on the target element when the user drags the object to a valid drop target.
     * @param ev The drag event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/dragenter_event)
     */
    ondragenter: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    ondragexit: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires on the target object when the user moves the mouse out of a valid drop target during a drag operation.
     * @param ev The drag event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/dragleave_event)
     */
    ondragleave: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires on the target element continuously while the user drags the object over a valid drop target.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/dragover_event)
     */
    ondragover: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires on the source object when the user starts to drag a text selection or selected object.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/dragstart_event)
     */
    ondragstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/drop_event) */
    ondrop: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when the duration attribute is updated.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/durationchange_event)
     */
    ondurationchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when the media element is reset to its initial state.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/emptied_event)
     */
    onemptied: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when the end of playback is reached.
     * @param ev The event
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/ended_event)
     */
    onended: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when an error occurs during object loading.
     * @param ev The event.
     */
    onerror: OnErrorEventHandler;
    /**
     * Fires when the object receives focus.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/focus_event)
     */
    onfocus: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/formdata_event) */
    onformdata: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/gotpointercapture_event) */
    ongotpointercapture: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/input_event) */
    oninput: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/invalid_event) */
    oninvalid: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the user presses a key.
     * @param ev The keyboard event
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/keydown_event)
     */
    onkeydown: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the user presses an alphanumeric key.
     * @param ev The event.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/keypress_event)
     */
    onkeypress: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the user releases a key.
     * @param ev The keyboard event
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/keyup_event)
     */
    onkeyup: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires immediately after the browser loads the object.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/SVGElement/load_event)
     */
    onload: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when media data is loaded at the current playback position.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/loadeddata_event)
     */
    onloadeddata: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when the duration and dimensions of the media have been determined.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/loadedmetadata_event)
     */
    onloadedmetadata: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when Internet Explorer begins looking for media data.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/loadstart_event)
     */
    onloadstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/lostpointercapture_event) */
    onlostpointercapture: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the user clicks the object with either mouse button.
     * @param ev The mouse event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mousedown_event)
     */
    onmousedown: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mouseenter_event) */
    onmouseenter: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mouseleave_event) */
    onmouseleave: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the user moves the mouse over the object.
     * @param ev The mouse event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mousemove_event)
     */
    onmousemove: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the user moves the mouse pointer outside the boundaries of the object.
     * @param ev The mouse event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mouseout_event)
     */
    onmouseout: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the user moves the mouse pointer into the object.
     * @param ev The mouse event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mouseover_event)
     */
    onmouseover: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the user releases a mouse button while the mouse is over the object.
     * @param ev The mouse event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mouseup_event)
     */
    onmouseup: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onmozfullscreenchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onmozfullscreenerror: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/paste_event) */
    onpaste: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when playback is paused.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/pause_event)
     */
    onpause: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when the play method is requested.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/play_event)
     */
    onplay: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when the audio or video has started playing.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/playing_event)
     */
    onplaying: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointercancel_event) */
    onpointercancel: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointerdown_event) */
    onpointerdown: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointerenter_event) */
    onpointerenter: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointerleave_event) */
    onpointerleave: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointermove_event) */
    onpointermove: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointerout_event) */
    onpointerout: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointerover_event) */
    onpointerover: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointerup_event) */
    onpointerup: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs to indicate progress while downloading media data.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/progress_event)
     */
    onprogress: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when the playback rate is increased or decreased.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/ratechange_event)
     */
    onratechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the user resets a form.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/reset_event)
     */
    onreset: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/resize_event) */
    onresize: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the user repositions the scroll box in the scroll bar on the object.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/scroll_event)
     */
    onscroll: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/scrollend_event) */
    onscrollend: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/securitypolicyviolation_event) */
    onsecuritypolicyviolation: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when the seek operation ends.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/seeked_event)
     */
    onseeked: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when the current playback position is moved.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/seeking_event)
     */
    onseeking: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Fires when the current selection changes.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/select_event)
     */
    onselect: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/selectionchange_event) */
    onselectionchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/selectstart_event) */
    onselectstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSlotElement/slotchange_event) */
    onslotchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when the download has stopped.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/stalled_event)
     */
    onstalled: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/submit_event) */
    onsubmit: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs if the load operation has been intentionally halted.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/suspend_event)
     */
    onsuspend: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs to indicate the current playback position.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/timeupdate_event)
     */
    ontimeupdate: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDetailsElement/toggle_event) */
    ontoggle: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/transitioncancel_event) */
    ontransitioncancel: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/transitionend_event) */
    ontransitionend: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/transitionrun_event) */
    ontransitionrun: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/transitionstart_event) */
    ontransitionstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when the volume is changed, or playback is muted or unmuted.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/volumechange_event)
     */
    onvolumechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * Occurs when playback stops because the next frame of a video resource is not available.
     * @param ev The event.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/waiting_event)
     */
    onwaiting: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * @deprecated This is a legacy alias of `onanimationend`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationend_event)
     */
    onwebkitanimationend: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * @deprecated This is a legacy alias of `onanimationiteration`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationiteration_event)
     */
    onwebkitanimationiteration: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * @deprecated This is a legacy alias of `onanimationstart`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationstart_event)
     */
    onwebkitanimationstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /**
     * @deprecated This is a legacy alias of `ontransitionend`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/transitionend_event)
     */
    onwebkittransitionend: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/wheel_event) */
    onwheel: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    addEventListener<K extends keyof GlobalEventHandlersEventMap>(type: K, listener: (this: GlobalEventHandlers, ev: GlobalEventHandlersEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof GlobalEventHandlersEventMap>(type: K, listener: (this: GlobalEventHandlers, ev: GlobalEventHandlersEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

interface GlobalPrivacyControl {
    readonly globalPrivacyControl: boolean;
}

interface GlobalProcessScriptLoader {
    readonly initialProcessData: any;
    readonly sharedData: MozWritableSharedMap;
}

interface Grid {
    readonly areas: GridArea[];
    readonly cols: GridDimension;
    readonly rows: GridDimension;
}

declare var Grid: {
    prototype: Grid;
    new(): Grid;
    isInstance(obj): obj is Grid;
};

interface GridArea {
    readonly columnEnd: number;
    readonly columnStart: number;
    readonly name: string;
    readonly rowEnd: number;
    readonly rowStart: number;
    readonly type: GridDeclaration;
}

declare var GridArea: {
    prototype: GridArea;
    new(): GridArea;
    isInstance(obj): obj is GridArea;
};

interface GridDimension {
    readonly lines: GridLines;
    readonly tracks: GridTracks;
}

declare var GridDimension: {
    prototype: GridDimension;
    new(): GridDimension;
    isInstance(obj): obj is GridDimension;
};

interface GridLine {
    readonly breadth: number;
    readonly names: string[];
    readonly negativeNumber: number;
    readonly number: number;
    readonly start: number;
    readonly type: GridDeclaration;
}

declare var GridLine: {
    prototype: GridLine;
    new(): GridLine;
    isInstance(obj): obj is GridLine;
};

interface GridLines {
    readonly length: number;
    item(index: number): GridLine | null;
    [index: number]: GridLine;
}

declare var GridLines: {
    prototype: GridLines;
    new(): GridLines;
    isInstance(obj): obj is GridLines;
};

interface GridTrack {
    readonly breadth: number;
    readonly start: number;
    readonly state: GridTrackState;
    readonly type: GridDeclaration;
}

declare var GridTrack: {
    prototype: GridTrack;
    new(): GridTrack;
    isInstance(obj): obj is GridTrack;
};

interface GridTracks {
    readonly length: number;
    item(index: number): GridTrack | null;
    [index: number]: GridTrack;
}

declare var GridTracks: {
    prototype: GridTracks;
    new(): GridTracks;
    isInstance(obj): obj is GridTracks;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAllCollection) */
interface HTMLAllCollection {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAllCollection/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAllCollection/item) */
    item(nameOrIndex?: string): HTMLCollection | Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAllCollection/namedItem) */
    namedItem(name: string): HTMLCollection | Element | null;
    [index: number]: Element;
}

declare var HTMLAllCollection: {
    prototype: HTMLAllCollection;
    new(): HTMLAllCollection;
    isInstance(obj): obj is HTMLAllCollection;
};

/**
 * Hyperlink elements and provides special properties and methods (beyond those of the regular HTMLElement object interface that they inherit from) for manipulating the layout and presentation of such elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement)
 */
interface HTMLAnchorElement extends HTMLElement, HTMLHyperlinkElementUtils {
    /**
     * Sets or retrieves the character set used to encode the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/charset)
     */
    charset: string;
    /**
     * Sets or retrieves the coordinates of the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/coords)
     */
    coords: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/download) */
    download: string;
    /**
     * Sets or retrieves the language code of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/hreflang)
     */
    hreflang: string;
    /**
     * Sets or retrieves the shape of the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/name)
     */
    name: string;
    ping: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/referrerPolicy) */
    referrerPolicy: string;
    /**
     * Sets or retrieves the relationship between the object and the destination of the link.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/rel)
     */
    rel: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/relList) */
    readonly relList: DOMTokenList;
    /**
     * Sets or retrieves the relationship between the object and the destination of the link.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/rev)
     */
    rev: string;
    /**
     * Sets or retrieves the shape of the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/shape)
     */
    shape: string;
    /**
     * Sets or retrieves the window or frame at which to target content.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/target)
     */
    target: string;
    /**
     * Retrieves or sets the text of the object as a string.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/text)
     */
    text: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/type) */
    type: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAnchorElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAnchorElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLAnchorElement: {
    prototype: HTMLAnchorElement;
    new(): HTMLAnchorElement;
    isInstance(obj): obj is HTMLAnchorElement;
};

/**
 * Provides special properties and methods (beyond those of the regular object HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of <area> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement)
 */
interface HTMLAreaElement extends HTMLElement, HTMLHyperlinkElementUtils {
    /**
     * Sets or retrieves a text alternative to the graphic.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/alt)
     */
    alt: string;
    /**
     * Sets or retrieves the coordinates of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/coords)
     */
    coords: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/download) */
    download: string;
    /**
     * Sets or gets whether clicks in this region cause action.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/noHref)
     */
    noHref: boolean;
    ping: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/referrerPolicy) */
    referrerPolicy: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/rel) */
    rel: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/relList) */
    readonly relList: DOMTokenList;
    /**
     * Sets or retrieves the shape of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/shape)
     */
    shape: string;
    /**
     * Sets or retrieves the window or frame at which to target content.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/target)
     */
    target: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLAreaElement: {
    prototype: HTMLAreaElement;
    new(): HTMLAreaElement;
    isInstance(obj): obj is HTMLAreaElement;
};

/**
 * Provides access to the properties of <audio> elements, as well as methods to manipulate them. It derives from the HTMLMediaElement interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAudioElement)
 */
interface HTMLAudioElement extends HTMLMediaElement {
    addEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLAudioElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLAudioElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLAudioElement: {
    prototype: HTMLAudioElement;
    new(): HTMLAudioElement;
    isInstance(obj): obj is HTMLAudioElement;
};

/**
 * A HTML line break element (<br>). It inherits from HTMLElement.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBRElement)
 */
interface HTMLBRElement extends HTMLElement {
    /**
     * Sets or retrieves the side on which floating objects are not to be positioned when any IHTMLBlockElement is inserted into the document.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBRElement/clear)
     */
    clear: string;
    readonly isPaddingForEmptyEditor: boolean;
    readonly isPaddingForEmptyLastLine: boolean;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLBRElement: {
    prototype: HTMLBRElement;
    new(): HTMLBRElement;
    isInstance(obj): obj is HTMLBRElement;
};

/**
 * Contains the base URI for a document. This object inherits all of the properties and methods as described in the HTMLElement interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBaseElement)
 */
interface HTMLBaseElement extends HTMLElement {
    /**
     * Gets or sets the baseline URL on which relative links are based.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBaseElement/href)
     */
    href: string;
    /**
     * Sets or retrieves the window or frame at which to target content.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBaseElement/target)
     */
    target: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBaseElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBaseElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLBaseElement: {
    prototype: HTMLBaseElement;
    new(): HTMLBaseElement;
    isInstance(obj): obj is HTMLBaseElement;
};

interface HTMLBodyElementEventMap extends HTMLElementEventMap, WindowEventHandlersEventMap {
}

/**
 * Provides special properties (beyond those inherited from the regular HTMLElement interface) for manipulating <body> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBodyElement)
 */
interface HTMLBodyElement extends HTMLElement, WindowEventHandlers {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBodyElement/aLink)
     */
    aLink: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBodyElement/background)
     */
    background: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBodyElement/bgColor)
     */
    bgColor: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBodyElement/link)
     */
    link: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBodyElement/text)
     */
    text: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBodyElement/vLink)
     */
    vLink: string;
    addEventListener<K extends keyof HTMLBodyElementEventMap>(type: K, listener: (this: HTMLBodyElement, ev: HTMLBodyElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLBodyElementEventMap>(type: K, listener: (this: HTMLBodyElement, ev: HTMLBodyElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLBodyElement: {
    prototype: HTMLBodyElement;
    new(): HTMLBodyElement;
    isInstance(obj): obj is HTMLBodyElement;
};

/**
 * Provides properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <button> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement)
 */
interface HTMLButtonElement extends HTMLElement, InvokerElement, PopoverInvokerElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/disabled) */
    disabled: boolean;
    /**
     * Retrieves a reference to the form that the object is embedded in.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/form)
     */
    readonly form: HTMLFormElement | null;
    /**
     * Overrides the action attribute (where the data on a form is sent) on the parent form element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/formAction)
     */
    formAction: string;
    /**
     * Used to override the encoding (formEnctype attribute) specified on the form element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/formEnctype)
     */
    formEnctype: string;
    /**
     * Overrides the submit method attribute previously specified on a form element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/formMethod)
     */
    formMethod: string;
    /**
     * Overrides any validation or required attributes on a form or form elements to allow it to be submitted without validation. This can be used to create a "save draft"-type submit option.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/formNoValidate)
     */
    formNoValidate: boolean;
    /**
     * Overrides the target attribute on a form element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/formTarget)
     */
    formTarget: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/labels) */
    readonly labels: NodeList;
    /**
     * Sets or retrieves the name of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/name)
     */
    name: string;
    /**
     * Gets the classification and default behavior of the button.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/type)
     */
    type: string;
    /**
     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as "this is a required field". The result is that the user sees validation messages without actually submitting.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/validationMessage)
     */
    readonly validationMessage: string;
    /**
     * Returns a  ValidityState object that represents the validity states of an element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/validity)
     */
    readonly validity: ValidityState;
    /**
     * Sets or retrieves the default or selected value of the control.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/value)
     */
    value: string;
    /**
     * Returns whether an element will successfully validate based on forms validation rules and constraints.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/willValidate)
     */
    readonly willValidate: boolean;
    /** Returns whether a form will validate when it is submitted, without having to submit it. */
    checkValidity(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/reportValidity) */
    reportValidity(): boolean;
    /**
     * Sets a custom error message that is displayed when a form is submitted.
     * @param error Sets a custom error message that is displayed when a form is submitted.
     */
    setCustomValidity(error: string): void;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLButtonElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLButtonElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLButtonElement: {
    prototype: HTMLButtonElement;
    new(): HTMLButtonElement;
    isInstance(obj): obj is HTMLButtonElement;
};

/**
 * Provides properties and methods for manipulating the layout and presentation of <canvas> elements. The HTMLCanvasElement interface also inherits the properties and methods of the HTMLElement interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement)
 */
interface HTMLCanvasElement extends HTMLElement {
    /**
     * Gets or sets the height of a canvas element on a document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/height)
     */
    height: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/mozOpaque)
     */
    mozOpaque: boolean;
    mozPrintCallback: PrintCallback | null;
    /**
     * Gets or sets the width of a canvas element on a document.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/width)
     */
    width: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/captureStream) */
    captureStream(frameRate?: number): CanvasCaptureMediaStream;
    /**
     * Returns an object that provides methods and properties for drawing and manipulating images and graphics on a canvas element in a document. A context object includes information about colors, line widths, fonts, and other graphic parameters that can be drawn on a canvas.
     * @param contextId The identifier (ID) of the type of canvas to create. Internet Explorer 9 and Internet Explorer 10 support only a 2-D context using canvas.getContext("2d"); IE11 Preview also supports 3-D or WebGL context using canvas.getContext("experimental-webgl");
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/getContext)
     */
    getContext(contextId: string, contextOptions?: any): nsISupports | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/toBlob) */
    toBlob(callback: BlobCallback, type?: string, encoderOptions?: any): void;
    /**
     * Returns the content of the current canvas as an image that you can use as a source for another canvas or an HTML element.
     * @param type The standard MIME type for the image format to return. If you do not specify this parameter, the default value is a PNG format image.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/toDataURL)
     */
    toDataURL(type?: string, encoderOptions?: any): string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/transferControlToOffscreen) */
    transferControlToOffscreen(): OffscreenCanvas;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLCanvasElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLCanvasElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLCanvasElement: {
    prototype: HTMLCanvasElement;
    new(): HTMLCanvasElement;
    isInstance(obj): obj is HTMLCanvasElement;
};

/**
 * A generic collection (array-like object similar to arguments) of elements (in document order) and offers methods and properties for selecting from the list.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCollection)
 */
interface HTMLCollectionBase {
    /**
     * Sets or retrieves the number of objects in a collection.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCollection/length)
     */
    readonly length: number;
    /**
     * Retrieves an object from various collections.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCollection/item)
     */
    item(index: number): Element | null;
    [index: number]: Element;
}

interface HTMLCollection extends HTMLCollectionBase {
    /**
     * Retrieves a select object or an object from an options collection.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCollection/namedItem)
     */
    namedItem(name: string): Element | null;
}

declare var HTMLCollection: {
    prototype: HTMLCollection;
    new(): HTMLCollection;
    isInstance(obj): obj is HTMLCollection;
};

/**
 * Provides special properties (beyond those of the regular HTMLElement interface it also has available to it by inheritance) for manipulating definition list (<dl>) elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDListElement)
 */
interface HTMLDListElement extends HTMLElement {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDListElement/compact)
     */
    compact: boolean;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLDListElement: {
    prototype: HTMLDListElement;
    new(): HTMLDListElement;
    isInstance(obj): obj is HTMLDListElement;
};

/**
 * Provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <data> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDataElement)
 */
interface HTMLDataElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDataElement/value) */
    value: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLDataElement: {
    prototype: HTMLDataElement;
    new(): HTMLDataElement;
    isInstance(obj): obj is HTMLDataElement;
};

/**
 * Provides special properties (beyond the HTMLElement object interface it also has available to it by inheritance) to manipulate <datalist> elements and their content.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDataListElement)
 */
interface HTMLDataListElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDataListElement/options) */
    readonly options: HTMLCollection;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLDataListElement: {
    prototype: HTMLDataListElement;
    new(): HTMLDataListElement;
    isInstance(obj): obj is HTMLDataListElement;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDetailsElement) */
interface HTMLDetailsElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDetailsElement/open) */
    open: boolean;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDetailsElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDetailsElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLDetailsElement: {
    prototype: HTMLDetailsElement;
    new(): HTMLDetailsElement;
    isInstance(obj): obj is HTMLDetailsElement;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement) */
interface HTMLDialogElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/open) */
    open: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/returnValue) */
    returnValue: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/close) */
    close(returnValue?: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/show) */
    show(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/showModal) */
    showModal(): void;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDialogElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDialogElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLDialogElement: {
    prototype: HTMLDialogElement;
    new(): HTMLDialogElement;
    isInstance(obj): obj is HTMLDialogElement;
};

/** @deprecated */
interface HTMLDirectoryElement extends HTMLElement {
    /** @deprecated */
    compact: boolean;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDirectoryElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDirectoryElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

/** @deprecated */
declare var HTMLDirectoryElement: {
    prototype: HTMLDirectoryElement;
    new(): HTMLDirectoryElement;
    isInstance(obj): obj is HTMLDirectoryElement;
};

/**
 * Provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <div> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDivElement)
 */
interface HTMLDivElement extends HTMLElement {
    /**
     * Sets or retrieves how the object is aligned with adjacent text.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDivElement/align)
     */
    align: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDivElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDivElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLDivElement: {
    prototype: HTMLDivElement;
    new(): HTMLDivElement;
    isInstance(obj): obj is HTMLDivElement;
};

/**
 * The HTMLDocument property of Window objects is an alias that browsers expose for the Document interface object.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDocument)
 */
interface HTMLDocument extends Document {
    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: HTMLDocument, ev: DocumentEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: HTMLDocument, ev: DocumentEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
    [name: string]: any;
}

declare var HTMLDocument: {
    prototype: HTMLDocument;
    new(): HTMLDocument;
    isInstance(obj): obj is HTMLDocument;
};

interface HTMLElementEventMap extends ElementEventMap, GlobalEventHandlersEventMap, OnErrorEventHandlerForNodesEventMap, TouchEventHandlersEventMap {
}

/**
 * Any HTML element. Some elements directly implement this interface, while others implement it via an interface that inherits it.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement)
 */
interface HTMLElement extends Element, ElementCSSInlineStyle, GlobalEventHandlers, HTMLOrForeignElement, OnErrorEventHandlerForNodes, TouchEventHandlers {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/accessKey) */
    accessKey: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/accessKeyLabel) */
    readonly accessKeyLabel: string;
    autocapitalize: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/contentEditable) */
    contentEditable: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/dir) */
    dir: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/draggable) */
    draggable: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/enterKeyHint) */
    enterKeyHint: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/hidden) */
    hidden: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/inert) */
    inert: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/innerText) */
    innerText: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/inputMode) */
    inputMode: string;
    readonly internals: ElementInternals | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/isContentEditable) */
    readonly isContentEditable: boolean;
    readonly isFormAssociatedCustomElements: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/lang) */
    lang: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/nonce) */
    nonce: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/offsetHeight) */
    readonly offsetHeight: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/offsetLeft) */
    readonly offsetLeft: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/offsetParent) */
    readonly offsetParent: Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/offsetTop) */
    readonly offsetTop: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/offsetWidth) */
    readonly offsetWidth: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/outerText) */
    outerText: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/popover) */
    popover: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/spellcheck) */
    spellcheck: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/title) */
    title: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/translate) */
    translate: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/attachInternals) */
    attachInternals(): ElementInternals;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/click) */
    click(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/hidePopover) */
    hidePopover(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/showPopover) */
    showPopover(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/togglePopover) */
    togglePopover(force?: boolean): boolean;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLElement: {
    prototype: HTMLElement;
    new(): HTMLElement;
    isInstance(obj): obj is HTMLElement;
};

/**
 * Provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <embed> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLEmbedElement)
 */
interface HTMLEmbedElement extends HTMLElement, MozFrameLoaderOwner, MozImageLoadingContent, MozObjectLoadingContent {
    /** @deprecated */
    align: string;
    /** Sets or retrieves the height of the object. */
    height: string;
    /**
     * Sets or retrieves the name of the object.
     * @deprecated
     */
    name: string;
    /** Sets or retrieves a URL to be loaded by the object. */
    src: string;
    type: string;
    /** Sets or retrieves the width of the object. */
    width: string;
    getSVGDocument(): Document | null;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLEmbedElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLEmbedElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLEmbedElement: {
    prototype: HTMLEmbedElement;
    new(): HTMLEmbedElement;
    readonly UNKNOWN_REQUEST: -1;
    readonly CURRENT_REQUEST: 0;
    readonly PENDING_REQUEST: 1;
    readonly TYPE_LOADING: 0;
    readonly TYPE_IMAGE: 1;
    readonly TYPE_FALLBACK: 2;
    readonly TYPE_FAKE_PLUGIN: 3;
    readonly TYPE_DOCUMENT: 4;
    readonly TYPE_NULL: 5;
    isInstance(obj): obj is HTMLEmbedElement;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFencedFrameElement) */
interface HTMLFencedFrameElement {
}

declare var HTMLFencedFrameElement: {
    prototype: HTMLFencedFrameElement;
    new(): HTMLFencedFrameElement;
    isInstance(obj): obj is HTMLFencedFrameElement;
};

/**
 * Provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of <fieldset> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement)
 */
interface HTMLFieldSetElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/disabled) */
    disabled: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/elements) */
    readonly elements: HTMLCollection;
    /**
     * Retrieves a reference to the form that the object is embedded in.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/form)
     */
    readonly form: HTMLFormElement | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/name) */
    name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/type) */
    readonly type: string;
    /**
     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as "this is a required field". The result is that the user sees validation messages without actually submitting.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/validationMessage)
     */
    readonly validationMessage: string;
    /**
     * Returns a  ValidityState object that represents the validity states of an element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/validity)
     */
    readonly validity: ValidityState;
    /**
     * Returns whether an element will successfully validate based on forms validation rules and constraints.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/willValidate)
     */
    readonly willValidate: boolean;
    /** Returns whether a form will validate when it is submitted, without having to submit it. */
    checkValidity(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/reportValidity) */
    reportValidity(): boolean;
    /**
     * Sets a custom error message that is displayed when a form is submitted.
     * @param error Sets a custom error message that is displayed when a form is submitted.
     */
    setCustomValidity(error: string): void;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFieldSetElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFieldSetElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLFieldSetElement: {
    prototype: HTMLFieldSetElement;
    new(): HTMLFieldSetElement;
    isInstance(obj): obj is HTMLFieldSetElement;
};

/**
 * Implements the document object model (DOM) representation of the font element. The HTML Font Element <font> defines the font size, font face and color of text.
 * @deprecated
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFontElement)
 */
interface HTMLFontElement extends HTMLElement {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFontElement/color)
     */
    color: string;
    /**
     * Sets or retrieves the current typeface family.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFontElement/face)
     */
    face: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFontElement/size)
     */
    size: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFontElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFontElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

/** @deprecated */
declare var HTMLFontElement: {
    prototype: HTMLFontElement;
    new(): HTMLFontElement;
    isInstance(obj): obj is HTMLFontElement;
};

/**
 * A collection of HTML form control elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormControlsCollection)
 */
interface HTMLFormControlsCollection extends HTMLCollectionBase {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormControlsCollection/namedItem) */
    namedItem(name: string): RadioNodeList | Element | null;
}

declare var HTMLFormControlsCollection: {
    prototype: HTMLFormControlsCollection;
    new(): HTMLFormControlsCollection;
    isInstance(obj): obj is HTMLFormControlsCollection;
};

/**
 * A <form> element in the DOM; it allows access to and in some cases modification of aspects of the form, as well as access to its component elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement)
 */
interface HTMLFormElement extends HTMLElement {
    /**
     * Sets or retrieves a list of character encodings for input data that must be accepted by the server processing the form.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/acceptCharset)
     */
    acceptCharset: string;
    /**
     * Sets or retrieves the URL to which the form content is sent for processing.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/action)
     */
    action: string;
    /**
     * Specifies whether autocomplete is applied to an editable text field.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/autocomplete)
     */
    autocomplete: string;
    /**
     * Retrieves a collection, in source order, of all controls in a given form.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/elements)
     */
    readonly elements: HTMLFormControlsCollection;
    /**
     * Sets or retrieves the MIME encoding for the form.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/encoding)
     */
    encoding: string;
    /**
     * Sets or retrieves the encoding type for the form.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/enctype)
     */
    enctype: string;
    /**
     * Sets or retrieves the number of objects in a collection.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/length)
     */
    readonly length: number;
    /**
     * Sets or retrieves how to send the form data to the server.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/method)
     */
    method: string;
    /**
     * Sets or retrieves the name of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/name)
     */
    name: string;
    /**
     * Designates a form that is not validated when submitted.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/noValidate)
     */
    noValidate: boolean;
    rel: string;
    readonly relList: DOMTokenList;
    /**
     * Sets or retrieves the window or frame at which to target content.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/target)
     */
    target: string;
    /**
     * Returns whether a form will validate when it is submitted, without having to submit it.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/checkValidity)
     */
    checkValidity(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/reportValidity) */
    reportValidity(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/requestSubmit) */
    requestSubmit(submitter?: HTMLElement | null): void;
    /**
     * Fires when the user resets a form.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/reset)
     */
    reset(): void;
    /**
     * Fires when a FORM is about to be submitted.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/submit)
     */
    submit(): void;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFormElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFormElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
    [index: number]: Element;
}

declare var HTMLFormElement: {
    prototype: HTMLFormElement;
    new(): HTMLFormElement;
    isInstance(obj): obj is HTMLFormElement;
};

/**
 * @deprecated
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFrameElement)
 */
interface HTMLFrameElement extends HTMLElement, MozFrameLoaderOwner {
    /**
     * Retrieves the document object of the page or frame.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFrameElement/contentDocument)
     */
    readonly contentDocument: Document | null;
    /**
     * Retrieves the object of the specified.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFrameElement/contentWindow)
     */
    readonly contentWindow: WindowProxy | null;
    /**
     * Sets or retrieves whether to display a border for the frame.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFrameElement/frameBorder)
     */
    frameBorder: string;
    /**
     * Sets or retrieves a URI to a long description of the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFrameElement/longDesc)
     */
    longDesc: string;
    /**
     * Sets or retrieves the top and bottom margin heights before displaying the text in a frame.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFrameElement/marginHeight)
     */
    marginHeight: string;
    /**
     * Sets or retrieves the left and right margin widths before displaying the text in a frame.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFrameElement/marginWidth)
     */
    marginWidth: string;
    /**
     * Sets or retrieves the frame name.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFrameElement/name)
     */
    name: string;
    /**
     * Sets or retrieves whether the user can resize the frame.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFrameElement/noResize)
     */
    noResize: boolean;
    /**
     * Sets or retrieves whether the frame can be scrolled.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFrameElement/scrolling)
     */
    scrolling: string;
    /**
     * Sets or retrieves a URL to be loaded by the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFrameElement/src)
     */
    src: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

/** @deprecated */
declare var HTMLFrameElement: {
    prototype: HTMLFrameElement;
    new(): HTMLFrameElement;
    isInstance(obj): obj is HTMLFrameElement;
};

interface HTMLFrameSetElementEventMap extends HTMLElementEventMap, WindowEventHandlersEventMap {
}

/**
 * Provides special properties (beyond those of the regular HTMLElement interface they also inherit) for manipulating <frameset> elements.
 * @deprecated
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFrameSetElement)
 */
interface HTMLFrameSetElement extends HTMLElement, WindowEventHandlers {
    /**
     * Sets or retrieves the frame widths of the object.
     * @deprecated
     */
    cols: string;
    /**
     * Sets or retrieves the frame heights of the object.
     * @deprecated
     */
    rows: string;
    addEventListener<K extends keyof HTMLFrameSetElementEventMap>(type: K, listener: (this: HTMLFrameSetElement, ev: HTMLFrameSetElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLFrameSetElementEventMap>(type: K, listener: (this: HTMLFrameSetElement, ev: HTMLFrameSetElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

/** @deprecated */
declare var HTMLFrameSetElement: {
    prototype: HTMLFrameSetElement;
    new(): HTMLFrameSetElement;
    isInstance(obj): obj is HTMLFrameSetElement;
};

/**
 * Provides special properties (beyond those of the HTMLElement interface it also has available to it by inheritance) for manipulating <hr> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLHRElement)
 */
interface HTMLHRElement extends HTMLElement {
    /**
     * Sets or retrieves how the object is aligned with adjacent text.
     * @deprecated
     */
    align: string;
    /** @deprecated */
    color: string;
    /**
     * Sets or retrieves whether the horizontal rule is drawn with 3-D shading.
     * @deprecated
     */
    noShade: boolean;
    /** @deprecated */
    size: string;
    /**
     * Sets or retrieves the width of the object.
     * @deprecated
     */
    width: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLHRElement: {
    prototype: HTMLHRElement;
    new(): HTMLHRElement;
    isInstance(obj): obj is HTMLHRElement;
};

/**
 * Contains the descriptive information, or metadata, for a document. This object inherits all of the properties and methods described in the HTMLElement interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLHeadElement)
 */
interface HTMLHeadElement extends HTMLElement {
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLHeadElement: {
    prototype: HTMLHeadElement;
    new(): HTMLHeadElement;
    isInstance(obj): obj is HTMLHeadElement;
};

/**
 * The different heading elements. It inherits methods and properties from the HTMLElement interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLHeadingElement)
 */
interface HTMLHeadingElement extends HTMLElement {
    /**
     * Sets or retrieves a value that indicates the table alignment.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLHeadingElement/align)
     */
    align: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadingElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadingElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLHeadingElement: {
    prototype: HTMLHeadingElement;
    new(): HTMLHeadingElement;
    isInstance(obj): obj is HTMLHeadingElement;
};

/**
 * Serves as the root node for a given HTML document. This object inherits the properties and methods described in the HTMLElement interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLHtmlElement)
 */
interface HTMLHtmlElement extends HTMLElement {
    /**
     * Sets or retrieves the DTD version that governs the current document.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLHtmlElement/version)
     */
    version: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHtmlElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHtmlElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLHtmlElement: {
    prototype: HTMLHtmlElement;
    new(): HTMLHtmlElement;
    isInstance(obj): obj is HTMLHtmlElement;
};

interface HTMLHyperlinkElementUtils {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/hash) */
    hash: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/host) */
    host: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/hostname) */
    hostname: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/href) */
    href: string;
    toString(): string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/origin) */
    readonly origin: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/password) */
    password: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/pathname) */
    pathname: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/port) */
    port: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/protocol) */
    protocol: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/search) */
    search: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/username) */
    username: string;
}

/**
 * Provides special properties and methods (beyond those of the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of inline frame elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement)
 */
interface HTMLIFrameElement extends HTMLElement, MozFrameLoaderOwner {
    /**
     * Sets or retrieves how the object is aligned with adjacent text.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/align)
     */
    align: string;
    allow: string;
    allowFullscreen: boolean;
    /**
     * Retrieves the document object of the page or frame.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/contentDocument)
     */
    readonly contentDocument: Document | null;
    /**
     * Retrieves the object of the specified.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/contentWindow)
     */
    readonly contentWindow: WindowProxy | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/featurePolicy) */
    readonly featurePolicy: FeaturePolicy;
    /**
     * Sets or retrieves whether to display a border for the frame.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/frameBorder)
     */
    frameBorder: string;
    /**
     * Sets or retrieves the height of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/height)
     */
    height: string;
    loading: string;
    /**
     * Sets or retrieves a URI to a long description of the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/longDesc)
     */
    longDesc: string;
    /**
     * Sets or retrieves the top and bottom margin heights before displaying the text in a frame.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/marginHeight)
     */
    marginHeight: string;
    /**
     * Sets or retrieves the left and right margin widths before displaying the text in a frame.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/marginWidth)
     */
    marginWidth: string;
    /**
     * Sets or retrieves the frame name.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/name)
     */
    name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/referrerPolicy) */
    referrerPolicy: string;
    readonly sandbox: DOMTokenList;
    /**
     * Sets or retrieves whether the frame can be scrolled.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/scrolling)
     */
    scrolling: string;
    /**
     * Sets or retrieves a URL to be loaded by the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/src)
     */
    src: string;
    /**
     * Sets or retrives the content of the page that is to contain.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/srcdoc)
     */
    srcdoc: string;
    /**
     * Sets or retrieves the width of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/width)
     */
    width: string;
    getSVGDocument(): Document | null;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLIFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLIFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLIFrameElement: {
    prototype: HTMLIFrameElement;
    new(): HTMLIFrameElement;
    isInstance(obj): obj is HTMLIFrameElement;
};

/**
 * Provides special properties and methods for manipulating <img> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement)
 */
interface HTMLImageElement extends HTMLElement, MozImageLoadingContent {
    /**
     * Sets or retrieves how the object is aligned with adjacent text.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/align)
     */
    align: string;
    /**
     * Sets or retrieves a text alternative to the graphic.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/alt)
     */
    alt: string;
    /**
     * Specifies the properties of a border drawn around an object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/border)
     */
    border: string;
    /**
     * Retrieves whether the object is fully loaded.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/complete)
     */
    readonly complete: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/crossOrigin) */
    crossOrigin: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/currentSrc) */
    readonly currentSrc: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/decoding) */
    decoding: string;
    /**
     * Sets or retrieves the height of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/height)
     */
    height: number;
    /**
     * Sets or retrieves the width of the border to draw around the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/hspace)
     */
    hspace: number;
    /**
     * Sets or retrieves whether the image is a server-side image map.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/isMap)
     */
    isMap: boolean;
    /**
     * Sets or retrieves the policy for loading image elements that are outside the viewport.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/loading)
     */
    loading: string;
    /**
     * Sets or retrieves a Uniform Resource Identifier (URI) to a long description of the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/longDesc)
     */
    longDesc: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/lowsrc)
     */
    lowsrc: string;
    /**
     * Sets or retrieves the name of the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/name)
     */
    name: string;
    /**
     * The original height of the image resource before sizing.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/naturalHeight)
     */
    readonly naturalHeight: number;
    /**
     * The original width of the image resource before sizing.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/naturalWidth)
     */
    readonly naturalWidth: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/referrerPolicy) */
    referrerPolicy: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/sizes) */
    sizes: string;
    /**
     * The address or URL of the a media resource that is to be considered.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/src)
     */
    src: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/srcset) */
    srcset: string;
    /**
     * Sets or retrieves the URL, often with a bookmark extension (#name), to use as a client-side image map.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/useMap)
     */
    useMap: string;
    /**
     * Sets or retrieves the vertical margin for the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/vspace)
     */
    vspace: number;
    /**
     * Sets or retrieves the width of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/width)
     */
    width: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/x) */
    readonly x: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/y) */
    readonly y: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/decode) */
    decode(): Promise<void>;
    recognizeCurrentImageText(): Promise<ImageText[]>;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLImageElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLImageElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLImageElement: {
    prototype: HTMLImageElement;
    new(): HTMLImageElement;
    readonly UNKNOWN_REQUEST: -1;
    readonly CURRENT_REQUEST: 0;
    readonly PENDING_REQUEST: 1;
    isInstance(obj): obj is HTMLImageElement;
};

/**
 * Provides special properties and methods for manipulating the options, layout, and presentation of <input> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement)
 */
interface HTMLInputElement extends HTMLElement, InvokerElement, MozEditableElement, MozImageLoadingContent, PopoverInvokerElement {
    /** Sets or retrieves a comma-separated list of content types. */
    accept: string;
    /**
     * Sets or retrieves how the object is aligned with adjacent text.
     * @deprecated
     */
    align: string;
    /** Sets or retrieves a text alternative to the graphic. */
    alt: string;
    /**
     * Specifies whether autocomplete is applied to an editable text field.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/autocomplete)
     */
    autocomplete: string;
    capture: string;
    /** Sets or retrieves the state of the check box or radio button. */
    checked: boolean;
    readonly controllers: XULControllers | null;
    readonly dateTimeBoxElement: Element | null;
    /** Sets or retrieves the state of the check box or radio button. */
    defaultChecked: boolean;
    /** Sets or retrieves the initial contents of the object. */
    defaultValue: string;
    dirName: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/disabled) */
    disabled: boolean;
    /**
     * Returns a FileList object on a file type input object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/files)
     */
    files: FileList | null;
    /** Retrieves a reference to the form that the object is embedded in. */
    readonly form: HTMLFormElement | null;
    /**
     * Overrides the action attribute (where the data on a form is sent) on the parent form element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/formAction)
     */
    formAction: string;
    /**
     * Used to override the encoding (formEnctype attribute) specified on the form element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/formEnctype)
     */
    formEnctype: string;
    /**
     * Overrides the submit method attribute previously specified on a form element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/formMethod)
     */
    formMethod: string;
    /**
     * Overrides any validation or required attributes on a form or form elements to allow it to be submitted without validation. This can be used to create a "save draft"-type submit option.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/formNoValidate)
     */
    formNoValidate: boolean;
    /**
     * Overrides the target attribute on a form element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/formTarget)
     */
    formTarget: string;
    readonly hasBeenTypePassword: boolean;
    /**
     * Sets or retrieves the height of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/height)
     */
    height: number;
    indeterminate: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/labels) */
    readonly labels: NodeList | null;
    readonly lastInteractiveValue: string;
    /**
     * Specifies the ID of a pre-defined datalist of options for an input element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/list)
     */
    readonly list: HTMLDataListElement | null;
    /** Defines the maximum acceptable value for an input element with type="number".When used with the min and step attributes, lets you control the range and increment (such as only even numbers) that the user can enter into an input field. */
    max: string;
    /** Sets or retrieves the maximum number of characters that the user can enter in a text control. */
    maxLength: number;
    /** Defines the minimum acceptable value for an input element with type="number". When used with the max and step attributes, lets you control the range and increment (such as even numbers only) that the user can enter into an input field. */
    min: string;
    minLength: number;
    /**
     * Sets or retrieves the Boolean value indicating whether multiple items can be selected from a list.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/multiple)
     */
    multiple: boolean;
    /** Sets or retrieves the name of the object. */
    name: string;
    /**
     * Gets or sets a string containing a regular expression that the user's input must match.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/pattern)
     */
    pattern: string;
    /**
     * Gets or sets a text string that is displayed in an input field as a hint or prompt to users as the format or type of information they need to enter.The text appears in an input field until the user puts focus on the field.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/placeholder)
     */
    placeholder: string;
    previewValue: string;
    readOnly: boolean;
    /**
     * When present, marks an element that can't be submitted without a value.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/required)
     */
    required: boolean;
    revealPassword: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/selectionDirection) */
    selectionDirection: string | null;
    /** Gets or sets the end position or offset of a text selection. */
    selectionEnd: number | null;
    /** Gets or sets the starting position or offset of a text selection. */
    selectionStart: number | null;
    size: number;
    /** The address or URL of the a media resource that is to be considered. */
    src: string;
    /** Defines an increment or jump between values that you want to allow the user to enter. When used with the max and min attributes, lets you control the range and increment (for example, allow only even numbers) that the user can enter into an input field. */
    step: string;
    readonly textLength: number;
    /** Returns the content type of the object. */
    type: string;
    /**
     * Sets or retrieves the URL, often with a bookmark extension (#name), to use as a client-side image map.
     * @deprecated
     */
    useMap: string;
    /**
     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as "this is a required field". The result is that the user sees validation messages without actually submitting.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/validationMessage)
     */
    readonly validationMessage: string;
    /**
     * Returns a  ValidityState object that represents the validity states of an element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/validity)
     */
    readonly validity: ValidityState;
    /** Returns the value of the data at the cursor's current position. */
    value: string;
    /** Returns a Date object representing the form control's value, if applicable; otherwise, returns null. Can be set, to change the value. Throws an "InvalidStateError" DOMException if the control isn't date- or time-based. */
    valueAsDate: any;
    /** Returns the input field value as a number. */
    valueAsNumber: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/webkitEntries) */
    readonly webkitEntries: FileSystemEntry[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/webkitdirectory) */
    webkitdirectory: boolean;
    /**
     * Sets or retrieves the width of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/width)
     */
    width: number;
    /**
     * Returns whether an element will successfully validate based on forms validation rules and constraints.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/willValidate)
     */
    readonly willValidate: boolean;
    /**
     * Returns whether a form will validate when it is submitted, without having to submit it.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/checkValidity)
     */
    checkValidity(): boolean;
    closeDateTimePicker(): void;
    getAutocompleteInfo(): AutocompleteInfo | null;
    getDateTimeInputBoxValue(): DateTimeValue;
    getFilesAndDirectories(): Promise<(File | Directory)[]>;
    getMaximum(): number;
    getMinimum(): number;
    getStep(): number;
    getStepBase(): number;
    mozGetFileNameArray(): string[];
    mozIsTextField(aExcludePassword: boolean): boolean;
    mozSetDirectory(directoryPath: string): void;
    mozSetDndFilesAndDirectories(list: (File | Directory)[]): void;
    mozSetFileArray(files: File[]): void;
    mozSetFileNameArray(fileNames: string[]): void;
    openDateTimePicker(initialValue?: DateTimeValue): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/reportValidity) */
    reportValidity(): boolean;
    /**
     * Makes the selection equal to the current object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/select)
     */
    select(): void;
    /**
     * Sets a custom error message that is displayed when a form is submitted.
     * @param error Sets a custom error message that is displayed when a form is submitted.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/setCustomValidity)
     */
    setCustomValidity(error: string): void;
    setFocusState(aIsFocused: boolean): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/setRangeText) */
    setRangeText(replacement: string): void;
    setRangeText(replacement: string, start: number, end: number, selectionMode?: SelectionMode): void;
    /**
     * Sets the start and end positions of a selection in a text field.
     * @param start The offset into the text field for the start of the selection.
     * @param end The offset into the text field for the end of the selection.
     * @param direction The direction in which the selection is performed.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/setSelectionRange)
     */
    setSelectionRange(start: number, end: number, direction?: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/showPicker) */
    showPicker(): void;
    /**
     * Decrements a range input control's value by the value given by the Step attribute. If the optional parameter is used, it will decrement the input control's step value multiplied by the parameter's value.
     * @param n Value to decrement the value by.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/stepDown)
     */
    stepDown(n?: number): void;
    /**
     * Increments a range input control's value by the value given by the Step attribute. If the optional parameter is used, will increment the input control's value by that value.
     * @param n Value to increment the value by.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/stepUp)
     */
    stepUp(n?: number): void;
    updateDateTimePicker(value?: DateTimeValue): void;
    updateValidityState(): void;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLInputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLInputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLInputElement: {
    prototype: HTMLInputElement;
    new(): HTMLInputElement;
    readonly UNKNOWN_REQUEST: -1;
    readonly CURRENT_REQUEST: 0;
    readonly PENDING_REQUEST: 1;
    isInstance(obj): obj is HTMLInputElement;
};

/**
 * Exposes specific properties and methods (beyond those defined by regular HTMLElement interface it also has available to it by inheritance) for manipulating list elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLIElement)
 */
interface HTMLLIElement extends HTMLElement {
    /** @deprecated */
    type: string;
    /** Sets or retrieves the value of a list item. */
    value: number;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLIElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLIElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLLIElement: {
    prototype: HTMLLIElement;
    new(): HTMLLIElement;
    isInstance(obj): obj is HTMLLIElement;
};

/**
 * Gives access to properties specific to <label> elements. It inherits methods and properties from the base HTMLElement interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLabelElement)
 */
interface HTMLLabelElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLabelElement/control) */
    readonly control: HTMLElement | null;
    /**
     * Retrieves a reference to the form that the object is embedded in.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLabelElement/form)
     */
    readonly form: HTMLFormElement | null;
    /**
     * Sets or retrieves the object to which the given label object is assigned.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLabelElement/htmlFor)
     */
    htmlFor: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLabelElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLabelElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLLabelElement: {
    prototype: HTMLLabelElement;
    new(): HTMLLabelElement;
    isInstance(obj): obj is HTMLLabelElement;
};

/**
 * The HTMLLegendElement is an interface allowing to access properties of the <legend> elements. It inherits properties and methods from the HTMLElement interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLegendElement)
 */
interface HTMLLegendElement extends HTMLElement {
    /** @deprecated */
    align: string;
    /** Retrieves a reference to the form that the object is embedded in. */
    readonly form: HTMLFormElement | null;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLegendElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLegendElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLLegendElement: {
    prototype: HTMLLegendElement;
    new(): HTMLLegendElement;
    isInstance(obj): obj is HTMLLegendElement;
};

/**
 * Reference information for external resources and the relationship of those resources to a document and vice-versa. This object inherits all of the properties and methods of the HTMLElement interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement)
 */
interface HTMLLinkElement extends HTMLElement, LinkStyle {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/as) */
    as: string;
    /**
     * Sets or retrieves the character set used to encode the object.
     * @deprecated
     */
    charset: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/crossOrigin) */
    crossOrigin: string | null;
    disabled: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/fetchPriority) */
    fetchPriority: string;
    /**
     * Sets or retrieves a destination URL or an anchor point.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/href)
     */
    href: string;
    /**
     * Sets or retrieves the language code of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/hreflang)
     */
    hreflang: string;
    imageSizes: string;
    imageSrcset: string;
    integrity: string;
    /** Sets or retrieves the media type. */
    media: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/referrerPolicy) */
    referrerPolicy: string;
    /**
     * Sets or retrieves the relationship between the object and the destination of the link.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/rel)
     */
    rel: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/relList) */
    readonly relList: DOMTokenList;
    /**
     * Sets or retrieves the relationship between the object and the destination of the link.
     * @deprecated
     */
    rev: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/sizes) */
    readonly sizes: DOMTokenList;
    /**
     * Sets or retrieves the window or frame at which to target content.
     * @deprecated
     */
    target: string;
    /** Sets or retrieves the MIME type of the object. */
    type: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLinkElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLinkElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLLinkElement: {
    prototype: HTMLLinkElement;
    new(): HTMLLinkElement;
    isInstance(obj): obj is HTMLLinkElement;
};

/**
 * Provides special properties and methods (beyond those of the regular object HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of map elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMapElement)
 */
interface HTMLMapElement extends HTMLElement {
    /**
     * Retrieves a collection of the area objects defined for the given map object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMapElement/areas)
     */
    readonly areas: HTMLCollection;
    /**
     * Sets or retrieves the name of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMapElement/name)
     */
    name: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMapElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMapElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLMapElement: {
    prototype: HTMLMapElement;
    new(): HTMLMapElement;
    isInstance(obj): obj is HTMLMapElement;
};

interface HTMLMarqueeElementEventMap extends HTMLElementEventMap {
    "bounce": Event;
    "finish": Event;
    "start": Event;
}

/**
 * Provides methods to manipulate <marquee> elements.
 * @deprecated
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMarqueeElement)
 */
interface HTMLMarqueeElement extends HTMLElement {
    /** @deprecated */
    behavior: string;
    /** @deprecated */
    bgColor: string;
    /** @deprecated */
    direction: string;
    /** @deprecated */
    height: string;
    /** @deprecated */
    hspace: number;
    /** @deprecated */
    loop: number;
    /** @deprecated */
    onbounce: ((this: HTMLMarqueeElement, ev: Event) => any) | null;
    /** @deprecated */
    onfinish: ((this: HTMLMarqueeElement, ev: Event) => any) | null;
    /** @deprecated */
    onstart: ((this: HTMLMarqueeElement, ev: Event) => any) | null;
    /** @deprecated */
    scrollAmount: number;
    /** @deprecated */
    scrollDelay: number;
    /** @deprecated */
    trueSpeed: boolean;
    /** @deprecated */
    vspace: number;
    /** @deprecated */
    width: string;
    /** @deprecated */
    start(): void;
    /** @deprecated */
    stop(): void;
    addEventListener<K extends keyof HTMLMarqueeElementEventMap>(type: K, listener: (this: HTMLMarqueeElement, ev: HTMLMarqueeElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLMarqueeElementEventMap>(type: K, listener: (this: HTMLMarqueeElement, ev: HTMLMarqueeElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

/** @deprecated */
declare var HTMLMarqueeElement: {
    prototype: HTMLMarqueeElement;
    new(): HTMLMarqueeElement;
    isInstance(obj): obj is HTMLMarqueeElement;
};

interface HTMLMediaElementEventMap extends HTMLElementEventMap {
    "encrypted": Event;
    "waitingforkey": Event;
}

/**
 * Adds to HTMLElement the properties and methods needed to support basic media-related capabilities that are common to audio and video.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement)
 */
interface HTMLMediaElement extends HTMLElement {
    readonly allowedToPlay: boolean;
    readonly audiblePlayTime: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/audioTracks) */
    readonly audioTracks: AudioTrackList;
    /**
     * Gets or sets a value that indicates whether to start playing the media automatically.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/autoplay)
     */
    autoplay: boolean;
    /**
     * Gets a collection of buffered time ranges.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/buffered)
     */
    readonly buffered: TimeRanges;
    readonly computedMuted: boolean;
    readonly computedVolume: number;
    /**
     * Gets or sets a flag that indicates whether the client provides a set of controls for the media (in case the developer does not include controls for the player).
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/controls)
     */
    controls: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/crossOrigin) */
    crossOrigin: string | null;
    /**
     * Gets the address or URL of the current media resource that is selected by IHTMLMediaElement.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/currentSrc)
     */
    readonly currentSrc: string;
    /**
     * Gets or sets the current playback position, in seconds.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/currentTime)
     */
    currentTime: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/defaultMuted) */
    defaultMuted: boolean;
    /**
     * Gets or sets the default playback rate when the user is not using fast forward or reverse for a video or audio resource.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/defaultPlaybackRate)
     */
    defaultPlaybackRate: number;
    /**
     * Returns the duration in seconds of the current media resource. A NaN value is returned if duration is not available, or Infinity if the media resource is streaming.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/duration)
     */
    readonly duration: number;
    /**
     * Gets information about whether the playback has ended or not.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/ended)
     */
    readonly ended: boolean;
    /**
     * Returns an object representing the current error state of the audio or video element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/error)
     */
    "error": ErrorEvent;
    readonly inaudiblePlayTime: number;
    readonly invisiblePlayTime: number;
    readonly isEncrypted: boolean;
    readonly isInViewPort: boolean;
    readonly isSuspendedByInactiveDocOrDocShell: boolean;
    readonly isVideoDecodingSuspended: boolean;
    /**
     * Gets or sets a flag to specify whether playback should restart after it completes.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/loop)
     */
    loop: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/mediaKeys) */
    readonly mediaKeys: MediaKeys | null;
    mozAllowCasting: boolean;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/mozAudioCaptured)
     */
    readonly mozAudioCaptured: boolean;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/mozFragmentEnd)
     */
    readonly mozFragmentEnd: number;
    mozIsCasting: boolean;
    readonly mozMediaSourceObject: MediaSource | null;
    /**
     * Gets or sets a flag that indicates whether the audio (either audio or the audio track on video media) is muted.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/muted)
     */
    muted: boolean;
    readonly mutedPlayTime: number;
    /**
     * Gets the current network activity for the element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/networkState)
     */
    readonly networkState: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/encrypted_event) */
    onencrypted: ((this: HTMLMediaElement, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/waitingforkey_event) */
    onwaitingforkey: ((this: HTMLMediaElement, ev: Event) => any) | null;
    /**
     * Gets a flag that specifies whether playback is paused.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/paused)
     */
    readonly paused: boolean;
    /**
     * Gets or sets the current rate of speed for the media resource to play. This speed is expressed as a multiple of the normal speed of the media resource.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/playbackRate)
     */
    playbackRate: number;
    /**
     * Gets TimeRanges for the current media resource that has been played.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/played)
     */
    readonly played: TimeRanges;
    /**
     * Gets or sets a value indicating what data should be preloaded, if any.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/preload)
     */
    preload: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/preservesPitch) */
    preservesPitch: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/readyState) */
    readonly readyState: number;
    /**
     * Returns a TimeRanges object that represents the ranges of the current media resource that can be seeked.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/seekable)
     */
    readonly seekable: TimeRanges;
    /**
     * Gets a flag that indicates whether the client is currently moving to a new playback position in the media resource.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/seeking)
     */
    readonly seeking: boolean;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/sinkId)
     */
    readonly sinkId: string;
    /**
     * The address or URL of the a media resource that is to be considered.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/src)
     */
    src: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/srcObject) */
    srcObject: MediaStream | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/textTracks) */
    readonly textTracks: TextTrackList | null;
    readonly totalAudioPlayTime: number;
    readonly totalVideoHDRPlayTime: number;
    readonly totalVideoPlayTime: number;
    readonly videoDecodeSuspendedTime: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/videoTracks) */
    readonly videoTracks: VideoTrackList;
    readonly visiblePlayTime: number;
    /**
     * Gets or sets the volume level for audio portions of the media element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/volume)
     */
    volume: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/addTextTrack) */
    addTextTrack(kind: TextTrackKind, label?: string, language?: string): TextTrack;
    /**
     * Returns a string that specifies whether the client can play a given media resource type.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/canPlayType)
     */
    canPlayType(type: string): string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/fastSeek) */
    fastSeek(time: number): void;
    hasSuspendTaint(): boolean;
    /**
     * Resets the audio or video object and loads a new media resource.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/load)
     */
    load(): void;
    /**
     * @deprecated This is a legacy alias of `captureStream`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/captureStream)
     */
    mozCaptureStream(): MediaStream;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/mozCaptureStreamUntilEnded)
     */
    mozCaptureStreamUntilEnded(): MediaStream;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/mozGetMetadata)
     */
    mozGetMetadata(): any;
    mozRequestDebugInfo(): Promise<HTMLMediaElementDebugInfo>;
    mozRequestDebugLog(): Promise<string>;
    /**
     * Pauses the current playback and sets paused to TRUE.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/pause)
     */
    pause(): void;
    /**
     * Loads and starts playback of a media resource.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/play)
     */
    play(): Promise<void>;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/seekToNextFrame)
     */
    seekToNextFrame(): Promise<void>;
    setAudioSinkFailedStartup(): void;
    setDecodeError(error: string): void;
    setFormatDiagnosticsReportForMimeType(mimeType: string, error: DecoderDoctorReportType): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/setMediaKeys) */
    setMediaKeys(mediaKeys: MediaKeys | null): Promise<void>;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/setSinkId)
     */
    setSinkId(sinkId: string): Promise<void>;
    setVisible(aVisible: boolean): void;
    readonly NETWORK_EMPTY: 0;
    readonly NETWORK_IDLE: 1;
    readonly NETWORK_LOADING: 2;
    readonly NETWORK_NO_SOURCE: 3;
    readonly HAVE_NOTHING: 0;
    readonly HAVE_METADATA: 1;
    readonly HAVE_CURRENT_DATA: 2;
    readonly HAVE_FUTURE_DATA: 3;
    readonly HAVE_ENOUGH_DATA: 4;
    addEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLMediaElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLMediaElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLMediaElement: {
    prototype: HTMLMediaElement;
    new(): HTMLMediaElement;
    readonly NETWORK_EMPTY: 0;
    readonly NETWORK_IDLE: 1;
    readonly NETWORK_LOADING: 2;
    readonly NETWORK_NO_SOURCE: 3;
    readonly HAVE_NOTHING: 0;
    readonly HAVE_METADATA: 1;
    readonly HAVE_CURRENT_DATA: 2;
    readonly HAVE_FUTURE_DATA: 3;
    readonly HAVE_ENOUGH_DATA: 4;
    mozEnableDebugLog(): void;
    isInstance(obj): obj is HTMLMediaElement;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMenuElement) */
interface HTMLMenuElement extends HTMLElement {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMenuElement/compact)
     */
    compact: boolean;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMenuElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMenuElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLMenuElement: {
    prototype: HTMLMenuElement;
    new(): HTMLMenuElement;
    isInstance(obj): obj is HTMLMenuElement;
};

/**
 * Contains descriptive metadata about a document. It inherits all of the properties and methods described in the HTMLElement interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMetaElement)
 */
interface HTMLMetaElement extends HTMLElement {
    /** Gets or sets meta-information to associate with httpEquiv or name. */
    content: string;
    /** Gets or sets information used to bind the value of a content attribute of a meta element to an HTTP response header. */
    httpEquiv: string;
    media: string;
    /** Sets or retrieves the value specified in the content attribute of the meta object. */
    name: string;
    /**
     * Sets or retrieves a scheme to be used in interpreting the value of a property specified for the object.
     * @deprecated
     */
    scheme: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMetaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMetaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLMetaElement: {
    prototype: HTMLMetaElement;
    new(): HTMLMetaElement;
    isInstance(obj): obj is HTMLMetaElement;
};

/**
 * The HTML <meter> elements expose the HTMLMeterElement interface, which provides special properties and methods (beyond the HTMLElement object interface they also have available to them by inheritance) for manipulating the layout and presentation of <meter> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement)
 */
interface HTMLMeterElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/high) */
    high: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/labels) */
    readonly labels: NodeList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/low) */
    low: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/max) */
    max: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/min) */
    min: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/optimum) */
    optimum: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/value) */
    value: number;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMeterElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMeterElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLMeterElement: {
    prototype: HTMLMeterElement;
    new(): HTMLMeterElement;
    isInstance(obj): obj is HTMLMeterElement;
};

/**
 * Provides special properties (beyond the regular methods and properties available through the HTMLElement interface they also have available to them by inheritance) for manipulating modification elements, that is <del> and <ins>.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLModElement)
 */
interface HTMLModElement extends HTMLElement {
    /**
     * Sets or retrieves reference information about the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLModElement/cite)
     */
    cite: string;
    /**
     * Sets or retrieves the date and time of a modification to the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLModElement/dateTime)
     */
    dateTime: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLModElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLModElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLModElement: {
    prototype: HTMLModElement;
    new(): HTMLModElement;
    isInstance(obj): obj is HTMLModElement;
};

interface HTMLModelElement {
}

declare var HTMLModelElement: {
    prototype: HTMLModelElement;
    new(): HTMLModelElement;
    isInstance(obj): obj is HTMLModelElement;
};

/**
 * Provides special properties (beyond those defined on the regular HTMLElement interface it also has available to it by inheritance) for manipulating ordered list elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOListElement)
 */
interface HTMLOListElement extends HTMLElement {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOListElement/compact)
     */
    compact: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOListElement/reversed) */
    reversed: boolean;
    /**
     * The starting number.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOListElement/start)
     */
    start: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOListElement/type) */
    type: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLOListElement: {
    prototype: HTMLOListElement;
    new(): HTMLOListElement;
    isInstance(obj): obj is HTMLOListElement;
};

/**
 * Provides special properties and methods (beyond those on the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of <object> element, representing external resources.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement)
 */
interface HTMLObjectElement extends HTMLElement, MozFrameLoaderOwner, MozImageLoadingContent, MozObjectLoadingContent {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/align)
     */
    align: string;
    /**
     * Sets or retrieves a character string that can be used to implement your own archive functionality for the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/archive)
     */
    archive: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/border)
     */
    border: string;
    /**
     * Sets or retrieves the URL of the file containing the compiled Java class.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/code)
     */
    code: string;
    /**
     * Sets or retrieves the URL of the component.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/codeBase)
     */
    codeBase: string;
    /**
     * Sets or retrieves the Internet media type for the code associated with the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/codeType)
     */
    codeType: string;
    /**
     * Retrieves the document object of the page or frame.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/contentDocument)
     */
    readonly contentDocument: Document | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/contentWindow) */
    readonly contentWindow: WindowProxy | null;
    /**
     * Sets or retrieves the URL that references the data of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/data)
     */
    data: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/declare)
     */
    declare: boolean;
    /**
     * Retrieves a reference to the form that the object is embedded in.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/form)
     */
    readonly form: HTMLFormElement | null;
    /**
     * Sets or retrieves the height of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/height)
     */
    height: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/hspace)
     */
    hspace: number;
    /**
     * Sets or retrieves the name of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/name)
     */
    name: string;
    /**
     * Sets or retrieves a message to be displayed while an object is loading.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/standby)
     */
    standby: string;
    /**
     * Sets or retrieves the MIME type of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/type)
     */
    type: string;
    /**
     * Sets or retrieves the URL, often with a bookmark extension (#name), to use as a client-side image map.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/useMap)
     */
    useMap: string;
    /**
     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as "this is a required field". The result is that the user sees validation messages without actually submitting.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/validationMessage)
     */
    readonly validationMessage: string;
    /**
     * Returns a  ValidityState object that represents the validity states of an element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/validity)
     */
    readonly validity: ValidityState;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/vspace)
     */
    vspace: number;
    /**
     * Sets or retrieves the width of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/width)
     */
    width: string;
    /**
     * Returns whether an element will successfully validate based on forms validation rules and constraints.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/willValidate)
     */
    readonly willValidate: boolean;
    /**
     * Returns whether a form will validate when it is submitted, without having to submit it.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/checkValidity)
     */
    checkValidity(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/getSVGDocument) */
    getSVGDocument(): Document | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/reportValidity) */
    reportValidity(): boolean;
    /**
     * Sets a custom error message that is displayed when a form is submitted.
     * @param error Sets a custom error message that is displayed when a form is submitted.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/setCustomValidity)
     */
    setCustomValidity(error: string): void;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLObjectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLObjectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLObjectElement: {
    prototype: HTMLObjectElement;
    new(): HTMLObjectElement;
    readonly UNKNOWN_REQUEST: -1;
    readonly CURRENT_REQUEST: 0;
    readonly PENDING_REQUEST: 1;
    readonly TYPE_LOADING: 0;
    readonly TYPE_IMAGE: 1;
    readonly TYPE_FALLBACK: 2;
    readonly TYPE_FAKE_PLUGIN: 3;
    readonly TYPE_DOCUMENT: 4;
    readonly TYPE_NULL: 5;
    isInstance(obj): obj is HTMLObjectElement;
};

/**
 * Provides special properties and methods (beyond the regular HTMLElement object interface they also have available to them by inheritance) for manipulating the layout and presentation of <optgroup> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptGroupElement)
 */
interface HTMLOptGroupElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptGroupElement/disabled) */
    disabled: boolean;
    /**
     * Sets or retrieves a value that you can use to implement your own label functionality for the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptGroupElement/label)
     */
    label: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptGroupElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptGroupElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLOptGroupElement: {
    prototype: HTMLOptGroupElement;
    new(): HTMLOptGroupElement;
    isInstance(obj): obj is HTMLOptGroupElement;
};

/**
 * <option> elements and inherits all classes and methods of the HTMLElement interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement)
 */
interface HTMLOptionElement extends HTMLElement {
    /**
     * Sets or retrieves the status of an option.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/defaultSelected)
     */
    defaultSelected: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/disabled) */
    disabled: boolean;
    /**
     * Retrieves a reference to the form that the object is embedded in.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/form)
     */
    readonly form: HTMLFormElement | null;
    /**
     * Sets or retrieves the ordinal position of an option in a list box.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/index)
     */
    readonly index: number;
    /**
     * Sets or retrieves a value that you can use to implement your own label functionality for the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/label)
     */
    label: string;
    /**
     * Sets or retrieves whether the option in the list box is the default item.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/selected)
     */
    selected: boolean;
    /**
     * Sets or retrieves the text string specified by the option tag.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/text)
     */
    text: string;
    /**
     * Sets or retrieves the value which is returned to the server when the form control is submitted.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/value)
     */
    value: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLOptionElement: {
    prototype: HTMLOptionElement;
    new(): HTMLOptionElement;
    isInstance(obj): obj is HTMLOptionElement;
};

/**
 * HTMLOptionsCollection is an interface representing a collection of HTML option elements (in document order) and offers methods and properties for traversing the list as well as optionally altering its items. This type is returned solely by the "options" property of select.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionsCollection)
 */
interface HTMLOptionsCollection extends HTMLCollectionBase {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionsCollection/length) */
    length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionsCollection/selectedIndex) */
    selectedIndex: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionsCollection/add) */
    add(element: HTMLOptionElement | HTMLOptGroupElement, before?: HTMLElement | number | null): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionsCollection/remove) */
    remove(index: number): void;
}

declare var HTMLOptionsCollection: {
    prototype: HTMLOptionsCollection;
    new(): HTMLOptionsCollection;
    isInstance(obj): obj is HTMLOptionsCollection;
};

interface HTMLOrForeignElement {
    autofocus: boolean;
    readonly dataset: DOMStringMap;
    tabIndex: number;
    blur(): void;
    focus(options?: FocusOptions): void;
}

/**
 * Provides properties and methods (beyond those inherited from HTMLElement) for manipulating the layout and presentation of <output> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement)
 */
interface HTMLOutputElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/defaultValue) */
    defaultValue: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/form) */
    readonly form: HTMLFormElement | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/htmlFor) */
    readonly htmlFor: DOMTokenList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/labels) */
    readonly labels: NodeList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/name) */
    name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/type) */
    readonly type: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/validationMessage) */
    readonly validationMessage: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/validity) */
    readonly validity: ValidityState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/value) */
    value: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/willValidate) */
    readonly willValidate: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/checkValidity) */
    checkValidity(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/reportValidity) */
    reportValidity(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/setCustomValidity) */
    setCustomValidity(error: string): void;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOutputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOutputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLOutputElement: {
    prototype: HTMLOutputElement;
    new(): HTMLOutputElement;
    isInstance(obj): obj is HTMLOutputElement;
};

/**
 * Provides special properties (beyond those of the regular HTMLElement object interface it inherits) for manipulating <p> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLParagraphElement)
 */
interface HTMLParagraphElement extends HTMLElement {
    /**
     * Sets or retrieves how the object is aligned with adjacent text.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLParagraphElement/align)
     */
    align: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParagraphElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParagraphElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLParagraphElement: {
    prototype: HTMLParagraphElement;
    new(): HTMLParagraphElement;
    isInstance(obj): obj is HTMLParagraphElement;
};

/**
 * Provides special properties (beyond those of the regular HTMLElement object interface it inherits) for manipulating <param> elements, representing a pair of a key and a value that acts as a parameter for an <object> element.
 * @deprecated
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLParamElement)
 */
interface HTMLParamElement extends HTMLElement {
    /**
     * Sets or retrieves the name of an input parameter for an element.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLParamElement/name)
     */
    name: string;
    /**
     * Sets or retrieves the content type of the resource designated by the value attribute.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLParamElement/type)
     */
    type: string;
    /**
     * Sets or retrieves the value of an input parameter for an element.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLParamElement/value)
     */
    value: string;
    /**
     * Sets or retrieves the data type of the value attribute.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLParamElement/valueType)
     */
    valueType: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParamElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParamElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

/** @deprecated */
declare var HTMLParamElement: {
    prototype: HTMLParamElement;
    new(): HTMLParamElement;
    isInstance(obj): obj is HTMLParamElement;
};

/**
 * A <picture> HTML element. It doesn't implement specific properties or methods.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLPictureElement)
 */
interface HTMLPictureElement extends HTMLElement {
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPictureElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPictureElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLPictureElement: {
    prototype: HTMLPictureElement;
    new(): HTMLPictureElement;
    isInstance(obj): obj is HTMLPictureElement;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLPortalElement) */
interface HTMLPortalElement {
}

declare var HTMLPortalElement: {
    prototype: HTMLPortalElement;
    new(): HTMLPortalElement;
    isInstance(obj): obj is HTMLPortalElement;
};

/**
 * Exposes specific properties and methods (beyond those of the HTMLElement interface it also has available to it by inheritance) for manipulating a block of preformatted text (<pre>).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLPreElement)
 */
interface HTMLPreElement extends HTMLElement {
    /**
     * Sets or gets a value that you can use to implement your own width functionality for the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLPreElement/width)
     */
    width: number;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPreElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPreElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLPreElement: {
    prototype: HTMLPreElement;
    new(): HTMLPreElement;
    isInstance(obj): obj is HTMLPreElement;
};

/**
 * Provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of <progress> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLProgressElement)
 */
interface HTMLProgressElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLProgressElement/labels) */
    readonly labels: NodeList;
    /**
     * Defines the maximum, or "done" value for a progress element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLProgressElement/max)
     */
    max: number;
    /**
     * Returns the quotient of value/max when the value attribute is set (determinate progress bar), or -1 when the value attribute is missing (indeterminate progress bar).
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLProgressElement/position)
     */
    readonly position: number;
    /**
     * Sets or gets the current value of a progress element. The value must be a non-negative number between 0 and the max value.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLProgressElement/value)
     */
    value: number;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLProgressElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLProgressElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLProgressElement: {
    prototype: HTMLProgressElement;
    new(): HTMLProgressElement;
    isInstance(obj): obj is HTMLProgressElement;
};

/**
 * Provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating quoting elements, like <blockquote> and <q>, but not the <cite> element.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLQuoteElement)
 */
interface HTMLQuoteElement extends HTMLElement {
    /**
     * Sets or retrieves reference information about the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLQuoteElement/cite)
     */
    cite: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLQuoteElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLQuoteElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLQuoteElement: {
    prototype: HTMLQuoteElement;
    new(): HTMLQuoteElement;
    isInstance(obj): obj is HTMLQuoteElement;
};

/**
 * HTML <script> elements expose the HTMLScriptElement interface, which provides special properties and methods for manipulating the behavior and execution of <script> elements (beyond the inherited HTMLElement interface).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement)
 */
interface HTMLScriptElement extends HTMLElement {
    async: boolean;
    /**
     * Sets or retrieves the character set used to encode the object.
     * @deprecated
     */
    charset: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/crossOrigin) */
    crossOrigin: string | null;
    /** Sets or retrieves the status of the script. */
    defer: boolean;
    /**
     * Sets or retrieves the event for which the script is written.
     * @deprecated
     */
    event: string;
    fetchPriority: string;
    /**
     * Sets or retrieves the object that is bound to the event script.
     * @deprecated
     */
    htmlFor: string;
    integrity: string;
    noModule: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/referrerPolicy) */
    referrerPolicy: string;
    /** Retrieves the URL to an external file that contains the source code or data. */
    src: string;
    /** Retrieves or sets the text of the object as a string. */
    text: string;
    /** Sets or retrieves the MIME type for the associated scripting engine. */
    type: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLScriptElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLScriptElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLScriptElement: {
    prototype: HTMLScriptElement;
    new(): HTMLScriptElement;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/supports_static) */
    supports(type: string): boolean;
    isInstance(obj): obj is HTMLScriptElement;
};

/**
 * A <select> HTML Element. These elements also share all of the properties and methods of other HTML elements via the HTMLElement interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement)
 */
interface HTMLSelectElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/autocomplete) */
    autocomplete: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/disabled) */
    disabled: boolean;
    /**
     * Retrieves a reference to the form that the object is embedded in.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/form)
     */
    readonly form: HTMLFormElement | null;
    readonly isCombobox: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/labels) */
    readonly labels: NodeList;
    /**
     * Sets or retrieves the number of objects in a collection.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/length)
     */
    length: number;
    /**
     * Sets or retrieves the Boolean value indicating whether multiple items can be selected from a list.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/multiple)
     */
    multiple: boolean;
    /**
     * Sets or retrieves the name of the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/name)
     */
    name: string;
    openInParentProcess: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/options) */
    readonly options: HTMLOptionsCollection;
    previewValue: string;
    /**
     * When present, marks an element that can't be submitted without a value.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/required)
     */
    required: boolean;
    /**
     * Sets or retrieves the index of the selected option in a select object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/selectedIndex)
     */
    selectedIndex: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/selectedOptions) */
    readonly selectedOptions: HTMLCollection;
    /**
     * Sets or retrieves the number of rows in the list box.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/size)
     */
    size: number;
    /**
     * Retrieves the type of select control based on the value of the MULTIPLE attribute.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/type)
     */
    readonly type: string;
    /**
     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as "this is a required field". The result is that the user sees validation messages without actually submitting.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/validationMessage)
     */
    readonly validationMessage: string;
    /**
     * Returns a  ValidityState object that represents the validity states of an element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/validity)
     */
    readonly validity: ValidityState;
    /**
     * Sets or retrieves the value which is returned to the server when the form control is submitted.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/value)
     */
    value: string;
    /**
     * Returns whether an element will successfully validate based on forms validation rules and constraints.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/willValidate)
     */
    readonly willValidate: boolean;
    /**
     * Adds an element to the areas, controlRange, or options collection.
     * @param element Variant of type Number that specifies the index position in the collection where the element is placed. If no value is given, the method places the element at the end of the collection.
     * @param before Variant of type Object that specifies an element to insert before, or null to append the object to the collection.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/add)
     */
    add(element: HTMLOptionElement | HTMLOptGroupElement, before?: HTMLElement | number | null): void;
    /**
     * Returns whether a form will validate when it is submitted, without having to submit it.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/checkValidity)
     */
    checkValidity(): boolean;
    getAutocompleteInfo(): AutocompleteInfo;
    /**
     * Retrieves a select object or an object from an options collection.
     * @param name Variant of type Number or String that specifies the object or collection to retrieve. If this parameter is an integer, it is the zero-based index of the object. If this parameter is a string, all objects with matching name or id properties are retrieved, and a collection is returned if more than one match is made.
     * @param index Variant of type Number that specifies the zero-based index of the object to retrieve when a collection is returned.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/item)
     */
    item(index: number): Element | null;
    /**
     * Retrieves a select object or an object from an options collection.
     * @param namedItem A String that specifies the name or id property of the object to retrieve. A collection is returned if more than one match is made.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/namedItem)
     */
    namedItem(name: string): HTMLOptionElement | null;
    /**
     * Removes an element from the collection.
     * @param index Number that specifies the zero-based index of the element to remove from the collection.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/remove)
     */
    remove(index: number): void;
    remove(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/reportValidity) */
    reportValidity(): boolean;
    /**
     * Sets a custom error message that is displayed when a form is submitted.
     * @param error Sets a custom error message that is displayed when a form is submitted.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/setCustomValidity)
     */
    setCustomValidity(error: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/showPicker) */
    showPicker(): void;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSelectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSelectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
    [index: number]: Element;
}

declare var HTMLSelectElement: {
    prototype: HTMLSelectElement;
    new(): HTMLSelectElement;
    isInstance(obj): obj is HTMLSelectElement;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSlotElement) */
interface HTMLSlotElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSlotElement/name) */
    name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSlotElement/assign) */
    assign(...nodes: (Element | Text)[]): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSlotElement/assignedElements) */
    assignedElements(options?: AssignedNodesOptions): Element[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSlotElement/assignedNodes) */
    assignedNodes(options?: AssignedNodesOptions): Node[];
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSlotElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSlotElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLSlotElement: {
    prototype: HTMLSlotElement;
    new(): HTMLSlotElement;
    isInstance(obj): obj is HTMLSlotElement;
};

/**
 * Provides special properties (beyond the regular HTMLElement object interface it also has available to it by inheritance) for manipulating <source> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement)
 */
interface HTMLSourceElement extends HTMLElement {
    height: number;
    /**
     * Gets or sets the intended media type of the media source.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement/media)
     */
    media: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement/sizes) */
    sizes: string;
    /**
     * The address or URL of the a media resource that is to be considered.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement/src)
     */
    src: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement/srcset) */
    srcset: string;
    /**
     * Gets or sets the MIME type of a media resource.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement/type)
     */
    type: string;
    width: number;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSourceElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSourceElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLSourceElement: {
    prototype: HTMLSourceElement;
    new(): HTMLSourceElement;
    isInstance(obj): obj is HTMLSourceElement;
};

/**
 * A <span> element and derives from the HTMLElement interface, but without implementing any additional properties or methods.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSpanElement)
 */
interface HTMLSpanElement extends HTMLElement {
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSpanElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSpanElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLSpanElement: {
    prototype: HTMLSpanElement;
    new(): HTMLSpanElement;
    isInstance(obj): obj is HTMLSpanElement;
};

/**
 * A <style> element. It inherits properties and methods from its parent, HTMLElement, and from LinkStyle.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLStyleElement)
 */
interface HTMLStyleElement extends HTMLElement, LinkStyle {
    /**
     * Enables or disables the style sheet.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLStyleElement/disabled)
     */
    disabled: boolean;
    /**
     * Sets or retrieves the media type.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLStyleElement/media)
     */
    media: string;
    /**
     * Retrieves the CSS language in which the style sheet is written.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLStyleElement/type)
     */
    type: string;
    setDevtoolsAsTriggeringPrincipal(): void;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLStyleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLStyleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLStyleElement: {
    prototype: HTMLStyleElement;
    new(): HTMLStyleElement;
    isInstance(obj): obj is HTMLStyleElement;
};

/**
 * Special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating table caption elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCaptionElement)
 */
interface HTMLTableCaptionElement extends HTMLElement {
    /**
     * Sets or retrieves the alignment of the caption or legend.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCaptionElement/align)
     */
    align: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCaptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCaptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLTableCaptionElement: {
    prototype: HTMLTableCaptionElement;
    new(): HTMLTableCaptionElement;
    isInstance(obj): obj is HTMLTableCaptionElement;
};

/**
 * Provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of table cells, either header or data cells, in an HTML document.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement)
 */
interface HTMLTableCellElement extends HTMLElement {
    /**
     * Sets or retrieves abbreviated text for the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/abbr)
     */
    abbr: string;
    /**
     * Sets or retrieves how the object is aligned with adjacent text.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/align)
     */
    align: string;
    /**
     * Sets or retrieves a comma-delimited list of conceptual categories associated with the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/axis)
     */
    axis: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/bgColor)
     */
    bgColor: string;
    /**
     * Retrieves the position of the object in the cells collection of a row.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/cellIndex)
     */
    readonly cellIndex: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/ch)
     */
    ch: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/chOff)
     */
    chOff: string;
    /**
     * Sets or retrieves the number columns in the table that the object should span.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/colSpan)
     */
    colSpan: number;
    /**
     * Sets or retrieves a list of header cells that provide information for the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/headers)
     */
    headers: string;
    /**
     * Sets or retrieves the height of the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/height)
     */
    height: string;
    /**
     * Sets or retrieves whether the browser automatically performs wordwrap.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/noWrap)
     */
    noWrap: boolean;
    /**
     * Sets or retrieves how many rows in a table the cell should span.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/rowSpan)
     */
    rowSpan: number;
    /**
     * Sets or retrieves the group of cells in a table to which the object's information applies.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/scope)
     */
    scope: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/vAlign)
     */
    vAlign: string;
    /**
     * Sets or retrieves the width of the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/width)
     */
    width: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLTableCellElement: {
    prototype: HTMLTableCellElement;
    new(): HTMLTableCellElement;
    isInstance(obj): obj is HTMLTableCellElement;
};

/**
 * Provides special properties (beyond the HTMLElement interface it also has available to it inheritance) for manipulating single or grouped table column elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableColElement)
 */
interface HTMLTableColElement extends HTMLElement {
    /**
     * Sets or retrieves the alignment of the object relative to the display or table.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableColElement/align)
     */
    align: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableColElement/ch)
     */
    ch: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableColElement/chOff)
     */
    chOff: string;
    /**
     * Sets or retrieves the number of columns in the group.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableColElement/span)
     */
    span: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableColElement/vAlign)
     */
    vAlign: string;
    /**
     * Sets or retrieves the width of the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableColElement/width)
     */
    width: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableColElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableColElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLTableColElement: {
    prototype: HTMLTableColElement;
    new(): HTMLTableColElement;
    isInstance(obj): obj is HTMLTableColElement;
};

/**
 * Provides special properties and methods (beyond the regular HTMLElement object interface it also has available to it by inheritance) for manipulating the layout and presentation of tables in an HTML document.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement)
 */
interface HTMLTableElement extends HTMLElement {
    /**
     * Sets or retrieves a value that indicates the table alignment.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/align)
     */
    align: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/bgColor)
     */
    bgColor: string;
    /**
     * Sets or retrieves the width of the border to draw around the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/border)
     */
    border: string;
    /**
     * Retrieves the caption object of a table.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/caption)
     */
    caption: HTMLTableCaptionElement | null;
    /**
     * Sets or retrieves the amount of space between the border of the cell and the content of the cell.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/cellPadding)
     */
    cellPadding: string;
    /**
     * Sets or retrieves the amount of space between cells in a table.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/cellSpacing)
     */
    cellSpacing: string;
    /**
     * Sets or retrieves the way the border frame around the table is displayed.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/frame)
     */
    frame: string;
    /**
     * Sets or retrieves the number of horizontal rows contained in the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/rows)
     */
    readonly rows: HTMLCollection;
    /**
     * Sets or retrieves which dividing lines (inner borders) are displayed.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/rules)
     */
    rules: string;
    /**
     * Sets or retrieves a description and/or structure of the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/summary)
     */
    summary: string;
    /**
     * Retrieves a collection of all tBody objects in the table. Objects in this collection are in source order.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/tBodies)
     */
    readonly tBodies: HTMLCollection;
    /**
     * Retrieves the tFoot object of the table.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/tFoot)
     */
    tFoot: HTMLTableSectionElement | null;
    /**
     * Retrieves the tHead object of the table.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/tHead)
     */
    tHead: HTMLTableSectionElement | null;
    /**
     * Sets or retrieves the width of the object.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/width)
     */
    width: string;
    /**
     * Creates an empty caption element in the table.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/createCaption)
     */
    createCaption(): HTMLElement;
    /**
     * Creates an empty tBody element in the table.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/createTBody)
     */
    createTBody(): HTMLElement;
    /**
     * Creates an empty tFoot element in the table.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/createTFoot)
     */
    createTFoot(): HTMLElement;
    /**
     * Returns the tHead element object if successful, or null otherwise.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/createTHead)
     */
    createTHead(): HTMLElement;
    /**
     * Deletes the caption element and its contents from the table.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/deleteCaption)
     */
    deleteCaption(): void;
    /**
     * Removes the specified row (tr) from the element and from the rows collection.
     * @param index Number that specifies the zero-based position in the rows collection of the row to remove.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/deleteRow)
     */
    deleteRow(index: number): void;
    /**
     * Deletes the tFoot element and its contents from the table.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/deleteTFoot)
     */
    deleteTFoot(): void;
    /**
     * Deletes the tHead element and its contents from the table.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/deleteTHead)
     */
    deleteTHead(): void;
    /**
     * Creates a new row (tr) in the table, and adds the row to the rows collection.
     * @param index Number that specifies where to insert the row in the rows collection. The default value is -1, which appends the new row to the end of the rows collection.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/insertRow)
     */
    insertRow(index?: number): HTMLElement;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLTableElement: {
    prototype: HTMLTableElement;
    new(): HTMLTableElement;
    isInstance(obj): obj is HTMLTableElement;
};

/**
 * Provides special properties and methods (beyond the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of rows in an HTML table.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement)
 */
interface HTMLTableRowElement extends HTMLElement {
    /**
     * Sets or retrieves how the object is aligned with adjacent text.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/align)
     */
    align: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/bgColor)
     */
    bgColor: string;
    /**
     * Retrieves a collection of all cells in the table row.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/cells)
     */
    readonly cells: HTMLCollection;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/ch)
     */
    ch: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/chOff)
     */
    chOff: string;
    /**
     * Retrieves the position of the object in the rows collection for the table.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/rowIndex)
     */
    readonly rowIndex: number;
    /**
     * Retrieves the position of the object in the collection.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/sectionRowIndex)
     */
    readonly sectionRowIndex: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/vAlign)
     */
    vAlign: string;
    /**
     * Removes the specified cell from the table row, as well as from the cells collection.
     * @param index Number that specifies the zero-based position of the cell to remove from the table row. If no value is provided, the last cell in the cells collection is deleted.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/deleteCell)
     */
    deleteCell(index: number): void;
    /**
     * Creates a new cell in the table row, and adds the cell to the cells collection.
     * @param index Number that specifies where to insert the cell in the tr. The default value is -1, which appends the new cell to the end of the cells collection.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/insertCell)
     */
    insertCell(index?: number): HTMLElement;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableRowElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableRowElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLTableRowElement: {
    prototype: HTMLTableRowElement;
    new(): HTMLTableRowElement;
    isInstance(obj): obj is HTMLTableRowElement;
};

/**
 * Provides special properties and methods (beyond the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of sections, that is headers, footers and bodies, in an HTML table.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement)
 */
interface HTMLTableSectionElement extends HTMLElement {
    /**
     * Sets or retrieves a value that indicates the table alignment.
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/align)
     */
    align: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/ch)
     */
    ch: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/chOff)
     */
    chOff: string;
    /**
     * Sets or retrieves the number of horizontal rows contained in the object.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/rows)
     */
    readonly rows: HTMLCollection;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/vAlign)
     */
    vAlign: string;
    /**
     * Removes the specified row (tr) from the element and from the rows collection.
     * @param index Number that specifies the zero-based position in the rows collection of the row to remove.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/deleteRow)
     */
    deleteRow(index: number): void;
    /**
     * Creates a new row (tr) in the table, and adds the row to the rows collection.
     * @param index Number that specifies where to insert the row in the rows collection. The default value is -1, which appends the new row to the end of the rows collection.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/insertRow)
     */
    insertRow(index?: number): HTMLElement;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableSectionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableSectionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLTableSectionElement: {
    prototype: HTMLTableSectionElement;
    new(): HTMLTableSectionElement;
    isInstance(obj): obj is HTMLTableSectionElement;
};

/**
 * Enables access to the contents of an HTML <template> element.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTemplateElement)
 */
interface HTMLTemplateElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTemplateElement/content) */
    readonly content: DocumentFragment;
    shadowRootDelegatesFocus: boolean;
    shadowRootMode: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTemplateElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTemplateElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLTemplateElement: {
    prototype: HTMLTemplateElement;
    new(): HTMLTemplateElement;
    isInstance(obj): obj is HTMLTemplateElement;
};

/**
 * Provides special properties and methods for manipulating the layout and presentation of <textarea> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement)
 */
interface HTMLTextAreaElement extends HTMLElement, MozEditableElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/autocomplete) */
    autocomplete: string;
    /** Sets or retrieves the width of the object. */
    cols: number;
    readonly controllers: XULControllers;
    /** Sets or retrieves the initial contents of the object. */
    defaultValue: string;
    dirName: string;
    disabled: boolean;
    /** Retrieves a reference to the form that the object is embedded in. */
    readonly form: HTMLFormElement | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/labels) */
    readonly labels: NodeList;
    /** Sets or retrieves the maximum number of characters that the user can enter in a text control. */
    maxLength: number;
    minLength: number;
    /** Sets or retrieves the name of the object. */
    name: string;
    /** Gets or sets a text string that is displayed in an input field as a hint or prompt to users as the format or type of information they need to enter.The text appears in an input field until the user puts focus on the field. */
    placeholder: string;
    previewValue: string;
    /** Sets or retrieves the value indicated whether the content of the object is read-only. */
    readOnly: boolean;
    /** When present, marks an element that can't be submitted without a value. */
    required: boolean;
    /** Sets or retrieves the number of horizontal rows contained in the object. */
    rows: number;
    selectionDirection: string | null;
    /** Gets or sets the end position or offset of a text selection. */
    selectionEnd: number | null;
    /** Gets or sets the starting position or offset of a text selection. */
    selectionStart: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/textLength) */
    readonly textLength: number;
    /** Retrieves the type of control. */
    readonly type: string;
    /** Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as "this is a required field". The result is that the user sees validation messages without actually submitting. */
    readonly validationMessage: string;
    /** Returns a  ValidityState object that represents the validity states of an element. */
    readonly validity: ValidityState;
    /** Retrieves or sets the text in the entry field of the textArea element. */
    value: string;
    /** Returns whether an element will successfully validate based on forms validation rules and constraints. */
    readonly willValidate: boolean;
    /** Sets or retrieves how to handle wordwrapping in the object. */
    wrap: string;
    /** Returns whether a form will validate when it is submitted, without having to submit it. */
    checkValidity(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/reportValidity) */
    reportValidity(): boolean;
    /** Highlights the input area of a form element. */
    select(): void;
    /**
     * Sets a custom error message that is displayed when a form is submitted.
     * @param error Sets a custom error message that is displayed when a form is submitted.
     */
    setCustomValidity(error: string): void;
    setRangeText(replacement: string): void;
    setRangeText(replacement: string, start: number, end: number, selectionMode?: SelectionMode): void;
    /**
     * Sets the start and end positions of a selection in a text field.
     * @param start The offset into the text field for the start of the selection.
     * @param end The offset into the text field for the end of the selection.
     * @param direction The direction in which the selection is performed.
     */
    setSelectionRange(start: number, end: number, direction?: string): void;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTextAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTextAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLTextAreaElement: {
    prototype: HTMLTextAreaElement;
    new(): HTMLTextAreaElement;
    isInstance(obj): obj is HTMLTextAreaElement;
};

/**
 * Provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <time> elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTimeElement)
 */
interface HTMLTimeElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTimeElement/dateTime) */
    dateTime: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTimeElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTimeElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLTimeElement: {
    prototype: HTMLTimeElement;
    new(): HTMLTimeElement;
    isInstance(obj): obj is HTMLTimeElement;
};

/**
 * Contains the title for a document. This element inherits all of the properties and methods of the HTMLElement interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTitleElement)
 */
interface HTMLTitleElement extends HTMLElement {
    /**
     * Retrieves or sets the text of the object as a string.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTitleElement/text)
     */
    text: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTitleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTitleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLTitleElement: {
    prototype: HTMLTitleElement;
    new(): HTMLTitleElement;
    isInstance(obj): obj is HTMLTitleElement;
};

/**
 * The HTMLTrackElement
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement)
 */
interface HTMLTrackElement extends HTMLElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/default) */
    default: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/kind) */
    kind: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/label) */
    label: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/readyState) */
    readonly readyState: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/src) */
    src: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/srclang) */
    srclang: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/track) */
    readonly track: TextTrack | null;
    readonly NONE: 0;
    readonly LOADING: 1;
    readonly LOADED: 2;
    readonly ERROR: 3;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTrackElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTrackElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLTrackElement: {
    prototype: HTMLTrackElement;
    new(): HTMLTrackElement;
    readonly NONE: 0;
    readonly LOADING: 1;
    readonly LOADED: 2;
    readonly ERROR: 3;
    isInstance(obj): obj is HTMLTrackElement;
};

/**
 * Provides special properties (beyond those defined on the regular HTMLElement interface it also has available to it by inheritance) for manipulating unordered list elements.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLUListElement)
 */
interface HTMLUListElement extends HTMLElement {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLUListElement/compact)
     */
    compact: boolean;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLUListElement/type)
     */
    type: string;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLUListElement: {
    prototype: HTMLUListElement;
    new(): HTMLUListElement;
    isInstance(obj): obj is HTMLUListElement;
};

/**
 * An invalid HTML element and derives from the HTMLElement interface, but without implementing any additional properties or methods.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLUnknownElement)
 */
interface HTMLUnknownElement extends HTMLElement {
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUnknownElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUnknownElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLUnknownElement: {
    prototype: HTMLUnknownElement;
    new(): HTMLUnknownElement;
    isInstance(obj): obj is HTMLUnknownElement;
};

/**
 * Provides special properties and methods for manipulating video objects. It also inherits properties and methods of HTMLMediaElement and HTMLElement.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement)
 */
interface HTMLVideoElement extends HTMLMediaElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/disablePictureInPicture) */
    disablePictureInPicture: boolean;
    /**
     * Gets or sets the height of the video element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/height)
     */
    height: number;
    readonly isCloningElementVisually: boolean;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/mozDecodedFrames)
     */
    readonly mozDecodedFrames: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/mozFrameDelay)
     */
    readonly mozFrameDelay: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/mozHasAudio)
     */
    readonly mozHasAudio: boolean;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/mozPaintedFrames)
     */
    readonly mozPaintedFrames: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/mozParsedFrames)
     */
    readonly mozParsedFrames: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/mozPresentedFrames)
     */
    readonly mozPresentedFrames: number;
    /** Gets or sets the playsinline of the video element. for example, On iPhone, video elements will now be allowed to play inline, and will not automatically enter fullscreen mode when playback begins. */
    playsInline: unknown;
    /**
     * Gets or sets a URL of an image to display, for example, like a movie poster. This can be a still frame from the video, or another image if no video data is available.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/poster)
     */
    poster: string;
    /**
     * Gets the intrinsic height of a video in CSS pixels, or zero if the dimensions are not known.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/videoHeight)
     */
    readonly videoHeight: number;
    /**
     * Gets the intrinsic width of a video in CSS pixels, or zero if the dimensions are not known.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/videoWidth)
     */
    readonly videoWidth: number;
    /**
     * Gets or sets the width of the video element.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/width)
     */
    width: number;
    cloneElementVisually(target: HTMLVideoElement): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/getVideoPlaybackQuality) */
    getVideoPlaybackQuality(): VideoPlaybackQuality;
    stopCloningElementVisually(): void;
    addEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLVideoElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLVideoElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var HTMLVideoElement: {
    prototype: HTMLVideoElement;
    new(): HTMLVideoElement;
    isInstance(obj): obj is HTMLVideoElement;
};

/**
 * Events that fire when the fragment identifier of the URL has changed.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HashChangeEvent)
 */
interface HashChangeEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HashChangeEvent/newURL) */
    readonly newURL: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HashChangeEvent/oldURL) */
    readonly oldURL: string;
    initHashChangeEvent(typeArg: string, canBubbleArg?: boolean, cancelableArg?: boolean, oldURLArg?: string, newURLArg?: string): void;
}

declare var HashChangeEvent: {
    prototype: HashChangeEvent;
    new(type: string, eventInitDict?: HashChangeEventInit): HashChangeEvent;
    isInstance(obj): obj is HashChangeEvent;
};

/**
 * This Fetch API interface allows you to perform various actions on HTTP request and response headers. These actions include retrieving, setting, adding to, and removing. A Headers object has an associated header list, which is initially empty and consists of zero or more name and value pairs.  You can add to this using methods like append() (see Examples.) In all methods of this interface, header names are matched by case-insensitive byte sequence.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers)
 */
interface Headers {
    guard: HeadersGuardEnum;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers/append) */
    append(name: string, value: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers/delete) */
    delete(name: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers/get) */
    get(name: string): string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers/getSetCookie) */
    getSetCookie(): string[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers/has) */
    has(name: string): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers/set) */
    set(name: string, value: string): void;
    forEach(callbackfn: (value: string, key: string, parent: Headers) => void, thisArg?: any): void;
}

declare var Headers: {
    prototype: Headers;
    new(init?: HeadersInit): Headers;
    isInstance(obj): obj is Headers;
};

interface HeapSnapshot {
    readonly creationTime: number | null;
    computeDominatorTree(): DominatorTree;
    computeShortestPaths(start: NodeId, targets: NodeId[], maxNumPaths: number): any;
    describeNode(breakdown: any, node: NodeId): any;
    takeCensus(options: any): any;
}

declare var HeapSnapshot: {
    prototype: HeapSnapshot;
    new(): HeapSnapshot;
    isInstance(obj): obj is HeapSnapshot;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Highlight) */
interface Highlight {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Highlight/priority) */
    priority: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Highlight/type) */
    type: HighlightType;
    forEach(callbackfn: (value: AbstractRange, key: AbstractRange, parent: Highlight) => void, thisArg?: any): void;
}

declare var Highlight: {
    prototype: Highlight;
    new(...initialRanges: AbstractRange[]): Highlight;
    isInstance(obj): obj is Highlight;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HighlightRegistry) */
interface HighlightRegistry {
    forEach(callbackfn: (value: Highlight, key: string, parent: HighlightRegistry) => void, thisArg?: any): void;
}

declare var HighlightRegistry: {
    prototype: HighlightRegistry;
    new(): HighlightRegistry;
    isInstance(obj): obj is HighlightRegistry;
};

/**
 * Allows manipulation of the browser session history, that is the pages visited in the tab or frame that the current page is loaded in.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/History)
 */
interface History {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/scrollRestoration) */
    scrollRestoration: ScrollRestoration;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/state) */
    readonly state: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/back) */
    back(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/forward) */
    forward(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/go) */
    go(delta?: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/pushState) */
    pushState(data: any, title: string, url?: string | null): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/replaceState) */
    replaceState(data: any, title: string, url?: string | null): void;
}

declare var History: {
    prototype: History;
    new(): History;
    isInstance(obj): obj is History;
};

/**
 * This IndexedDB API interface represents a cursor for traversing or iterating over multiple records in a database.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor)
 */
interface IDBCursor {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/direction) */
    readonly direction: IDBCursorDirection;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/key) */
    readonly key: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/primaryKey) */
    readonly primaryKey: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/request) */
    readonly request: IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/source) */
    readonly source: IDBObjectStore | IDBIndex;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/advance) */
    advance(count: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/continue) */
    continue(key?: any): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/continuePrimaryKey) */
    continuePrimaryKey(key: any, primaryKey: any): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/delete) */
    delete(): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/update) */
    update(value: any): IDBRequest;
}

declare var IDBCursor: {
    prototype: IDBCursor;
    new(): IDBCursor;
    isInstance(obj): obj is IDBCursor;
};

/**
 * This IndexedDB API interface represents a cursor for traversing or iterating over multiple records in a database. It is the same as the IDBCursor, except that it includes the value property.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursorWithValue)
 */
interface IDBCursorWithValue extends IDBCursor {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursorWithValue/value) */
    readonly value: any;
}

declare var IDBCursorWithValue: {
    prototype: IDBCursorWithValue;
    new(): IDBCursorWithValue;
    isInstance(obj): obj is IDBCursorWithValue;
};

interface IDBDatabaseEventMap {
    "abort": Event;
    "close": Event;
    "error": ErrorEvent;
    "versionchange": Event;
}

/**
 * This IndexedDB API interface provides a connection to a database; you can use an IDBDatabase object to open a transaction on your database then create, manipulate, and delete objects (data) in that database. The interface provides the only way to get and manage versions of the database.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase)
 */
interface IDBDatabase extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/name) */
    readonly name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/objectStoreNames) */
    readonly objectStoreNames: DOMStringList;
    onabort: ((this: IDBDatabase, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/close_event) */
    onclose: ((this: IDBDatabase, ev: Event) => any) | null;
    onerror: OnErrorEventHandler;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/versionchange_event) */
    onversionchange: ((this: IDBDatabase, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/version) */
    readonly version: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/close) */
    close(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/createObjectStore) */
    createObjectStore(name: string, options?: IDBObjectStoreParameters): IDBObjectStore;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/deleteObjectStore) */
    deleteObjectStore(name: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/transaction) */
    transaction(storeNames: string | string[], mode?: IDBTransactionMode): IDBTransaction;
    addEventListener<K extends keyof IDBDatabaseEventMap>(type: K, listener: (this: IDBDatabase, ev: IDBDatabaseEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof IDBDatabaseEventMap>(type: K, listener: (this: IDBDatabase, ev: IDBDatabaseEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var IDBDatabase: {
    prototype: IDBDatabase;
    new(): IDBDatabase;
    isInstance(obj): obj is IDBDatabase;
};

/**
 * In the following code snippet, we make a request to open a database, and include handlers for the success and error cases. For a full working example, see our To-do Notifications app (view example live.)
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBFactory)
 */
interface IDBFactory {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBFactory/cmp) */
    cmp(first: any, second: any): number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBFactory/deleteDatabase) */
    deleteDatabase(name: string): IDBOpenDBRequest;
    deleteForPrincipal(principal: Principal, name: string, options?: IDBOpenDBOptions): IDBOpenDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBFactory/open) */
    open(name: string, version?: number): IDBOpenDBRequest;
    openForPrincipal(principal: Principal, name: string, version: number): IDBOpenDBRequest;
    openForPrincipal(principal: Principal, name: string, options?: IDBOpenDBOptions): IDBOpenDBRequest;
}

declare var IDBFactory: {
    prototype: IDBFactory;
    new(): IDBFactory;
    isInstance(obj): obj is IDBFactory;
};

/**
 * IDBIndex interface of the IndexedDB API provides asynchronous access to an index in a database. An index is a kind of object store for looking up records in another object store, called the referenced object store. You use this interface to retrieve data.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex)
 */
interface IDBIndex {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/isAutoLocale) */
    readonly isAutoLocale: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/keyPath) */
    readonly keyPath: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/locale) */
    readonly locale: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/multiEntry) */
    readonly multiEntry: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/name) */
    name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/objectStore) */
    readonly objectStore: IDBObjectStore;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/unique) */
    readonly unique: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/count) */
    count(query?: any): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/get) */
    get(query: any): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/getAll) */
    getAll(query?: any, count?: number): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/getAllKeys) */
    getAllKeys(query?: any, count?: number): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/getKey) */
    getKey(query: any): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/openCursor) */
    openCursor(query?: any, direction?: IDBCursorDirection): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/openKeyCursor) */
    openKeyCursor(query?: any, direction?: IDBCursorDirection): IDBRequest;
}

declare var IDBIndex: {
    prototype: IDBIndex;
    new(): IDBIndex;
    isInstance(obj): obj is IDBIndex;
};

/**
 * A key range can be a single value or a range with upper and lower bounds or endpoints. If the key range has both upper and lower bounds, then it is bounded; if it has no bounds, it is unbounded. A bounded key range can either be open (the endpoints are excluded) or closed (the endpoints are included). To retrieve all keys within a certain range, you can use the following code constructs:
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange)
 */
interface IDBKeyRange {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/lower) */
    readonly lower: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/lowerOpen) */
    readonly lowerOpen: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/upper) */
    readonly upper: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/upperOpen) */
    readonly upperOpen: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/includes) */
    includes(key: any): boolean;
}

declare var IDBKeyRange: {
    prototype: IDBKeyRange;
    new(): IDBKeyRange;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/bound_static) */
    bound(lower: any, upper: any, lowerOpen?: boolean, upperOpen?: boolean): IDBKeyRange;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/lowerBound_static) */
    lowerBound(lower: any, open?: boolean): IDBKeyRange;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/only_static) */
    only(value: any): IDBKeyRange;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/upperBound_static) */
    upperBound(upper: any, open?: boolean): IDBKeyRange;
    isInstance(obj): obj is IDBKeyRange;
};

/**
 * This example shows a variety of different uses of object stores, from updating the data structure with IDBObjectStore.createIndex inside an onupgradeneeded function, to adding a new item to our object store with IDBObjectStore.add. For a full working example, see our To-do Notifications app (view example live.)
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore)
 */
interface IDBObjectStore {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/autoIncrement) */
    readonly autoIncrement: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/indexNames) */
    readonly indexNames: DOMStringList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/keyPath) */
    readonly keyPath: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/name) */
    name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/transaction) */
    readonly transaction: IDBTransaction;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/add) */
    add(value: any, key?: any): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/clear) */
    clear(): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/count) */
    count(key?: any): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/createIndex) */
    createIndex(name: string, keyPath: string | string[], optionalParameters?: IDBIndexParameters): IDBIndex;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/delete) */
    delete(key: any): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/deleteIndex) */
    deleteIndex(indexName: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/get) */
    get(key: any): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/getAll) */
    getAll(query?: any, count?: number): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/getAllKeys) */
    getAllKeys(query?: any, count?: number): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/getKey) */
    getKey(key: any): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/index) */
    index(name: string): IDBIndex;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/openCursor) */
    openCursor(range?: any, direction?: IDBCursorDirection): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/openKeyCursor) */
    openKeyCursor(query?: any, direction?: IDBCursorDirection): IDBRequest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/put) */
    put(value: any, key?: any): IDBRequest;
}

declare var IDBObjectStore: {
    prototype: IDBObjectStore;
    new(): IDBObjectStore;
    isInstance(obj): obj is IDBObjectStore;
};

interface IDBOpenDBRequestEventMap extends IDBRequestEventMap {
    "blocked": Event;
    "upgradeneeded": Event;
}

/**
 * Also inherits methods from its parents IDBRequest and EventTarget.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBOpenDBRequest)
 */
interface IDBOpenDBRequest extends IDBRequest {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBOpenDBRequest/blocked_event) */
    onblocked: ((this: IDBOpenDBRequest, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBOpenDBRequest/upgradeneeded_event) */
    onupgradeneeded: ((this: IDBOpenDBRequest, ev: Event) => any) | null;
    addEventListener<K extends keyof IDBOpenDBRequestEventMap>(type: K, listener: (this: IDBOpenDBRequest, ev: IDBOpenDBRequestEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof IDBOpenDBRequestEventMap>(type: K, listener: (this: IDBOpenDBRequest, ev: IDBOpenDBRequestEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var IDBOpenDBRequest: {
    prototype: IDBOpenDBRequest;
    new(): IDBOpenDBRequest;
    isInstance(obj): obj is IDBOpenDBRequest;
};

interface IDBRequestEventMap {
    "error": ErrorEvent;
    "success": Event;
}

/**
 * The request object does not initially contain any information about the result of the operation, but once information becomes available, an event is fired on the request, and the information becomes available through the properties of the IDBRequest instance.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest)
 */
interface IDBRequest extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/error) */
    "error": ErrorEvent;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/error_event) */
    onerror: OnErrorEventHandler;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/success_event) */
    onsuccess: ((this: IDBRequest, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/readyState) */
    readonly readyState: IDBRequestReadyState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/result) */
    readonly result: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/source) */
    readonly source: IDBObjectStore | IDBIndex | IDBCursor | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/transaction) */
    readonly transaction: IDBTransaction | null;
    addEventListener<K extends keyof IDBRequestEventMap>(type: K, listener: (this: IDBRequest, ev: IDBRequestEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof IDBRequestEventMap>(type: K, listener: (this: IDBRequest, ev: IDBRequestEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var IDBRequest: {
    prototype: IDBRequest;
    new(): IDBRequest;
    isInstance(obj): obj is IDBRequest;
};

interface IDBTransactionEventMap {
    "abort": Event;
    "complete": Event;
    "error": ErrorEvent;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction) */
interface IDBTransaction extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/db) */
    readonly db: IDBDatabase;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/error) */
    "error": ErrorEvent;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/mode) */
    readonly mode: IDBTransactionMode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/objectStoreNames) */
    readonly objectStoreNames: DOMStringList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/abort_event) */
    onabort: ((this: IDBTransaction, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/complete_event) */
    oncomplete: ((this: IDBTransaction, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/error_event) */
    onerror: OnErrorEventHandler;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/abort) */
    abort(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/commit) */
    commit(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/objectStore) */
    objectStore(name: string): IDBObjectStore;
    addEventListener<K extends keyof IDBTransactionEventMap>(type: K, listener: (this: IDBTransaction, ev: IDBTransactionEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof IDBTransactionEventMap>(type: K, listener: (this: IDBTransaction, ev: IDBTransactionEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var IDBTransaction: {
    prototype: IDBTransaction;
    new(): IDBTransaction;
    isInstance(obj): obj is IDBTransaction;
};

/**
 * This IndexedDB API interface indicates that the version of the database has changed, as the result of an IDBOpenDBRequest.onupgradeneeded event handler function.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBVersionChangeEvent)
 */
interface IDBVersionChangeEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBVersionChangeEvent/newVersion) */
    readonly newVersion: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBVersionChangeEvent/oldVersion) */
    readonly oldVersion: number;
}

declare var IDBVersionChangeEvent: {
    prototype: IDBVersionChangeEvent;
    new(type: string, eventInitDict?: IDBVersionChangeEventInit): IDBVersionChangeEvent;
    isInstance(obj): obj is IDBVersionChangeEvent;
};

/**
 * The IIRFilterNode interface of the Web Audio API is a AudioNode processor which implements a general infinite impulse response (IIR)  filter; this type of filter can be used to implement tone control devices and graphic equalizers as well. It lets the parameters of the filter response be specified, so that it can be tuned as needed.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IIRFilterNode)
 */
interface IIRFilterNode extends AudioNode, AudioNodePassThrough {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IIRFilterNode/getFrequencyResponse) */
    getFrequencyResponse(frequencyHz: Float32Array, magResponse: Float32Array, phaseResponse: Float32Array): void;
}

declare var IIRFilterNode: {
    prototype: IIRFilterNode;
    new(context: BaseAudioContext, options: IIRFilterOptions): IIRFilterNode;
    isInstance(obj): obj is IIRFilterNode;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IdentityCredential)
 */
interface IdentityCredential extends Credential {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IdentityCredential/token) */
    readonly token: string | null;
}

declare var IdentityCredential: {
    prototype: IdentityCredential;
    new(): IdentityCredential;
    logoutRPs(logoutRequests: IdentityCredentialLogoutRPsRequest[]): Promise<void>;
    isInstance(obj): obj is IdentityCredential;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IdleDeadline) */
interface IdleDeadline {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IdleDeadline/didTimeout) */
    readonly didTimeout: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IdleDeadline/timeRemaining) */
    timeRemaining(): DOMHighResTimeStamp;
}

declare var IdleDeadline: {
    prototype: IdleDeadline;
    new(): IdleDeadline;
    isInstance(obj): obj is IdleDeadline;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmap) */
interface ImageBitmap {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmap/height) */
    readonly height: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmap/width) */
    readonly width: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmap/close) */
    close(): void;
}

declare var ImageBitmap: {
    prototype: ImageBitmap;
    new(): ImageBitmap;
    isInstance(obj): obj is ImageBitmap;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmapRenderingContext) */
interface ImageBitmapRenderingContext {
    readonly canvas: CanvasSource | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmapRenderingContext/transferFromImageBitmap) */
    transferFromImageBitmap(bitmap: ImageBitmap | null): void;
    /**
     * @deprecated This is a legacy alias of `transferFromImageBitmap`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmapRenderingContext/transferFromImageBitmap)
     */
    transferImageBitmap(bitmap: ImageBitmap): void;
}

declare var ImageBitmapRenderingContext: {
    prototype: ImageBitmapRenderingContext;
    new(): ImageBitmapRenderingContext;
    isInstance(obj): obj is ImageBitmapRenderingContext;
};

interface ImageCaptureEventMap {
    "error": ErrorEvent;
    "photo": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageCapture) */
interface ImageCapture extends EventTarget {
    onerror: OnErrorEventHandler;
    onphoto: ((this: ImageCapture, ev: Event) => any) | null;
    /**
     * @deprecated This is a legacy alias of `track`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageCapture/track)
     */
    readonly videoStreamTrack: MediaStreamTrack;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageCapture/takePhoto) */
    takePhoto(): void;
    addEventListener<K extends keyof ImageCaptureEventMap>(type: K, listener: (this: ImageCapture, ev: ImageCaptureEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof ImageCaptureEventMap>(type: K, listener: (this: ImageCapture, ev: ImageCaptureEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var ImageCapture: {
    prototype: ImageCapture;
    new(track: MediaStreamTrack): ImageCapture;
    isInstance(obj): obj is ImageCapture;
};

interface ImageCaptureError {
    readonly code: number;
    readonly message: string;
    readonly FRAME_GRAB_ERROR: 1;
    readonly SETTINGS_ERROR: 2;
    readonly PHOTO_ERROR: 3;
    readonly ERROR_UNKNOWN: 4;
}

interface ImageCaptureErrorEvent extends Event {
    readonly imageCaptureError: ImageCaptureError | null;
}

declare var ImageCaptureErrorEvent: {
    prototype: ImageCaptureErrorEvent;
    new(type: string, imageCaptureErrorInitDict?: ImageCaptureErrorEventInit): ImageCaptureErrorEvent;
    isInstance(obj): obj is ImageCaptureErrorEvent;
};

/**
 * The underlying pixel data of an area of a <canvas> element. It is created using the ImageData() constructor or creator methods on the CanvasRenderingContext2D object associated with a canvas: createImageData() and getImageData(). It can also be used to set a part of the canvas by using putImageData().
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageData)
 */
interface ImageData {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageData/data) */
    readonly data: Uint8ClampedArray;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageData/height) */
    readonly height: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageData/width) */
    readonly width: number;
}

declare var ImageData: {
    prototype: ImageData;
    new(sw: number, sh: number): ImageData;
    new(data: Uint8ClampedArray, sw: number, sh?: number): ImageData;
    isInstance(obj): obj is ImageData;
};

interface ImageDocument extends HTMLDocument {
    readonly imageIsOverflowing: boolean;
    readonly imageIsResized: boolean;
    restoreImage(): void;
    shrinkToFit(): void;
    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: ImageDocument, ev: DocumentEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: ImageDocument, ev: DocumentEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var ImageDocument: {
    prototype: ImageDocument;
    new(): ImageDocument;
    isInstance(obj): obj is ImageDocument;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputEvent) */
interface InputEvent extends UIEvent {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputEvent/data) */
    readonly data: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputEvent/dataTransfer) */
    readonly dataTransfer: DataTransfer | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputEvent/inputType) */
    readonly inputType: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputEvent/isComposing) */
    readonly isComposing: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputEvent/getTargetRanges) */
    getTargetRanges(): StaticRange[];
}

declare var InputEvent: {
    prototype: InputEvent;
    new(type: string, eventInitDict?: InputEventInit): InputEvent;
    isInstance(obj): obj is InputEvent;
};

interface InspectorFontFace {
    readonly CSSFamilyName: string;
    readonly CSSGeneric: string;
    readonly URI: string;
    readonly format: string;
    readonly fromFontGroup: boolean;
    readonly fromLanguagePrefs: boolean;
    readonly fromSystemFallback: boolean;
    readonly localName: string;
    readonly metadata: string;
    readonly name: string;
    readonly ranges: Range[];
    readonly rule: CSSFontFaceRule | null;
    readonly srcIndex: number;
    getFeatures(): InspectorFontFeature[];
    getVariationAxes(): InspectorVariationAxis[];
    getVariationInstances(): InspectorVariationInstance[];
}

declare var InspectorFontFace: {
    prototype: InspectorFontFace;
    new(): InspectorFontFace;
    isInstance(obj): obj is InspectorFontFace;
};

interface InstallTriggerImpl {
    enabled(): boolean;
    install(installs: Record<string, string | InstallTriggerData>, callback?: InstallTriggerCallback): boolean;
    installChrome(type: number, url: string, skin: string): boolean;
    startSoftwareUpdate(url: string, flags?: number): boolean;
    updateEnabled(): boolean;
    readonly SKIN: 1;
    readonly LOCALE: 2;
    readonly CONTENT: 4;
    readonly PACKAGE: 7;
}

declare var InstallTriggerImpl: {
    prototype: InstallTriggerImpl;
    new(): InstallTriggerImpl;
    readonly SKIN: 1;
    readonly LOCALE: 2;
    readonly CONTENT: 4;
    readonly PACKAGE: 7;
    isInstance(obj): obj is InstallTriggerImpl;
};

/**
 * provides a way to asynchronously observe changes in the intersection of a target element with an ancestor element or with a top-level document's viewport.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver)
 */
interface IntersectionObserver {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/root) */
    readonly root: Node | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/rootMargin) */
    readonly rootMargin: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/thresholds) */
    readonly thresholds: number[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/disconnect) */
    disconnect(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/observe) */
    observe(target: Element): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/takeRecords) */
    takeRecords(): IntersectionObserverEntry[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/unobserve) */
    unobserve(target: Element): void;
}

declare var IntersectionObserver: {
    prototype: IntersectionObserver;
    new(intersectionCallback: IntersectionCallback, options?: IntersectionObserverInit): IntersectionObserver;
    isInstance(obj): obj is IntersectionObserver;
};

/**
 * This Intersection Observer API interface describes the intersection between the target element and its root container at a specific moment of transition.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry)
 */
interface IntersectionObserverEntry {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/boundingClientRect) */
    readonly boundingClientRect: DOMRectReadOnly;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/intersectionRatio) */
    readonly intersectionRatio: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/intersectionRect) */
    readonly intersectionRect: DOMRectReadOnly;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/isIntersecting) */
    readonly isIntersecting: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/rootBounds) */
    readonly rootBounds: DOMRectReadOnly | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/target) */
    readonly target: Element;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/time) */
    readonly time: DOMHighResTimeStamp;
}

declare var IntersectionObserverEntry: {
    prototype: IntersectionObserverEntry;
    new(): IntersectionObserverEntry;
    isInstance(obj): obj is IntersectionObserverEntry;
};

interface IntlUtils {
    getDisplayNames(locales: string[], options?: DisplayNameOptions): DisplayNameResult;
    isAppLocaleRTL(): boolean;
}

interface InvokeEvent extends Event {
    readonly action: string;
    readonly invoker: Element | null;
}

declare var InvokeEvent: {
    prototype: InvokeEvent;
    new(type: string, eventInitDict?: InvokeEventInit): InvokeEvent;
    isInstance(obj): obj is InvokeEvent;
};

interface InvokerElement {
    invokeAction: string;
    invokeTargetElement: Element | null;
}

interface JSActor {
    readonly name: UTF8String;
    sendAsyncMessage(messageName: string, obj?: any, transferables?: any): void;
    sendQuery(messageName: string, obj?: any): Promise<any>;
}

interface JSProcessActorChild extends JSActor {
    readonly manager: nsIDOMProcessChild;
}

declare var JSProcessActorChild: {
    prototype: JSProcessActorChild;
    new(): JSProcessActorChild;
    isInstance(obj): obj is JSProcessActorChild;
};

interface JSProcessActorParent extends JSActor {
    readonly manager: nsIDOMProcessParent;
}

declare var JSProcessActorParent: {
    prototype: JSProcessActorParent;
    new(): JSProcessActorParent;
    isInstance(obj): obj is JSProcessActorParent;
};

interface JSWindowActorChild extends JSActor {
    readonly browsingContext: BrowsingContext | null;
    readonly contentWindow: WindowProxy | null;
    readonly docShell: nsIDocShell | null;
    readonly document: Document | null;
    readonly manager: WindowGlobalChild | null;
    readonly windowContext: WindowContext | null;
}

declare var JSWindowActorChild: {
    prototype: JSWindowActorChild;
    new(): JSWindowActorChild;
    isInstance(obj): obj is JSWindowActorChild;
};

interface JSWindowActorParent extends JSActor {
    readonly browsingContext: CanonicalBrowsingContext | null;
    readonly manager: WindowGlobalParent | null;
    readonly windowContext: WindowContext | null;
}

declare var JSWindowActorParent: {
    prototype: JSWindowActorParent;
    new(): JSWindowActorParent;
    isInstance(obj): obj is JSWindowActorParent;
};

interface KeyEvent extends KeyEventMixin {
}

declare var KeyEvent: {
    prototype: KeyEvent;
    new(): KeyEvent;
    readonly DOM_VK_CANCEL: 0x03;
    readonly DOM_VK_HELP: 0x06;
    readonly DOM_VK_BACK_SPACE: 0x08;
    readonly DOM_VK_TAB: 0x09;
    readonly DOM_VK_CLEAR: 0x0C;
    readonly DOM_VK_RETURN: 0x0D;
    readonly DOM_VK_SHIFT: 0x10;
    readonly DOM_VK_CONTROL: 0x11;
    readonly DOM_VK_ALT: 0x12;
    readonly DOM_VK_PAUSE: 0x13;
    readonly DOM_VK_CAPS_LOCK: 0x14;
    readonly DOM_VK_KANA: 0x15;
    readonly DOM_VK_HANGUL: 0x15;
    readonly DOM_VK_EISU: 0x16;
    readonly DOM_VK_JUNJA: 0x17;
    readonly DOM_VK_FINAL: 0x18;
    readonly DOM_VK_HANJA: 0x19;
    readonly DOM_VK_KANJI: 0x19;
    readonly DOM_VK_ESCAPE: 0x1B;
    readonly DOM_VK_CONVERT: 0x1C;
    readonly DOM_VK_NONCONVERT: 0x1D;
    readonly DOM_VK_ACCEPT: 0x1E;
    readonly DOM_VK_MODECHANGE: 0x1F;
    readonly DOM_VK_SPACE: 0x20;
    readonly DOM_VK_PAGE_UP: 0x21;
    readonly DOM_VK_PAGE_DOWN: 0x22;
    readonly DOM_VK_END: 0x23;
    readonly DOM_VK_HOME: 0x24;
    readonly DOM_VK_LEFT: 0x25;
    readonly DOM_VK_UP: 0x26;
    readonly DOM_VK_RIGHT: 0x27;
    readonly DOM_VK_DOWN: 0x28;
    readonly DOM_VK_SELECT: 0x29;
    readonly DOM_VK_PRINT: 0x2A;
    readonly DOM_VK_EXECUTE: 0x2B;
    readonly DOM_VK_PRINTSCREEN: 0x2C;
    readonly DOM_VK_INSERT: 0x2D;
    readonly DOM_VK_DELETE: 0x2E;
    readonly DOM_VK_0: 0x30;
    readonly DOM_VK_1: 0x31;
    readonly DOM_VK_2: 0x32;
    readonly DOM_VK_3: 0x33;
    readonly DOM_VK_4: 0x34;
    readonly DOM_VK_5: 0x35;
    readonly DOM_VK_6: 0x36;
    readonly DOM_VK_7: 0x37;
    readonly DOM_VK_8: 0x38;
    readonly DOM_VK_9: 0x39;
    readonly DOM_VK_COLON: 0x3A;
    readonly DOM_VK_SEMICOLON: 0x3B;
    readonly DOM_VK_LESS_THAN: 0x3C;
    readonly DOM_VK_EQUALS: 0x3D;
    readonly DOM_VK_GREATER_THAN: 0x3E;
    readonly DOM_VK_QUESTION_MARK: 0x3F;
    readonly DOM_VK_AT: 0x40;
    readonly DOM_VK_A: 0x41;
    readonly DOM_VK_B: 0x42;
    readonly DOM_VK_C: 0x43;
    readonly DOM_VK_D: 0x44;
    readonly DOM_VK_E: 0x45;
    readonly DOM_VK_F: 0x46;
    readonly DOM_VK_G: 0x47;
    readonly DOM_VK_H: 0x48;
    readonly DOM_VK_I: 0x49;
    readonly DOM_VK_J: 0x4A;
    readonly DOM_VK_K: 0x4B;
    readonly DOM_VK_L: 0x4C;
    readonly DOM_VK_M: 0x4D;
    readonly DOM_VK_N: 0x4E;
    readonly DOM_VK_O: 0x4F;
    readonly DOM_VK_P: 0x50;
    readonly DOM_VK_Q: 0x51;
    readonly DOM_VK_R: 0x52;
    readonly DOM_VK_S: 0x53;
    readonly DOM_VK_T: 0x54;
    readonly DOM_VK_U: 0x55;
    readonly DOM_VK_V: 0x56;
    readonly DOM_VK_W: 0x57;
    readonly DOM_VK_X: 0x58;
    readonly DOM_VK_Y: 0x59;
    readonly DOM_VK_Z: 0x5A;
    readonly DOM_VK_WIN: 0x5B;
    readonly DOM_VK_CONTEXT_MENU: 0x5D;
    readonly DOM_VK_SLEEP: 0x5F;
    readonly DOM_VK_NUMPAD0: 0x60;
    readonly DOM_VK_NUMPAD1: 0x61;
    readonly DOM_VK_NUMPAD2: 0x62;
    readonly DOM_VK_NUMPAD3: 0x63;
    readonly DOM_VK_NUMPAD4: 0x64;
    readonly DOM_VK_NUMPAD5: 0x65;
    readonly DOM_VK_NUMPAD6: 0x66;
    readonly DOM_VK_NUMPAD7: 0x67;
    readonly DOM_VK_NUMPAD8: 0x68;
    readonly DOM_VK_NUMPAD9: 0x69;
    readonly DOM_VK_MULTIPLY: 0x6A;
    readonly DOM_VK_ADD: 0x6B;
    readonly DOM_VK_SEPARATOR: 0x6C;
    readonly DOM_VK_SUBTRACT: 0x6D;
    readonly DOM_VK_DECIMAL: 0x6E;
    readonly DOM_VK_DIVIDE: 0x6F;
    readonly DOM_VK_F1: 0x70;
    readonly DOM_VK_F2: 0x71;
    readonly DOM_VK_F3: 0x72;
    readonly DOM_VK_F4: 0x73;
    readonly DOM_VK_F5: 0x74;
    readonly DOM_VK_F6: 0x75;
    readonly DOM_VK_F7: 0x76;
    readonly DOM_VK_F8: 0x77;
    readonly DOM_VK_F9: 0x78;
    readonly DOM_VK_F10: 0x79;
    readonly DOM_VK_F11: 0x7A;
    readonly DOM_VK_F12: 0x7B;
    readonly DOM_VK_F13: 0x7C;
    readonly DOM_VK_F14: 0x7D;
    readonly DOM_VK_F15: 0x7E;
    readonly DOM_VK_F16: 0x7F;
    readonly DOM_VK_F17: 0x80;
    readonly DOM_VK_F18: 0x81;
    readonly DOM_VK_F19: 0x82;
    readonly DOM_VK_F20: 0x83;
    readonly DOM_VK_F21: 0x84;
    readonly DOM_VK_F22: 0x85;
    readonly DOM_VK_F23: 0x86;
    readonly DOM_VK_F24: 0x87;
    readonly DOM_VK_NUM_LOCK: 0x90;
    readonly DOM_VK_SCROLL_LOCK: 0x91;
    readonly DOM_VK_WIN_OEM_FJ_JISHO: 0x92;
    readonly DOM_VK_WIN_OEM_FJ_MASSHOU: 0x93;
    readonly DOM_VK_WIN_OEM_FJ_TOUROKU: 0x94;
    readonly DOM_VK_WIN_OEM_FJ_LOYA: 0x95;
    readonly DOM_VK_WIN_OEM_FJ_ROYA: 0x96;
    readonly DOM_VK_CIRCUMFLEX: 0xA0;
    readonly DOM_VK_EXCLAMATION: 0xA1;
    readonly DOM_VK_DOUBLE_QUOTE: 0xA2;
    readonly DOM_VK_HASH: 0xA3;
    readonly DOM_VK_DOLLAR: 0xA4;
    readonly DOM_VK_PERCENT: 0xA5;
    readonly DOM_VK_AMPERSAND: 0xA6;
    readonly DOM_VK_UNDERSCORE: 0xA7;
    readonly DOM_VK_OPEN_PAREN: 0xA8;
    readonly DOM_VK_CLOSE_PAREN: 0xA9;
    readonly DOM_VK_ASTERISK: 0xAA;
    readonly DOM_VK_PLUS: 0xAB;
    readonly DOM_VK_PIPE: 0xAC;
    readonly DOM_VK_HYPHEN_MINUS: 0xAD;
    readonly DOM_VK_OPEN_CURLY_BRACKET: 0xAE;
    readonly DOM_VK_CLOSE_CURLY_BRACKET: 0xAF;
    readonly DOM_VK_TILDE: 0xB0;
    readonly DOM_VK_VOLUME_MUTE: 0xB5;
    readonly DOM_VK_VOLUME_DOWN: 0xB6;
    readonly DOM_VK_VOLUME_UP: 0xB7;
    readonly DOM_VK_COMMA: 0xBC;
    readonly DOM_VK_PERIOD: 0xBE;
    readonly DOM_VK_SLASH: 0xBF;
    readonly DOM_VK_BACK_QUOTE: 0xC0;
    readonly DOM_VK_OPEN_BRACKET: 0xDB;
    readonly DOM_VK_BACK_SLASH: 0xDC;
    readonly DOM_VK_CLOSE_BRACKET: 0xDD;
    readonly DOM_VK_QUOTE: 0xDE;
    readonly DOM_VK_META: 0xE0;
    readonly DOM_VK_ALTGR: 0xE1;
    readonly DOM_VK_WIN_ICO_HELP: 0xE3;
    readonly DOM_VK_WIN_ICO_00: 0xE4;
    readonly DOM_VK_PROCESSKEY: 0xE5;
    readonly DOM_VK_WIN_ICO_CLEAR: 0xE6;
    readonly DOM_VK_WIN_OEM_RESET: 0xE9;
    readonly DOM_VK_WIN_OEM_JUMP: 0xEA;
    readonly DOM_VK_WIN_OEM_PA1: 0xEB;
    readonly DOM_VK_WIN_OEM_PA2: 0xEC;
    readonly DOM_VK_WIN_OEM_PA3: 0xED;
    readonly DOM_VK_WIN_OEM_WSCTRL: 0xEE;
    readonly DOM_VK_WIN_OEM_CUSEL: 0xEF;
    readonly DOM_VK_WIN_OEM_ATTN: 0xF0;
    readonly DOM_VK_WIN_OEM_FINISH: 0xF1;
    readonly DOM_VK_WIN_OEM_COPY: 0xF2;
    readonly DOM_VK_WIN_OEM_AUTO: 0xF3;
    readonly DOM_VK_WIN_OEM_ENLW: 0xF4;
    readonly DOM_VK_WIN_OEM_BACKTAB: 0xF5;
    readonly DOM_VK_ATTN: 0xF6;
    readonly DOM_VK_CRSEL: 0xF7;
    readonly DOM_VK_EXSEL: 0xF8;
    readonly DOM_VK_EREOF: 0xF9;
    readonly DOM_VK_PLAY: 0xFA;
    readonly DOM_VK_ZOOM: 0xFB;
    readonly DOM_VK_PA1: 0xFD;
    readonly DOM_VK_WIN_OEM_CLEAR: 0xFE;
    isInstance(obj): obj is KeyEvent;
};

interface KeyEventMixin {
    initKeyEvent(type: string, canBubble?: boolean, cancelable?: boolean, view?: Window | null, ctrlKey?: boolean, altKey?: boolean, shiftKey?: boolean, metaKey?: boolean, keyCode?: number, charCode?: number): void;
    readonly DOM_VK_CANCEL: 0x03;
    readonly DOM_VK_HELP: 0x06;
    readonly DOM_VK_BACK_SPACE: 0x08;
    readonly DOM_VK_TAB: 0x09;
    readonly DOM_VK_CLEAR: 0x0C;
    readonly DOM_VK_RETURN: 0x0D;
    readonly DOM_VK_SHIFT: 0x10;
    readonly DOM_VK_CONTROL: 0x11;
    readonly DOM_VK_ALT: 0x12;
    readonly DOM_VK_PAUSE: 0x13;
    readonly DOM_VK_CAPS_LOCK: 0x14;
    readonly DOM_VK_KANA: 0x15;
    readonly DOM_VK_HANGUL: 0x15;
    readonly DOM_VK_EISU: 0x16;
    readonly DOM_VK_JUNJA: 0x17;
    readonly DOM_VK_FINAL: 0x18;
    readonly DOM_VK_HANJA: 0x19;
    readonly DOM_VK_KANJI: 0x19;
    readonly DOM_VK_ESCAPE: 0x1B;
    readonly DOM_VK_CONVERT: 0x1C;
    readonly DOM_VK_NONCONVERT: 0x1D;
    readonly DOM_VK_ACCEPT: 0x1E;
    readonly DOM_VK_MODECHANGE: 0x1F;
    readonly DOM_VK_SPACE: 0x20;
    readonly DOM_VK_PAGE_UP: 0x21;
    readonly DOM_VK_PAGE_DOWN: 0x22;
    readonly DOM_VK_END: 0x23;
    readonly DOM_VK_HOME: 0x24;
    readonly DOM_VK_LEFT: 0x25;
    readonly DOM_VK_UP: 0x26;
    readonly DOM_VK_RIGHT: 0x27;
    readonly DOM_VK_DOWN: 0x28;
    readonly DOM_VK_SELECT: 0x29;
    readonly DOM_VK_PRINT: 0x2A;
    readonly DOM_VK_EXECUTE: 0x2B;
    readonly DOM_VK_PRINTSCREEN: 0x2C;
    readonly DOM_VK_INSERT: 0x2D;
    readonly DOM_VK_DELETE: 0x2E;
    readonly DOM_VK_0: 0x30;
    readonly DOM_VK_1: 0x31;
    readonly DOM_VK_2: 0x32;
    readonly DOM_VK_3: 0x33;
    readonly DOM_VK_4: 0x34;
    readonly DOM_VK_5: 0x35;
    readonly DOM_VK_6: 0x36;
    readonly DOM_VK_7: 0x37;
    readonly DOM_VK_8: 0x38;
    readonly DOM_VK_9: 0x39;
    readonly DOM_VK_COLON: 0x3A;
    readonly DOM_VK_SEMICOLON: 0x3B;
    readonly DOM_VK_LESS_THAN: 0x3C;
    readonly DOM_VK_EQUALS: 0x3D;
    readonly DOM_VK_GREATER_THAN: 0x3E;
    readonly DOM_VK_QUESTION_MARK: 0x3F;
    readonly DOM_VK_AT: 0x40;
    readonly DOM_VK_A: 0x41;
    readonly DOM_VK_B: 0x42;
    readonly DOM_VK_C: 0x43;
    readonly DOM_VK_D: 0x44;
    readonly DOM_VK_E: 0x45;
    readonly DOM_VK_F: 0x46;
    readonly DOM_VK_G: 0x47;
    readonly DOM_VK_H: 0x48;
    readonly DOM_VK_I: 0x49;
    readonly DOM_VK_J: 0x4A;
    readonly DOM_VK_K: 0x4B;
    readonly DOM_VK_L: 0x4C;
    readonly DOM_VK_M: 0x4D;
    readonly DOM_VK_N: 0x4E;
    readonly DOM_VK_O: 0x4F;
    readonly DOM_VK_P: 0x50;
    readonly DOM_VK_Q: 0x51;
    readonly DOM_VK_R: 0x52;
    readonly DOM_VK_S: 0x53;
    readonly DOM_VK_T: 0x54;
    readonly DOM_VK_U: 0x55;
    readonly DOM_VK_V: 0x56;
    readonly DOM_VK_W: 0x57;
    readonly DOM_VK_X: 0x58;
    readonly DOM_VK_Y: 0x59;
    readonly DOM_VK_Z: 0x5A;
    readonly DOM_VK_WIN: 0x5B;
    readonly DOM_VK_CONTEXT_MENU: 0x5D;
    readonly DOM_VK_SLEEP: 0x5F;
    readonly DOM_VK_NUMPAD0: 0x60;
    readonly DOM_VK_NUMPAD1: 0x61;
    readonly DOM_VK_NUMPAD2: 0x62;
    readonly DOM_VK_NUMPAD3: 0x63;
    readonly DOM_VK_NUMPAD4: 0x64;
    readonly DOM_VK_NUMPAD5: 0x65;
    readonly DOM_VK_NUMPAD6: 0x66;
    readonly DOM_VK_NUMPAD7: 0x67;
    readonly DOM_VK_NUMPAD8: 0x68;
    readonly DOM_VK_NUMPAD9: 0x69;
    readonly DOM_VK_MULTIPLY: 0x6A;
    readonly DOM_VK_ADD: 0x6B;
    readonly DOM_VK_SEPARATOR: 0x6C;
    readonly DOM_VK_SUBTRACT: 0x6D;
    readonly DOM_VK_DECIMAL: 0x6E;
    readonly DOM_VK_DIVIDE: 0x6F;
    readonly DOM_VK_F1: 0x70;
    readonly DOM_VK_F2: 0x71;
    readonly DOM_VK_F3: 0x72;
    readonly DOM_VK_F4: 0x73;
    readonly DOM_VK_F5: 0x74;
    readonly DOM_VK_F6: 0x75;
    readonly DOM_VK_F7: 0x76;
    readonly DOM_VK_F8: 0x77;
    readonly DOM_VK_F9: 0x78;
    readonly DOM_VK_F10: 0x79;
    readonly DOM_VK_F11: 0x7A;
    readonly DOM_VK_F12: 0x7B;
    readonly DOM_VK_F13: 0x7C;
    readonly DOM_VK_F14: 0x7D;
    readonly DOM_VK_F15: 0x7E;
    readonly DOM_VK_F16: 0x7F;
    readonly DOM_VK_F17: 0x80;
    readonly DOM_VK_F18: 0x81;
    readonly DOM_VK_F19: 0x82;
    readonly DOM_VK_F20: 0x83;
    readonly DOM_VK_F21: 0x84;
    readonly DOM_VK_F22: 0x85;
    readonly DOM_VK_F23: 0x86;
    readonly DOM_VK_F24: 0x87;
    readonly DOM_VK_NUM_LOCK: 0x90;
    readonly DOM_VK_SCROLL_LOCK: 0x91;
    readonly DOM_VK_WIN_OEM_FJ_JISHO: 0x92;
    readonly DOM_VK_WIN_OEM_FJ_MASSHOU: 0x93;
    readonly DOM_VK_WIN_OEM_FJ_TOUROKU: 0x94;
    readonly DOM_VK_WIN_OEM_FJ_LOYA: 0x95;
    readonly DOM_VK_WIN_OEM_FJ_ROYA: 0x96;
    readonly DOM_VK_CIRCUMFLEX: 0xA0;
    readonly DOM_VK_EXCLAMATION: 0xA1;
    readonly DOM_VK_DOUBLE_QUOTE: 0xA2;
    readonly DOM_VK_HASH: 0xA3;
    readonly DOM_VK_DOLLAR: 0xA4;
    readonly DOM_VK_PERCENT: 0xA5;
    readonly DOM_VK_AMPERSAND: 0xA6;
    readonly DOM_VK_UNDERSCORE: 0xA7;
    readonly DOM_VK_OPEN_PAREN: 0xA8;
    readonly DOM_VK_CLOSE_PAREN: 0xA9;
    readonly DOM_VK_ASTERISK: 0xAA;
    readonly DOM_VK_PLUS: 0xAB;
    readonly DOM_VK_PIPE: 0xAC;
    readonly DOM_VK_HYPHEN_MINUS: 0xAD;
    readonly DOM_VK_OPEN_CURLY_BRACKET: 0xAE;
    readonly DOM_VK_CLOSE_CURLY_BRACKET: 0xAF;
    readonly DOM_VK_TILDE: 0xB0;
    readonly DOM_VK_VOLUME_MUTE: 0xB5;
    readonly DOM_VK_VOLUME_DOWN: 0xB6;
    readonly DOM_VK_VOLUME_UP: 0xB7;
    readonly DOM_VK_COMMA: 0xBC;
    readonly DOM_VK_PERIOD: 0xBE;
    readonly DOM_VK_SLASH: 0xBF;
    readonly DOM_VK_BACK_QUOTE: 0xC0;
    readonly DOM_VK_OPEN_BRACKET: 0xDB;
    readonly DOM_VK_BACK_SLASH: 0xDC;
    readonly DOM_VK_CLOSE_BRACKET: 0xDD;
    readonly DOM_VK_QUOTE: 0xDE;
    readonly DOM_VK_META: 0xE0;
    readonly DOM_VK_ALTGR: 0xE1;
    readonly DOM_VK_WIN_ICO_HELP: 0xE3;
    readonly DOM_VK_WIN_ICO_00: 0xE4;
    readonly DOM_VK_PROCESSKEY: 0xE5;
    readonly DOM_VK_WIN_ICO_CLEAR: 0xE6;
    readonly DOM_VK_WIN_OEM_RESET: 0xE9;
    readonly DOM_VK_WIN_OEM_JUMP: 0xEA;
    readonly DOM_VK_WIN_OEM_PA1: 0xEB;
    readonly DOM_VK_WIN_OEM_PA2: 0xEC;
    readonly DOM_VK_WIN_OEM_PA3: 0xED;
    readonly DOM_VK_WIN_OEM_WSCTRL: 0xEE;
    readonly DOM_VK_WIN_OEM_CUSEL: 0xEF;
    readonly DOM_VK_WIN_OEM_ATTN: 0xF0;
    readonly DOM_VK_WIN_OEM_FINISH: 0xF1;
    readonly DOM_VK_WIN_OEM_COPY: 0xF2;
    readonly DOM_VK_WIN_OEM_AUTO: 0xF3;
    readonly DOM_VK_WIN_OEM_ENLW: 0xF4;
    readonly DOM_VK_WIN_OEM_BACKTAB: 0xF5;
    readonly DOM_VK_ATTN: 0xF6;
    readonly DOM_VK_CRSEL: 0xF7;
    readonly DOM_VK_EXSEL: 0xF8;
    readonly DOM_VK_EREOF: 0xF9;
    readonly DOM_VK_PLAY: 0xFA;
    readonly DOM_VK_ZOOM: 0xFB;
    readonly DOM_VK_PA1: 0xFD;
    readonly DOM_VK_WIN_OEM_CLEAR: 0xFE;
}

/**
 * KeyboardEvent objects describe a user interaction with the keyboard; each event describes a single interaction between the user and a key (or combination of a key with modifier keys) on the keyboard.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent)
 */
interface KeyboardEvent extends UIEvent, KeyEventMixin {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/altKey) */
    readonly altKey: boolean;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/charCode)
     */
    readonly charCode: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/code) */
    readonly code: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/ctrlKey) */
    readonly ctrlKey: boolean;
    readonly initDict: KeyboardEventInit;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/isComposing) */
    readonly isComposing: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/key) */
    readonly key: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/keyCode)
     */
    readonly keyCode: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/location) */
    readonly location: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/metaKey) */
    readonly metaKey: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/repeat) */
    readonly repeat: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/shiftKey) */
    readonly shiftKey: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/getModifierState) */
    getModifierState(key: string): boolean;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/initKeyboardEvent)
     */
    initKeyboardEvent(typeArg: string, bubblesArg?: boolean, cancelableArg?: boolean, viewArg?: Window | null, keyArg?: string, locationArg?: number, ctrlKey?: boolean, altKey?: boolean, shiftKey?: boolean, metaKey?: boolean): void;
    readonly DOM_KEY_LOCATION_STANDARD: 0x00;
    readonly DOM_KEY_LOCATION_LEFT: 0x01;
    readonly DOM_KEY_LOCATION_RIGHT: 0x02;
    readonly DOM_KEY_LOCATION_NUMPAD: 0x03;
}

declare var KeyboardEvent: {
    prototype: KeyboardEvent;
    new(typeArg: string, keyboardEventInitDict?: KeyboardEventInit): KeyboardEvent;
    readonly DOM_KEY_LOCATION_STANDARD: 0x00;
    readonly DOM_KEY_LOCATION_LEFT: 0x01;
    readonly DOM_KEY_LOCATION_RIGHT: 0x02;
    readonly DOM_KEY_LOCATION_NUMPAD: 0x03;
    readonly DOM_VK_CANCEL: 0x03;
    readonly DOM_VK_HELP: 0x06;
    readonly DOM_VK_BACK_SPACE: 0x08;
    readonly DOM_VK_TAB: 0x09;
    readonly DOM_VK_CLEAR: 0x0C;
    readonly DOM_VK_RETURN: 0x0D;
    readonly DOM_VK_SHIFT: 0x10;
    readonly DOM_VK_CONTROL: 0x11;
    readonly DOM_VK_ALT: 0x12;
    readonly DOM_VK_PAUSE: 0x13;
    readonly DOM_VK_CAPS_LOCK: 0x14;
    readonly DOM_VK_KANA: 0x15;
    readonly DOM_VK_HANGUL: 0x15;
    readonly DOM_VK_EISU: 0x16;
    readonly DOM_VK_JUNJA: 0x17;
    readonly DOM_VK_FINAL: 0x18;
    readonly DOM_VK_HANJA: 0x19;
    readonly DOM_VK_KANJI: 0x19;
    readonly DOM_VK_ESCAPE: 0x1B;
    readonly DOM_VK_CONVERT: 0x1C;
    readonly DOM_VK_NONCONVERT: 0x1D;
    readonly DOM_VK_ACCEPT: 0x1E;
    readonly DOM_VK_MODECHANGE: 0x1F;
    readonly DOM_VK_SPACE: 0x20;
    readonly DOM_VK_PAGE_UP: 0x21;
    readonly DOM_VK_PAGE_DOWN: 0x22;
    readonly DOM_VK_END: 0x23;
    readonly DOM_VK_HOME: 0x24;
    readonly DOM_VK_LEFT: 0x25;
    readonly DOM_VK_UP: 0x26;
    readonly DOM_VK_RIGHT: 0x27;
    readonly DOM_VK_DOWN: 0x28;
    readonly DOM_VK_SELECT: 0x29;
    readonly DOM_VK_PRINT: 0x2A;
    readonly DOM_VK_EXECUTE: 0x2B;
    readonly DOM_VK_PRINTSCREEN: 0x2C;
    readonly DOM_VK_INSERT: 0x2D;
    readonly DOM_VK_DELETE: 0x2E;
    readonly DOM_VK_0: 0x30;
    readonly DOM_VK_1: 0x31;
    readonly DOM_VK_2: 0x32;
    readonly DOM_VK_3: 0x33;
    readonly DOM_VK_4: 0x34;
    readonly DOM_VK_5: 0x35;
    readonly DOM_VK_6: 0x36;
    readonly DOM_VK_7: 0x37;
    readonly DOM_VK_8: 0x38;
    readonly DOM_VK_9: 0x39;
    readonly DOM_VK_COLON: 0x3A;
    readonly DOM_VK_SEMICOLON: 0x3B;
    readonly DOM_VK_LESS_THAN: 0x3C;
    readonly DOM_VK_EQUALS: 0x3D;
    readonly DOM_VK_GREATER_THAN: 0x3E;
    readonly DOM_VK_QUESTION_MARK: 0x3F;
    readonly DOM_VK_AT: 0x40;
    readonly DOM_VK_A: 0x41;
    readonly DOM_VK_B: 0x42;
    readonly DOM_VK_C: 0x43;
    readonly DOM_VK_D: 0x44;
    readonly DOM_VK_E: 0x45;
    readonly DOM_VK_F: 0x46;
    readonly DOM_VK_G: 0x47;
    readonly DOM_VK_H: 0x48;
    readonly DOM_VK_I: 0x49;
    readonly DOM_VK_J: 0x4A;
    readonly DOM_VK_K: 0x4B;
    readonly DOM_VK_L: 0x4C;
    readonly DOM_VK_M: 0x4D;
    readonly DOM_VK_N: 0x4E;
    readonly DOM_VK_O: 0x4F;
    readonly DOM_VK_P: 0x50;
    readonly DOM_VK_Q: 0x51;
    readonly DOM_VK_R: 0x52;
    readonly DOM_VK_S: 0x53;
    readonly DOM_VK_T: 0x54;
    readonly DOM_VK_U: 0x55;
    readonly DOM_VK_V: 0x56;
    readonly DOM_VK_W: 0x57;
    readonly DOM_VK_X: 0x58;
    readonly DOM_VK_Y: 0x59;
    readonly DOM_VK_Z: 0x5A;
    readonly DOM_VK_WIN: 0x5B;
    readonly DOM_VK_CONTEXT_MENU: 0x5D;
    readonly DOM_VK_SLEEP: 0x5F;
    readonly DOM_VK_NUMPAD0: 0x60;
    readonly DOM_VK_NUMPAD1: 0x61;
    readonly DOM_VK_NUMPAD2: 0x62;
    readonly DOM_VK_NUMPAD3: 0x63;
    readonly DOM_VK_NUMPAD4: 0x64;
    readonly DOM_VK_NUMPAD5: 0x65;
    readonly DOM_VK_NUMPAD6: 0x66;
    readonly DOM_VK_NUMPAD7: 0x67;
    readonly DOM_VK_NUMPAD8: 0x68;
    readonly DOM_VK_NUMPAD9: 0x69;
    readonly DOM_VK_MULTIPLY: 0x6A;
    readonly DOM_VK_ADD: 0x6B;
    readonly DOM_VK_SEPARATOR: 0x6C;
    readonly DOM_VK_SUBTRACT: 0x6D;
    readonly DOM_VK_DECIMAL: 0x6E;
    readonly DOM_VK_DIVIDE: 0x6F;
    readonly DOM_VK_F1: 0x70;
    readonly DOM_VK_F2: 0x71;
    readonly DOM_VK_F3: 0x72;
    readonly DOM_VK_F4: 0x73;
    readonly DOM_VK_F5: 0x74;
    readonly DOM_VK_F6: 0x75;
    readonly DOM_VK_F7: 0x76;
    readonly DOM_VK_F8: 0x77;
    readonly DOM_VK_F9: 0x78;
    readonly DOM_VK_F10: 0x79;
    readonly DOM_VK_F11: 0x7A;
    readonly DOM_VK_F12: 0x7B;
    readonly DOM_VK_F13: 0x7C;
    readonly DOM_VK_F14: 0x7D;
    readonly DOM_VK_F15: 0x7E;
    readonly DOM_VK_F16: 0x7F;
    readonly DOM_VK_F17: 0x80;
    readonly DOM_VK_F18: 0x81;
    readonly DOM_VK_F19: 0x82;
    readonly DOM_VK_F20: 0x83;
    readonly DOM_VK_F21: 0x84;
    readonly DOM_VK_F22: 0x85;
    readonly DOM_VK_F23: 0x86;
    readonly DOM_VK_F24: 0x87;
    readonly DOM_VK_NUM_LOCK: 0x90;
    readonly DOM_VK_SCROLL_LOCK: 0x91;
    readonly DOM_VK_WIN_OEM_FJ_JISHO: 0x92;
    readonly DOM_VK_WIN_OEM_FJ_MASSHOU: 0x93;
    readonly DOM_VK_WIN_OEM_FJ_TOUROKU: 0x94;
    readonly DOM_VK_WIN_OEM_FJ_LOYA: 0x95;
    readonly DOM_VK_WIN_OEM_FJ_ROYA: 0x96;
    readonly DOM_VK_CIRCUMFLEX: 0xA0;
    readonly DOM_VK_EXCLAMATION: 0xA1;
    readonly DOM_VK_DOUBLE_QUOTE: 0xA2;
    readonly DOM_VK_HASH: 0xA3;
    readonly DOM_VK_DOLLAR: 0xA4;
    readonly DOM_VK_PERCENT: 0xA5;
    readonly DOM_VK_AMPERSAND: 0xA6;
    readonly DOM_VK_UNDERSCORE: 0xA7;
    readonly DOM_VK_OPEN_PAREN: 0xA8;
    readonly DOM_VK_CLOSE_PAREN: 0xA9;
    readonly DOM_VK_ASTERISK: 0xAA;
    readonly DOM_VK_PLUS: 0xAB;
    readonly DOM_VK_PIPE: 0xAC;
    readonly DOM_VK_HYPHEN_MINUS: 0xAD;
    readonly DOM_VK_OPEN_CURLY_BRACKET: 0xAE;
    readonly DOM_VK_CLOSE_CURLY_BRACKET: 0xAF;
    readonly DOM_VK_TILDE: 0xB0;
    readonly DOM_VK_VOLUME_MUTE: 0xB5;
    readonly DOM_VK_VOLUME_DOWN: 0xB6;
    readonly DOM_VK_VOLUME_UP: 0xB7;
    readonly DOM_VK_COMMA: 0xBC;
    readonly DOM_VK_PERIOD: 0xBE;
    readonly DOM_VK_SLASH: 0xBF;
    readonly DOM_VK_BACK_QUOTE: 0xC0;
    readonly DOM_VK_OPEN_BRACKET: 0xDB;
    readonly DOM_VK_BACK_SLASH: 0xDC;
    readonly DOM_VK_CLOSE_BRACKET: 0xDD;
    readonly DOM_VK_QUOTE: 0xDE;
    readonly DOM_VK_META: 0xE0;
    readonly DOM_VK_ALTGR: 0xE1;
    readonly DOM_VK_WIN_ICO_HELP: 0xE3;
    readonly DOM_VK_WIN_ICO_00: 0xE4;
    readonly DOM_VK_PROCESSKEY: 0xE5;
    readonly DOM_VK_WIN_ICO_CLEAR: 0xE6;
    readonly DOM_VK_WIN_OEM_RESET: 0xE9;
    readonly DOM_VK_WIN_OEM_JUMP: 0xEA;
    readonly DOM_VK_WIN_OEM_PA1: 0xEB;
    readonly DOM_VK_WIN_OEM_PA2: 0xEC;
    readonly DOM_VK_WIN_OEM_PA3: 0xED;
    readonly DOM_VK_WIN_OEM_WSCTRL: 0xEE;
    readonly DOM_VK_WIN_OEM_CUSEL: 0xEF;
    readonly DOM_VK_WIN_OEM_ATTN: 0xF0;
    readonly DOM_VK_WIN_OEM_FINISH: 0xF1;
    readonly DOM_VK_WIN_OEM_COPY: 0xF2;
    readonly DOM_VK_WIN_OEM_AUTO: 0xF3;
    readonly DOM_VK_WIN_OEM_ENLW: 0xF4;
    readonly DOM_VK_WIN_OEM_BACKTAB: 0xF5;
    readonly DOM_VK_ATTN: 0xF6;
    readonly DOM_VK_CRSEL: 0xF7;
    readonly DOM_VK_EXSEL: 0xF8;
    readonly DOM_VK_EREOF: 0xF9;
    readonly DOM_VK_PLAY: 0xFA;
    readonly DOM_VK_ZOOM: 0xFB;
    readonly DOM_VK_PA1: 0xFD;
    readonly DOM_VK_WIN_OEM_CLEAR: 0xFE;
    isInstance(obj): obj is KeyboardEvent;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect) */
interface KeyframeEffect extends AnimationEffect {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect/composite) */
    composite: CompositeOperation;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect/iterationComposite) */
    iterationComposite: IterationCompositeOperation;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect/pseudoElement) */
    pseudoElement: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect/target) */
    target: Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect/getKeyframes) */
    getKeyframes(): any[];
    getProperties(): AnimationPropertyDetails[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect/setKeyframes) */
    setKeyframes(keyframes: any): void;
}

declare var KeyframeEffect: {
    prototype: KeyframeEffect;
    new(target: Element | null, keyframes: any, options?: number | KeyframeEffectOptions): KeyframeEffect;
    new(source: KeyframeEffect): KeyframeEffect;
    isInstance(obj): obj is KeyframeEffect;
};

interface L10nFileSource {
    readonly index: UTF8String[] | null;
    readonly locales: UTF8String[];
    readonly metaSource: UTF8String;
    readonly name: UTF8String;
    readonly prePath: UTF8String;
    fetchFile(locale: UTF8String, path: UTF8String): Promise<FluentResource | null>;
    fetchFileSync(locale: UTF8String, path: UTF8String): FluentResource | null;
    hasFile(locale: UTF8String, path: UTF8String): L10nFileSourceHasFileStatus;
}

declare var L10nFileSource: {
    prototype: L10nFileSource;
    new(name: UTF8String, metaSource: UTF8String, locales: UTF8String[], prePath: UTF8String, options?: FileSourceOptions, index?: UTF8String[]): L10nFileSource;
    createMock(name: UTF8String, metasource: UTF8String, locales: UTF8String[], prePath: UTF8String, fs: L10nFileSourceMockFile[]): L10nFileSource;
    isInstance(obj): obj is L10nFileSource;
};

interface L10nRegistry {
    clearSources(): void;
    generateBundles(aLocales: UTF8String[], aResourceIds: L10nResourceId[]): FluentBundleAsyncIterator;
    generateBundlesSync(aLocales: UTF8String[], aResourceIds: L10nResourceId[]): FluentBundleIterator;
    getAvailableLocales(): UTF8String[];
    getSource(aName: UTF8String): L10nFileSource | null;
    getSourceNames(): UTF8String[];
    hasSource(aName: UTF8String): boolean;
    registerSources(aSources: L10nFileSource[]): void;
    removeSources(aSources: UTF8String[]): void;
    updateSources(aSources: L10nFileSource[]): void;
}

declare var L10nRegistry: {
    prototype: L10nRegistry;
    new(aOptions?: L10nRegistryOptions): L10nRegistry;
    getInstance(): L10nRegistry;
    isInstance(obj): obj is L10nRegistry;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint) */
interface LargestContentfulPaint extends PerformanceEntry {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/element) */
    readonly element: Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/id) */
    readonly id: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/loadTime) */
    readonly loadTime: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/renderTime) */
    readonly renderTime: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/size) */
    readonly size: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/url) */
    readonly url: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/toJSON) */
    toJSON(): any;
}

declare var LargestContentfulPaint: {
    prototype: LargestContentfulPaint;
    new(): LargestContentfulPaint;
    isInstance(obj): obj is LargestContentfulPaint;
};

interface LegacyMozTCPSocket {
    listen(port: number, options?: ServerSocketOptions, backlog?: number): TCPServerSocket;
    open(host: string, port: number, options?: SocketOptions): TCPSocket;
}

interface LinkStyle {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/sheet) */
    readonly sheet: StyleSheet | null;
}

interface LoadContextMixin {
    readonly associatedWindow: WindowProxy | null;
    readonly isContent: boolean;
    readonly originAttributes: any;
    readonly topFrameElement: Element | null;
    readonly topWindow: WindowProxy | null;
    usePrivateBrowsing: boolean;
    readonly useRemoteSubframes: boolean;
    readonly useRemoteTabs: boolean;
    useTrackingProtection: boolean;
}

interface Localization {
    addResourceIds(aResourceIds: L10nResourceId[]): void;
    formatMessages(aKeys: L10nKey[]): Promise<(L10nMessage | null)[]>;
    formatMessagesSync(aKeys: L10nKey[]): (L10nMessage | null)[];
    formatValue(aId: UTF8String, aArgs?: L10nArgs): Promise<UTF8String | null>;
    formatValueSync(aId: UTF8String, aArgs?: L10nArgs): UTF8String | null;
    formatValues(aKeys: L10nKey[]): Promise<(UTF8String | null)[]>;
    formatValuesSync(aKeys: L10nKey[]): (UTF8String | null)[];
    removeResourceIds(aResourceIds: L10nResourceId[]): number;
    setAsync(): void;
}

declare var Localization: {
    prototype: Localization;
    new(aResourceIds: L10nResourceId[], aSync?: boolean, aRegistry?: L10nRegistry, aLocales?: UTF8String[]): Localization;
    isInstance(obj): obj is Localization;
};

/**
 * The location (URL) of the object it is linked to. Changes done on it are reflected on the object it relates to. Both the Document and Window interface have such a linked Location, accessible via Document.location and Window.location respectively.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location)
 */
interface Location {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/hash) */
    hash: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/host) */
    host: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/hostname) */
    hostname: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/href) */
    href: string;
    toString(): string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/origin) */
    readonly origin: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/pathname) */
    pathname: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/port) */
    port: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/protocol) */
    protocol: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/search) */
    search: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/assign) */
    assign(url: string | URL): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/reload) */
    reload(forceget?: boolean): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/replace) */
    replace(url: string | URL): void;
}

declare var Location: {
    prototype: Location;
    new(): Location;
    isInstance(obj): obj is Location;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Lock)
 */
interface Lock {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Lock/mode) */
    readonly mode: LockMode;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Lock/name) */
    readonly name: string;
}

declare var Lock: {
    prototype: Lock;
    new(): Lock;
    isInstance(obj): obj is Lock;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/LockManager)
 */
interface LockManager {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/LockManager/query) */
    query(): Promise<LockManagerSnapshot>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/LockManager/request) */
    request(name: string, callback: LockGrantedCallback): Promise<any>;
    request(name: string, options: LockOptions, callback: LockGrantedCallback): Promise<any>;
}

declare var LockManager: {
    prototype: LockManager;
    new(): LockManager;
    isInstance(obj): obj is LockManager;
};

interface MIDIAccessEventMap {
    "statechange": Event;
}

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIAccess)
 */
interface MIDIAccess extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIAccess/inputs) */
    readonly inputs: MIDIInputMap;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIAccess/statechange_event) */
    onstatechange: ((this: MIDIAccess, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIAccess/outputs) */
    readonly outputs: MIDIOutputMap;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIAccess/sysexEnabled) */
    readonly sysexEnabled: boolean;
    addEventListener<K extends keyof MIDIAccessEventMap>(type: K, listener: (this: MIDIAccess, ev: MIDIAccessEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MIDIAccessEventMap>(type: K, listener: (this: MIDIAccess, ev: MIDIAccessEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var MIDIAccess: {
    prototype: MIDIAccess;
    new(): MIDIAccess;
    isInstance(obj): obj is MIDIAccess;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIConnectionEvent)
 */
interface MIDIConnectionEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIConnectionEvent/port) */
    readonly port: MIDIPort | null;
}

declare var MIDIConnectionEvent: {
    prototype: MIDIConnectionEvent;
    new(type: string, eventInitDict?: MIDIConnectionEventInit): MIDIConnectionEvent;
    isInstance(obj): obj is MIDIConnectionEvent;
};

interface MIDIInputEventMap extends MIDIPortEventMap {
    "midimessage": Event;
}

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIInput)
 */
interface MIDIInput extends MIDIPort {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIInput/midimessage_event) */
    onmidimessage: ((this: MIDIInput, ev: Event) => any) | null;
    addEventListener<K extends keyof MIDIInputEventMap>(type: K, listener: (this: MIDIInput, ev: MIDIInputEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MIDIInputEventMap>(type: K, listener: (this: MIDIInput, ev: MIDIInputEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var MIDIInput: {
    prototype: MIDIInput;
    new(): MIDIInput;
    isInstance(obj): obj is MIDIInput;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIInputMap)
 */
interface MIDIInputMap {
    forEach(callbackfn: (value: MIDIInput, key: string, parent: MIDIInputMap) => void, thisArg?: any): void;
}

declare var MIDIInputMap: {
    prototype: MIDIInputMap;
    new(): MIDIInputMap;
    isInstance(obj): obj is MIDIInputMap;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIMessageEvent)
 */
interface MIDIMessageEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIMessageEvent/data) */
    readonly data: Uint8Array;
}

declare var MIDIMessageEvent: {
    prototype: MIDIMessageEvent;
    new(type: string, eventInitDict?: MIDIMessageEventInit): MIDIMessageEvent;
    isInstance(obj): obj is MIDIMessageEvent;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIOutput)
 */
interface MIDIOutput extends MIDIPort {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIOutput/clear) */
    clear(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIOutput/send) */
    send(data: number[], timestamp?: DOMHighResTimeStamp): void;
    addEventListener<K extends keyof MIDIPortEventMap>(type: K, listener: (this: MIDIOutput, ev: MIDIPortEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MIDIPortEventMap>(type: K, listener: (this: MIDIOutput, ev: MIDIPortEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var MIDIOutput: {
    prototype: MIDIOutput;
    new(): MIDIOutput;
    isInstance(obj): obj is MIDIOutput;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIOutputMap)
 */
interface MIDIOutputMap {
    forEach(callbackfn: (value: MIDIOutput, key: string, parent: MIDIOutputMap) => void, thisArg?: any): void;
}

declare var MIDIOutputMap: {
    prototype: MIDIOutputMap;
    new(): MIDIOutputMap;
    isInstance(obj): obj is MIDIOutputMap;
};

interface MIDIPortEventMap {
    "statechange": Event;
}

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort)
 */
interface MIDIPort extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/connection) */
    readonly connection: MIDIPortConnectionState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/id) */
    readonly id: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/manufacturer) */
    readonly manufacturer: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/name) */
    readonly name: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/statechange_event) */
    onstatechange: ((this: MIDIPort, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/state) */
    readonly state: MIDIPortDeviceState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/type) */
    readonly type: MIDIPortType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/version) */
    readonly version: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/close) */
    close(): Promise<MIDIPort>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/open) */
    open(): Promise<MIDIPort>;
    addEventListener<K extends keyof MIDIPortEventMap>(type: K, listener: (this: MIDIPort, ev: MIDIPortEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MIDIPortEventMap>(type: K, listener: (this: MIDIPort, ev: MIDIPortEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var MIDIPort: {
    prototype: MIDIPort;
    new(): MIDIPort;
    isInstance(obj): obj is MIDIPort;
};

interface MOZ_debug {
    getParameter(pname: GLenum): any;
    readonly EXTENSIONS: 0x1F03;
    readonly WSI_INFO: 0x10000;
    readonly UNPACK_REQUIRE_FASTPATH: 0x10001;
    readonly DOES_INDEX_VALIDATION: 0x10002;
}

interface MatchGlob {
    readonly glob: UTF8String;
    matches(string: UTF8String): boolean;
}

declare var MatchGlob: {
    prototype: MatchGlob;
    new(glob: UTF8String, allowQuestion?: boolean): MatchGlob;
    isInstance(obj): obj is MatchGlob;
};

interface MatchPattern {
    readonly matchesAllWebUrls: boolean;
    readonly pattern: string;
    matches(uri: URI, explicit?: boolean): boolean;
    matches(url: string, explicit?: boolean): boolean;
    matchesCookie(cookie: Cookie): boolean;
    overlaps(pattern: MatchPattern): boolean;
    subsumes(pattern: MatchPattern): boolean;
    subsumesDomain(pattern: MatchPattern): boolean;
}

declare var MatchPattern: {
    prototype: MatchPattern;
    new(pattern: string, options?: MatchPatternOptions): MatchPattern;
    isInstance(obj): obj is MatchPattern;
};

interface MatchPatternSet {
    readonly matchesAllWebUrls: boolean;
    readonly patterns: MatchPattern[];
    matches(uri: URI, explicit?: boolean): boolean;
    matches(url: string, explicit?: boolean): boolean;
    matchesCookie(cookie: Cookie): boolean;
    overlaps(pattern: MatchPattern): boolean;
    overlaps(patternSet: MatchPatternSet): boolean;
    overlapsAll(patternSet: MatchPatternSet): boolean;
    subsumes(pattern: MatchPattern): boolean;
    subsumesDomain(pattern: MatchPattern): boolean;
}

declare var MatchPatternSet: {
    prototype: MatchPatternSet;
    new(patterns: (string | MatchPattern)[], options?: MatchPatternOptions): MatchPatternSet;
    isInstance(obj): obj is MatchPatternSet;
};

interface MathMLElementEventMap extends ElementEventMap, GlobalEventHandlersEventMap, OnErrorEventHandlerForNodesEventMap, TouchEventHandlersEventMap {
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MathMLElement) */
interface MathMLElement extends Element, ElementCSSInlineStyle, GlobalEventHandlers, HTMLOrForeignElement, OnErrorEventHandlerForNodes, TouchEventHandlers {
    addEventListener<K extends keyof MathMLElementEventMap>(type: K, listener: (this: MathMLElement, ev: MathMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MathMLElementEventMap>(type: K, listener: (this: MathMLElement, ev: MathMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var MathMLElement: {
    prototype: MathMLElement;
    new(): MathMLElement;
    isInstance(obj): obj is MathMLElement;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaCapabilities) */
interface MediaCapabilities {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaCapabilities/decodingInfo) */
    decodingInfo(configuration: MediaDecodingConfiguration): Promise<MediaCapabilitiesInfo>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaCapabilities/encodingInfo) */
    encodingInfo(configuration: MediaEncodingConfiguration): Promise<MediaCapabilitiesInfo>;
}

declare var MediaCapabilities: {
    prototype: MediaCapabilities;
    new(): MediaCapabilities;
    isInstance(obj): obj is MediaCapabilities;
};

interface MediaCapabilitiesInfo {
    readonly powerEfficient: boolean;
    readonly smooth: boolean;
    readonly supported: boolean;
}

declare var MediaCapabilitiesInfo: {
    prototype: MediaCapabilitiesInfo;
    new(): MediaCapabilitiesInfo;
    isInstance(obj): obj is MediaCapabilitiesInfo;
};

interface MediaControllerEventMap {
    "activated": Event;
    "deactivated": Event;
    "metadatachange": Event;
    "playbackstatechange": Event;
    "positionstatechange": Event;
    "supportedkeyschange": Event;
}

/** @deprecated */
interface MediaController extends EventTarget {
    readonly id: number;
    readonly isActive: boolean;
    readonly isAudible: boolean;
    readonly isPlaying: boolean;
    onactivated: ((this: MediaController, ev: Event) => any) | null;
    ondeactivated: ((this: MediaController, ev: Event) => any) | null;
    onmetadatachange: ((this: MediaController, ev: Event) => any) | null;
    onplaybackstatechange: ((this: MediaController, ev: Event) => any) | null;
    onpositionstatechange: ((this: MediaController, ev: Event) => any) | null;
    onsupportedkeyschange: ((this: MediaController, ev: Event) => any) | null;
    /** @deprecated */
    readonly playbackState: MediaSessionPlaybackState;
    readonly supportedKeys: MediaControlKey[];
    focus(): void;
    getMetadata(): MediaMetadataInit;
    nextTrack(): void;
    /** @deprecated */
    pause(): void;
    /** @deprecated */
    play(): void;
    prevTrack(): void;
    seekBackward(): void;
    seekForward(): void;
    seekTo(seekTime: number, fastSeek?: boolean): void;
    skipAd(): void;
    stop(): void;
    addEventListener<K extends keyof MediaControllerEventMap>(type: K, listener: (this: MediaController, ev: MediaControllerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MediaControllerEventMap>(type: K, listener: (this: MediaController, ev: MediaControllerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

/** @deprecated */
declare var MediaController: {
    prototype: MediaController;
    new(): MediaController;
    isInstance(obj): obj is MediaController;
};

/**
 * The MediaDevicesInfo interface contains information that describes a single media input or output device.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDeviceInfo)
 */
interface MediaDeviceInfo {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDeviceInfo/deviceId) */
    readonly deviceId: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDeviceInfo/groupId) */
    readonly groupId: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDeviceInfo/kind) */
    readonly kind: MediaDeviceKind;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDeviceInfo/label) */
    readonly label: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDeviceInfo/toJSON) */
    toJSON(): any;
}

declare var MediaDeviceInfo: {
    prototype: MediaDeviceInfo;
    new(): MediaDeviceInfo;
    isInstance(obj): obj is MediaDeviceInfo;
};

interface MediaDevicesEventMap {
    "devicechange": Event;
}

/**
 * Provides access to connected media input devices like cameras and microphones, as well as screen sharing. In essence, it lets you obtain access to any hardware source of media data.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDevices)
 */
interface MediaDevices extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDevices/devicechange_event) */
    ondevicechange: ((this: MediaDevices, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDevices/enumerateDevices) */
    enumerateDevices(): Promise<MediaDeviceInfo[]>;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDevices/getDisplayMedia)
     */
    getDisplayMedia(constraints?: DisplayMediaStreamConstraints): Promise<MediaStream>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDevices/getSupportedConstraints) */
    getSupportedConstraints(): MediaTrackSupportedConstraints;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDevices/getUserMedia) */
    getUserMedia(constraints?: MediaStreamConstraints): Promise<MediaStream>;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDevices/selectAudioOutput)
     */
    selectAudioOutput(options?: AudioOutputOptions): Promise<MediaDeviceInfo>;
    addEventListener<K extends keyof MediaDevicesEventMap>(type: K, listener: (this: MediaDevices, ev: MediaDevicesEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MediaDevicesEventMap>(type: K, listener: (this: MediaDevices, ev: MediaDevicesEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var MediaDevices: {
    prototype: MediaDevices;
    new(): MediaDevices;
    isInstance(obj): obj is MediaDevices;
};

/**
 * A MediaElementSourceNode has no inputs and exactly one output, and is created using the AudioContext.createMediaElementSource method. The amount of channels in the output equals the number of channels of the audio referenced by the HTMLMediaElement used in the creation of the node, or is 1 if the HTMLMediaElement has no audio.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaElementAudioSourceNode)
 */
interface MediaElementAudioSourceNode extends AudioNode, AudioNodePassThrough {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaElementAudioSourceNode/mediaElement) */
    readonly mediaElement: HTMLMediaElement;
}

declare var MediaElementAudioSourceNode: {
    prototype: MediaElementAudioSourceNode;
    new(context: AudioContext, options: MediaElementAudioSourceOptions): MediaElementAudioSourceNode;
    isInstance(obj): obj is MediaElementAudioSourceNode;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaEncryptedEvent) */
interface MediaEncryptedEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaEncryptedEvent/initData) */
    readonly initData: ArrayBuffer | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaEncryptedEvent/initDataType) */
    readonly initDataType: string;
}

declare var MediaEncryptedEvent: {
    prototype: MediaEncryptedEvent;
    new(type: string, eventInitDict?: MediaKeyNeededEventInit): MediaEncryptedEvent;
    isInstance(obj): obj is MediaEncryptedEvent;
};

/**
 * An error which occurred while handling media in an HTML media element based on HTMLMediaElement, such as <audio> or <video>.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaError)
 */
interface MediaError {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaError/code) */
    readonly code: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaError/message) */
    readonly message: string;
    readonly MEDIA_ERR_ABORTED: 1;
    readonly MEDIA_ERR_NETWORK: 2;
    readonly MEDIA_ERR_DECODE: 3;
    readonly MEDIA_ERR_SRC_NOT_SUPPORTED: 4;
}

declare var MediaError: {
    prototype: MediaError;
    new(): MediaError;
    readonly MEDIA_ERR_ABORTED: 1;
    readonly MEDIA_ERR_NETWORK: 2;
    readonly MEDIA_ERR_DECODE: 3;
    readonly MEDIA_ERR_SRC_NOT_SUPPORTED: 4;
    isInstance(obj): obj is MediaError;
};

interface MediaKeyError extends Event {
    readonly systemCode: number;
}

declare var MediaKeyError: {
    prototype: MediaKeyError;
    new(): MediaKeyError;
    isInstance(obj): obj is MediaKeyError;
};

/**
 * This EncryptedMediaExtensions API interface contains the content and related data when the content decryption module generates a message for the session.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyMessageEvent)
 */
interface MediaKeyMessageEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyMessageEvent/message) */
    readonly message: ArrayBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyMessageEvent/messageType) */
    readonly messageType: MediaKeyMessageType;
}

declare var MediaKeyMessageEvent: {
    prototype: MediaKeyMessageEvent;
    new(type: string, eventInitDict: MediaKeyMessageEventInit): MediaKeyMessageEvent;
    isInstance(obj): obj is MediaKeyMessageEvent;
};

interface MediaKeySessionEventMap {
    "keystatuseschange": Event;
    "message": Event;
}

/**
 * This EncryptedMediaExtensions API interface represents a context for message exchange with a content decryption module (CDM).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession)
 */
interface MediaKeySession extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/closed) */
    readonly closed: Promise<undefined>;
    "error": ErrorEvent;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/expiration) */
    readonly expiration: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/keyStatuses) */
    readonly keyStatuses: MediaKeyStatusMap;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/keystatuseschange_event) */
    onkeystatuseschange: ((this: MediaKeySession, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/message_event) */
    onmessage: ((this: MediaKeySession, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/sessionId) */
    readonly sessionId: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/close) */
    close(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/generateRequest) */
    generateRequest(initDataType: string, initData: BufferSource): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/load) */
    load(sessionId: string): Promise<boolean>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/remove) */
    remove(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/update) */
    update(response: BufferSource): Promise<void>;
    addEventListener<K extends keyof MediaKeySessionEventMap>(type: K, listener: (this: MediaKeySession, ev: MediaKeySessionEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MediaKeySessionEventMap>(type: K, listener: (this: MediaKeySession, ev: MediaKeySessionEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var MediaKeySession: {
    prototype: MediaKeySession;
    new(): MediaKeySession;
    isInstance(obj): obj is MediaKeySession;
};

/**
 * This EncryptedMediaExtensions API interface is a read-only map of media key statuses by key IDs.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyStatusMap)
 */
interface MediaKeyStatusMap {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyStatusMap/size) */
    readonly size: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyStatusMap/get) */
    get(keyId: BufferSource): MediaKeyStatus | undefined;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyStatusMap/has) */
    has(keyId: BufferSource): boolean;
    forEach(callbackfn: (value: MediaKeyStatus, key: ArrayBuffer, parent: MediaKeyStatusMap) => void, thisArg?: any): void;
}

declare var MediaKeyStatusMap: {
    prototype: MediaKeyStatusMap;
    new(): MediaKeyStatusMap;
    isInstance(obj): obj is MediaKeyStatusMap;
};

/**
 * This EncryptedMediaExtensions API interface provides access to a Key System for decryption and/or a content protection provider. You can request an instance of this object using the Navigator.requestMediaKeySystemAccess method.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySystemAccess)
 */
interface MediaKeySystemAccess {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySystemAccess/keySystem) */
    readonly keySystem: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySystemAccess/createMediaKeys) */
    createMediaKeys(): Promise<MediaKeys>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySystemAccess/getConfiguration) */
    getConfiguration(): MediaKeySystemConfiguration;
}

declare var MediaKeySystemAccess: {
    prototype: MediaKeySystemAccess;
    new(): MediaKeySystemAccess;
    isInstance(obj): obj is MediaKeySystemAccess;
};

/**
 * This EncryptedMediaExtensions API interface the represents a set of keys that an associated HTMLMediaElement can use for decryption of media data during playback.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeys)
 */
interface MediaKeys {
    readonly keySystem: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeys/createSession) */
    createSession(sessionType?: MediaKeySessionType): MediaKeySession;
    getStatusForPolicy(policy?: MediaKeysPolicy): Promise<MediaKeyStatus>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeys/setServerCertificate) */
    setServerCertificate(serverCertificate: BufferSource): Promise<void>;
}

declare var MediaKeys: {
    prototype: MediaKeys;
    new(): MediaKeys;
    isInstance(obj): obj is MediaKeys;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaList) */
interface MediaList {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaList/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaList/mediaText) */
    mediaText: UTF8String;
    toString(): string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaList/appendMedium) */
    appendMedium(newMedium: UTF8String): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaList/deleteMedium) */
    deleteMedium(oldMedium: UTF8String): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaList/item) */
    item(index: number): UTF8String | null;
    [index: number]: UTF8String;
}

declare var MediaList: {
    prototype: MediaList;
    new(): MediaList;
    isInstance(obj): obj is MediaList;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaMetadata) */
interface MediaMetadata {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaMetadata/album) */
    album: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaMetadata/artist) */
    artist: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaMetadata/artwork) */
    artwork: any[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaMetadata/title) */
    title: string;
}

declare var MediaMetadata: {
    prototype: MediaMetadata;
    new(init?: MediaMetadataInit): MediaMetadata;
    isInstance(obj): obj is MediaMetadata;
};

interface MediaQueryListEventMap {
    "change": Event;
}

/**
 * Stores information on a media query applied to a document, and handles sending notifications to listeners when the media query state change (i.e. when the media query test starts or stops evaluating to true).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryList)
 */
interface MediaQueryList extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryList/matches) */
    readonly matches: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryList/media) */
    readonly media: UTF8String;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryList/change_event) */
    onchange: ((this: MediaQueryList, ev: Event) => any) | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryList/addListener)
     */
    addListener(listener: EventListener | null): void;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryList/removeListener)
     */
    removeListener(listener: EventListener | null): void;
    addEventListener<K extends keyof MediaQueryListEventMap>(type: K, listener: (this: MediaQueryList, ev: MediaQueryListEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MediaQueryListEventMap>(type: K, listener: (this: MediaQueryList, ev: MediaQueryListEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var MediaQueryList: {
    prototype: MediaQueryList;
    new(): MediaQueryList;
    isInstance(obj): obj is MediaQueryList;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryListEvent) */
interface MediaQueryListEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryListEvent/matches) */
    readonly matches: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryListEvent/media) */
    readonly media: UTF8String;
}

declare var MediaQueryListEvent: {
    prototype: MediaQueryListEvent;
    new(type: string, eventInitDict?: MediaQueryListEventInit): MediaQueryListEvent;
    isInstance(obj): obj is MediaQueryListEvent;
};

interface MediaRecorderEventMap {
    "dataavailable": Event;
    "error": ErrorEvent;
    "pause": Event;
    "resume": Event;
    "start": Event;
    "stop": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder) */
interface MediaRecorder extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/audioBitsPerSecond) */
    readonly audioBitsPerSecond: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/mimeType) */
    readonly mimeType: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/dataavailable_event) */
    ondataavailable: ((this: MediaRecorder, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/error_event) */
    onerror: OnErrorEventHandler;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/pause_event) */
    onpause: ((this: MediaRecorder, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/resume_event) */
    onresume: ((this: MediaRecorder, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/start_event) */
    onstart: ((this: MediaRecorder, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/stop_event) */
    onstop: ((this: MediaRecorder, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/state) */
    readonly state: RecordingState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/stream) */
    readonly stream: MediaStream;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/videoBitsPerSecond) */
    readonly videoBitsPerSecond: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/pause) */
    pause(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/requestData) */
    requestData(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/resume) */
    resume(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/start) */
    start(timeslice?: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/stop) */
    stop(): void;
    addEventListener<K extends keyof MediaRecorderEventMap>(type: K, listener: (this: MediaRecorder, ev: MediaRecorderEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MediaRecorderEventMap>(type: K, listener: (this: MediaRecorder, ev: MediaRecorderEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var MediaRecorder: {
    prototype: MediaRecorder;
    new(stream: MediaStream, options?: MediaRecorderOptions): MediaRecorder;
    new(node: AudioNode, output?: number, options?: MediaRecorderOptions): MediaRecorder;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/isTypeSupported_static) */
    isTypeSupported(type: string): boolean;
    isInstance(obj): obj is MediaRecorder;
};

/**
 * @deprecated
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorderErrorEvent)
 */
interface MediaRecorderErrorEvent extends Event {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorderErrorEvent/error)
     */
    "error": ErrorEvent;
}

/** @deprecated */
declare var MediaRecorderErrorEvent: {
    prototype: MediaRecorderErrorEvent;
    new(type: string, eventInitDict: MediaRecorderErrorEventInit): MediaRecorderErrorEvent;
    isInstance(obj): obj is MediaRecorderErrorEvent;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSession) */
interface MediaSession {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSession/metadata) */
    metadata: MediaMetadata | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSession/playbackState) */
    playbackState: MediaSessionPlaybackState;
    notifyHandler(details: MediaSessionActionDetails): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSession/setActionHandler) */
    setActionHandler(action: MediaSessionAction, handler: MediaSessionActionHandler | null): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSession/setPositionState) */
    setPositionState(state?: MediaPositionState): void;
}

declare var MediaSession: {
    prototype: MediaSession;
    new(): MediaSession;
    isInstance(obj): obj is MediaSession;
};

interface MediaSourceEventMap {
    "sourceclose": Event;
    "sourceended": Event;
    "sourceopen": Event;
}

/**
 * This Media Source Extensions API interface represents a source of media data for an HTMLMediaElement object. A MediaSource object can be attached to a HTMLMediaElement to be played in the user agent.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource)
 */
interface MediaSource extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/activeSourceBuffers) */
    readonly activeSourceBuffers: SourceBufferList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/duration) */
    duration: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/sourceclose_event) */
    onsourceclose: ((this: MediaSource, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/sourceended_event) */
    onsourceended: ((this: MediaSource, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/sourceopen_event) */
    onsourceopen: ((this: MediaSource, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/readyState) */
    readonly readyState: MediaSourceReadyState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/sourceBuffers) */
    readonly sourceBuffers: SourceBufferList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/addSourceBuffer) */
    addSourceBuffer(type: string): SourceBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/clearLiveSeekableRange) */
    clearLiveSeekableRange(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/endOfStream) */
    endOfStream(error?: MediaSourceEndOfStreamError): void;
    mozDebugReaderData(): Promise<MediaSourceDecoderDebugInfo>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/removeSourceBuffer) */
    removeSourceBuffer(sourceBuffer: SourceBuffer): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/setLiveSeekableRange) */
    setLiveSeekableRange(start: number, end: number): void;
    addEventListener<K extends keyof MediaSourceEventMap>(type: K, listener: (this: MediaSource, ev: MediaSourceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MediaSourceEventMap>(type: K, listener: (this: MediaSource, ev: MediaSourceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var MediaSource: {
    prototype: MediaSource;
    new(): MediaSource;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/isTypeSupported_static) */
    isTypeSupported(type: string): boolean;
    isInstance(obj): obj is MediaSource;
};

interface MediaStreamEventMap {
    "addtrack": Event;
    "removetrack": Event;
}

/**
 * A stream of media content. A stream consists of several tracks such as video or audio tracks. Each track is specified as an instance of MediaStreamTrack.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream)
 */
interface MediaStream extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/active) */
    readonly active: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/id) */
    readonly id: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/addtrack_event) */
    onaddtrack: ((this: MediaStream, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/removetrack_event) */
    onremovetrack: ((this: MediaStream, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/addTrack) */
    addTrack(track: MediaStreamTrack): void;
    assignId(id: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/clone) */
    clone(): MediaStream;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/getAudioTracks) */
    getAudioTracks(): MediaStreamTrack[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/getTrackById) */
    getTrackById(trackId: string): MediaStreamTrack | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/getTracks) */
    getTracks(): MediaStreamTrack[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/getVideoTracks) */
    getVideoTracks(): MediaStreamTrack[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/removeTrack) */
    removeTrack(track: MediaStreamTrack): void;
    addEventListener<K extends keyof MediaStreamEventMap>(type: K, listener: (this: MediaStream, ev: MediaStreamEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MediaStreamEventMap>(type: K, listener: (this: MediaStream, ev: MediaStreamEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var MediaStream: {
    prototype: MediaStream;
    new(): MediaStream;
    new(stream: MediaStream): MediaStream;
    new(tracks: MediaStreamTrack[]): MediaStream;
    countUnderlyingStreams(): Promise<number>;
    isInstance(obj): obj is MediaStream;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamAudioDestinationNode) */
interface MediaStreamAudioDestinationNode extends AudioNode {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamAudioDestinationNode/stream) */
    readonly stream: MediaStream;
}

declare var MediaStreamAudioDestinationNode: {
    prototype: MediaStreamAudioDestinationNode;
    new(context: AudioContext, options?: AudioNodeOptions): MediaStreamAudioDestinationNode;
    isInstance(obj): obj is MediaStreamAudioDestinationNode;
};

/**
 * A type of AudioNode which operates as an audio source whose media is received from a MediaStream obtained using the WebRTC or Media Capture and Streams APIs.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamAudioSourceNode)
 */
interface MediaStreamAudioSourceNode extends AudioNode, AudioNodePassThrough {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamAudioSourceNode/mediaStream) */
    readonly mediaStream: MediaStream;
}

declare var MediaStreamAudioSourceNode: {
    prototype: MediaStreamAudioSourceNode;
    new(context: AudioContext, options: MediaStreamAudioSourceOptions): MediaStreamAudioSourceNode;
    isInstance(obj): obj is MediaStreamAudioSourceNode;
};

interface MediaStreamError {
    readonly constraint: string | null;
    readonly message: string | null;
    readonly name: string;
}

/**
 * Events that occurs in relation to a MediaStream. Two events of this type can be thrown: addstream and removestream.
 * @deprecated
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamEvent)
 */
interface MediaStreamEvent extends Event {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamEvent/stream)
     */
    readonly stream: MediaStream | null;
}

/** @deprecated */
declare var MediaStreamEvent: {
    prototype: MediaStreamEvent;
    new(type: string, eventInitDict?: MediaStreamEventInit): MediaStreamEvent;
    isInstance(obj): obj is MediaStreamEvent;
};

interface MediaStreamTrackEventMap {
    "ended": Event;
    "mute": Event;
    "unmute": Event;
}

/**
 * A single media track within a stream; typically, these are audio or video tracks, but other track types may exist as well.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack)
 */
interface MediaStreamTrack extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/enabled) */
    enabled: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/id) */
    readonly id: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/kind) */
    readonly kind: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/label) */
    readonly label: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/muted) */
    readonly muted: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/ended_event) */
    onended: ((this: MediaStreamTrack, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/mute_event) */
    onmute: ((this: MediaStreamTrack, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/unmute_event) */
    onunmute: ((this: MediaStreamTrack, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/readyState) */
    readonly readyState: MediaStreamTrackState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/applyConstraints) */
    applyConstraints(constraints?: MediaTrackConstraints): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/clone) */
    clone(): MediaStreamTrack;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/getConstraints) */
    getConstraints(): MediaTrackConstraints;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/getSettings) */
    getSettings(): MediaTrackSettings;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/stop) */
    stop(): void;
    addEventListener<K extends keyof MediaStreamTrackEventMap>(type: K, listener: (this: MediaStreamTrack, ev: MediaStreamTrackEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MediaStreamTrackEventMap>(type: K, listener: (this: MediaStreamTrack, ev: MediaStreamTrackEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var MediaStreamTrack: {
    prototype: MediaStreamTrack;
    new(): MediaStreamTrack;
    isInstance(obj): obj is MediaStreamTrack;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrackAudioSourceNode) */
interface MediaStreamTrackAudioSourceNode extends AudioNode, AudioNodePassThrough {
}

declare var MediaStreamTrackAudioSourceNode: {
    prototype: MediaStreamTrackAudioSourceNode;
    new(context: AudioContext, options: MediaStreamTrackAudioSourceOptions): MediaStreamTrackAudioSourceNode;
    isInstance(obj): obj is MediaStreamTrackAudioSourceNode;
};

/**
 * Events which indicate that a MediaStream has had tracks added to or removed from the stream through calls to Media Stream API methods. These events are sent to the stream when these changes occur.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrackEvent)
 */
interface MediaStreamTrackEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrackEvent/track) */
    readonly track: MediaStreamTrack;
}

declare var MediaStreamTrackEvent: {
    prototype: MediaStreamTrackEvent;
    new(type: string, eventInitDict: MediaStreamTrackEventInit): MediaStreamTrackEvent;
    isInstance(obj): obj is MediaStreamTrackEvent;
};

/**
 * @deprecated
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MerchantValidationEvent)
 */
interface MerchantValidationEvent extends Event {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MerchantValidationEvent/methodName)
     */
    readonly methodName: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MerchantValidationEvent/validationURL)
     */
    readonly validationURL: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MerchantValidationEvent/complete)
     */
    complete(merchantSessionPromise: any): void;
}

/** @deprecated */
declare var MerchantValidationEvent: {
    prototype: MerchantValidationEvent;
    new(type: string, eventInitDict?: MerchantValidationEventInit): MerchantValidationEvent;
    isInstance(obj): obj is MerchantValidationEvent;
};

interface MessageBroadcaster extends MessageListenerManager {
    readonly childCount: number;
    broadcastAsyncMessage(messageName?: string | null, obj?: any): void;
    getChildAt(aIndex: number): MessageListenerManager | null;
    releaseCachedProcesses(): void;
}

declare var MessageBroadcaster: {
    prototype: MessageBroadcaster;
    new(): MessageBroadcaster;
    isInstance(obj): obj is MessageBroadcaster;
};

/**
 * This Channel Messaging API interface allows us to create a new message channel and send data through it via its two MessagePort properties.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageChannel)
 */
interface MessageChannel {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageChannel/port1) */
    readonly port1: MessagePort;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageChannel/port2) */
    readonly port2: MessagePort;
}

declare var MessageChannel: {
    prototype: MessageChannel;
    new(): MessageChannel;
    isInstance(obj): obj is MessageChannel;
};

/**
 * A message received by a target object.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageEvent)
 */
interface MessageEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageEvent/data) */
    readonly data: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageEvent/lastEventId) */
    readonly lastEventId: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageEvent/origin) */
    readonly origin: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageEvent/ports) */
    readonly ports: MessagePort[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageEvent/source) */
    readonly source: MessageEventSource | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageEvent/initMessageEvent)
     */
    initMessageEvent(type: string, bubbles?: boolean, cancelable?: boolean, data?: any, origin?: string, lastEventId?: string, source?: MessageEventSource | null, ports?: MessagePort[]): void;
}

declare var MessageEvent: {
    prototype: MessageEvent;
    new(type: string, eventInitDict?: MessageEventInit): MessageEvent;
    isInstance(obj): obj is MessageEvent;
};

interface MessageListenerManager extends MessageListenerManagerMixin {
}

declare var MessageListenerManager: {
    prototype: MessageListenerManager;
    new(): MessageListenerManager;
    isInstance(obj): obj is MessageListenerManager;
};

interface MessageListenerManagerMixin {
    addMessageListener(messageName: string, listener: MessageListener, listenWhenClosed?: boolean): void;
    addWeakMessageListener(messageName: string, listener: MessageListener): void;
    removeMessageListener(messageName: string, listener: MessageListener): void;
    removeWeakMessageListener(messageName: string, listener: MessageListener): void;
}

interface MessageManagerGlobal {
    atob(asciiString: string): string;
    btoa(base64Data: string): string;
    dump(str: string): void;
}

interface MessagePortEventMap {
    "message": Event;
    "messageerror": Event;
}

/**
 * This Channel Messaging API interface represents one of the two ports of a MessageChannel, allowing messages to be sent from one port and listening out for them arriving at the other.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessagePort)
 */
interface MessagePort extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessagePort/message_event) */
    onmessage: ((this: MessagePort, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessagePort/messageerror_event) */
    onmessageerror: ((this: MessagePort, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessagePort/close) */
    close(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessagePort/postMessage) */
    postMessage(message: any, transferable: any[]): void;
    postMessage(message: any, options?: StructuredSerializeOptions): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessagePort/start) */
    start(): void;
    addEventListener<K extends keyof MessagePortEventMap>(type: K, listener: (this: MessagePort, ev: MessagePortEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof MessagePortEventMap>(type: K, listener: (this: MessagePort, ev: MessagePortEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var MessagePort: {
    prototype: MessagePort;
    new(): MessagePort;
    isInstance(obj): obj is MessagePort;
};

interface MessageSender extends MessageListenerManager, MessageSenderMixin {
}

declare var MessageSender: {
    prototype: MessageSender;
    new(): MessageSender;
    isInstance(obj): obj is MessageSender;
};

interface MessageSenderMixin {
    readonly processMessageManager: MessageSender | null;
    readonly remoteType: UTF8String;
    sendAsyncMessage(messageName?: string | null, obj?: any, transfers?: any): void;
}

/**
 * Provides contains information about a MIME type associated with a particular plugin. NavigatorPlugins.mimeTypes returns an array of this object.
 * @deprecated
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MimeType)
 */
interface MimeType {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MimeType/description)
     */
    readonly description: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MimeType/enabledPlugin)
     */
    readonly enabledPlugin: Plugin;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MimeType/suffixes)
     */
    readonly suffixes: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MimeType/type)
     */
    readonly type: string;
}

/** @deprecated */
declare var MimeType: {
    prototype: MimeType;
    new(): MimeType;
    isInstance(obj): obj is MimeType;
};

/**
 * Returns an array of MimeType instances, each of which contains information about a supported browser plugins. This object is returned by NavigatorPlugins.mimeTypes.
 * @deprecated
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MimeTypeArray)
 */
interface MimeTypeArray {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MimeTypeArray/length)
     */
    readonly length: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MimeTypeArray/item)
     */
    item(index: number): MimeType | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MimeTypeArray/namedItem)
     */
    namedItem(name: string): MimeType | null;
    [index: number]: MimeType;
}

/** @deprecated */
declare var MimeTypeArray: {
    prototype: MimeTypeArray;
    new(): MimeTypeArray;
    isInstance(obj): obj is MimeTypeArray;
};

/**
 * Events that occur due to the user interacting with a pointing device (such as a mouse). Common events using this interface include click, dblclick, mouseup, mousedown.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent)
 */
interface MouseEvent extends UIEvent {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/altKey) */
    readonly altKey: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/button) */
    readonly button: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/buttons) */
    readonly buttons: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/clientX) */
    readonly clientX: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/clientY) */
    readonly clientY: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/ctrlKey) */
    readonly ctrlKey: boolean;
    readonly inputSource: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/metaKey) */
    readonly metaKey: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/movementX) */
    readonly movementX: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/movementY) */
    readonly movementY: number;
    readonly mozInputSource: number;
    readonly mozPressure: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/offsetX) */
    readonly offsetX: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/offsetY) */
    readonly offsetY: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/pageX) */
    readonly pageX: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/pageY) */
    readonly pageY: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/relatedTarget) */
    readonly relatedTarget: EventTarget | null;
    readonly screen: nsIScreen | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/screenX) */
    readonly screenX: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/screenY) */
    readonly screenY: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/shiftKey) */
    readonly shiftKey: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/x) */
    readonly x: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/y) */
    readonly y: number;
    clickEventPrevented(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/getModifierState) */
    getModifierState(keyArg: string): boolean;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/initMouseEvent)
     */
    initMouseEvent(typeArg: string, canBubbleArg?: boolean, cancelableArg?: boolean, viewArg?: Window | null, detailArg?: number, screenXArg?: number, screenYArg?: number, clientXArg?: number, clientYArg?: number, ctrlKeyArg?: boolean, altKeyArg?: boolean, shiftKeyArg?: boolean, metaKeyArg?: boolean, buttonArg?: number, relatedTargetArg?: EventTarget | null): void;
    initNSMouseEvent(typeArg: string, canBubbleArg?: boolean, cancelableArg?: boolean, viewArg?: Window | null, detailArg?: number, screenXArg?: number, screenYArg?: number, clientXArg?: number, clientYArg?: number, ctrlKeyArg?: boolean, altKeyArg?: boolean, shiftKeyArg?: boolean, metaKeyArg?: boolean, buttonArg?: number, relatedTargetArg?: EventTarget | null, pressure?: number, inputSourceArg?: number): void;
    preventClickEvent(): void;
    readonly MOZ_SOURCE_UNKNOWN: 0;
    readonly MOZ_SOURCE_MOUSE: 1;
    readonly MOZ_SOURCE_PEN: 2;
    readonly MOZ_SOURCE_ERASER: 3;
    readonly MOZ_SOURCE_CURSOR: 4;
    readonly MOZ_SOURCE_TOUCH: 5;
    readonly MOZ_SOURCE_KEYBOARD: 6;
}

declare var MouseEvent: {
    prototype: MouseEvent;
    new(typeArg: string, mouseEventInitDict?: MouseEventInit): MouseEvent;
    readonly MOZ_SOURCE_UNKNOWN: 0;
    readonly MOZ_SOURCE_MOUSE: 1;
    readonly MOZ_SOURCE_PEN: 2;
    readonly MOZ_SOURCE_ERASER: 3;
    readonly MOZ_SOURCE_CURSOR: 4;
    readonly MOZ_SOURCE_TOUCH: 5;
    readonly MOZ_SOURCE_KEYBOARD: 6;
    isInstance(obj): obj is MouseEvent;
};

/**
 * @deprecated
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseScrollEvent)
 */
interface MouseScrollEvent extends MouseEvent {
    readonly axis: number;
    initMouseScrollEvent(type: string, canBubble?: boolean, cancelable?: boolean, view?: Window | null, detail?: number, screenX?: number, screenY?: number, clientX?: number, clientY?: number, ctrlKey?: boolean, altKey?: boolean, shiftKey?: boolean, metaKey?: boolean, button?: number, relatedTarget?: EventTarget | null, axis?: number): void;
    readonly HORIZONTAL_AXIS: 1;
    readonly VERTICAL_AXIS: 2;
}

/** @deprecated */
declare var MouseScrollEvent: {
    prototype: MouseScrollEvent;
    new(): MouseScrollEvent;
    readonly HORIZONTAL_AXIS: 1;
    readonly VERTICAL_AXIS: 2;
    isInstance(obj): obj is MouseScrollEvent;
};

interface MozApplicationEvent extends Event {
    readonly application: DOMApplication | null;
}

declare var MozApplicationEvent: {
    prototype: MozApplicationEvent;
    new(type: string, eventInitDict?: MozApplicationEventInit): MozApplicationEvent;
    isInstance(obj): obj is MozApplicationEvent;
};

interface MozCanvasPrintState {
    readonly context: nsISupports;
    done(): void;
}

declare var MozCanvasPrintState: {
    prototype: MozCanvasPrintState;
    new(): MozCanvasPrintState;
    isInstance(obj): obj is MozCanvasPrintState;
};

interface MozDocumentMatcher {
    readonly allFrames: boolean;
    readonly checkPermissions: boolean;
    readonly excludeMatches: MatchPatternSet | null;
    readonly extension: WebExtensionPolicy | null;
    readonly frameID: number | null;
    readonly matchAboutBlank: boolean;
    readonly matches: MatchPatternSet;
    readonly originAttributesPatterns: any;
    matchesURI(uri: URI): boolean;
    matchesWindowGlobal(windowGlobal: WindowGlobalChild, ignorePermissions?: boolean): boolean;
}

declare var MozDocumentMatcher: {
    prototype: MozDocumentMatcher;
    new(options: MozDocumentMatcherInit): MozDocumentMatcher;
    isInstance(obj): obj is MozDocumentMatcher;
};

interface MozDocumentObserver {
    disconnect(): void;
    observe(matchers: MozDocumentMatcher[]): void;
}

declare var MozDocumentObserver: {
    prototype: MozDocumentObserver;
    new(callbacks: MozDocumentCallback): MozDocumentObserver;
    isInstance(obj): obj is MozDocumentObserver;
};

interface MozEditableElement {
    readonly editor: nsIEditor | null;
    readonly hasEditor: boolean;
    readonly isInputEventTarget: boolean;
    setUserInput(input: string): void;
}

interface MozFrameLoaderOwner {
    readonly browsingContext: BrowsingContext | null;
    readonly frameLoader: FrameLoader | null;
    changeRemoteness(aOptions: RemotenessOptions): void;
    swapFrameLoaders(aOtherLoaderOwner: XULFrameElement): void;
    swapFrameLoaders(aOtherLoaderOwner: HTMLIFrameElement): void;
}

interface MozImageLoadingContent {
    readonly currentRequestFinalURI: URI | null;
    readonly currentURI: URI | null;
    loadingEnabled: boolean;
    addObserver(aObserver: imgINotificationObserver): void;
    forceReload(aNotify?: boolean): void;
    getRequest(aRequestType: number): imgIRequest | null;
    getRequestType(aRequest: imgIRequest): number;
    removeObserver(aObserver: imgINotificationObserver): void;
    readonly UNKNOWN_REQUEST: -1;
    readonly CURRENT_REQUEST: 0;
    readonly PENDING_REQUEST: 1;
}

interface MozObjectLoadingContent {
    readonly actualType: string;
    readonly displayedType: number;
    readonly runID: number;
    readonly srcURI: URI | null;
    getContentTypeForMIMEType(aMimeType: string): number;
    getPluginAttributes(): MozPluginParameter[];
    getPluginParameters(): MozPluginParameter[];
    reload(aClearActivation: boolean): void;
    skipFakePlugins(): void;
    readonly TYPE_LOADING: 0;
    readonly TYPE_IMAGE: 1;
    readonly TYPE_FALLBACK: 2;
    readonly TYPE_FAKE_PLUGIN: 3;
    readonly TYPE_DOCUMENT: 4;
    readonly TYPE_NULL: 5;
}

interface MozObserver {
}

declare var MozObserver: {
    prototype: MozObserver;
    new(): MozObserver;
    isInstance(obj): obj is MozObserver;
};

interface MozQueryInterface {
}

declare var MozQueryInterface: {
    prototype: MozQueryInterface;
    new(): MozQueryInterface;
    isInstance(obj): obj is MozQueryInterface;
};

interface MozSharedMap extends EventTarget {
    get(name: string): StructuredClonable;
    has(name: string): boolean;
    forEach(callbackfn: (value: StructuredClonable, key: string, parent: MozSharedMap) => void, thisArg?: any): void;
}

declare var MozSharedMap: {
    prototype: MozSharedMap;
    new(): MozSharedMap;
    isInstance(obj): obj is MozSharedMap;
};

interface MozSharedMapChangeEvent extends Event {
    readonly changedKeys: string[];
}

declare var MozSharedMapChangeEvent: {
    prototype: MozSharedMapChangeEvent;
    new(): MozSharedMapChangeEvent;
    isInstance(obj): obj is MozSharedMapChangeEvent;
};

interface MozStorageAsyncStatementParams {
    readonly length: number;
    [index: number]: any;
    [name: string]: any;
}

declare var MozStorageAsyncStatementParams: {
    prototype: MozStorageAsyncStatementParams;
    new(): MozStorageAsyncStatementParams;
    isInstance(obj): obj is MozStorageAsyncStatementParams;
};

interface MozStorageStatementParams {
    readonly length: number;
    [index: number]: any;
    [name: string]: any;
}

declare var MozStorageStatementParams: {
    prototype: MozStorageStatementParams;
    new(): MozStorageStatementParams;
    isInstance(obj): obj is MozStorageStatementParams;
};

interface MozStorageStatementRow {
    [name: string]: any;
}

declare var MozStorageStatementRow: {
    prototype: MozStorageStatementRow;
    new(): MozStorageStatementRow;
    isInstance(obj): obj is MozStorageStatementRow;
};

interface MozWritableSharedMap extends MozSharedMap {
    delete(name: string): void;
    flush(): void;
    set(name: string, value: StructuredClonable): void;
}

declare var MozWritableSharedMap: {
    prototype: MozWritableSharedMap;
    new(): MozWritableSharedMap;
    isInstance(obj): obj is MozWritableSharedMap;
};

/**
 * Provides event properties that are specific to modifications to the Document Object Model (DOM) hierarchy and nodes.
 * @deprecated DOM4 [DOM] provides a new mechanism using a MutationObserver interface which addresses the use cases that mutation events solve, but in a more performant manner. Thus, this specification describes mutation events for reference and completeness of legacy behavior, but deprecates the use of the MutationEvent interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationEvent)
 */
interface MutationEvent extends Event {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationEvent/attrChange)
     */
    readonly attrChange: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationEvent/attrName)
     */
    readonly attrName: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationEvent/newValue)
     */
    readonly newValue: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationEvent/prevValue)
     */
    readonly prevValue: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationEvent/relatedNode)
     */
    readonly relatedNode: Node | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationEvent/initMutationEvent)
     */
    initMutationEvent(type: string, canBubble?: boolean, cancelable?: boolean, relatedNode?: Node | null, prevValue?: string, newValue?: string, attrName?: string, attrChange?: number): void;
    readonly MODIFICATION: 1;
    readonly ADDITION: 2;
    readonly REMOVAL: 3;
    readonly SMIL: 4;
}

/** @deprecated */
declare var MutationEvent: {
    prototype: MutationEvent;
    new(): MutationEvent;
    readonly MODIFICATION: 1;
    readonly ADDITION: 2;
    readonly REMOVAL: 3;
    readonly SMIL: 4;
    isInstance(obj): obj is MutationEvent;
};

/**
 * Provides the ability to watch for changes being made to the DOM tree. It is designed as a replacement for the older Mutation Events feature which was part of the DOM3 Events specification.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationObserver)
 */
interface MutationObserver {
    mergeAttributeRecords: boolean;
    readonly mutationCallback: MutationCallback;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationObserver/disconnect) */
    disconnect(): void;
    getObservingInfo(): (MutationObservingInfo | null)[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationObserver/observe) */
    observe(target: Node, options?: MutationObserverInit): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationObserver/takeRecords) */
    takeRecords(): MutationRecord[];
}

declare var MutationObserver: {
    prototype: MutationObserver;
    new(mutationCallback: MutationCallback): MutationObserver;
    isInstance(obj): obj is MutationObserver;
};

/**
 * A MutationRecord represents an individual DOM mutation. It is the object that is passed to MutationObserver's callback.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord)
 */
interface MutationRecord {
    readonly addedAnimations: Animation[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/addedNodes) */
    readonly addedNodes: NodeList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/attributeName) */
    readonly attributeName: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/attributeNamespace) */
    readonly attributeNamespace: string | null;
    readonly changedAnimations: Animation[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/nextSibling) */
    readonly nextSibling: Node | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/oldValue) */
    readonly oldValue: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/previousSibling) */
    readonly previousSibling: Node | null;
    readonly removedAnimations: Animation[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/removedNodes) */
    readonly removedNodes: NodeList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/target) */
    readonly target: Node | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/type) */
    readonly type: string;
}

declare var MutationRecord: {
    prototype: MutationRecord;
    new(): MutationRecord;
    isInstance(obj): obj is MutationRecord;
};

/**
 * A collection of Attr objects. Objects inside a NamedNodeMap are not in any particular order, unlike NodeList, although they may be accessed by an index as in an array.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/NamedNodeMap)
 */
interface NamedNodeMap {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NamedNodeMap/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NamedNodeMap/getNamedItem) */
    getNamedItem(name: string): Attr | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NamedNodeMap/getNamedItemNS) */
    getNamedItemNS(namespaceURI: string | null, localName: string): Attr | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NamedNodeMap/item) */
    item(index: number): Attr | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NamedNodeMap/removeNamedItem) */
    removeNamedItem(name: string): Attr;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NamedNodeMap/removeNamedItemNS) */
    removeNamedItemNS(namespaceURI: string | null, localName: string): Attr;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NamedNodeMap/setNamedItem) */
    setNamedItem(arg: Attr): Attr | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NamedNodeMap/setNamedItemNS) */
    setNamedItemNS(arg: Attr): Attr | null;
    [index: number]: Attr;
}

declare var NamedNodeMap: {
    prototype: NamedNodeMap;
    new(): NamedNodeMap;
    isInstance(obj): obj is NamedNodeMap;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/NavigationPreloadManager)
 */
interface NavigationPreloadManager {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NavigationPreloadManager/disable) */
    disable(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NavigationPreloadManager/enable) */
    enable(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NavigationPreloadManager/getState) */
    getState(): Promise<NavigationPreloadState>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NavigationPreloadManager/setHeaderValue) */
    setHeaderValue(value: string): Promise<void>;
}

declare var NavigationPreloadManager: {
    prototype: NavigationPreloadManager;
    new(): NavigationPreloadManager;
    isInstance(obj): obj is NavigationPreloadManager;
};

/**
 * The state and the identity of the user agent. It allows scripts to query it and to register themselves to carry on some activities.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator)
 */
interface Navigator extends GlobalPrivacyControl, NavigatorAutomationInformation, NavigatorConcurrentHardware, NavigatorContentUtils, NavigatorGPU, NavigatorGeolocation, NavigatorID, NavigatorLanguage, NavigatorLocks, NavigatorOnLine, NavigatorStorage {
    /**
     * @deprecated
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/activeVRDisplays)
     */
    readonly activeVRDisplays: VRDisplay[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/buildID) */
    readonly buildID: string;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/clipboard)
     */
    readonly clipboard: Clipboard;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/connection) */
    readonly connection: NetworkInformation;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/cookieEnabled) */
    readonly cookieEnabled: boolean;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/credentials)
     */
    readonly credentials: CredentialsContainer;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/doNotTrack)
     */
    readonly doNotTrack: string;
    readonly isWebVRContentDetected: boolean;
    readonly isWebVRContentPresenting: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/maxTouchPoints) */
    readonly maxTouchPoints: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/mediaCapabilities) */
    readonly mediaCapabilities: MediaCapabilities;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/mediaDevices) */
    readonly mediaDevices: MediaDevices;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/mediaSession) */
    readonly mediaSession: MediaSession;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/NavigatorPlugins/mimeTypes)
     */
    readonly mimeTypes: MimeTypeArray;
    readonly mozAddonManager: AddonManager;
    readonly mozTCPSocket: LegacyMozTCPSocket;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/oscpu)
     */
    readonly oscpu: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/pdfViewerEnabled) */
    readonly pdfViewerEnabled: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/permissions) */
    readonly permissions: Permissions;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/plugins)
     */
    readonly plugins: PluginArray;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/productSub)
     */
    readonly productSub: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/serviceWorker) */
    readonly serviceWorker: ServiceWorkerContainer;
    readonly testTrialGatedAttribute: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/userActivation) */
    readonly userActivation: UserActivation;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/vendor)
     */
    readonly vendor: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/vendorSub)
     */
    readonly vendorSub: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/wakeLock) */
    readonly wakeLock: WakeLock;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/xr)
     */
    readonly xr: XRSystem;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/canShare)
     */
    canShare(data?: ShareData): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/getAutoplayPolicy) */
    getAutoplayPolicy(type: AutoplayPolicyMediaType): AutoplayPolicy;
    getAutoplayPolicy(element: HTMLMediaElement): AutoplayPolicy;
    getAutoplayPolicy(context: AudioContext): AutoplayPolicy;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/getBattery) */
    getBattery(): Promise<BatteryManager>;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/getGamepads)
     */
    getGamepads(): (Gamepad | null)[];
    /**
     * @deprecated
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/getVRDisplays)
     */
    getVRDisplays(): Promise<VRDisplay[]>;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/javaEnabled)
     */
    javaEnabled(): boolean;
    /**
     * @deprecated This is a legacy alias of `getUserMedia`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/getUserMedia)
     */
    mozGetUserMedia(constraints: MediaStreamConstraints, successCallback: NavigatorUserMediaSuccessCallback, errorCallback: NavigatorUserMediaErrorCallback): void;
    requestGamepadServiceTest(): GamepadServiceTest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/requestMIDIAccess) */
    requestMIDIAccess(options?: MIDIOptions): Promise<MIDIAccess>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/requestMediaKeySystemAccess) */
    requestMediaKeySystemAccess(keySystem: string, supportedConfigurations: MediaKeySystemConfiguration[]): Promise<MediaKeySystemAccess>;
    requestVRPresentation(display: VRDisplay): void;
    requestVRServiceTest(): VRServiceTest;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/sendBeacon) */
    sendBeacon(url: string, data?: BodyInit | null): boolean;
    setVibrationPermission(permitted: boolean, persistent?: boolean): void;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/share)
     */
    share(data?: ShareData): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/vibrate) */
    vibrate(duration: number): boolean;
    vibrate(pattern: number[]): boolean;
}

declare var Navigator: {
    prototype: Navigator;
    new(): Navigator;
    isInstance(obj): obj is Navigator;
};

interface NavigatorAutomationInformation {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/webdriver) */
    readonly webdriver: boolean;
}

interface NavigatorConcurrentHardware {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/hardwareConcurrency) */
    readonly hardwareConcurrency: number;
}

interface NavigatorContentUtils {
    checkProtocolHandlerAllowed(scheme: string, handlerURI: URI, documentURI: URI): void;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/registerProtocolHandler)
     */
    registerProtocolHandler(scheme: string, url: string): void;
}

interface NavigatorGPU {
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/gpu)
     */
    readonly gpu: GPU;
}

interface NavigatorGeolocation {
    readonly geolocation: Geolocation;
}

interface NavigatorID {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/appCodeName)
     */
    readonly appCodeName: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/appName)
     */
    readonly appName: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/appVersion)
     */
    readonly appVersion: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/platform)
     */
    readonly platform: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/product)
     */
    readonly product: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/userAgent) */
    readonly userAgent: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/taintEnabled)
     */
    taintEnabled(): boolean;
}

interface NavigatorLanguage {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/language) */
    readonly language: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/languages) */
    readonly languages: string[];
}

/** Available only in secure contexts. */
interface NavigatorLocks {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/locks) */
    readonly locks: LockManager;
}

interface NavigatorOnLine {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/onLine) */
    readonly onLine: boolean;
}

/** Available only in secure contexts. */
interface NavigatorStorage {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Navigator/storage) */
    readonly storage: StorageManager;
}

interface NetworkInformationEventMap {
    "typechange": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NetworkInformation) */
interface NetworkInformation extends EventTarget {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/NetworkInformation/typechange_event)
     */
    ontypechange: ((this: NetworkInformation, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NetworkInformation/type) */
    readonly type: ConnectionType;
    addEventListener<K extends keyof NetworkInformationEventMap>(type: K, listener: (this: NetworkInformation, ev: NetworkInformationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof NetworkInformationEventMap>(type: K, listener: (this: NetworkInformation, ev: NetworkInformationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var NetworkInformation: {
    prototype: NetworkInformation;
    new(): NetworkInformation;
    isInstance(obj): obj is NetworkInformation;
};

/**
 * Node is an interface from which a number of DOM API object types inherit. It allows those types to be treated similarly; for example, inheriting the same set of methods, or being tested in the same way.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node)
 */
interface Node extends EventTarget {
    readonly accessibleNode: AccessibleNode | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/baseURI) */
    readonly baseURI: string | null;
    readonly baseURIObject: URI | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/childNodes) */
    readonly childNodes: NodeList;
    readonly containingShadowRoot: ShadowRoot | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/firstChild) */
    readonly firstChild: Node | null;
    readonly flattenedTreeParentNode: Node | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/isConnected) */
    readonly isConnected: boolean;
    readonly isNativeAnonymous: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/lastChild) */
    readonly lastChild: Node | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/nextSibling) */
    readonly nextSibling: Node | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/nodeName) */
    readonly nodeName: string;
    readonly nodePrincipal: Principal;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/nodeType) */
    readonly nodeType: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/nodeValue) */
    nodeValue: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/ownerDocument) */
    readonly ownerDocument: Document | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/parentElement) */
    readonly parentElement: Element | null;
    readonly parentFlexElement: Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/parentNode) */
    readonly parentNode: Node | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/previousSibling) */
    readonly previousSibling: Node | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/textContent) */
    textContent: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/appendChild) */
    appendChild(node: Node): Node;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/cloneNode) */
    cloneNode(deep?: boolean): Node;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/compareDocumentPosition) */
    compareDocumentPosition(other: Node): number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/contains) */
    contains(other: Node | null): boolean;
    generateXPath(): string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/getRootNode) */
    getRootNode(options?: GetRootNodeOptions): Node;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/hasChildNodes) */
    hasChildNodes(): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/insertBefore) */
    insertBefore(node: Node, child: Node | null): Node;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/isDefaultNamespace) */
    isDefaultNamespace(namespace: string | null): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/isEqualNode) */
    isEqualNode(node: Node | null): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/isSameNode) */
    isSameNode(node: Node | null): boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/lookupNamespaceURI) */
    lookupNamespaceURI(prefix: string | null): string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/lookupPrefix) */
    lookupPrefix(namespace: string | null): string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/normalize) */
    normalize(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/removeChild) */
    removeChild(child: Node): Node;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/replaceChild) */
    replaceChild(node: Node, child: Node): Node;
    readonly ELEMENT_NODE: 1;
    readonly ATTRIBUTE_NODE: 2;
    readonly TEXT_NODE: 3;
    readonly CDATA_SECTION_NODE: 4;
    readonly ENTITY_REFERENCE_NODE: 5;
    readonly ENTITY_NODE: 6;
    readonly PROCESSING_INSTRUCTION_NODE: 7;
    readonly COMMENT_NODE: 8;
    readonly DOCUMENT_NODE: 9;
    readonly DOCUMENT_TYPE_NODE: 10;
    readonly DOCUMENT_FRAGMENT_NODE: 11;
    readonly NOTATION_NODE: 12;
    readonly DOCUMENT_POSITION_DISCONNECTED: 0x01;
    readonly DOCUMENT_POSITION_PRECEDING: 0x02;
    readonly DOCUMENT_POSITION_FOLLOWING: 0x04;
    readonly DOCUMENT_POSITION_CONTAINS: 0x08;
    readonly DOCUMENT_POSITION_CONTAINED_BY: 0x10;
    readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC: 0x20;
}

declare var Node: {
    prototype: Node;
    new(): Node;
    readonly ELEMENT_NODE: 1;
    readonly ATTRIBUTE_NODE: 2;
    readonly TEXT_NODE: 3;
    readonly CDATA_SECTION_NODE: 4;
    readonly ENTITY_REFERENCE_NODE: 5;
    readonly ENTITY_NODE: 6;
    readonly PROCESSING_INSTRUCTION_NODE: 7;
    readonly COMMENT_NODE: 8;
    readonly DOCUMENT_NODE: 9;
    readonly DOCUMENT_TYPE_NODE: 10;
    readonly DOCUMENT_FRAGMENT_NODE: 11;
    readonly NOTATION_NODE: 12;
    readonly DOCUMENT_POSITION_DISCONNECTED: 0x01;
    readonly DOCUMENT_POSITION_PRECEDING: 0x02;
    readonly DOCUMENT_POSITION_FOLLOWING: 0x04;
    readonly DOCUMENT_POSITION_CONTAINS: 0x08;
    readonly DOCUMENT_POSITION_CONTAINED_BY: 0x10;
    readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC: 0x20;
    isInstance(obj): obj is Node;
};

/**
 * An iterator over the members of a list of the nodes in a subtree of the DOM. The nodes will be returned in document order.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/NodeIterator)
 */
interface NodeIterator {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NodeIterator/filter) */
    readonly filter: NodeFilter | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NodeIterator/pointerBeforeReferenceNode) */
    readonly pointerBeforeReferenceNode: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NodeIterator/referenceNode) */
    readonly referenceNode: Node | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NodeIterator/root) */
    readonly root: Node;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NodeIterator/whatToShow) */
    readonly whatToShow: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/NodeIterator/detach)
     */
    detach(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NodeIterator/nextNode) */
    nextNode(): Node | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NodeIterator/previousNode) */
    previousNode(): Node | null;
}

declare var NodeIterator: {
    prototype: NodeIterator;
    new(): NodeIterator;
    isInstance(obj): obj is NodeIterator;
};

/**
 * NodeList objects are collections of nodes, usually returned by properties such as Node.childNodes and methods such as document.querySelectorAll().
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/NodeList)
 */
interface NodeList {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NodeList/length) */
    readonly length: number;
    /**
     * Performs the specified action for each node in an list.
     * @param callbackfn  A function that accepts up to three arguments. forEach calls the callbackfn function one time for each element in the list.
     * @param thisArg  An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.
     */
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NodeList/item) */
    item(index: number): Node | null;
    forEach(callbackfn: (value: Node | null, key: number, parent: NodeList) => void, thisArg?: any): void;
    [index: number]: Node;
}

declare var NodeList: {
    prototype: NodeList;
    new(): NodeList;
    isInstance(obj): obj is NodeList;
};

interface NodeListOf {
    /**
     * Performs the specified action for each node in an list.
     * @param callbackfn  A function that accepts up to three arguments. forEach calls the callbackfn function one time for each element in the list.
     * @param thisArg  An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.
     */
}

declare var NodeListOf: {
    prototype: NodeListOf;
    new(): NodeListOf;
    isInstance(obj): obj is NodeListOf;
};

interface NonDocumentTypeChildNode {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/nextElementSibling) */
    readonly nextElementSibling: Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/previousElementSibling) */
    readonly previousElementSibling: Element | null;
}

interface NotificationEventMap {
    "click": Event;
    "close": Event;
    "error": ErrorEvent;
    "show": Event;
}

/**
 * This Notifications API interface is used to configure and display desktop notifications to the user.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification)
 */
interface Notification extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/body) */
    readonly body: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/data) */
    readonly data: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/dir) */
    readonly dir: NotificationDirection;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/icon) */
    readonly icon: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/lang) */
    readonly lang: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/click_event) */
    onclick: ((this: Notification, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/close_event) */
    onclose: ((this: Notification, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/error_event) */
    onerror: OnErrorEventHandler;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/show_event) */
    onshow: ((this: Notification, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/requireInteraction) */
    readonly requireInteraction: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/silent) */
    readonly silent: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/tag) */
    readonly tag: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/title) */
    readonly title: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/vibrate) */
    readonly vibrate: number[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/close) */
    close(): void;
    addEventListener<K extends keyof NotificationEventMap>(type: K, listener: (this: Notification, ev: NotificationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof NotificationEventMap>(type: K, listener: (this: Notification, ev: NotificationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var Notification: {
    prototype: Notification;
    new(title: string, options?: NotificationOptions): Notification;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/permission_static) */
    readonly permission: NotificationPermission;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Notification/requestPermission_static) */
    requestPermission(permissionCallback?: NotificationPermissionCallback): Promise<NotificationPermission>;
    isInstance(obj): obj is Notification;
};

/**
 * The parameter passed into the onnotificationclick handler, the NotificationEvent interface represents a notification click event that is dispatched on the ServiceWorkerGlobalScope of a ServiceWorker.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/NotificationEvent)
 */
interface NotificationEvent extends ExtendableEvent {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/NotificationEvent/notification) */
    readonly notification: Notification;
}

declare var NotificationEvent: {
    prototype: NotificationEvent;
    new(type: string, eventInitDict: NotificationEventInit): NotificationEvent;
    isInstance(obj): obj is NotificationEvent;
};

interface NotifyPaintEvent extends Event {
    readonly boundingClientRect: DOMRect;
    readonly clientRects: DOMRectList;
    readonly paintRequests: PaintRequestList;
    readonly paintTimeStamp: DOMHighResTimeStamp;
    readonly transactionId: number;
}

declare var NotifyPaintEvent: {
    prototype: NotifyPaintEvent;
    new(): NotifyPaintEvent;
    isInstance(obj): obj is NotifyPaintEvent;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_draw_buffers_indexed) */
interface OES_draw_buffers_indexed {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_draw_buffers_indexed/blendEquationSeparateiOES) */
    blendEquationSeparateiOES(buf: GLuint, modeRGB: GLenum, modeAlpha: GLenum): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_draw_buffers_indexed/blendEquationiOES) */
    blendEquationiOES(buf: GLuint, mode: GLenum): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_draw_buffers_indexed/blendFuncSeparateiOES) */
    blendFuncSeparateiOES(buf: GLuint, srcRGB: GLenum, dstRGB: GLenum, srcAlpha: GLenum, dstAlpha: GLenum): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_draw_buffers_indexed/blendFunciOES) */
    blendFunciOES(buf: GLuint, src: GLenum, dst: GLenum): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_draw_buffers_indexed/colorMaskiOES) */
    colorMaskiOES(buf: GLuint, r: GLboolean, g: GLboolean, b: GLboolean, a: GLboolean): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_draw_buffers_indexed/disableiOES) */
    disableiOES(target: GLenum, index: GLuint): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_draw_buffers_indexed/enableiOES) */
    enableiOES(target: GLenum, index: GLuint): void;
}

/**
 * The OES_element_index_uint extension is part of the WebGL API and adds support for gl.UNSIGNED_INT types to WebGLRenderingContext.drawElements().
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_element_index_uint)
 */
interface OES_element_index_uint {
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_fbo_render_mipmap) */
interface OES_fbo_render_mipmap {
}

/**
 * The OES_standard_derivatives extension is part of the WebGL API and adds the GLSL derivative functions dFdx, dFdy, and fwidth.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_standard_derivatives)
 */
interface OES_standard_derivatives {
    readonly FRAGMENT_SHADER_DERIVATIVE_HINT_OES: 0x8B8B;
}

/**
 * The OES_texture_float extension is part of the WebGL API and exposes floating-point pixel types for textures.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_texture_float)
 */
interface OES_texture_float {
}

/**
 * The OES_texture_float_linear extension is part of the WebGL API and allows linear filtering with floating-point pixel types for textures.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_texture_float_linear)
 */
interface OES_texture_float_linear {
}

/**
 * The OES_texture_half_float extension is part of the WebGL API and adds texture formats with 16- (aka half float) and 32-bit floating-point components.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_texture_half_float)
 */
interface OES_texture_half_float {
    readonly HALF_FLOAT_OES: 0x8D61;
}

/**
 * The OES_texture_half_float_linear extension is part of the WebGL API and allows linear filtering with half floating-point pixel types for textures.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_texture_half_float_linear)
 */
interface OES_texture_half_float_linear {
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_vertex_array_object) */
interface OES_vertex_array_object {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_vertex_array_object/bindVertexArrayOES) */
    bindVertexArrayOES(arrayObject: WebGLVertexArrayObject | null): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_vertex_array_object/createVertexArrayOES) */
    createVertexArrayOES(): WebGLVertexArrayObject | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_vertex_array_object/deleteVertexArrayOES) */
    deleteVertexArrayOES(arrayObject: WebGLVertexArrayObject | null): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OES_vertex_array_object/isVertexArrayOES) */
    isVertexArrayOES(arrayObject: WebGLVertexArrayObject | null): GLboolean;
    readonly VERTEX_ARRAY_BINDING_OES: 0x85B5;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OVR_multiview2) */
interface OVR_multiview2 {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OVR_multiview2/framebufferTextureMultiviewOVR) */
    framebufferTextureMultiviewOVR(target: GLenum, attachment: GLenum, texture: WebGLTexture | null, level: GLint, baseViewIndex: GLint, numViews: GLsizei): void;
    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR: 0x9630;
    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR: 0x9632;
    readonly MAX_VIEWS_OVR: 0x9631;
    readonly FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR: 0x9633;
}

/**
 * The Web Audio API OfflineAudioCompletionEvent interface represents events that occur when the processing of an OfflineAudioContext is terminated. The complete event implements this interface.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/OfflineAudioCompletionEvent)
 */
interface OfflineAudioCompletionEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OfflineAudioCompletionEvent/renderedBuffer) */
    readonly renderedBuffer: AudioBuffer;
}

declare var OfflineAudioCompletionEvent: {
    prototype: OfflineAudioCompletionEvent;
    new(type: string, eventInitDict: OfflineAudioCompletionEventInit): OfflineAudioCompletionEvent;
    isInstance(obj): obj is OfflineAudioCompletionEvent;
};

interface OfflineAudioContextEventMap extends BaseAudioContextEventMap {
    "complete": Event;
}

/**
 * An AudioContext interface representing an audio-processing graph built from linked together AudioNodes. In contrast with a standard AudioContext, an OfflineAudioContext doesn't render the audio to the device hardware; instead, it generates it, as fast as it can, and outputs the result to an AudioBuffer.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/OfflineAudioContext)
 */
interface OfflineAudioContext extends BaseAudioContext {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OfflineAudioContext/length) */
    readonly length: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OfflineAudioContext/complete_event) */
    oncomplete: ((this: OfflineAudioContext, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OfflineAudioContext/startRendering) */
    startRendering(): Promise<AudioBuffer>;
    addEventListener<K extends keyof OfflineAudioContextEventMap>(type: K, listener: (this: OfflineAudioContext, ev: OfflineAudioContextEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof OfflineAudioContextEventMap>(type: K, listener: (this: OfflineAudioContext, ev: OfflineAudioContextEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var OfflineAudioContext: {
    prototype: OfflineAudioContext;
    new(contextOptions: OfflineAudioContextOptions): OfflineAudioContext;
    new(numberOfChannels: number, length: number, sampleRate: number): OfflineAudioContext;
    isInstance(obj): obj is OfflineAudioContext;
};

interface OffscreenCanvasEventMap {
    "contextlost": Event;
    "contextrestored": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OffscreenCanvas) */
interface OffscreenCanvas extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OffscreenCanvas/height) */
    height: number;
    oncontextlost: ((this: OffscreenCanvas, ev: Event) => any) | null;
    oncontextrestored: ((this: OffscreenCanvas, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OffscreenCanvas/width) */
    width: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OffscreenCanvas/convertToBlob) */
    convertToBlob(options?: ImageEncodeOptions): Promise<Blob>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OffscreenCanvas/getContext) */
    getContext(contextId: OffscreenRenderingContextId, contextOptions?: any): OffscreenRenderingContext | null;
    /**
     * @deprecated This is a legacy alias of `convertToBlob`.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/OffscreenCanvas/convertToBlob)
     */
    toBlob(type?: string, encoderOptions?: any): Promise<Blob>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OffscreenCanvas/transferToImageBitmap) */
    transferToImageBitmap(): ImageBitmap;
    addEventListener<K extends keyof OffscreenCanvasEventMap>(type: K, listener: (this: OffscreenCanvas, ev: OffscreenCanvasEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof OffscreenCanvasEventMap>(type: K, listener: (this: OffscreenCanvas, ev: OffscreenCanvasEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var OffscreenCanvas: {
    prototype: OffscreenCanvas;
    new(width: number, height: number): OffscreenCanvas;
    isInstance(obj): obj is OffscreenCanvas;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OffscreenCanvasRenderingContext2D) */
interface OffscreenCanvasRenderingContext2D extends CanvasCompositing, CanvasDrawImage, CanvasDrawPath, CanvasFillStrokeStyles, CanvasFilters, CanvasImageData, CanvasImageSmoothing, CanvasPathDrawingStyles, CanvasPathMethods, CanvasRect, CanvasShadowStyles, CanvasState, CanvasText, CanvasTextDrawingStyles, CanvasTransform {
    readonly canvas: OffscreenCanvas;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OffscreenCanvasRenderingContext2D/commit) */
    commit(): void;
}

declare var OffscreenCanvasRenderingContext2D: {
    prototype: OffscreenCanvasRenderingContext2D;
    new(): OffscreenCanvasRenderingContext2D;
    isInstance(obj): obj is OffscreenCanvasRenderingContext2D;
};

interface OnErrorEventHandlerForNodesEventMap {
    "error": ErrorEvent;
}

interface OnErrorEventHandlerForNodes {
    onerror: OnErrorEventHandler;
    addEventListener<K extends keyof OnErrorEventHandlerForNodesEventMap>(type: K, listener: (this: OnErrorEventHandlerForNodes, ev: OnErrorEventHandlerForNodesEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof OnErrorEventHandlerForNodesEventMap>(type: K, listener: (this: OnErrorEventHandlerForNodes, ev: OnErrorEventHandlerForNodesEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

interface OnErrorEventHandlerForWindowEventMap {
    "error": ErrorEvent;
}

interface OnErrorEventHandlerForWindow {
    onerror: OnErrorEventHandler;
    addEventListener<K extends keyof OnErrorEventHandlerForWindowEventMap>(type: K, listener: (this: OnErrorEventHandlerForWindow, ev: OnErrorEventHandlerForWindowEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof OnErrorEventHandlerForWindowEventMap>(type: K, listener: (this: OnErrorEventHandlerForWindow, ev: OnErrorEventHandlerForWindowEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

/**
 * The OscillatorNode interface represents a periodic waveform, such as a sine wave. It is an AudioScheduledSourceNode audio-processing module that causes a specified frequency of a given wave to be created—in effect, a constant tone.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/OscillatorNode)
 */
interface OscillatorNode extends AudioScheduledSourceNode, AudioNodePassThrough {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OscillatorNode/detune) */
    readonly detune: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OscillatorNode/frequency) */
    readonly frequency: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OscillatorNode/type) */
    type: OscillatorType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/OscillatorNode/setPeriodicWave) */
    setPeriodicWave(periodicWave: PeriodicWave): void;
    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: OscillatorNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: OscillatorNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var OscillatorNode: {
    prototype: OscillatorNode;
    new(context: BaseAudioContext, options?: OscillatorOptions): OscillatorNode;
    isInstance(obj): obj is OscillatorNode;
};

/**
 * The PageTransitionEvent is fired when a document is being loaded or unloaded.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PageTransitionEvent)
 */
interface PageTransitionEvent extends Event {
    readonly inFrameSwap: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PageTransitionEvent/persisted) */
    readonly persisted: boolean;
}

declare var PageTransitionEvent: {
    prototype: PageTransitionEvent;
    new(type: string, eventInitDict?: PageTransitionEventInit): PageTransitionEvent;
    isInstance(obj): obj is PageTransitionEvent;
};

interface PaintRequest {
    readonly clientRect: DOMRect;
    readonly reason: string;
}

declare var PaintRequest: {
    prototype: PaintRequest;
    new(): PaintRequest;
    isInstance(obj): obj is PaintRequest;
};

interface PaintRequestList {
    readonly length: number;
    item(index: number): PaintRequest | null;
    [index: number]: PaintRequest;
}

declare var PaintRequestList: {
    prototype: PaintRequestList;
    new(): PaintRequestList;
    isInstance(obj): obj is PaintRequestList;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaintWorkletGlobalScope) */
interface PaintWorkletGlobalScope extends WorkletGlobalScope {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaintWorkletGlobalScope/registerPaint) */
    registerPaint(name: string, paintCtor: VoidFunction): void;
}

declare var PaintWorkletGlobalScope: {
    prototype: PaintWorkletGlobalScope;
    new(): PaintWorkletGlobalScope;
    isInstance(obj): obj is PaintWorkletGlobalScope;
};

/**
 * A PannerNode always has exactly one input and one output: the input can be mono or stereo but the output is always stereo (2 channels); you can't have panning effects without at least two audio channels!
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode)
 */
interface PannerNode extends AudioNode, AudioNodePassThrough {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/coneInnerAngle) */
    coneInnerAngle: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/coneOuterAngle) */
    coneOuterAngle: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/coneOuterGain) */
    coneOuterGain: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/distanceModel) */
    distanceModel: DistanceModelType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/maxDistance) */
    maxDistance: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/orientationX) */
    readonly orientationX: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/orientationY) */
    readonly orientationY: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/orientationZ) */
    readonly orientationZ: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/panningModel) */
    panningModel: PanningModelType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/positionX) */
    readonly positionX: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/positionY) */
    readonly positionY: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/positionZ) */
    readonly positionZ: AudioParam;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/refDistance) */
    refDistance: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/rolloffFactor) */
    rolloffFactor: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/setOrientation)
     */
    setOrientation(x: number, y: number, z: number): void;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PannerNode/setPosition)
     */
    setPosition(x: number, y: number, z: number): void;
}

declare var PannerNode: {
    prototype: PannerNode;
    new(context: BaseAudioContext, options?: PannerOptions): PannerNode;
    isInstance(obj): obj is PannerNode;
};

interface ParentNode {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/childElementCount) */
    readonly childElementCount: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/children) */
    readonly children: HTMLCollection;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/firstElementChild) */
    readonly firstElementChild: Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/lastElementChild) */
    readonly lastElementChild: Element | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/append) */
    append(...nodes: (Node | string)[]): void;
    getElementsByAttribute(name: string, value: string | null): HTMLCollection;
    getElementsByAttributeNS(namespaceURI: string | null, name: string, value: string | null): HTMLCollection;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/prepend) */
    prepend(...nodes: (Node | string)[]): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/replaceChildren) */
    replaceChildren(...nodes: (Node | string)[]): void;
}

interface ParentProcessMessageManager extends MessageBroadcaster, GlobalProcessScriptLoader, ProcessScriptLoader {
}

declare var ParentProcessMessageManager: {
    prototype: ParentProcessMessageManager;
    new(): ParentProcessMessageManager;
    isInstance(obj): obj is ParentProcessMessageManager;
};

/**
 * This Canvas 2D API interface is used to declare a path that can then be used on a CanvasRenderingContext2D object. The path methods of the CanvasRenderingContext2D interface are also present on this interface, which gives you the convenience of being able to retain and replay your path whenever desired.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Path2D)
 */
interface Path2D extends CanvasPathMethods {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Path2D/addPath) */
    addPath(path: Path2D, transform?: DOMMatrix2DInit): void;
}

declare var Path2D: {
    prototype: Path2D;
    new(): Path2D;
    new(other: Path2D): Path2D;
    new(pathString: string): Path2D;
    isInstance(obj): obj is Path2D;
};

/**
 * This Payment Request API interface is used to store shipping or payment address information.
 * @deprecated
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentAddress)
 */
interface PaymentAddress {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentAddress/addressLine)
     */
    readonly addressLine: string[];
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentAddress/city)
     */
    readonly city: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentAddress/country)
     */
    readonly country: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentAddress/dependentLocality)
     */
    readonly dependentLocality: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentAddress/organization)
     */
    readonly organization: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentAddress/phone)
     */
    readonly phone: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentAddress/postalCode)
     */
    readonly postalCode: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentAddress/recipient)
     */
    readonly recipient: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentAddress/region)
     */
    readonly region: string;
    readonly regionCode: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentAddress/sortingCode)
     */
    readonly sortingCode: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentAddress/toJSON)
     */
    toJSON(): any;
}

/** @deprecated */
declare var PaymentAddress: {
    prototype: PaymentAddress;
    new(): PaymentAddress;
    isInstance(obj): obj is PaymentAddress;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentMethodChangeEvent)
 */
interface PaymentMethodChangeEvent extends PaymentRequestUpdateEvent {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentMethodChangeEvent/methodDetails) */
    readonly methodDetails: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentMethodChangeEvent/methodName) */
    readonly methodName: string;
}

declare var PaymentMethodChangeEvent: {
    prototype: PaymentMethodChangeEvent;
    new(type: string, eventInitDict?: PaymentMethodChangeEventInit): PaymentMethodChangeEvent;
    isInstance(obj): obj is PaymentMethodChangeEvent;
};

interface PaymentRequestEventMap {
    "merchantvalidation": Event;
    "paymentmethodchange": Event;
    "shippingaddresschange": Event;
    "shippingoptionchange": Event;
}

/**
 * This Payment Request API interface is the primary access point into the API, and lets web content and apps accept payments from the end user.
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequest)
 */
interface PaymentRequest extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequest/id) */
    readonly id: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequest/merchantvalidation_event)
     */
    onmerchantvalidation: ((this: PaymentRequest, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequest/paymentmethodchange_event) */
    onpaymentmethodchange: ((this: PaymentRequest, ev: Event) => any) | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequest/shippingaddresschange_event)
     */
    onshippingaddresschange: ((this: PaymentRequest, ev: Event) => any) | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequest/shippingoptionchange_event)
     */
    onshippingoptionchange: ((this: PaymentRequest, ev: Event) => any) | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequest/shippingAddress)
     */
    readonly shippingAddress: PaymentAddress | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequest/shippingOption)
     */
    readonly shippingOption: string | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequest/shippingType)
     */
    readonly shippingType: PaymentShippingType | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequest/abort) */
    abort(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequest/canMakePayment) */
    canMakePayment(): Promise<boolean>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequest/show) */
    show(detailsPromise?: PaymentDetailsUpdate | PromiseLike<PaymentDetailsUpdate>): Promise<PaymentResponse>;
    addEventListener<K extends keyof PaymentRequestEventMap>(type: K, listener: (this: PaymentRequest, ev: PaymentRequestEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof PaymentRequestEventMap>(type: K, listener: (this: PaymentRequest, ev: PaymentRequestEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var PaymentRequest: {
    prototype: PaymentRequest;
    new(methodData: PaymentMethodData[], details: PaymentDetailsInit, options?: PaymentOptions): PaymentRequest;
    isInstance(obj): obj is PaymentRequest;
};

/**
 * This Payment Request API interface enables a web page to update the details of a PaymentRequest in response to a user action.
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequestUpdateEvent)
 */
interface PaymentRequestUpdateEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentRequestUpdateEvent/updateWith) */
    updateWith(detailsPromise: PaymentDetailsUpdate | PromiseLike<PaymentDetailsUpdate>): void;
}

declare var PaymentRequestUpdateEvent: {
    prototype: PaymentRequestUpdateEvent;
    new(type: string, eventInitDict?: PaymentRequestUpdateEventInit): PaymentRequestUpdateEvent;
    isInstance(obj): obj is PaymentRequestUpdateEvent;
};

interface PaymentResponseEventMap {
    "payerdetailchange": Event;
}

/**
 * This Payment Request API interface is returned after a user selects a payment method and approves a payment request.
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentResponse)
 */
interface PaymentResponse extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentResponse/details) */
    readonly details: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentResponse/methodName) */
    readonly methodName: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentResponse/payerdetailchange_event)
     */
    onpayerdetailchange: ((this: PaymentResponse, ev: Event) => any) | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentResponse/payerEmail)
     */
    readonly payerEmail: string | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentResponse/payerName)
     */
    readonly payerName: string | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentResponse/payerPhone)
     */
    readonly payerPhone: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentResponse/requestId) */
    readonly requestId: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentResponse/shippingAddress)
     */
    readonly shippingAddress: PaymentAddress | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentResponse/shippingOption)
     */
    readonly shippingOption: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentResponse/complete) */
    complete(result?: PaymentComplete): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentResponse/retry) */
    retry(errorFields?: PaymentValidationErrors): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PaymentResponse/toJSON) */
    toJSON(): any;
    addEventListener<K extends keyof PaymentResponseEventMap>(type: K, listener: (this: PaymentResponse, ev: PaymentResponseEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof PaymentResponseEventMap>(type: K, listener: (this: PaymentResponse, ev: PaymentResponseEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var PaymentResponse: {
    prototype: PaymentResponse;
    new(): PaymentResponse;
    isInstance(obj): obj is PaymentResponse;
};

interface PeerConnectionImpl {
    certificate: RTCCertificate;
    readonly connectionState: RTCPeerConnectionState;
    readonly currentLocalDescription: string;
    readonly currentOfferer: boolean | null;
    readonly currentRemoteDescription: string;
    readonly fingerprint: string;
    readonly iceConnectionState: RTCIceConnectionState;
    readonly iceGatheringState: RTCIceGatheringState;
    id: string;
    peerIdentity: string;
    readonly pendingLocalDescription: string;
    readonly pendingOfferer: boolean | null;
    readonly pendingRemoteDescription: string;
    readonly privacyRequested: boolean;
    readonly sctp: RTCSctpTransport | null;
    readonly signalingState: RTCSignalingState;
    addIceCandidate(candidate: string, mid: string, ufrag: string, level: number | null): void;
    addTransceiver(init: RTCRtpTransceiverInit, kind: string, sendTrack: MediaStreamTrack | null, addTrackMagic: boolean): RTCRtpTransceiver;
    chain(op: ChainedOperation): Promise<any>;
    close(): void;
    closeStreams(): void;
    createAnswer(): void;
    createDataChannel(label: string, protocol: string, type: number, ordered: boolean, maxTime: number, maxNum: number, externalNegotiated: boolean, stream: number): RTCDataChannel;
    createOffer(options?: RTCOfferOptions): void;
    createdSender(sender: RTCRtpSender): boolean;
    disablePacketDump(level: number, type: mozPacketDumpType, sending: boolean): void;
    enablePacketDump(level: number, type: mozPacketDumpType, sending: boolean): void;
    getRemoteStreams(): MediaStream[];
    getStats(selector: MediaStreamTrack | null): Promise<RTCStatsReport>;
    getTransceivers(): RTCRtpTransceiver[];
    initialize(observer: PeerConnectionObserver, window: Window): void;
    onSetDescriptionError(): void;
    onSetDescriptionSuccess(type: RTCSdpType, remote: boolean): Promise<void>;
    pluginCrash(pluginId: number, name: string): boolean;
    restartIce(): void;
    restartIceNoRenegotiationNeeded(): void;
    setConfiguration(config?: RTCConfiguration): void;
    setLocalDescription(action: number, sdp: string): void;
    setRemoteDescription(action: number, sdp: string): void;
    updateNegotiationNeeded(): void;
}

declare var PeerConnectionImpl: {
    prototype: PeerConnectionImpl;
    new(): PeerConnectionImpl;
    isInstance(obj): obj is PeerConnectionImpl;
};

interface PeerConnectionObserver {
    fireNegotiationNeededEvent(): void;
    fireStreamEvent(stream: MediaStream): void;
    fireTrackEvent(receiver: RTCRtpReceiver, streams: MediaStream[]): void;
    notifyDataChannel(channel: RTCDataChannel): void;
    onAddIceCandidateError(error: PCErrorData): void;
    onAddIceCandidateSuccess(): void;
    onCreateAnswerError(error: PCErrorData): void;
    onCreateAnswerSuccess(answer: string): void;
    onCreateOfferError(error: PCErrorData): void;
    onCreateOfferSuccess(offer: string): void;
    onIceCandidate(level: number, mid: string, candidate: string, ufrag: string): void;
    onPacket(level: number, type: mozPacketDumpType, sending: boolean, packet: ArrayBuffer): void;
    onSetDescriptionError(error: PCErrorData): void;
    onSetDescriptionSuccess(): void;
    onStateChange(state: PCObserverStateType): void;
}

declare var PeerConnectionObserver: {
    prototype: PeerConnectionObserver;
    new(domPC: RTCPeerConnection): PeerConnectionObserver;
    isInstance(obj): obj is PeerConnectionObserver;
};

interface PerformanceEventMap {
    "resourcetimingbufferfull": Event;
}

/**
 * Provides access to performance-related information for the current page. It's part of the High Resolution Time API, but is enhanced by the Performance Timeline API, the Navigation Timing API, the User Timing API, and the Resource Timing API.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance)
 */
interface Performance extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/eventCounts) */
    readonly eventCounts: EventCounts;
    readonly mozMemory: any;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/navigation)
     */
    readonly navigation: PerformanceNavigation;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/resourcetimingbufferfull_event) */
    onresourcetimingbufferfull: ((this: Performance, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/timeOrigin) */
    readonly timeOrigin: DOMHighResTimeStamp;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/timing)
     */
    readonly timing: PerformanceTiming;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/clearMarks) */
    clearMarks(markName?: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/clearMeasures) */
    clearMeasures(measureName?: string): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/clearResourceTimings) */
    clearResourceTimings(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/getEntries) */
    getEntries(): PerformanceEntryList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/getEntriesByName) */
    getEntriesByName(name: string, entryType?: string): PerformanceEntryList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/getEntriesByType) */
    getEntriesByType(entryType: string): PerformanceEntryList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/mark) */
    mark(markName: string, markOptions?: PerformanceMarkOptions): PerformanceMark;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/measure) */
    measure(measureName: string, startOrMeasureOptions?: string | PerformanceMeasureOptions, endMark?: string): PerformanceMeasure;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/now) */
    now(): DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/setResourceTimingBufferSize) */
    setResourceTimingBufferSize(maxSize: number): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Performance/toJSON) */
    toJSON(): any;
    addEventListener<K extends keyof PerformanceEventMap>(type: K, listener: (this: Performance, ev: PerformanceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof PerformanceEventMap>(type: K, listener: (this: Performance, ev: PerformanceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var Performance: {
    prototype: Performance;
    new(): Performance;
    isInstance(obj): obj is Performance;
};

/**
 * Encapsulates a single performance metric that is part of the performance timeline. A performance entry can be directly created by making a performance mark or measure (for example by calling the mark() method) at an explicit point in an application. Performance entries are also created in indirect ways such as loading a resource (such as an image).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceEntry)
 */
interface PerformanceEntry {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceEntry/duration) */
    readonly duration: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceEntry/entryType) */
    readonly entryType: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceEntry/name) */
    readonly name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceEntry/startTime) */
    readonly startTime: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceEntry/toJSON) */
    toJSON(): any;
}

declare var PerformanceEntry: {
    prototype: PerformanceEntry;
    new(): PerformanceEntry;
    isInstance(obj): obj is PerformanceEntry;
};

interface PerformanceEntryEvent extends Event {
    readonly duration: DOMHighResTimeStamp;
    readonly entryType: string;
    readonly epoch: number;
    readonly name: string;
    readonly origin: string;
    readonly startTime: DOMHighResTimeStamp;
}

declare var PerformanceEntryEvent: {
    prototype: PerformanceEntryEvent;
    new(type: string, eventInitDict?: PerformanceEntryEventInit): PerformanceEntryEvent;
    isInstance(obj): obj is PerformanceEntryEvent;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceEventTiming) */
interface PerformanceEventTiming extends PerformanceEntry {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceEventTiming/cancelable) */
    readonly cancelable: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceEventTiming/processingEnd) */
    readonly processingEnd: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceEventTiming/processingStart) */
    readonly processingStart: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceEventTiming/target) */
    readonly target: Node | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceEventTiming/toJSON) */
    toJSON(): any;
}

declare var PerformanceEventTiming: {
    prototype: PerformanceEventTiming;
    new(): PerformanceEventTiming;
    isInstance(obj): obj is PerformanceEventTiming;
};

/**
 * PerformanceMark is an abstract interface for PerformanceEntry objects with an entryType of "mark". Entries of this type are created by calling performance.mark() to add a named DOMHighResTimeStamp (the mark) to the browser's performance timeline.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceMark)
 */
interface PerformanceMark extends PerformanceEntry {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceMark/detail) */
    readonly detail: any;
}

declare var PerformanceMark: {
    prototype: PerformanceMark;
    new(markName: string, markOptions?: PerformanceMarkOptions): PerformanceMark;
    isInstance(obj): obj is PerformanceMark;
};

/**
 * PerformanceMeasure is an abstract interface for PerformanceEntry objects with an entryType of "measure". Entries of this type are created by calling performance.measure() to add a named DOMHighResTimeStamp (the measure) between two marks to the browser's performance timeline.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceMeasure)
 */
interface PerformanceMeasure extends PerformanceEntry {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceMeasure/detail) */
    readonly detail: any;
}

declare var PerformanceMeasure: {
    prototype: PerformanceMeasure;
    new(): PerformanceMeasure;
    isInstance(obj): obj is PerformanceMeasure;
};

/**
 * The legacy PerformanceNavigation interface represents information about how the navigation to the current document was done.
 * @deprecated This interface is deprecated in the Navigation Timing Level 2 specification. Please use the PerformanceNavigationTiming interface instead.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigation)
 */
interface PerformanceNavigation {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigation/redirectCount)
     */
    readonly redirectCount: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigation/type)
     */
    readonly type: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigation/toJSON)
     */
    toJSON(): any;
    readonly TYPE_NAVIGATE: 0;
    readonly TYPE_RELOAD: 1;
    readonly TYPE_BACK_FORWARD: 2;
    readonly TYPE_RESERVED: 255;
}

/** @deprecated */
declare var PerformanceNavigation: {
    prototype: PerformanceNavigation;
    new(): PerformanceNavigation;
    readonly TYPE_NAVIGATE: 0;
    readonly TYPE_RELOAD: 1;
    readonly TYPE_BACK_FORWARD: 2;
    readonly TYPE_RESERVED: 255;
    isInstance(obj): obj is PerformanceNavigation;
};

/**
 * Provides methods and properties to store and retrieve metrics regarding the browser's document navigation events. For example, this interface can be used to determine how much time it takes to load or unload a document.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigationTiming)
 */
interface PerformanceNavigationTiming extends PerformanceResourceTiming {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigationTiming/domComplete) */
    readonly domComplete: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigationTiming/domContentLoadedEventEnd) */
    readonly domContentLoadedEventEnd: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigationTiming/domContentLoadedEventStart) */
    readonly domContentLoadedEventStart: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigationTiming/domInteractive) */
    readonly domInteractive: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigationTiming/loadEventEnd) */
    readonly loadEventEnd: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigationTiming/loadEventStart) */
    readonly loadEventStart: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigationTiming/redirectCount) */
    readonly redirectCount: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigationTiming/type) */
    readonly type: NavigationType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigationTiming/unloadEventEnd) */
    readonly unloadEventEnd: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigationTiming/unloadEventStart) */
    readonly unloadEventStart: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceNavigationTiming/toJSON) */
    toJSON(): any;
}

declare var PerformanceNavigationTiming: {
    prototype: PerformanceNavigationTiming;
    new(): PerformanceNavigationTiming;
    isInstance(obj): obj is PerformanceNavigationTiming;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceObserver) */
interface PerformanceObserver {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceObserver/disconnect) */
    disconnect(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceObserver/observe) */
    observe(options?: PerformanceObserverInit): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceObserver/takeRecords) */
    takeRecords(): PerformanceEntryList;
}

declare var PerformanceObserver: {
    prototype: PerformanceObserver;
    new(callback: PerformanceObserverCallback): PerformanceObserver;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceObserver/supportedEntryTypes_static) */
    readonly supportedEntryTypes: any;
    isInstance(obj): obj is PerformanceObserver;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceObserverEntryList) */
interface PerformanceObserverEntryList {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceObserverEntryList/getEntries) */
    getEntries(filter?: PerformanceEntryFilterOptions): PerformanceEntryList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceObserverEntryList/getEntriesByName) */
    getEntriesByName(name: string, entryType?: string): PerformanceEntryList;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceObserverEntryList/getEntriesByType) */
    getEntriesByType(entryType: string): PerformanceEntryList;
}

declare var PerformanceObserverEntryList: {
    prototype: PerformanceObserverEntryList;
    new(): PerformanceObserverEntryList;
    isInstance(obj): obj is PerformanceObserverEntryList;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformancePaintTiming) */
interface PerformancePaintTiming extends PerformanceEntry {
}

declare var PerformancePaintTiming: {
    prototype: PerformancePaintTiming;
    new(): PerformancePaintTiming;
    isInstance(obj): obj is PerformancePaintTiming;
};

/**
 * Enables retrieval and analysis of detailed network timing data regarding the loading of an application's resources. An application can use the timing metrics to determine, for example, the length of time it takes to fetch a specific resource, such as an XMLHttpRequest, <SVG>, image, or script.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming)
 */
interface PerformanceResourceTiming extends PerformanceEntry {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/connectEnd) */
    readonly connectEnd: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/connectStart) */
    readonly connectStart: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/decodedBodySize) */
    readonly decodedBodySize: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/domainLookupEnd) */
    readonly domainLookupEnd: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/domainLookupStart) */
    readonly domainLookupStart: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/encodedBodySize) */
    readonly encodedBodySize: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/fetchStart) */
    readonly fetchStart: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/initiatorType) */
    readonly initiatorType: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/nextHopProtocol) */
    readonly nextHopProtocol: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/redirectEnd) */
    readonly redirectEnd: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/redirectStart) */
    readonly redirectStart: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/requestStart) */
    readonly requestStart: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/responseEnd) */
    readonly responseEnd: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/responseStart) */
    readonly responseStart: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/secureConnectionStart) */
    readonly secureConnectionStart: DOMHighResTimeStamp;
    /**
     * Available only in secure contexts.
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/serverTiming)
     */
    readonly serverTiming: PerformanceServerTiming[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/transferSize) */
    readonly transferSize: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/workerStart) */
    readonly workerStart: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceResourceTiming/toJSON) */
    toJSON(): any;
}

declare var PerformanceResourceTiming: {
    prototype: PerformanceResourceTiming;
    new(): PerformanceResourceTiming;
    isInstance(obj): obj is PerformanceResourceTiming;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceServerTiming)
 */
interface PerformanceServerTiming {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceServerTiming/description) */
    readonly description: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceServerTiming/duration) */
    readonly duration: DOMHighResTimeStamp;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceServerTiming/name) */
    readonly name: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceServerTiming/toJSON) */
    toJSON(): any;
}

declare var PerformanceServerTiming: {
    prototype: PerformanceServerTiming;
    new(): PerformanceServerTiming;
    isInstance(obj): obj is PerformanceServerTiming;
};

/**
 * A legacy interface kept for backwards compatibility and contains properties that offer performance timing information for various events which occur during the loading and use of the current page. You get a PerformanceTiming object describing your page using the window.performance.timing property.
 * @deprecated This interface is deprecated in the Navigation Timing Level 2 specification. Please use the PerformanceNavigationTiming interface instead.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming)
 */
interface PerformanceTiming {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/connectEnd)
     */
    readonly connectEnd: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/connectStart)
     */
    readonly connectStart: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/domComplete)
     */
    readonly domComplete: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/domContentLoadedEventEnd)
     */
    readonly domContentLoadedEventEnd: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/domContentLoadedEventStart)
     */
    readonly domContentLoadedEventStart: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/domInteractive)
     */
    readonly domInteractive: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/domLoading)
     */
    readonly domLoading: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/domainLookupEnd)
     */
    readonly domainLookupEnd: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/domainLookupStart)
     */
    readonly domainLookupStart: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/fetchStart)
     */
    readonly fetchStart: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/loadEventEnd)
     */
    readonly loadEventEnd: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/loadEventStart)
     */
    readonly loadEventStart: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/navigationStart)
     */
    readonly navigationStart: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/redirectEnd)
     */
    readonly redirectEnd: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/redirectStart)
     */
    readonly redirectStart: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/requestStart)
     */
    readonly requestStart: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/responseEnd)
     */
    readonly responseEnd: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/responseStart)
     */
    readonly responseStart: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/secureConnectionStart)
     */
    readonly secureConnectionStart: number;
    readonly timeToContentfulPaint: number;
    readonly timeToDOMContentFlushed: number;
    readonly timeToFirstInteractive: number;
    readonly timeToNonBlankPaint: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/unloadEventEnd)
     */
    readonly unloadEventEnd: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/unloadEventStart)
     */
    readonly unloadEventStart: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PerformanceTiming/toJSON)
     */
    toJSON(): any;
}

/** @deprecated */
declare var PerformanceTiming: {
    prototype: PerformanceTiming;
    new(): PerformanceTiming;
    isInstance(obj): obj is PerformanceTiming;
};

/**
 * PeriodicWave has no inputs or outputs; it is used to define custom oscillators when calling OscillatorNode.setPeriodicWave(). The PeriodicWave itself is created/returned by AudioContext.createPeriodicWave().
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PeriodicWave)
 */
interface PeriodicWave {
}

declare var PeriodicWave: {
    prototype: PeriodicWave;
    new(context: BaseAudioContext, options?: PeriodicWaveOptions): PeriodicWave;
    isInstance(obj): obj is PeriodicWave;
};

interface PermissionStatusEventMap {
    "change": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PermissionStatus) */
interface PermissionStatus extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PermissionStatus/name) */
    readonly name: PermissionName;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PermissionStatus/change_event) */
    onchange: ((this: PermissionStatus, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PermissionStatus/state) */
    readonly state: PermissionState;
    addEventListener<K extends keyof PermissionStatusEventMap>(type: K, listener: (this: PermissionStatus, ev: PermissionStatusEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof PermissionStatusEventMap>(type: K, listener: (this: PermissionStatus, ev: PermissionStatusEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var PermissionStatus: {
    prototype: PermissionStatus;
    new(): PermissionStatus;
    isInstance(obj): obj is PermissionStatus;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Permissions) */
interface Permissions {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Permissions/query) */
    query(permission: any): Promise<PermissionStatus>;
}

declare var Permissions: {
    prototype: Permissions;
    new(): Permissions;
    isInstance(obj): obj is Permissions;
};

interface PlacesBookmark extends PlacesEvent {
    readonly guid: string;
    readonly id: number;
    readonly isTagging: boolean;
    readonly itemType: number;
    readonly parentGuid: string;
    readonly parentId: number;
    readonly source: number;
    readonly url: string;
}

declare var PlacesBookmark: {
    prototype: PlacesBookmark;
    new(): PlacesBookmark;
    isInstance(obj): obj is PlacesBookmark;
};

interface PlacesBookmarkAddition extends PlacesBookmark {
    readonly dateAdded: number;
    readonly frecency: number;
    readonly hidden: boolean;
    readonly index: number;
    readonly lastVisitDate: number | null;
    readonly tags: string;
    readonly targetFolderGuid: string;
    readonly targetFolderItemId: number;
    readonly targetFolderTitle: string;
    readonly title: string;
    readonly visitCount: number;
}

declare var PlacesBookmarkAddition: {
    prototype: PlacesBookmarkAddition;
    new(initDict: PlacesBookmarkAdditionInit): PlacesBookmarkAddition;
    isInstance(obj): obj is PlacesBookmarkAddition;
};

interface PlacesBookmarkChanged extends PlacesBookmark {
    readonly lastModified: number;
}

declare var PlacesBookmarkChanged: {
    prototype: PlacesBookmarkChanged;
    new(): PlacesBookmarkChanged;
    isInstance(obj): obj is PlacesBookmarkChanged;
};

interface PlacesBookmarkGuid extends PlacesBookmarkChanged {
}

declare var PlacesBookmarkGuid: {
    prototype: PlacesBookmarkGuid;
    new(initDict: PlacesBookmarkGuidInit): PlacesBookmarkGuid;
    isInstance(obj): obj is PlacesBookmarkGuid;
};

interface PlacesBookmarkKeyword extends PlacesBookmarkChanged {
    readonly keyword: string;
}

declare var PlacesBookmarkKeyword: {
    prototype: PlacesBookmarkKeyword;
    new(initDict: PlacesBookmarkKeywordInit): PlacesBookmarkKeyword;
    isInstance(obj): obj is PlacesBookmarkKeyword;
};

interface PlacesBookmarkMoved extends PlacesBookmark {
    readonly dateAdded: number;
    readonly frecency: number;
    readonly hidden: boolean;
    readonly index: number;
    readonly lastVisitDate: number | null;
    readonly oldIndex: number;
    readonly oldParentGuid: string;
    readonly tags: string;
    readonly title: string;
    readonly visitCount: number;
}

declare var PlacesBookmarkMoved: {
    prototype: PlacesBookmarkMoved;
    new(initDict: PlacesBookmarkMovedInit): PlacesBookmarkMoved;
    isInstance(obj): obj is PlacesBookmarkMoved;
};

interface PlacesBookmarkRemoved extends PlacesBookmark {
    readonly index: number;
    readonly isDescendantRemoval: boolean;
    readonly title: string;
}

declare var PlacesBookmarkRemoved: {
    prototype: PlacesBookmarkRemoved;
    new(initDict: PlacesBookmarkRemovedInit): PlacesBookmarkRemoved;
    isInstance(obj): obj is PlacesBookmarkRemoved;
};

interface PlacesBookmarkTags extends PlacesBookmarkChanged {
    readonly tags: string[];
}

declare var PlacesBookmarkTags: {
    prototype: PlacesBookmarkTags;
    new(initDict: PlacesBookmarkTagsInit): PlacesBookmarkTags;
    isInstance(obj): obj is PlacesBookmarkTags;
};

interface PlacesBookmarkTime extends PlacesBookmarkChanged {
    readonly dateAdded: number;
}

declare var PlacesBookmarkTime: {
    prototype: PlacesBookmarkTime;
    new(initDict: PlacesBookmarkTimeInit): PlacesBookmarkTime;
    isInstance(obj): obj is PlacesBookmarkTime;
};

interface PlacesBookmarkTitle extends PlacesBookmarkChanged {
    readonly title: string;
}

declare var PlacesBookmarkTitle: {
    prototype: PlacesBookmarkTitle;
    new(initDict: PlacesBookmarkTitleInit): PlacesBookmarkTitle;
    isInstance(obj): obj is PlacesBookmarkTitle;
};

interface PlacesBookmarkUrl extends PlacesBookmarkChanged {
}

declare var PlacesBookmarkUrl: {
    prototype: PlacesBookmarkUrl;
    new(initDict: PlacesBookmarkUrlInit): PlacesBookmarkUrl;
    isInstance(obj): obj is PlacesBookmarkUrl;
};

interface PlacesEvent {
    readonly type: PlacesEventType;
}

declare var PlacesEvent: {
    prototype: PlacesEvent;
    new(): PlacesEvent;
    isInstance(obj): obj is PlacesEvent;
};

interface PlacesFavicon extends PlacesEvent {
    readonly faviconUrl: string;
    readonly pageGuid: string;
    readonly url: string;
}

declare var PlacesFavicon: {
    prototype: PlacesFavicon;
    new(initDict: PlacesFaviconInit): PlacesFavicon;
    isInstance(obj): obj is PlacesFavicon;
};

interface PlacesHistoryCleared extends PlacesEvent {
}

declare var PlacesHistoryCleared: {
    prototype: PlacesHistoryCleared;
    new(): PlacesHistoryCleared;
    isInstance(obj): obj is PlacesHistoryCleared;
};

interface PlacesPurgeCaches extends PlacesEvent {
}

declare var PlacesPurgeCaches: {
    prototype: PlacesPurgeCaches;
    new(): PlacesPurgeCaches;
    isInstance(obj): obj is PlacesPurgeCaches;
};

interface PlacesRanking extends PlacesEvent {
}

declare var PlacesRanking: {
    prototype: PlacesRanking;
    new(): PlacesRanking;
    isInstance(obj): obj is PlacesRanking;
};

interface PlacesVisit extends PlacesEvent {
    readonly frecency: number;
    readonly hidden: boolean;
    readonly lastKnownTitle: string | null;
    readonly pageGuid: string;
    readonly referringVisitId: number;
    readonly transitionType: number;
    readonly typedCount: number;
    readonly url: string;
    readonly visitCount: number;
    readonly visitId: number;
    readonly visitTime: number;
}

declare var PlacesVisit: {
    prototype: PlacesVisit;
    new(): PlacesVisit;
    isInstance(obj): obj is PlacesVisit;
};

interface PlacesVisitRemoved extends PlacesEvent {
    readonly isPartialVisistsRemoval: boolean;
    readonly isRemovedFromStore: boolean;
    readonly pageGuid: string;
    readonly reason: number;
    readonly transitionType: number;
    readonly url: string;
    readonly REASON_DELETED: 0;
    readonly REASON_EXPIRED: 1;
}

declare var PlacesVisitRemoved: {
    prototype: PlacesVisitRemoved;
    new(initDict: PlacesVisitRemovedInit): PlacesVisitRemoved;
    readonly REASON_DELETED: 0;
    readonly REASON_EXPIRED: 1;
    isInstance(obj): obj is PlacesVisitRemoved;
};

interface PlacesVisitTitle extends PlacesEvent {
    readonly pageGuid: string;
    readonly title: string;
    readonly url: string;
}

declare var PlacesVisitTitle: {
    prototype: PlacesVisitTitle;
    new(initDict: PlacesVisitTitleInit): PlacesVisitTitle;
    isInstance(obj): obj is PlacesVisitTitle;
};

interface PlacesWeakCallbackWrapper {
}

declare var PlacesWeakCallbackWrapper: {
    prototype: PlacesWeakCallbackWrapper;
    new(callback: PlacesEventCallback): PlacesWeakCallbackWrapper;
    isInstance(obj): obj is PlacesWeakCallbackWrapper;
};

/**
 * Provides information about a browser plugin.
 * @deprecated
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Plugin)
 */
interface Plugin {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Plugin/description)
     */
    readonly description: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Plugin/filename)
     */
    readonly filename: string;
    /** @deprecated */
    readonly length: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Plugin/name)
     */
    readonly name: string;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Plugin/item)
     */
    item(index: number): MimeType | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Plugin/namedItem)
     */
    namedItem(name: string): MimeType | null;
    [index: number]: MimeType;
}

/** @deprecated */
declare var Plugin: {
    prototype: Plugin;
    new(): Plugin;
    isInstance(obj): obj is Plugin;
};

/**
 * Used to store a list of Plugin objects describing the available plugins; it's returned by the window.navigator.plugins property. The PluginArray is not a JavaScript array, but has the length property and supports accessing individual items using bracket notation (plugins[2]), as well as via item(index) and namedItem("name") methods.
 * @deprecated
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PluginArray)
 */
interface PluginArray {
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PluginArray/length)
     */
    readonly length: number;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PluginArray/item)
     */
    item(index: number): Plugin | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PluginArray/namedItem)
     */
    namedItem(name: string): Plugin | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PluginArray/refresh)
     */
    refresh(): void;
    [index: number]: Plugin;
}

/** @deprecated */
declare var PluginArray: {
    prototype: PluginArray;
    new(): PluginArray;
    isInstance(obj): obj is PluginArray;
};

interface PluginCrashedEvent extends Event {
    readonly gmpPlugin: boolean;
    readonly pluginDumpID: string;
    readonly pluginFilename: string | null;
    readonly pluginID: number;
    readonly pluginName: string;
    readonly submittedCrashReport: boolean;
}

declare var PluginCrashedEvent: {
    prototype: PluginCrashedEvent;
    new(type: string, eventInitDict?: PluginCrashedEventInit): PluginCrashedEvent;
    isInstance(obj): obj is PluginCrashedEvent;
};

/**
 * The state of a DOM event produced by a pointer such as the geometry of the contact point, the device type that generated the event, the amount of pressure that was applied on the contact surface, etc.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PointerEvent)
 */
interface PointerEvent extends MouseEvent {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PointerEvent/height) */
    readonly height: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PointerEvent/isPrimary) */
    readonly isPrimary: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PointerEvent/pointerId) */
    readonly pointerId: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PointerEvent/pointerType) */
    readonly pointerType: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PointerEvent/pressure) */
    readonly pressure: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PointerEvent/tangentialPressure) */
    readonly tangentialPressure: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PointerEvent/tiltX) */
    readonly tiltX: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PointerEvent/tiltY) */
    readonly tiltY: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PointerEvent/twist) */
    readonly twist: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PointerEvent/width) */
    readonly width: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PointerEvent/getCoalescedEvents) */
    getCoalescedEvents(): PointerEvent[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PointerEvent/getPredictedEvents) */
    getPredictedEvents(): PointerEvent[];
}

declare var PointerEvent: {
    prototype: PointerEvent;
    new(type: string, eventInitDict?: PointerEventInit): PointerEvent;
    isInstance(obj): obj is PointerEvent;
};

/**
 * PopStateEvent is an event handler for the popstate event on the window.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PopStateEvent)
 */
interface PopStateEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PopStateEvent/state) */
    readonly state: any;
}

declare var PopStateEvent: {
    prototype: PopStateEvent;
    new(type: string, eventInitDict?: PopStateEventInit): PopStateEvent;
    isInstance(obj): obj is PopStateEvent;
};

interface PopoverInvokerElement {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/popoverTargetAction) */
    popoverTargetAction: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/popoverTargetElement) */
    popoverTargetElement: Element | null;
}

interface PopupBlockedEvent extends Event {
    readonly popupWindowFeatures: string | null;
    readonly popupWindowName: string | null;
    readonly popupWindowURI: URI | null;
    readonly requestingWindow: Window | null;
}

declare var PopupBlockedEvent: {
    prototype: PopupBlockedEvent;
    new(type: string, eventInitDict?: PopupBlockedEventInit): PopupBlockedEvent;
    isInstance(obj): obj is PopupBlockedEvent;
};

interface PopupPositionedEvent extends Event {
    readonly alignmentOffset: number;
    readonly alignmentPosition: string;
    readonly isAnchored: boolean;
    readonly popupAlignment: string;
}

declare var PopupPositionedEvent: {
    prototype: PopupPositionedEvent;
    new(type: string, init?: PopupPositionedEventInit): PopupPositionedEvent;
    isInstance(obj): obj is PopupPositionedEvent;
};

interface PositionStateEvent extends Event {
    readonly duration: number;
    readonly playbackRate: number;
    readonly position: number;
}

declare var PositionStateEvent: {
    prototype: PositionStateEvent;
    new(type: string, eventInitDict?: PositionStateEventInit): PositionStateEvent;
    isInstance(obj): obj is PositionStateEvent;
};

interface PrecompiledScript {
    readonly hasReturnValue: boolean;
    readonly url: string;
    executeInGlobal(global: any, options?: ExecuteInGlobalOptions): any;
}

declare var PrecompiledScript: {
    prototype: PrecompiledScript;
    new(): PrecompiledScript;
    isInstance(obj): obj is PrecompiledScript;
};

interface ProcessMessageManager extends MessageSender, ProcessScriptLoader {
    readonly isInProcess: boolean;
    readonly osPid: number;
}

declare var ProcessMessageManager: {
    prototype: ProcessMessageManager;
    new(): ProcessMessageManager;
    isInstance(obj): obj is ProcessMessageManager;
};

interface ProcessScriptLoader {
    getDelayedProcessScripts(): any[][];
    loadProcessScript(url: string, allowDelayedLoad: boolean): void;
    removeDelayedProcessScript(url: string): void;
}

/**
 * A processing instruction embeds application-specific instructions in XML which can be ignored by other applications that don't recognize them.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ProcessingInstruction)
 */
interface ProcessingInstruction extends CharacterData, LinkStyle {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ProcessingInstruction/target) */
    readonly target: string;
}

declare var ProcessingInstruction: {
    prototype: ProcessingInstruction;
    new(): ProcessingInstruction;
    isInstance(obj): obj is ProcessingInstruction;
};

/**
 * Events measuring progress of an underlying process, like an HTTP request (for an XMLHttpRequest, or the loading of the underlying resource of an <img>, <audio>, <video>, <style> or <link>).
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ProgressEvent)
 */
interface ProgressEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ProgressEvent/lengthComputable) */
    readonly lengthComputable: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ProgressEvent/loaded) */
    readonly loaded: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ProgressEvent/total) */
    readonly total: number;
}

declare var ProgressEvent: {
    prototype: ProgressEvent;
    new(type: string, eventInitDict?: ProgressEventInit): ProgressEvent;
    isInstance(obj): obj is ProgressEvent;
};

interface PromiseNativeHandler {
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PromiseRejectionEvent) */
interface PromiseRejectionEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PromiseRejectionEvent/promise) */
    readonly promise: Promise<any>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PromiseRejectionEvent/reason) */
    readonly reason: any;
}

declare var PromiseRejectionEvent: {
    prototype: PromiseRejectionEvent;
    new(type: string, eventInitDict: PromiseRejectionEventInit): PromiseRejectionEvent;
    isInstance(obj): obj is PromiseRejectionEvent;
};

/**
 * Available only in secure contexts.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PublicKeyCredential)
 */
interface PublicKeyCredential extends Credential {
    readonly authenticatorAttachment: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PublicKeyCredential/rawId) */
    readonly rawId: ArrayBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PublicKeyCredential/response) */
    readonly response: AuthenticatorResponse;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PublicKeyCredential/getClientExtensionResults) */
    getClientExtensionResults(): AuthenticationExtensionsClientOutputs;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PublicKeyCredential/toJSON) */
    toJSON(): any;
}

declare var PublicKeyCredential: {
    prototype: PublicKeyCredential;
    new(): PublicKeyCredential;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PublicKeyCredential/isConditionalMediationAvailable) */
    isConditionalMediationAvailable(): Promise<boolean>;
    isExternalCTAP2SecurityKeySupported(): Promise<boolean>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PublicKeyCredential/isUserVerifyingPlatformAuthenticatorAvailable_static) */
    isUserVerifyingPlatformAuthenticatorAvailable(): Promise<boolean>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PublicKeyCredential/parseCreationOptionsFromJSON_static) */
    parseCreationOptionsFromJSON(options: PublicKeyCredentialCreationOptionsJSON): PublicKeyCredentialCreationOptions;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PublicKeyCredential/parseRequestOptionsFromJSON_static) */
    parseRequestOptionsFromJSON(options: PublicKeyCredentialRequestOptionsJSON): PublicKeyCredentialRequestOptions;
    isInstance(obj): obj is PublicKeyCredential;
};

/**
 * This Push API interface represents a push message that has been received. This event is sent to the global scope of a ServiceWorker. It contains the information sent from an application server to a PushSubscription.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushEvent)
 */
interface PushEvent extends ExtendableEvent {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushEvent/data) */
    readonly data: PushMessageData | null;
}

declare var PushEvent: {
    prototype: PushEvent;
    new(type: string, eventInitDict?: PushEventInit): PushEvent;
    isInstance(obj): obj is PushEvent;
};

/**
 * This Push API interface provides a way to receive notifications from third-party servers as well as request URLs for push notifications.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushManager)
 */
interface PushManager {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushManager/getSubscription) */
    getSubscription(): Promise<PushSubscription | null>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushManager/permissionState) */
    permissionState(options?: PushSubscriptionOptionsInit): Promise<PermissionState>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushManager/subscribe) */
    subscribe(options?: PushSubscriptionOptionsInit): Promise<PushSubscription>;
}

declare var PushManager: {
    prototype: PushManager;
    new(scope: string): PushManager;
    isInstance(obj): obj is PushManager;
};

interface PushManagerImpl {
    getSubscription(): Promise<PushSubscription | null>;
    permissionState(options?: PushSubscriptionOptionsInit): Promise<PermissionState>;
    subscribe(options?: PushSubscriptionOptionsInit): Promise<PushSubscription>;
}

declare var PushManagerImpl: {
    prototype: PushManagerImpl;
    new(scope: string): PushManagerImpl;
    isInstance(obj): obj is PushManagerImpl;
};

/**
 * This Push API interface provides methods which let you retrieve the push data sent by a server in various formats.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushMessageData)
 */
interface PushMessageData {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushMessageData/arrayBuffer) */
    arrayBuffer(): ArrayBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushMessageData/blob) */
    blob(): Blob;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushMessageData/json) */
    json(): any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushMessageData/text) */
    text(): string;
}

declare var PushMessageData: {
    prototype: PushMessageData;
    new(): PushMessageData;
    isInstance(obj): obj is PushMessageData;
};

/**
 * This Push API interface provides a subcription's URL endpoint and allows unsubscription from a push service.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushSubscription)
 */
interface PushSubscription {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushSubscription/endpoint) */
    readonly endpoint: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushSubscription/expirationTime) */
    readonly expirationTime: EpochTimeStamp | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushSubscription/options) */
    readonly options: PushSubscriptionOptions;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushSubscription/getKey) */
    getKey(name: PushEncryptionKeyName): ArrayBuffer | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushSubscription/toJSON) */
    toJSON(): PushSubscriptionJSON;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushSubscription/unsubscribe) */
    unsubscribe(): Promise<boolean>;
}

declare var PushSubscription: {
    prototype: PushSubscription;
    new(initDict: PushSubscriptionInit): PushSubscription;
    isInstance(obj): obj is PushSubscription;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushSubscriptionOptions) */
interface PushSubscriptionOptions {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/PushSubscriptionOptions/applicationServerKey) */
    readonly applicationServerKey: ArrayBuffer | null;
}

declare var PushSubscriptionOptions: {
    prototype: PushSubscriptionOptions;
    new(): PushSubscriptionOptions;
    isInstance(obj): obj is PushSubscriptionOptions;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCCertificate) */
interface RTCCertificate {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCCertificate/expires) */
    readonly expires: DOMTimeStamp;
}

declare var RTCCertificate: {
    prototype: RTCCertificate;
    new(): RTCCertificate;
    isInstance(obj): obj is RTCCertificate;
};

interface RTCDTMFSenderEventMap {
    "tonechange": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDTMFSender) */
interface RTCDTMFSender extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDTMFSender/tonechange_event) */
    ontonechange: ((this: RTCDTMFSender, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDTMFSender/toneBuffer) */
    readonly toneBuffer: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDTMFSender/insertDTMF) */
    insertDTMF(tones: string, duration?: number, interToneGap?: number): void;
    addEventListener<K extends keyof RTCDTMFSenderEventMap>(type: K, listener: (this: RTCDTMFSender, ev: RTCDTMFSenderEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof RTCDTMFSenderEventMap>(type: K, listener: (this: RTCDTMFSender, ev: RTCDTMFSenderEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var RTCDTMFSender: {
    prototype: RTCDTMFSender;
    new(): RTCDTMFSender;
    isInstance(obj): obj is RTCDTMFSender;
};

/**
 * Events sent to indicate that DTMF tones have started or finished playing. This interface is used by the tonechange event.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDTMFToneChangeEvent)
 */
interface RTCDTMFToneChangeEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDTMFToneChangeEvent/tone) */
    readonly tone: string;
}

declare var RTCDTMFToneChangeEvent: {
    prototype: RTCDTMFToneChangeEvent;
    new(type: string, eventInitDict?: RTCDTMFToneChangeEventInit): RTCDTMFToneChangeEvent;
    isInstance(obj): obj is RTCDTMFToneChangeEvent;
};

interface RTCDataChannelEventMap {
    "bufferedamountlow": Event;
    "close": Event;
    "error": ErrorEvent;
    "message": Event;
    "open": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel) */
interface RTCDataChannel extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/binaryType) */
    binaryType: RTCDataChannelType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/bufferedAmount) */
    readonly bufferedAmount: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/bufferedAmountLowThreshold) */
    bufferedAmountLowThreshold: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/id) */
    readonly id: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/label) */
    readonly label: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/maxPacketLifeTime) */
    readonly maxPacketLifeTime: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/maxRetransmits) */
    readonly maxRetransmits: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/negotiated) */
    readonly negotiated: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/bufferedamountlow_event) */
    onbufferedamountlow: ((this: RTCDataChannel, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/close_event) */
    onclose: ((this: RTCDataChannel, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/error_event) */
    onerror: OnErrorEventHandler;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/message_event) */
    onmessage: ((this: RTCDataChannel, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/open_event) */
    onopen: ((this: RTCDataChannel, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/ordered) */
    readonly ordered: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/protocol) */
    readonly protocol: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/readyState) */
    readonly readyState: RTCDataChannelState;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/reliable)
     */
    readonly reliable: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/close) */
    close(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannel/send) */
    send(data: string): void;
    send(data: Blob): void;
    send(data: ArrayBuffer): void;
    send(data: ArrayBufferView): void;
    addEventListener<K extends keyof RTCDataChannelEventMap>(type: K, listener: (this: RTCDataChannel, ev: RTCDataChannelEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof RTCDataChannelEventMap>(type: K, listener: (this: RTCDataChannel, ev: RTCDataChannelEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var RTCDataChannel: {
    prototype: RTCDataChannel;
    new(): RTCDataChannel;
    isInstance(obj): obj is RTCDataChannel;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannelEvent) */
interface RTCDataChannelEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDataChannelEvent/channel) */
    readonly channel: RTCDataChannel;
}

declare var RTCDataChannelEvent: {
    prototype: RTCDataChannelEvent;
    new(type: string, eventInitDict: RTCDataChannelEventInit): RTCDataChannelEvent;
    isInstance(obj): obj is RTCDataChannelEvent;
};

interface RTCDtlsTransportEventMap {
    "statechange": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDtlsTransport) */
interface RTCDtlsTransport extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDtlsTransport/statechange_event) */
    onstatechange: ((this: RTCDtlsTransport, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCDtlsTransport/state) */
    readonly state: RTCDtlsTransportState;
    addEventListener<K extends keyof RTCDtlsTransportEventMap>(type: K, listener: (this: RTCDtlsTransport, ev: RTCDtlsTransportEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof RTCDtlsTransportEventMap>(type: K, listener: (this: RTCDtlsTransport, ev: RTCDtlsTransportEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var RTCDtlsTransport: {
    prototype: RTCDtlsTransport;
    new(): RTCDtlsTransport;
    isInstance(obj): obj is RTCDtlsTransport;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCEncodedAudioFrame) */
interface RTCEncodedAudioFrame {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCEncodedAudioFrame/data) */
    data: ArrayBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCEncodedAudioFrame/timestamp) */
    readonly timestamp: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCEncodedAudioFrame/getMetadata) */
    getMetadata(): RTCEncodedAudioFrameMetadata;
}

declare var RTCEncodedAudioFrame: {
    prototype: RTCEncodedAudioFrame;
    new(): RTCEncodedAudioFrame;
    isInstance(obj): obj is RTCEncodedAudioFrame;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCEncodedVideoFrame) */
interface RTCEncodedVideoFrame {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCEncodedVideoFrame/data) */
    data: ArrayBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCEncodedVideoFrame/timestamp) */
    readonly timestamp: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCEncodedVideoFrame/type) */
    readonly type: RTCEncodedVideoFrameType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCEncodedVideoFrame/getMetadata) */
    getMetadata(): RTCEncodedVideoFrameMetadata;
}

declare var RTCEncodedVideoFrame: {
    prototype: RTCEncodedVideoFrame;
    new(): RTCEncodedVideoFrame;
    isInstance(obj): obj is RTCEncodedVideoFrame;
};

/**
 * The RTCIceCandidate interface—part of the WebRTC API—represents a candidate Internet Connectivity Establishment (ICE) configuration which may be used to establish an RTCPeerConnection.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCIceCandidate)
 */
interface RTCIceCandidate {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCIceCandidate/candidate) */
    candidate: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCIceCandidate/sdpMLineIndex) */
    sdpMLineIndex: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCIceCandidate/sdpMid) */
    sdpMid: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCIceCandidate/usernameFragment) */
    usernameFragment: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCIceCandidate/toJSON) */
    toJSON(): any;
}

declare var RTCIceCandidate: {
    prototype: RTCIceCandidate;
    new(candidateInitDict?: RTCIceCandidateInit): RTCIceCandidate;
    isInstance(obj): obj is RTCIceCandidate;
};

interface RTCIdentityProviderRegistrar {
    readonly hasIdp: boolean;
    generateAssertion(contents: string, origin: string, options?: RTCIdentityProviderOptions): Promise<RTCIdentityAssertionResult>;
    register(idp: RTCIdentityProvider): void;
    validateAssertion(assertion: string, origin: string): Promise<RTCIdentityValidationResult>;
}

interface RTCPeerConnectionEventMap {
    "addstream": Event;
    "addtrack": Event;
    "connectionstatechange": Event;
    "datachannel": Event;
    "icecandidate": Event;
    "iceconnectionstatechange": Event;
    "icegatheringstatechange": Event;
    "negotiationneeded": Event;
    "signalingstatechange": Event;
    "track": Event;
}

/**
 * A WebRTC connection between the local computer and a remote peer. It provides methods to connect to a remote peer, maintain and monitor the connection, and close the connection once it's no longer needed.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection)
 */
interface RTCPeerConnection extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/canTrickleIceCandidates) */
    readonly canTrickleIceCandidates: boolean | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/connectionState) */
    readonly connectionState: RTCPeerConnectionState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/currentLocalDescription) */
    readonly currentLocalDescription: RTCSessionDescription | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/currentRemoteDescription) */
    readonly currentRemoteDescription: RTCSessionDescription | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/iceConnectionState) */
    readonly iceConnectionState: RTCIceConnectionState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/iceGatheringState) */
    readonly iceGatheringState: RTCIceGatheringState;
    id: string;
    readonly idpLoginUrl: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/localDescription) */
    readonly localDescription: RTCSessionDescription | null;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/addstream_event)
     */
    onaddstream: ((this: RTCPeerConnection, ev: Event) => any) | null;
    onaddtrack: ((this: RTCPeerConnection, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/connectionstatechange_event) */
    onconnectionstatechange: ((this: RTCPeerConnection, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/datachannel_event) */
    ondatachannel: ((this: RTCPeerConnection, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/icecandidate_event) */
    onicecandidate: ((this: RTCPeerConnection, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/iceconnectionstatechange_event) */
    oniceconnectionstatechange: ((this: RTCPeerConnection, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/icegatheringstatechange_event) */
    onicegatheringstatechange: ((this: RTCPeerConnection, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/negotiationneeded_event) */
    onnegotiationneeded: ((this: RTCPeerConnection, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/signalingstatechange_event) */
    onsignalingstatechange: ((this: RTCPeerConnection, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/track_event) */
    ontrack: ((this: RTCPeerConnection, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/peerIdentity) */
    readonly peerIdentity: Promise<RTCIdentityAssertion>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/pendingLocalDescription) */
    readonly pendingLocalDescription: RTCSessionDescription | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/pendingRemoteDescription) */
    readonly pendingRemoteDescription: RTCSessionDescription | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/remoteDescription) */
    readonly remoteDescription: RTCSessionDescription | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/sctp) */
    readonly sctp: RTCSctpTransport | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/signalingState) */
    readonly signalingState: RTCSignalingState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/addIceCandidate) */
    addIceCandidate(candidate: RTCIceCandidate, successCallback: VoidFunction, failureCallback: RTCPeerConnectionErrorCallback): Promise<void>;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/addStream)
     */
    addStream(stream: MediaStream): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/addTrack) */
    addTrack(track: MediaStreamTrack, ...streams: MediaStream[]): RTCRtpSender;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/addTransceiver) */
    addTransceiver(trackOrKind: MediaStreamTrack | string, init?: RTCRtpTransceiverInit): RTCRtpTransceiver;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/close) */
    close(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/createAnswer) */
    createAnswer(successCallback: RTCSessionDescriptionCallback, failureCallback: RTCPeerConnectionErrorCallback): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/createDataChannel) */
    createDataChannel(label: string, dataChannelDict?: RTCDataChannelInit): RTCDataChannel;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/createOffer) */
    createOffer(successCallback: RTCSessionDescriptionCallback, failureCallback: RTCPeerConnectionErrorCallback, options?: RTCOfferOptions): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/getConfiguration) */
    getConfiguration(): RTCConfiguration;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/getIdentityAssertion) */
    getIdentityAssertion(): Promise<string>;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/getLocalStreams)
     */
    getLocalStreams(): MediaStream[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/getReceivers) */
    getReceivers(): RTCRtpReceiver[];
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/getRemoteStreams)
     */
    getRemoteStreams(): MediaStream[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/getSenders) */
    getSenders(): RTCRtpSender[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/getStats) */
    getStats(selector?: MediaStreamTrack | null): Promise<RTCStatsReport>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/getTransceivers) */
    getTransceivers(): RTCRtpTransceiver[];
    mozDisablePacketDump(level: number, type: mozPacketDumpType, sending: boolean): void;
    mozEnablePacketDump(level: number, type: mozPacketDumpType, sending: boolean): void;
    mozSetPacketCallback(callback: mozPacketCallback): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/removeTrack) */
    removeTrack(sender: RTCRtpSender): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/restartIce) */
    restartIce(): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/setConfiguration) */
    setConfiguration(configuration?: RTCConfiguration): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/setIdentityProvider) */
    setIdentityProvider(provider: string, options?: RTCIdentityProviderOptions): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/setLocalDescription) */
    setLocalDescription(description: RTCSessionDescriptionInit, successCallback: VoidFunction, failureCallback: RTCPeerConnectionErrorCallback): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/setRemoteDescription) */
    setRemoteDescription(description: RTCSessionDescriptionInit, successCallback: VoidFunction, failureCallback: RTCPeerConnectionErrorCallback): Promise<void>;
    addEventListener<K extends keyof RTCPeerConnectionEventMap>(type: K, listener: (this: RTCPeerConnection, ev: RTCPeerConnectionEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof RTCPeerConnectionEventMap>(type: K, listener: (this: RTCPeerConnection, ev: RTCPeerConnectionEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var RTCPeerConnection: {
    prototype: RTCPeerConnection;
    new(configuration?: RTCConfiguration, constraints?: any): RTCPeerConnection;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnection/generateCertificate_static) */
    generateCertificate(keygenAlgorithm: AlgorithmIdentifier): Promise<RTCCertificate>;
    isInstance(obj): obj is RTCPeerConnection;
};

/**
 * Events that occurs in relation to ICE candidates with the target, usually an RTCPeerConnection. Only one event is of this type: icecandidate.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnectionIceEvent)
 */
interface RTCPeerConnectionIceEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCPeerConnectionIceEvent/candidate) */
    readonly candidate: RTCIceCandidate | null;
}

declare var RTCPeerConnectionIceEvent: {
    prototype: RTCPeerConnectionIceEvent;
    new(type: string, eventInitDict?: RTCPeerConnectionIceEventInit): RTCPeerConnectionIceEvent;
    isInstance(obj): obj is RTCPeerConnectionIceEvent;
};

interface RTCPeerConnectionStatic {
    registerPeerConnectionLifecycleCallback(cb: PeerConnectionLifecycleCallback): void;
}

declare var RTCPeerConnectionStatic: {
    prototype: RTCPeerConnectionStatic;
    new(): RTCPeerConnectionStatic;
    isInstance(obj): obj is RTCPeerConnectionStatic;
};

/**
 * This WebRTC API interface manages the reception and decoding of data for a MediaStreamTrack on an RTCPeerConnection.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpReceiver)
 */
interface RTCRtpReceiver {
    jitterBufferTarget: DOMHighResTimeStamp | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpReceiver/track) */
    readonly track: MediaStreamTrack;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpReceiver/transform) */
    transform: RTCRtpTransform | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpReceiver/transport) */
    readonly transport: RTCDtlsTransport | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpReceiver/getContributingSources) */
    getContributingSources(): RTCRtpContributingSource[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpReceiver/getStats) */
    getStats(): Promise<RTCStatsReport>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpReceiver/getSynchronizationSources) */
    getSynchronizationSources(): RTCRtpSynchronizationSource[];
    mozInsertAudioLevelForContributingSource(source: number, timestamp: DOMHighResTimeStamp, rtpTimestamp: number, hasLevel: boolean, level: number): void;
}

declare var RTCRtpReceiver: {
    prototype: RTCRtpReceiver;
    new(): RTCRtpReceiver;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpReceiver/getCapabilities_static) */
    getCapabilities(kind: string): RTCRtpCapabilities | null;
    isInstance(obj): obj is RTCRtpReceiver;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpScriptTransform) */
interface RTCRtpScriptTransform {
}

declare var RTCRtpScriptTransform: {
    prototype: RTCRtpScriptTransform;
    new(worker: Worker, options?: any, transfer?: any[]): RTCRtpScriptTransform;
    isInstance(obj): obj is RTCRtpScriptTransform;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpScriptTransformer) */
interface RTCRtpScriptTransformer {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpScriptTransformer/options) */
    readonly options: any;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpScriptTransformer/readable) */
    readonly readable: ReadableStream;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpScriptTransformer/writable) */
    readonly writable: WritableStream;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpScriptTransformer/generateKeyFrame) */
    generateKeyFrame(rid?: string): Promise<number>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpScriptTransformer/sendKeyFrameRequest) */
    sendKeyFrameRequest(): Promise<void>;
}

declare var RTCRtpScriptTransformer: {
    prototype: RTCRtpScriptTransformer;
    new(): RTCRtpScriptTransformer;
    isInstance(obj): obj is RTCRtpScriptTransformer;
};

/**
 * Provides the ability to control and obtain details about how a particular MediaStreamTrack is encoded and sent to a remote peer.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpSender)
 */
interface RTCRtpSender {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpSender/dtmf) */
    readonly dtmf: RTCDTMFSender | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpSender/track) */
    readonly track: MediaStreamTrack | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpSender/transform) */
    transform: RTCRtpTransform | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpSender/transport) */
    readonly transport: RTCDtlsTransport | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpSender/getParameters) */
    getParameters(): RTCRtpSendParameters;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpSender/getStats) */
    getStats(): Promise<RTCStatsReport>;
    getStreams(): MediaStream[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpSender/replaceTrack) */
    replaceTrack(withTrack: MediaStreamTrack | null): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpSender/setParameters) */
    setParameters(parameters: RTCRtpSendParameters): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpSender/setStreams) */
    setStreams(...streams: MediaStream[]): void;
    setStreamsImpl(...streams: MediaStream[]): void;
    setTrack(track: MediaStreamTrack | null): void;
}

declare var RTCRtpSender: {
    prototype: RTCRtpSender;
    new(): RTCRtpSender;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpSender/getCapabilities_static) */
    getCapabilities(kind: string): RTCRtpCapabilities | null;
    isInstance(obj): obj is RTCRtpSender;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpTransceiver) */
interface RTCRtpTransceiver {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpTransceiver/currentDirection) */
    readonly currentDirection: RTCRtpTransceiverDirection | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpTransceiver/direction) */
    direction: RTCRtpTransceiverDirection;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpTransceiver/mid) */
    readonly mid: string | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpTransceiver/receiver) */
    readonly receiver: RTCRtpReceiver;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpTransceiver/sender) */
    readonly sender: RTCRtpSender;
    /**
     * @deprecated
     *
     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpTransceiver/stopped)
     */
    readonly stopped: boolean;
    getKind(): string;
    hasBeenUsedToSend(): boolean;
    setDirectionInternal(direction: RTCRtpTransceiverDirection): void;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCRtpTransceiver/stop) */
    stop(): void;
}

declare var RTCRtpTransceiver: {
    prototype: RTCRtpTransceiver;
    new(): RTCRtpTransceiver;
    isInstance(obj): obj is RTCRtpTransceiver;
};

interface RTCSctpTransportEventMap {
    "statechange": Event;
}

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCSctpTransport) */
interface RTCSctpTransport extends EventTarget {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCSctpTransport/maxChannels) */
    readonly maxChannels: number | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCSctpTransport/maxMessageSize) */
    readonly maxMessageSize: number;
    onstatechange: ((this: RTCSctpTransport, ev: Event) => any) | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCSctpTransport/state) */
    readonly state: RTCSctpTransportState;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCSctpTransport/transport) */
    readonly transport: RTCDtlsTransport;
    addEventListener<K extends keyof RTCSctpTransportEventMap>(type: K, listener: (this: RTCSctpTransport, ev: RTCSctpTransportEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof RTCSctpTransportEventMap>(type: K, listener: (this: RTCSctpTransport, ev: RTCSctpTransportEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;
}

declare var RTCSctpTransport: {
    prototype: RTCSctpTransport;
    new(): RTCSctpTransport;
    isInstance(obj): obj is RTCSctpTransport;
};

/**
 * One end of a connection—or potential connection—and how it's configured. Each RTCSessionDescription consists of a description type indicating which part of the offer/answer negotiation process it describes and of the SDP descriptor of the session.
 *
 * [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCSessionDescription)
 */
interface RTCSessionDescription {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCSessionDescription/sdp) */
    sdp: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCSessionDescription/type) */
    type: RTCSdpType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCSessionDescription/toJSON) */
    toJSON(): any;
}

declare var RTCSessionDescription: {
    prototype: RTCSessionDescription;
    new(descriptionInitDict?: RTCSessionDescriptionInit): RTCSessionDescription;
    isInstance(obj): obj is RTCSessionDescription;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCStatsReport) */
interface RTCStatsReport {
    forEach(callbackfn: (value: any, key: string, parent: RTCStatsReport) => void, thisArg?: any): void;
}

declare var RTCStatsReport: {
    prototype: RTCStatsReport;
    new(): RTCStatsReport;
    isInstance(obj): obj is RTCStatsReport;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCTrackEvent) */
interface RTCTrackEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCTrackEvent/receiver) */
    readonly receiver: RTCRtpReceiver;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCTrackEvent/streams) */
    readonly streams: MediaStream[];
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCTrackEvent/track) */
    readonly track: MediaStreamTrack;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCTrackEvent/transceiver) */
    readonly transceiver: RTCRtpTransceiver;
}

declare var RTCTrackEvent: {
    prototype: RTCTrackEvent;
    new(type: string, eventInitDict: RTCTrackEventInit): RTCTrackEvent;
    isInstance(obj): obj is RTCTrackEvent;
};

/** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCTransformEvent) */
interface RTCTransformEvent extends Event {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/RTCTransformEvent/transformer) */
    readonly transformer: RTCRtpScriptTransformer;
}

