/* THIS FILE IS AUTOGENERATED FROM Blob.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_BlobBinding_h
#define mozilla_dom_BlobBinding_h

#include "js/RootingAPI.h"
#include "jsfriendapi.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Blob;
struct BlobAtoms;
struct BlobPropertyBagAtoms;
struct NativePropertyHooks;
class OwningArrayBufferOrArrayBufferViewOrBlobOrUSVString;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class EndingTypes : uint32_t {
  Transparent,
  Native,
  EndGuard_
};

namespace EndingTypesValues {
extern const EnumEntry strings[3];
} // namespace EndingTypesValues

bool
ToJSValue(JSContext* aCx, EndingTypes aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningArrayBufferOrArrayBufferViewOrBlobOrUSVString& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningArrayBufferOrArrayBufferViewOrBlobOrUSVString& aUnion);


class ArrayBufferOrArrayBufferViewOrBlobOrUSVString
{
  friend class ArrayBufferOrArrayBufferViewOrBlobOrUSVStringArgument;
  enum Type
  {
    eUninitialized,
    eArrayBuffer,
    eArrayBufferView,
    eBlob,
    eUSVString
  };

  union Value
  {
    UnionMember<RootedTypedArray<ArrayBuffer> > mArrayBuffer;
    UnionMember<RootedTypedArray<ArrayBufferView> > mArrayBufferView;
    UnionMember<NonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<binding_detail::FakeString > mUSVString;

  };

  Type mType;
  Value mValue;

  ArrayBufferOrArrayBufferViewOrBlobOrUSVString(const ArrayBufferOrArrayBufferViewOrBlobOrUSVString&) = delete;
  void operator=(const ArrayBufferOrArrayBufferViewOrBlobOrUSVString) = delete;
public:
  explicit inline ArrayBufferOrArrayBufferViewOrBlobOrUSVString()
    : mType(eUninitialized)
  {
  }

  inline ~ArrayBufferOrArrayBufferViewOrBlobOrUSVString()
  {
    Uninit();
  }

  inline RootedTypedArray<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline RootedTypedArray<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedTypedArray<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline RootedTypedArray<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline RootedTypedArray<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedTypedArray<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline NonNull<mozilla::dom::Blob>&
  RawSetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline NonNull<mozilla::dom::Blob>&
  SetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    Uninit();
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline NonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline mozilla::dom::Blob&
  GetAsBlob() const
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline binding_detail::FakeString&
  RawSetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  inline binding_detail::FakeString&
  SetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    Uninit();
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline binding_detail::FakeString&
  GetAsUSVString()
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline const nsAString&
  GetAsUSVString() const
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
      case eBlob: {
        DestroyBlob();
        break;
      }
      case eUSVString: {
        DestroyUSVString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyArrayBuffer()
  {
    MOZ_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyArrayBufferView()
  {
    MOZ_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyBlob()
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    mValue.mBlob.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyUSVString()
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    mValue.mUSVString.Destroy();
    mType = eUninitialized;
  }
};


class OwningArrayBufferOrArrayBufferViewOrBlobOrUSVString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningArrayBufferOrArrayBufferViewOrBlobOrUSVString& aUnion);
  enum Type
  {
    eUninitialized,
    eArrayBuffer,
    eArrayBufferView,
    eBlob,
    eUSVString
  };

  union Value
  {
    UnionMember<ArrayBuffer > mArrayBuffer;
    UnionMember<ArrayBufferView > mArrayBufferView;
    UnionMember<OwningNonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<nsString > mUSVString;

  };

  Type mType;
  Value mValue;

  OwningArrayBufferOrArrayBufferViewOrBlobOrUSVString(const OwningArrayBufferOrArrayBufferViewOrBlobOrUSVString&) = delete;
  void operator=(const OwningArrayBufferOrArrayBufferViewOrBlobOrUSVString) = delete;
public:
  explicit inline OwningArrayBufferOrArrayBufferViewOrBlobOrUSVString()
    : mType(eUninitialized)
  {
  }

  inline ~OwningArrayBufferOrArrayBufferViewOrBlobOrUSVString()
  {
    Uninit();
  }

  ArrayBuffer&
  RawSetAsArrayBuffer();

  ArrayBuffer&
  SetAsArrayBuffer();

  bool
  TrySetToArrayBuffer(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  ArrayBufferView&
  RawSetAsArrayBufferView();

  ArrayBufferView&
  SetAsArrayBufferView();

  bool
  TrySetToArrayBufferView(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  OwningNonNull<mozilla::dom::Blob>&
  RawSetAsBlob();

  OwningNonNull<mozilla::dom::Blob>&
  SetAsBlob();

  bool
  TrySetToBlob(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline OwningNonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline OwningNonNull<mozilla::dom::Blob> const &
  GetAsBlob() const
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  nsString&
  RawSetAsUSVString();

  nsString&
  SetAsUSVString();

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  SetStringData(const nsString::char_type* aData, nsString::size_type aLength)
  {
    RawSetAsUSVString().Assign(aData, aLength);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline nsString&
  GetAsUSVString()
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline nsString const &
  GetAsUSVString() const
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

private:
  void
  DestroyArrayBuffer();

  void
  DestroyArrayBufferView();

  void
  DestroyBlob();

  void
  DestroyUSVString();
};


struct BlobPropertyBag : public DictionaryBase
{
  EndingTypes mEndings;
  nsString mType;

  BlobPropertyBag();

  explicit inline BlobPropertyBag(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline BlobPropertyBag(const BlobPropertyBag& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const BlobPropertyBag& aOther);

private:
  static bool
  InitIds(JSContext* cx, BlobPropertyBagAtoms* atomsCache);
};

namespace binding_detail {
struct FastBlobPropertyBag : public BlobPropertyBag
{
  inline FastBlobPropertyBag()
    : BlobPropertyBag(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace BlobBinding {

  typedef mozilla::dom::Blob NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::Blob* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JSObject*
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace BlobBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_BlobBinding_h
