/* THIS FILE IS AUTOGENERATED FROM BrowserElementProxy.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_BrowserElementProxyBinding_h
#define mozilla_dom_BrowserElementProxyBinding_h

#include "BrowserElementBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/DOMEventTargetHelper.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class BrowserElementAudioChannel;
struct BrowserElementDownloadOptions;
struct BrowserElementExecuteScriptOptions;
class BrowserElementNextPaintEventCallback;
class BrowserElementProxy;
struct BrowserElementProxyAtoms;
class DOMRequest;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

namespace BrowserElementProxyBinding {

  typedef mozilla::dom::BrowserElementProxy NativeType;

  already_AddRefed<BrowserElementProxy>
  ConstructNavigatorObject(JSContext* cx, JS::Handle<JSObject*> obj, ErrorResult& aRv);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::BrowserElementProxy* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedAllowedAudioChannelsValue(mozilla::dom::BrowserElementProxy* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace BrowserElementProxyBinding



class BrowserElementProxyJSImpl : public CallbackInterface
{
public:
  explicit inline BrowserElementProxyJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  explicit inline BrowserElementProxyJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  explicit inline BrowserElementProxyJSImpl(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aAsyncStack, aIncumbentGlobal)
  {
  }

  void SetVisible(bool visible, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> GetVisible(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetActive(bool active, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool GetActive(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddNextPaintListener(BrowserElementNextPaintEventCallback& listener, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveNextPaintListener(BrowserElementNextPaintEventCallback& listener, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SendMouseEvent(const nsAString& type, uint32_t x, uint32_t y, uint32_t button, uint32_t clickCount, uint32_t modifiers, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SendTouchEvent(const nsAString& type, const Sequence<uint32_t>& identifiers, const Sequence<int32_t>& x, const Sequence<int32_t>& y, const Sequence<uint32_t>& rx, const Sequence<uint32_t>& ry, const Sequence<float>& rotationAngles, const Sequence<float>& forces, uint32_t count, uint32_t modifiers, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GoBack(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GoForward(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Reload(bool hardReload, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Stop(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> Download(const nsAString& url, const BrowserElementDownloadOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> PurgeHistory(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> GetScreenshot(uint32_t width, uint32_t height, const nsAString& mimeType, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Zoom(float zoom, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> GetCanGoBack(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> GetCanGoForward(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> GetContentDimensions(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> SetInputMethodActive(bool isActive, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetNFCFocus(bool isFocus, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void FindAll(const nsAString& searchString, BrowserFindCaseSensitivity caseSensitivity, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void FindNext(BrowserFindDirection direction, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void ClearMatch(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> ExecuteScript(const nsAString& script, const BrowserElementExecuteScriptOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> GetWebManifest(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Mute(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Unmute(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> GetMuted(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetVolume(float volume, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> GetVolume(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void __Init(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const BrowserElementProxyJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  void GetAllowedAudioChannels(nsTArray<RefPtr<BrowserElementAudioChannel>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, BrowserElementProxyAtoms* atomsCache);
};


class BrowserElementProxy final : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(BrowserElementProxy, mozilla::DOMEventTargetHelper)

private:
  RefPtr<BrowserElementProxyJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  BrowserElementProxy(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~BrowserElementProxy();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  static already_AddRefed<BrowserElementProxy> Constructor(const GlobalObject& global, JSContext* cx, ErrorResult& aRv);

  void SetVisible(bool visible, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> GetVisible(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetActive(bool active, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool GetActive(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddNextPaintListener(BrowserElementNextPaintEventCallback& listener, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveNextPaintListener(BrowserElementNextPaintEventCallback& listener, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SendMouseEvent(const nsAString& type, uint32_t x, uint32_t y, uint32_t button, uint32_t clickCount, uint32_t modifiers, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SendTouchEvent(const nsAString& type, const Sequence<uint32_t>& identifiers, const Sequence<int32_t>& x, const Sequence<int32_t>& y, const Sequence<uint32_t>& rx, const Sequence<uint32_t>& ry, const Sequence<float>& rotationAngles, const Sequence<float>& forces, uint32_t count, uint32_t modifiers, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GoBack(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GoForward(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Reload(bool hardReload, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Stop(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> Download(const nsAString& url, const BrowserElementDownloadOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> PurgeHistory(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> GetScreenshot(uint32_t width, uint32_t height, const nsAString& mimeType, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Zoom(float zoom, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> GetCanGoBack(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> GetCanGoForward(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> GetContentDimensions(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> SetInputMethodActive(bool isActive, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetNFCFocus(bool isFocus, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void FindAll(const nsAString& searchString, BrowserFindCaseSensitivity caseSensitivity, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void FindNext(BrowserFindDirection direction, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void ClearMatch(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> ExecuteScript(const nsAString& script, const BrowserElementExecuteScriptOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> GetWebManifest(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetAllowedAudioChannels(nsTArray<RefPtr<BrowserElementAudioChannel>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void Mute(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Unmute(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> GetMuted(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetVolume(float volume, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> GetVolume(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_BrowserElementProxyBinding_h
