/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef DetailsFrame_h
#define DetailsFrame_h

#include "nsBlockFrame.h"
#include "nsIAnonymousContentCreator.h"

class nsContainerFrame;
class nsStyleContext;

namespace mozilla {

// DetailsFrame is generated by HTMLDetailsElement. See
// nsCSSFrameConstructor::ConstructDetailsFrame for the structure of a
// DetailsFrame.
//
class DetailsFrame final : public nsBlockFrame
                         , public nsIAnonymousContentCreator
{
public:
  NS_DECL_FRAMEARENA_HELPERS(DetailsFrame)
  NS_DECL_QUERYFRAME

  explicit DetailsFrame(nsStyleContext* aContext);

  virtual ~DetailsFrame();

#ifdef DEBUG_FRAME_DUMP
  nsresult GetFrameName(nsAString& aResult) const override
  {
    return MakeFrameName(NS_LITERAL_STRING("Details"), aResult);
  }
#endif

#ifdef DEBUG
  // Check the frame of the main summary element is the first child in the frame
  // list. Returns true if we found the main summary frame; false otherwise.
  bool CheckValidMainSummary(const nsFrameList& aFrameList) const;
#endif

  void SetInitialChildList(ChildListID aListID,
                           nsFrameList& aChildList) override;

  void DestroyFrom(nsIFrame* aDestructRoot) override;

  // nsIAnonymousContentCreator
  nsresult CreateAnonymousContent(nsTArray<ContentInfo>& aElements) override;

  void AppendAnonymousContentTo(nsTArray<nsIContent*>& aElements,
                                uint32_t aFilter) override;

private:
  nsCOMPtr<nsIContent> mDefaultSummary;
};

} // namespace mozilla

#endif // DetailsFrame_h
