/* -*- tab-width: 2; indent-tabs-mode: nil; js-indent-level: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */


/**
 *  File Name:          dowhile-002
 *  ECMA Section:
 *  Description:        do...while statements
 *
 *  Verify that code after a labeled break is not executed.  Verify that
 *  a labeled break breaks you out of the whole labeled block, and not
 *  just the current iteration statement.
 *
 *  Author:             christine@netscape.com
 *  Date:               11 August 1998
 */
var SECTION = "dowhile-002";
var TITLE   = "do...while with a labeled continue statement";

writeHeaderToLog( SECTION + " "+ TITLE);

LabeledContinue( 0, 1 );
LabeledContinue( 1, 1 );
LabeledContinue( -1, 1 );
LabeledContinue( 5, 5 );

test();

// The labeled statement contains statements after the labeled break.
// Verify that the statements after the break are not executed.

function LabeledContinue( limit, expect ) {
  i = 0;
  result1 = "pass";
  result2 = "pass";

woohoo: {
    do {
      i++;
      if ( ! (i < limit) ) {
	break woohoo;
	result1 = "fail: evaluated statement after a labeled break";
      }
    } while ( true );

    result2 = "failed:  broke out of loop, but not out of labeled block";
  }

  new TestCase(
    "do while ( " + i +" < " + limit +" )",
    expect,
    i );

  new TestCase(
    "breaking out of a do... while loop",
    "pass",
    result1 );


  new TestCase(
    "breaking out of a labeled do...while loop",
    "pass",
    result2 );
}
