/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. RUN TESTS IN FIXTURES/ TO UPDATE.
 */

const {
  parsePacketsWithFronts,
} = require("chrome://mochitests/content/browser/devtools/client/webconsole/test/browser/stub-generator-helpers");
const { prepareMessage } = require("devtools/client/webconsole/utils/messages");
const {
  ConsoleMessage,
  NetworkEventMessage,
} = require("devtools/client/webconsole/types");

const rawPackets = new Map();
rawPackets.set(`GET request`, {
  "resourceType": "network-event",
  "_type": "NetworkEvent",
  "timeStamp": 1572867483805,
  "node": null,
  "actor": "server0.conn0.netEvent4",
  "discardRequestBody": true,
  "discardResponseBody": true,
  "startedDateTime": "2019-11-04T11:06:34.542Z",
  "request": {
    "url": "http://example.com/inexistent.html",
    "method": "GET",
    "headersSize": 385
  },
  "isXHR": false,
  "cause": {
    "type": "img",
    "loadingDocumentUri": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "lastFrame": {
      "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 3,
      "columnNumber": 1,
      "functionName": "triggerPacket",
      "asyncCause": null
    },
    "stacktraceAvailable": true
  },
  "response": {
    "httpVersion": "HTTP/1.1",
    "status": "404",
    "statusText": "Not Found",
    "headersSize": 160,
    "remoteAddress": "127.0.0.1",
    "remotePort": 8888,
    "content": {
      "mimeType": "text/html; charset=utf-8"
    },
    "waitingTime": 1,
    "bodySize": 418,
    "transferredSize": 578
  },
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "no-referrer-when-downgrade",
  "channelId": 265845590720515,
  "updates": [
    "eventTimings",
    "requestCookies",
    "requestHeaders",
    "responseContent",
    "responseCookies",
    "responseHeaders",
    "responseStart",
    "securityInfo"
  ]
});

rawPackets.set(`GET request update`, {
  "resourceType": "network-event",
  "_type": "NetworkEvent",
  "timeStamp": 1572867483805,
  "node": null,
  "actor": "server0.conn0.netEvent5",
  "discardRequestBody": true,
  "discardResponseBody": false,
  "startedDateTime": "2020-07-07T14:41:14.572Z",
  "request": {
    "url": "http://example.com/inexistent.html",
    "method": "GET",
    "headersSize": 385
  },
  "isXHR": false,
  "cause": {
    "type": "img",
    "loadingDocumentUri": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "lastFrame": {
      "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 3,
      "columnNumber": 1,
      "functionName": "triggerPacket",
      "asyncCause": null
    },
    "stacktraceAvailable": true
  },
  "response": {
    "httpVersion": "HTTP/1.1",
    "status": "404",
    "statusText": "Not Found",
    "headersSize": 160,
    "remoteAddress": "127.0.0.1",
    "remotePort": 8888,
    "content": {
      "mimeType": "text/html; charset=utf-8"
    },
    "waitingTime": 1,
    "bodySize": 418,
    "transferredSize": 578
  },
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "no-referrer-when-downgrade",
  "channelId": 202499118071811,
  "updates": [
    "eventTimings",
    "requestCookies",
    "requestHeaders",
    "responseContent",
    "responseCookies",
    "responseHeaders",
    "responseStart",
    "securityInfo"
  ],
  "updateType": "responseContent",
  "totalTime": 3,
  "securityState": "insecure"
});

rawPackets.set(`XHR GET request`, {
  "resourceType": "network-event",
  "_type": "NetworkEvent",
  "timeStamp": 1572867483805,
  "node": null,
  "actor": "server0.conn0.netEvent21",
  "discardRequestBody": true,
  "discardResponseBody": true,
  "startedDateTime": "2020-07-07T14:41:14.612Z",
  "request": {
    "url": "http://example.com/inexistent.html",
    "method": "GET",
    "headersSize": 385
  },
  "isXHR": true,
  "cause": {
    "type": "xhr",
    "loadingDocumentUri": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "lastFrame": {
      "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 4,
      "columnNumber": 5,
      "functionName": "triggerPacket",
      "asyncCause": null
    },
    "stacktraceAvailable": true
  },
  "response": {
    "httpVersion": "HTTP/1.1",
    "status": "404",
    "statusText": "Not Found",
    "headersSize": 160,
    "remoteAddress": "127.0.0.1",
    "remotePort": 8888,
    "content": {
      "mimeType": "text/html; charset=utf-8"
    },
    "waitingTime": 2,
    "bodySize": 418,
    "transferredSize": 578
  },
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "no-referrer-when-downgrade",
  "channelId": 202499118071812,
  "updates": [
    "eventTimings",
    "requestCookies",
    "requestHeaders",
    "responseContent",
    "responseCookies",
    "responseHeaders",
    "responseStart",
    "securityInfo"
  ]
});

rawPackets.set(`XHR GET request update`, {
  "resourceType": "network-event",
  "_type": "NetworkEvent",
  "timeStamp": 1572867483805,
  "node": null,
  "actor": "server0.conn0.netEvent20",
  "discardRequestBody": true,
  "discardResponseBody": false,
  "request": {
    "url": "http://example.com/inexistent.html",
    "method": "GET",
    "headersSize": 385
  },
  "isXHR": true,
  "cause": {
    "type": "xhr",
    "loadingDocumentUri": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "lastFrame": {
      "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 4,
      "columnNumber": 5,
      "functionName": "triggerPacket",
      "asyncCause": null
    },
    "stacktraceAvailable": true
  },
  "response": {
    "httpVersion": "HTTP/1.1",
    "status": "404",
    "statusText": "Not Found",
    "headersSize": 160,
    "remoteAddress": "127.0.0.1",
    "remotePort": 8888,
    "content": {
      "mimeType": "text/html; charset=utf-8"
    },
    "waitingTime": 2,
    "bodySize": 418,
    "transferredSize": 578
  },
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "no-referrer-when-downgrade",
  "updates": [
    "eventTimings",
    "requestCookies",
    "requestHeaders",
    "responseContent",
    "responseCookies",
    "responseHeaders",
    "responseStart",
    "securityInfo"
  ],
  "updateType": "responseContent",
  "totalTime": 1,
  "securityState": "insecure"
});

rawPackets.set(`XHR POST request`, {
  "resourceType": "network-event",
  "_type": "NetworkEvent",
  "timeStamp": 1572867483805,
  "node": null,
  "actor": "server0.conn0.netEvent36",
  "discardRequestBody": true,
  "discardResponseBody": true,
  "startedDateTime": "2019-11-04T11:06:35.007Z",
  "request": {
    "url": "http://example.com/inexistent.html",
    "method": "POST",
    "headersSize": 385
  },
  "isXHR": true,
  "cause": {
    "type": "xhr",
    "loadingDocumentUri": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "lastFrame": {
      "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 4,
      "columnNumber": 5,
      "functionName": "triggerPacket",
      "asyncCause": null
    },
    "stacktraceAvailable": true
  },
  "response": {
    "httpVersion": "HTTP/1.1",
    "status": "404",
    "statusText": "Not Found",
    "headersSize": 160,
    "remoteAddress": "127.0.0.1",
    "remotePort": 8888,
    "content": {
      "mimeType": "text/html; charset=utf-8"
    },
    "waitingTime": 2,
    "bodySize": 418,
    "transferredSize": 578
  },
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "no-referrer-when-downgrade",
  "channelId": 265845590720517,
  "updates": [
    "eventTimings",
    "requestCookies",
    "requestHeaders",
    "responseContent",
    "responseCookies",
    "responseHeaders",
    "responseStart",
    "securityInfo"
  ]
});

rawPackets.set(`XHR POST request update`, {
  "resourceType": "network-event",
  "_type": "NetworkEvent",
  "timeStamp": 1572867483805,
  "node": null,
  "actor": "server0.conn0.netEvent36",
  "discardRequestBody": true,
  "discardResponseBody": false,
  "request": {
    "url": "http://example.com/inexistent.html",
    "method": "POST",
    "headersSize": 385
  },
  "isXHR": true,
  "cause": {
    "type": "xhr",
    "loadingDocumentUri": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "lastFrame": {
      "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 4,
      "columnNumber": 5,
      "functionName": "triggerPacket",
      "asyncCause": null
    },
    "stacktraceAvailable": true
  },
  "response": {
    "httpVersion": "HTTP/1.1",
    "status": "404",
    "statusText": "Not Found",
    "headersSize": 160,
    "remoteAddress": "127.0.0.1",
    "remotePort": 8888,
    "content": {
      "mimeType": "text/html; charset=utf-8"
    },
    "waitingTime": 2,
    "bodySize": 418,
    "transferredSize": 578
  },
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "no-referrer-when-downgrade",
  "updates": [
    "eventTimings",
    "requestCookies",
    "requestHeaders",
    "responseContent",
    "responseCookies",
    "responseHeaders",
    "responseStart",
    "securityInfo"
  ],
  "updateType": "responseContent",
  "totalTime": 2,
  "securityState": "insecure"
});


const stubPackets = parsePacketsWithFronts(rawPackets);

const stubPreparedMessages = new Map();
for (const [key, packet] of Array.from(stubPackets.entries())) {
  const transformedPacket = prepareMessage(packet, {
    getNextId: () => "1",
  });
  const message = NetworkEventMessage(transformedPacket);
  stubPreparedMessages.set(key, message);
}

module.exports = {
  rawPackets,
  stubPreparedMessages,
  stubPackets,
};
