# Code of Conduct

Contact: a moderator ([see below](#moderators)), or a member of the WPT
community that you feel you can trust.

## Our Pledge

We as members, contributors, and leaders pledge to make participation in our
community a harassment-free experience for everyone, regardless of age, body
size, visible or invisible disability, ethnicity, sex characteristics, gender
identity and expression, level of experience, education, socio-economic status,
nationality, personal appearance, race, religion, sexual identity and
orientation, or any other dimension of diversity.

We pledge to act and interact in ways that contribute to an open, welcoming,
diverse, inclusive, and healthy community.

## Our Standards

Examples of behavior that contributes to a positive environment for our
community include:

* Demonstrating empathy and kindness toward other people
* Being respectful of differing opinions, viewpoints, and experiences
* Giving and gracefully accepting constructive feedback
* Accepting responsibility and apologizing to those affected by our mistakes,
  and learning from the experience
* Focusing on what is best not just for us as individuals, but for the
  overall community

Examples of unacceptable behavior include:

* The use of sexualized language or imagery, and sexual attention or
  advances of any kind
* Trolling, insulting or derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or email
  address, without their explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional setting

## Enforcement Responsibilities

Moderators are responsible for clarifying and enforcing our standards of
acceptable behavior and will take appropriate and fair corrective action in
response to any behavior that they deem inappropriate, threatening, offensive,
or harmful.

Moderators have the right and responsibility to remove, edit, or reject
comments, commits, code, wiki edits, issues, and other contributions that are
not aligned to this Code of Conduct, and will communicate reasons for moderation
decisions when appropriate.

Moderators are held to a higher standard than other community members. If a
moderator creates an inappropriate situation, they should expect less leeway
than others.

## Scope

This Code of Conduct applies within all community spaces, and also applies when
an individual is officially representing the community in public spaces.
Examples of representing our community include official IRC channels (#testing
on irc.w3.org); GitHub repositories under the web-platform-tests organization;
and the public-test-infra@w3.org mailing list.

There may arise situations where both the WPT code of conduct and that of
another organization (such as the WHATWG or W3C) may apply.
For example, a WPT-focused meeting at
[TPAC](https://www.w3.org/2002/09/TPOverview.html) would involve both the WPT
code of conduct and the [W3C code of ethics and professional
conduct](https://www.w3.org/Consortium/cepc/).
In such situations we operate under all code of conducts involved.
If you are placed in a situation where you feel this is inappropriate (e.g. if
you believe the code of conducts involved contradict one another), please
contact a [moderator](#moderators).

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported to the [moderators](#moderators).
All complaints will be reviewed and investigated promptly and fairly.

All moderators are obligated to respect the privacy and security of the
reporter of any incident.

Moderators will recuse themselves if they are directly involved in a report of
a code of conduct violation.

## Enforcement Guidelines

Moderators will follow these Community Impact Guidelines in determining
the consequences for any action they deem in violation of this Code of Conduct.
These are not a consecutive set of steps; a single incident may be sufficient
enough to proceed straight to a temporary ban, for example.

### 1. Warning

**Community Impact**: A violation through a single incident or series
of actions.

**Consequence**: A warning with consequences for continued behavior, providing
clarity around the nature of the violation and an explanation of why the
behavior was inappropriate. A public apology may be requested.

### 2. Temporary Ban

**Community Impact**: A serious violation of community standards, including
sustained inappropriate behavior.

**Consequence**: A temporary ban from any sort of interaction or public
communication with the community for a specified period of time. No public or
private interaction with the people involved, including unsolicited interaction
with those enforcing the Code of Conduct, is allowed during this period.
Violating these terms may lead to a permanent ban.

### 3. Permanent Ban

**Community Impact**: Demonstrating a pattern of violation of community
standards, including sustained inappropriate behavior,  harassment of an
individual, or aggression toward or disparagement of classes of individuals.

**Consequence**: A permanent ban from any sort of public interaction within
the community.

## Moderators

This section lists the current moderators and how to reach them.

* Nina Satragno - [nso@google.com](mailto:nso@google.com). Languages: English, Spanish.
* Boaz Sender - [boaz@bocoup.com](mailto:boaz@bocoup.com). Languages: English, Hebrew.
* Jory Burson - [jory@bocoup.education](mailto:jory@bocoup.education). Languages: English (fluent), Spanish (conversational).

## Attribution

This Code of Conduct is adapted from the Contributor Covenant,
version 2.0, available at
https://www.contributor-covenant.org/version/2/0/code_of_conduct.html.
