//@line 37 "/builds/tinderbox/Fx-Trunk/Linux_2.4.21-27.0.4.ELsmp_Depend/mozilla/toolkit/mozapps/extensions/content/extensions.js"

///////////////////////////////////////////////////////////////////////////////
// Globals

const kObserverServiceProgID = "@mozilla.org/observer-service;1";
const nsIUpdateItem = Components.interfaces.nsIUpdateItem;

var gExtensionManager = null;
var gExtensionsView   = null;
var gWindowState      = "";
var gGetMoreURL       = "";
var gCurrentTheme     = "classic/1.0";
var gDefaultTheme     = "classic/1.0";
var gDownloadManager  = null;
var gObserverIndex    = -1;
var gItemType         = -1;
var gApp              = null;

const PREF_EXTENSIONS_GETMORETHEMESURL      = "extensions.getMoreThemesURL";
const PREF_EXTENSIONS_GETMOREEXTENSIONSURL  = "extensions.getMoreExtensionsURL";
const PREF_EXTENSIONS_DSS_ENABLED           = "extensions.dss.enabled";
const PREF_EXTENSIONS_DSS_SWITCHPENDING     = "extensions.dss.switchPending";
const PREF_EM_LAST_SELECTED_SKIN            = "extensions.lastSelectedSkin";
const PREF_GENERAL_SKINS_SELECTEDSKIN       = "general.skins.selectedSkin";

const RDFURI_ITEM_ROOT  = "urn:mozilla:item:root";
const PREFIX_ITEM_URI   = "urn:mozilla:item:";

///////////////////////////////////////////////////////////////////////////////
// Utility Functions 

function getIDFromResourceURI(aURI) 
{
  if (aURI.substring(0, PREFIX_ITEM_URI.length) == PREFIX_ITEM_URI) 
    return aURI.substring(PREFIX_ITEM_URI.length);
  return aURI;
}

function openURL(aURL)
{
//@line 88 "/builds/tinderbox/Fx-Trunk/Linux_2.4.21-27.0.4.ELsmp_Depend/mozilla/toolkit/mozapps/extensions/content/extensions.js"
  openDialog("chrome://browser/content/browser.xul", "_blank", "chrome,all,dialog=no", aURL, null, null);
//@line 90 "/builds/tinderbox/Fx-Trunk/Linux_2.4.21-27.0.4.ELsmp_Depend/mozilla/toolkit/mozapps/extensions/content/extensions.js"
}

function flushDataSource()
{
  var rds = gExtensionManager.datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
  if (rds)
    rds.Flush();
}

function setRestartMessage(aItem)
{
  var sbs = Components.classes["@mozilla.org/intl/stringbundle;1"]
                      .getService(Components.interfaces.nsIStringBundleService);
  var extensionStrings = sbs.createBundle("chrome://mozapps/locale/extensions/extensions.properties");
  var brandStrings = sbs.createBundle("chrome://branding/locale/brand.properties");
  var brandShortName = brandStrings.GetStringFromName("brandShortName");
  var themeName = aItem.getAttribute("name");
  var restartMessage = extensionStrings.formatStringFromName("dssSwitchAfterRestart", 
                                                             [brandShortName], 1);
  for (var i = 0; i < gExtensionsView.childNodes.length; ++i) {
    var item = gExtensionsView.childNodes[i];
    if (item.hasAttribute("oldDescription")) {
      item.setAttribute("description", item.getAttribute("oldDescription"));
      item.removeAttribute("oldDescription");
    }
  }
  aItem.setAttribute("oldDescription", aItem.getAttribute("description"));
  aItem.setAttribute("description", restartMessage);
}

///////////////////////////////////////////////////////////////////////////////
// Event Handlers
function onExtensionSelect(aEvent)
{
  if (aEvent.target.selected)
    aEvent.target.setAttribute("last-selected", aEvent.target.selected.id);
  else
    aEvent.target.removeAttribute("last-selected");
}

///////////////////////////////////////////////////////////////////////////////
// Startup, Shutdown
function Startup() 
{
  gWindowState = window.location.search.substr("?type=".length, window.location.search.length);
  
  var isExtensions = gWindowState == "extensions";
  gItemType   = isExtensions ? nsIUpdateItem.TYPE_EXTENSION : nsIUpdateItem.TYPE_THEME;
  var typeCondition = document.getElementById("typeCondition");
  typeCondition.setAttribute("object", gItemType);
  
  document.documentElement.setAttribute("windowtype", document.documentElement.getAttribute("windowtype") + "-" + gWindowState);

  gExtensionsView = document.getElementById("extensionsView");
  gExtensionsView.setAttribute("state", gWindowState);
  gExtensionManager = Components.classes["@mozilla.org/extensions/manager;1"]
                                .getService(Components.interfaces.nsIExtensionManager);
  gApp = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo)
                   .QueryInterface(Components.interfaces.nsIXULRuntime);

  // Extension Command Updating is handled by a command controller.
  gExtensionsView.controllers.appendController(gExtensionsViewController);

  // This persists the last-selected extension
  gExtensionsView.addEventListener("richview-select", onExtensionSelect, false);

  // Finally, update the UI. 
  gExtensionsView.database.AddDataSource(gExtensionManager.datasource);
  gExtensionsView.setAttribute("ref", RDFURI_ITEM_ROOT);
  gExtensionsView.focus();
  
  var pref = Components.classes["@mozilla.org/preferences-service;1"]
                       .getService(Components.interfaces.nsIPrefBranch);
  var defaultPref = pref.QueryInterface(Components.interfaces.nsIPrefService)
                        .getDefaultBranch(null);
  if (!isExtensions) {
    gExtensionsView.addEventListener("richview-select", onThemeSelect, false);

    try {
        gCurrentTheme = pref.getCharPref(PREF_GENERAL_SKINS_SELECTEDSKIN);
        gDefaultTheme = defaultPref.getCharPref(PREF_GENERAL_SKINS_SELECTEDSKIN);
    }
    catch (e) { }

    var useThemeButton = document.getElementById("useThemeButton");
    useThemeButton.hidden = false;

    var optionsButton = document.getElementById("optionsButton");
    optionsButton.hidden = true;
  }
  
  // Restore the last-selected extension
  var lastSelected = gExtensionsView.getAttribute("last-selected");
  if (lastSelected != "")
    lastSelected = document.getElementById(lastSelected);
  if (!lastSelected) 
    gExtensionsView.selectionForward();
  else
    gExtensionsView.selected = lastSelected;

  var extensionsStrings = document.getElementById("extensionsStrings");
  document.title = extensionsStrings.getString(gWindowState + "Title");
  
  gExtensionsViewController.onCommandUpdate(); 
  
  gGetMoreURL = pref.getComplexValue(isExtensions ? PREF_EXTENSIONS_GETMOREEXTENSIONSURL 
                                                  : PREF_EXTENSIONS_GETMORETHEMESURL, 
                                     Components.interfaces.nsIPrefLocalizedString).data;
  var app = Components.classes["@mozilla.org/xre/app-info;1"]
                      .getService(Components.interfaces.nsIXULAppInfo);
  gGetMoreURL = gGetMoreURL.replace(/%APPID%/g, app.ID);
  // Update various pieces of state-dependant UI
  var getMore = document.getElementById("getMore");
  getMore.setAttribute("value", getMore.getAttribute(isExtensions ? "valueextensions" : "valuethemes"));
  getMore.setAttribute("tooltiptext", getMore.getAttribute(isExtensions ? "tooltiptextextensions" : "tooltiptextthemes"));
  
  if (!isExtensions) {
    var themePreviewArea = document.getElementById("themePreviewArea");
    themePreviewArea.hidden = false;
    gExtensionsView.removeAttribute("flex");
  }
  
  // Set Initial Size
  var win = document.documentElement;
  if (!win.hasAttribute("width") || !win.hasAttribute("height")) {
    win.setAttribute("width", isExtensions ? 460 : 560);
    win.setAttribute("height", isExtensions ? 300 : 380);
  }

  // Now look and see if we're being opened by XPInstall
  gDownloadManager = new XPInstallDownloadManager();
  var os = Components.classes["@mozilla.org/observer-service;1"]
                     .getService(Components.interfaces.nsIObserverService);
  os.addObserver(gDownloadManager, "xpinstall-download-started", false);

  gObserverIndex = gExtensionManager.addDownloadListener(gDownloadManager);
  
  if ("arguments" in window) {
    try {
      var params = window.arguments[0].QueryInterface(Components.interfaces.nsIDialogParamBlock);
      gDownloadManager.addDownloads(params);
    }
    catch (e) { }
  }
  
  // Set the tooltips
  if (!isExtensions) {
    var extensionsStrings = document.getElementById("extensionsStrings");
//@line 241 "/builds/tinderbox/Fx-Trunk/Linux_2.4.21-27.0.4.ELsmp_Depend/mozilla/toolkit/mozapps/extensions/content/extensions.js"
    document.getElementById("uninstallButton").setAttribute("tooltiptext", extensionsStrings.getString("cmdUninstallTooltipTheme"));
    document.getElementById("updateButton").setAttribute("tooltiptext", extensionsStrings.getString("cmdUpdateTooltipTheme"));
  }
}

function Shutdown() 
{
  if (gWindowState != "extensions")
    gExtensionsView.removeEventListener("richview-select", onThemeSelect, false);
  
  gExtensionsView.database.RemoveDataSource(gExtensionManager.datasource);

  gExtensionManager.removeDownloadListenerAt(gObserverIndex);

  var os = Components.classes["@mozilla.org/observer-service;1"]
                     .getService(Components.interfaces.nsIObserverService);
  if (gDownloadManager) 
    os.removeObserver(gDownloadManager, "xpinstall-download-started");
}

///////////////////////////////////////////////////////////////////////////////
//
// XPInstall
//

function getURLSpecFromFile(aFile)
{
  var ioServ = Components.classes["@mozilla.org/network/io-service;1"]
                          .getService(Components.interfaces.nsIIOService);
  var fph = ioServ.getProtocolHandler("file").QueryInterface(Components.interfaces.nsIFileProtocolHandler);
  return fph.getURLSpecFromFile(aFile);
}

function XPInstallDownloadManager()
{
  var extensionsStrings = document.getElementById("extensionsStrings");
  this._statusFormatKBMB  = extensionsStrings.getString("statusFormatKBMB");
  this._statusFormatKBKB  = extensionsStrings.getString("statusFormatKBKB");
  this._statusFormatMBMB  = extensionsStrings.getString("statusFormatMBMB");
}

XPInstallDownloadManager.prototype = {
  _statusFormat     : null,
  _statusFormatKBMB : null,
  _statusFormatKBKB : null,
  _statusFormatMBMB : null,
  
  observe: function (aSubject, aTopic, aData) 
  {
    switch (aTopic) {
    case "xpinstall-download-started":
      var params = aSubject.QueryInterface(Components.interfaces.nsISupportsArray);
      var paramBlock = params.GetElementAt(0).QueryInterface(Components.interfaces.nsISupportsInterfacePointer);
      paramBlock = paramBlock.data.QueryInterface(Components.interfaces.nsIDialogParamBlock);
      this.addDownloads(paramBlock);
      break;
    }
  },
  
  addDownloads: function (aParams)
  {
    var numXPInstallItems = aParams.GetInt(1);
    var isExtensions = gWindowState == "extensions";
    
    var items = [];
    for (var i = 0; i < numXPInstallItems;) {
      var displayName = aParams.GetString(i++);
      var url = aParams.GetString(i++);
      var iconURL = aParams.GetString(i++);
      if (!iconURL) { 
        iconURL = isExtensions ? "chrome://mozapps/skin/xpinstall/xpinstallItemGeneric.png" : 
                                 "chrome://mozapps/skin/extensions/themeGeneric.png";
      }
      
      var type = isExtensions ? nsIUpdateItem.TYPE_EXTENSION : nsIUpdateItem.TYPE_THEME;
      // gExtensionManager.addDownload(displayName, url, iconURL, type);
      var item = Components.classes["@mozilla.org/updates/item;1"]
                           .createInstance(Components.interfaces.nsIUpdateItem);
      item.init(url, " ", "app-profile", "", "", displayName, url, iconURL, "", type);
      items.push(item);

      // Advance the enumerator
      var certName = aParams.GetString(i++);
    }
    
    gExtensionManager.addDownloads(items, items.length);
  },

  removeDownload: function (aEvent)
  {
  
  },
  
  /////////////////////////////////////////////////////////////////////////////  
  // nsIExtensionDownloadListener
  onStateChange: function (aURL, aState, aValue)
  {
    const nsIXPIProgressDialog = Components.interfaces.nsIXPIProgressDialog;
    var element = document.getElementById(aURL);
    if (!element) return;
    switch (aState) {
    case nsIXPIProgressDialog.DOWNLOAD_START:
      element.setAttribute("state", "waiting");

      var extensionsStrings = document.getElementById("extensionsStrings");
      element.setAttribute("description", 
                           extensionsStrings.getString("installWaiting"));

      element.setAttribute("progress", "0");
      break;
    case nsIXPIProgressDialog.DOWNLOAD_DONE:
      element.setAttribute("progress", "100");
      break;
    case nsIXPIProgressDialog.INSTALL_START:
      element.setAttribute("state", "installing");

      var extensionsStrings = document.getElementById("extensionsStrings");
      element.setAttribute("description", 
                           extensionsStrings.getString("installInstalling"));
      break;
    case nsIXPIProgressDialog.INSTALL_DONE:
      dump("*** state change = " + aURL + ", state = " + aState + ", value = " + aValue + "\n");
      element.setAttribute("state", "done");
      var extensionsStrings = document.getElementById("extensionsStrings");
      element.setAttribute("description", 
                           extensionsStrings.getString("installSuccess"));
      var msg;
      if (aValue != 0 && aValue != 999) {
        var xpinstallStrings = document.getElementById("xpinstallStrings");
        try {
          msg = xpinstallStrings.getString("error" + aValue);
        }
        catch (e) {
          msg = xpinstallStrings.getFormattedString("unknown.error", [aValue]);
        }
        var sbs = Components.classes["@mozilla.org/intl/stringbundle;1"]
                            .getService(Components.interfaces.nsIStringBundleService);
        var extensionStrings = sbs.createBundle("chrome://mozapps/locale/extensions/extensions.properties");
        var title = extensionStrings.GetStringFromName("errorInstallTitle");

        var brandStrings = sbs.createBundle("chrome://branding/locale/brand.properties");
        var brandShortName = brandStrings.GetStringFromName("brandShortName");
        var params = [brandShortName, aURL, msg];
        var message = extensionStrings.formatStringFromName("errorInstallMsg", params, params.length);
        
        var ps = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                           .getService(Components.interfaces.nsIPromptService);
        ps.alert(window, title, message);
        element.setAttribute("status", msg);
      }
      // Remove the dummy, since we installed successfully
      var type = gWindowState == "extensions" ? nsIUpdateItem.TYPE_EXTENSION 
                                              : nsIUpdateItem.TYPE_THEME;
      gExtensionManager.removeDownload(aURL);
      break;
    case nsIXPIProgressDialog.DIALOG_CLOSE:
      break;
    }
  },
  
  _urls: { },
  onProgress: function (aURL, aValue, aMaxValue)
  {
    var element = document.getElementById(aURL);
    if (!element) return;
    var percent = Math.round((aValue / aMaxValue) * 100);
    if (percent > 1 && !(aURL in this._urls)) {
      this._urls[aURL] = true;
      element.setAttribute("state", "downloading");
    }
    element.setAttribute("progress", percent);
    
    var KBProgress = parseInt(aValue/1024 + .5);
    var KBTotal = parseInt(aMaxValue/1024 + .5);
    element.setAttribute("status", this._formatKBytes(KBProgress, KBTotal));
  },
  
  _replaceInsert: function ( text, index, value ) 
  {
    var result = text;
    var regExp = new RegExp( "#"+index );
    result = result.replace( regExp, value );
    return result;
  },
  
  // aBytes     aTotalKBytes    returns:
  // x, < 1MB   y < 1MB         x of y KB
  // x, < 1MB   y >= 1MB        x KB of y MB
  // x, >= 1MB  y >= 1MB        x of y MB
  _formatKBytes: function (aKBytes, aTotalKBytes)
  {
    var progressHasMB = parseInt(aKBytes/1000) > 0;
    var totalHasMB = parseInt(aTotalKBytes/1000) > 0;
    
    var format = "";
    if (!progressHasMB && !totalHasMB) {
      format = this._statusFormatKBKB;
      format = this._replaceInsert(format, 1, aKBytes);
      format = this._replaceInsert(format, 2, aTotalKBytes);
    }
    else if (progressHasMB && totalHasMB) {
      format = this._statusFormatMBMB;
      format = this._replaceInsert(format, 1, (aKBytes / 1000).toFixed(1));
      format = this._replaceInsert(format, 2, (aTotalKBytes / 1000).toFixed(1));
    }
    else if (totalHasMB && !progressHasMB) {
      format = this._statusFormatKBMB;
      format = this._replaceInsert(format, 1, aKBytes);
      format = this._replaceInsert(format, 2, (aTotalKBytes / 1000).toFixed(1));
    }
    else {
      // This is an undefined state!
      dump("*** huh?!\n");
    }
    
    return format;  
  },

  /////////////////////////////////////////////////////////////////////////////
  // nsISupports
  QueryInterface: function (aIID) 
  {
    if (!aIID.equals(Components.interfaces.nsIExtensionDownloadListener) &&
        !aIID.equals(Components.interfaces.nsISupports))
      throw Components.results.NS_ERROR_NO_INTERFACE;
    return this;
  }
};

///////////////////////////////////////////////////////////////////////////////
//
// View Event Handlers
//
function onViewDoubleClick(aEvent)
{
  if (aEvent.button != 0)
    return;

  switch (gWindowState) {
  case "extensions":
    gExtensionsViewController.doCommand('cmd_options');
    break;
  case "themes":
    gExtensionsViewController.doCommand('cmd_useTheme');
    break;
  }
}

function onThemeSelect(aEvent)
{
  if (gWindowState != "themes")
    return;

  var previewImageDeck = document.getElementById("previewImageDeck");
  if (!gExtensionsView.selected) {
    previewImageDeck.setAttribute("selectedIndex", "0");
    return;
  }
  var url = gExtensionsView.selected.getAttribute("previewImage");
  if (url) {
    previewImageDeck.setAttribute("selectedIndex", "2");
    var previewImage = document.getElementById("previewImage");
    previewImage.setAttribute("src", url);
  }
  else
    previewImageDeck.setAttribute("selectedIndex", "1");
}

///////////////////////////////////////////////////////////////////////////////
// View Context Menus
var gExtensionContextMenus = ["menuitem_options", "menuitem_homepage", "menuitem_about", 
                              "menuseparator_1", "menuitem_uninstall", "menuitem_update",
                              "menuitem_enable", "menuitem_disable", "menuseparator_2", 
                              "menuitem_moveTop", "menuitem_moveUp", "menuitem_moveDn"];
var gThemeContextMenus = ["menuitem_useTheme", "menuitem_homepage", "menuitem_about", 
                          "menuseparator_1", "menuitem_uninstall", "menuitem_update",
                          "menuitem_enable"];

function buildContextMenu(aEvent)
{
  if (aEvent.target.id != "extensionContextMenu")
    return false;
    
  var popup = document.getElementById("extensionContextMenu");
  while (popup.hasChildNodes())
    popup.removeChild(popup.firstChild);

  var isExtensions = gWindowState == "extensions";

  var menus = isExtensions ? gExtensionContextMenus : gThemeContextMenus;  
  for (var i = 0; i < menus.length; ++i) {
    var clonedMenu = document.getElementById(menus[i]).cloneNode(true);
    clonedMenu.id = clonedMenu.id + "_clone";
    popup.appendChild(clonedMenu);
  }

  var extensionsStrings = document.getElementById("extensionsStrings");
  var menuitem_about = document.getElementById("menuitem_about_clone");
  var selectedItem = gExtensionsView.selected;
  var name = selectedItem ? selectedItem.getAttribute("name") : "";
  menuitem_about.setAttribute("label", extensionsStrings.getFormattedString("aboutExtension", [name]));
  
  if (isExtensions) {
    var canEnable = gExtensionsViewController.isCommandEnabled("cmd_reallyEnable");
    var menuitemToShow, menuitemToHide;
    if (canEnable) {
      menuitemToShow = document.getElementById("menuitem_enable_clone");
      menuitemToHide = document.getElementById("menuitem_disable_clone");
    }
    else {
      menuitemToShow = document.getElementById("menuitem_disable_clone");
      menuitemToHide = document.getElementById("menuitem_enable_clone");
    }
    menuitemToShow.hidden = false;
    menuitemToHide.hidden = true;
  }
  else {
    var enableMenu = document.getElementById("menuitem_enable_clone");
    if (gExtensionsView.selected.getAttribute("compatible") == "false" ||
        gExtensionsView.selected.disabled) 
      // don't let the user activate incompatible themes, but show a (disabled) Enable
      // menuitem to give visual feedback; it's disabled because cmd_enable returns false
      enableMenu.hidden = false;
    else {
      enableMenu.hidden = true;
    }
  }
    
  return true;
}

///////////////////////////////////////////////////////////////////////////////
// Drag and Drop

var gExtensionsDNDObserver =
{
  _ioServ: null,
  _filePH: null,
  
  _ensureServices: function ()
  {
    if (!this._ioServ) {
      this._ioServ = Components.classes["@mozilla.org/network/io-service;1"]
                               .getService(Components.interfaces.nsIIOService);
      this._filePH = this._ioServ.getProtocolHandler("file")
                         .QueryInterface(Components.interfaces.nsIFileProtocolHandler);
    }
  },
  
  onDragOver: function (aEvent, aFlavor, aDragSession)
  {
    this._ensureServices();
  
    aDragSession.canDrop = true;
    var count = aDragSession.numDropItems;
    for (var i = 0; i < count; ++i) {
      var xfer = Components.classes["@mozilla.org/widget/transferable;1"]
                          .createInstance(Components.interfaces.nsITransferable);
      xfer.addDataFlavor("text/x-moz-url");
      aDragSession.getData(xfer, i);
      
      var data = { }, length = { };
      xfer.getTransferData("text/x-moz-url", data, length);
      var fileURL = data.value.QueryInterface(Components.interfaces.nsISupportsString).data.split("\n")[0];

      var fileURI = this._ioServ.newURI(fileURL, null, null);
      var url = fileURI.QueryInterface(Components.interfaces.nsIURL);
      if (url.fileExtension != "jar" && url.fileExtension != "xpi") {
        aDragSession.canDrop = false;
        break;
      }
    }
  },
  
  onDrop: function(aEvent, aXferData, aDragSession)
  {
    this._ensureServices();
    
    var xpinstallObj = {};
    var themes = {};
    var xpiCount = 0;
    var themeCount = 0;
    
    var count = aDragSession.numDropItems;
    for (var i = 0; i < count; ++i) {
      var xfer = Components.classes["@mozilla.org/widget/transferable;1"]
                          .createInstance(Components.interfaces.nsITransferable);
      xfer.addDataFlavor("text/x-moz-url");
      aDragSession.getData(xfer, i);
      
      var data = { }, length = { };
      xfer.getTransferData("text/x-moz-url", data, length);
      var fileURL = data.value.QueryInterface(Components.interfaces.nsISupportsString).data.split("\n")[0];

      var uri = Components.classes["@mozilla.org/network/io-service;1"]
                          .getService(Components.interfaces.nsIIOService)
                          .newURI(fileURL, null, null);

      var url = uri.QueryInterface(Components.interfaces.nsIURL);
      if (url.fileExtension == "xpi") {
        xpinstallObj[url.fileName] = fileURL;
        ++xpiCount;
      }
      else if (url.fileExtension == "jar") {
        themes[url.fileName] = fileURL;
        ++themeCount;
      }
    }
    if (xpiCount > 0) 
      InstallTrigger.install(xpinstallObj);
    if (themeCount > 0) {
      for (var fileName in themes)
        InstallTrigger.installChrome(InstallTrigger.SKIN, themes[fileName], fileName);
    }
  },
  _flavourSet: null,  
  getSupportedFlavours: function ()
  {
    if (!this._flavourSet) {
      this._flavourSet = new FlavourSet();
      this._flavourSet.appendFlavour("text/x-moz-url");
    }
    return this._flavourSet;
  }
}

///////////////////////////////////////////////////////////////////////////////
// Command Updating and Command Handlers

function canWriteToLocation(element)
{
  var installLocation = null;
  if (element) {
    var id = getIDFromResourceURI(element.id)
    installLocation = gExtensionManager.getInstallLocation(id);
  }
  return installLocation ? installLocation.canAccess : false;
}


var gExtensionsViewController = {
  supportsCommand: function (aCommand)
  {
    var commandNode = document.getElementById(aCommand);
    return commandNode && (commandNode.parentNode == document.getElementById("extensionsCommands"));
  },
  
  isCommandEnabled: function (aCommand)
  {
    var selectedItem = gExtensionsView.selected;
    switch (aCommand) {
    case "cmd_close":
      return true;
    case "cmd_useTheme":
      return selectedItem &&
             !selectedItem.disabled &&
             selectedItem.getAttribute("toBeUninstalled") != "true" &&
             gCurrentTheme != selectedItem.getAttribute("internalName");
    case "cmd_options":
      return selectedItem &&
             !selectedItem.disabled &&
             !gApp.inSafeMode &&
             selectedItem.getAttribute("toBeUninstalled") != "true" &&
             selectedItem.getAttribute("optionsURL") != "";
    case "cmd_about":
      return selectedItem &&
             selectedItem.getAttribute("toBeInstalled") != "true" &&
             (selectedItem.disabled ? selectedItem.getAttribute("aboutURL") == "" : true);
    case "cmd_homepage":
      return selectedItem && selectedItem.getAttribute("homepageURL") != "";
    case "cmd_uninstall":
      if (gWindowState != "extensions") {
        // uninstall is only available if the selected item isn't the 
        // default theme.
        return (selectedItem && 
                selectedItem.getAttribute("internalName") != gDefaultTheme);
      }
      return selectedItem &&
             selectedItem.getAttribute("toBeUninstalled") != "true" &&
             selectedItem.getAttribute("toBeInstalled") != "true" &&
             selectedItem.getAttribute("locked") != "true" &&
             canWriteToLocation(selectedItem);
    case "cmd_update":
      return !selectedItem ||
             (selectedItem &&
              selectedItem.getAttribute("toBeUninstalled") != "true" &&
              selectedItem.getAttribute("toBeInstalled") != "true") &&
              canWriteToLocation(selectedItem);
    case "cmd_reallyEnable":
    // controls whether to show Enable or Disable in extensions' context menu
      return selectedItem && 
             selectedItem.disabled;
    case "cmd_enable":
    //controls wheter the Enable/Disable menuitem is enabled
      return selectedItem && 
             selectedItem.disabled && 
             selectedItem.getAttribute("toBeUninstalled") != "true" &&
             selectedItem.getAttribute("compatible") != "false";
    case "cmd_disable":
      return selectedItem &&
             !selectedItem.disabled &&
             selectedItem.getAttribute("toBeUninstalled") != "true" && 
             selectedItem.getAttribute("toBeInstalled") != "true";
    case "cmd_movetop":
      return selectedItem && (gExtensionsView.children[0] != selectedItem);
    case "cmd_moveup":
      return selectedItem && (gExtensionsView.children[0] != selectedItem);
    case "cmd_movedn":
      var children = gExtensionsView.children;
      return selectedItem && (children[children.length-1] != selectedItem);
//@line 755 "/builds/tinderbox/Fx-Trunk/Linux_2.4.21-27.0.4.ELsmp_Depend/mozilla/toolkit/mozapps/extensions/content/extensions.js"
    }
    return false;
  },

  doCommand: function (aCommand)
  {
    if (this.isCommandEnabled(aCommand))
      this.commands[aCommand](gExtensionsView.selected);
  },  
  
  onCommandUpdate: function ()
  {
    var extensionsCommands = document.getElementById("extensionsCommands");
    for (var i = 0; i < extensionsCommands.childNodes.length; ++i) {
      var command = extensionsCommands.childNodes[i];
      if (this.isCommandEnabled(command.id))
        command.removeAttribute("disabled");
      else
        command.setAttribute("disabled", "true");
    }
  },
  
  commands: { 
    cmd_close: function (aSelectedItem)
    {
      closeWindow(true);
    },  
  
    cmd_useTheme: function (aSelectedItem)
    {
      var pref = Components.classes["@mozilla.org/preferences-service;1"]
                           .getService(Components.interfaces.nsIPrefBranch);
      gCurrentTheme = aSelectedItem.getAttribute("internalName");
      // Set this pref so the user can reset the theme in safe mode
      pref.setCharPref(PREF_EM_LAST_SELECTED_SKIN, gCurrentTheme);

      if (pref.getBoolPref(PREF_EXTENSIONS_DSS_ENABLED)) {
        pref.setCharPref(PREF_GENERAL_SKINS_SELECTEDSKIN, gCurrentTheme);
      }
      else {
        // Theme change will happen on next startup, this flag tells
        // the Theme Manager that it needs to show "This theme will
        // be selected after a restart" text in the selected theme
        // item.
        pref.setBoolPref(PREF_EXTENSIONS_DSS_SWITCHPENDING, true);
        // Update the view
        setRestartMessage(aSelectedItem);
      }
      
      // disable the useThemeButton
      gExtensionsViewController.onCommandUpdate();
    },
      
    cmd_options: function (aSelectedItem)
    {
      if (!aSelectedItem) return;
      var optionsURL = aSelectedItem.getAttribute("optionsURL");
      if (optionsURL != "")
        openDialog(optionsURL, "", "chrome,modal");
    },
    
    cmd_homepage: function (aSelectedItem)
    {
      if (!aSelectedItem) return;
      var homepageURL = aSelectedItem.getAttribute("homepageURL");
      if (homepageURL != "")
        openURL(homepageURL);
    },
    
    cmd_about: function (aSelectedItem)
    {
      if (!aSelectedItem) return;
      var aboutURL = aSelectedItem.getAttribute("aboutURL");
      if (aboutURL != "")
        openDialog(aboutURL, "", "chrome,modal");
      else
        openDialog("chrome://mozapps/content/extensions/about.xul", "", "chrome,modal", aSelectedItem.id, gExtensionsView.database);
    },  
    
    cmd_movetop: function (aSelectedItem)
    {
      var movingID = aSelectedItem.id;
      var moveTopID = gExtensionsView.children[0].id;
      gExtensionManager.moveToIndexOf(movingID, moveTopID);
      gExtensionsView.selected = document.getElementById(movingID);
    },
    
    cmd_moveup: function (aSelectedItem)
    {
      var movingID = aSelectedItem.id;
      var moveAboveID = aSelectedItem.previousSibling.id;
      gExtensionManager.moveToIndexOf(movingID, moveAboveID);
      gExtensionsView.selected = document.getElementById(movingID);
    },
    
    cmd_movedn: function (aSelectedItem)
    {
      var movingID = aSelectedItem.id;
      var moveBelowID = aSelectedItem.nextSibling.id;
      gExtensionManager.moveToIndexOf(movingID, moveBelowID);
      gExtensionsView.selected = document.getElementById(movingID);
    },
    
    cmd_update: function (aSelectedItem)
    { 
      var id = aSelectedItem ? getIDFromResourceURI(aSelectedItem.id) : null;
      var itemType = gWindowState == "extensions" ? nsIUpdateItem.TYPE_EXTENSION : nsIUpdateItem.TYPE_THEME;
      var items = id ? [gExtensionManager.getItemForID(id)] : [];
      var updates = Components.classes["@mozilla.org/updates/update-service;1"]
                              .getService(Components.interfaces.nsIUpdateService);
      updates.checkForUpdates(items, items.length, itemType, 
                              Components.interfaces.nsIUpdateService.SOURCE_EVENT_USER,
                              window);
    },

    cmd_uninstall: function (aSelectedItem)
    {
      // Confirm the uninstall
      var extensionsStrings = document.getElementById("extensionsStrings");
      var brandStrings = document.getElementById("brandStrings");

      var name = aSelectedItem.getAttribute("name");
      var title = extensionsStrings.getFormattedString("queryUninstallTitle", [name]);
      if (gWindowState == "extensions")
        message = extensionsStrings.getFormattedString("queryUninstallExtensionMessage", [name, name]);
      else if (gWindowState == "themes")
        message = extensionsStrings.getFormattedString("queryUninstallThemeMessage", [name]);

      // XXXben - improve the wording on the buttons here!
      var promptSvc = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                .getService(Components.interfaces.nsIPromptService);
      if (!promptSvc.confirm(window, title, message))
        return;

      var selectedID = aSelectedItem.id;
      var selectedElement = document.getElementById(selectedID);
      var nextElement = selectedElement.nextSibling;
      if (!nextElement)
        nextElement = selectedElement.previousSibling;
      nextElement = nextElement.id;
      
      if (gWindowState == "themes") {
        // If the theme being uninstalled is the current theme, we need to reselect
        // the default. 
        var pref = Components.classes["@mozilla.org/preferences-service;1"]
                             .getService(Components.interfaces.nsIPrefBranch);
        var currentTheme = pref.getCharPref(PREF_GENERAL_SKINS_SELECTEDSKIN);
        if (aSelectedItem.getAttribute("internalName") == currentTheme)
          this.cmd_useTheme(document.getElementById(PREFIX_ITEM_URI + "{972ce4c6-7e08-4474-a285-3208198ce6fd}"));
      }
      gExtensionManager.uninstallItem(getIDFromResourceURI(selectedID));
      
      gExtensionsView.selected = document.getElementById(nextElement);
    },
    
    cmd_disable: function (aSelectedItem)
    {
      gExtensionManager.disableItem(getIDFromResourceURI(aSelectedItem.id));
    },
    
    cmd_enable: function (aSelectedItem)
    {
      gExtensionManager.enableItem(getIDFromResourceURI(aSelectedItem.id));
//@line 919 "/builds/tinderbox/Fx-Trunk/Linux_2.4.21-27.0.4.ELsmp_Depend/mozilla/toolkit/mozapps/extensions/content/extensions.js"
    }
  }
};
