/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class LDAPDN {
    public static String[] explodeDN(String dn, boolean noTypes) {
        DN name = new DN(dn);
        return name.explodeDN(noTypes);
    }

    public static String[] explodeRDN(String rdn, boolean noTypes) {
        RDN name = new RDN(rdn);
        return name.explodeRDN(noTypes);
    }

    public static String escapeRDN(String rdn) {
        RDN name = new RDN(rdn);
        String val = name.getValue();
        if (val == null) {
            return rdn;
        }
        StringBuffer buffer = new StringBuffer(val);
        int i = 0;
        while (i < buffer.length()) {
            if (LDAPDN.isEscape(buffer.charAt(i))) {
                buffer.insert(i, '\\');
                ++i;
            }
            ++i;
        }
        return String.valueOf(name.getType()) + "=" + new String(buffer);
    }

    public static String unEscapeRDN(String rdn) {
        RDN name = new RDN(rdn);
        String val = name.getValue();
        if (val == null) {
            return rdn;
        }
        StringBuffer buffer = new StringBuffer(val);
        StringBuffer copy = new StringBuffer();
        int i = 0;
        while (i < buffer.length()) {
            char c = buffer.charAt(i);
            if (c != '\\') {
                copy.append(c);
            }
            ++i;
        }
        return String.valueOf(name.getType()) + "=" + new String(copy);
    }

    private static boolean isEscape(char c) {
        int i = 0;
        while (i < DN.ESCAPED_CHAR.length) {
            if (c == DN.ESCAPED_CHAR[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

