/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Color;
import netscape.application.Graphics;
import netscape.application.InternalWindow;
import netscape.application.Rect;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class WindowContentView
extends View {
    Color _color = Color.lightGray;
    boolean transparent = false;
    static final String COLOR_KEY = "color";
    static final String TRANSPARENT_KEY = "transparent";

    public WindowContentView() {
        this(0, 0, 0, 0);
    }

    public WindowContentView(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public WindowContentView(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void setColor(Color aColor) {
        this.setBackgroundColor(aColor);
    }

    public void setBackgroundColor(Color aColor) {
        this._color = aColor;
    }

    public Color backgroundColor() {
        return this._color;
    }

    public void setTransparent(boolean flag) {
        this.transparent = flag;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void drawView(Graphics g) {
        InternalWindow theWindow = this.window();
        if (this._color == null || this.isTransparent() || theWindow.isTransparent()) {
            return;
        }
        g.setColor(this._color);
        int i = this.subviewCount();
        g.fillRect(0, 0, this.width(), this.height());
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.WindowContentView", 1);
        info.addField(COLOR_KEY, (byte)18);
        info.addField(TRANSPARENT_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(COLOR_KEY, this._color);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this._color = (Color)decoder.decodeObject(COLOR_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
    }
}

