/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */
#include "nsLayoutAtoms.h"

// XXX make this be autogenerated. doh!

// media atoms
nsIAtom* nsLayoutAtoms::all;
nsIAtom* nsLayoutAtoms::aural;
nsIAtom* nsLayoutAtoms::braille;
nsIAtom* nsLayoutAtoms::embossed;
nsIAtom* nsLayoutAtoms::handheld;
nsIAtom* nsLayoutAtoms::print;
nsIAtom* nsLayoutAtoms::projection;
nsIAtom* nsLayoutAtoms::screen;
nsIAtom* nsLayoutAtoms::tty;
nsIAtom* nsLayoutAtoms::tv;

// name space atoms
nsIAtom* nsLayoutAtoms::htmlNameSpace;
nsIAtom* nsLayoutAtoms::xmlNameSpace;
nsIAtom* nsLayoutAtoms::xmlnsNameSpace;

// frame additional child lists
nsIAtom* nsLayoutAtoms::absoluteList;
nsIAtom* nsLayoutAtoms::bulletList;
nsIAtom* nsLayoutAtoms::colGroupList;
nsIAtom* nsLayoutAtoms::fixedList;
nsIAtom* nsLayoutAtoms::floaterList;

// pseudo tag names for non-element content
nsIAtom* nsLayoutAtoms::commentTagName;
nsIAtom* nsLayoutAtoms::textTagName;
nsIAtom* nsLayoutAtoms::processingInstructionTagName;
nsIAtom* nsLayoutAtoms::viewportPseudo;
nsIAtom* nsLayoutAtoms::pagePseudo;

// frame types
nsIAtom* nsLayoutAtoms::areaFrame;
nsIAtom* nsLayoutAtoms::blockFrame;
nsIAtom* nsLayoutAtoms::htmlFrameInnerFrame;
nsIAtom* nsLayoutAtoms::htmlFrameOuterFrame;
nsIAtom* nsLayoutAtoms::inlineFrame;
nsIAtom* nsLayoutAtoms::letterFrame;
nsIAtom* nsLayoutAtoms::lineFrame;
nsIAtom* nsLayoutAtoms::pageFrame;
nsIAtom* nsLayoutAtoms::placeholderFrame;
nsIAtom* nsLayoutAtoms::positionedInlineFrame;
nsIAtom* nsLayoutAtoms::rootFrame;
nsIAtom* nsLayoutAtoms::scrollFrame;
nsIAtom* nsLayoutAtoms::tableOuterFrame;
nsIAtom* nsLayoutAtoms::tableFrame;
nsIAtom* nsLayoutAtoms::tableRowGroupFrame;
nsIAtom* nsLayoutAtoms::tableRowFrame;
nsIAtom* nsLayoutAtoms::tableCellFrame;
nsIAtom* nsLayoutAtoms::textFrame;
nsIAtom* nsLayoutAtoms::viewportFrame;

static nsrefcnt gRefCnt;

void nsLayoutAtoms::AddrefAtoms()
{
  if (0 == gRefCnt) {
    all = NS_NewAtom("all");  // Media atoms must be lower case
    aural = NS_NewAtom("aural");
    braille = NS_NewAtom("braille");
    embossed = NS_NewAtom("embossed");
    handheld = NS_NewAtom("handheld");
    print = NS_NewAtom("print");
    projection = NS_NewAtom("projection");
    screen = NS_NewAtom("screen");
    tty = NS_NewAtom("tty");
    tv = NS_NewAtom("tv");

    htmlNameSpace = NS_NewAtom("html");
    xmlNameSpace = NS_NewAtom("xml");
    xmlnsNameSpace = NS_NewAtom("xmlns");

    absoluteList = NS_NewAtom("Absolute-list");
    bulletList = NS_NewAtom("Bullet-list");
    colGroupList = NS_NewAtom("ColGroup-list");
    fixedList = NS_NewAtom("Fixed-list");
    floaterList = NS_NewAtom("Floater-list");

    commentTagName = NS_NewAtom("__moz_comment");
    textTagName = NS_NewAtom("__moz_text");
    processingInstructionTagName = NS_NewAtom("__moz_pi");
    viewportPseudo = NS_NewAtom(":-moz-viewport");
    pagePseudo = NS_NewAtom(":-moz-page");

    areaFrame = NS_NewAtom("AreaFrame");
    blockFrame = NS_NewAtom("BlockFrame");
    htmlFrameInnerFrame = NS_NewAtom("htmlFrameInnerFrame");
    htmlFrameOuterFrame = NS_NewAtom("htmlFrameOuterFrame");
    inlineFrame = NS_NewAtom("InlineFrame");
    letterFrame = NS_NewAtom("LetterFrame");
    lineFrame = NS_NewAtom("LineFrame");
    pageFrame = NS_NewAtom("PageFrame");
    placeholderFrame = NS_NewAtom("PlaceholderFrame");
    positionedInlineFrame = NS_NewAtom("PositionedInlineFrame");
    rootFrame = NS_NewAtom("RootFrame");
    scrollFrame = NS_NewAtom("ScrollFrame");
    tableOuterFrame = NS_NewAtom("TableOuterFrame");
    tableFrame = NS_NewAtom("TableFrame");
    tableRowGroupFrame = NS_NewAtom("TableRowGroupFrame");
    tableRowFrame = NS_NewAtom("TableRowFrame");
    tableCellFrame = NS_NewAtom("TableCellFrame");
    textFrame = NS_NewAtom("TextFrame");
    viewportFrame = NS_NewAtom("ViewportFrame");
  }
  ++gRefCnt;
}

void nsLayoutAtoms::ReleaseAtoms()
{
  NS_PRECONDITION(gRefCnt != 0, "bad release atoms");
  if (--gRefCnt == 0) {
    NS_RELEASE(all);
    NS_RELEASE(aural);
    NS_RELEASE(braille);
    NS_RELEASE(embossed);
    NS_RELEASE(handheld);
    NS_RELEASE(print);
    NS_RELEASE(projection);
    NS_RELEASE(screen);
    NS_RELEASE(tty);
    NS_RELEASE(tv);
    
    NS_RELEASE(htmlNameSpace);
    NS_RELEASE(xmlNameSpace);
    NS_RELEASE(xmlnsNameSpace);

    NS_RELEASE(absoluteList);
    NS_RELEASE(bulletList);
    NS_RELEASE(colGroupList);
    NS_RELEASE(fixedList);
    NS_RELEASE(floaterList);

    NS_RELEASE(commentTagName);
    NS_RELEASE(textTagName);
    NS_RELEASE(processingInstructionTagName);
    NS_RELEASE(viewportPseudo);
    NS_RELEASE(pagePseudo);
    
    NS_RELEASE(areaFrame);
    NS_RELEASE(blockFrame);
    NS_RELEASE(htmlFrameInnerFrame);
    NS_RELEASE(htmlFrameOuterFrame);
    NS_RELEASE(inlineFrame);
    NS_RELEASE(letterFrame);
    NS_RELEASE(lineFrame);
    NS_RELEASE(pageFrame);
    NS_RELEASE(placeholderFrame);
    NS_RELEASE(positionedInlineFrame);
    NS_RELEASE(rootFrame);
    NS_RELEASE(scrollFrame);
    NS_RELEASE(tableOuterFrame);
    NS_RELEASE(tableFrame);
    NS_RELEASE(tableRowGroupFrame);
    NS_RELEASE(tableRowFrame);
    NS_RELEASE(tableCellFrame);
    NS_RELEASE(textFrame);
    NS_RELEASE(viewportFrame);
  }
}

