/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla addressbook.
 *
 * The Initial Developer of the Original Code is
 * Seth Spitzer <sspitzer@netscape.com>.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

function AbResultsPaneOnClick(event)
{
    // we only care about button 0 (left click) events
    if (event.button != 0) return;

    // all we need to worry about here is double clicks
    // and column header clicks.
    //
    // we get in here for clicks on the "outlinercol" (headers)
    // and the "scrollbarbutton" (scrollbar buttons)
    // we don't want those events to cause a "double click"

    var t = event.originalTarget;

    if (t.localName == "outlinercol") {
      var sortDirection = kDefaultDescending;

      if (gAbView) {
        var node = document.getElementById(gAbView.URI);
        if (node) {
          sortDirection = node.getAttribute("sortDirection");
        }
        if (sortDirection == kDefaultDescending)
          sortDirection = kDefaultAscending;
        else 
          sortDirection = kDefaultDescending;
      }
      SortAndUpdateIndicators(t.id, sortDirection);
    }
    else if (t.localName == "outlinerchildren") {
       var row = new Object;
       var colID = new Object;
       var childElt = new Object;

       var outliner = GetAbResultsOutliner();
       // figure out what cell the click was in
       outliner.boxObject.QueryInterface(Components.interfaces.nsIOutlinerBoxObject).getCellAt(event.clientX, event.clientY, row, colID, childElt);
       if (row.value == -1)
         return;

       if (event.detail == 2) {
         AbResultsPaneDoubleClick(gAbView.getCardFromRow(row.value));
       }
       else {
         UpdateCardView();
       }
    }
}
