// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!
import Foundation

// Depending on the consumer's build setup, the low-level FFI code
// might be in a separate module, or it might be compiled inline into
// this module. This is a bit of light hackery to work with both.
#if canImport(MozillaRustComponents)
    import MozillaRustComponents
#endif

private extension RustBuffer {
    // Allocate a new buffer, copying the contents of a `UInt8` array.
    init(bytes: [UInt8]) {
        let rbuf = bytes.withUnsafeBufferPointer { ptr in
            RustBuffer.from(ptr)
        }
        self.init(capacity: rbuf.capacity, len: rbuf.len, data: rbuf.data)
    }

    static func from(_ ptr: UnsafeBufferPointer<UInt8>) -> RustBuffer {
        try! rustCall { ffi_nimbus_rustbuffer_from_bytes(ForeignBytes(bufferPointer: ptr), $0) }
    }

    // Frees the buffer in place.
    // The buffer must not be used after this is called.
    func deallocate() {
        try! rustCall { ffi_nimbus_rustbuffer_free(self, $0) }
    }
}

private extension ForeignBytes {
    init(bufferPointer: UnsafeBufferPointer<UInt8>) {
        self.init(len: Int32(bufferPointer.count), data: bufferPointer.baseAddress)
    }
}

// For every type used in the interface, we provide helper methods for conveniently
// lifting and lowering that type from C-compatible data, and for reading and writing
// values of that type in a buffer.

// Helper classes/extensions that don't change.
// Someday, this will be in a library of its own.

private extension Data {
    init(rustBuffer: RustBuffer) {
        // TODO: This copies the buffer. Can we read directly from a
        // Rust buffer?
        self.init(bytes: rustBuffer.data!, count: Int(rustBuffer.len))
    }
}

// Define reader functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.
//
// With external types, one swift source file needs to be able to call the read
// method on another source file's FfiConverter, but then what visibility
// should Reader have?
// - If Reader is fileprivate, then this means the read() must also
//   be fileprivate, which doesn't work with external types.
// - If Reader is internal/public, we'll get compile errors since both source
//   files will try define the same type.
//
// Instead, the read() method and these helper functions input a tuple of data

private func createReader(data: Data) -> (data: Data, offset: Data.Index) {
    (data: data, offset: 0)
}

// Reads an integer at the current offset, in big-endian order, and advances
// the offset on success. Throws if reading the integer would move the
// offset past the end of the buffer.
private func readInt<T: FixedWidthInteger>(_ reader: inout (data: Data, offset: Data.Index)) throws -> T {
    let range = reader.offset ..< reader.offset + MemoryLayout<T>.size
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    if T.self == UInt8.self {
        let value = reader.data[reader.offset]
        reader.offset += 1
        return value as! T
    }
    var value: T = 0
    let _ = withUnsafeMutableBytes(of: &value) { reader.data.copyBytes(to: $0, from: range) }
    reader.offset = range.upperBound
    return value.bigEndian
}

// Reads an arbitrary number of bytes, to be used to read
// raw bytes, this is useful when lifting strings
private func readBytes(_ reader: inout (data: Data, offset: Data.Index), count: Int) throws -> [UInt8] {
    let range = reader.offset ..< (reader.offset + count)
    guard reader.data.count >= range.upperBound else {
        throw UniffiInternalError.bufferOverflow
    }
    var value = [UInt8](repeating: 0, count: count)
    value.withUnsafeMutableBufferPointer { buffer in
        reader.data.copyBytes(to: buffer, from: range)
    }
    reader.offset = range.upperBound
    return value
}

// Reads a float at the current offset.
private func readFloat(_ reader: inout (data: Data, offset: Data.Index)) throws -> Float {
    return try Float(bitPattern: readInt(&reader))
}

// Reads a float at the current offset.
private func readDouble(_ reader: inout (data: Data, offset: Data.Index)) throws -> Double {
    return try Double(bitPattern: readInt(&reader))
}

// Indicates if the offset has reached the end of the buffer.
private func hasRemaining(_ reader: (data: Data, offset: Data.Index)) -> Bool {
    return reader.offset < reader.data.count
}

// Define writer functionality.  Normally this would be defined in a class or
// struct, but we use standalone functions instead in order to make external
// types work.  See the above discussion on Readers for details.

private func createWriter() -> [UInt8] {
    return []
}

private func writeBytes<S>(_ writer: inout [UInt8], _ byteArr: S) where S: Sequence, S.Element == UInt8 {
    writer.append(contentsOf: byteArr)
}

// Writes an integer in big-endian order.
//
// Warning: make sure what you are trying to write
// is in the correct type!
private func writeInt<T: FixedWidthInteger>(_ writer: inout [UInt8], _ value: T) {
    var value = value.bigEndian
    withUnsafeBytes(of: &value) { writer.append(contentsOf: $0) }
}

private func writeFloat(_ writer: inout [UInt8], _ value: Float) {
    writeInt(&writer, value.bitPattern)
}

private func writeDouble(_ writer: inout [UInt8], _ value: Double) {
    writeInt(&writer, value.bitPattern)
}

// Protocol for types that transfer other types across the FFI. This is
// analogous go the Rust trait of the same name.
private protocol FfiConverter {
    associatedtype FfiType
    associatedtype SwiftType

    static func lift(_ value: FfiType) throws -> SwiftType
    static func lower(_ value: SwiftType) -> FfiType
    static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType
    static func write(_ value: SwiftType, into buf: inout [UInt8])
}

// Types conforming to `Primitive` pass themselves directly over the FFI.
private protocol FfiConverterPrimitive: FfiConverter where FfiType == SwiftType {}

extension FfiConverterPrimitive {
    public static func lift(_ value: FfiType) throws -> SwiftType {
        return value
    }

    public static func lower(_ value: SwiftType) -> FfiType {
        return value
    }
}

// Types conforming to `FfiConverterRustBuffer` lift and lower into a `RustBuffer`.
// Used for complex types where it's hard to write a custom lift/lower.
private protocol FfiConverterRustBuffer: FfiConverter where FfiType == RustBuffer {}

extension FfiConverterRustBuffer {
    public static func lift(_ buf: RustBuffer) throws -> SwiftType {
        var reader = createReader(data: Data(rustBuffer: buf))
        let value = try read(from: &reader)
        if hasRemaining(reader) {
            throw UniffiInternalError.incompleteData
        }
        buf.deallocate()
        return value
    }

    public static func lower(_ value: SwiftType) -> RustBuffer {
        var writer = createWriter()
        write(value, into: &writer)
        return RustBuffer(bytes: writer)
    }
}

// An error type for FFI errors. These errors occur at the UniFFI level, not
// the library level.
private enum UniffiInternalError: LocalizedError {
    case bufferOverflow
    case incompleteData
    case unexpectedOptionalTag
    case unexpectedEnumCase
    case unexpectedNullPointer
    case unexpectedRustCallStatusCode
    case unexpectedRustCallError
    case unexpectedStaleHandle
    case rustPanic(_ message: String)

    public var errorDescription: String? {
        switch self {
        case .bufferOverflow: return "Reading the requested value would read past the end of the buffer"
        case .incompleteData: return "The buffer still has data after lifting its containing value"
        case .unexpectedOptionalTag: return "Unexpected optional tag; should be 0 or 1"
        case .unexpectedEnumCase: return "Raw enum value doesn't match any cases"
        case .unexpectedNullPointer: return "Raw pointer value was null"
        case .unexpectedRustCallStatusCode: return "Unexpected RustCallStatus code"
        case .unexpectedRustCallError: return "CALL_ERROR but no errorClass specified"
        case .unexpectedStaleHandle: return "The object in the handle map has been dropped already"
        case let .rustPanic(message): return message
        }
    }
}

private let CALL_SUCCESS: Int8 = 0
private let CALL_ERROR: Int8 = 1
private let CALL_PANIC: Int8 = 2

private extension RustCallStatus {
    init() {
        self.init(
            code: CALL_SUCCESS,
            errorBuf: RustBuffer(
                capacity: 0,
                len: 0,
                data: nil
            )
        )
    }
}

private func rustCall<T>(_ callback: (UnsafeMutablePointer<RustCallStatus>) -> T) throws -> T {
    try makeRustCall(callback, errorHandler: nil)
}

private func rustCallWithError<T>(
    _ errorHandler: @escaping (RustBuffer) throws -> Error,
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T
) throws -> T {
    try makeRustCall(callback, errorHandler: errorHandler)
}

private func makeRustCall<T>(
    _ callback: (UnsafeMutablePointer<RustCallStatus>) -> T,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws -> T {
    uniffiEnsureInitialized()
    var callStatus = RustCallStatus()
    let returnedVal = callback(&callStatus)
    try uniffiCheckCallStatus(callStatus: callStatus, errorHandler: errorHandler)
    return returnedVal
}

private func uniffiCheckCallStatus(
    callStatus: RustCallStatus,
    errorHandler: ((RustBuffer) throws -> Error)?
) throws {
    switch callStatus.code {
    case CALL_SUCCESS:
        return

    case CALL_ERROR:
        if let errorHandler = errorHandler {
            throw try errorHandler(callStatus.errorBuf)
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.unexpectedRustCallError
        }

    case CALL_PANIC:
        // When the rust code sees a panic, it tries to construct a RustBuffer
        // with the message.  But if that code panics, then it just sends back
        // an empty buffer.
        if callStatus.errorBuf.len > 0 {
            throw try UniffiInternalError.rustPanic(FfiConverterString.lift(callStatus.errorBuf))
        } else {
            callStatus.errorBuf.deallocate()
            throw UniffiInternalError.rustPanic("Rust panic")
        }

    default:
        throw UniffiInternalError.unexpectedRustCallStatusCode
    }
}

// Public interface members begin here.

private struct FfiConverterInt8: FfiConverterPrimitive {
    typealias FfiType = Int8
    typealias SwiftType = Int8

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int8 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int8, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterInt32: FfiConverterPrimitive {
    typealias FfiType = Int32
    typealias SwiftType = Int32

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int32 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int32, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterInt64: FfiConverterPrimitive {
    typealias FfiType = Int64
    typealias SwiftType = Int64

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Int64 {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Int64, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterBool: FfiConverter {
    typealias FfiType = Int8
    typealias SwiftType = Bool

    public static func lift(_ value: Int8) throws -> Bool {
        return value != 0
    }

    public static func lower(_ value: Bool) -> Int8 {
        return value ? 1 : 0
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> Bool {
        return try lift(readInt(&buf))
    }

    public static func write(_ value: Bool, into buf: inout [UInt8]) {
        writeInt(&buf, lower(value))
    }
}

private struct FfiConverterString: FfiConverter {
    typealias SwiftType = String
    typealias FfiType = RustBuffer

    public static func lift(_ value: RustBuffer) throws -> String {
        defer {
            value.deallocate()
        }
        if value.data == nil {
            return String()
        }
        let bytes = UnsafeBufferPointer<UInt8>(start: value.data!, count: Int(value.len))
        return String(bytes: bytes, encoding: String.Encoding.utf8)!
    }

    public static func lower(_ value: String) -> RustBuffer {
        return value.utf8CString.withUnsafeBufferPointer { ptr in
            // The swift string gives us int8_t, we want uint8_t.
            ptr.withMemoryRebound(to: UInt8.self) { ptr in
                // The swift string gives us a trailing null byte, we don't want it.
                let buf = UnsafeBufferPointer(rebasing: ptr.prefix(upTo: ptr.count - 1))
                return RustBuffer.from(buf)
            }
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> String {
        let len: Int32 = try readInt(&buf)
        return try String(bytes: readBytes(&buf, count: Int(len)), encoding: String.Encoding.utf8)!
    }

    public static func write(_ value: String, into buf: inout [UInt8]) {
        let len = Int32(value.utf8.count)
        writeInt(&buf, len)
        writeBytes(&buf, value.utf8)
    }
}

public protocol NimbusClientProtocol {
    func initialize() throws
    func getExperimentBranch(id: String) throws -> String?
    func getFeatureConfigVariables(featureId: String) throws -> String?
    func getExperimentBranches(experimentSlug: String) throws -> [ExperimentBranch]
    func getActiveExperiments() throws -> [EnrolledExperiment]
    func getEnrollmentByFeature(featureId: String) throws -> EnrolledFeature?
    func getAvailableExperiments() throws -> [AvailableExperiment]
    func getGlobalUserParticipation() throws -> Bool
    func setGlobalUserParticipation(optIn: Bool) throws -> [EnrollmentChangeEvent]
    func fetchExperiments() throws
    func setFetchEnabled(flag: Bool) throws
    func isFetchEnabled() throws -> Bool
    func applyPendingExperiments() throws -> [EnrollmentChangeEvent]
    func setExperimentsLocally(experimentsJson: String) throws
    func resetEnrollments() throws
    func optInWithBranch(experimentSlug: String, branch: String) throws -> [EnrollmentChangeEvent]
    func optOut(experimentSlug: String) throws -> [EnrollmentChangeEvent]
    func resetTelemetryIdentifiers(newRandomizationUnits: AvailableRandomizationUnits) throws -> [EnrollmentChangeEvent]
    func createTargetingHelper(additionalContext: JsonObject?) throws -> NimbusTargetingHelper
    func createStringHelper(additionalContext: JsonObject?) throws -> NimbusStringHelper
    func recordEvent(eventId: String, count: Int64) throws
    func recordPastEvent(eventId: String, secondsAgo: Int64, count: Int64) throws
    func advanceEventTime(bySeconds: Int64) throws
    func clearEvents() throws
    func dumpStateToLog() throws
}

public class NimbusClient: NimbusClientProtocol {
    fileprivate let pointer: UnsafeMutableRawPointer

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    public convenience init(appCtx: AppContext, coenrollingFeatureIds: [String] = [], dbpath: String, remoteSettingsConfig: RemoteSettingsConfig?, availableRandomizationUnits: AvailableRandomizationUnits) throws {
        try self.init(unsafeFromRawPointer: rustCallWithError(FfiConverterTypeNimbusError.lift) {
            uniffi_nimbus_fn_constructor_nimbusclient_new(
                FfiConverterTypeAppContext.lower(appCtx),
                FfiConverterSequenceString.lower(coenrollingFeatureIds),
                FfiConverterString.lower(dbpath),
                FfiConverterOptionTypeRemoteSettingsConfig.lower(remoteSettingsConfig),
                FfiConverterTypeAvailableRandomizationUnits.lower(availableRandomizationUnits), $0
            )
        })
    }

    deinit {
        try! rustCall { uniffi_nimbus_fn_free_nimbusclient(pointer, $0) }
    }

    public func initialize() throws {
        try
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_initialize(self.pointer, $0)
            }
    }

    public func getExperimentBranch(id: String) throws -> String? {
        return try FfiConverterOptionString.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_get_experiment_branch(self.pointer,
                                                                           FfiConverterString.lower(id), $0)
            }
        )
    }

    public func getFeatureConfigVariables(featureId: String) throws -> String? {
        return try FfiConverterOptionString.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_get_feature_config_variables(self.pointer,
                                                                                  FfiConverterString.lower(featureId), $0)
            }
        )
    }

    public func getExperimentBranches(experimentSlug: String) throws -> [ExperimentBranch] {
        return try FfiConverterSequenceTypeExperimentBranch.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_get_experiment_branches(self.pointer,
                                                                             FfiConverterString.lower(experimentSlug), $0)
            }
        )
    }

    public func getActiveExperiments() throws -> [EnrolledExperiment] {
        return try FfiConverterSequenceTypeEnrolledExperiment.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_get_active_experiments(self.pointer, $0)
            }
        )
    }

    public func getEnrollmentByFeature(featureId: String) throws -> EnrolledFeature? {
        return try FfiConverterOptionTypeEnrolledFeature.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_get_enrollment_by_feature(self.pointer,
                                                                               FfiConverterString.lower(featureId), $0)
            }
        )
    }

    public func getAvailableExperiments() throws -> [AvailableExperiment] {
        return try FfiConverterSequenceTypeAvailableExperiment.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_get_available_experiments(self.pointer, $0)
            }
        )
    }

    public func getGlobalUserParticipation() throws -> Bool {
        return try FfiConverterBool.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_get_global_user_participation(self.pointer, $0)
            }
        )
    }

    public func setGlobalUserParticipation(optIn: Bool) throws -> [EnrollmentChangeEvent] {
        return try FfiConverterSequenceTypeEnrollmentChangeEvent.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_set_global_user_participation(self.pointer,
                                                                                   FfiConverterBool.lower(optIn), $0)
            }
        )
    }

    public func fetchExperiments() throws {
        try
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_fetch_experiments(self.pointer, $0)
            }
    }

    public func setFetchEnabled(flag: Bool) throws {
        try
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_set_fetch_enabled(self.pointer,
                                                                       FfiConverterBool.lower(flag), $0)
            }
    }

    public func isFetchEnabled() throws -> Bool {
        return try FfiConverterBool.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_is_fetch_enabled(self.pointer, $0)
            }
        )
    }

    public func applyPendingExperiments() throws -> [EnrollmentChangeEvent] {
        return try FfiConverterSequenceTypeEnrollmentChangeEvent.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_apply_pending_experiments(self.pointer, $0)
            }
        )
    }

    public func setExperimentsLocally(experimentsJson: String) throws {
        try
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_set_experiments_locally(self.pointer,
                                                                             FfiConverterString.lower(experimentsJson), $0)
            }
    }

    public func resetEnrollments() throws {
        try
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_reset_enrollments(self.pointer, $0)
            }
    }

    public func optInWithBranch(experimentSlug: String, branch: String) throws -> [EnrollmentChangeEvent] {
        return try FfiConverterSequenceTypeEnrollmentChangeEvent.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_opt_in_with_branch(self.pointer,
                                                                        FfiConverterString.lower(experimentSlug),
                                                                        FfiConverterString.lower(branch), $0)
            }
        )
    }

    public func optOut(experimentSlug: String) throws -> [EnrollmentChangeEvent] {
        return try FfiConverterSequenceTypeEnrollmentChangeEvent.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_opt_out(self.pointer,
                                                             FfiConverterString.lower(experimentSlug), $0)
            }
        )
    }

    public func resetTelemetryIdentifiers(newRandomizationUnits: AvailableRandomizationUnits) throws -> [EnrollmentChangeEvent] {
        return try FfiConverterSequenceTypeEnrollmentChangeEvent.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_reset_telemetry_identifiers(self.pointer,
                                                                                 FfiConverterTypeAvailableRandomizationUnits.lower(newRandomizationUnits), $0)
            }
        )
    }

    public func createTargetingHelper(additionalContext: JsonObject? = nil) throws -> NimbusTargetingHelper {
        return try FfiConverterTypeNimbusTargetingHelper.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_create_targeting_helper(self.pointer,
                                                                             FfiConverterOptionTypeJsonObject.lower(additionalContext), $0)
            }
        )
    }

    public func createStringHelper(additionalContext: JsonObject? = nil) throws -> NimbusStringHelper {
        return try FfiConverterTypeNimbusStringHelper.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_create_string_helper(self.pointer,
                                                                          FfiConverterOptionTypeJsonObject.lower(additionalContext), $0)
            }
        )
    }

    public func recordEvent(eventId: String, count: Int64 = Int64(1)) throws {
        try
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_record_event(self.pointer,
                                                                  FfiConverterString.lower(eventId),
                                                                  FfiConverterInt64.lower(count), $0)
            }
    }

    public func recordPastEvent(eventId: String, secondsAgo: Int64, count: Int64 = Int64(1)) throws {
        try
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_record_past_event(self.pointer,
                                                                       FfiConverterString.lower(eventId),
                                                                       FfiConverterInt64.lower(secondsAgo),
                                                                       FfiConverterInt64.lower(count), $0)
            }
    }

    public func advanceEventTime(bySeconds: Int64) throws {
        try
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_advance_event_time(self.pointer,
                                                                        FfiConverterInt64.lower(bySeconds), $0)
            }
    }

    public func clearEvents() throws {
        try
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_clear_events(self.pointer, $0)
            }
    }

    public func dumpStateToLog() throws {
        try
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbusclient_dump_state_to_log(self.pointer, $0)
            }
    }
}

public struct FfiConverterTypeNimbusClient: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = NimbusClient

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> NimbusClient {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: NimbusClient, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> NimbusClient {
        return NimbusClient(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: NimbusClient) -> UnsafeMutableRawPointer {
        return value.pointer
    }
}

public func FfiConverterTypeNimbusClient_lift(_ pointer: UnsafeMutableRawPointer) throws -> NimbusClient {
    return try FfiConverterTypeNimbusClient.lift(pointer)
}

public func FfiConverterTypeNimbusClient_lower(_ value: NimbusClient) -> UnsafeMutableRawPointer {
    return FfiConverterTypeNimbusClient.lower(value)
}

public protocol NimbusStringHelperProtocol {
    func stringFormat(template: String, uuid: String?) -> String
    func getUuid(template: String) -> String?
}

public class NimbusStringHelper: NimbusStringHelperProtocol {
    fileprivate let pointer: UnsafeMutableRawPointer

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    deinit {
        try! rustCall { uniffi_nimbus_fn_free_nimbusstringhelper(pointer, $0) }
    }

    public func stringFormat(template: String, uuid: String? = nil) -> String {
        return try! FfiConverterString.lift(
            try!
                rustCall {
                    uniffi_nimbus_fn_method_nimbusstringhelper_string_format(self.pointer,
                                                                             FfiConverterString.lower(template),
                                                                             FfiConverterOptionString.lower(uuid), $0)
                }
        )
    }

    public func getUuid(template: String) -> String? {
        return try! FfiConverterOptionString.lift(
            try!
                rustCall {
                    uniffi_nimbus_fn_method_nimbusstringhelper_get_uuid(self.pointer,
                                                                        FfiConverterString.lower(template), $0)
                }
        )
    }
}

public struct FfiConverterTypeNimbusStringHelper: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = NimbusStringHelper

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> NimbusStringHelper {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: NimbusStringHelper, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> NimbusStringHelper {
        return NimbusStringHelper(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: NimbusStringHelper) -> UnsafeMutableRawPointer {
        return value.pointer
    }
}

public func FfiConverterTypeNimbusStringHelper_lift(_ pointer: UnsafeMutableRawPointer) throws -> NimbusStringHelper {
    return try FfiConverterTypeNimbusStringHelper.lift(pointer)
}

public func FfiConverterTypeNimbusStringHelper_lower(_ value: NimbusStringHelper) -> UnsafeMutableRawPointer {
    return FfiConverterTypeNimbusStringHelper.lower(value)
}

public protocol NimbusTargetingHelperProtocol {
    func evalJexl(expression: String) throws -> Bool
}

public class NimbusTargetingHelper: NimbusTargetingHelperProtocol {
    fileprivate let pointer: UnsafeMutableRawPointer

    // TODO: We'd like this to be `private` but for Swifty reasons,
    // we can't implement `FfiConverter` without making this `required` and we can't
    // make it `required` without making it `public`.
    required init(unsafeFromRawPointer pointer: UnsafeMutableRawPointer) {
        self.pointer = pointer
    }

    deinit {
        try! rustCall { uniffi_nimbus_fn_free_nimbustargetinghelper(pointer, $0) }
    }

    public func evalJexl(expression: String) throws -> Bool {
        return try FfiConverterBool.lift(
            rustCallWithError(FfiConverterTypeNimbusError.lift) {
                uniffi_nimbus_fn_method_nimbustargetinghelper_eval_jexl(self.pointer,
                                                                        FfiConverterString.lower(expression), $0)
            }
        )
    }
}

public struct FfiConverterTypeNimbusTargetingHelper: FfiConverter {
    typealias FfiType = UnsafeMutableRawPointer
    typealias SwiftType = NimbusTargetingHelper

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> NimbusTargetingHelper {
        let v: UInt64 = try readInt(&buf)
        // The Rust code won't compile if a pointer won't fit in a UInt64.
        // We have to go via `UInt` because that's the thing that's the size of a pointer.
        let ptr = UnsafeMutableRawPointer(bitPattern: UInt(truncatingIfNeeded: v))
        if ptr == nil {
            throw UniffiInternalError.unexpectedNullPointer
        }
        return try lift(ptr!)
    }

    public static func write(_ value: NimbusTargetingHelper, into buf: inout [UInt8]) {
        // This fiddling is because `Int` is the thing that's the same size as a pointer.
        // The Rust code won't compile if a pointer won't fit in a `UInt64`.
        writeInt(&buf, UInt64(bitPattern: Int64(Int(bitPattern: lower(value)))))
    }

    public static func lift(_ pointer: UnsafeMutableRawPointer) throws -> NimbusTargetingHelper {
        return NimbusTargetingHelper(unsafeFromRawPointer: pointer)
    }

    public static func lower(_ value: NimbusTargetingHelper) -> UnsafeMutableRawPointer {
        return value.pointer
    }
}

public func FfiConverterTypeNimbusTargetingHelper_lift(_ pointer: UnsafeMutableRawPointer) throws -> NimbusTargetingHelper {
    return try FfiConverterTypeNimbusTargetingHelper.lift(pointer)
}

public func FfiConverterTypeNimbusTargetingHelper_lower(_ value: NimbusTargetingHelper) -> UnsafeMutableRawPointer {
    return FfiConverterTypeNimbusTargetingHelper.lower(value)
}

public struct AppContext {
    public var appName: String
    public var appId: String
    public var channel: String
    public var appVersion: String?
    public var appBuild: String?
    public var architecture: String?
    public var deviceManufacturer: String?
    public var deviceModel: String?
    public var locale: String?
    public var os: String?
    public var osVersion: String?
    public var androidSdkVersion: String?
    public var debugTag: String?
    public var installationDate: Int64?
    public var homeDirectory: String?
    public var customTargetingAttributes: JsonObject?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(appName: String, appId: String, channel: String, appVersion: String?, appBuild: String?, architecture: String?, deviceManufacturer: String?, deviceModel: String?, locale: String?, os: String?, osVersion: String?, androidSdkVersion: String?, debugTag: String?, installationDate: Int64?, homeDirectory: String?, customTargetingAttributes: JsonObject?) {
        self.appName = appName
        self.appId = appId
        self.channel = channel
        self.appVersion = appVersion
        self.appBuild = appBuild
        self.architecture = architecture
        self.deviceManufacturer = deviceManufacturer
        self.deviceModel = deviceModel
        self.locale = locale
        self.os = os
        self.osVersion = osVersion
        self.androidSdkVersion = androidSdkVersion
        self.debugTag = debugTag
        self.installationDate = installationDate
        self.homeDirectory = homeDirectory
        self.customTargetingAttributes = customTargetingAttributes
    }
}

extension AppContext: Equatable, Hashable {
    public static func == (lhs: AppContext, rhs: AppContext) -> Bool {
        if lhs.appName != rhs.appName {
            return false
        }
        if lhs.appId != rhs.appId {
            return false
        }
        if lhs.channel != rhs.channel {
            return false
        }
        if lhs.appVersion != rhs.appVersion {
            return false
        }
        if lhs.appBuild != rhs.appBuild {
            return false
        }
        if lhs.architecture != rhs.architecture {
            return false
        }
        if lhs.deviceManufacturer != rhs.deviceManufacturer {
            return false
        }
        if lhs.deviceModel != rhs.deviceModel {
            return false
        }
        if lhs.locale != rhs.locale {
            return false
        }
        if lhs.os != rhs.os {
            return false
        }
        if lhs.osVersion != rhs.osVersion {
            return false
        }
        if lhs.androidSdkVersion != rhs.androidSdkVersion {
            return false
        }
        if lhs.debugTag != rhs.debugTag {
            return false
        }
        if lhs.installationDate != rhs.installationDate {
            return false
        }
        if lhs.homeDirectory != rhs.homeDirectory {
            return false
        }
        if lhs.customTargetingAttributes != rhs.customTargetingAttributes {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(appName)
        hasher.combine(appId)
        hasher.combine(channel)
        hasher.combine(appVersion)
        hasher.combine(appBuild)
        hasher.combine(architecture)
        hasher.combine(deviceManufacturer)
        hasher.combine(deviceModel)
        hasher.combine(locale)
        hasher.combine(os)
        hasher.combine(osVersion)
        hasher.combine(androidSdkVersion)
        hasher.combine(debugTag)
        hasher.combine(installationDate)
        hasher.combine(homeDirectory)
        hasher.combine(customTargetingAttributes)
    }
}

public struct FfiConverterTypeAppContext: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AppContext {
        return try AppContext(
            appName: FfiConverterString.read(from: &buf),
            appId: FfiConverterString.read(from: &buf),
            channel: FfiConverterString.read(from: &buf),
            appVersion: FfiConverterOptionString.read(from: &buf),
            appBuild: FfiConverterOptionString.read(from: &buf),
            architecture: FfiConverterOptionString.read(from: &buf),
            deviceManufacturer: FfiConverterOptionString.read(from: &buf),
            deviceModel: FfiConverterOptionString.read(from: &buf),
            locale: FfiConverterOptionString.read(from: &buf),
            os: FfiConverterOptionString.read(from: &buf),
            osVersion: FfiConverterOptionString.read(from: &buf),
            androidSdkVersion: FfiConverterOptionString.read(from: &buf),
            debugTag: FfiConverterOptionString.read(from: &buf),
            installationDate: FfiConverterOptionInt64.read(from: &buf),
            homeDirectory: FfiConverterOptionString.read(from: &buf),
            customTargetingAttributes: FfiConverterOptionTypeJsonObject.read(from: &buf)
        )
    }

    public static func write(_ value: AppContext, into buf: inout [UInt8]) {
        FfiConverterString.write(value.appName, into: &buf)
        FfiConverterString.write(value.appId, into: &buf)
        FfiConverterString.write(value.channel, into: &buf)
        FfiConverterOptionString.write(value.appVersion, into: &buf)
        FfiConverterOptionString.write(value.appBuild, into: &buf)
        FfiConverterOptionString.write(value.architecture, into: &buf)
        FfiConverterOptionString.write(value.deviceManufacturer, into: &buf)
        FfiConverterOptionString.write(value.deviceModel, into: &buf)
        FfiConverterOptionString.write(value.locale, into: &buf)
        FfiConverterOptionString.write(value.os, into: &buf)
        FfiConverterOptionString.write(value.osVersion, into: &buf)
        FfiConverterOptionString.write(value.androidSdkVersion, into: &buf)
        FfiConverterOptionString.write(value.debugTag, into: &buf)
        FfiConverterOptionInt64.write(value.installationDate, into: &buf)
        FfiConverterOptionString.write(value.homeDirectory, into: &buf)
        FfiConverterOptionTypeJsonObject.write(value.customTargetingAttributes, into: &buf)
    }
}

public func FfiConverterTypeAppContext_lift(_ buf: RustBuffer) throws -> AppContext {
    return try FfiConverterTypeAppContext.lift(buf)
}

public func FfiConverterTypeAppContext_lower(_ value: AppContext) -> RustBuffer {
    return FfiConverterTypeAppContext.lower(value)
}

public struct AvailableExperiment {
    public var slug: String
    public var userFacingName: String
    public var userFacingDescription: String
    public var branches: [ExperimentBranch]
    public var referenceBranch: String?

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(slug: String, userFacingName: String, userFacingDescription: String, branches: [ExperimentBranch], referenceBranch: String?) {
        self.slug = slug
        self.userFacingName = userFacingName
        self.userFacingDescription = userFacingDescription
        self.branches = branches
        self.referenceBranch = referenceBranch
    }
}

extension AvailableExperiment: Equatable, Hashable {
    public static func == (lhs: AvailableExperiment, rhs: AvailableExperiment) -> Bool {
        if lhs.slug != rhs.slug {
            return false
        }
        if lhs.userFacingName != rhs.userFacingName {
            return false
        }
        if lhs.userFacingDescription != rhs.userFacingDescription {
            return false
        }
        if lhs.branches != rhs.branches {
            return false
        }
        if lhs.referenceBranch != rhs.referenceBranch {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(slug)
        hasher.combine(userFacingName)
        hasher.combine(userFacingDescription)
        hasher.combine(branches)
        hasher.combine(referenceBranch)
    }
}

public struct FfiConverterTypeAvailableExperiment: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AvailableExperiment {
        return try AvailableExperiment(
            slug: FfiConverterString.read(from: &buf),
            userFacingName: FfiConverterString.read(from: &buf),
            userFacingDescription: FfiConverterString.read(from: &buf),
            branches: FfiConverterSequenceTypeExperimentBranch.read(from: &buf),
            referenceBranch: FfiConverterOptionString.read(from: &buf)
        )
    }

    public static func write(_ value: AvailableExperiment, into buf: inout [UInt8]) {
        FfiConverterString.write(value.slug, into: &buf)
        FfiConverterString.write(value.userFacingName, into: &buf)
        FfiConverterString.write(value.userFacingDescription, into: &buf)
        FfiConverterSequenceTypeExperimentBranch.write(value.branches, into: &buf)
        FfiConverterOptionString.write(value.referenceBranch, into: &buf)
    }
}

public func FfiConverterTypeAvailableExperiment_lift(_ buf: RustBuffer) throws -> AvailableExperiment {
    return try FfiConverterTypeAvailableExperiment.lift(buf)
}

public func FfiConverterTypeAvailableExperiment_lower(_ value: AvailableExperiment) -> RustBuffer {
    return FfiConverterTypeAvailableExperiment.lower(value)
}

public struct AvailableRandomizationUnits {
    public var clientId: String?
    public var userId: String?
    public var nimbusId: String?
    public var dummy: Int8

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(clientId: String?, userId: String?, nimbusId: String?, dummy: Int8) {
        self.clientId = clientId
        self.userId = userId
        self.nimbusId = nimbusId
        self.dummy = dummy
    }
}

extension AvailableRandomizationUnits: Equatable, Hashable {
    public static func == (lhs: AvailableRandomizationUnits, rhs: AvailableRandomizationUnits) -> Bool {
        if lhs.clientId != rhs.clientId {
            return false
        }
        if lhs.userId != rhs.userId {
            return false
        }
        if lhs.nimbusId != rhs.nimbusId {
            return false
        }
        if lhs.dummy != rhs.dummy {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(clientId)
        hasher.combine(userId)
        hasher.combine(nimbusId)
        hasher.combine(dummy)
    }
}

public struct FfiConverterTypeAvailableRandomizationUnits: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> AvailableRandomizationUnits {
        return try AvailableRandomizationUnits(
            clientId: FfiConverterOptionString.read(from: &buf),
            userId: FfiConverterOptionString.read(from: &buf),
            nimbusId: FfiConverterOptionString.read(from: &buf),
            dummy: FfiConverterInt8.read(from: &buf)
        )
    }

    public static func write(_ value: AvailableRandomizationUnits, into buf: inout [UInt8]) {
        FfiConverterOptionString.write(value.clientId, into: &buf)
        FfiConverterOptionString.write(value.userId, into: &buf)
        FfiConverterOptionString.write(value.nimbusId, into: &buf)
        FfiConverterInt8.write(value.dummy, into: &buf)
    }
}

public func FfiConverterTypeAvailableRandomizationUnits_lift(_ buf: RustBuffer) throws -> AvailableRandomizationUnits {
    return try FfiConverterTypeAvailableRandomizationUnits.lift(buf)
}

public func FfiConverterTypeAvailableRandomizationUnits_lower(_ value: AvailableRandomizationUnits) -> RustBuffer {
    return FfiConverterTypeAvailableRandomizationUnits.lower(value)
}

public struct EnrolledExperiment {
    public var featureIds: [String]
    public var slug: String
    public var userFacingName: String
    public var userFacingDescription: String
    public var branchSlug: String
    public var enrollmentId: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(featureIds: [String], slug: String, userFacingName: String, userFacingDescription: String, branchSlug: String, enrollmentId: String) {
        self.featureIds = featureIds
        self.slug = slug
        self.userFacingName = userFacingName
        self.userFacingDescription = userFacingDescription
        self.branchSlug = branchSlug
        self.enrollmentId = enrollmentId
    }
}

extension EnrolledExperiment: Equatable, Hashable {
    public static func == (lhs: EnrolledExperiment, rhs: EnrolledExperiment) -> Bool {
        if lhs.featureIds != rhs.featureIds {
            return false
        }
        if lhs.slug != rhs.slug {
            return false
        }
        if lhs.userFacingName != rhs.userFacingName {
            return false
        }
        if lhs.userFacingDescription != rhs.userFacingDescription {
            return false
        }
        if lhs.branchSlug != rhs.branchSlug {
            return false
        }
        if lhs.enrollmentId != rhs.enrollmentId {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(featureIds)
        hasher.combine(slug)
        hasher.combine(userFacingName)
        hasher.combine(userFacingDescription)
        hasher.combine(branchSlug)
        hasher.combine(enrollmentId)
    }
}

public struct FfiConverterTypeEnrolledExperiment: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> EnrolledExperiment {
        return try EnrolledExperiment(
            featureIds: FfiConverterSequenceString.read(from: &buf),
            slug: FfiConverterString.read(from: &buf),
            userFacingName: FfiConverterString.read(from: &buf),
            userFacingDescription: FfiConverterString.read(from: &buf),
            branchSlug: FfiConverterString.read(from: &buf),
            enrollmentId: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: EnrolledExperiment, into buf: inout [UInt8]) {
        FfiConverterSequenceString.write(value.featureIds, into: &buf)
        FfiConverterString.write(value.slug, into: &buf)
        FfiConverterString.write(value.userFacingName, into: &buf)
        FfiConverterString.write(value.userFacingDescription, into: &buf)
        FfiConverterString.write(value.branchSlug, into: &buf)
        FfiConverterString.write(value.enrollmentId, into: &buf)
    }
}

public func FfiConverterTypeEnrolledExperiment_lift(_ buf: RustBuffer) throws -> EnrolledExperiment {
    return try FfiConverterTypeEnrolledExperiment.lift(buf)
}

public func FfiConverterTypeEnrolledExperiment_lower(_ value: EnrolledExperiment) -> RustBuffer {
    return FfiConverterTypeEnrolledExperiment.lower(value)
}

public struct EnrolledFeature {
    public var slug: String
    public var branch: String?
    public var featureId: String

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(slug: String, branch: String?, featureId: String) {
        self.slug = slug
        self.branch = branch
        self.featureId = featureId
    }
}

extension EnrolledFeature: Equatable, Hashable {
    public static func == (lhs: EnrolledFeature, rhs: EnrolledFeature) -> Bool {
        if lhs.slug != rhs.slug {
            return false
        }
        if lhs.branch != rhs.branch {
            return false
        }
        if lhs.featureId != rhs.featureId {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(slug)
        hasher.combine(branch)
        hasher.combine(featureId)
    }
}

public struct FfiConverterTypeEnrolledFeature: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> EnrolledFeature {
        return try EnrolledFeature(
            slug: FfiConverterString.read(from: &buf),
            branch: FfiConverterOptionString.read(from: &buf),
            featureId: FfiConverterString.read(from: &buf)
        )
    }

    public static func write(_ value: EnrolledFeature, into buf: inout [UInt8]) {
        FfiConverterString.write(value.slug, into: &buf)
        FfiConverterOptionString.write(value.branch, into: &buf)
        FfiConverterString.write(value.featureId, into: &buf)
    }
}

public func FfiConverterTypeEnrolledFeature_lift(_ buf: RustBuffer) throws -> EnrolledFeature {
    return try FfiConverterTypeEnrolledFeature.lift(buf)
}

public func FfiConverterTypeEnrolledFeature_lower(_ value: EnrolledFeature) -> RustBuffer {
    return FfiConverterTypeEnrolledFeature.lower(value)
}

public struct EnrollmentChangeEvent {
    public var experimentSlug: String
    public var branchSlug: String
    public var enrollmentId: String
    public var reason: String?
    public var change: EnrollmentChangeEventType

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(experimentSlug: String, branchSlug: String, enrollmentId: String, reason: String?, change: EnrollmentChangeEventType) {
        self.experimentSlug = experimentSlug
        self.branchSlug = branchSlug
        self.enrollmentId = enrollmentId
        self.reason = reason
        self.change = change
    }
}

extension EnrollmentChangeEvent: Equatable, Hashable {
    public static func == (lhs: EnrollmentChangeEvent, rhs: EnrollmentChangeEvent) -> Bool {
        if lhs.experimentSlug != rhs.experimentSlug {
            return false
        }
        if lhs.branchSlug != rhs.branchSlug {
            return false
        }
        if lhs.enrollmentId != rhs.enrollmentId {
            return false
        }
        if lhs.reason != rhs.reason {
            return false
        }
        if lhs.change != rhs.change {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(experimentSlug)
        hasher.combine(branchSlug)
        hasher.combine(enrollmentId)
        hasher.combine(reason)
        hasher.combine(change)
    }
}

public struct FfiConverterTypeEnrollmentChangeEvent: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> EnrollmentChangeEvent {
        return try EnrollmentChangeEvent(
            experimentSlug: FfiConverterString.read(from: &buf),
            branchSlug: FfiConverterString.read(from: &buf),
            enrollmentId: FfiConverterString.read(from: &buf),
            reason: FfiConverterOptionString.read(from: &buf),
            change: FfiConverterTypeEnrollmentChangeEventType.read(from: &buf)
        )
    }

    public static func write(_ value: EnrollmentChangeEvent, into buf: inout [UInt8]) {
        FfiConverterString.write(value.experimentSlug, into: &buf)
        FfiConverterString.write(value.branchSlug, into: &buf)
        FfiConverterString.write(value.enrollmentId, into: &buf)
        FfiConverterOptionString.write(value.reason, into: &buf)
        FfiConverterTypeEnrollmentChangeEventType.write(value.change, into: &buf)
    }
}

public func FfiConverterTypeEnrollmentChangeEvent_lift(_ buf: RustBuffer) throws -> EnrollmentChangeEvent {
    return try FfiConverterTypeEnrollmentChangeEvent.lift(buf)
}

public func FfiConverterTypeEnrollmentChangeEvent_lower(_ value: EnrollmentChangeEvent) -> RustBuffer {
    return FfiConverterTypeEnrollmentChangeEvent.lower(value)
}

public struct ExperimentBranch {
    public var slug: String
    public var ratio: Int32

    // Default memberwise initializers are never public by default, so we
    // declare one manually.
    public init(slug: String, ratio: Int32) {
        self.slug = slug
        self.ratio = ratio
    }
}

extension ExperimentBranch: Equatable, Hashable {
    public static func == (lhs: ExperimentBranch, rhs: ExperimentBranch) -> Bool {
        if lhs.slug != rhs.slug {
            return false
        }
        if lhs.ratio != rhs.ratio {
            return false
        }
        return true
    }

    public func hash(into hasher: inout Hasher) {
        hasher.combine(slug)
        hasher.combine(ratio)
    }
}

public struct FfiConverterTypeExperimentBranch: FfiConverterRustBuffer {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> ExperimentBranch {
        return try ExperimentBranch(
            slug: FfiConverterString.read(from: &buf),
            ratio: FfiConverterInt32.read(from: &buf)
        )
    }

    public static func write(_ value: ExperimentBranch, into buf: inout [UInt8]) {
        FfiConverterString.write(value.slug, into: &buf)
        FfiConverterInt32.write(value.ratio, into: &buf)
    }
}

public func FfiConverterTypeExperimentBranch_lift(_ buf: RustBuffer) throws -> ExperimentBranch {
    return try FfiConverterTypeExperimentBranch.lift(buf)
}

public func FfiConverterTypeExperimentBranch_lower(_ value: ExperimentBranch) -> RustBuffer {
    return FfiConverterTypeExperimentBranch.lower(value)
}

// Note that we don't yet support `indirect` for enums.
// See https://github.com/mozilla/uniffi-rs/issues/396 for further discussion.
public enum EnrollmentChangeEventType {
    case enrollment
    case enrollFailed
    case disqualification
    case unenrollment
    case unenrollFailed
}

public struct FfiConverterTypeEnrollmentChangeEventType: FfiConverterRustBuffer {
    typealias SwiftType = EnrollmentChangeEventType

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> EnrollmentChangeEventType {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return .enrollment

        case 2: return .enrollFailed

        case 3: return .disqualification

        case 4: return .unenrollment

        case 5: return .unenrollFailed

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: EnrollmentChangeEventType, into buf: inout [UInt8]) {
        switch value {
        case .enrollment:
            writeInt(&buf, Int32(1))

        case .enrollFailed:
            writeInt(&buf, Int32(2))

        case .disqualification:
            writeInt(&buf, Int32(3))

        case .unenrollment:
            writeInt(&buf, Int32(4))

        case .unenrollFailed:
            writeInt(&buf, Int32(5))
        }
    }
}

public func FfiConverterTypeEnrollmentChangeEventType_lift(_ buf: RustBuffer) throws -> EnrollmentChangeEventType {
    return try FfiConverterTypeEnrollmentChangeEventType.lift(buf)
}

public func FfiConverterTypeEnrollmentChangeEventType_lower(_ value: EnrollmentChangeEventType) -> RustBuffer {
    return FfiConverterTypeEnrollmentChangeEventType.lower(value)
}

extension EnrollmentChangeEventType: Equatable, Hashable {}

public enum NimbusError {
    // Simple error enums only carry a message
    case InvalidPersistedData(message: String)

    // Simple error enums only carry a message
    case RkvError(message: String)

    // Simple error enums only carry a message
    case IoError(message: String)

    // Simple error enums only carry a message
    case JsonError(message: String)

    // Simple error enums only carry a message
    case EvaluationError(message: String)

    // Simple error enums only carry a message
    case InvalidExpression(message: String)

    // Simple error enums only carry a message
    case InvalidFraction(message: String)

    // Simple error enums only carry a message
    case TryFromSliceError(message: String)

    // Simple error enums only carry a message
    case EmptyRatiosError(message: String)

    // Simple error enums only carry a message
    case OutOfBoundsError(message: String)

    // Simple error enums only carry a message
    case UrlParsingError(message: String)

    // Simple error enums only carry a message
    case UuidError(message: String)

    // Simple error enums only carry a message
    case InvalidExperimentFormat(message: String)

    // Simple error enums only carry a message
    case InvalidPath(message: String)

    // Simple error enums only carry a message
    case InternalError(message: String)

    // Simple error enums only carry a message
    case NoSuchExperiment(message: String)

    // Simple error enums only carry a message
    case NoSuchBranch(message: String)

    // Simple error enums only carry a message
    case DatabaseNotReady(message: String)

    // Simple error enums only carry a message
    case VersionParsingError(message: String)

    // Simple error enums only carry a message
    case BehaviorError(message: String)

    // Simple error enums only carry a message
    case TryFromIntError(message: String)

    // Simple error enums only carry a message
    case ParseIntError(message: String)

    // Simple error enums only carry a message
    case TransformParameterError(message: String)

    // Simple error enums only carry a message
    case ClientError(message: String)

    fileprivate static func uniffiErrorHandler(_ error: RustBuffer) throws -> Error {
        return try FfiConverterTypeNimbusError.lift(error)
    }
}

public struct FfiConverterTypeNimbusError: FfiConverterRustBuffer {
    typealias SwiftType = NimbusError

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> NimbusError {
        let variant: Int32 = try readInt(&buf)
        switch variant {
        case 1: return try .InvalidPersistedData(
                message: FfiConverterString.read(from: &buf)
            )

        case 2: return try .RkvError(
                message: FfiConverterString.read(from: &buf)
            )

        case 3: return try .IoError(
                message: FfiConverterString.read(from: &buf)
            )

        case 4: return try .JsonError(
                message: FfiConverterString.read(from: &buf)
            )

        case 5: return try .EvaluationError(
                message: FfiConverterString.read(from: &buf)
            )

        case 6: return try .InvalidExpression(
                message: FfiConverterString.read(from: &buf)
            )

        case 7: return try .InvalidFraction(
                message: FfiConverterString.read(from: &buf)
            )

        case 8: return try .TryFromSliceError(
                message: FfiConverterString.read(from: &buf)
            )

        case 9: return try .EmptyRatiosError(
                message: FfiConverterString.read(from: &buf)
            )

        case 10: return try .OutOfBoundsError(
                message: FfiConverterString.read(from: &buf)
            )

        case 11: return try .UrlParsingError(
                message: FfiConverterString.read(from: &buf)
            )

        case 12: return try .UuidError(
                message: FfiConverterString.read(from: &buf)
            )

        case 13: return try .InvalidExperimentFormat(
                message: FfiConverterString.read(from: &buf)
            )

        case 14: return try .InvalidPath(
                message: FfiConverterString.read(from: &buf)
            )

        case 15: return try .InternalError(
                message: FfiConverterString.read(from: &buf)
            )

        case 16: return try .NoSuchExperiment(
                message: FfiConverterString.read(from: &buf)
            )

        case 17: return try .NoSuchBranch(
                message: FfiConverterString.read(from: &buf)
            )

        case 18: return try .DatabaseNotReady(
                message: FfiConverterString.read(from: &buf)
            )

        case 19: return try .VersionParsingError(
                message: FfiConverterString.read(from: &buf)
            )

        case 20: return try .BehaviorError(
                message: FfiConverterString.read(from: &buf)
            )

        case 21: return try .TryFromIntError(
                message: FfiConverterString.read(from: &buf)
            )

        case 22: return try .ParseIntError(
                message: FfiConverterString.read(from: &buf)
            )

        case 23: return try .TransformParameterError(
                message: FfiConverterString.read(from: &buf)
            )

        case 24: return try .ClientError(
                message: FfiConverterString.read(from: &buf)
            )

        default: throw UniffiInternalError.unexpectedEnumCase
        }
    }

    public static func write(_ value: NimbusError, into buf: inout [UInt8]) {
        switch value {
        case let .InvalidPersistedData(message):
            writeInt(&buf, Int32(1))
        case let .RkvError(message):
            writeInt(&buf, Int32(2))
        case let .IoError(message):
            writeInt(&buf, Int32(3))
        case let .JsonError(message):
            writeInt(&buf, Int32(4))
        case let .EvaluationError(message):
            writeInt(&buf, Int32(5))
        case let .InvalidExpression(message):
            writeInt(&buf, Int32(6))
        case let .InvalidFraction(message):
            writeInt(&buf, Int32(7))
        case let .TryFromSliceError(message):
            writeInt(&buf, Int32(8))
        case let .EmptyRatiosError(message):
            writeInt(&buf, Int32(9))
        case let .OutOfBoundsError(message):
            writeInt(&buf, Int32(10))
        case let .UrlParsingError(message):
            writeInt(&buf, Int32(11))
        case let .UuidError(message):
            writeInt(&buf, Int32(12))
        case let .InvalidExperimentFormat(message):
            writeInt(&buf, Int32(13))
        case let .InvalidPath(message):
            writeInt(&buf, Int32(14))
        case let .InternalError(message):
            writeInt(&buf, Int32(15))
        case let .NoSuchExperiment(message):
            writeInt(&buf, Int32(16))
        case let .NoSuchBranch(message):
            writeInt(&buf, Int32(17))
        case let .DatabaseNotReady(message):
            writeInt(&buf, Int32(18))
        case let .VersionParsingError(message):
            writeInt(&buf, Int32(19))
        case let .BehaviorError(message):
            writeInt(&buf, Int32(20))
        case let .TryFromIntError(message):
            writeInt(&buf, Int32(21))
        case let .ParseIntError(message):
            writeInt(&buf, Int32(22))
        case let .TransformParameterError(message):
            writeInt(&buf, Int32(23))
        case let .ClientError(message):
            writeInt(&buf, Int32(24))
        }
    }
}

extension NimbusError: Equatable, Hashable {}

extension NimbusError: Error {}

private struct FfiConverterOptionInt64: FfiConverterRustBuffer {
    typealias SwiftType = Int64?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterInt64.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterInt64.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionString: FfiConverterRustBuffer {
    typealias SwiftType = String?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterString.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterString.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeEnrolledFeature: FfiConverterRustBuffer {
    typealias SwiftType = EnrolledFeature?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeEnrolledFeature.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeEnrolledFeature.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeRemoteSettingsConfig: FfiConverterRustBuffer {
    typealias SwiftType = RemoteSettingsConfig?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeRemoteSettingsConfig.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeRemoteSettingsConfig.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterOptionTypeJsonObject: FfiConverterRustBuffer {
    typealias SwiftType = JsonObject?

    public static func write(_ value: SwiftType, into buf: inout [UInt8]) {
        guard let value = value else {
            writeInt(&buf, Int8(0))
            return
        }
        writeInt(&buf, Int8(1))
        FfiConverterTypeJsonObject.write(value, into: &buf)
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> SwiftType {
        switch try readInt(&buf) as Int8 {
        case 0: return nil
        case 1: return try FfiConverterTypeJsonObject.read(from: &buf)
        default: throw UniffiInternalError.unexpectedOptionalTag
        }
    }
}

private struct FfiConverterSequenceString: FfiConverterRustBuffer {
    typealias SwiftType = [String]

    public static func write(_ value: [String], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterString.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [String] {
        let len: Int32 = try readInt(&buf)
        var seq = [String]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterString.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeAvailableExperiment: FfiConverterRustBuffer {
    typealias SwiftType = [AvailableExperiment]

    public static func write(_ value: [AvailableExperiment], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeAvailableExperiment.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [AvailableExperiment] {
        let len: Int32 = try readInt(&buf)
        var seq = [AvailableExperiment]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeAvailableExperiment.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeEnrolledExperiment: FfiConverterRustBuffer {
    typealias SwiftType = [EnrolledExperiment]

    public static func write(_ value: [EnrolledExperiment], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeEnrolledExperiment.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [EnrolledExperiment] {
        let len: Int32 = try readInt(&buf)
        var seq = [EnrolledExperiment]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeEnrolledExperiment.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeEnrollmentChangeEvent: FfiConverterRustBuffer {
    typealias SwiftType = [EnrollmentChangeEvent]

    public static func write(_ value: [EnrollmentChangeEvent], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeEnrollmentChangeEvent.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [EnrollmentChangeEvent] {
        let len: Int32 = try readInt(&buf)
        var seq = [EnrollmentChangeEvent]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeEnrollmentChangeEvent.read(from: &buf))
        }
        return seq
    }
}

private struct FfiConverterSequenceTypeExperimentBranch: FfiConverterRustBuffer {
    typealias SwiftType = [ExperimentBranch]

    public static func write(_ value: [ExperimentBranch], into buf: inout [UInt8]) {
        let len = Int32(value.count)
        writeInt(&buf, len)
        for item in value {
            FfiConverterTypeExperimentBranch.write(item, into: &buf)
        }
    }

    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> [ExperimentBranch] {
        let len: Int32 = try readInt(&buf)
        var seq = [ExperimentBranch]()
        seq.reserveCapacity(Int(len))
        for _ in 0 ..< len {
            try seq.append(FfiConverterTypeExperimentBranch.read(from: &buf))
        }
        return seq
    }
}

/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 */
public typealias JsonObject = String
public struct FfiConverterTypeJsonObject: FfiConverter {
    public static func read(from buf: inout (data: Data, offset: Data.Index)) throws -> JsonObject {
        return try FfiConverterString.read(from: &buf)
    }

    public static func write(_ value: JsonObject, into buf: inout [UInt8]) {
        return FfiConverterString.write(value, into: &buf)
    }

    public static func lift(_ value: RustBuffer) throws -> JsonObject {
        return try FfiConverterString.lift(value)
    }

    public static func lower(_ value: JsonObject) -> RustBuffer {
        return FfiConverterString.lower(value)
    }
}

private enum InitializationResult {
    case ok
    case contractVersionMismatch
    case apiChecksumMismatch
}

// Use a global variables to perform the versioning checks. Swift ensures that
// the code inside is only computed once.
private var initializationResult: InitializationResult {
    // Get the bindings contract version from our ComponentInterface
    let bindings_contract_version = 22
    // Get the scaffolding contract version by calling the into the dylib
    let scaffolding_contract_version = ffi_nimbus_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version {
        return InitializationResult.contractVersionMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_initialize() != 51904 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_get_experiment_branch() != 10603 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_get_feature_config_variables() != 41988 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_get_experiment_branches() != 31390 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_get_active_experiments() != 19354 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_get_enrollment_by_feature() != 21095 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_get_available_experiments() != 49085 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_get_global_user_participation() != 10141 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_set_global_user_participation() != 55652 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_fetch_experiments() != 47237 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_set_fetch_enabled() != 19645 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_is_fetch_enabled() != 19071 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_apply_pending_experiments() != 2188 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_set_experiments_locally() != 17473 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_reset_enrollments() != 3557 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_opt_in_with_branch() != 31494 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_opt_out() != 58630 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_reset_telemetry_identifiers() != 12776 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_create_targeting_helper() != 29336 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_create_string_helper() != 11159 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_record_event() != 14297 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_record_past_event() != 14954 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_advance_event_time() != 27182 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_clear_events() != 5624 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusclient_dump_state_to_log() != 26463 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbustargetinghelper_eval_jexl() != 8942 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusstringhelper_string_format() != 58607 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_method_nimbusstringhelper_get_uuid() != 33231 {
        return InitializationResult.apiChecksumMismatch
    }
    if uniffi_nimbus_checksum_constructor_nimbusclient_new() != 64610 {
        return InitializationResult.apiChecksumMismatch
    }

    return InitializationResult.ok
}

private func uniffiEnsureInitialized() {
    switch initializationResult {
    case .ok:
        break
    case .contractVersionMismatch:
        fatalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    case .apiChecksumMismatch:
        fatalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}
