/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
/* global BigInt */

"use strict";

function matchingProperties(obj, regexp) {
  return Object.getOwnPropertyNames(obj)
    .filter(n => regexp.test(n))
    .map(n => obj[n])
    .filter(v => typeof v == "function");
}

function allProperties(obj) {
  return matchingProperties(obj, /./);
}

const TypedArray = Reflect.getPrototypeOf(Int8Array);

module.exports = [
  Array,
  Array.from,
  Array.isArray,
  Array.of,
  Array.prototype.concat,
  Array.prototype.entries,
  Array.prototype.every,
  Array.prototype.filter,
  Array.prototype.find,
  Array.prototype.findIndex,
  Array.prototype.flat,
  Array.prototype.flatMap,
  Array.prototype.forEach,
  Array.prototype.includes,
  Array.prototype.indexOf,
  Array.prototype.join,
  Array.prototype.keys,
  Array.prototype.lastIndexOf,
  Array.prototype.map,
  Array.prototype.reduce,
  Array.prototype.reduceRight,
  Array.prototype.slice,
  Array.prototype.some,
  Array.prototype.values,
  ArrayBuffer,
  ArrayBuffer.isView,
  ArrayBuffer.prototype.slice,
  BigInt,
  ...allProperties(BigInt),
  Boolean,
  DataView,
  Date,
  Date.now,
  Date.parse,
  Date.UTC,
  ...matchingProperties(Date.prototype, /^get/),
  ...matchingProperties(Date.prototype, /^to.*?String$/),
  Error,
  Function,
  Function.prototype.apply,
  Function.prototype.bind,
  Function.prototype.call,
  Function.prototype[Symbol.hasInstance],
  Int8Array,
  Uint8Array,
  Uint8ClampedArray,
  Int16Array,
  Uint16Array,
  Int32Array,
  Uint32Array,
  Float32Array,
  Float64Array,
  TypedArray.from,
  TypedArray.of,
  TypedArray.prototype.entries,
  TypedArray.prototype.every,
  TypedArray.prototype.filter,
  TypedArray.prototype.find,
  TypedArray.prototype.findIndex,
  TypedArray.prototype.forEach,
  TypedArray.prototype.includes,
  TypedArray.prototype.indexOf,
  TypedArray.prototype.join,
  TypedArray.prototype.keys,
  TypedArray.prototype.lastIndexOf,
  TypedArray.prototype.map,
  TypedArray.prototype.reduce,
  TypedArray.prototype.reduceRight,
  TypedArray.prototype.slice,
  TypedArray.prototype.some,
  TypedArray.prototype.subarray,
  TypedArray.prototype.values,
  ...allProperties(JSON),
  Map,
  Map.prototype.forEach,
  Map.prototype.get,
  Map.prototype.has,
  Map.prototype.entries,
  Map.prototype.keys,
  Map.prototype.values,
  ...allProperties(Math),
  Number,
  ...allProperties(Number),
  ...allProperties(Number.prototype),
  Object,
  Object.create,
  Object.keys,
  Object.entries,
  Object.getOwnPropertyDescriptor,
  Object.getOwnPropertyDescriptors,
  Object.getOwnPropertyNames,
  Object.getOwnPropertySymbols,
  Object.getPrototypeOf,
  Object.is,
  Object.isExtensible,
  Object.isFrozen,
  Object.isSealed,
  Object.values,
  Object.prototype.hasOwnProperty,
  Object.prototype.isPrototypeOf,
  Proxy,
  Proxy.revocable,
  Reflect.apply,
  Reflect.construct,
  Reflect.get,
  Reflect.getOwnPropertyDescriptor,
  Reflect.getPrototypeOf,
  Reflect.has,
  Reflect.isExtensible,
  Reflect.ownKeys,
  RegExp,
  RegExp.prototype.exec,
  RegExp.prototype.test,
  RegExp.prototype[Symbol.match],
  RegExp.prototype[Symbol.search],
  RegExp.prototype[Symbol.replace],
  Set,
  Set.prototype.entries,
  Set.prototype.forEach,
  Set.prototype.has,
  Set.prototype.values,
  String,
  ...allProperties(String),
  ...allProperties(String.prototype),
  Symbol,
  Symbol.keyFor,
  WeakMap,
  WeakMap.prototype.get,
  WeakMap.prototype.has,
  WeakSet,
  WeakSet.prototype.has,
  decodeURI,
  decodeURIComponent,
  encodeURI,
  encodeURIComponent,
  escape,
  isFinite,
  isNaN,
  unescape,
];
