/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. RUN TESTS IN FIXTURES/ TO UPDATE.
 */

const {
  parsePacketsWithFronts,
} = require("chrome://mochitests/content/browser/devtools/client/webconsole/test/browser/stub-generator-helpers");
const { prepareMessage } = require("devtools/client/webconsole/utils/messages");
const {
  ConsoleMessage,
  NetworkEventMessage,
} = require("devtools/client/webconsole/types");

const rawPackets = new Map();
rawPackets.set(`console.log('foobar', 'test')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foobar",
      "test"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.log(undefined)`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "undefined"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.warn('danger, will robinson!')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "danger, will robinson!"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "warn",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.log(NaN)`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "NaN"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.log(null)`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "null"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.log('鼬')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "鼬"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.clear()`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "clear",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.count('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": {
      "count": 1,
      "label": "bar"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.assert(false, {message: 'foobar'})`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.child1/obj31",
          "class": "Object",
          "ownPropertyLength": 1,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "Object",
            "ownProperties": {
              "message": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "foobar"
              }
            },
            "ownSymbols": [],
            "ownPropertiesLength": 1,
            "ownSymbolsLength": 0,
            "safeGetterValues": {}
          }
        },
        "actorID": "server0.conn0.child1/obj31"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "assert",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source30",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 35,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 1,
        "sourceId": "server0.conn0.child1/source30"
      }
    ],
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.log('úṇĩçödê țĕșť')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "úṇĩçödê țĕșť"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.dirxml(window)`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.child1/obj34",
          "class": "Window",
          "ownPropertyLength": 818,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "ObjectWithURL",
            "url": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html"
          }
        },
        "actorID": "server0.conn0.child1/obj34"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "dirxml",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.log('myarray', ['red', 'green', 'blue'])`, {
  "message": {
    "addonId": "",
    "arguments": [
      "myarray",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.child1/obj36",
          "class": "Array",
          "ownPropertyLength": 4,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "ArrayLike",
            "length": 3,
            "items": [
              "red",
              "green",
              "blue"
            ]
          }
        },
        "actorID": "server0.conn0.child1/obj36"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.log('myregex', /a.b.c/)`, {
  "message": {
    "addonId": "",
    "arguments": [
      "myregex",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.child1/obj38",
          "class": "RegExp",
          "ownPropertyLength": 1,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "displayString": "/a.b.c/"
        },
        "actorID": "server0.conn0.child1/obj38"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.table(['red', 'green', 'blue']);`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.child1/obj40",
          "class": "Array",
          "ownPropertyLength": 4,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": null,
          "ownProperties": {
            "0": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "red"
            },
            "1": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "green"
            },
            "2": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "blue"
            }
          }
        },
        "actorID": "server0.conn0.child1/obj40"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.log('myobject', {red: 'redValue', green: 'greenValue', blue: 'blueValue'});`, {
  "message": {
    "addonId": "",
    "arguments": [
      "myobject",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.child1/obj42",
          "class": "Object",
          "ownPropertyLength": 3,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "Object",
            "ownProperties": {
              "red": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "redValue"
              },
              "green": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "greenValue"
              },
              "blue": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "blueValue"
              }
            },
            "ownSymbols": [],
            "ownPropertiesLength": 3,
            "ownSymbolsLength": 0,
            "safeGetterValues": {}
          }
        },
        "actorID": "server0.conn0.child1/obj42"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.debug('debug message');`, {
  "message": {
    "addonId": "",
    "arguments": [
      "debug message"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "debug",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.info('info message');`, {
  "message": {
    "addonId": "",
    "arguments": [
      "info message"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "info",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.error('error message');`, {
  "message": {
    "addonId": "",
    "arguments": [
      "error message"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "error",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source30",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 35,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 1,
        "sourceId": "server0.conn0.child1/source30"
      }
    ],
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.log('mymap')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "mymap",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.child1/obj47",
          "class": "Map",
          "ownPropertyLength": 0,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "MapLike",
            "size": 2,
            "entries": [
              [
                "key1",
                "value1"
              ],
              [
                "key2",
                "value2"
              ]
            ]
          }
        },
        "actorID": "server0.conn0.child1/obj47"
      }
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 5,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source46",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.log('myset')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "myset",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.child1/obj49",
          "class": "Set",
          "ownPropertyLength": 0,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "ArrayLike",
            "length": 2,
            "items": [
              "a",
              "b"
            ]
          }
        },
        "actorID": "server0.conn0.child1/obj49"
      }
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.trace()`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "testStacktraceFiltering",
    "groupName": "",
    "level": "trace",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source50",
    "timeStamp": 1572867483805,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 13,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "testStacktraceFiltering",
        "lineNumber": 3,
        "sourceId": "server0.conn0.child1/source50"
      },
      {
        "columnNumber": 5,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "foo",
        "lineNumber": 6,
        "sourceId": "server0.conn0.child1/source50"
      },
      {
        "columnNumber": 3,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 9,
        "sourceId": "server0.conn0.child1/source50"
      }
    ],
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.trace('bar', {'foo': 'bar'}, [1,2,3])`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.child1/obj52",
          "class": "Object",
          "ownPropertyLength": 1,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "Object",
            "ownProperties": {
              "foo": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "bar"
              }
            },
            "ownSymbols": [],
            "ownPropertiesLength": 1,
            "ownSymbolsLength": 0,
            "safeGetterValues": {}
          }
        },
        "actorID": "server0.conn0.child1/obj52"
      },
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.child1/obj53",
          "class": "Array",
          "ownPropertyLength": 4,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "ArrayLike",
            "length": 3,
            "items": [
              1,
              2,
              3
            ]
          }
        },
        "actorID": "server0.conn0.child1/obj53"
      }
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "testStacktraceWithLog",
    "groupName": "",
    "level": "trace",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source51",
    "timeStamp": 1572867483805,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 13,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "testStacktraceWithLog",
        "lineNumber": 3,
        "sourceId": "server0.conn0.child1/source51"
      },
      {
        "columnNumber": 5,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "foo",
        "lineNumber": 6,
        "sourceId": "server0.conn0.child1/source50"
      },
      {
        "columnNumber": 3,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 9,
        "sourceId": "server0.conn0.child1/source50"
      }
    ],
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.time('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "time",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "timeStamp": 1572867483805,
    "timer": {
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`timerAlreadyExists`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "time",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483805,
    "timer": {
      "error": "timerAlreadyExists",
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.timeLog('bar') - 1`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeLog",
    "lineNumber": 4,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483805,
    "timer": {
      "duration": 4,
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.timeLog('bar') - 2`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar",
      "second call",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.child1/obj55",
          "class": "Object",
          "ownPropertyLength": 1,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "Object",
            "ownProperties": {
              "state": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": 1
              }
            },
            "ownSymbols": [],
            "ownPropertiesLength": 1,
            "ownSymbolsLength": 0,
            "safeGetterValues": {}
          }
        },
        "actorID": "server0.conn0.child1/obj55"
      }
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeLog",
    "lineNumber": 5,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source46",
    "timeStamp": 1572867483805,
    "timer": {
      "duration": 5,
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.timeEnd('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeEnd",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483805,
    "timer": {
      "duration": 9,
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`timeEnd.timerDoesntExist`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeEnd",
    "lineNumber": 7,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483805,
    "timer": {
      "error": "timerDoesntExist",
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`timeLog.timerDoesntExist`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeLog",
    "lineNumber": 8,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483805,
    "timer": {
      "error": "timerDoesntExist",
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.table('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.table(['a', 'b', 'c'])`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.child1/obj58",
          "class": "Array",
          "ownPropertyLength": 4,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": null,
          "ownProperties": {
            "0": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "a"
            },
            "1": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "b"
            },
            "2": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "c"
            }
          }
        },
        "actorID": "server0.conn0.child1/obj58"
      }
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.group('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "bar",
    "level": "group",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.groupEnd('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "bar",
    "level": "groupEnd",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.groupCollapsed('foo')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foo"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo",
    "level": "groupCollapsed",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.groupEnd('foo')`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo",
    "level": "groupEnd",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.group()`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "group",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.groupEnd()`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "groupEnd",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.log(%cfoobar)`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [
      "color:blue; font-size:1.3em; background:url('http://example.com/test'); position:absolute; top:10px; ",
      "color:red; line-height: 1.5; background:url('http://example.com/test')"
    ],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.log("%cHello%c|%cWorld")`, {
  "message": {
    "addonId": "",
    "arguments": [
      "Hello",
      "|",
      "World"
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source63",
    "styles": [
      "color:red",
      "",
      "color: blue"
    ],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.group(%cfoo%cbar)`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo bar",
    "level": "group",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [
      "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
      "color:red;background:url('http://example.com/test')"
    ],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.groupEnd(%cfoo%cbar)`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo bar",
    "level": "groupEnd",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.groupCollapsed(%cfoo%cbaz)`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "baz"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo baz",
    "level": "groupCollapsed",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [
      "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
      "color:red;background:url('http://example.com/test')"
    ],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.groupEnd(%cfoo%cbaz)`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo baz",
    "level": "groupEnd",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.dir({C, M, Y, K})`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.child1/obj67",
          "class": "Object",
          "ownPropertyLength": 4,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "Object",
            "ownProperties": {
              "cyan": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "C"
              },
              "magenta": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "M"
              },
              "yellow": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "Y"
              },
              "black": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "K"
              }
            },
            "ownSymbols": [],
            "ownPropertiesLength": 4,
            "ownSymbolsLength": 0,
            "safeGetterValues": {}
          }
        },
        "actorID": "server0.conn0.child1/obj67"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "dir",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.count | default: 1`, {
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 1,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.count | default: 2`, {
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 2,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.count | test counter: 1`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 1,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 4,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.count | test counter: 2`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 2,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 5,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.count | default: 3`, {
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 3,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.count | clear`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "clear",
    "lineNumber": 7,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.count | default: 4`, {
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 4,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 8,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.count | test counter: 3`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 3,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 9,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.countReset | test counter: 0`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 0,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "countReset",
    "lineNumber": 10,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.countReset | counterDoesntExist`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "error": "counterDoesntExist",
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "countReset",
    "lineNumber": 11,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});

rawPackets.set(`console.log escaped characters`, {
  "message": {
    "addonId": "",
    "arguments": [
      "hello \nfrom \rthe \"string world!"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "resourceType": "console-message"
});


const stubPackets = parsePacketsWithFronts(rawPackets);

const stubPreparedMessages = new Map();
for (const [key, packet] of Array.from(stubPackets.entries())) {
  const transformedPacket = prepareMessage(packet, {
    getNextId: () => "1",
  });
  const message = ConsoleMessage(transformedPacket);
  stubPreparedMessages.set(key, message);
}

module.exports = {
  rawPackets,
  stubPreparedMessages,
  stubPackets,
};
