
/* -*- Mode: Java; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 */

const nsIPrefService    = Components.interfaces.nsIPrefService;
const nsIPrefLocalizedString = Components.interfaces.nsIPrefLocalizedString;

const PREFSERVICE_CONTRACTID    = "@mozilla.org/preferences-service;1";

function setHomePageToCurrentPage()
{
  if (top.opener) {
    var homePageField = document.getElementById("browserStartupHomepage");
    var newVal = "";

    var browser = top.opener.document.getElementById("content");
    var l = browser.mPanelContainer.childNodes.length;
    for (var i = 0; i < l; i++) {
      if (i)
        newVal += "|";
      newVal += browser.mPanelContainer.childNodes[i].webNavigation.currentURI.spec;
    }
    
    homePageField.value = newVal;
  }
}

function setHomePageToBookmark()
{
  var rv = { url: null };
  openDialog("chrome://browser/content/bookmarks/selectBookmark.xul", "", 
             "centerscreen,chrome,modal=yes,dialog=yes,resizable=yes", rv);
  if (rv.url) {
    var homePageField = document.getElementById("browserStartupHomepage");
    homePageField.value = rv.url;
  }
}

function setHomePageToDefaultPage()
{
  var prefService = Components.classes[PREFSERVICE_CONTRACTID]
                              .getService(nsIPrefService);
  var pref = prefService.getDefaultBranch(null);
  var url = pref.getComplexValue("browser.startup.homepage",
                                  nsIPrefLocalizedString).data;
  var homePageField = document.getElementById("browserStartupHomepage");
  homePageField.value = url;
}

function onOK() {
  if (!('homepage' in parent)) return;

  // Replace pipes with commas to look nicer.
  parent.homepage = parent.homepage.replace(/\|/g,', ');
  
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
  var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
  var eb = windowManagerInterface.getEnumerator("navigator:browser");
  while (eb.hasMoreElements()) {
    // Update the home button tooltip.
    var domWin = eb.getNext().QueryInterface(Components.interfaces.nsIDOMWindow);
    domWin.document.getElementById("home-button").setAttribute("tooltiptext", parent.homepage);
  }
}

// check download directory is valid
function checkDownloadDirectory() {
   var dloadDir = Components.classes["@mozilla.org/file/local;1"]
                            .createInstance(Components.interfaces.nsILocalFile);
   if (!dloadDir) 
     return false;

   var givenValue = document.getElementById("defaultDir");
   var downloadDir = document.getElementById("downloadDir");
   if (downloadDir.selectedItem == document.getElementById("alwaysAskRadio"))
     return;
   
   try {
     dloadDir.initWithPath(givenValue.value);
     dloadDir.isDirectory();
   }
   catch(ex) {
     var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                   .getService(Components.interfaces.nsIPromptService);
     var prefbundle = document.getElementById("bundle_prefutilities");

     if (givenValue.value == "") { 
       // no directory, reset back to Always Ask
       downloadDir.selectedItem = document.getElementById("alwaysAskRadio");
     } else {
       var checkValue = {value:false};

       var title = prefbundle.getString("downloadDirTitle");
       var description = prefbundle.getFormattedString("invalidDirPopup", [givenValue.value]);
       var buttonPressed = promptService.confirmEx(window, 
         title, description,
         (promptService.BUTTON_TITLE_YES * promptService.BUTTON_POS_0) +
         (promptService.BUTTON_TITLE_NO * promptService.BUTTON_POS_1),
         null, null, null, null, checkValue);

       if (buttonPressed != 0) {
         // they don't want to create the directory
         return;
       }
       try { 
         dloadDir.create(nsIFile.DIRECTORY_TYPE, 0755);
       } catch(ex) {
         title = prefbundle.getString("invalidDirPopupTitle");
         description = prefbundle.getFormattedString("invalidDir", [givenValue.value])
         promptService.alert(parent, title, description);
       }
     }
  }
}

function Startup()
{  
  if (top.opener) {
    var browser = top.opener.document.getElementById("content");
    var l = browser.mPanelContainer.childNodes.length;

    if (l > 1) {
      var useButton = document.getElementById("browserUseCurrent");
      useButton.label = useButton.getAttribute("label2");
    }
  }
  parent.hPrefWindow.registerOKCallbackFunc(onOK);
}
      
function showConnections()
{
  openDialog("chrome://browser/content/pref/pref-connection.xul", "", "centerscreen,chrome,modal=yes,dialog=yes");
}

function showFontsAndColors()
{
  openDialog("chrome://browser/content/pref/pref-fonts.xul", "", "centerscreen,chrome,modal=yes,dialog=yes");
}

function saveFontPrefs()
{
  var dataObject = top.hPrefWindow.wsm.dataManager.pageData["chrome://browser/content/pref/pref-fonts.xul"].userData;
  var pref = top.hPrefWindow.pref;
  for (var language in dataObject.languageData) {
    for (var type in dataObject.languageData[language].types) {
      var fontPrefString = "font.name." + type + "." + language;
      var currValue = "";
      try {
        currValue = pref.CopyUnicharPref(fontPrefString);
      }
      catch(e) {
      }
      if (currValue != dataObject.languageData[language].types[type])
        pref.SetUnicharPref(fontPrefString, dataObject.languageData[language].types[type]);
    }
    var variableSizePref = "font.size.variable." + language;
    var fixedSizePref = "font.size.fixed." + language;
    var minSizePref = "font.minimum-size." + language;
    var currVariableSize = 12, currFixedSize = 12, minSizeVal = 0;
    try {
      currVariableSize = pref.GetIntPref(variableSizePref);
      currFixedSize = pref.GetIntPref(fixedSizePref );
      minSizeVal = pref.GetIntPref(minSizePref);
    }
    catch(e) {
    }
    if (currVariableSize != dataObject.languageData[language].variableSize)
      pref.SetIntPref(variableSizePref, dataObject.languageData[language].variableSize);
    if (currFixedSize != dataObject.languageData[language].fixedSize)
      pref.SetIntPref(fixedSizePref, dataObject.languageData[language].fixedSize);
    if (minSizeVal != dataObject.languageData[language].minSize) {
      pref.SetIntPref(minSizePref, dataObject.languageData[language].minSize);
    }
  }

  // font scaling
  var fontDPI = parseInt(dataObject.fontDPI);
  var myFonts = dataObject.dataEls["useMyFonts"].checked;
  var defaultFont = dataObject.defaultFont;
  var myColors = dataObject.dataEls["useMyColors"].checked;
  try {
    var currDPI = pref.GetIntPref("browser.display.screen_resolution");
    var currFonts = pref.GetIntPref("browser.display.use_document_fonts");
    var currColors = pref.GetBoolPref("browser.display.use_document_colors");
    var currDefault = pref.CopyUnicharPref( "font.default" );
  }
  catch(e) {
  }

  if (currDPI != fontDPI)
    pref.SetIntPref("browser.display.screen_resolution", fontDPI);
  if (currFonts == myFonts)
    pref.SetIntPref("browser.display.use_document_fonts", !myFonts);
  if(currDefault != defaultFont)
    pref.SetUnicharPref( "font.default", defaultFont );
  if (currColors == myColors)
    pref.SetBoolPref("browser.display.use_document_colors", !myColors);

  var items = ["foregroundText", "background", "unvisitedLinks", "visitedLinks"];
  var prefs = ["browser.display.foreground_color", "browser.display.background_color",
                "browser.anchor_color", "browser.visited_color"];
  var prefvalue;
  for (var i = 0; i < items.length; ++i) {
    prefvalue = dataObject.dataEls[items[i]].value;
    pref.SetUnicharPref(prefs[i], prefvalue)
  }
  items = ["browserUseSystemColors", "browserUnderlineAnchors"];
  prefs = ["browser.display.use_system_colors", "browser.underline_anchors"];
  for (i = 0; i < items.length; ++i) {
    prefvalue = dataObject.dataEls[items[i]].checked;
    pref.SetBoolPref(prefs[i], prefvalue)
  }
}
