// |reftest| skip-if(!this.hasOwnProperty('SharedArrayBuffer')) -- SharedArrayBuffer not yet riding the trains
// Copyright (C) 2016 the V8 project authors. All rights reserved.
// Copyright (C) 2017 Mozilla Corporation. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-dataview.prototype.getint32
es6id: 24.2.4.9
description: >
  Boolean littleEndian argument coerced in ToBoolean
info: |
  24.2.4.9 DataView.prototype.getInt32 ( byteOffset [ , littleEndian ] )

  1. Let v be the this value.
  2. If littleEndian is not present, let littleEndian be false.
  3. Return ? GetViewValue(v, byteOffset, littleEndian, "Int32").

  24.2.1.1 GetViewValue ( view, requestIndex, isLittleEndian, type )

  ...
  14. Let bufferIndex be getIndex + viewOffset.
  15. Return GetValueFromBuffer(buffer, bufferIndex, type, isLittleEndian).
  ...

  24.1.1.5 GetValueFromBuffer ( arrayBuffer, byteIndex, type [ , isLittleEndian
  ] )

  ...
  8. If isLittleEndian is false, reverse the order of the elements of rawValue.
  ...
features: [SharedArrayBuffer]
---*/

var buffer = new SharedArrayBuffer(4);
var sample = new DataView(buffer, 0);

sample.setUint8(0, 0);
sample.setUint8(1, 17);
sample.setUint8(2, 4);
sample.setUint8(3, 0);

// False
assert.sameValue(sample.getInt32(0), 1115136, "no arg");
assert.sameValue(sample.getInt32(0, undefined), 1115136, "undefined");
assert.sameValue(sample.getInt32(0, null), 1115136, "null");
assert.sameValue(sample.getInt32(0, 0), 1115136, "0");
assert.sameValue(sample.getInt32(0, ""), 1115136, "the empty string");

// True
assert.sameValue(sample.getInt32(0, {}), 266496, "{}");
assert.sameValue(sample.getInt32(0, Symbol("1")), 266496, "symbol");
assert.sameValue(sample.getInt32(0, 1), 266496, "1");
assert.sameValue(sample.getInt32(0, "string"), 266496, "string");

reportCompare(0, 0);
