/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. RUN TESTS IN FIXTURES/ TO UPDATE.
 */

const { ConsoleMessage } =
  require("devtools/client/webconsole/new-console-output/types");

let stubPreparedMessages = new Map();
let stubPackets = new Map();
stubPreparedMessages.set("console.log('foobar', 'test')", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159894798,
  "type": "log",
  "level": "log",
  "messageText": null,
  "parameters": [
    "foobar",
    "test"
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159894798,\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foobar\",\"test\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.log(undefined)", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159896036,
  "type": "log",
  "level": "log",
  "messageText": null,
  "parameters": [
    {
      "type": "undefined"
    }
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159896036,\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"undefined\"}],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.warn('danger, will robinson!')", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159897333,
  "type": "warn",
  "level": "warn",
  "messageText": null,
  "parameters": [
    "danger, will robinson!"
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159897333,\"type\":\"warn\",\"level\":\"warn\",\"messageText\":null,\"parameters\":[\"danger, will robinson!\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.log(NaN)", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159898667,
  "type": "log",
  "level": "log",
  "messageText": null,
  "parameters": [
    {
      "type": "NaN"
    }
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159898667,\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"NaN\"}],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.log(null)", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159900151,
  "type": "log",
  "level": "log",
  "messageText": null,
  "parameters": [
    {
      "type": "null"
    }
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159900151,\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"null\"}],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.log('鼬')", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159901470,
  "type": "log",
  "level": "log",
  "messageText": null,
  "parameters": [
    "鼬"
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159901470,\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"鼬\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.clear()", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159902721,
  "type": "clear",
  "level": "log",
  "messageText": null,
  "parameters": [
    "Console was cleared."
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159902721,\"type\":\"clear\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"Console was cleared.\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.count('bar')", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159903982,
  "type": "log",
  "level": "debug",
  "messageText": "bar: 1",
  "parameters": null,
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159903982,\"type\":\"log\",\"level\":\"debug\",\"messageText\":\"bar: 1\",\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.assert(false, {message: 'foobar'})", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159905182,
  "type": "assert",
  "level": "error",
  "messageText": null,
  "parameters": [
    {
      "type": "object",
      "actor": "server1.conn8.child1/obj31",
      "class": "Object",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 1,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "message": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "foobar"
          }
        },
        "ownPropertiesLength": 1,
        "safeGetterValues": {}
      }
    }
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159905182,\"type\":\"assert\",\"level\":\"error\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn8.child1/obj31\",\"class\":\"Object\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":1,\"preview\":{\"kind\":\"Object\",\"ownProperties\":{\"message\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"foobar\"}},\"ownPropertiesLength\":1,\"safeGetterValues\":{}}}],\"repeatId\":null,\"stacktrace\":[{\"columnNumber\":27,\"filename\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"functionName\":\"triggerPacket\",\"language\":2,\"lineNumber\":1}],\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": [
    {
      "columnNumber": 27,
      "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "triggerPacket",
      "language": 2,
      "lineNumber": 1
    }
  ],
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.log('hello \nfrom \rthe \"string world!')", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159906444,
  "type": "log",
  "level": "log",
  "messageText": null,
  "parameters": [
    "hello \nfrom \rthe \"string world!"
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159906444,\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"hello \\nfrom \\rthe \\\"string world!\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.log('úṇĩçödê țĕșť')", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159907704,
  "type": "log",
  "level": "log",
  "messageText": null,
  "parameters": [
    "úṇĩçödê țĕșť"
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159907704,\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"úṇĩçödê țĕșť\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.dirxml(window)", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159908948,
  "type": "log",
  "level": "log",
  "messageText": null,
  "parameters": [
    {
      "type": "object",
      "actor": "server1.conn11.child1/obj31",
      "class": "Window",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 815,
      "preview": {
        "kind": "ObjectWithURL",
        "url": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html"
      }
    }
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159908948,\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn11.child1/obj31\",\"class\":\"Window\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":815,\"preview\":{\"kind\":\"ObjectWithURL\",\"url\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\"}}],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.trace()", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159910198,
  "type": "trace",
  "level": "log",
  "messageText": null,
  "parameters": [],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159910198,\"type\":\"trace\",\"level\":\"log\",\"messageText\":null,\"parameters\":[],\"repeatId\":null,\"stacktrace\":[{\"columnNumber\":3,\"filename\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"functionName\":\"testStacktraceFiltering\",\"language\":2,\"lineNumber\":3},{\"columnNumber\":3,\"filename\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"functionName\":\"foo\",\"language\":2,\"lineNumber\":6},{\"columnNumber\":1,\"filename\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"functionName\":\"triggerPacket\",\"language\":2,\"lineNumber\":9}],\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":3,\"column\":3},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": [
    {
      "columnNumber": 3,
      "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "testStacktraceFiltering",
      "language": 2,
      "lineNumber": 3
    },
    {
      "columnNumber": 3,
      "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "foo",
      "language": 2,
      "lineNumber": 6
    },
    {
      "columnNumber": 1,
      "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "triggerPacket",
      "language": 2,
      "lineNumber": 9
    }
  ],
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 3,
    "column": 3
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.time('bar')", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159911476,
  "type": "nullMessage",
  "level": "log",
  "messageText": null,
  "parameters": null,
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159911476,\"type\":\"nullMessage\",\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.timeEnd('bar')", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159911478,
  "type": "timeEnd",
  "level": "log",
  "messageText": "bar: 1.36ms",
  "parameters": null,
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159911478,\"type\":\"timeEnd\",\"level\":\"log\",\"messageText\":\"bar: 1.36ms\",\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":3,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 3,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.table('bar')", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159912655,
  "type": "log",
  "level": "log",
  "messageText": null,
  "parameters": [
    "bar"
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159912655,\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"bar\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.table(['a', 'b', 'c'])", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159913807,
  "type": "table",
  "level": "log",
  "messageText": null,
  "parameters": [
    {
      "type": "object",
      "actor": "server1.conn15.child1/obj31",
      "class": "Array",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 4,
      "preview": {
        "kind": "ArrayLike",
        "length": 3,
        "items": [
          "a",
          "b",
          "c"
        ]
      }
    }
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159913807,\"type\":\"table\",\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn15.child1/obj31\",\"class\":\"Array\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":4,\"preview\":{\"kind\":\"ArrayLike\",\"length\":3,\"items\":[\"a\",\"b\",\"c\"]}}],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.group('bar')", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159914984,
  "type": "startGroup",
  "level": "log",
  "messageText": null,
  "parameters": [
    "bar"
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159914984,\"type\":\"startGroup\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"bar\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.groupEnd('bar')", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159914987,
  "type": "endGroup",
  "level": "log",
  "messageText": null,
  "parameters": null,
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159914987,\"type\":\"endGroup\",\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":3,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 3,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.groupCollapsed('foo')", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159916153,
  "type": "startGroupCollapsed",
  "level": "log",
  "messageText": null,
  "parameters": [
    "foo"
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159916153,\"type\":\"startGroupCollapsed\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foo\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.groupEnd('foo')", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159916155,
  "type": "endGroup",
  "level": "log",
  "messageText": null,
  "parameters": null,
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159916155,\"type\":\"endGroup\",\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":3,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 3,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.group()", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159917524,
  "type": "startGroup",
  "level": "log",
  "messageText": null,
  "parameters": [
    "<no group label>"
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159917524,\"type\":\"startGroup\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"<no group label>\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.groupEnd()", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159917526,
  "type": "endGroup",
  "level": "log",
  "messageText": null,
  "parameters": null,
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159917526,\"type\":\"endGroup\",\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":3,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 3,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.log(%cfoobar)", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1479159919144,
  "type": "log",
  "level": "log",
  "messageText": null,
  "parameters": [
    "foo",
    "bar"
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1479159919144,\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foo\",\"bar\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[\"color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px\",\"color:red;background:url('http://example.com/test')\"],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [
    "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
    "color:red;background:url('http://example.com/test')"
  ],
  "notes": null
}));

stubPreparedMessages.set("console.group(%cfoo%cbar)", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1491902018670,
  "type": "startGroup",
  "level": "log",
  "messageText": null,
  "parameters": [
    "foo",
    "bar"
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1491902018670,\"type\":\"startGroup\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foo\",\"bar\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[\"color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px\",\"color:red;background:url('http://example.com/test')\"],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [
    "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
    "color:red;background:url('http://example.com/test')"
  ],
  "notes": null
}));

stubPreparedMessages.set("console.groupEnd(%cfoo%cbar)", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1491902018671,
  "type": "endGroup",
  "level": "log",
  "messageText": null,
  "parameters": null,
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1491902018671,\"type\":\"endGroup\",\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":6,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 6,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPreparedMessages.set("console.groupCollapsed(%cfoo%cbaz)", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1491902018683,
  "type": "startGroupCollapsed",
  "level": "log",
  "messageText": null,
  "parameters": [
    "foo",
    "baz"
  ],
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1491902018683,\"type\":\"startGroupCollapsed\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foo\",\"baz\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[\"color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px\",\"color:red;background:url('http://example.com/test')\"],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [
    "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
    "color:red;background:url('http://example.com/test')"
  ],
  "notes": null
}));

stubPreparedMessages.set("console.groupEnd(%cfoo%cbaz)", new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1491902018685,
  "type": "endGroup",
  "level": "log",
  "messageText": null,
  "parameters": null,
  "repeat": 1,
  "repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"timeStamp\":1491902018685,\"type\":\"endGroup\",\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\",\"line\":6,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[],\"notes\":null}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "line": 6,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null
}));

stubPackets.set("console.log('foobar', 'test')", {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "foobar",
      "test"
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "private": false,
    "styles": [],
    "timeStamp": 1479159894798,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.log(undefined)", {
  "from": "server1.conn1.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "undefined"
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "private": false,
    "styles": [],
    "timeStamp": 1479159896036,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.warn('danger, will robinson!')", {
  "from": "server1.conn2.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "danger, will robinson!"
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "warn",
    "lineNumber": 1,
    "private": false,
    "styles": [],
    "timeStamp": 1479159897333,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.log(NaN)", {
  "from": "server1.conn3.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "NaN"
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "private": false,
    "styles": [],
    "timeStamp": 1479159898667,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.log(null)", {
  "from": "server1.conn4.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "null"
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "private": false,
    "styles": [],
    "timeStamp": 1479159900151,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.log('鼬')", {
  "from": "server1.conn5.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "鼬"
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "private": false,
    "styles": [],
    "timeStamp": 1479159901470,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.clear()", {
  "from": "server1.conn6.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "clear",
    "lineNumber": 1,
    "private": false,
    "timeStamp": 1479159902721,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set("console.count('bar')", {
  "from": "server1.conn7.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 27,
    "counter": {
      "count": 1,
      "label": "bar"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 1,
    "private": false,
    "timeStamp": 1479159903982,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set("console.assert(false, {message: 'foobar'})", {
  "from": "server1.conn8.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server1.conn8.child1/obj31",
        "class": "Object",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 1,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "message": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "foobar"
            }
          },
          "ownPropertiesLength": 1,
          "safeGetterValues": {}
        }
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "assert",
    "lineNumber": 1,
    "private": false,
    "styles": [],
    "timeStamp": 1479159905182,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 27,
        "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "triggerPacket",
        "language": 2,
        "lineNumber": 1
      }
    ],
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.log('hello \nfrom \rthe \"string world!')", {
  "from": "server1.conn9.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "hello \nfrom \rthe \"string world!"
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "private": false,
    "styles": [],
    "timeStamp": 1479159906444,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.log('úṇĩçödê țĕșť')", {
  "from": "server1.conn10.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "úṇĩçödê țĕșť"
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "private": false,
    "styles": [],
    "timeStamp": 1479159907704,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.dirxml(window)", {
  "from": "server1.conn11.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server1.conn11.child1/obj31",
        "class": "Window",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 815,
        "preview": {
          "kind": "ObjectWithURL",
          "url": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html"
        }
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "dirxml",
    "lineNumber": 1,
    "private": false,
    "timeStamp": 1479159908948,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set("console.trace()", {
  "from": "server1.conn12.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 3,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "testStacktraceFiltering",
    "groupName": "",
    "level": "trace",
    "lineNumber": 3,
    "private": false,
    "timeStamp": 1479159910198,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 3,
        "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "testStacktraceFiltering",
        "language": 2,
        "lineNumber": 3
      },
      {
        "columnNumber": 3,
        "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "foo",
        "language": 2,
        "lineNumber": 6
      },
      {
        "columnNumber": 1,
        "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "triggerPacket",
        "language": 2,
        "lineNumber": 9
      }
    ],
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set("console.time('bar')", {
  "from": "server1.conn13.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "time",
    "lineNumber": 2,
    "private": false,
    "timeStamp": 1479159911476,
    "timer": {
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set("console.timeEnd('bar')", {
  "from": "server1.conn13.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeEnd",
    "lineNumber": 3,
    "private": false,
    "timeStamp": 1479159911478,
    "timer": {
      "duration": 1.3550000000000182,
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set("console.table('bar')", {
  "from": "server1.conn14.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 2,
    "private": false,
    "timeStamp": 1479159912655,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set("console.table(['a', 'b', 'c'])", {
  "from": "server1.conn15.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server1.conn15.child1/obj31",
        "class": "Array",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 4,
        "preview": {
          "kind": "ArrayLike",
          "length": 3,
          "items": [
            "a",
            "b",
            "c"
          ]
        }
      }
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 2,
    "private": false,
    "timeStamp": 1479159913807,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set("console.group('bar')", {
  "from": "server1.conn16.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "bar",
    "level": "group",
    "lineNumber": 2,
    "private": false,
    "styles": [],
    "timeStamp": 1479159914984,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.groupEnd('bar')", {
  "from": "server1.conn16.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "bar",
    "level": "groupEnd",
    "lineNumber": 3,
    "private": false,
    "styles": [],
    "timeStamp": 1479159914987,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.groupCollapsed('foo')", {
  "from": "server1.conn17.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "foo"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo",
    "level": "groupCollapsed",
    "lineNumber": 2,
    "private": false,
    "styles": [],
    "timeStamp": 1479159916153,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.groupEnd('foo')", {
  "from": "server1.conn17.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "foo"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo",
    "level": "groupEnd",
    "lineNumber": 3,
    "private": false,
    "styles": [],
    "timeStamp": 1479159916155,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.group()", {
  "from": "server1.conn18.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "group",
    "lineNumber": 2,
    "private": false,
    "styles": [],
    "timeStamp": 1479159917524,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.groupEnd()", {
  "from": "server1.conn18.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "groupEnd",
    "lineNumber": 3,
    "private": false,
    "styles": [],
    "timeStamp": 1479159917526,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.log(%cfoobar)", {
  "from": "server1.conn19.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 2,
    "private": false,
    "styles": [
      "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
      "color:red;background:url('http://example.com/test')"
    ],
    "timeStamp": 1479159919144,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.group(%cfoo%cbar)", {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo bar",
    "level": "group",
    "lineNumber": 2,
    "private": false,
    "styles": [
      "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
      "color:red;background:url('http://example.com/test')"
    ],
    "timeStamp": 1491902018670,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.groupEnd(%cfoo%cbar)", {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "groupEnd",
    "lineNumber": 6,
    "private": false,
    "styles": [],
    "timeStamp": 1491902018671,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.groupCollapsed(%cfoo%cbaz)", {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "baz"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo baz",
    "level": "groupCollapsed",
    "lineNumber": 2,
    "private": false,
    "styles": [
      "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
      "color:red;background:url('http://example.com/test')"
    ],
    "timeStamp": 1491902018683,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set("console.groupEnd(%cfoo%cbaz)", {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "groupEnd",
    "lineNumber": 6,
    "private": false,
    "styles": [],
    "timeStamp": 1491902018685,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

module.exports = {
  stubPreparedMessages,
  stubPackets,
};
