// Copyright 2017 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=SignWriting`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v9.0.0
  Emoji v5.0 (UTR51)
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x01D800, 0x01DA8B],
    [0x01DA9B, 0x01DA9F],
    [0x01DAA1, 0x01DAAF]
  ]
});
testPropertyEscapes(
  /^\p{Script=SignWriting}+$/u,
  matchSymbols,
  "\\p{Script=SignWriting}"
);
testPropertyEscapes(
  /^\p{Script=Sgnw}+$/u,
  matchSymbols,
  "\\p{Script=Sgnw}"
);
testPropertyEscapes(
  /^\p{sc=SignWriting}+$/u,
  matchSymbols,
  "\\p{sc=SignWriting}"
);
testPropertyEscapes(
  /^\p{sc=Sgnw}+$/u,
  matchSymbols,
  "\\p{sc=Sgnw}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [
    0x01DAA0
  ],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x01D7FF],
    [0x01DA8C, 0x01DA9A],
    [0x01DAB0, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=SignWriting}+$/u,
  nonMatchSymbols,
  "\\P{Script=SignWriting}"
);
testPropertyEscapes(
  /^\P{Script=Sgnw}+$/u,
  nonMatchSymbols,
  "\\P{Script=Sgnw}"
);
testPropertyEscapes(
  /^\P{sc=SignWriting}+$/u,
  nonMatchSymbols,
  "\\P{sc=SignWriting}"
);
testPropertyEscapes(
  /^\P{sc=Sgnw}+$/u,
  nonMatchSymbols,
  "\\P{sc=Sgnw}"
);

reportCompare(0, 0);
