// |reftest| skip-if(!this.hasOwnProperty('BigInt')) -- BigInt is not enabled unconditionally
// Copyright (C) 2017 Robin Templeton. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-addition-operator-plus-runtime-semantics-evaluation
description: BigInt addition arithmetic
features: [BigInt]
---*/

function testAdd(x, y, z) {
    assert.sameValue(x + y, z, x + " + " + y + " = " + z);
    assert.sameValue(y + x, z, y + " + " + x + " = " + z);
}

testAdd(0xFEDCBA9876543210n, 0xFEDCBA9876543210n, 0x1FDB97530ECA86420n);
testAdd(0xFEDCBA9876543210n, 0xFEDCBA987654320Fn, 0x1FDB97530ECA8641Fn);
testAdd(0xFEDCBA9876543210n, 0xFEDCBA98n, 0xFEDCBA997530ECA8n);
testAdd(0xFEDCBA9876543210n, 0xFEDCBA97n, 0xFEDCBA997530ECA7n);
testAdd(0xFEDCBA9876543210n, 0x1234n, 0xFEDCBA9876544444n);
testAdd(0xFEDCBA9876543210n, 0x3n, 0xFEDCBA9876543213n);
testAdd(0xFEDCBA9876543210n, 0x2n, 0xFEDCBA9876543212n);
testAdd(0xFEDCBA9876543210n, 0x1n, 0xFEDCBA9876543211n);
testAdd(0xFEDCBA9876543210n, 0x0n, 0xFEDCBA9876543210n);
testAdd(0xFEDCBA9876543210n, -0x1n, 0xFEDCBA987654320Fn);
testAdd(0xFEDCBA9876543210n, -0x2n, 0xFEDCBA987654320En);
testAdd(0xFEDCBA9876543210n, -0x3n, 0xFEDCBA987654320Dn);
testAdd(0xFEDCBA9876543210n, -0x1234n, 0xFEDCBA9876541FDCn);
testAdd(0xFEDCBA9876543210n, -0xFEDCBA97n, 0xFEDCBA9777777779n);
testAdd(0xFEDCBA9876543210n, -0xFEDCBA98n, 0xFEDCBA9777777778n);
testAdd(0xFEDCBA9876543210n, -0xFEDCBA987654320Fn, 0x1n);
testAdd(0xFEDCBA9876543210n, -0xFEDCBA9876543210n, 0x0n);
testAdd(0xFEDCBA987654320Fn, 0xFEDCBA987654320Fn, 0x1FDB97530ECA8641En);
testAdd(0xFEDCBA987654320Fn, 0xFEDCBA98n, 0xFEDCBA997530ECA7n);
testAdd(0xFEDCBA987654320Fn, 0xFEDCBA97n, 0xFEDCBA997530ECA6n);
testAdd(0xFEDCBA987654320Fn, 0x1234n, 0xFEDCBA9876544443n);
testAdd(0xFEDCBA987654320Fn, 0x3n, 0xFEDCBA9876543212n);
testAdd(0xFEDCBA987654320Fn, 0x2n, 0xFEDCBA9876543211n);
testAdd(0xFEDCBA987654320Fn, 0x1n, 0xFEDCBA9876543210n);
testAdd(0xFEDCBA987654320Fn, 0x0n, 0xFEDCBA987654320Fn);
testAdd(0xFEDCBA987654320Fn, -0x1n, 0xFEDCBA987654320En);
testAdd(0xFEDCBA987654320Fn, -0x2n, 0xFEDCBA987654320Dn);
testAdd(0xFEDCBA987654320Fn, -0x3n, 0xFEDCBA987654320Cn);
testAdd(0xFEDCBA987654320Fn, -0x1234n, 0xFEDCBA9876541FDBn);
testAdd(0xFEDCBA987654320Fn, -0xFEDCBA97n, 0xFEDCBA9777777778n);
testAdd(0xFEDCBA987654320Fn, -0xFEDCBA98n, 0xFEDCBA9777777777n);
testAdd(0xFEDCBA987654320Fn, -0xFEDCBA987654320Fn, 0x0n);
testAdd(0xFEDCBA987654320Fn, -0xFEDCBA9876543210n, -0x1n);
testAdd(0xFEDCBA98n, 0xFEDCBA98n, 0x1FDB97530n);
testAdd(0xFEDCBA98n, 0xFEDCBA97n, 0x1FDB9752Fn);
testAdd(0xFEDCBA98n, 0x1234n, 0xFEDCCCCCn);
testAdd(0xFEDCBA98n, 0x3n, 0xFEDCBA9Bn);
testAdd(0xFEDCBA98n, 0x2n, 0xFEDCBA9An);
testAdd(0xFEDCBA98n, 0x1n, 0xFEDCBA99n);
testAdd(0xFEDCBA98n, 0x0n, 0xFEDCBA98n);
testAdd(0xFEDCBA98n, -0x1n, 0xFEDCBA97n);
testAdd(0xFEDCBA98n, -0x2n, 0xFEDCBA96n);
testAdd(0xFEDCBA98n, -0x3n, 0xFEDCBA95n);
testAdd(0xFEDCBA98n, -0x1234n, 0xFEDCA864n);
testAdd(0xFEDCBA98n, -0xFEDCBA97n, 0x1n);
testAdd(0xFEDCBA98n, -0xFEDCBA98n, 0x0n);
testAdd(0xFEDCBA98n, -0xFEDCBA987654320Fn, -0xFEDCBA9777777777n);
testAdd(0xFEDCBA98n, -0xFEDCBA9876543210n, -0xFEDCBA9777777778n);
testAdd(0xFEDCBA97n, 0xFEDCBA97n, 0x1FDB9752En);
testAdd(0xFEDCBA97n, 0x1234n, 0xFEDCCCCBn);
testAdd(0xFEDCBA97n, 0x3n, 0xFEDCBA9An);
testAdd(0xFEDCBA97n, 0x2n, 0xFEDCBA99n);
testAdd(0xFEDCBA97n, 0x1n, 0xFEDCBA98n);
testAdd(0xFEDCBA97n, 0x0n, 0xFEDCBA97n);
testAdd(0xFEDCBA97n, -0x1n, 0xFEDCBA96n);
testAdd(0xFEDCBA97n, -0x2n, 0xFEDCBA95n);
testAdd(0xFEDCBA97n, -0x3n, 0xFEDCBA94n);
testAdd(0xFEDCBA97n, -0x1234n, 0xFEDCA863n);
testAdd(0xFEDCBA97n, -0xFEDCBA97n, 0x0n);
testAdd(0xFEDCBA97n, -0xFEDCBA98n, -0x1n);
testAdd(0xFEDCBA97n, -0xFEDCBA987654320Fn, -0xFEDCBA9777777778n);
testAdd(0xFEDCBA97n, -0xFEDCBA9876543210n, -0xFEDCBA9777777779n);
testAdd(0x1234n, 0x1234n, 0x2468n);
testAdd(0x1234n, 0x3n, 0x1237n);
testAdd(0x1234n, 0x2n, 0x1236n);
testAdd(0x1234n, 0x1n, 0x1235n);
testAdd(0x1234n, 0x0n, 0x1234n);
testAdd(0x1234n, -0x1n, 0x1233n);
testAdd(0x1234n, -0x2n, 0x1232n);
testAdd(0x1234n, -0x3n, 0x1231n);
testAdd(0x1234n, -0x1234n, 0x0n);
testAdd(0x1234n, -0xFEDCBA97n, -0xFEDCA863n);
testAdd(0x1234n, -0xFEDCBA98n, -0xFEDCA864n);
testAdd(0x1234n, -0xFEDCBA987654320Fn, -0xFEDCBA9876541FDBn);
testAdd(0x1234n, -0xFEDCBA9876543210n, -0xFEDCBA9876541FDCn);
testAdd(0x3n, 0x3n, 0x6n);
testAdd(0x3n, 0x2n, 0x5n);
testAdd(0x3n, 0x1n, 0x4n);
testAdd(0x3n, 0x0n, 0x3n);
testAdd(0x3n, -0x1n, 0x2n);
testAdd(0x3n, -0x2n, 0x1n);
testAdd(0x3n, -0x3n, 0x0n);
testAdd(0x3n, -0x1234n, -0x1231n);
testAdd(0x3n, -0xFEDCBA97n, -0xFEDCBA94n);
testAdd(0x3n, -0xFEDCBA98n, -0xFEDCBA95n);
testAdd(0x3n, -0xFEDCBA987654320Fn, -0xFEDCBA987654320Cn);
testAdd(0x3n, -0xFEDCBA9876543210n, -0xFEDCBA987654320Dn);
testAdd(0x2n, 0x2n, 0x4n);
testAdd(0x2n, 0x1n, 0x3n);
testAdd(0x2n, 0x0n, 0x2n);
testAdd(0x2n, -0x1n, 0x1n);
testAdd(0x2n, -0x2n, 0x0n);
testAdd(0x2n, -0x3n, -0x1n);
testAdd(0x2n, -0x1234n, -0x1232n);
testAdd(0x2n, -0xFEDCBA97n, -0xFEDCBA95n);
testAdd(0x2n, -0xFEDCBA98n, -0xFEDCBA96n);
testAdd(0x2n, -0xFEDCBA987654320Fn, -0xFEDCBA987654320Dn);
testAdd(0x2n, -0xFEDCBA9876543210n, -0xFEDCBA987654320En);
testAdd(0x1n, 0x1n, 0x2n);
testAdd(0x1n, 0x0n, 0x1n);
testAdd(0x1n, -0x1n, 0x0n);
testAdd(0x1n, -0x2n, -0x1n);
testAdd(0x1n, -0x3n, -0x2n);
testAdd(0x1n, -0x1234n, -0x1233n);
testAdd(0x1n, -0xFEDCBA97n, -0xFEDCBA96n);
testAdd(0x1n, -0xFEDCBA98n, -0xFEDCBA97n);
testAdd(0x1n, -0xFEDCBA987654320Fn, -0xFEDCBA987654320En);
testAdd(0x1n, -0xFEDCBA9876543210n, -0xFEDCBA987654320Fn);
testAdd(0x0n, 0x0n, 0x0n);
testAdd(0x0n, -0x1n, -0x1n);
testAdd(0x0n, -0x2n, -0x2n);
testAdd(0x0n, -0x3n, -0x3n);
testAdd(0x0n, -0x1234n, -0x1234n);
testAdd(0x0n, -0xFEDCBA97n, -0xFEDCBA97n);
testAdd(0x0n, -0xFEDCBA98n, -0xFEDCBA98n);
testAdd(0x0n, -0xFEDCBA987654320Fn, -0xFEDCBA987654320Fn);
testAdd(0x0n, -0xFEDCBA9876543210n, -0xFEDCBA9876543210n);
testAdd(-0x1n, -0x1n, -0x2n);
testAdd(-0x1n, -0x2n, -0x3n);
testAdd(-0x1n, -0x3n, -0x4n);
testAdd(-0x1n, -0x1234n, -0x1235n);
testAdd(-0x1n, -0xFEDCBA97n, -0xFEDCBA98n);
testAdd(-0x1n, -0xFEDCBA98n, -0xFEDCBA99n);
testAdd(-0x1n, -0xFEDCBA987654320Fn, -0xFEDCBA9876543210n);
testAdd(-0x1n, -0xFEDCBA9876543210n, -0xFEDCBA9876543211n);
testAdd(-0x2n, -0x2n, -0x4n);
testAdd(-0x2n, -0x3n, -0x5n);
testAdd(-0x2n, -0x1234n, -0x1236n);
testAdd(-0x2n, -0xFEDCBA97n, -0xFEDCBA99n);
testAdd(-0x2n, -0xFEDCBA98n, -0xFEDCBA9An);
testAdd(-0x2n, -0xFEDCBA987654320Fn, -0xFEDCBA9876543211n);
testAdd(-0x2n, -0xFEDCBA9876543210n, -0xFEDCBA9876543212n);
testAdd(-0x3n, -0x3n, -0x6n);
testAdd(-0x3n, -0x1234n, -0x1237n);
testAdd(-0x3n, -0xFEDCBA97n, -0xFEDCBA9An);
testAdd(-0x3n, -0xFEDCBA98n, -0xFEDCBA9Bn);
testAdd(-0x3n, -0xFEDCBA987654320Fn, -0xFEDCBA9876543212n);
testAdd(-0x3n, -0xFEDCBA9876543210n, -0xFEDCBA9876543213n);
testAdd(-0x1234n, -0x1234n, -0x2468n);
testAdd(-0x1234n, -0xFEDCBA97n, -0xFEDCCCCBn);
testAdd(-0x1234n, -0xFEDCBA98n, -0xFEDCCCCCn);
testAdd(-0x1234n, -0xFEDCBA987654320Fn, -0xFEDCBA9876544443n);
testAdd(-0x1234n, -0xFEDCBA9876543210n, -0xFEDCBA9876544444n);
testAdd(-0xFEDCBA97n, -0xFEDCBA97n, -0x1FDB9752En);
testAdd(-0xFEDCBA97n, -0xFEDCBA98n, -0x1FDB9752Fn);
testAdd(-0xFEDCBA97n, -0xFEDCBA987654320Fn, -0xFEDCBA997530ECA6n);
testAdd(-0xFEDCBA97n, -0xFEDCBA9876543210n, -0xFEDCBA997530ECA7n);
testAdd(-0xFEDCBA98n, -0xFEDCBA98n, -0x1FDB97530n);
testAdd(-0xFEDCBA98n, -0xFEDCBA987654320Fn, -0xFEDCBA997530ECA7n);
testAdd(-0xFEDCBA98n, -0xFEDCBA9876543210n, -0xFEDCBA997530ECA8n);
testAdd(-0xFEDCBA987654320Fn, -0xFEDCBA987654320Fn, -0x1FDB97530ECA8641En);
testAdd(-0xFEDCBA987654320Fn, -0xFEDCBA9876543210n, -0x1FDB97530ECA8641Fn);
testAdd(-0xFEDCBA9876543210n, -0xFEDCBA9876543210n, -0x1FDB97530ECA86420n);

reportCompare(0, 0);
