// |reftest| skip-if(!this.hasOwnProperty('BigInt')) -- BigInt is not enabled unconditionally
// Copyright (C) 2017 Robin Templeton. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-multiplicative-operators-runtime-semantics-evaluation
description: BigInt remainder arithmetic
features: [BigInt]
---*/

function testMod(x, y, z) {
    assert.sameValue(x % y, z, x + " % " + y + " = " + z);
}

testMod(0xFEDCBA9876543210n, 0xFEDCBA9876543210n, 0x0n);
testMod(0xFEDCBA9876543210n, 0xFEDCBA987654320Fn, 0x1n);
testMod(0xFEDCBA9876543210n, 0xFEDCBA98n, 0x76543210n);
testMod(0xFEDCBA9876543210n, 0xFEDCBA97n, 0x77777779n);
testMod(0xFEDCBA9876543210n, 0x1234n, 0x960n);
testMod(0xFEDCBA9876543210n, 0x3n, 0x0n);
testMod(0xFEDCBA9876543210n, 0x2n, 0x0n);
testMod(0xFEDCBA9876543210n, 0x1n, 0x0n);
testMod(0xFEDCBA9876543210n, -0x1n, 0x0n);
testMod(0xFEDCBA9876543210n, -0x2n, 0x0n);
testMod(0xFEDCBA9876543210n, -0x3n, 0x0n);
testMod(0xFEDCBA9876543210n, -0x1234n, 0x960n);
testMod(0xFEDCBA9876543210n, -0xFEDCBA97n, 0x77777779n);
testMod(0xFEDCBA9876543210n, -0xFEDCBA98n, 0x76543210n);
testMod(0xFEDCBA9876543210n, -0xFEDCBA987654320Fn, 0x1n);
testMod(0xFEDCBA9876543210n, -0xFEDCBA9876543210n, 0x0n);
testMod(0xFEDCBA987654320Fn, 0xFEDCBA9876543210n, 0xFEDCBA987654320Fn);
testMod(0xFEDCBA987654320Fn, 0xFEDCBA987654320Fn, 0x0n);
testMod(0xFEDCBA987654320Fn, 0xFEDCBA98n, 0x7654320Fn);
testMod(0xFEDCBA987654320Fn, 0xFEDCBA97n, 0x77777778n);
testMod(0xFEDCBA987654320Fn, 0x1234n, 0x95Fn);
testMod(0xFEDCBA987654320Fn, 0x3n, 0x2n);
testMod(0xFEDCBA987654320Fn, 0x2n, 0x1n);
testMod(0xFEDCBA987654320Fn, 0x1n, 0x0n);
testMod(0xFEDCBA987654320Fn, -0x1n, 0x0n);
testMod(0xFEDCBA987654320Fn, -0x2n, 0x1n);
testMod(0xFEDCBA987654320Fn, -0x3n, 0x2n);
testMod(0xFEDCBA987654320Fn, -0x1234n, 0x95Fn);
testMod(0xFEDCBA987654320Fn, -0xFEDCBA97n, 0x77777778n);
testMod(0xFEDCBA987654320Fn, -0xFEDCBA98n, 0x7654320Fn);
testMod(0xFEDCBA987654320Fn, -0xFEDCBA987654320Fn, 0x0n);
testMod(0xFEDCBA987654320Fn, -0xFEDCBA9876543210n, 0xFEDCBA987654320Fn);
testMod(0xFEDCBA98n, 0xFEDCBA9876543210n, 0xFEDCBA98n);
testMod(0xFEDCBA98n, 0xFEDCBA987654320Fn, 0xFEDCBA98n);
testMod(0xFEDCBA98n, 0xFEDCBA98n, 0x0n);
testMod(0xFEDCBA98n, 0xFEDCBA97n, 0x1n);
testMod(0xFEDCBA98n, 0x1234n, 0x930n);
testMod(0xFEDCBA98n, 0x3n, 0x2n);
testMod(0xFEDCBA98n, 0x2n, 0x0n);
testMod(0xFEDCBA98n, 0x1n, 0x0n);
testMod(0xFEDCBA98n, -0x1n, 0x0n);
testMod(0xFEDCBA98n, -0x2n, 0x0n);
testMod(0xFEDCBA98n, -0x3n, 0x2n);
testMod(0xFEDCBA98n, -0x1234n, 0x930n);
testMod(0xFEDCBA98n, -0xFEDCBA97n, 0x1n);
testMod(0xFEDCBA98n, -0xFEDCBA98n, 0x0n);
testMod(0xFEDCBA98n, -0xFEDCBA987654320Fn, 0xFEDCBA98n);
testMod(0xFEDCBA98n, -0xFEDCBA9876543210n, 0xFEDCBA98n);
testMod(0xFEDCBA97n, 0xFEDCBA9876543210n, 0xFEDCBA97n);
testMod(0xFEDCBA97n, 0xFEDCBA987654320Fn, 0xFEDCBA97n);
testMod(0xFEDCBA97n, 0xFEDCBA98n, 0xFEDCBA97n);
testMod(0xFEDCBA97n, 0xFEDCBA97n, 0x0n);
testMod(0xFEDCBA97n, 0x1234n, 0x92Fn);
testMod(0xFEDCBA97n, 0x3n, 0x1n);
testMod(0xFEDCBA97n, 0x2n, 0x1n);
testMod(0xFEDCBA97n, 0x1n, 0x0n);
testMod(0xFEDCBA97n, -0x1n, 0x0n);
testMod(0xFEDCBA97n, -0x2n, 0x1n);
testMod(0xFEDCBA97n, -0x3n, 0x1n);
testMod(0xFEDCBA97n, -0x1234n, 0x92Fn);
testMod(0xFEDCBA97n, -0xFEDCBA97n, 0x0n);
testMod(0xFEDCBA97n, -0xFEDCBA98n, 0xFEDCBA97n);
testMod(0xFEDCBA97n, -0xFEDCBA987654320Fn, 0xFEDCBA97n);
testMod(0xFEDCBA97n, -0xFEDCBA9876543210n, 0xFEDCBA97n);
testMod(0x1234n, 0xFEDCBA9876543210n, 0x1234n);
testMod(0x1234n, 0xFEDCBA987654320Fn, 0x1234n);
testMod(0x1234n, 0xFEDCBA98n, 0x1234n);
testMod(0x1234n, 0xFEDCBA97n, 0x1234n);
testMod(0x1234n, 0x1234n, 0x0n);
testMod(0x1234n, 0x3n, 0x1n);
testMod(0x1234n, 0x2n, 0x0n);
testMod(0x1234n, 0x1n, 0x0n);
testMod(0x1234n, -0x1n, 0x0n);
testMod(0x1234n, -0x2n, 0x0n);
testMod(0x1234n, -0x3n, 0x1n);
testMod(0x1234n, -0x1234n, 0x0n);
testMod(0x1234n, -0xFEDCBA97n, 0x1234n);
testMod(0x1234n, -0xFEDCBA98n, 0x1234n);
testMod(0x1234n, -0xFEDCBA987654320Fn, 0x1234n);
testMod(0x1234n, -0xFEDCBA9876543210n, 0x1234n);
testMod(0x3n, 0xFEDCBA9876543210n, 0x3n);
testMod(0x3n, 0xFEDCBA987654320Fn, 0x3n);
testMod(0x3n, 0xFEDCBA98n, 0x3n);
testMod(0x3n, 0xFEDCBA97n, 0x3n);
testMod(0x3n, 0x1234n, 0x3n);
testMod(0x3n, 0x3n, 0x0n);
testMod(0x3n, 0x2n, 0x1n);
testMod(0x3n, 0x1n, 0x0n);
testMod(0x3n, -0x1n, 0x0n);
testMod(0x3n, -0x2n, 0x1n);
testMod(0x3n, -0x3n, 0x0n);
testMod(0x3n, -0x1234n, 0x3n);
testMod(0x3n, -0xFEDCBA97n, 0x3n);
testMod(0x3n, -0xFEDCBA98n, 0x3n);
testMod(0x3n, -0xFEDCBA987654320Fn, 0x3n);
testMod(0x3n, -0xFEDCBA9876543210n, 0x3n);
testMod(0x2n, 0xFEDCBA9876543210n, 0x2n);
testMod(0x2n, 0xFEDCBA987654320Fn, 0x2n);
testMod(0x2n, 0xFEDCBA98n, 0x2n);
testMod(0x2n, 0xFEDCBA97n, 0x2n);
testMod(0x2n, 0x1234n, 0x2n);
testMod(0x2n, 0x3n, 0x2n);
testMod(0x2n, 0x2n, 0x0n);
testMod(0x2n, 0x1n, 0x0n);
testMod(0x2n, -0x1n, 0x0n);
testMod(0x2n, -0x2n, 0x0n);
testMod(0x2n, -0x3n, 0x2n);
testMod(0x2n, -0x1234n, 0x2n);
testMod(0x2n, -0xFEDCBA97n, 0x2n);
testMod(0x2n, -0xFEDCBA98n, 0x2n);
testMod(0x2n, -0xFEDCBA987654320Fn, 0x2n);
testMod(0x2n, -0xFEDCBA9876543210n, 0x2n);
testMod(0x1n, 0xFEDCBA9876543210n, 0x1n);
testMod(0x1n, 0xFEDCBA987654320Fn, 0x1n);
testMod(0x1n, 0xFEDCBA98n, 0x1n);
testMod(0x1n, 0xFEDCBA97n, 0x1n);
testMod(0x1n, 0x1234n, 0x1n);
testMod(0x1n, 0x3n, 0x1n);
testMod(0x1n, 0x2n, 0x1n);
testMod(0x1n, 0x1n, 0x0n);
testMod(0x1n, -0x1n, 0x0n);
testMod(0x1n, -0x2n, 0x1n);
testMod(0x1n, -0x3n, 0x1n);
testMod(0x1n, -0x1234n, 0x1n);
testMod(0x1n, -0xFEDCBA97n, 0x1n);
testMod(0x1n, -0xFEDCBA98n, 0x1n);
testMod(0x1n, -0xFEDCBA987654320Fn, 0x1n);
testMod(0x1n, -0xFEDCBA9876543210n, 0x1n);
testMod(-0x1n, 0xFEDCBA9876543210n, -0x1n);
testMod(-0x1n, 0xFEDCBA987654320Fn, -0x1n);
testMod(-0x1n, 0xFEDCBA98n, -0x1n);
testMod(-0x1n, 0xFEDCBA97n, -0x1n);
testMod(-0x1n, 0x1234n, -0x1n);
testMod(-0x1n, 0x3n, -0x1n);
testMod(-0x1n, 0x2n, -0x1n);
testMod(-0x1n, 0x1n, 0x0n);
testMod(-0x1n, -0x1n, 0x0n);
testMod(-0x1n, -0x2n, -0x1n);
testMod(-0x1n, -0x3n, -0x1n);
testMod(-0x1n, -0x1234n, -0x1n);
testMod(-0x1n, -0xFEDCBA97n, -0x1n);
testMod(-0x1n, -0xFEDCBA98n, -0x1n);
testMod(-0x1n, -0xFEDCBA987654320Fn, -0x1n);
testMod(-0x1n, -0xFEDCBA9876543210n, -0x1n);
testMod(-0x2n, 0xFEDCBA9876543210n, -0x2n);
testMod(-0x2n, 0xFEDCBA987654320Fn, -0x2n);
testMod(-0x2n, 0xFEDCBA98n, -0x2n);
testMod(-0x2n, 0xFEDCBA97n, -0x2n);
testMod(-0x2n, 0x1234n, -0x2n);
testMod(-0x2n, 0x3n, -0x2n);
testMod(-0x2n, 0x2n, 0x0n);
testMod(-0x2n, 0x1n, 0x0n);
testMod(-0x2n, -0x1n, 0x0n);
testMod(-0x2n, -0x2n, 0x0n);
testMod(-0x2n, -0x3n, -0x2n);
testMod(-0x2n, -0x1234n, -0x2n);
testMod(-0x2n, -0xFEDCBA97n, -0x2n);
testMod(-0x2n, -0xFEDCBA98n, -0x2n);
testMod(-0x2n, -0xFEDCBA987654320Fn, -0x2n);
testMod(-0x2n, -0xFEDCBA9876543210n, -0x2n);
testMod(-0x3n, 0xFEDCBA9876543210n, -0x3n);
testMod(-0x3n, 0xFEDCBA987654320Fn, -0x3n);
testMod(-0x3n, 0xFEDCBA98n, -0x3n);
testMod(-0x3n, 0xFEDCBA97n, -0x3n);
testMod(-0x3n, 0x1234n, -0x3n);
testMod(-0x3n, 0x3n, 0x0n);
testMod(-0x3n, 0x2n, -0x1n);
testMod(-0x3n, 0x1n, 0x0n);
testMod(-0x3n, -0x1n, 0x0n);
testMod(-0x3n, -0x2n, -0x1n);
testMod(-0x3n, -0x3n, 0x0n);
testMod(-0x3n, -0x1234n, -0x3n);
testMod(-0x3n, -0xFEDCBA97n, -0x3n);
testMod(-0x3n, -0xFEDCBA98n, -0x3n);
testMod(-0x3n, -0xFEDCBA987654320Fn, -0x3n);
testMod(-0x3n, -0xFEDCBA9876543210n, -0x3n);
testMod(-0x1234n, 0xFEDCBA9876543210n, -0x1234n);
testMod(-0x1234n, 0xFEDCBA987654320Fn, -0x1234n);
testMod(-0x1234n, 0xFEDCBA98n, -0x1234n);
testMod(-0x1234n, 0xFEDCBA97n, -0x1234n);
testMod(-0x1234n, 0x1234n, 0x0n);
testMod(-0x1234n, 0x3n, -0x1n);
testMod(-0x1234n, 0x2n, 0x0n);
testMod(-0x1234n, 0x1n, 0x0n);
testMod(-0x1234n, -0x1n, 0x0n);
testMod(-0x1234n, -0x2n, 0x0n);
testMod(-0x1234n, -0x3n, -0x1n);
testMod(-0x1234n, -0x1234n, 0x0n);
testMod(-0x1234n, -0xFEDCBA97n, -0x1234n);
testMod(-0x1234n, -0xFEDCBA98n, -0x1234n);
testMod(-0x1234n, -0xFEDCBA987654320Fn, -0x1234n);
testMod(-0x1234n, -0xFEDCBA9876543210n, -0x1234n);
testMod(-0xFEDCBA97n, 0xFEDCBA9876543210n, -0xFEDCBA97n);
testMod(-0xFEDCBA97n, 0xFEDCBA987654320Fn, -0xFEDCBA97n);
testMod(-0xFEDCBA97n, 0xFEDCBA98n, -0xFEDCBA97n);
testMod(-0xFEDCBA97n, 0xFEDCBA97n, 0x0n);
testMod(-0xFEDCBA97n, 0x1234n, -0x92Fn);
testMod(-0xFEDCBA97n, 0x3n, -0x1n);
testMod(-0xFEDCBA97n, 0x2n, -0x1n);
testMod(-0xFEDCBA97n, 0x1n, 0x0n);
testMod(-0xFEDCBA97n, -0x1n, 0x0n);
testMod(-0xFEDCBA97n, -0x2n, -0x1n);
testMod(-0xFEDCBA97n, -0x3n, -0x1n);
testMod(-0xFEDCBA97n, -0x1234n, -0x92Fn);
testMod(-0xFEDCBA97n, -0xFEDCBA97n, 0x0n);
testMod(-0xFEDCBA97n, -0xFEDCBA98n, -0xFEDCBA97n);
testMod(-0xFEDCBA97n, -0xFEDCBA987654320Fn, -0xFEDCBA97n);
testMod(-0xFEDCBA97n, -0xFEDCBA9876543210n, -0xFEDCBA97n);
testMod(-0xFEDCBA98n, 0xFEDCBA9876543210n, -0xFEDCBA98n);
testMod(-0xFEDCBA98n, 0xFEDCBA987654320Fn, -0xFEDCBA98n);
testMod(-0xFEDCBA98n, 0xFEDCBA98n, 0x0n);
testMod(-0xFEDCBA98n, 0xFEDCBA97n, -0x1n);
testMod(-0xFEDCBA98n, 0x1234n, -0x930n);
testMod(-0xFEDCBA98n, 0x3n, -0x2n);
testMod(-0xFEDCBA98n, 0x2n, 0x0n);
testMod(-0xFEDCBA98n, 0x1n, 0x0n);
testMod(-0xFEDCBA98n, -0x1n, 0x0n);
testMod(-0xFEDCBA98n, -0x2n, 0x0n);
testMod(-0xFEDCBA98n, -0x3n, -0x2n);
testMod(-0xFEDCBA98n, -0x1234n, -0x930n);
testMod(-0xFEDCBA98n, -0xFEDCBA97n, -0x1n);
testMod(-0xFEDCBA98n, -0xFEDCBA98n, 0x0n);
testMod(-0xFEDCBA98n, -0xFEDCBA987654320Fn, -0xFEDCBA98n);
testMod(-0xFEDCBA98n, -0xFEDCBA9876543210n, -0xFEDCBA98n);
testMod(-0xFEDCBA987654320Fn, 0xFEDCBA9876543210n, -0xFEDCBA987654320Fn);
testMod(-0xFEDCBA987654320Fn, 0xFEDCBA987654320Fn, 0x0n);
testMod(-0xFEDCBA987654320Fn, 0xFEDCBA98n, -0x7654320Fn);
testMod(-0xFEDCBA987654320Fn, 0xFEDCBA97n, -0x77777778n);
testMod(-0xFEDCBA987654320Fn, 0x1234n, -0x95Fn);
testMod(-0xFEDCBA987654320Fn, 0x3n, -0x2n);
testMod(-0xFEDCBA987654320Fn, 0x2n, -0x1n);
testMod(-0xFEDCBA987654320Fn, 0x1n, 0x0n);
testMod(-0xFEDCBA987654320Fn, -0x1n, 0x0n);
testMod(-0xFEDCBA987654320Fn, -0x2n, -0x1n);
testMod(-0xFEDCBA987654320Fn, -0x3n, -0x2n);
testMod(-0xFEDCBA987654320Fn, -0x1234n, -0x95Fn);
testMod(-0xFEDCBA987654320Fn, -0xFEDCBA97n, -0x77777778n);
testMod(-0xFEDCBA987654320Fn, -0xFEDCBA98n, -0x7654320Fn);
testMod(-0xFEDCBA987654320Fn, -0xFEDCBA987654320Fn, 0x0n);
testMod(-0xFEDCBA987654320Fn, -0xFEDCBA9876543210n, -0xFEDCBA987654320Fn);
testMod(-0xFEDCBA9876543210n, 0xFEDCBA9876543210n, 0x0n);
testMod(-0xFEDCBA9876543210n, 0xFEDCBA987654320Fn, -0x1n);
testMod(-0xFEDCBA9876543210n, 0xFEDCBA98n, -0x76543210n);
testMod(-0xFEDCBA9876543210n, 0xFEDCBA97n, -0x77777779n);
testMod(-0xFEDCBA9876543210n, 0x1234n, -0x960n);
testMod(-0xFEDCBA9876543210n, 0x3n, 0x0n);
testMod(-0xFEDCBA9876543210n, 0x2n, 0x0n);
testMod(-0xFEDCBA9876543210n, 0x1n, 0x0n);
testMod(-0xFEDCBA9876543210n, -0x1n, 0x0n);
testMod(-0xFEDCBA9876543210n, -0x2n, 0x0n);
testMod(-0xFEDCBA9876543210n, -0x3n, 0x0n);
testMod(-0xFEDCBA9876543210n, -0x1234n, -0x960n);
testMod(-0xFEDCBA9876543210n, -0xFEDCBA97n, -0x77777779n);
testMod(-0xFEDCBA9876543210n, -0xFEDCBA98n, -0x76543210n);
testMod(-0xFEDCBA9876543210n, -0xFEDCBA987654320Fn, -0x1n);
testMod(-0xFEDCBA9876543210n, -0xFEDCBA9876543210n, 0x0n);

reportCompare(0, 0);
