/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_dom_CSSMozDocumentRule_h
#define mozilla_dom_CSSMozDocumentRule_h

#include "mozilla/css/GroupRule.h"
#include "mozilla/css/URLMatchingFunction.h"
#include "mozilla/ServoBindingTypes.h"

namespace mozilla {
namespace dom {

class CSSMozDocumentRule final : public css::ConditionRule
{
public:
  CSSMozDocumentRule(RefPtr<RawServoMozDocumentRule> aRawRule,
                     uint32_t aLine, uint32_t aColumn);

  NS_DECL_ISUPPORTS_INHERITED

  static bool Match(nsIDocument* aDoc,
                    nsIURI* aDocURI,
                    const nsACString& aDocURISpec,
                    const nsACString& aPattern,
                    css::URLMatchingFunction aUrlMatchingFunction);

#ifdef DEBUG
  void List(FILE* out = stdout, int32_t aIndent = 0) const final;
#endif

  RawServoMozDocumentRule* Raw() const { return mRawRule; }

  // WebIDL interface
  uint16_t Type() const final { return CSSRule_Binding::DOCUMENT_RULE; }
  void GetCssText(nsAString& aCssText) const final;
  void GetConditionText(nsAString& aConditionText) final;
  void SetConditionText(const nsAString& aConditionText,
                        ErrorResult& aRv) final;

  size_t SizeOfIncludingThis(mozilla::MallocSizeOf aMallocSizeOf)
    const override;

  JSObject* WrapObject(JSContext* aCx,
                       JS::Handle<JSObject*> aGivenProto) override;

private:
  ~CSSMozDocumentRule() = default;

  RefPtr<RawServoMozDocumentRule> mRawRule;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_CSSMozDocumentRule_h
