# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.

import runpy

def generate(output, dataFile):
    output.write("""/* THIS IS AN AUTOGENERATED FILE.  DO NOT EDIT */

/* processed file that defines entries for nsComputedDOMStyle, designed
   to be #included in nsComputedDOMStyle.cpp */

static constexpr Entry kEntries[] = {
""")

    def exposed_on_getcs(p):
        return "ExposedOnGetCS" in p.flags

    def order_key(p):
        # Put prefixed properties after normal properties.
        # The spec is unclear about this, and Blink doesn't have any sensible
        # order at all, so it probably doesn't matter a lot. But originally
        # Gecko put then later so we do so as well. See w3c/csswg-drafts#2827.
        order = p.name.startswith("-")
        return (order, p.name)

    def has_cpp_getter(p):
        if "SerializedByServo" in p.flags:
            return False
        if p.type() == "longhand" and "IsLogical" in p.flags:
            return False
        return True

    # Some special cases we may get rid of later. See bug 1471423.
    def method(p):
        if p.id.startswith("margin_"):
            return "{}Width".format(p.method)
        if p.id.startswith("_moz_"):
            method = p.method[3:]
        else:
            method = p.method
        if p.id.startswith("_moz_outline_radius_"):
            method = method.replace("left", "Left")
            method = method.replace("right", "Right")
        return method

    def getter_entry(p):
        if has_cpp_getter(p):
            return "DoGet" + method(p)
        # Put a dummy getter here instead of nullptr because MSVC seems
        # to have bug which ruins the table when we put nullptr for
        # pointer-to-member-function. See bug 1471426.
        return "DummyGetter"

    properties = runpy.run_path(dataFile)["data"]
    properties = filter(exposed_on_getcs, properties)
    properties.sort(key=order_key)

    TEMPLATE = "  {{ eCSSProperty_{}, &nsComputedDOMStyle::{} }},\n"
    for p in properties:
        output.write(TEMPLATE.format(p.id, getter_entry(p)))

    output.write("};\n")
