
var _elementIDs = ["advancedJavaAllow", "enableSoftwareInstall", 
                   "enableJavaScript", "enableImagePref",
                   "popupPolicy", "allowWindowMoveResize", 
                   "allowWindowFlip", "allowControlContextMenu", 
                   "allowHideStatusBar", "allowWindowStatusChange", 
                   "allowImageSrcChange"];
var gImagesPref, gImagesEnabled, gImagesRestricted;

function Startup()
{
  updateButtons('popup', 'install', 'javascript');
  
  gImagesPref = document.getElementById("enableImagePref");
  gImagesEnabled = document.getElementById("enableImages");
  gImagesRestricted = document.getElementById("enableRestricted");
  var prefValue = gImagesPref.getAttribute("value");
  if (!prefValue)
    prefValue = "0";
  switch (prefValue) {
  case "1": 
    gImagesRestricted.checked = true;
  case "0": 
    gImagesEnabled.checked = true;
    break;
  }
  if (!gImagesEnabled.checked)
    gImagesRestricted.disabled = true;

  if (parent.hPrefWindow.getPrefIsLocked("network.image.imageBehavior")) {  
    gImagesRestricted.disabled = true;
    gImagesEnabled.disabled = true;
  }
}

function updateImagePref()
{
  if (!parent.hPrefWindow.getPrefIsLocked("network.image.imageBehavior")) {
    if (!gImagesEnabled.checked) {
      gImagesPref.setAttribute("value", 2)
      gImagesRestricted.disabled = true;
    } else {
      gImagesPref.setAttribute("value", gImagesRestricted.checked ? 1 : 0)
      gImagesRestricted.disabled = false;
    }
  } else {
    gImagesRestricted.disabled = true;
    gImagesEnabled.disabled = true;
  }
}

function advancedJavaScript()
{
  openDialog("chrome://browser/content/pref/pref-advancedscripts.xul", "", 
             "chrome,modal");
}

function updateButtons()
{
  var i;
  var checkbox;
  var button;

  for (i=0; i < arguments.length; ++i) {
    switch (arguments[i]) {
    case "popup":
      checkbox = document.getElementById("popupPolicy");
      button   = document.getElementById("popupPolicyButton");
      break;
    case "install":
      checkbox = document.getElementById("enableSoftwareInstall");
      button   = document.getElementById("enableSoftwareInstallButton");
      break;
    case "javascript":
      checkbox = document.getElementById("enableJavaScript");
      button   = document.getElementById("advancedJavascript");
      break;
    }
    button.disabled = !checkbox.checked;
  }
}

var gExceptionsParams = {
  install: { blockVisible: false, sessionVisible: false, allowVisible: true, prefilledHost: "", permissionType: "install" },
  popup:   { blockVisible: false, sessionVisible: false, allowVisible: true, prefilledHost: "", permissionType: "popup"   },
  image:   { blockVisible: true,  sessionVisible: false, allowVisible: true, prefilledHost: "", permissionType: "image"   },
};

function showExceptions(aEvent)
{
  var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                     .getService(Components.interfaces.nsIWindowMediator);
  var existingWindow = wm.getMostRecentWindow("exceptions");
  if (existingWindow) {
    existingWindow.setHost("");
    existingWindow.focus();
  }
  else {
    const kURL = "chrome://browser/content/cookieviewer/CookieExceptions.xul";
    var params = gExceptionsParams[aEvent.target.getAttribute("permissiontype")];
    window.openDialog(kURL, "_blank", "chrome,modal,resizable=yes", params);
  }
}

