// |reftest| skip -- Temporal is not supported
// Copyright (C) 2021 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
esid: sec-temporal.calendar.prototype.daysInYear
description: Temporal.Calendar.prototype.daysInYear throws RangeError on
  ToTemporalDate when temporalDateLike is invalid string.
info: |
  4. If Type(temporalDateLike) is not Object or temporalDateLike does
    not have an [[InitializedTemporalDate]] or [[InitializedTemporalYearMonth]]
    internal slot, then
    a. Set temporalDateLike to ? ToTemporalDate(temporalDateLike).
features: [Temporal, arrow-function]
---*/
let cal = new Temporal.Calendar("iso8601");

assert.throws(RangeError, () => cal.daysInYear("invalid string"),
    'cal.daysInYear("invalid string") throws a RangeError exception');

reportCompare(0, 0);
