// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!



"use strict";

var EXPORTED_SYMBOLS = [];

// Write/Read data to/from an ArrayBuffer
class ArrayBufferDataStream {
    constructor(arrayBuffer) {
        this.dataView = new DataView(arrayBuffer);
        this.pos = 0;
    }

    readUint8() {
        let rv = this.dataView.getUint8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeUint8(value) {
        this.dataView.setUint8(this.pos, value);
        this.pos += 1;
    }

    readUint16() {
        let rv = this.dataView.getUint16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeUint16(value) {
        this.dataView.setUint16(this.pos, value);
        this.pos += 2;
    }

    readUint32() {
        let rv = this.dataView.getUint32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeUint32(value) {
        this.dataView.setUint32(this.pos, value);
        this.pos += 4;
    }

    readUint64() {
        let rv = this.dataView.getBigUint64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeUint64(value) {
        this.dataView.setBigUint64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readInt8() {
        let rv = this.dataView.getInt8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeInt8(value) {
        this.dataView.setInt8(this.pos, value);
        this.pos += 1;
    }

    readInt16() {
        let rv = this.dataView.getInt16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeInt16(value) {
        this.dataView.setInt16(this.pos, value);
        this.pos += 2;
    }

    readInt32() {
        let rv = this.dataView.getInt32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeInt32(value) {
        this.dataView.setInt32(this.pos, value);
        this.pos += 4;
    }

    readInt64() {
        let rv = this.dataView.getBigInt64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeInt64(value) {
        this.dataView.setBigInt64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readFloat32() {
        let rv = this.dataView.getFloat32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeFloat32(value) {
        this.dataView.setFloat32(this.pos, value);
        this.pos += 4;
    }

    readFloat64() {
        let rv = this.dataView.getFloat64(this.pos);
        this.pos += 8;
        return rv;
    }

    writeFloat64(value) {
        this.dataView.setFloat64(this.pos, value);
        this.pos += 8;
    }


    writeString(value) {
      const encoder = new TextEncoder();
      // Note: in order to efficiently write this data, we first write the
      // string data, reserving 4 bytes for the size.
      const dest = new Uint8Array(this.dataView.buffer, this.pos + 4);
      const encodeResult = encoder.encodeInto(value, dest);
      if (encodeResult.read != value.length) {
        throw new UniFFIError(
            "writeString: out of space when writing to ArrayBuffer.  Did the computeSize() method returned the wrong result?"
        );
      }
      const size = encodeResult.written;
      // Next, go back and write the size before the string data
      this.dataView.setUint32(this.pos, size);
      // Finally, advance our position past both the size and string data
      this.pos += size + 4;
    }

    readString() {
      const decoder = new TextDecoder();
      const size = this.readUint32();
      const source = new Uint8Array(this.dataView.buffer, this.pos, size)
      const value = decoder.decode(source);
      this.pos += size;
      return value;
    }

    // Reads a Sprite pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerSprite() {
        const pointerId = 3; // sprites:Sprite
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a Sprite pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerSprite(value) {
        const pointerId = 3; // sprites:Sprite
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    
}

function handleRustResult(result, liftCallback, liftErrCallback) {
    switch (result.code) {
        case "success":
            return liftCallback(result.data);

        case "error":
            throw liftErrCallback(result.data);

        case "internal-error":
            let message = result.internalErrorMessage;
            if (message) {
                throw new UniFFIInternalError(message);
            } else {
                throw new UniFFIInternalError("Unknown error");
            }

        default:
            throw new UniFFIError(`Unexpected status code: ${result.code}`);
    }
}

class UniFFIError {
    constructor(message) {
        this.message = message;
    }
}

class UniFFIInternalError extends UniFFIError {}

// Base class for FFI converters
class FfiConverter {
    static checkType(name, value) {
        if (value === undefined ) {
            throw TypeError(`${name} is undefined`);
        }
        if (value === null ) {
            throw TypeError(`${name} is null`);
        }
    }
}

// Base class for FFI converters that lift/lower by reading/writing to an ArrayBuffer
class FfiConverterArrayBuffer extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }

    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
}

// Symbols that are used to ensure that Object constructors
// can only be used with a proper UniFFI pointer
const uniffiObjectPtr = Symbol("uniffiObjectPtr");
const constructUniffiObject = Symbol("constructUniffiObject");

class FfiConverterF64 extends FfiConverter {
    static computeSize() {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeFloat64(value)
    }
    static read(dataStream) {
        return dataStream.readFloat64()
    }
}

class FfiConverterString extends FfiConverter {
    static lift(buf) {
        const decoder = new TextDecoder();
        const utf8Arr = new Uint8Array(buf);
        return decoder.decode(utf8Arr);
    }
    static lower(value) {
        const encoder = new TextEncoder();
        return encoder.encode(value).buffer;
    }

    static write(dataStream, value) {
        dataStream.writeString(value);
    }

    static read(dataStream) {
        return dataStream.readString();
    }

    static computeSize(value) {
        const encoder = new TextEncoder();
        return 4 + encoder.encode(value).length
    }
}


class Sprite {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * An async constructor for Sprite.
     * 
     * @returns {Promise<Sprite>}: A promise that resolves
     *      to a newly constructed Sprite
     */
    static init(initialPosition) {
    const liftResult = (result) => FfiConverterTypeSprite.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterOptionalTypePoint.checkType("initialPosition", initialPosition);
        return UniFFIScaffolding.callAsync(
            66, // sprites:sprites_f59e_Sprite_new
            FfiConverterOptionalTypePoint.lower(initialPosition),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    /**
     * An async constructor for Sprite.
     * 
     * @returns {Promise<Sprite>}: A promise that resolves
     *      to a newly constructed Sprite
     */
    static newRelativeTo(reference,direction) {
    const liftResult = (result) => FfiConverterTypeSprite.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterTypePoint.checkType("reference", reference);
        FfiConverterTypeVector.checkType("direction", direction);
        return UniFFIScaffolding.callAsync(
            67, // sprites:sprites_f59e_Sprite_new_relative_to
            FfiConverterTypePoint.lower(reference),
            FfiConverterTypeVector.lower(direction),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    getPosition() {
    const liftResult = (result) => FfiConverterTypePoint.lift(result);
    const liftError = null;
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            68, // sprites:sprites_f59e_Sprite_get_position
            FfiConverterTypeSprite.lower(this),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    moveTo(position) {
    const liftResult = (result) => undefined;
    const liftError = null;
    const functionCall = () => {
        FfiConverterTypePoint.checkType("position", position);
        return UniFFIScaffolding.callAsync(
            69, // sprites:sprites_f59e_Sprite_move_to
            FfiConverterTypeSprite.lower(this),
            FfiConverterTypePoint.lower(position),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    moveBy(direction) {
    const liftResult = (result) => undefined;
    const liftError = null;
    const functionCall = () => {
        FfiConverterTypeVector.checkType("direction", direction);
        return UniFFIScaffolding.callAsync(
            70, // sprites:sprites_f59e_Sprite_move_by
            FfiConverterTypeSprite.lower(this),
            FfiConverterTypeVector.lower(direction),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}

}

class FfiConverterTypeSprite extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new Sprite(opts);
    }

    static lower(value) {
        return value[uniffiObjectPtr];
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerSprite());
    }

    static write(dataStream, value) {
        dataStream.writePointerSprite(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

EXPORTED_SYMBOLS.push("Sprite");

class Point {
    constructor(x,y) {
        FfiConverterF64.checkType("x", x);
        FfiConverterF64.checkType("y", y);
        this.x = x;
        this.y = y;
    }
    equals(other) {
        return (
            this.x == other.x &&
            this.y == other.y
        )
    }
}

class FfiConverterTypePoint extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }
    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
    static read(dataStream) {
        return new Point(
            FfiConverterF64.read(dataStream), 
            FfiConverterF64.read(dataStream)
        );
    }
    static write(dataStream, value) {
        FfiConverterF64.write(dataStream, value.x);
        FfiConverterF64.write(dataStream, value.y);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterF64.computeSize(value.x);
        totalSize += FfiConverterF64.computeSize(value.y);
        return totalSize
    }
}

EXPORTED_SYMBOLS.push("Point");

class Vector {
    constructor(dx,dy) {
        FfiConverterF64.checkType("dx", dx);
        FfiConverterF64.checkType("dy", dy);
        this.dx = dx;
        this.dy = dy;
    }
    equals(other) {
        return (
            this.dx == other.dx &&
            this.dy == other.dy
        )
    }
}

class FfiConverterTypeVector extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }
    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
    static read(dataStream) {
        return new Vector(
            FfiConverterF64.read(dataStream), 
            FfiConverterF64.read(dataStream)
        );
    }
    static write(dataStream, value) {
        FfiConverterF64.write(dataStream, value.dx);
        FfiConverterF64.write(dataStream, value.dy);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterF64.computeSize(value.dx);
        totalSize += FfiConverterF64.computeSize(value.dy);
        return totalSize
    }
}

EXPORTED_SYMBOLS.push("Vector");class FfiConverterOptionalTypePoint extends FfiConverterArrayBuffer {
    static checkType(name, value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypePoint.checkType(name, value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypePoint.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypePoint.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypePoint.computeSize(value)
    }
}


function translate(position,direction) {
    
    const liftResult = (result) => FfiConverterTypePoint.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterTypePoint.checkType("position", position);
        FfiConverterTypeVector.checkType("direction", direction);
        return UniFFIScaffolding.callAsync(
            71, // sprites:sprites_f59e_translate
            FfiConverterTypePoint.lower(position),
            FfiConverterTypeVector.lower(direction),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }
}

EXPORTED_SYMBOLS.push("translate");
