// |reftest| skip-if(!this.hasOwnProperty('Temporal')) -- Temporal is not enabled unconditionally
// Copyright (C) 2022 André Bargull. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-temporal.timezone
description: >
  TimeZone constructor accepts link names as its input.
features: [Temporal]
---*/

const testCases = [
  "Pacific/Saipan",  // Link Pacific/Guam Pacific/Saipan # N Mariana Is
  "Antarctica/McMurdo",  // Link Pacific/Auckland Antarctica/McMurdo
  "Antarctica/DumontDUrville",  // Link Pacific/Port_Moresby Antarctica/DumontDUrville
  "Pacific/Midway",  // Link Pacific/Pago_Pago Pacific/Midway # in US minor outlying islands
];

for (let id of testCases) {
  // Doesn't throw a RangeError.
  new Temporal.TimeZone(id);
}

reportCompare(0, 0);
