/*
  Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/
*/

async function testSteps() {
  const urlString = "http://example.com";

  const data = {
    key: "foo",
    value: "bar",
  };

  function getLocalStorage(principal) {
    return Services.domStorageManager.createStorage(null, principal, principal, "");
  }

  info("Getting storage");

  const urlPrincipal = getPrincipal(urlString);
  let storage = getLocalStorage(urlPrincipal);

  info("Adding data");

  storage.setItem(data.key, data.value);
}
