// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!

import { UniFFITypeError } from "resource://gre/modules/UniFFI.sys.mjs";



// Objects intended to be used in the unit tests
export var UnitTestObjs = {};

// Write/Read data to/from an ArrayBuffer
class ArrayBufferDataStream {
    constructor(arrayBuffer) {
        this.dataView = new DataView(arrayBuffer);
        this.pos = 0;
    }

    readUint8() {
        let rv = this.dataView.getUint8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeUint8(value) {
        this.dataView.setUint8(this.pos, value);
        this.pos += 1;
    }

    readUint16() {
        let rv = this.dataView.getUint16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeUint16(value) {
        this.dataView.setUint16(this.pos, value);
        this.pos += 2;
    }

    readUint32() {
        let rv = this.dataView.getUint32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeUint32(value) {
        this.dataView.setUint32(this.pos, value);
        this.pos += 4;
    }

    readUint64() {
        let rv = this.dataView.getBigUint64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeUint64(value) {
        this.dataView.setBigUint64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readInt8() {
        let rv = this.dataView.getInt8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeInt8(value) {
        this.dataView.setInt8(this.pos, value);
        this.pos += 1;
    }

    readInt16() {
        let rv = this.dataView.getInt16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeInt16(value) {
        this.dataView.setInt16(this.pos, value);
        this.pos += 2;
    }

    readInt32() {
        let rv = this.dataView.getInt32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeInt32(value) {
        this.dataView.setInt32(this.pos, value);
        this.pos += 4;
    }

    readInt64() {
        let rv = this.dataView.getBigInt64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeInt64(value) {
        this.dataView.setBigInt64(this.pos, BigInt(value));
        this.pos += 8;
    }

    readFloat32() {
        let rv = this.dataView.getFloat32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeFloat32(value) {
        this.dataView.setFloat32(this.pos, value);
        this.pos += 4;
    }

    readFloat64() {
        let rv = this.dataView.getFloat64(this.pos);
        this.pos += 8;
        return rv;
    }

    writeFloat64(value) {
        this.dataView.setFloat64(this.pos, value);
        this.pos += 8;
    }


    writeString(value) {
      const encoder = new TextEncoder();
      // Note: in order to efficiently write this data, we first write the
      // string data, reserving 4 bytes for the size.
      const dest = new Uint8Array(this.dataView.buffer, this.pos + 4);
      const encodeResult = encoder.encodeInto(value, dest);
      if (encodeResult.read != value.length) {
        throw new UniFFIError(
            "writeString: out of space when writing to ArrayBuffer.  Did the computeSize() method returned the wrong result?"
        );
      }
      const size = encodeResult.written;
      // Next, go back and write the size before the string data
      this.dataView.setUint32(this.pos, size);
      // Finally, advance our position past both the size and string data
      this.pos += size + 4;
    }

    readString() {
      const decoder = new TextDecoder();
      const size = this.readUint32();
      const source = new Uint8Array(this.dataView.buffer, this.pos, size)
      const value = decoder.decode(source);
      this.pos += size;
      return value;
    }

    // Reads a SuggestStore pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerSuggestStore() {
        const pointerId = 1; // suggest:SuggestStore
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a SuggestStore pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerSuggestStore(value) {
        const pointerId = 1; // suggest:SuggestStore
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    

    // Reads a SuggestStoreBuilder pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerSuggestStoreBuilder() {
        const pointerId = 2; // suggest:SuggestStoreBuilder
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a SuggestStoreBuilder pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerSuggestStoreBuilder(value) {
        const pointerId = 2; // suggest:SuggestStoreBuilder
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    
}

function handleRustResult(result, liftCallback, liftErrCallback) {
    switch (result.code) {
        case "success":
            return liftCallback(result.data);

        case "error":
            throw liftErrCallback(result.data);

        case "internal-error":
            let message = result.internalErrorMessage;
            if (message) {
                throw new UniFFIInternalError(message);
            } else {
                throw new UniFFIInternalError("Unknown error");
            }

        default:
            throw new UniFFIError(`Unexpected status code: ${result.code}`);
    }
}

class UniFFIError {
    constructor(message) {
        this.message = message;
    }

    toString() {
        return `UniFFIError: ${this.message}`
    }
}

class UniFFIInternalError extends UniFFIError {}

// Base class for FFI converters
class FfiConverter {
    // throw `UniFFITypeError` if a value to be converted has an invalid type
    static checkType(value) {
        if (value === undefined ) {
            throw new UniFFITypeError(`undefined`);
        }
        if (value === null ) {
            throw new UniFFITypeError(`null`);
        }
    }
}

// Base class for FFI converters that lift/lower by reading/writing to an ArrayBuffer
class FfiConverterArrayBuffer extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }

    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
}

// Symbols that are used to ensure that Object constructors
// can only be used with a proper UniFFI pointer
const uniffiObjectPtr = Symbol("uniffiObjectPtr");
const constructUniffiObject = Symbol("constructUniffiObject");
UnitTestObjs.uniffiObjectPtr = uniffiObjectPtr;

// Export the FFIConverter object to make external types work.
export class FfiConverterU8 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < 0 || value > 256) {
            throw new UniFFITypeError(`${value} exceeds the U8 bounds`);
        }
    }
    static computeSize() {
        return 1;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint8(value)
    }
    static read(dataStream) {
        return dataStream.readUint8()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterI32 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < -2147483648 || value > 2147483647) {
            throw new UniFFITypeError(`${value} exceeds the I32 bounds`);
        }
    }
    static computeSize() {
        return 4;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt32(value)
    }
    static read(dataStream) {
        return dataStream.readInt32()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterU64 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isSafeInteger(value)) {
            throw new UniFFITypeError(`${value} exceeds the safe integer bounds`);
        }
        if (value < 0) {
            throw new UniFFITypeError(`${value} exceeds the U64 bounds`);
        }
    }
    static computeSize() {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint64(value)
    }
    static read(dataStream) {
        return dataStream.readUint64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterI64 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isSafeInteger(value)) {
            throw new UniFFITypeError(`${value} exceeds the safe integer bounds`);
        }
    }
    static computeSize() {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt64(value)
    }
    static read(dataStream) {
        return dataStream.readInt64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterF64 extends FfiConverter {
    static computeSize() {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeFloat64(value)
    }
    static read(dataStream) {
        return dataStream.readFloat64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterBool extends FfiConverter {
    static computeSize() {
        return 1;
    }
    static lift(value) {
        return value == 1;
    }
    static lower(value) {
        if (value) {
            return 1;
        } else {
            return 0;
        }
    }
    static write(dataStream, value) {
        dataStream.writeUint8(this.lower(value))
    }
    static read(dataStream) {
        return this.lift(dataStream.readUint8())
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterString extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (typeof value !== "string") {
            throw new UniFFITypeError(`${value} is not a string`);
        }
    }

    static lift(buf) {
        const decoder = new TextDecoder();
        const utf8Arr = new Uint8Array(buf);
        return decoder.decode(utf8Arr);
    }
    static lower(value) {
        const encoder = new TextEncoder();
        return encoder.encode(value).buffer;
    }

    static write(dataStream, value) {
        dataStream.writeString(value);
    }

    static read(dataStream) {
        return dataStream.readString();
    }

    static computeSize(value) {
        const encoder = new TextEncoder();
        return 4 + encoder.encode(value).length
    }
}

export class SuggestStore {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * A constructor for SuggestStore.
     * 
     * @returns { SuggestStore }
     */
    static init(path,settingsConfig = null) {
        const liftResult = (result) => FfiConverterTypeSuggestStore.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterString.checkType(path)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("path");
                }
                throw e;
            }
            try {
                FfiConverterOptionalTypeRemoteSettingsConfig.checkType(settingsConfig)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("settingsConfig");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                4, // suggest:uniffi_suggest_fn_constructor_suggeststore_new
                FfiConverterString.lower(path),
                FfiConverterOptionalTypeRemoteSettingsConfig.lower(settingsConfig),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);}

    clear() {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                5, // suggest:uniffi_suggest_fn_method_suggeststore_clear
                FfiConverterTypeSuggestStore.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    fetchGlobalConfig() {
        const liftResult = (result) => FfiConverterTypeSuggestGlobalConfig.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                6, // suggest:uniffi_suggest_fn_method_suggeststore_fetch_global_config
                FfiConverterTypeSuggestStore.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    fetchProviderConfig(provider) {
        const liftResult = (result) => FfiConverterOptionalTypeSuggestProviderConfig.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterTypeSuggestionProvider.checkType(provider)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("provider");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                7, // suggest:uniffi_suggest_fn_method_suggeststore_fetch_provider_config
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterTypeSuggestionProvider.lower(provider),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    ingest(constraints) {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterTypeSuggestIngestionConstraints.checkType(constraints)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("constraints");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                8, // suggest:uniffi_suggest_fn_method_suggeststore_ingest
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterTypeSuggestIngestionConstraints.lower(constraints),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    interrupt() {
        const liftResult = (result) => undefined;
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callSync(
                9, // suggest:uniffi_suggest_fn_method_suggeststore_interrupt
                FfiConverterTypeSuggestStore.lower(this),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

    query(query) {
        const liftResult = (result) => FfiConverterSequenceTypeSuggestion.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterTypeSuggestionQuery.checkType(query)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("query");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                10, // suggest:uniffi_suggest_fn_method_suggeststore_query
                FfiConverterTypeSuggestStore.lower(this),
                FfiConverterTypeSuggestionQuery.lower(query),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestStore extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new SuggestStore(opts);
    }

    static lower(value) {
        return value[uniffiObjectPtr];
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerSuggestStore());
    }

    static write(dataStream, value) {
        dataStream.writePointerSuggestStore(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

export class SuggestStoreBuilder {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * An async constructor for SuggestStoreBuilder.
     * 
     * @returns {Promise<SuggestStoreBuilder>}: A promise that resolves
     *      to a newly constructed SuggestStoreBuilder
     */
    static init() {
        const liftResult = (result) => FfiConverterTypeSuggestStoreBuilder.lift(result);
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                11, // suggest:uniffi_suggest_fn_constructor_suggeststorebuilder_new
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }}

    build() {
        const liftResult = (result) => FfiConverterTypeSuggestStore.lift(result);
        const liftError = (data) => FfiConverterTypeSuggestApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                12, // suggest:uniffi_suggest_fn_method_suggeststorebuilder_build
                FfiConverterTypeSuggestStoreBuilder.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    cachePath(path) {
        const liftResult = (result) => FfiConverterTypeSuggestStoreBuilder.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(path)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("path");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                13, // suggest:uniffi_suggest_fn_method_suggeststorebuilder_cache_path
                FfiConverterTypeSuggestStoreBuilder.lower(this),
                FfiConverterString.lower(path),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    dataPath(path) {
        const liftResult = (result) => FfiConverterTypeSuggestStoreBuilder.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(path)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("path");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                14, // suggest:uniffi_suggest_fn_method_suggeststorebuilder_data_path
                FfiConverterTypeSuggestStoreBuilder.lower(this),
                FfiConverterString.lower(path),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    remoteSettingsConfig(config) {
        const liftResult = (result) => FfiConverterTypeSuggestStoreBuilder.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeRemoteSettingsConfig.checkType(config)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("config");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                15, // suggest:uniffi_suggest_fn_method_suggeststorebuilder_remote_settings_config
                FfiConverterTypeSuggestStoreBuilder.lower(this),
                FfiConverterTypeRemoteSettingsConfig.lower(config),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestStoreBuilder extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new SuggestStoreBuilder(opts);
    }

    static lower(value) {
        return value[uniffiObjectPtr];
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerSuggestStoreBuilder());
    }

    static write(dataStream, value) {
        dataStream.writePointerSuggestStoreBuilder(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

export class SuggestGlobalConfig {
    constructor({ showLessFrequentlyCap } = {}) {
        try {
            FfiConverterI32.checkType(showLessFrequentlyCap)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("showLessFrequentlyCap");
            }
            throw e;
        }
        this.showLessFrequentlyCap = showLessFrequentlyCap;
    }
    equals(other) {
        return (
            this.showLessFrequentlyCap == other.showLessFrequentlyCap
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestGlobalConfig extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new SuggestGlobalConfig({
            showLessFrequentlyCap: FfiConverterI32.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterI32.write(dataStream, value.showLessFrequentlyCap);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterI32.computeSize(value.showLessFrequentlyCap);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof SuggestGlobalConfig)) {
            throw new TypeError(`Expected 'SuggestGlobalConfig', found '${typeof value}'`);
        }
        try {
            FfiConverterI32.checkType(value.showLessFrequentlyCap);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".showLessFrequentlyCap");
            }
            throw e;
        }
    }
}

export class SuggestIngestionConstraints {
    constructor({ maxSuggestions = null } = {}) {
        try {
            FfiConverterOptionalu64.checkType(maxSuggestions)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("maxSuggestions");
            }
            throw e;
        }
        this.maxSuggestions = maxSuggestions;
    }
    equals(other) {
        return (
            this.maxSuggestions == other.maxSuggestions
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestIngestionConstraints extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new SuggestIngestionConstraints({
            maxSuggestions: FfiConverterOptionalu64.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterOptionalu64.write(dataStream, value.maxSuggestions);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterOptionalu64.computeSize(value.maxSuggestions);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof SuggestIngestionConstraints)) {
            throw new TypeError(`Expected 'SuggestIngestionConstraints', found '${typeof value}'`);
        }
        try {
            FfiConverterOptionalu64.checkType(value.maxSuggestions);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".maxSuggestions");
            }
            throw e;
        }
    }
}

export class SuggestionQuery {
    constructor({ keyword, providers, limit = null } = {}) {
        try {
            FfiConverterString.checkType(keyword)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("keyword");
            }
            throw e;
        }
        try {
            FfiConverterSequenceTypeSuggestionProvider.checkType(providers)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("providers");
            }
            throw e;
        }
        try {
            FfiConverterOptionali32.checkType(limit)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("limit");
            }
            throw e;
        }
        this.keyword = keyword;
        this.providers = providers;
        this.limit = limit;
    }
    equals(other) {
        return (
            this.keyword == other.keyword &&
            this.providers == other.providers &&
            this.limit == other.limit
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestionQuery extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new SuggestionQuery({
            keyword: FfiConverterString.read(dataStream),
            providers: FfiConverterSequenceTypeSuggestionProvider.read(dataStream),
            limit: FfiConverterOptionali32.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value.keyword);
        FfiConverterSequenceTypeSuggestionProvider.write(dataStream, value.providers);
        FfiConverterOptionali32.write(dataStream, value.limit);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterString.computeSize(value.keyword);
        totalSize += FfiConverterSequenceTypeSuggestionProvider.computeSize(value.providers);
        totalSize += FfiConverterOptionali32.computeSize(value.limit);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof SuggestionQuery)) {
            throw new TypeError(`Expected 'SuggestionQuery', found '${typeof value}'`);
        }
        try {
            FfiConverterString.checkType(value.keyword);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".keyword");
            }
            throw e;
        }
        try {
            FfiConverterSequenceTypeSuggestionProvider.checkType(value.providers);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".providers");
            }
            throw e;
        }
        try {
            FfiConverterOptionali32.checkType(value.limit);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".limit");
            }
            throw e;
        }
    }
}




export class SuggestApiError extends Error {}


export class Interrupted extends SuggestApiError {

    constructor(
        ...params
    ) {
        super(...params);
    }
    toString() {
        return `Interrupted: ${super.toString()}`
    }
}

export class Backoff extends SuggestApiError {

    constructor(
        seconds,
        ...params
    ) {
        super(...params);
        this.seconds = seconds;
    }
    toString() {
        return `Backoff: ${super.toString()}`
    }
}

export class Network extends SuggestApiError {

    constructor(
        reason,
        ...params
    ) {
        super(...params);
        this.reason = reason;
    }
    toString() {
        return `Network: ${super.toString()}`
    }
}

export class Other extends SuggestApiError {

    constructor(
        reason,
        ...params
    ) {
        super(...params);
        this.reason = reason;
    }
    toString() {
        return `Other: ${super.toString()}`
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestApiError extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new Interrupted(
                    );
            case 2:
                return new Backoff(
                    FfiConverterU64.read(dataStream)
                    );
            case 3:
                return new Network(
                    FfiConverterString.read(dataStream)
                    );
            case 4:
                return new Other(
                    FfiConverterString.read(dataStream)
                    );
            default:
                throw new Error("Unknown SuggestApiError variant");
        }
    }
    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof Interrupted) {
            return totalSize;
        }
        if (value instanceof Backoff) {
            totalSize += FfiConverterU64.computeSize(value.seconds);
            return totalSize;
        }
        if (value instanceof Network) {
            totalSize += FfiConverterString.computeSize(value.reason);
            return totalSize;
        }
        if (value instanceof Other) {
            totalSize += FfiConverterString.computeSize(value.reason);
            return totalSize;
        }
        throw new Error("Unknown SuggestApiError variant");
    }
    static write(dataStream, value) {
        if (value instanceof Interrupted) {
            dataStream.writeInt32(1);
            return;
        }
        if (value instanceof Backoff) {
            dataStream.writeInt32(2);
            FfiConverterU64.write(dataStream, value.seconds);
            return;
        }
        if (value instanceof Network) {
            dataStream.writeInt32(3);
            FfiConverterString.write(dataStream, value.reason);
            return;
        }
        if (value instanceof Other) {
            dataStream.writeInt32(4);
            FfiConverterString.write(dataStream, value.reason);
            return;
        }
        throw new Error("Unknown SuggestApiError variant");
    }

    static errorClass = SuggestApiError;
}


export class SuggestProviderConfig {}
SuggestProviderConfig.Weather = class extends SuggestProviderConfig{
    constructor(
        minKeywordLength
        ) {
            super();
            this.minKeywordLength = minKeywordLength;
        }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestProviderConfig extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new SuggestProviderConfig.Weather(
                    FfiConverterI32.read(dataStream)
                    );
            default:
                return new Error("Unknown SuggestProviderConfig variant");
        }
    }

    static write(dataStream, value) {
        if (value instanceof SuggestProviderConfig.Weather) {
            dataStream.writeInt32(1);
            FfiConverterI32.write(dataStream, value.minKeywordLength);
            return;
        }
        return new Error("Unknown SuggestProviderConfig variant");
    }

    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof SuggestProviderConfig.Weather) {
            totalSize += FfiConverterI32.computeSize(value.minKeywordLength);
            return totalSize;
        }
        return new Error("Unknown SuggestProviderConfig variant");
    }

    static checkType(value) {
      if (!(value instanceof SuggestProviderConfig)) {
        throw new UniFFITypeError(`${value} is not a subclass instance of SuggestProviderConfig`);
      }
    }
}



export class Suggestion {}
Suggestion.Amp = class extends Suggestion{
    constructor(
        title,
        url,
        rawUrl,
        icon,
        fullKeyword,
        blockId,
        advertiser,
        iabCategory,
        impressionUrl,
        clickUrl,
        rawClickUrl,
        score
        ) {
            super();
            this.title = title;
            this.url = url;
            this.rawUrl = rawUrl;
            this.icon = icon;
            this.fullKeyword = fullKeyword;
            this.blockId = blockId;
            this.advertiser = advertiser;
            this.iabCategory = iabCategory;
            this.impressionUrl = impressionUrl;
            this.clickUrl = clickUrl;
            this.rawClickUrl = rawClickUrl;
            this.score = score;
        }
}
Suggestion.Pocket = class extends Suggestion{
    constructor(
        title,
        url,
        score,
        isTopPick
        ) {
            super();
            this.title = title;
            this.url = url;
            this.score = score;
            this.isTopPick = isTopPick;
        }
}
Suggestion.Wikipedia = class extends Suggestion{
    constructor(
        title,
        url,
        icon,
        fullKeyword
        ) {
            super();
            this.title = title;
            this.url = url;
            this.icon = icon;
            this.fullKeyword = fullKeyword;
        }
}
Suggestion.Amo = class extends Suggestion{
    constructor(
        title,
        url,
        iconUrl,
        description,
        rating,
        numberOfRatings,
        guid,
        score
        ) {
            super();
            this.title = title;
            this.url = url;
            this.iconUrl = iconUrl;
            this.description = description;
            this.rating = rating;
            this.numberOfRatings = numberOfRatings;
            this.guid = guid;
            this.score = score;
        }
}
Suggestion.Yelp = class extends Suggestion{
    constructor(
        url,
        title,
        icon,
        score,
        hasLocationSign,
        subjectExactMatch,
        locationParam
        ) {
            super();
            this.url = url;
            this.title = title;
            this.icon = icon;
            this.score = score;
            this.hasLocationSign = hasLocationSign;
            this.subjectExactMatch = subjectExactMatch;
            this.locationParam = locationParam;
        }
}
Suggestion.Mdn = class extends Suggestion{
    constructor(
        title,
        url,
        description,
        score
        ) {
            super();
            this.title = title;
            this.url = url;
            this.description = description;
            this.score = score;
        }
}
Suggestion.Weather = class extends Suggestion{
    constructor(
        score
        ) {
            super();
            this.score = score;
        }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestion extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new Suggestion.Amp(
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterOptionalSequenceu8.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterI64.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterF64.read(dataStream)
                    );
            case 2:
                return new Suggestion.Pocket(
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterF64.read(dataStream),
                    FfiConverterBool.read(dataStream)
                    );
            case 3:
                return new Suggestion.Wikipedia(
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterOptionalSequenceu8.read(dataStream),
                    FfiConverterString.read(dataStream)
                    );
            case 4:
                return new Suggestion.Amo(
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterOptionalstring.read(dataStream),
                    FfiConverterI64.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterF64.read(dataStream)
                    );
            case 5:
                return new Suggestion.Yelp(
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterOptionalSequenceu8.read(dataStream),
                    FfiConverterF64.read(dataStream),
                    FfiConverterBool.read(dataStream),
                    FfiConverterBool.read(dataStream),
                    FfiConverterString.read(dataStream)
                    );
            case 6:
                return new Suggestion.Mdn(
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterString.read(dataStream),
                    FfiConverterF64.read(dataStream)
                    );
            case 7:
                return new Suggestion.Weather(
                    FfiConverterF64.read(dataStream)
                    );
            default:
                return new Error("Unknown Suggestion variant");
        }
    }

    static write(dataStream, value) {
        if (value instanceof Suggestion.Amp) {
            dataStream.writeInt32(1);
            FfiConverterString.write(dataStream, value.title);
            FfiConverterString.write(dataStream, value.url);
            FfiConverterString.write(dataStream, value.rawUrl);
            FfiConverterOptionalSequenceu8.write(dataStream, value.icon);
            FfiConverterString.write(dataStream, value.fullKeyword);
            FfiConverterI64.write(dataStream, value.blockId);
            FfiConverterString.write(dataStream, value.advertiser);
            FfiConverterString.write(dataStream, value.iabCategory);
            FfiConverterString.write(dataStream, value.impressionUrl);
            FfiConverterString.write(dataStream, value.clickUrl);
            FfiConverterString.write(dataStream, value.rawClickUrl);
            FfiConverterF64.write(dataStream, value.score);
            return;
        }
        if (value instanceof Suggestion.Pocket) {
            dataStream.writeInt32(2);
            FfiConverterString.write(dataStream, value.title);
            FfiConverterString.write(dataStream, value.url);
            FfiConverterF64.write(dataStream, value.score);
            FfiConverterBool.write(dataStream, value.isTopPick);
            return;
        }
        if (value instanceof Suggestion.Wikipedia) {
            dataStream.writeInt32(3);
            FfiConverterString.write(dataStream, value.title);
            FfiConverterString.write(dataStream, value.url);
            FfiConverterOptionalSequenceu8.write(dataStream, value.icon);
            FfiConverterString.write(dataStream, value.fullKeyword);
            return;
        }
        if (value instanceof Suggestion.Amo) {
            dataStream.writeInt32(4);
            FfiConverterString.write(dataStream, value.title);
            FfiConverterString.write(dataStream, value.url);
            FfiConverterString.write(dataStream, value.iconUrl);
            FfiConverterString.write(dataStream, value.description);
            FfiConverterOptionalstring.write(dataStream, value.rating);
            FfiConverterI64.write(dataStream, value.numberOfRatings);
            FfiConverterString.write(dataStream, value.guid);
            FfiConverterF64.write(dataStream, value.score);
            return;
        }
        if (value instanceof Suggestion.Yelp) {
            dataStream.writeInt32(5);
            FfiConverterString.write(dataStream, value.url);
            FfiConverterString.write(dataStream, value.title);
            FfiConverterOptionalSequenceu8.write(dataStream, value.icon);
            FfiConverterF64.write(dataStream, value.score);
            FfiConverterBool.write(dataStream, value.hasLocationSign);
            FfiConverterBool.write(dataStream, value.subjectExactMatch);
            FfiConverterString.write(dataStream, value.locationParam);
            return;
        }
        if (value instanceof Suggestion.Mdn) {
            dataStream.writeInt32(6);
            FfiConverterString.write(dataStream, value.title);
            FfiConverterString.write(dataStream, value.url);
            FfiConverterString.write(dataStream, value.description);
            FfiConverterF64.write(dataStream, value.score);
            return;
        }
        if (value instanceof Suggestion.Weather) {
            dataStream.writeInt32(7);
            FfiConverterF64.write(dataStream, value.score);
            return;
        }
        return new Error("Unknown Suggestion variant");
    }

    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof Suggestion.Amp) {
            totalSize += FfiConverterString.computeSize(value.title);
            totalSize += FfiConverterString.computeSize(value.url);
            totalSize += FfiConverterString.computeSize(value.rawUrl);
            totalSize += FfiConverterOptionalSequenceu8.computeSize(value.icon);
            totalSize += FfiConverterString.computeSize(value.fullKeyword);
            totalSize += FfiConverterI64.computeSize(value.blockId);
            totalSize += FfiConverterString.computeSize(value.advertiser);
            totalSize += FfiConverterString.computeSize(value.iabCategory);
            totalSize += FfiConverterString.computeSize(value.impressionUrl);
            totalSize += FfiConverterString.computeSize(value.clickUrl);
            totalSize += FfiConverterString.computeSize(value.rawClickUrl);
            totalSize += FfiConverterF64.computeSize(value.score);
            return totalSize;
        }
        if (value instanceof Suggestion.Pocket) {
            totalSize += FfiConverterString.computeSize(value.title);
            totalSize += FfiConverterString.computeSize(value.url);
            totalSize += FfiConverterF64.computeSize(value.score);
            totalSize += FfiConverterBool.computeSize(value.isTopPick);
            return totalSize;
        }
        if (value instanceof Suggestion.Wikipedia) {
            totalSize += FfiConverterString.computeSize(value.title);
            totalSize += FfiConverterString.computeSize(value.url);
            totalSize += FfiConverterOptionalSequenceu8.computeSize(value.icon);
            totalSize += FfiConverterString.computeSize(value.fullKeyword);
            return totalSize;
        }
        if (value instanceof Suggestion.Amo) {
            totalSize += FfiConverterString.computeSize(value.title);
            totalSize += FfiConverterString.computeSize(value.url);
            totalSize += FfiConverterString.computeSize(value.iconUrl);
            totalSize += FfiConverterString.computeSize(value.description);
            totalSize += FfiConverterOptionalstring.computeSize(value.rating);
            totalSize += FfiConverterI64.computeSize(value.numberOfRatings);
            totalSize += FfiConverterString.computeSize(value.guid);
            totalSize += FfiConverterF64.computeSize(value.score);
            return totalSize;
        }
        if (value instanceof Suggestion.Yelp) {
            totalSize += FfiConverterString.computeSize(value.url);
            totalSize += FfiConverterString.computeSize(value.title);
            totalSize += FfiConverterOptionalSequenceu8.computeSize(value.icon);
            totalSize += FfiConverterF64.computeSize(value.score);
            totalSize += FfiConverterBool.computeSize(value.hasLocationSign);
            totalSize += FfiConverterBool.computeSize(value.subjectExactMatch);
            totalSize += FfiConverterString.computeSize(value.locationParam);
            return totalSize;
        }
        if (value instanceof Suggestion.Mdn) {
            totalSize += FfiConverterString.computeSize(value.title);
            totalSize += FfiConverterString.computeSize(value.url);
            totalSize += FfiConverterString.computeSize(value.description);
            totalSize += FfiConverterF64.computeSize(value.score);
            return totalSize;
        }
        if (value instanceof Suggestion.Weather) {
            totalSize += FfiConverterF64.computeSize(value.score);
            return totalSize;
        }
        return new Error("Unknown Suggestion variant");
    }

    static checkType(value) {
      if (!(value instanceof Suggestion)) {
        throw new UniFFITypeError(`${value} is not a subclass instance of Suggestion`);
      }
    }
}



export const SuggestionProvider = {
    AMP: 1,
    POCKET: 2,
    WIKIPEDIA: 3,
    AMO: 4,
    YELP: 5,
    MDN: 6,
    WEATHER: 7,
    AMP_MOBILE: 8,
};

Object.freeze(SuggestionProvider);
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeSuggestionProvider extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return SuggestionProvider.AMP
            case 2:
                return SuggestionProvider.POCKET
            case 3:
                return SuggestionProvider.WIKIPEDIA
            case 4:
                return SuggestionProvider.AMO
            case 5:
                return SuggestionProvider.YELP
            case 6:
                return SuggestionProvider.MDN
            case 7:
                return SuggestionProvider.WEATHER
            case 8:
                return SuggestionProvider.AMP_MOBILE
            default:
                return new Error("Unknown SuggestionProvider variant");
        }
    }

    static write(dataStream, value) {
        if (value === SuggestionProvider.AMP) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === SuggestionProvider.POCKET) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === SuggestionProvider.WIKIPEDIA) {
            dataStream.writeInt32(3);
            return;
        }
        if (value === SuggestionProvider.AMO) {
            dataStream.writeInt32(4);
            return;
        }
        if (value === SuggestionProvider.YELP) {
            dataStream.writeInt32(5);
            return;
        }
        if (value === SuggestionProvider.MDN) {
            dataStream.writeInt32(6);
            return;
        }
        if (value === SuggestionProvider.WEATHER) {
            dataStream.writeInt32(7);
            return;
        }
        if (value === SuggestionProvider.AMP_MOBILE) {
            dataStream.writeInt32(8);
            return;
        }
        return new Error("Unknown SuggestionProvider variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      if (!Number.isInteger(value) || value < 1 || value > 8) {
          throw new UniFFITypeError(`${value} is not a valid value for SuggestionProvider`);
      }
    }
}


// Export the FFIConverter object to make external types work.
export class FfiConverterOptionali32 extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterI32.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterI32.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterI32.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterI32.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalu64 extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterU64.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterU64.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterU64.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterU64.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalstring extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterString.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterString.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterString.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterString.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeSuggestProviderConfig extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeSuggestProviderConfig.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeSuggestProviderConfig.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeSuggestProviderConfig.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeSuggestProviderConfig.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalSequenceu8 extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterSequenceu8.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterSequenceu8.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterSequenceu8.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterSequenceu8.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeRemoteSettingsConfig extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeRemoteSettingsConfig.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeRemoteSettingsConfig.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeRemoteSettingsConfig.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeRemoteSettingsConfig.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceu8 extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterU8.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterU8.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterU8.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterU8.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeSuggestion extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeSuggestion.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeSuggestion.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeSuggestion.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeSuggestion.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeSuggestionProvider extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeSuggestionProvider.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeSuggestionProvider.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeSuggestionProvider.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeSuggestionProvider.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

import {
  FfiConverterTypeRemoteSettingsConfig,
  RemoteSettingsConfig,
} from "resource://gre/modules/RustRemoteSettings.sys.mjs";

// Export the FFIConverter object to make external types work.
export { FfiConverterTypeRemoteSettingsConfig, RemoteSettingsConfig };





export function rawSuggestionUrlMatches(rawUrl,url) {

        const liftResult = (result) => FfiConverterBool.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(rawUrl)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("rawUrl");
                }
                throw e;
            }
            try {
                FfiConverterString.checkType(url)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("url");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                16, // suggest:uniffi_suggest_fn_func_raw_suggestion_url_matches
                FfiConverterString.lower(rawUrl),
                FfiConverterString.lower(url),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
}
