// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!

import { UniFFITypeError } from "resource://gre/modules/UniFFI.sys.mjs";



// Objects intended to be used in the unit tests
export var UnitTestObjs = {};

// Write/Read data to/from an ArrayBuffer
class ArrayBufferDataStream {
    constructor(arrayBuffer) {
        this.dataView = new DataView(arrayBuffer);
        this.pos = 0;
    }

    readUint8() {
        let rv = this.dataView.getUint8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeUint8(value) {
        this.dataView.setUint8(this.pos, value);
        this.pos += 1;
    }

    readUint16() {
        let rv = this.dataView.getUint16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeUint16(value) {
        this.dataView.setUint16(this.pos, value);
        this.pos += 2;
    }

    readUint32() {
        let rv = this.dataView.getUint32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeUint32(value) {
        this.dataView.setUint32(this.pos, value);
        this.pos += 4;
    }

    readUint64() {
        let rv = this.dataView.getBigUint64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeUint64(value) {
        this.dataView.setBigUint64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readInt8() {
        let rv = this.dataView.getInt8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeInt8(value) {
        this.dataView.setInt8(this.pos, value);
        this.pos += 1;
    }

    readInt16() {
        let rv = this.dataView.getInt16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeInt16(value) {
        this.dataView.setInt16(this.pos, value);
        this.pos += 2;
    }

    readInt32() {
        let rv = this.dataView.getInt32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeInt32(value) {
        this.dataView.setInt32(this.pos, value);
        this.pos += 4;
    }

    readInt64() {
        let rv = this.dataView.getBigInt64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeInt64(value) {
        this.dataView.setBigInt64(this.pos, BigInt(value));
        this.pos += 8;
    }

    readFloat32() {
        let rv = this.dataView.getFloat32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeFloat32(value) {
        this.dataView.setFloat32(this.pos, value);
        this.pos += 4;
    }

    readFloat64() {
        let rv = this.dataView.getFloat64(this.pos);
        this.pos += 8;
        return rv;
    }

    writeFloat64(value) {
        this.dataView.setFloat64(this.pos, value);
        this.pos += 8;
    }


    writeString(value) {
      const encoder = new TextEncoder();
      // Note: in order to efficiently write this data, we first write the
      // string data, reserving 4 bytes for the size.
      const dest = new Uint8Array(this.dataView.buffer, this.pos + 4);
      const encodeResult = encoder.encodeInto(value, dest);
      if (encodeResult.read != value.length) {
        throw new UniFFIError(
            "writeString: out of space when writing to ArrayBuffer.  Did the computeSize() method returned the wrong result?"
        );
      }
      const size = encodeResult.written;
      // Next, go back and write the size before the string data
      this.dataView.setUint32(this.pos, size);
      // Finally, advance our position past both the size and string data
      this.pos += size + 4;
    }

    readString() {
      const decoder = new TextDecoder();
      const size = this.readUint32();
      const source = new Uint8Array(this.dataView.buffer, this.pos, size)
      const value = decoder.decode(source);
      this.pos += size;
      return value;
    }

    // Reads a TabsBridgedEngine pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerTabsBridgedEngine() {
        const pointerId = 4; // tabs:TabsBridgedEngine
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a TabsBridgedEngine pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerTabsBridgedEngine(value) {
        const pointerId = 4; // tabs:TabsBridgedEngine
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    

    // Reads a TabsStore pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerTabsStore() {
        const pointerId = 5; // tabs:TabsStore
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a TabsStore pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerTabsStore(value) {
        const pointerId = 5; // tabs:TabsStore
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    
}

function handleRustResult(result, liftCallback, liftErrCallback) {
    switch (result.code) {
        case "success":
            return liftCallback(result.data);

        case "error":
            throw liftErrCallback(result.data);

        case "internal-error":
            let message = result.internalErrorMessage;
            if (message) {
                throw new UniFFIInternalError(message);
            } else {
                throw new UniFFIInternalError("Unknown error");
            }

        default:
            throw new UniFFIError(`Unexpected status code: ${result.code}`);
    }
}

class UniFFIError {
    constructor(message) {
        this.message = message;
    }

    toString() {
        return `UniFFIError: ${this.message}`
    }
}

class UniFFIInternalError extends UniFFIError {}

// Base class for FFI converters
class FfiConverter {
    // throw `UniFFITypeError` if a value to be converted has an invalid type
    static checkType(value) {
        if (value === undefined ) {
            throw new UniFFITypeError(`undefined`);
        }
        if (value === null ) {
            throw new UniFFITypeError(`null`);
        }
    }
}

// Base class for FFI converters that lift/lower by reading/writing to an ArrayBuffer
class FfiConverterArrayBuffer extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }

    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
}

// Symbols that are used to ensure that Object constructors
// can only be used with a proper UniFFI pointer
const uniffiObjectPtr = Symbol("uniffiObjectPtr");
const constructUniffiObject = Symbol("constructUniffiObject");
UnitTestObjs.uniffiObjectPtr = uniffiObjectPtr;

// Export the FFIConverter object to make external types work.
export class FfiConverterI64 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isSafeInteger(value)) {
            throw new UniFFITypeError(`${value} exceeds the safe integer bounds`);
        }
    }
    static computeSize() {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt64(value)
    }
    static read(dataStream) {
        return dataStream.readInt64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterBool extends FfiConverter {
    static computeSize() {
        return 1;
    }
    static lift(value) {
        return value == 1;
    }
    static lower(value) {
        if (value) {
            return 1;
        } else {
            return 0;
        }
    }
    static write(dataStream, value) {
        dataStream.writeUint8(this.lower(value))
    }
    static read(dataStream) {
        return this.lift(dataStream.readUint8())
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterString extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (typeof value !== "string") {
            throw new UniFFITypeError(`${value} is not a string`);
        }
    }

    static lift(buf) {
        const decoder = new TextDecoder();
        const utf8Arr = new Uint8Array(buf);
        return decoder.decode(utf8Arr);
    }
    static lower(value) {
        const encoder = new TextEncoder();
        return encoder.encode(value).buffer;
    }

    static write(dataStream, value) {
        dataStream.writeString(value);
    }

    static read(dataStream) {
        return dataStream.readString();
    }

    static computeSize(value) {
        const encoder = new TextEncoder();
        return 4 + encoder.encode(value).length
    }
}

export class TabsBridgedEngine {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }

    apply() {
        const liftResult = (result) => FfiConverterSequencestring.lift(result);
        const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                31, // tabs:uniffi_tabs_fn_method_tabsbridgedengine_apply
                FfiConverterTypeTabsBridgedEngine.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    ensureCurrentSyncId(newSyncId) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterString.checkType(newSyncId)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("newSyncId");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                32, // tabs:uniffi_tabs_fn_method_tabsbridgedengine_ensure_current_sync_id
                FfiConverterTypeTabsBridgedEngine.lower(this),
                FfiConverterString.lower(newSyncId),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    lastSync() {
        const liftResult = (result) => FfiConverterI64.lift(result);
        const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                33, // tabs:uniffi_tabs_fn_method_tabsbridgedengine_last_sync
                FfiConverterTypeTabsBridgedEngine.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    prepareForSync(clientData) {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterString.checkType(clientData)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("clientData");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                34, // tabs:uniffi_tabs_fn_method_tabsbridgedengine_prepare_for_sync
                FfiConverterTypeTabsBridgedEngine.lower(this),
                FfiConverterString.lower(clientData),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    reset() {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                35, // tabs:uniffi_tabs_fn_method_tabsbridgedengine_reset
                FfiConverterTypeTabsBridgedEngine.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    resetSyncId() {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                36, // tabs:uniffi_tabs_fn_method_tabsbridgedengine_reset_sync_id
                FfiConverterTypeTabsBridgedEngine.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    setLastSync(lastSync) {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterI64.checkType(lastSync)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("lastSync");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                37, // tabs:uniffi_tabs_fn_method_tabsbridgedengine_set_last_sync
                FfiConverterTypeTabsBridgedEngine.lower(this),
                FfiConverterI64.lower(lastSync),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    setUploaded(newTimestamp,uploadedIds) {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterI64.checkType(newTimestamp)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("newTimestamp");
                }
                throw e;
            }
            try {
                FfiConverterSequenceTypeTabsGuid.checkType(uploadedIds)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("uploadedIds");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                38, // tabs:uniffi_tabs_fn_method_tabsbridgedengine_set_uploaded
                FfiConverterTypeTabsBridgedEngine.lower(this),
                FfiConverterI64.lower(newTimestamp),
                FfiConverterSequenceTypeTabsGuid.lower(uploadedIds),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    storeIncoming(incomingEnvelopesAsJson) {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterSequencestring.checkType(incomingEnvelopesAsJson)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("incomingEnvelopesAsJson");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                39, // tabs:uniffi_tabs_fn_method_tabsbridgedengine_store_incoming
                FfiConverterTypeTabsBridgedEngine.lower(this),
                FfiConverterSequencestring.lower(incomingEnvelopesAsJson),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    syncFinished() {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                40, // tabs:uniffi_tabs_fn_method_tabsbridgedengine_sync_finished
                FfiConverterTypeTabsBridgedEngine.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    syncId() {
        const liftResult = (result) => FfiConverterOptionalstring.lift(result);
        const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                41, // tabs:uniffi_tabs_fn_method_tabsbridgedengine_sync_id
                FfiConverterTypeTabsBridgedEngine.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    syncStarted() {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                42, // tabs:uniffi_tabs_fn_method_tabsbridgedengine_sync_started
                FfiConverterTypeTabsBridgedEngine.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    wipe() {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                43, // tabs:uniffi_tabs_fn_method_tabsbridgedengine_wipe
                FfiConverterTypeTabsBridgedEngine.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeTabsBridgedEngine extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new TabsBridgedEngine(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'TabsBridgedEngine' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerTabsBridgedEngine());
    }

    static write(dataStream, value) {
        dataStream.writePointerTabsBridgedEngine(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

export class TabsStore {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * An async constructor for TabsStore.
     * 
     * @returns {Promise<TabsStore>}: A promise that resolves
     *      to a newly constructed TabsStore
     */
    static init(path) {
        const liftResult = (result) => FfiConverterTypeTabsStore.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(path)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("path");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                45, // tabs:uniffi_tabs_fn_constructor_tabsstore_new
                FfiConverterString.lower(path),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }}

    bridgedEngine() {
        const liftResult = (result) => FfiConverterTypeTabsBridgedEngine.lift(result);
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                46, // tabs:uniffi_tabs_fn_method_tabsstore_bridged_engine
                FfiConverterTypeTabsStore.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    getAll() {
        const liftResult = (result) => FfiConverterSequenceTypeClientRemoteTabs.lift(result);
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                47, // tabs:uniffi_tabs_fn_method_tabsstore_get_all
                FfiConverterTypeTabsStore.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    registerWithSyncManager() {
        const liftResult = (result) => undefined;
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                48, // tabs:uniffi_tabs_fn_method_tabsstore_register_with_sync_manager
                FfiConverterTypeTabsStore.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    setLocalTabs(remoteTabs) {
        const liftResult = (result) => undefined;
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterSequenceTypeRemoteTabRecord.checkType(remoteTabs)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("remoteTabs");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                49, // tabs:uniffi_tabs_fn_method_tabsstore_set_local_tabs
                FfiConverterTypeTabsStore.lower(this),
                FfiConverterSequenceTypeRemoteTabRecord.lower(remoteTabs),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeTabsStore extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new TabsStore(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'TabsStore' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerTabsStore());
    }

    static write(dataStream, value) {
        dataStream.writePointerTabsStore(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

export class ClientRemoteTabs {
    constructor({ clientId, clientName, deviceType, lastModified, remoteTabs } = {}) {
        try {
            FfiConverterString.checkType(clientId)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("clientId");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(clientName)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("clientName");
            }
            throw e;
        }
        try {
            FfiConverterTypeDeviceType.checkType(deviceType)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("deviceType");
            }
            throw e;
        }
        try {
            FfiConverterI64.checkType(lastModified)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("lastModified");
            }
            throw e;
        }
        try {
            FfiConverterSequenceTypeRemoteTabRecord.checkType(remoteTabs)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("remoteTabs");
            }
            throw e;
        }
        this.clientId = clientId;
        this.clientName = clientName;
        this.deviceType = deviceType;
        this.lastModified = lastModified;
        this.remoteTabs = remoteTabs;
    }
    equals(other) {
        return (
            this.clientId == other.clientId &&
            this.clientName == other.clientName &&
            this.deviceType == other.deviceType &&
            this.lastModified == other.lastModified &&
            this.remoteTabs == other.remoteTabs
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeClientRemoteTabs extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new ClientRemoteTabs({
            clientId: FfiConverterString.read(dataStream),
            clientName: FfiConverterString.read(dataStream),
            deviceType: FfiConverterTypeDeviceType.read(dataStream),
            lastModified: FfiConverterI64.read(dataStream),
            remoteTabs: FfiConverterSequenceTypeRemoteTabRecord.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value.clientId);
        FfiConverterString.write(dataStream, value.clientName);
        FfiConverterTypeDeviceType.write(dataStream, value.deviceType);
        FfiConverterI64.write(dataStream, value.lastModified);
        FfiConverterSequenceTypeRemoteTabRecord.write(dataStream, value.remoteTabs);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterString.computeSize(value.clientId);
        totalSize += FfiConverterString.computeSize(value.clientName);
        totalSize += FfiConverterTypeDeviceType.computeSize(value.deviceType);
        totalSize += FfiConverterI64.computeSize(value.lastModified);
        totalSize += FfiConverterSequenceTypeRemoteTabRecord.computeSize(value.remoteTabs);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof ClientRemoteTabs)) {
            throw new UniFFITypeError(`Expected 'ClientRemoteTabs', found '${typeof value}'`);
        }
        try {
            FfiConverterString.checkType(value.clientId);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".clientId");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(value.clientName);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".clientName");
            }
            throw e;
        }
        try {
            FfiConverterTypeDeviceType.checkType(value.deviceType);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".deviceType");
            }
            throw e;
        }
        try {
            FfiConverterI64.checkType(value.lastModified);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".lastModified");
            }
            throw e;
        }
        try {
            FfiConverterSequenceTypeRemoteTabRecord.checkType(value.remoteTabs);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".remoteTabs");
            }
            throw e;
        }
    }
}

export class RemoteTabRecord {
    constructor({ title, urlHistory, icon, lastUsed, inactive = false } = {}) {
        try {
            FfiConverterString.checkType(title)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("title");
            }
            throw e;
        }
        try {
            FfiConverterSequencestring.checkType(urlHistory)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("urlHistory");
            }
            throw e;
        }
        try {
            FfiConverterOptionalstring.checkType(icon)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("icon");
            }
            throw e;
        }
        try {
            FfiConverterI64.checkType(lastUsed)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("lastUsed");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(inactive)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("inactive");
            }
            throw e;
        }
        this.title = title;
        this.urlHistory = urlHistory;
        this.icon = icon;
        this.lastUsed = lastUsed;
        this.inactive = inactive;
    }
    equals(other) {
        return (
            this.title == other.title &&
            this.urlHistory == other.urlHistory &&
            this.icon == other.icon &&
            this.lastUsed == other.lastUsed &&
            this.inactive == other.inactive
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeRemoteTabRecord extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new RemoteTabRecord({
            title: FfiConverterString.read(dataStream),
            urlHistory: FfiConverterSequencestring.read(dataStream),
            icon: FfiConverterOptionalstring.read(dataStream),
            lastUsed: FfiConverterI64.read(dataStream),
            inactive: FfiConverterBool.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value.title);
        FfiConverterSequencestring.write(dataStream, value.urlHistory);
        FfiConverterOptionalstring.write(dataStream, value.icon);
        FfiConverterI64.write(dataStream, value.lastUsed);
        FfiConverterBool.write(dataStream, value.inactive);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterString.computeSize(value.title);
        totalSize += FfiConverterSequencestring.computeSize(value.urlHistory);
        totalSize += FfiConverterOptionalstring.computeSize(value.icon);
        totalSize += FfiConverterI64.computeSize(value.lastUsed);
        totalSize += FfiConverterBool.computeSize(value.inactive);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof RemoteTabRecord)) {
            throw new UniFFITypeError(`Expected 'RemoteTabRecord', found '${typeof value}'`);
        }
        try {
            FfiConverterString.checkType(value.title);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".title");
            }
            throw e;
        }
        try {
            FfiConverterSequencestring.checkType(value.urlHistory);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".urlHistory");
            }
            throw e;
        }
        try {
            FfiConverterOptionalstring.checkType(value.icon);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".icon");
            }
            throw e;
        }
        try {
            FfiConverterI64.checkType(value.lastUsed);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".lastUsed");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(value.inactive);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".inactive");
            }
            throw e;
        }
    }
}




export class TabsApiError extends Error {}


export class SyncError extends TabsApiError {

    constructor(
        reason,
        ...params
    ) {
        super(...params);
        this.reason = reason;
    }
    toString() {
        return `SyncError: ${super.toString()}`
    }
}

export class SqlError extends TabsApiError {

    constructor(
        reason,
        ...params
    ) {
        super(...params);
        this.reason = reason;
    }
    toString() {
        return `SqlError: ${super.toString()}`
    }
}

export class UnexpectedTabsError extends TabsApiError {

    constructor(
        reason,
        ...params
    ) {
        super(...params);
        this.reason = reason;
    }
    toString() {
        return `UnexpectedTabsError: ${super.toString()}`
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeTabsApiError extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new SyncError(
                    FfiConverterString.read(dataStream)
                    );
            case 2:
                return new SqlError(
                    FfiConverterString.read(dataStream)
                    );
            case 3:
                return new UnexpectedTabsError(
                    FfiConverterString.read(dataStream)
                    );
            default:
                throw new UniFFITypeError("Unknown TabsApiError variant");
        }
    }
    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof SyncError) {
            totalSize += FfiConverterString.computeSize(value.reason);
            return totalSize;
        }
        if (value instanceof SqlError) {
            totalSize += FfiConverterString.computeSize(value.reason);
            return totalSize;
        }
        if (value instanceof UnexpectedTabsError) {
            totalSize += FfiConverterString.computeSize(value.reason);
            return totalSize;
        }
        throw new UniFFITypeError("Unknown TabsApiError variant");
    }
    static write(dataStream, value) {
        if (value instanceof SyncError) {
            dataStream.writeInt32(1);
            FfiConverterString.write(dataStream, value.reason);
            return;
        }
        if (value instanceof SqlError) {
            dataStream.writeInt32(2);
            FfiConverterString.write(dataStream, value.reason);
            return;
        }
        if (value instanceof UnexpectedTabsError) {
            dataStream.writeInt32(3);
            FfiConverterString.write(dataStream, value.reason);
            return;
        }
        throw new UniFFITypeError("Unknown TabsApiError variant");
    }

    static errorClass = TabsApiError;
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalstring extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterString.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterString.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterString.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterString.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequencestring extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterString.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterString.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterString.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterString.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeClientRemoteTabs extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeClientRemoteTabs.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeClientRemoteTabs.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeClientRemoteTabs.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeClientRemoteTabs.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeRemoteTabRecord extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeRemoteTabRecord.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeRemoteTabRecord.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeRemoteTabRecord.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeRemoteTabRecord.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeTabsGuid extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeTabsGuid.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeTabsGuid.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeTabsGuid.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeTabsGuid.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

import {
  FfiConverterTypeDeviceType,
  DeviceType,
} from "resource://gre/modules/RustSync15.sys.mjs";

// Export the FFIConverter object to make external types work.
export { FfiConverterTypeDeviceType, DeviceType };

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeTabsGuid extends FfiConverter {
    static lift(buf) {
        return FfiConverterString.lift(buf);    
    }
    
    static lower(buf) {
        return FfiConverterString.lower(buf);
    }
    
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value);
    } 
    
    static read(buf) {
        return FfiConverterString.read(buf);
    }
    
    static computeSize(value) {
        return FfiConverterString.computeSize(value);
    }
}
// TODO: We should also allow JS to customize the type eventually.




