/* Generated by wayland-scanner 1.19.0 */

#ifndef XDG_DBUS_ANNOTATION_V1_CLIENT_PROTOCOL_H
#define XDG_DBUS_ANNOTATION_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @page page_xdg_dbus_annotation_v1 The xdg_dbus_annotation_v1 protocol
 * Wayland protocol for associating DBus objects with toplevels
 *
 * @section page_desc_xdg_dbus_annotation_v1 Description
 *
 * This description provides a high-level overview of the interplay between
 * the interfaces defined in this protocol. For details, see the protocol
 * specification.
 *
 * The dbus_annotation_manager allows a client to request the creation of an
 * annotation object associated with an wl_surface or itself. The annotation
 * object allows a client to notify the compositor of a DBus object associated
 * with itself.
 *
 * Clients should request the creation of an dbus_annotation object when they
 * create a DBus object associated with an wl_surface or themselves, and should
 * release the object when they destroy a DBus object associated with their
 * wl_surface or themselves.
 *
 * Clients should only own at most one dbus_annotation object with a given name
 * for each of their wl_surface objects or themselves. A protocol error will be
 * raised if a client requests more than one dbus_annotation object for an
 * wl_surface or themselves with a given name.
 *
 * @section page_ifaces_xdg_dbus_annotation_v1 Interfaces
 * - @subpage page_iface_xdg_dbus_annotation_manager_v1 - controller object for
 * registering dbus objects associated with wl_surfaces or clients
 * - @subpage page_iface_xdg_dbus_annotation_v1 - controller object for
 * associating dbus objects with an wl_surface
 * @section page_copyright_xdg_dbus_annotation_v1 Copyright
 * <pre>
 *
 * Copyright © 2017 David Edmundson
 * Copyrihgt © 2023 Janet Blackquill
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct xdg_dbus_annotation_manager_v1;
struct xdg_dbus_annotation_v1;

#ifndef XDG_DBUS_ANNOTATION_MANAGER_V1_INTERFACE
#  define XDG_DBUS_ANNOTATION_MANAGER_V1_INTERFACE
/**
 * @page page_iface_xdg_dbus_annotation_manager_v1
 * xdg_dbus_annotation_manager_v1
 * @section page_iface_xdg_dbus_annotation_manager_v1_desc Description
 *
 * An object that provides access to the creation of dbus_annotation objects.
 * @section page_iface_xdg_dbus_annotation_manager_v1_api API
 * See @ref iface_xdg_dbus_annotation_manager_v1.
 */
/**
 * @defgroup iface_xdg_dbus_annotation_manager_v1 The
 * xdg_dbus_annotation_manager_v1 interface
 *
 * An object that provides access to the creation of dbus_annotation objects.
 */
extern const struct wl_interface xdg_dbus_annotation_manager_v1_interface;
#endif
#ifndef XDG_DBUS_ANNOTATION_V1_INTERFACE
#  define XDG_DBUS_ANNOTATION_V1_INTERFACE
/**
 * @page page_iface_xdg_dbus_annotation_v1 xdg_dbus_annotation_v1
 * @section page_iface_xdg_dbus_annotation_v1_desc Description
 *
 * An object that provides access to clients to notify the compositor of
 * associated DBus objects for an wl_surface.
 *
 * If not applicable, clients should remove this object.
 * @section page_iface_xdg_dbus_annotation_v1_api API
 * See @ref iface_xdg_dbus_annotation_v1.
 */
/**
 * @defgroup iface_xdg_dbus_annotation_v1 The xdg_dbus_annotation_v1 interface
 *
 * An object that provides access to clients to notify the compositor of
 * associated DBus objects for an wl_surface.
 *
 * If not applicable, clients should remove this object.
 */
extern const struct wl_interface xdg_dbus_annotation_v1_interface;
#endif

#ifndef XDG_DBUS_ANNOTATION_MANAGER_V1_ERROR_ENUM
#  define XDG_DBUS_ANNOTATION_MANAGER_V1_ERROR_ENUM
enum xdg_dbus_annotation_manager_v1_error {
  /**
   * given wl_surface or client already has a dbus_annotation with the same
   * interface
   */
  XDG_DBUS_ANNOTATION_MANAGER_V1_ERROR_ALREADY_ANNOTATED = 0,
  /**
   * given wl_surface is invalid
   */
  XDG_DBUS_ANNOTATION_MANAGER_V1_ERROR_BAD_TARGET = 1,
};
#endif /* XDG_DBUS_ANNOTATION_MANAGER_V1_ERROR_ENUM */

#define XDG_DBUS_ANNOTATION_MANAGER_V1_DESTROY 0
#define XDG_DBUS_ANNOTATION_MANAGER_V1_CREATE_CLIENT 1
#define XDG_DBUS_ANNOTATION_MANAGER_V1_CREATE_SURFACE 2

/**
 * @ingroup iface_xdg_dbus_annotation_manager_v1
 */
#define XDG_DBUS_ANNOTATION_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_dbus_annotation_manager_v1
 */
#define XDG_DBUS_ANNOTATION_MANAGER_V1_CREATE_CLIENT_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_dbus_annotation_manager_v1
 */
#define XDG_DBUS_ANNOTATION_MANAGER_V1_CREATE_SURFACE_SINCE_VERSION 1

/** @ingroup iface_xdg_dbus_annotation_manager_v1 */
static inline void xdg_dbus_annotation_manager_v1_set_user_data(
    struct xdg_dbus_annotation_manager_v1* xdg_dbus_annotation_manager_v1,
    void* user_data) {
  wl_proxy_set_user_data((struct wl_proxy*)xdg_dbus_annotation_manager_v1,
                         user_data);
}

/** @ingroup iface_xdg_dbus_annotation_manager_v1 */
static inline void* xdg_dbus_annotation_manager_v1_get_user_data(
    struct xdg_dbus_annotation_manager_v1* xdg_dbus_annotation_manager_v1) {
  return wl_proxy_get_user_data(
      (struct wl_proxy*)xdg_dbus_annotation_manager_v1);
}

static inline uint32_t xdg_dbus_annotation_manager_v1_get_version(
    struct xdg_dbus_annotation_manager_v1* xdg_dbus_annotation_manager_v1) {
  return wl_proxy_get_version((struct wl_proxy*)xdg_dbus_annotation_manager_v1);
}

/**
 * @ingroup iface_xdg_dbus_annotation_manager_v1
 *
 * Destroy the xdg_dbus_annotation_manager object. xdg_dbus_annotation objects
 * created from this object remain valid and should be destroyed separately.
 */
static inline void xdg_dbus_annotation_manager_v1_destroy(
    struct xdg_dbus_annotation_manager_v1* xdg_dbus_annotation_manager_v1) {
  wl_proxy_marshal((struct wl_proxy*)xdg_dbus_annotation_manager_v1,
                   XDG_DBUS_ANNOTATION_MANAGER_V1_DESTROY);

  wl_proxy_destroy((struct wl_proxy*)xdg_dbus_annotation_manager_v1);
}

/**
 * @ingroup iface_xdg_dbus_annotation_manager_v1
 *
 * The interface other DBus clients can expect the object specified by the
 * annotation to implement.
 */
static inline struct xdg_dbus_annotation_v1*
xdg_dbus_annotation_manager_v1_create_client(
    struct xdg_dbus_annotation_manager_v1* xdg_dbus_annotation_manager_v1,
    const char* interface) {
  struct wl_proxy* id;

  id = wl_proxy_marshal_constructor(
      (struct wl_proxy*)xdg_dbus_annotation_manager_v1,
      XDG_DBUS_ANNOTATION_MANAGER_V1_CREATE_CLIENT,
      &xdg_dbus_annotation_v1_interface, interface, NULL);

  return (struct xdg_dbus_annotation_v1*)id;
}

/**
 * @ingroup iface_xdg_dbus_annotation_manager_v1
 *
 * The surface to associate the annotation with
 */
static inline struct xdg_dbus_annotation_v1*
xdg_dbus_annotation_manager_v1_create_surface(
    struct xdg_dbus_annotation_manager_v1* xdg_dbus_annotation_manager_v1,
    const char* interface, struct wl_surface* toplevel) {
  struct wl_proxy* id;

  id = wl_proxy_marshal_constructor(
      (struct wl_proxy*)xdg_dbus_annotation_manager_v1,
      XDG_DBUS_ANNOTATION_MANAGER_V1_CREATE_SURFACE,
      &xdg_dbus_annotation_v1_interface, interface, NULL, toplevel);

  return (struct xdg_dbus_annotation_v1*)id;
}

#define XDG_DBUS_ANNOTATION_V1_DESTROY 0
#define XDG_DBUS_ANNOTATION_V1_SET_ADDRESS 1

/**
 * @ingroup iface_xdg_dbus_annotation_v1
 */
#define XDG_DBUS_ANNOTATION_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_dbus_annotation_v1
 */
#define XDG_DBUS_ANNOTATION_V1_SET_ADDRESS_SINCE_VERSION 1

/** @ingroup iface_xdg_dbus_annotation_v1 */
static inline void xdg_dbus_annotation_v1_set_user_data(
    struct xdg_dbus_annotation_v1* xdg_dbus_annotation_v1, void* user_data) {
  wl_proxy_set_user_data((struct wl_proxy*)xdg_dbus_annotation_v1, user_data);
}

/** @ingroup iface_xdg_dbus_annotation_v1 */
static inline void* xdg_dbus_annotation_v1_get_user_data(
    struct xdg_dbus_annotation_v1* xdg_dbus_annotation_v1) {
  return wl_proxy_get_user_data((struct wl_proxy*)xdg_dbus_annotation_v1);
}

static inline uint32_t xdg_dbus_annotation_v1_get_version(
    struct xdg_dbus_annotation_v1* xdg_dbus_annotation_v1) {
  return wl_proxy_get_version((struct wl_proxy*)xdg_dbus_annotation_v1);
}

/**
 * @ingroup iface_xdg_dbus_annotation_v1
 */
static inline void xdg_dbus_annotation_v1_destroy(
    struct xdg_dbus_annotation_v1* xdg_dbus_annotation_v1) {
  wl_proxy_marshal((struct wl_proxy*)xdg_dbus_annotation_v1,
                   XDG_DBUS_ANNOTATION_V1_DESTROY);

  wl_proxy_destroy((struct wl_proxy*)xdg_dbus_annotation_v1);
}

/**
 * @ingroup iface_xdg_dbus_annotation_v1
 *
 * Set or update the service name and object path corresponding to the
 * DBus object. The DBus object should be registered on the session bus
 * before sending this request.
 *
 * Strings should be formatted in Latin-1 matching the relevant DBus
 * specifications.
 */
static inline void xdg_dbus_annotation_v1_set_address(
    struct xdg_dbus_annotation_v1* xdg_dbus_annotation_v1,
    const char* service_name, const char* object_path) {
  wl_proxy_marshal((struct wl_proxy*)xdg_dbus_annotation_v1,
                   XDG_DBUS_ANNOTATION_V1_SET_ADDRESS, service_name,
                   object_path);
}

#ifdef __cplusplus
}
#endif

#endif
