add_task(async function setup_pref() {
  await SpecialPowers.pushPrefEnv({
    set: [
      // To avoid throttling requestAnimationFrame callbacks in invisible
      // iframes
      ["layout.throttled_frame_rate", 60],
      // Next two prefs are needed for hit-testing to work
      ["test.events.async.enabled", true],
      ["apz.test.logging_enabled", true],
    ],
  });
});

add_task(async function test_main() {
  function httpURL(filename) {
    let chromeURL = getRootDirectory(gTestPath) + filename;
    return chromeURL.replace(
      "chrome://mochitests/content/",
      "http://mochi.test:8888/"
    );
  }

  // Each of these subtests is a dictionary that contains:
  // file (required): filename of the subtest that will get opened in a new tab
  //   in the top-level fission-enabled browser window.
  // setup (optional): function that takes the top-level fission window and is
  //   run once after the subtest is loaded but before it is started.
  var subtests = [
    {
      file: "helper_fission_event_region_override.html",
      setup(win) {
        win.document.addEventListener("wheel", e => e.preventDefault(), {
          once: true,
          passive: false,
        });
      },
    },
    { file: "helper_fission_initial_displayport.html" },
    // add additional tests here
  ];

  // ccov builds run slower and need longer, so let's scale up the timeout
  // by the number of tests we're running.
  requestLongerTimeout(subtests.length);

  let fissionWindow = await BrowserTestUtils.openNewBrowserWindow({
    fission: true,
  });

  // We import the ESM here so that we can install functions on the class
  // below.
  const { FissionTestHelperParent } = ChromeUtils.importESModule(
    getRootDirectory(gTestPath) + "FissionTestHelperParent.sys.mjs"
  );
  FissionTestHelperParent.SimpleTest = SimpleTest;

  ChromeUtils.registerWindowActor("FissionTestHelper", {
    parent: {
      esModuleURI:
        getRootDirectory(gTestPath) + "FissionTestHelperParent.sys.mjs",
    },
    child: {
      esModuleURI:
        getRootDirectory(gTestPath) + "FissionTestHelperChild.sys.mjs",
      events: {
        "FissionTestHelper:Init": { capture: true, wantUntrusted: true },
      },
    },
    allFrames: true,
  });

  try {
    var onlyOneSubtest = SpecialPowers.getCharPref(
      "apz.subtest",
      /*default = */ ""
    );

    for (var subtest of subtests) {
      if (onlyOneSubtest && onlyOneSubtest != subtest.file) {
        SimpleTest.ok(
          true,
          "Skipping " +
            subtest.file +
            " because only " +
            onlyOneSubtest +
            " is being run"
        );
        continue;
      }
      let url = httpURL(subtest.file);
      dump(`Starting test ${url}\n`);

      // Load the test URL and tell it to get started, and wait until it reports
      // completion.
      await BrowserTestUtils.withNewTab(
        { gBrowser: fissionWindow.gBrowser, url },
        async browser => {
          let tabActor =
            browser.browsingContext.currentWindowGlobal.getActor(
              "FissionTestHelper"
            );
          let donePromise = tabActor.getTestCompletePromise();
          if (subtest.setup) {
            subtest.setup(fissionWindow);
          }
          tabActor.startTest();
          await donePromise;
        }
      );

      dump(`Finished test ${url}\n`);
    }
  } finally {
    // Delete stuff we added to FissionTestHelperParent, beacuse the object will
    // outlive this test, and leaving stuff on it may leak the things reachable
    // from it.
    delete FissionTestHelperParent.SimpleTest;
    // Teardown
    ChromeUtils.unregisterWindowActor("FissionTestHelper");
    await BrowserTestUtils.closeWindow(fissionWindow);
  }
});
