// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!

import { UniFFITypeError } from "resource://gre/modules/UniFFI.sys.mjs";



// Objects intended to be used in the unit tests
export var UnitTestObjs = {};

// Write/Read data to/from an ArrayBuffer
class ArrayBufferDataStream {
    constructor(arrayBuffer) {
        this.dataView = new DataView(arrayBuffer);
        this.pos = 0;
    }

    readUint8() {
        let rv = this.dataView.getUint8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeUint8(value) {
        this.dataView.setUint8(this.pos, value);
        this.pos += 1;
    }

    readUint16() {
        let rv = this.dataView.getUint16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeUint16(value) {
        this.dataView.setUint16(this.pos, value);
        this.pos += 2;
    }

    readUint32() {
        let rv = this.dataView.getUint32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeUint32(value) {
        this.dataView.setUint32(this.pos, value);
        this.pos += 4;
    }

    readUint64() {
        let rv = this.dataView.getBigUint64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeUint64(value) {
        this.dataView.setBigUint64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readInt8() {
        let rv = this.dataView.getInt8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeInt8(value) {
        this.dataView.setInt8(this.pos, value);
        this.pos += 1;
    }

    readInt16() {
        let rv = this.dataView.getInt16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeInt16(value) {
        this.dataView.setInt16(this.pos, value);
        this.pos += 2;
    }

    readInt32() {
        let rv = this.dataView.getInt32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeInt32(value) {
        this.dataView.setInt32(this.pos, value);
        this.pos += 4;
    }

    readInt64() {
        let rv = this.dataView.getBigInt64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeInt64(value) {
        this.dataView.setBigInt64(this.pos, BigInt(value));
        this.pos += 8;
    }

    readFloat32() {
        let rv = this.dataView.getFloat32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeFloat32(value) {
        this.dataView.setFloat32(this.pos, value);
        this.pos += 4;
    }

    readFloat64() {
        let rv = this.dataView.getFloat64(this.pos);
        this.pos += 8;
        return rv;
    }

    writeFloat64(value) {
        this.dataView.setFloat64(this.pos, value);
        this.pos += 8;
    }


    writeString(value) {
      const encoder = new TextEncoder();
      // Note: in order to efficiently write this data, we first write the
      // string data, reserving 4 bytes for the size.
      const dest = new Uint8Array(this.dataView.buffer, this.pos + 4);
      const encodeResult = encoder.encodeInto(value, dest);
      if (encodeResult.read != value.length) {
        throw new UniFFIError(
            "writeString: out of space when writing to ArrayBuffer.  Did the computeSize() method returned the wrong result?"
        );
      }
      const size = encodeResult.written;
      // Next, go back and write the size before the string data
      this.dataView.setUint32(this.pos, size);
      // Finally, advance our position past both the size and string data
      this.pos += size + 4;
    }

    readString() {
      const decoder = new TextDecoder();
      const size = this.readUint32();
      const source = new Uint8Array(this.dataView.buffer, this.pos, size)
      const value = decoder.decode(source);
      this.pos += size;
      return value;
    }

    readBytes() {
      const size = this.readInt32();
      const bytes = new Uint8Array(this.dataView.buffer, this.pos, size);
      this.pos += size;
      return bytes
    }

    writeBytes(uint8Array) {
      this.writeUint32(uint8Array.length);
      value.forEach((elt) => {
        dataStream.writeUint8(elt);
      })
    }

    // Reads a FutureTester pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerFutureTester() {
        const pointerId = 11; // futures:FutureTester
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a FutureTester pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerFutureTester(value) {
        const pointerId = 11; // futures:FutureTester
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    

    // Reads a RustTask pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerRustTask() {
        const pointerId = 12; // futures:RustTask
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a RustTask pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerRustTask(value) {
        const pointerId = 12; // futures:RustTask
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    

    // Reads a Traveller pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerTraveller() {
        const pointerId = 13; // futures:Traveller
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a Traveller pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerTraveller(value) {
        const pointerId = 13; // futures:Traveller
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    

    // Reads a WorkerQueue pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerWorkerQueue() {
        const pointerId = 14; // futures:WorkerQueue
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a WorkerQueue pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerWorkerQueue(value) {
        const pointerId = 14; // futures:WorkerQueue
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    
}

function handleRustResult(result, liftCallback, liftErrCallback) {
    switch (result.code) {
        case "success":
            return liftCallback(result.data);

        case "error":
            throw liftErrCallback(result.data);

        case "internal-error":
            if (result.data) {
                throw new UniFFIInternalError(FfiConverterString.lift(result.data));
            } else {
                throw new UniFFIInternalError("Unknown error");
            }

        default:
            throw new UniFFIError(`Unexpected status code: ${result.code}`);
    }
}

class UniFFIError {
    constructor(message) {
        this.message = message;
    }

    toString() {
        return `UniFFIError: ${this.message}`
    }
}

class UniFFIInternalError extends UniFFIError {}

// Base class for FFI converters
class FfiConverter {
    // throw `UniFFITypeError` if a value to be converted has an invalid type
    static checkType(value) {
        if (value === undefined ) {
            throw new UniFFITypeError(`undefined`);
        }
        if (value === null ) {
            throw new UniFFITypeError(`null`);
        }
    }
}

// Base class for FFI converters that lift/lower by reading/writing to an ArrayBuffer
class FfiConverterArrayBuffer extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }

    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
}

// Symbols that are used to ensure that Object constructors
// can only be used with a proper UniFFI pointer
const uniffiObjectPtr = Symbol("uniffiObjectPtr");
const constructUniffiObject = Symbol("constructUniffiObject");
UnitTestObjs.uniffiObjectPtr = uniffiObjectPtr;

// Export the FFIConverter object to make external types work.
export class FfiConverterU8 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < 0 || value > 256) {
            throw new UniFFITypeError(`${value} exceeds the U8 bounds`);
        }
    }
    static computeSize() {
        return 1;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint8(value)
    }
    static read(dataStream) {
        return dataStream.readUint8()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterI8 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < -128 || value > 127) {
            throw new UniFFITypeError(`${value} exceeds the I8 bounds`);
        }
    }
    static computeSize() {
        return 1;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt8(value)
    }
    static read(dataStream) {
        return dataStream.readInt8()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterU16 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < 0 || value > 65535) {
            throw new UniFFITypeError(`${value} exceeds the U16 bounds`);
        }
    }
    static computeSize() {
        return 2;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint16(value)
    }
    static read(dataStream) {
        return dataStream.readUint16()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterI16 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < -32768 || value > 32767) {
            throw new UniFFITypeError(`${value} exceeds the I16 bounds`);
        }
    }
    static computeSize() {
        return 2;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt16(value)
    }
    static read(dataStream) {
        return dataStream.readInt16()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterU32 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < 0 || value > 4294967295) {
            throw new UniFFITypeError(`${value} exceeds the U32 bounds`);
        }
    }
    static computeSize() {
        return 4;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint32(value)
    }
    static read(dataStream) {
        return dataStream.readUint32()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterI32 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < -2147483648 || value > 2147483647) {
            throw new UniFFITypeError(`${value} exceeds the I32 bounds`);
        }
    }
    static computeSize() {
        return 4;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt32(value)
    }
    static read(dataStream) {
        return dataStream.readInt32()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterU64 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isSafeInteger(value)) {
            throw new UniFFITypeError(`${value} exceeds the safe integer bounds`);
        }
        if (value < 0) {
            throw new UniFFITypeError(`${value} exceeds the U64 bounds`);
        }
    }
    static computeSize() {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint64(value)
    }
    static read(dataStream) {
        return dataStream.readUint64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterI64 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isSafeInteger(value)) {
            throw new UniFFITypeError(`${value} exceeds the safe integer bounds`);
        }
    }
    static computeSize() {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt64(value)
    }
    static read(dataStream) {
        return dataStream.readInt64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterF32 extends FfiConverter {
    static computeSize() {
        return 4;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeFloat32(value)
    }
    static read(dataStream) {
        return dataStream.readFloat32()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterF64 extends FfiConverter {
    static computeSize() {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeFloat64(value)
    }
    static read(dataStream) {
        return dataStream.readFloat64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterString extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (typeof value !== "string") {
            throw new UniFFITypeError(`${value} is not a string`);
        }
    }

    static lift(buf) {
        const decoder = new TextDecoder();
        const utf8Arr = new Uint8Array(buf);
        return decoder.decode(utf8Arr);
    }
    static lower(value) {
        const encoder = new TextEncoder();
        return encoder.encode(value).buffer;
    }

    static write(dataStream, value) {
        dataStream.writeString(value);
    }

    static read(dataStream) {
        return dataStream.readString();
    }

    static computeSize(value) {
        const encoder = new TextEncoder();
        return 4 + encoder.encode(value).length
    }
}

/**
 * FutureTester
 */
export class FutureTester {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * init
     * @returns {FutureTester}
     */
    static init() {
        const liftResult = (result) => FfiConverterTypeFutureTester.lift(result);
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callSync(
                122, // futures:uniffi_uniffi_fixture_futures_fn_constructor_futuretester_init
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);}

    /**
     * Store a value in all futures created via `make_future()`, then wake up any wakers.
     * This will cause the C++ code to poll the future and get a `Ready` result.
     *
     * Returns the number of futures completed
     * @returns {number}
     */
    completeFutures(value) {
        const liftResult = (result) => FfiConverterU32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU8.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                119, // futures:uniffi_uniffi_fixture_futures_fn_method_futuretester_complete_futures
                FfiConverterTypeFutureTester.lower(this),
                FfiConverterU8.lower(value),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

    /**
     * Make a new future that can be manipulated with the other FutureTester methods
     * @returns {Promise<number>}}
     */
    makeFuture() {
        const liftResult = (result) => FfiConverterU8.lift(result);
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                120, // futures:uniffi_uniffi_fixture_futures_fn_method_futuretester_make_future
                FfiConverterTypeFutureTester.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * Wake up the waker for all futures created via `make_future()`.  This will cause the C++
     * code to poll the future, but it will get another `Pending` result
     */
    wakeFutures() {
        const liftResult = (result) => undefined;
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callSync(
                121, // futures:uniffi_uniffi_fixture_futures_fn_method_futuretester_wake_futures
                FfiConverterTypeFutureTester.lower(this),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeFutureTester extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new FutureTester(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'FutureTester' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerFutureTester());
    }

    static write(dataStream, value) {
        dataStream.writePointerFutureTester(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

/**
 * RustTask
 */
export class RustTask {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }

    /**
     * run
     */
    run() {
        const liftResult = (result) => undefined;
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callSync(
                123, // futures:uniffi_uniffi_fixture_futures_fn_method_rusttask_run
                FfiConverterTypeRustTask.lower(this),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeRustTask extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new RustTask(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'RustTask' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerRustTask());
    }

    static write(dataStream, value) {
        dataStream.writePointerRustTask(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

/**
 * Traveller
 */
export class Traveller {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * init
     * @returns {Traveller}
     */
    static init(name) {
        const liftResult = (result) => FfiConverterTypeTraveller.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(name)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("name");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                125, // futures:uniffi_uniffi_fixture_futures_fn_constructor_traveller_new
                FfiConverterString.lower(name),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);}

    /**
     * name
     * @returns {string}
     */
    name() {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callSync(
                124, // futures:uniffi_uniffi_fixture_futures_fn_method_traveller_name
                FfiConverterTypeTraveller.lower(this),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeTraveller extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new Traveller(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'Traveller' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerTraveller());
    }

    static write(dataStream, value) {
        dataStream.writePointerTraveller(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

/**
 * Worker queue scheduler trait
 *
 * This is a trait that the foreign code implements to schedule Rust tasks in a worker queue.  On
 * Swift/Kotlin, we can implement this trait using a DispatchQueue/CoroutineContext.
 *
 * On JS we can't implement it directly, since JS is single-threaded and we don't want to start up
 * a web worker.  Instead, we implement the trait in Rust using `moz_task`.
 */
export class WorkerQueue {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }

    /**
     * addTask
     */
    addTask(task) {
        const liftResult = (result) => undefined;
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeRustTask.checkType(task)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("task");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                126, // futures:uniffi_uniffi_fixture_futures_fn_method_workerqueue_add_task
                FfiConverterTypeWorkerQueue.lower(this),
                FfiConverterTypeRustTask.lower(task),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeWorkerQueue extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new WorkerQueue(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'WorkerQueue' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerWorkerQueue());
    }

    static write(dataStream, value) {
        dataStream.writePointerWorkerQueue(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceu32 extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterU32.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterU32.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterU32.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterU32.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterMapStringString extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const map = {};
        for (let i = 0; i < len; i++) {
            const key = FfiConverterString.read(dataStream);
            const value = FfiConverterString.read(dataStream);
            map[key] = value;
        }

        return map;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(Object.keys(value).length);
        for (const key in value) {
            FfiConverterString.write(dataStream, key);
            FfiConverterString.write(dataStream, value[key]);
        }
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const key in value) {
            size += FfiConverterString.computeSize(key);
            size += FfiConverterString.computeSize(value[key]);
        }
        return size;
    }

    static checkType(value) {
        for (const key in value) {
            try {
                FfiConverterString.checkType(key);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("(key)");
                }
                throw e;
            }

            try {
                FfiConverterString.checkType(value[key]);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${key}]`);
                }
                throw e;
            }
        }
    }
}





/**
 * Function to test the global worker queue
 *
 * This is how Rust components can wrap synchronous tasks to present an async interface.
 * @returns {Promise<number>}}
 */
export function expensiveComputation() {

        const liftResult = (result) => FfiConverterU32.lift(result);
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                102, // futures:uniffi_uniffi_fixture_futures_fn_func_expensive_computation
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * Initialize the global worker for JS.
 *
 * All code above here is generalized task code that works for JS, Kotlin, and Swift.
 *
 * This function and the GeckoWorkerQueue struct are Gecko-specific.
 */
export function initializeGeckoGlobalWorkerQueue() {

        const liftResult = (result) => undefined;
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callSync(
                103, // futures:uniffi_uniffi_fixture_futures_fn_func_initialize_gecko_global_worker_queue
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
}

/**
 * Initialize the global worker queue.  The Rust code will use this schedule sync tasks in the
 * background in order to present an async interface.
 */
export function initializeGlobalWorkerQueue(workerQueue) {

        const liftResult = (result) => undefined;
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeWorkerQueue.checkType(workerQueue)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("workerQueue");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                104, // futures:uniffi_uniffi_fixture_futures_fn_func_initialize_global_worker_queue
                FfiConverterTypeWorkerQueue.lower(workerQueue),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
}

/**
 * roundtripF32
 * @returns {Promise<number>}}
 */
export function roundtripF32(v) {

        const liftResult = (result) => FfiConverterF32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterF32.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                105, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_f32
                FfiConverterF32.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * roundtripF64
 * @returns {Promise<number>}}
 */
export function roundtripF64(v) {

        const liftResult = (result) => FfiConverterF64.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterF64.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                106, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_f64
                FfiConverterF64.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * roundtripI16
 * @returns {Promise<number>}}
 */
export function roundtripI16(v) {

        const liftResult = (result) => FfiConverterI16.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI16.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                107, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_i16
                FfiConverterI16.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * roundtripI32
 * @returns {Promise<number>}}
 */
export function roundtripI32(v) {

        const liftResult = (result) => FfiConverterI32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI32.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                108, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_i32
                FfiConverterI32.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * roundtripI64
 * @returns {Promise<number>}}
 */
export function roundtripI64(v) {

        const liftResult = (result) => FfiConverterI64.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI64.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                109, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_i64
                FfiConverterI64.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * roundtripI8
 * @returns {Promise<number>}}
 */
export function roundtripI8(v) {

        const liftResult = (result) => FfiConverterI8.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI8.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                110, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_i8
                FfiConverterI8.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * roundtripMap
 * @returns {Promise<object>}}
 */
export function roundtripMap(v) {

        const liftResult = (result) => FfiConverterMapStringString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterMapStringString.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                111, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_map
                FfiConverterMapStringString.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * roundtripObj
 * @returns {Promise<Traveller>}}
 */
export function roundtripObj(v) {

        const liftResult = (result) => FfiConverterTypeTraveller.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeTraveller.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                112, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_obj
                FfiConverterTypeTraveller.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * roundtripString
 * @returns {Promise<string>}}
 */
export function roundtripString(v) {

        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                113, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_string
                FfiConverterString.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * roundtripU16
 * @returns {Promise<number>}}
 */
export function roundtripU16(v) {

        const liftResult = (result) => FfiConverterU16.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU16.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                114, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_u16
                FfiConverterU16.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * roundtripU32
 * @returns {Promise<number>}}
 */
export function roundtripU32(v) {

        const liftResult = (result) => FfiConverterU32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU32.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                115, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_u32
                FfiConverterU32.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * roundtripU64
 * @returns {Promise<number>}}
 */
export function roundtripU64(v) {

        const liftResult = (result) => FfiConverterU64.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU64.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                116, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_u64
                FfiConverterU64.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * roundtripU8
 * @returns {Promise<number>}}
 */
export function roundtripU8(v) {

        const liftResult = (result) => FfiConverterU8.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU8.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                117, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_u8
                FfiConverterU8.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * roundtripVec
 * @returns {Promise<Array.<number>>}}
 */
export function roundtripVec(v) {

        const liftResult = (result) => FfiConverterSequenceu32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterSequenceu32.checkType(v)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("v");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                118, // futures:uniffi_uniffi_fixture_futures_fn_func_roundtrip_vec
                FfiConverterSequenceu32.lower(v),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}
