// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!

import { UniFFITypeError } from "resource://gre/modules/UniFFI.sys.mjs";



// Objects intended to be used in the unit tests
export var UnitTestObjs = {};

// Write/Read data to/from an ArrayBuffer
class ArrayBufferDataStream {
    constructor(arrayBuffer) {
        this.dataView = new DataView(arrayBuffer);
        this.pos = 0;
    }

    readUint8() {
        let rv = this.dataView.getUint8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeUint8(value) {
        this.dataView.setUint8(this.pos, value);
        this.pos += 1;
    }

    readUint16() {
        let rv = this.dataView.getUint16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeUint16(value) {
        this.dataView.setUint16(this.pos, value);
        this.pos += 2;
    }

    readUint32() {
        let rv = this.dataView.getUint32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeUint32(value) {
        this.dataView.setUint32(this.pos, value);
        this.pos += 4;
    }

    readUint64() {
        let rv = this.dataView.getBigUint64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeUint64(value) {
        this.dataView.setBigUint64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readInt8() {
        let rv = this.dataView.getInt8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeInt8(value) {
        this.dataView.setInt8(this.pos, value);
        this.pos += 1;
    }

    readInt16() {
        let rv = this.dataView.getInt16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeInt16(value) {
        this.dataView.setInt16(this.pos, value);
        this.pos += 2;
    }

    readInt32() {
        let rv = this.dataView.getInt32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeInt32(value) {
        this.dataView.setInt32(this.pos, value);
        this.pos += 4;
    }

    readInt64() {
        let rv = this.dataView.getBigInt64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeInt64(value) {
        this.dataView.setBigInt64(this.pos, BigInt(value));
        this.pos += 8;
    }

    readFloat32() {
        let rv = this.dataView.getFloat32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeFloat32(value) {
        this.dataView.setFloat32(this.pos, value);
        this.pos += 4;
    }

    readFloat64() {
        let rv = this.dataView.getFloat64(this.pos);
        this.pos += 8;
        return rv;
    }

    writeFloat64(value) {
        this.dataView.setFloat64(this.pos, value);
        this.pos += 8;
    }


    writeString(value) {
      const encoder = new TextEncoder();
      // Note: in order to efficiently write this data, we first write the
      // string data, reserving 4 bytes for the size.
      const dest = new Uint8Array(this.dataView.buffer, this.pos + 4);
      const encodeResult = encoder.encodeInto(value, dest);
      if (encodeResult.read != value.length) {
        throw new UniFFIError(
            "writeString: out of space when writing to ArrayBuffer.  Did the computeSize() method returned the wrong result?"
        );
      }
      const size = encodeResult.written;
      // Next, go back and write the size before the string data
      this.dataView.setUint32(this.pos, size);
      // Finally, advance our position past both the size and string data
      this.pos += size + 4;
    }

    readString() {
      const decoder = new TextDecoder();
      const size = this.readUint32();
      const source = new Uint8Array(this.dataView.buffer, this.pos, size)
      const value = decoder.decode(source);
      this.pos += size;
      return value;
    }

    readBytes() {
      const size = this.readInt32();
      const bytes = new Uint8Array(this.dataView.buffer, this.pos, size);
      this.pos += size;
      return bytes
    }

    writeBytes(value) {
      this.writeUint32(value.length);
      value.forEach((elt) => {
        this.writeUint8(elt);
      })
    }

    // Reads a Optionneur pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerOptionneur() {
        const pointerId = 17; // rondpoint:Optionneur
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a Optionneur pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerOptionneur(value) {
        const pointerId = 17; // rondpoint:Optionneur
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    

    // Reads a Retourneur pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerRetourneur() {
        const pointerId = 18; // rondpoint:Retourneur
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a Retourneur pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerRetourneur(value) {
        const pointerId = 18; // rondpoint:Retourneur
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    

    // Reads a Stringifier pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerStringifier() {
        const pointerId = 19; // rondpoint:Stringifier
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a Stringifier pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerStringifier(value) {
        const pointerId = 19; // rondpoint:Stringifier
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    
}

function handleRustResult(result, liftCallback, liftErrCallback) {
    switch (result.code) {
        case "success":
            return liftCallback(result.data);

        case "error":
            throw liftErrCallback(result.data);

        case "internal-error":
            if (result.data) {
                throw new UniFFIInternalError(FfiConverterString.lift(result.data));
            } else {
                throw new UniFFIInternalError("Unknown error");
            }

        default:
            throw new UniFFIError(`Unexpected status code: ${result.code}`);
    }
}

class UniFFIError {
    constructor(message) {
        this.message = message;
    }

    toString() {
        return `UniFFIError: ${this.message}`
    }
}

class UniFFIInternalError extends UniFFIError {}

// Base class for FFI converters
class FfiConverter {
    // throw `UniFFITypeError` if a value to be converted has an invalid type
    static checkType(value) {
        if (value === undefined ) {
            throw new UniFFITypeError(`undefined`);
        }
        if (value === null ) {
            throw new UniFFITypeError(`null`);
        }
    }
}

// Base class for FFI converters that lift/lower by reading/writing to an ArrayBuffer
class FfiConverterArrayBuffer extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }

    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }

    /**
     * Computes the size of the value.
     *
     * @param {*} _value
     * @return {number}
     */
    static computeSize(_value) {
        throw new UniFFIInternalError("computeSize() should be declared in the derived class");
    }

    /**
     * Reads the type from a data stream.
     *
     * @param {ArrayBufferDataStream} _dataStream
     * @returns {any}
     */
    static read(_dataStream) {
        throw new UniFFIInternalError("read() should be declared in the derived class");
    }

    /**
     * Writes the type to a data stream.
     *
     * @param {ArrayBufferDataStream} _dataStream
     * @param {any} _value
     */
    static write(_dataStream, _value) {
        throw new UniFFIInternalError("write() should be declared in the derived class");
    }

}

// Symbols that are used to ensure that Object constructors
// can only be used with a proper UniFFI pointer
const uniffiObjectPtr = Symbol("uniffiObjectPtr");
const constructUniffiObject = Symbol("constructUniffiObject");
UnitTestObjs.uniffiObjectPtr = uniffiObjectPtr;

// Export the FFIConverter object to make external types work.
export class FfiConverterU8 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < 0 || value > 256) {
            throw new UniFFITypeError(`${value} exceeds the U8 bounds`);
        }
    }
    static computeSize(_value) {
        return 1;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint8(value)
    }
    static read(dataStream) {
        return dataStream.readUint8()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterI8 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < -128 || value > 127) {
            throw new UniFFITypeError(`${value} exceeds the I8 bounds`);
        }
    }
    static computeSize(_value) {
        return 1;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt8(value)
    }
    static read(dataStream) {
        return dataStream.readInt8()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterU16 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < 0 || value > 65535) {
            throw new UniFFITypeError(`${value} exceeds the U16 bounds`);
        }
    }
    static computeSize(_value) {
        return 2;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint16(value)
    }
    static read(dataStream) {
        return dataStream.readUint16()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterI16 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < -32768 || value > 32767) {
            throw new UniFFITypeError(`${value} exceeds the I16 bounds`);
        }
    }
    static computeSize(_value) {
        return 2;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt16(value)
    }
    static read(dataStream) {
        return dataStream.readInt16()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterU32 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < 0 || value > 4294967295) {
            throw new UniFFITypeError(`${value} exceeds the U32 bounds`);
        }
    }
    static computeSize(_value) {
        return 4;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint32(value)
    }
    static read(dataStream) {
        return dataStream.readUint32()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterI32 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < -2147483648 || value > 2147483647) {
            throw new UniFFITypeError(`${value} exceeds the I32 bounds`);
        }
    }
    static computeSize(_value) {
        return 4;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt32(value)
    }
    static read(dataStream) {
        return dataStream.readInt32()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterU64 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isSafeInteger(value)) {
            throw new UniFFITypeError(`${value} exceeds the safe integer bounds`);
        }
        if (value < 0) {
            throw new UniFFITypeError(`${value} exceeds the U64 bounds`);
        }
    }
    static computeSize(_value) {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint64(value)
    }
    static read(dataStream) {
        return dataStream.readUint64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterI64 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isSafeInteger(value)) {
            throw new UniFFITypeError(`${value} exceeds the safe integer bounds`);
        }
    }
    static computeSize(_value) {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt64(value)
    }
    static read(dataStream) {
        return dataStream.readInt64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterF32 extends FfiConverter {
    static computeSize(_value) {
        return 4;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeFloat32(value)
    }
    static read(dataStream) {
        return dataStream.readFloat32()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterF64 extends FfiConverter {
    static computeSize(_value) {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeFloat64(value)
    }
    static read(dataStream) {
        return dataStream.readFloat64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterBool extends FfiConverter {
    static computeSize(_value) {
        return 1;
    }
    static lift(value) {
        return value == 1;
    }
    static lower(value) {
        if (value) {
            return 1;
        } else {
            return 0;
        }
    }
    static write(dataStream, value) {
        dataStream.writeUint8(this.lower(value))
    }
    static read(dataStream) {
        return this.lift(dataStream.readUint8())
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterString extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (typeof value !== "string") {
            throw new UniFFITypeError(`${value} is not a string`);
        }
    }

    static lift(buf) {
        const decoder = new TextDecoder();
        const utf8Arr = new Uint8Array(buf);
        return decoder.decode(utf8Arr);
    }
    static lower(value) {
        const encoder = new TextEncoder();
        return encoder.encode(value).buffer;
    }

    static write(dataStream, value) {
        dataStream.writeString(value);
    }

    static read(dataStream) {
        return dataStream.readString();
    }

    static computeSize(value) {
        const encoder = new TextEncoder();
        return 4 + encoder.encode(value).length
    }
}

/**
 * Optionneur
 */
export class Optionneur {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!(opts[constructUniffiObject] instanceof UniFFIPointer)) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * init
     * @returns {Optionneur}
     */
    static init() {
        const liftResult = (result) => FfiConverterTypeOptionneur.lift(result);
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callAsyncWrapper(
                166, // rondpoint:uniffi_uniffi_rondpoint_fn_constructor_optionneur_new
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }}

    /**
     * sinonBoolean
     * @returns {Boolean}
     */
    sinonBoolean(value = false) {
        const liftResult = (result) => FfiConverterBool.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterBool.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                141, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_boolean
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterBool.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonEnum
     * @returns {Enumeration}
     */
    sinonEnum(value = Enumeration.TROIS) {
        const liftResult = (result) => FfiConverterTypeEnumeration.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeEnumeration.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                142, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_enum
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterTypeEnumeration.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonF32
     * @returns {number}
     */
    sinonF32(value = 42.0) {
        const liftResult = (result) => FfiConverterF32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterF32.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                143, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_f32
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterF32.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonF64
     * @returns {number}
     */
    sinonF64(value = 42.1) {
        const liftResult = (result) => FfiConverterF64.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterF64.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                144, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_f64
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterF64.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonI16Dec
     * @returns {number}
     */
    sinonI16Dec(value = 42) {
        const liftResult = (result) => FfiConverterI16.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI16.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                145, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_i16_dec
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterI16.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonI16Hex
     * @returns {number}
     */
    sinonI16Hex(value = 0x7f) {
        const liftResult = (result) => FfiConverterI16.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI16.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                146, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_i16_hex
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterI16.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonI32Dec
     * @returns {number}
     */
    sinonI32Dec(value = 42) {
        const liftResult = (result) => FfiConverterI32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI32.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                147, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_i32_dec
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterI32.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonI32Hex
     * @returns {number}
     */
    sinonI32Hex(value = 0x7fffffff) {
        const liftResult = (result) => FfiConverterI32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI32.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                148, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_i32_hex
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterI32.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonI64Dec
     * @returns {number}
     */
    sinonI64Dec(value = 42) {
        const liftResult = (result) => FfiConverterI64.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI64.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                149, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_i64_dec
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterI64.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonI64Hex
     * @returns {number}
     */
    sinonI64Hex(value = 0x7fffffffffffffff) {
        const liftResult = (result) => FfiConverterI64.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI64.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                150, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_i64_hex
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterI64.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonI8Dec
     * @returns {number}
     */
    sinonI8Dec(value = -42) {
        const liftResult = (result) => FfiConverterI8.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI8.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                151, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_i8_dec
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterI8.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonI8Hex
     * @returns {number}
     */
    sinonI8Hex(value = -127) {
        const liftResult = (result) => FfiConverterI8.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI8.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                152, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_i8_hex
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterI8.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonNull
     * @returns {?string}
     */
    sinonNull(value = null) {
        const liftResult = (result) => FfiConverterOptionalstring.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterOptionalstring.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                153, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_null
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterOptionalstring.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonSequence
     * @returns {Array.<string>}
     */
    sinonSequence(value = []) {
        const liftResult = (result) => FfiConverterSequencestring.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterSequencestring.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                154, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_sequence
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterSequencestring.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonString
     * @returns {string}
     */
    sinonString(value = "default") {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                155, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_string
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterString.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonU16Dec
     * @returns {number}
     */
    sinonU16Dec(value = 42) {
        const liftResult = (result) => FfiConverterU16.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU16.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                156, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_u16_dec
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterU16.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonU16Hex
     * @returns {number}
     */
    sinonU16Hex(value = 0xffff) {
        const liftResult = (result) => FfiConverterU16.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU16.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                157, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_u16_hex
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterU16.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonU32Dec
     * @returns {number}
     */
    sinonU32Dec(value = 42) {
        const liftResult = (result) => FfiConverterU32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU32.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                158, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_u32_dec
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterU32.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonU32Hex
     * @returns {number}
     */
    sinonU32Hex(value = 0xffffffff) {
        const liftResult = (result) => FfiConverterU32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU32.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                159, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_u32_hex
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterU32.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonU32Oct
     * @returns {number}
     */
    sinonU32Oct(value = 0o755) {
        const liftResult = (result) => FfiConverterU32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU32.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                160, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_u32_oct
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterU32.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonU64Dec
     * @returns {number}
     */
    sinonU64Dec(value = 42) {
        const liftResult = (result) => FfiConverterU64.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU64.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                161, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_u64_dec
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterU64.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonU64Hex
     * @returns {number}
     */
    sinonU64Hex(value = 0xffffffffffffffff) {
        const liftResult = (result) => FfiConverterU64.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU64.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                162, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_u64_hex
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterU64.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonU8Dec
     * @returns {number}
     */
    sinonU8Dec(value = 42) {
        const liftResult = (result) => FfiConverterU8.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU8.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                163, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_u8_dec
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterU8.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonU8Hex
     * @returns {number}
     */
    sinonU8Hex(value = 0xff) {
        const liftResult = (result) => FfiConverterU8.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU8.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                164, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_u8_hex
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterU8.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * sinonZero
     * @returns {?number}
     */
    sinonZero(value = 0) {
        const liftResult = (result) => FfiConverterOptionali32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterOptionali32.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                165, // rondpoint:uniffi_uniffi_rondpoint_fn_method_optionneur_sinon_zero
                FfiConverterTypeOptionneur.lower(this),
                FfiConverterOptionali32.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeOptionneur extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new Optionneur(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'Optionneur' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerOptionneur());
    }

    static write(dataStream, value) {
        dataStream.writePointerOptionneur(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

/**
 * Retourneur
 */
export class Retourneur {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!(opts[constructUniffiObject] instanceof UniFFIPointer)) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * init
     * @returns {Retourneur}
     */
    static init() {
        const liftResult = (result) => FfiConverterTypeRetourneur.lift(result);
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callAsyncWrapper(
                182, // rondpoint:uniffi_uniffi_rondpoint_fn_constructor_retourneur_new
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }}

    /**
     * identiqueBoolean
     * @returns {Boolean}
     */
    identiqueBoolean(value) {
        const liftResult = (result) => FfiConverterBool.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterBool.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                167, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_boolean
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterBool.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueDouble
     * @returns {number}
     */
    identiqueDouble(value) {
        const liftResult = (result) => FfiConverterF64.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterF64.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                168, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_double
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterF64.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueFloat
     * @returns {number}
     */
    identiqueFloat(value) {
        const liftResult = (result) => FfiConverterF32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterF32.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                169, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_float
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterF32.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueI16
     * @returns {number}
     */
    identiqueI16(value) {
        const liftResult = (result) => FfiConverterI16.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI16.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                170, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_i16
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterI16.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueI32
     * @returns {number}
     */
    identiqueI32(value) {
        const liftResult = (result) => FfiConverterI32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI32.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                171, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_i32
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterI32.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueI64
     * @returns {number}
     */
    identiqueI64(value) {
        const liftResult = (result) => FfiConverterI64.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI64.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                172, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_i64
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterI64.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueI8
     * @returns {number}
     */
    identiqueI8(value) {
        const liftResult = (result) => FfiConverterI8.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI8.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                173, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_i8
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterI8.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueNombres
     * @returns {DictionnaireNombres}
     */
    identiqueNombres(value) {
        const liftResult = (result) => FfiConverterTypeDictionnaireNombres.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeDictionnaireNombres.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                174, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_nombres
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterTypeDictionnaireNombres.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueNombresSignes
     * @returns {DictionnaireNombresSignes}
     */
    identiqueNombresSignes(value) {
        const liftResult = (result) => FfiConverterTypeDictionnaireNombresSignes.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeDictionnaireNombresSignes.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                175, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_nombres_signes
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterTypeDictionnaireNombresSignes.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueOptionneurDictionnaire
     * @returns {OptionneurDictionnaire}
     */
    identiqueOptionneurDictionnaire(value) {
        const liftResult = (result) => FfiConverterTypeOptionneurDictionnaire.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeOptionneurDictionnaire.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                176, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_optionneur_dictionnaire
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterTypeOptionneurDictionnaire.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueString
     * @returns {string}
     */
    identiqueString(value) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                177, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_string
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterString.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueU16
     * @returns {number}
     */
    identiqueU16(value) {
        const liftResult = (result) => FfiConverterU16.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU16.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                178, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_u16
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterU16.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueU32
     * @returns {number}
     */
    identiqueU32(value) {
        const liftResult = (result) => FfiConverterU32.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU32.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                179, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_u32
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterU32.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueU64
     * @returns {number}
     */
    identiqueU64(value) {
        const liftResult = (result) => FfiConverterU64.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU64.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                180, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_u64
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterU64.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * identiqueU8
     * @returns {number}
     */
    identiqueU8(value) {
        const liftResult = (result) => FfiConverterU8.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU8.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                181, // rondpoint:uniffi_uniffi_rondpoint_fn_method_retourneur_identique_u8
                FfiConverterTypeRetourneur.lower(this),
                FfiConverterU8.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeRetourneur extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new Retourneur(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'Retourneur' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerRetourneur());
    }

    static write(dataStream, value) {
        dataStream.writePointerRetourneur(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

/**
 * Stringifier
 */
export class Stringifier {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!(opts[constructUniffiObject] instanceof UniFFIPointer)) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * init
     * @returns {Stringifier}
     */
    static init() {
        const liftResult = (result) => FfiConverterTypeStringifier.lift(result);
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callAsyncWrapper(
                195, // rondpoint:uniffi_uniffi_rondpoint_fn_constructor_stringifier_new
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }}

    /**
     * toStringBoolean
     * @returns {string}
     */
    toStringBoolean(value) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterBool.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                183, // rondpoint:uniffi_uniffi_rondpoint_fn_method_stringifier_to_string_boolean
                FfiConverterTypeStringifier.lower(this),
                FfiConverterBool.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * toStringDouble
     * @returns {string}
     */
    toStringDouble(value) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterF64.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                184, // rondpoint:uniffi_uniffi_rondpoint_fn_method_stringifier_to_string_double
                FfiConverterTypeStringifier.lower(this),
                FfiConverterF64.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * toStringFloat
     * @returns {string}
     */
    toStringFloat(value) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterF32.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                185, // rondpoint:uniffi_uniffi_rondpoint_fn_method_stringifier_to_string_float
                FfiConverterTypeStringifier.lower(this),
                FfiConverterF32.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * toStringI16
     * @returns {string}
     */
    toStringI16(value) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI16.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                186, // rondpoint:uniffi_uniffi_rondpoint_fn_method_stringifier_to_string_i16
                FfiConverterTypeStringifier.lower(this),
                FfiConverterI16.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * toStringI32
     * @returns {string}
     */
    toStringI32(value) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI32.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                187, // rondpoint:uniffi_uniffi_rondpoint_fn_method_stringifier_to_string_i32
                FfiConverterTypeStringifier.lower(this),
                FfiConverterI32.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * toStringI64
     * @returns {string}
     */
    toStringI64(value) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI64.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                188, // rondpoint:uniffi_uniffi_rondpoint_fn_method_stringifier_to_string_i64
                FfiConverterTypeStringifier.lower(this),
                FfiConverterI64.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * toStringI8
     * @returns {string}
     */
    toStringI8(value) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterI8.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                189, // rondpoint:uniffi_uniffi_rondpoint_fn_method_stringifier_to_string_i8
                FfiConverterTypeStringifier.lower(this),
                FfiConverterI8.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * toStringU16
     * @returns {string}
     */
    toStringU16(value) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU16.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                190, // rondpoint:uniffi_uniffi_rondpoint_fn_method_stringifier_to_string_u16
                FfiConverterTypeStringifier.lower(this),
                FfiConverterU16.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * toStringU32
     * @returns {string}
     */
    toStringU32(value) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU32.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                191, // rondpoint:uniffi_uniffi_rondpoint_fn_method_stringifier_to_string_u32
                FfiConverterTypeStringifier.lower(this),
                FfiConverterU32.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * toStringU64
     * @returns {string}
     */
    toStringU64(value) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU64.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                192, // rondpoint:uniffi_uniffi_rondpoint_fn_method_stringifier_to_string_u64
                FfiConverterTypeStringifier.lower(this),
                FfiConverterU64.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * toStringU8
     * @returns {string}
     */
    toStringU8(value) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterU8.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                193, // rondpoint:uniffi_uniffi_rondpoint_fn_method_stringifier_to_string_u8
                FfiConverterTypeStringifier.lower(this),
                FfiConverterU8.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    /**
     * wellKnownString
     * @returns {string}
     */
    wellKnownString(value) {
        const liftResult = (result) => FfiConverterString.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(value)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("value");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                194, // rondpoint:uniffi_uniffi_rondpoint_fn_method_stringifier_well_known_string
                FfiConverterTypeStringifier.lower(this),
                FfiConverterString.lower(value),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeStringifier extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new Stringifier(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'Stringifier' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerStringifier());
    }

    static write(dataStream, value) {
        dataStream.writePointerStringifier(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

/**
 * Dictionnaire
 */
export class Dictionnaire {
    constructor({ un, deux, petitNombre, grosNombre }) {
        try {
            FfiConverterTypeEnumeration.checkType(un)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("un");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(deux)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("deux");
            }
            throw e;
        }
        try {
            FfiConverterU8.checkType(petitNombre)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("petitNombre");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(grosNombre)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("grosNombre");
            }
            throw e;
        }
        /**
         * @type {Enumeration}
         */
        this.un = un;
        /**
         * @type {Boolean}
         */
        this.deux = deux;
        /**
         * @type {number}
         */
        this.petitNombre = petitNombre;
        /**
         * @type {number}
         */
        this.grosNombre = grosNombre;
    }

    equals(other) {
        return (
            this.un == other.un &&
            this.deux == other.deux &&
            this.petitNombre == other.petitNombre &&
            this.grosNombre == other.grosNombre
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeDictionnaire extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new Dictionnaire({
            un: FfiConverterTypeEnumeration.read(dataStream),
            deux: FfiConverterBool.read(dataStream),
            petitNombre: FfiConverterU8.read(dataStream),
            grosNombre: FfiConverterU64.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterTypeEnumeration.write(dataStream, value.un);
        FfiConverterBool.write(dataStream, value.deux);
        FfiConverterU8.write(dataStream, value.petitNombre);
        FfiConverterU64.write(dataStream, value.grosNombre);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterTypeEnumeration.computeSize(value.un);
        totalSize += FfiConverterBool.computeSize(value.deux);
        totalSize += FfiConverterU8.computeSize(value.petitNombre);
        totalSize += FfiConverterU64.computeSize(value.grosNombre);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof Dictionnaire)) {
            throw new UniFFITypeError(`Expected 'Dictionnaire', found '${typeof value}'`);
        }
        try {
            FfiConverterTypeEnumeration.checkType(value.un);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".un");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(value.deux);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".deux");
            }
            throw e;
        }
        try {
            FfiConverterU8.checkType(value.petitNombre);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".petitNombre");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(value.grosNombre);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".grosNombre");
            }
            throw e;
        }
    }
}

/**
 * DictionnaireNombres
 */
export class DictionnaireNombres {
    constructor({ petitNombre, courtNombre, nombreSimple, grosNombre }) {
        try {
            FfiConverterU8.checkType(petitNombre)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("petitNombre");
            }
            throw e;
        }
        try {
            FfiConverterU16.checkType(courtNombre)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("courtNombre");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(nombreSimple)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("nombreSimple");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(grosNombre)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("grosNombre");
            }
            throw e;
        }
        /**
         * @type {number}
         */
        this.petitNombre = petitNombre;
        /**
         * @type {number}
         */
        this.courtNombre = courtNombre;
        /**
         * @type {number}
         */
        this.nombreSimple = nombreSimple;
        /**
         * @type {number}
         */
        this.grosNombre = grosNombre;
    }

    equals(other) {
        return (
            this.petitNombre == other.petitNombre &&
            this.courtNombre == other.courtNombre &&
            this.nombreSimple == other.nombreSimple &&
            this.grosNombre == other.grosNombre
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeDictionnaireNombres extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new DictionnaireNombres({
            petitNombre: FfiConverterU8.read(dataStream),
            courtNombre: FfiConverterU16.read(dataStream),
            nombreSimple: FfiConverterU32.read(dataStream),
            grosNombre: FfiConverterU64.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterU8.write(dataStream, value.petitNombre);
        FfiConverterU16.write(dataStream, value.courtNombre);
        FfiConverterU32.write(dataStream, value.nombreSimple);
        FfiConverterU64.write(dataStream, value.grosNombre);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterU8.computeSize(value.petitNombre);
        totalSize += FfiConverterU16.computeSize(value.courtNombre);
        totalSize += FfiConverterU32.computeSize(value.nombreSimple);
        totalSize += FfiConverterU64.computeSize(value.grosNombre);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof DictionnaireNombres)) {
            throw new UniFFITypeError(`Expected 'DictionnaireNombres', found '${typeof value}'`);
        }
        try {
            FfiConverterU8.checkType(value.petitNombre);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".petitNombre");
            }
            throw e;
        }
        try {
            FfiConverterU16.checkType(value.courtNombre);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".courtNombre");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.nombreSimple);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".nombreSimple");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(value.grosNombre);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".grosNombre");
            }
            throw e;
        }
    }
}

/**
 * DictionnaireNombresSignes
 */
export class DictionnaireNombresSignes {
    constructor({ petitNombre, courtNombre, nombreSimple, grosNombre }) {
        try {
            FfiConverterI8.checkType(petitNombre)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("petitNombre");
            }
            throw e;
        }
        try {
            FfiConverterI16.checkType(courtNombre)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("courtNombre");
            }
            throw e;
        }
        try {
            FfiConverterI32.checkType(nombreSimple)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("nombreSimple");
            }
            throw e;
        }
        try {
            FfiConverterI64.checkType(grosNombre)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("grosNombre");
            }
            throw e;
        }
        /**
         * @type {number}
         */
        this.petitNombre = petitNombre;
        /**
         * @type {number}
         */
        this.courtNombre = courtNombre;
        /**
         * @type {number}
         */
        this.nombreSimple = nombreSimple;
        /**
         * @type {number}
         */
        this.grosNombre = grosNombre;
    }

    equals(other) {
        return (
            this.petitNombre == other.petitNombre &&
            this.courtNombre == other.courtNombre &&
            this.nombreSimple == other.nombreSimple &&
            this.grosNombre == other.grosNombre
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeDictionnaireNombresSignes extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new DictionnaireNombresSignes({
            petitNombre: FfiConverterI8.read(dataStream),
            courtNombre: FfiConverterI16.read(dataStream),
            nombreSimple: FfiConverterI32.read(dataStream),
            grosNombre: FfiConverterI64.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterI8.write(dataStream, value.petitNombre);
        FfiConverterI16.write(dataStream, value.courtNombre);
        FfiConverterI32.write(dataStream, value.nombreSimple);
        FfiConverterI64.write(dataStream, value.grosNombre);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterI8.computeSize(value.petitNombre);
        totalSize += FfiConverterI16.computeSize(value.courtNombre);
        totalSize += FfiConverterI32.computeSize(value.nombreSimple);
        totalSize += FfiConverterI64.computeSize(value.grosNombre);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof DictionnaireNombresSignes)) {
            throw new UniFFITypeError(`Expected 'DictionnaireNombresSignes', found '${typeof value}'`);
        }
        try {
            FfiConverterI8.checkType(value.petitNombre);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".petitNombre");
            }
            throw e;
        }
        try {
            FfiConverterI16.checkType(value.courtNombre);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".courtNombre");
            }
            throw e;
        }
        try {
            FfiConverterI32.checkType(value.nombreSimple);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".nombreSimple");
            }
            throw e;
        }
        try {
            FfiConverterI64.checkType(value.grosNombre);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".grosNombre");
            }
            throw e;
        }
    }
}

/**
 * OptionneurDictionnaire
 */
export class OptionneurDictionnaire {
    constructor({ i8Var = -8, u8Var = 8, i16Var = -16, u16Var = 0x10, i32Var = -32, u32Var = 32, i64Var = -64, u64Var = 64, floatVar = 4.0, doubleVar = 8.0, booleanVar = true, stringVar = "default", listVar = [], enumerationVar = Enumeration.DEUX, dictionnaireVar = null }) {
        try {
            FfiConverterI8.checkType(i8Var)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("i8Var");
            }
            throw e;
        }
        try {
            FfiConverterU8.checkType(u8Var)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("u8Var");
            }
            throw e;
        }
        try {
            FfiConverterI16.checkType(i16Var)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("i16Var");
            }
            throw e;
        }
        try {
            FfiConverterU16.checkType(u16Var)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("u16Var");
            }
            throw e;
        }
        try {
            FfiConverterI32.checkType(i32Var)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("i32Var");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(u32Var)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("u32Var");
            }
            throw e;
        }
        try {
            FfiConverterI64.checkType(i64Var)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("i64Var");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(u64Var)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("u64Var");
            }
            throw e;
        }
        try {
            FfiConverterF32.checkType(floatVar)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("floatVar");
            }
            throw e;
        }
        try {
            FfiConverterF64.checkType(doubleVar)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("doubleVar");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(booleanVar)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("booleanVar");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(stringVar)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("stringVar");
            }
            throw e;
        }
        try {
            FfiConverterSequencestring.checkType(listVar)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("listVar");
            }
            throw e;
        }
        try {
            FfiConverterTypeEnumeration.checkType(enumerationVar)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("enumerationVar");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeminusculeMajusculeEnum.checkType(dictionnaireVar)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("dictionnaireVar");
            }
            throw e;
        }
        /**
         * @type {number}
         */
        this.i8Var = i8Var;
        /**
         * @type {number}
         */
        this.u8Var = u8Var;
        /**
         * @type {number}
         */
        this.i16Var = i16Var;
        /**
         * @type {number}
         */
        this.u16Var = u16Var;
        /**
         * @type {number}
         */
        this.i32Var = i32Var;
        /**
         * @type {number}
         */
        this.u32Var = u32Var;
        /**
         * @type {number}
         */
        this.i64Var = i64Var;
        /**
         * @type {number}
         */
        this.u64Var = u64Var;
        /**
         * @type {number}
         */
        this.floatVar = floatVar;
        /**
         * @type {number}
         */
        this.doubleVar = doubleVar;
        /**
         * @type {Boolean}
         */
        this.booleanVar = booleanVar;
        /**
         * @type {string}
         */
        this.stringVar = stringVar;
        /**
         * @type {Array.<string>}
         */
        this.listVar = listVar;
        /**
         * @type {Enumeration}
         */
        this.enumerationVar = enumerationVar;
        /**
         * @type {?minusculeMAJUSCULEEnum}
         */
        this.dictionnaireVar = dictionnaireVar;
    }

    equals(other) {
        return (
            this.i8Var == other.i8Var &&
            this.u8Var == other.u8Var &&
            this.i16Var == other.i16Var &&
            this.u16Var == other.u16Var &&
            this.i32Var == other.i32Var &&
            this.u32Var == other.u32Var &&
            this.i64Var == other.i64Var &&
            this.u64Var == other.u64Var &&
            this.floatVar == other.floatVar &&
            this.doubleVar == other.doubleVar &&
            this.booleanVar == other.booleanVar &&
            this.stringVar == other.stringVar &&
            this.listVar == other.listVar &&
            this.enumerationVar == other.enumerationVar &&
            this.dictionnaireVar == other.dictionnaireVar
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeOptionneurDictionnaire extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new OptionneurDictionnaire({
            i8Var: FfiConverterI8.read(dataStream),
            u8Var: FfiConverterU8.read(dataStream),
            i16Var: FfiConverterI16.read(dataStream),
            u16Var: FfiConverterU16.read(dataStream),
            i32Var: FfiConverterI32.read(dataStream),
            u32Var: FfiConverterU32.read(dataStream),
            i64Var: FfiConverterI64.read(dataStream),
            u64Var: FfiConverterU64.read(dataStream),
            floatVar: FfiConverterF32.read(dataStream),
            doubleVar: FfiConverterF64.read(dataStream),
            booleanVar: FfiConverterBool.read(dataStream),
            stringVar: FfiConverterString.read(dataStream),
            listVar: FfiConverterSequencestring.read(dataStream),
            enumerationVar: FfiConverterTypeEnumeration.read(dataStream),
            dictionnaireVar: FfiConverterOptionalTypeminusculeMajusculeEnum.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterI8.write(dataStream, value.i8Var);
        FfiConverterU8.write(dataStream, value.u8Var);
        FfiConverterI16.write(dataStream, value.i16Var);
        FfiConverterU16.write(dataStream, value.u16Var);
        FfiConverterI32.write(dataStream, value.i32Var);
        FfiConverterU32.write(dataStream, value.u32Var);
        FfiConverterI64.write(dataStream, value.i64Var);
        FfiConverterU64.write(dataStream, value.u64Var);
        FfiConverterF32.write(dataStream, value.floatVar);
        FfiConverterF64.write(dataStream, value.doubleVar);
        FfiConverterBool.write(dataStream, value.booleanVar);
        FfiConverterString.write(dataStream, value.stringVar);
        FfiConverterSequencestring.write(dataStream, value.listVar);
        FfiConverterTypeEnumeration.write(dataStream, value.enumerationVar);
        FfiConverterOptionalTypeminusculeMajusculeEnum.write(dataStream, value.dictionnaireVar);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterI8.computeSize(value.i8Var);
        totalSize += FfiConverterU8.computeSize(value.u8Var);
        totalSize += FfiConverterI16.computeSize(value.i16Var);
        totalSize += FfiConverterU16.computeSize(value.u16Var);
        totalSize += FfiConverterI32.computeSize(value.i32Var);
        totalSize += FfiConverterU32.computeSize(value.u32Var);
        totalSize += FfiConverterI64.computeSize(value.i64Var);
        totalSize += FfiConverterU64.computeSize(value.u64Var);
        totalSize += FfiConverterF32.computeSize(value.floatVar);
        totalSize += FfiConverterF64.computeSize(value.doubleVar);
        totalSize += FfiConverterBool.computeSize(value.booleanVar);
        totalSize += FfiConverterString.computeSize(value.stringVar);
        totalSize += FfiConverterSequencestring.computeSize(value.listVar);
        totalSize += FfiConverterTypeEnumeration.computeSize(value.enumerationVar);
        totalSize += FfiConverterOptionalTypeminusculeMajusculeEnum.computeSize(value.dictionnaireVar);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof OptionneurDictionnaire)) {
            throw new UniFFITypeError(`Expected 'OptionneurDictionnaire', found '${typeof value}'`);
        }
        try {
            FfiConverterI8.checkType(value.i8Var);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".i8Var");
            }
            throw e;
        }
        try {
            FfiConverterU8.checkType(value.u8Var);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".u8Var");
            }
            throw e;
        }
        try {
            FfiConverterI16.checkType(value.i16Var);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".i16Var");
            }
            throw e;
        }
        try {
            FfiConverterU16.checkType(value.u16Var);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".u16Var");
            }
            throw e;
        }
        try {
            FfiConverterI32.checkType(value.i32Var);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".i32Var");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.u32Var);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".u32Var");
            }
            throw e;
        }
        try {
            FfiConverterI64.checkType(value.i64Var);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".i64Var");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(value.u64Var);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".u64Var");
            }
            throw e;
        }
        try {
            FfiConverterF32.checkType(value.floatVar);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".floatVar");
            }
            throw e;
        }
        try {
            FfiConverterF64.checkType(value.doubleVar);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".doubleVar");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(value.booleanVar);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".booleanVar");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(value.stringVar);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".stringVar");
            }
            throw e;
        }
        try {
            FfiConverterSequencestring.checkType(value.listVar);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".listVar");
            }
            throw e;
        }
        try {
            FfiConverterTypeEnumeration.checkType(value.enumerationVar);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".enumerationVar");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeminusculeMajusculeEnum.checkType(value.dictionnaireVar);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".dictionnaireVar");
            }
            throw e;
        }
    }
}

/**
 * MinusculeMajusculeDict
 */
export class MinusculeMajusculeDict {
    constructor({ minusculeMajusculeField }) {
        try {
            FfiConverterBool.checkType(minusculeMajusculeField)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("minusculeMajusculeField");
            }
            throw e;
        }
        /**
         * @type {Boolean}
         */
        this.minusculeMajusculeField = minusculeMajusculeField;
    }

    equals(other) {
        return (
            this.minusculeMajusculeField == other.minusculeMajusculeField
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeminusculeMajusculeDict extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new MinusculeMajusculeDict({
            minusculeMajusculeField: FfiConverterBool.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterBool.write(dataStream, value.minusculeMajusculeField);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterBool.computeSize(value.minusculeMajusculeField);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof MinusculeMajusculeDict)) {
            throw new UniFFITypeError(`Expected 'MinusculeMajusculeDict', found '${typeof value}'`);
        }
        try {
            FfiConverterBool.checkType(value.minusculeMajusculeField);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".minusculeMajusculeField");
            }
            throw e;
        }
    }
}


/**
 * Enumeration
 */
export const Enumeration = {
    /**
     * UN
     */
    UN: 1,
    /**
     * DEUX
     */
    DEUX: 2,
    /**
     * TROIS
     */
    TROIS: 3,
};

Object.freeze(Enumeration);
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeEnumeration extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return Enumeration.UN
            case 2:
                return Enumeration.DEUX
            case 3:
                return Enumeration.TROIS
            default:
                throw new UniFFITypeError("Unknown Enumeration variant");
        }
    }

    static write(dataStream, value) {
        if (value === Enumeration.UN) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === Enumeration.DEUX) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === Enumeration.TROIS) {
            dataStream.writeInt32(3);
            return;
        }
        throw new UniFFITypeError("Unknown Enumeration variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      if (!Number.isInteger(value) || value < 1 || value > 3) {
          throw new UniFFITypeError(`${value} is not a valid value for Enumeration`);
      }
    }
}



/**
 * EnumerationAvecDonnees
 */
export class EnumerationAvecDonnees {}
/**
 * Zero
 */
EnumerationAvecDonnees.Zero = class extends EnumerationAvecDonnees{
    constructor(
        ) {
            super();
        }
}
/**
 * Un
 */
EnumerationAvecDonnees.Un = class extends EnumerationAvecDonnees{
    constructor(
        premier
        ) {
            super();
            this.premier = premier;
        }
}
/**
 * Deux
 */
EnumerationAvecDonnees.Deux = class extends EnumerationAvecDonnees{
    constructor(
        premier,
        second
        ) {
            super();
            this.premier = premier;
            this.second = second;
        }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeEnumerationAvecDonnees extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new EnumerationAvecDonnees.Zero(
                    );
            case 2:
                return new EnumerationAvecDonnees.Un(
                    FfiConverterU32.read(dataStream)
                    );
            case 3:
                return new EnumerationAvecDonnees.Deux(
                    FfiConverterU32.read(dataStream),
                    FfiConverterString.read(dataStream)
                    );
            default:
                throw new UniFFITypeError("Unknown EnumerationAvecDonnees variant");
        }
    }

    static write(dataStream, value) {
        if (value instanceof EnumerationAvecDonnees.Zero) {
            dataStream.writeInt32(1);
            return;
        }
        if (value instanceof EnumerationAvecDonnees.Un) {
            dataStream.writeInt32(2);
            FfiConverterU32.write(dataStream, value.premier);
            return;
        }
        if (value instanceof EnumerationAvecDonnees.Deux) {
            dataStream.writeInt32(3);
            FfiConverterU32.write(dataStream, value.premier);
            FfiConverterString.write(dataStream, value.second);
            return;
        }
        throw new UniFFITypeError("Unknown EnumerationAvecDonnees variant");
    }

    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof EnumerationAvecDonnees.Zero) {
            return totalSize;
        }
        if (value instanceof EnumerationAvecDonnees.Un) {
            totalSize += FfiConverterU32.computeSize(value.premier);
            return totalSize;
        }
        if (value instanceof EnumerationAvecDonnees.Deux) {
            totalSize += FfiConverterU32.computeSize(value.premier);
            totalSize += FfiConverterString.computeSize(value.second);
            return totalSize;
        }
        throw new UniFFITypeError("Unknown EnumerationAvecDonnees variant");
    }

    static checkType(value) {
      if (!(value instanceof EnumerationAvecDonnees)) {
        throw new UniFFITypeError(`${value} is not a subclass instance of EnumerationAvecDonnees`);
      }
    }
}



/**
 * MinusculeMajusculeEnum
 */
export const MinusculeMajusculeEnum = {
    /**
     * MINUSCULE_MAJUSCULE_VARIANT
     */
    MINUSCULE_MAJUSCULE_VARIANT: 1,
};

Object.freeze(MinusculeMajusculeEnum);
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeminusculeMajusculeEnum extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return MinusculeMajusculeEnum.MINUSCULE_MAJUSCULE_VARIANT
            default:
                throw new UniFFITypeError("Unknown MinusculeMajusculeEnum variant");
        }
    }

    static write(dataStream, value) {
        if (value === MinusculeMajusculeEnum.MINUSCULE_MAJUSCULE_VARIANT) {
            dataStream.writeInt32(1);
            return;
        }
        throw new UniFFITypeError("Unknown MinusculeMajusculeEnum variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      if (!Number.isInteger(value) || value < 1 || value > 1) {
          throw new UniFFITypeError(`${value} is not a valid value for MinusculeMajusculeEnum`);
      }
    }
}


// Export the FFIConverter object to make external types work.
export class FfiConverterOptionali32 extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterI32.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterI32.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterI32.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterI32.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalstring extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterString.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterString.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterString.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterString.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeminusculeMajusculeEnum extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeminusculeMajusculeEnum.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeminusculeMajusculeEnum.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeminusculeMajusculeEnum.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeminusculeMajusculeEnum.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequencestring extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterString.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterString.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterString.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterString.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeEnumeration extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeEnumeration.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeEnumeration.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeEnumeration.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeEnumeration.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterMapStringTypeEnumerationAvecDonnees extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const map = {};
        for (let i = 0; i < len; i++) {
            const key = FfiConverterString.read(dataStream);
            const value = FfiConverterTypeEnumerationAvecDonnees.read(dataStream);
            map[key] = value;
        }

        return map;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(Object.keys(value).length);
        for (const key in value) {
            FfiConverterString.write(dataStream, key);
            FfiConverterTypeEnumerationAvecDonnees.write(dataStream, value[key]);
        }
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const key in value) {
            size += FfiConverterString.computeSize(key);
            size += FfiConverterTypeEnumerationAvecDonnees.computeSize(value[key]);
        }
        return size;
    }

    static checkType(value) {
        for (const key in value) {
            try {
                FfiConverterString.checkType(key);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("(key)");
                }
                throw e;
            }

            try {
                FfiConverterTypeEnumerationAvecDonnees.checkType(value[key]);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${key}]`);
                }
                throw e;
            }
        }
    }
}





/**
 * copieCarte
 * @returns {object}
 */
export function copieCarte(c) {

        const liftResult = (result) => FfiConverterMapStringTypeEnumerationAvecDonnees.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterMapStringTypeEnumerationAvecDonnees.checkType(c)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("c");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                136, // rondpoint:uniffi_uniffi_rondpoint_fn_func_copie_carte
                FfiConverterMapStringTypeEnumerationAvecDonnees.lower(c),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * copieDictionnaire
 * @returns {Dictionnaire}
 */
export function copieDictionnaire(d) {

        const liftResult = (result) => FfiConverterTypeDictionnaire.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeDictionnaire.checkType(d)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("d");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                137, // rondpoint:uniffi_uniffi_rondpoint_fn_func_copie_dictionnaire
                FfiConverterTypeDictionnaire.lower(d),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * copieEnumeration
 * @returns {Enumeration}
 */
export function copieEnumeration(e) {

        const liftResult = (result) => FfiConverterTypeEnumeration.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterTypeEnumeration.checkType(e)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("e");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                138, // rondpoint:uniffi_uniffi_rondpoint_fn_func_copie_enumeration
                FfiConverterTypeEnumeration.lower(e),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * copieEnumerations
 * @returns {Array.<Enumeration>}
 */
export function copieEnumerations(e) {

        const liftResult = (result) => FfiConverterSequenceTypeEnumeration.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterSequenceTypeEnumeration.checkType(e)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("e");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                139, // rondpoint:uniffi_uniffi_rondpoint_fn_func_copie_enumerations
                FfiConverterSequenceTypeEnumeration.lower(e),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}

/**
 * switcheroo
 * @returns {Boolean}
 */
export function switcheroo(b) {

        const liftResult = (result) => FfiConverterBool.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterBool.checkType(b)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("b");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsyncWrapper(
                140, // rondpoint:uniffi_uniffi_rondpoint_fn_func_switcheroo
                FfiConverterBool.lower(b),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
}
