// The compressed data are created by Mali GPU Texture Compression Tool
// (http://malideveloper.arm.com/resources/tools/mali-gpu-texture-compression-tool/).
// Simply convert image to ktx format then strip the ktx header to
// get compressed data.
//
// The decompressed data are create by Khronos KTX library and tools
// (https://github.com/KhronosGroup/KTX)
// Calling _ktxUnpackETC with previous generated compressed data to
// get decompressed data.

var img_4x4_r11_eac = {
  compressed: new Uint8Array([0x0f, 0xf9, 0xbe, 0xff, 0xef, 0xb6, 0xff, 0xff]),
  decompressed: new Uint8Array([
    0x4b, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x4b, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x4b, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x4b, 0x00, 0x00, 0xff,
    0x4b, 0x00, 0x00, 0xff, 0x4b, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff,
  ]),
};

var img_4x4_signed_r11_eac = {
  compressed: new Uint8Array([0x90, 0xf9, 0xbe, 0xff, 0xef, 0xb6, 0xff, 0xff]),
  decompressed: new Uint8Array([
    0x4c, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x4c, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x4c, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x4c, 0x00, 0x00, 0xff,
    0x4c, 0x00, 0x00, 0xff, 0x4c, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff,
  ]),
};

var img_4x4_rg11_eac = {
  compressed: new Uint8Array([
    0x2e, 0xf0, 0xe7, 0x92, 0x79, 0xff, 0x92, 0x49, 0x2e, 0xf0, 0x3c, 0xff,
    0xcf, 0x24, 0xff, 0xff,
  ]),
  decompressed: new Uint8Array([
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff,
  ]),
};

var img_4x4_signed_rg11_eac = {
  compressed: new Uint8Array([
    0xae, 0xf0, 0xe7, 0x92, 0x79, 0xff, 0x92, 0x49, 0xae, 0xf0, 0x3c, 0xff,
    0xcf, 0x24, 0xff, 0xff,
  ]),
  decompressed: new Uint8Array([
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff,
  ]),
};

var img_4x4_rgb_etc2 = {
  compressed: new Uint8Array([0x04, 0xf0, 0xf0, 0x02, 0x07, 0x45, 0x00, 0x00]),
  decompressed: new Uint8Array([
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff,
  ]),
};

var img_4x4_rgb_punchthrough_etc2 = {
  compressed: new Uint8Array([0x04, 0xf0, 0xf0, 0x00, 0xbf, 0x5f, 0x02, 0x05]),
  decompressed: new Uint8Array([
    0xfc, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff,
    0xfc, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
  ]),
};

var img_4x4_rgba_etc2 = {
  compressed: new Uint8Array([
    0x44, 0x89, 0x69, 0x24, 0x41, 0x43, 0x04, 0x41, 0x04, 0xf0, 0xf0, 0x02,
    0x07, 0x45, 0x00, 0x00,
  ]),
  decompressed: new Uint8Array([
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x04, 0xff, 0x00, 0x00, 0x04,
    0x00, 0xff, 0x00, 0x04, 0x00, 0xff, 0x00, 0x04, 0x00, 0xff, 0x00, 0x1c,
    0xff, 0x00, 0x00, 0x34, 0x00, 0xff, 0x00, 0x1c, 0xff, 0x00, 0x00, 0x04,
    0xff, 0x00, 0x00, 0x34, 0xff, 0x00, 0x00, 0x7c, 0x00, 0xff, 0x00, 0x34,
    0x00, 0xff, 0x00, 0x04, 0x00, 0xff, 0x00, 0x1c, 0x00, 0xff, 0x00, 0x34,
    0x00, 0xff, 0x00, 0x1c,
  ]),
};

var img_8x8_r11_eac = {
  compressed: new Uint8Array([
    0x0f, 0xf9, 0xbe, 0xff, 0xef, 0xb6, 0xff, 0xff, 0x5e, 0xb3, 0xeb, 0xa4,
    0xba, 0xff, 0xa4, 0x92, 0x00, 0xf6, 0xfb, 0xed, 0xbe, 0xff, 0xed, 0xb6,
    0x2c, 0xfd, 0x1c, 0x7f, 0xc7, 0x00, 0x7f, 0xff,
  ]),
  decompressed: new Uint8Array([
    0x4b, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x4b, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0xe2, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff,
    0xe2, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x4b, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x1c, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0xe2, 0x00, 0x00, 0xff,
    0x1c, 0x00, 0x00, 0xff, 0x4b, 0x00, 0x00, 0xff, 0x4b, 0x00, 0x00, 0xff,
    0x4b, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0xe2, 0x00, 0x00, 0xff,
    0xe2, 0x00, 0x00, 0xff, 0xe2, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff,
    0x1c, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x69, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0xb3, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff,
    0xb3, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff, 0xb3, 0x00, 0x00, 0xff,
    0xb3, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0xb3, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x69, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0xb3, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff,
    0x69, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff,
    0xb3, 0x00, 0x00, 0xff, 0xb3, 0x00, 0x00, 0xff, 0xb3, 0x00, 0x00, 0xff,
    0xb3, 0x00, 0x00, 0xff,
  ]),
};

var img_8x8_signed_r11_eac = {
  compressed: new Uint8Array([
    0x90, 0xf9, 0xbe, 0xff, 0xef, 0xb6, 0xff, 0xff, 0xdf, 0xb3, 0xeb, 0xa4,
    0xba, 0xff, 0xa4, 0x92, 0xfb, 0x20, 0xeb, 0xa4, 0xba, 0xff, 0xa4, 0x92,
    0xac, 0xfd, 0x1c, 0x7f, 0xc7, 0x00, 0x7f, 0xff,
  ]),
  decompressed: new Uint8Array([
    0x4c, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x4c, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0xe2, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff,
    0xe2, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x4c, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0xe2, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0x4c, 0x00, 0x00, 0xff, 0x4c, 0x00, 0x00, 0xff,
    0x4c, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0xe2, 0x00, 0x00, 0xff,
    0xe2, 0x00, 0x00, 0xff, 0xe2, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x69, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0xb2, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff,
    0xb2, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff, 0xb2, 0x00, 0x00, 0xff,
    0xb2, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0xb2, 0x00, 0x00, 0xff,
    0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff, 0x96, 0x00, 0x00, 0xff,
    0x69, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0xb2, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff,
    0x69, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff,
    0xb2, 0x00, 0x00, 0xff, 0xb2, 0x00, 0x00, 0xff, 0xb2, 0x00, 0x00, 0xff,
    0xb2, 0x00, 0x00, 0xff,
  ]),
};

var img_8x8_rg11_eac = {
  compressed: new Uint8Array([
    0x2e, 0xf0, 0xe7, 0x92, 0x79, 0xff, 0x92, 0x49, 0x2e, 0xf0, 0x3c, 0xff,
    0xcf, 0x24, 0xff, 0xff, 0x2e, 0xf0, 0xe7, 0x92, 0x79, 0xff, 0x92, 0x49,
    0x2e, 0xf0, 0xe7, 0x92, 0x79, 0xff, 0x92, 0x49, 0x2e, 0xf0, 0x3c, 0xff,
    0xcf, 0x24, 0xff, 0xff, 0x2e, 0xf0, 0xe7, 0x92, 0x79, 0xff, 0x92, 0x49,
    0x00, 0x00, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x2e, 0xf0, 0x3c, 0xff,
    0xcf, 0x24, 0xff, 0xff,
  ]),
  decompressed: new Uint8Array([
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff,
    0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff,
  ]),
};

var img_8x8_signed_rg11_eac = {
  compressed: new Uint8Array([
    0xae, 0xf0, 0xe7, 0x92, 0x79, 0xff, 0x92, 0x49, 0xae, 0xf0, 0x3c, 0xff,
    0xcf, 0x24, 0xff, 0xff, 0xae, 0xf0, 0xe7, 0x92, 0x79, 0xff, 0x92, 0x49,
    0xae, 0xf0, 0xe7, 0x92, 0x79, 0xff, 0x92, 0x49, 0xae, 0xf0, 0x3c, 0xff,
    0xcf, 0x24, 0xff, 0xff, 0xae, 0xf0, 0xe7, 0x92, 0x79, 0xff, 0x92, 0x49,
    0x80, 0x00, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0xae, 0xf0, 0x3c, 0xff,
    0xcf, 0x24, 0xff, 0xff,
  ]),
  decompressed: new Uint8Array([
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff,
    0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff,
  ]),
};

var img_8x8_rgb_etc2 = {
  compressed: new Uint8Array([
    0x04, 0xf0, 0xf0, 0x02, 0x07, 0x45, 0x00, 0x00, 0x04, 0x0f, 0xff, 0x02,
    0x07, 0x45, 0x00, 0x00, 0x04, 0xf0, 0xf0, 0xf2, 0xf8, 0xba, 0x00, 0x00,
    0x04, 0x0f, 0x0f, 0xf2, 0xf8, 0xba, 0x00, 0x00,
  ]),
  decompressed: new Uint8Array([
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff,
    0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff,
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff,
    0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff,
    0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff,
    0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff,
    0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,
    0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,
    0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
    0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,
    0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff,
    0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff,
    0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,
    0x00, 0xff, 0xff, 0xff,
  ]),
};

var img_8x8_rgb_punchthrough_etc2 = {
  compressed: new Uint8Array([
    0x04, 0xf0, 0xf0, 0x00, 0x5f, 0xef, 0x01, 0x44, 0xfb, 0xf0, 0x00, 0xf0,
    0xfd, 0xfa, 0x10, 0x80, 0xfb, 0x0f, 0x0f, 0x00, 0x7f, 0x6f, 0x02, 0x40,
    0x04, 0xff, 0x00, 0xf0, 0xf7, 0x6d, 0x05, 0x04,
  ]),
  decompressed: new Uint8Array([
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xfc, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff,
    0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xfc, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xfc, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xfc, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00,
  ]),
};

var img_8x8_rgba_etc2 = {
  compressed: new Uint8Array([
    0x35, 0x83, 0x6d, 0x26, 0x88, 0x46, 0x64, 0x37, 0x04, 0xf0, 0xf0, 0x02,
    0x07, 0x45, 0x00, 0x00, 0x69, 0xa8, 0x66, 0x76, 0x45, 0x68, 0x86, 0xd1,
    0x04, 0x0f, 0xff, 0x02, 0x07, 0x45, 0x00, 0x00, 0x69, 0xa8, 0x6d, 0xb2,
    0x53, 0x80, 0xaf, 0x41, 0x04, 0xf0, 0xf0, 0xf2, 0xf8, 0xba, 0x00, 0x00,
    0x8c, 0xca, 0xf4, 0x2b, 0x0a, 0x05, 0x34, 0x9b, 0x04, 0x0f, 0x0f, 0xf2,
    0xf8, 0xba, 0x00, 0x00,
  ]),
  decompressed: new Uint8Array([
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0x05,
    0x00, 0xff, 0x00, 0x05, 0xff, 0xff, 0x00, 0x05, 0x00, 0x00, 0xff, 0x05,
    0xff, 0xff, 0x00, 0x05, 0x00, 0x00, 0xff, 0x05, 0x00, 0xff, 0x00, 0x00,
    0x00, 0xff, 0x00, 0x05, 0xff, 0x00, 0x00, 0x15, 0x00, 0xff, 0x00, 0x25,
    0x00, 0x00, 0xff, 0x2d, 0x00, 0x00, 0xff, 0x2d, 0xff, 0xff, 0x00, 0x19,
    0x00, 0x00, 0xff, 0x05, 0xff, 0x00, 0x00, 0x05, 0xff, 0x00, 0x00, 0x15,
    0xff, 0x00, 0x00, 0x3d, 0x00, 0xff, 0x00, 0x5d, 0xff, 0xff, 0x00, 0x73,
    0xff, 0xff, 0x00, 0x55, 0xff, 0xff, 0x00, 0x2d, 0x00, 0x00, 0xff, 0x19,
    0x00, 0xff, 0x00, 0x05, 0x00, 0xff, 0x00, 0x25, 0x00, 0xff, 0x00, 0x5d,
    0x00, 0xff, 0x00, 0x95, 0x00, 0x00, 0xff, 0xc3, 0x00, 0x00, 0xff, 0x9b,
    0x00, 0x00, 0xff, 0x55, 0x00, 0x00, 0xff, 0x2d, 0x00, 0xff, 0x00, 0x05,
    0xff, 0x00, 0xff, 0x2d, 0x00, 0xff, 0x00, 0x73, 0xff, 0x00, 0xff, 0xc3,
    0x00, 0x00, 0xff, 0xf8, 0x00, 0xff, 0xff, 0xb0, 0x00, 0x00, 0xff, 0x74,
    0x00, 0xff, 0xff, 0x2c, 0xff, 0x00, 0xff, 0x05, 0xff, 0x00, 0xff, 0x2d,
    0x00, 0xff, 0x00, 0x55, 0xff, 0x00, 0xff, 0x9b, 0x00, 0xff, 0xff, 0xb0,
    0x00, 0xff, 0xff, 0x98, 0x00, 0x00, 0xff, 0x5c, 0x00, 0xff, 0xff, 0x2c,
    0x00, 0xff, 0x00, 0x05, 0x00, 0xff, 0x00, 0x19, 0x00, 0xff, 0x00, 0x2d,
    0xff, 0x00, 0xff, 0x55, 0x00, 0x00, 0xff, 0x74, 0x00, 0x00, 0xff, 0x5c,
    0x00, 0x00, 0xff, 0x2c, 0x00, 0xff, 0xff, 0x14, 0xff, 0x00, 0xff, 0x05,
    0xff, 0x00, 0xff, 0x05, 0xff, 0x00, 0xff, 0x19, 0xff, 0x00, 0xff, 0x2d,
    0x00, 0xff, 0xff, 0x2c, 0x00, 0xff, 0xff, 0x2c, 0x00, 0xff, 0xff, 0x14,
    0x00, 0xff, 0xff, 0x14,
  ]),
};

/* This image exercises every ETC2 block type */
var img_32x32_r11_eac = {
  compressed: new Uint8Array([
    0x6e, 0x61, 0x92, 0x08, 0x02, 0x01, 0x12, 0x53, 0x21, 0x32, 0xf2, 0x8d,
    0x01, 0xf0, 0x9f, 0x02, 0x2b, 0x4b, 0xd0, 0x9d, 0x41, 0xf0, 0x29, 0x12,
    0x1f, 0x30, 0xc0, 0x2e, 0x0a, 0xf0, 0xad, 0x02, 0x20, 0x34, 0xf0, 0x1b,
    0x42, 0xb6, 0x1a, 0x02, 0x1e, 0x34, 0xb0, 0x8d, 0x0a, 0xb0, 0x3f, 0x0a,
    0x2a, 0x21, 0xf1, 0xbf, 0x1a, 0xf1, 0x3e, 0x0b, 0x47, 0x32, 0x29, 0xb0,
    0x52, 0xb0, 0x1f, 0xac, 0x31, 0x4f, 0x9f, 0xc0, 0x49, 0x49, 0xb0, 0xdb,
    0x0a, 0x23, 0xda, 0x1c, 0x08, 0x18, 0x90, 0x21, 0x08, 0x2d, 0x08, 0x0c,
    0x92, 0x91, 0x22, 0x4a, 0x04, 0x00, 0x40, 0x70, 0x87, 0x40, 0x30, 0x9f,
    0x0c, 0x1c, 0x61, 0x30, 0xd2, 0x61, 0x3a, 0x83, 0x12, 0x14, 0x81, 0x9c,
    0x8b, 0x50, 0xb4, 0x39, 0x1a, 0x28, 0x66, 0x00, 0x64, 0xa0, 0x51, 0x45,
    0x2e, 0x33, 0x42, 0x02, 0x64, 0xb6, 0xdf, 0xff, 0x34, 0x31, 0x82, 0x62,
    0x08, 0x48, 0xb6, 0x9b, 0x07, 0x2d, 0xa3, 0x45, 0x60, 0x2b, 0x10, 0x44,
    0x08, 0x18, 0x67, 0x12, 0x86, 0x24, 0x92, 0x5b, 0x02, 0x00, 0xe0, 0x3e,
    0x10, 0xe9, 0x74, 0xd5, 0x08, 0x1c, 0x09, 0x44, 0x88, 0x84, 0xe9, 0xa4,
    0x16, 0x19, 0x4a, 0xdf, 0x6d, 0xbe, 0xd7, 0x6d, 0x20, 0x11, 0x4f, 0xe6,
    0xb6, 0xef, 0x6f, 0xf6, 0x2f, 0x44, 0xb2, 0xc9, 0x24, 0xbb, 0x6f, 0xff,
    0x2c, 0x41, 0xdb, 0xf9, 0x65, 0x12, 0x44, 0x8c, 0x07, 0x13, 0x09, 0x54,
    0xdb, 0x29, 0xb4, 0x9a, 0x01, 0x02, 0x6c, 0xf2, 0xd9, 0xb5, 0xbb, 0x6d,
    0x0e, 0x15, 0x64, 0x96, 0x40, 0x28, 0x41, 0x24, 0x14, 0x13, 0x6a, 0x48,
    0xe7, 0x5e, 0x7f, 0xbe, 0x1e, 0x19, 0x92, 0x69, 0xa6, 0x87, 0x4f, 0xff,
    0x36, 0x14, 0x6d, 0x14, 0x40, 0x12, 0x5b, 0xb7, 0x54, 0x2b, 0x6d, 0xa4,
    0x91, 0x00, 0x0b, 0x6d, 0x19, 0x43, 0xfe, 0xdf, 0xa4, 0xd8, 0x0d, 0x09,
    0x10, 0x21, 0xf0, 0x10, 0x00, 0x44, 0x04, 0x91, 0x01, 0x23, 0x92, 0x49,
    0x34, 0x9b, 0x69, 0x37, 0x11, 0x18, 0x6c, 0x00, 0x07, 0xe2, 0xdf, 0xed,
    0x21, 0x23, 0x40, 0x28, 0x84, 0xd0, 0x49, 0xb0, 0x13, 0x36, 0x9b, 0x6d,
    0x36, 0xdf, 0xff, 0xff, 0x38, 0x17, 0x26, 0x49, 0xb6, 0xda, 0xdf, 0xfe,
    0x60, 0x44, 0x49, 0x22, 0x49, 0x00, 0x09, 0x24, 0x2c, 0x53, 0x9b, 0x62,
    0x44, 0x29, 0x14, 0x89, 0x0b, 0x1c, 0x93, 0xf0, 0x3f, 0x82, 0xd9, 0xfd,
    0x0f, 0x13, 0x3f, 0xf5, 0xbf, 0x3b, 0x6f, 0xf6, 0x1e, 0x10, 0xb7, 0x27,
    0x74, 0xa4, 0x43, 0x62, 0x21, 0x1a, 0x00, 0x50, 0x07, 0x17, 0xfb, 0x6f,
    0x36, 0x11, 0x6c, 0x0c, 0x00, 0x96, 0xcd, 0x6c, 0x3f, 0x1d, 0x80, 0xab,
    0x01, 0xd6, 0x0d, 0xac, 0x4c, 0x23, 0x49, 0x20, 0x00, 0xb6, 0xdf, 0xff,
    0x35, 0x20, 0xdb, 0xfd, 0xed, 0x36, 0xd6, 0x49, 0x1e, 0x19, 0x22, 0xf4,
    0x2f, 0x66, 0x66, 0x66, 0x19, 0x13, 0x3b, 0x69, 0xb7, 0x9f, 0xfd, 0xbf,
    0x2b, 0x16, 0x4e, 0x76, 0x25, 0x02, 0x72, 0xaf, 0x35, 0x10, 0x68, 0x54,
    0x85, 0x03, 0x61, 0x26, 0x39, 0x1d, 0x44, 0x42, 0x25, 0x12, 0xeb, 0x76,
    0x3d, 0x1d, 0x29, 0x20, 0x09, 0xb2, 0x4d, 0xb6, 0x65, 0x37, 0x6d, 0xb4,
    0x91, 0x20, 0x49, 0x77, 0x68, 0x42, 0x17, 0xf4, 0x2f, 0x68, 0x56, 0xd5,
    0x49, 0x54, 0x02, 0x60, 0x26, 0x22, 0x62, 0x26, 0x5a, 0x4c, 0x68, 0x56,
    0x84, 0x68, 0x46, 0x84, 0x4a, 0x27, 0x66, 0x74, 0x67, 0x46, 0x74, 0x2f,
    0x53, 0x2b, 0x68, 0x66, 0x85, 0x68, 0x56, 0x85, 0x51, 0x2b, 0x68, 0x66,
    0x86, 0x68, 0x66, 0x86, 0x52, 0x25, 0x68, 0x46, 0x45, 0x66, 0x64, 0x27,
    0x77, 0x32, 0x6d, 0x16, 0x8c, 0x46, 0x61, 0x37,
  ]),
  decompressed: new Uint8Array([
    0x7a, 0x00, 0x00, 0xff, 0x7a, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff,
    0x44, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff, 0x36, 0x00, 0x00, 0xff,
    0x45, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff, 0x43, 0x00, 0x00, 0xff,
    0x43, 0x00, 0x00, 0xff, 0x4f, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff,
    0x37, 0x00, 0x00, 0xff, 0x49, 0x00, 0x00, 0xff, 0x49, 0x00, 0x00, 0xff,
    0x37, 0x00, 0x00, 0xff, 0x41, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff,
    0x2f, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff, 0x2d, 0x00, 0x00, 0xff,
    0x33, 0x00, 0x00, 0xff, 0x2d, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff,
    0x42, 0x00, 0x00, 0xff, 0x42, 0x00, 0x00, 0xff, 0x42, 0x00, 0x00, 0xff,
    0x42, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff, 0x41, 0x00, 0x00, 0xff,
    0x53, 0x00, 0x00, 0xff, 0x6b, 0x00, 0x00, 0xff, 0x7a, 0x00, 0x00, 0xff,
    0x5c, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff, 0x44, 0x00, 0x00, 0xff,
    0x24, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff,
    0x24, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff,
    0x2f, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x16, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff,
    0x26, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff,
    0x17, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff,
    0x24, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff, 0x2e, 0x00, 0x00, 0xff,
    0x2e, 0x00, 0x00, 0xff, 0x2e, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff,
    0x2f, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff, 0x4a, 0x00, 0x00, 0xff,
    0x5c, 0x00, 0x00, 0xff, 0x7a, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff,
    0x32, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff, 0x2d, 0x00, 0x00, 0xff,
    0x1b, 0x00, 0x00, 0xff, 0x12, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff,
    0x17, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff,
    0x0d, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff, 0x17, 0x00, 0x00, 0xff,
    0x17, 0x00, 0x00, 0xff, 0x26, 0x00, 0x00, 0xff, 0x17, 0x00, 0x00, 0xff,
    0x0c, 0x00, 0x00, 0xff, 0x0c, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff,
    0x0c, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff,
    0x16, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff,
    0x2f, 0x00, 0x00, 0xff, 0x41, 0x00, 0x00, 0xff, 0x53, 0x00, 0x00, 0xff,
    0x5c, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff, 0x44, 0x00, 0x00, 0xff,
    0x20, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff, 0x12, 0x00, 0x00, 0xff,
    0x12, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff, 0x17, 0x00, 0x00, 0xff,
    0x17, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff, 0x08, 0x00, 0x00, 0xff,
    0x0e, 0x00, 0x00, 0xff, 0x08, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff,
    0x06, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x10, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff,
    0x10, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff,
    0x38, 0x00, 0x00, 0xff, 0x4a, 0x00, 0x00, 0xff, 0x39, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x06, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff, 0x0c, 0x00, 0x00, 0xff,
    0x08, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x19, 0x00, 0x00, 0xff,
    0x0a, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x16, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x1c, 0x00, 0x00, 0xff, 0x22, 0x00, 0x00, 0xff, 0x37, 0x00, 0x00, 0xff,
    0x52, 0x00, 0x00, 0xff, 0x51, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff,
    0x15, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff,
    0x06, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x08, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff,
    0x16, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff,
    0x22, 0x00, 0x00, 0xff, 0x37, 0x00, 0x00, 0xff, 0x52, 0x00, 0x00, 0xff,
    0x51, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff,
    0x0d, 0x00, 0x00, 0xff, 0x0c, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x0c, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff,
    0x05, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x0c, 0x00, 0x00, 0xff, 0x0c, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff,
    0x1c, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x16, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff,
    0x37, 0x00, 0x00, 0xff, 0x52, 0x00, 0x00, 0xff, 0x39, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x06, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x0c, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x06, 0x00, 0x00, 0xff, 0x0c, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x1c, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff,
    0x28, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff, 0x37, 0x00, 0x00, 0xff,
    0x52, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff,
    0x16, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff,
    0x01, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff,
    0x01, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff,
    0x0e, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff,
    0x0c, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff, 0x13, 0x00, 0x00, 0xff,
    0x2c, 0x00, 0x00, 0xff, 0x2c, 0x00, 0x00, 0xff, 0x43, 0x00, 0x00, 0xff,
    0x37, 0x00, 0x00, 0xff, 0x43, 0x00, 0x00, 0xff, 0x5b, 0x00, 0x00, 0xff,
    0x2b, 0x00, 0x00, 0xff, 0x2b, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x16, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff,
    0x01, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff,
    0x1a, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff,
    0x13, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff, 0x13, 0x00, 0x00, 0xff,
    0x2c, 0x00, 0x00, 0xff, 0x37, 0x00, 0x00, 0xff, 0x37, 0x00, 0x00, 0xff,
    0x4b, 0x00, 0x00, 0xff, 0x5b, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x1f, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff,
    0x0b, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff,
    0x05, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x01, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff,
    0x01, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff,
    0x0a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff,
    0x1a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x2c, 0x00, 0x00, 0xff,
    0x29, 0x00, 0x00, 0xff, 0x29, 0x00, 0x00, 0xff, 0x29, 0x00, 0x00, 0xff,
    0x43, 0x00, 0x00, 0xff, 0x37, 0x00, 0x00, 0xff, 0x4b, 0x00, 0x00, 0xff,
    0x5b, 0x00, 0x00, 0xff, 0x4f, 0x00, 0x00, 0xff, 0x2b, 0x00, 0x00, 0xff,
    0x0d, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x05, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff,
    0x05, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff,
    0x1a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff,
    0x1a, 0x00, 0x00, 0xff, 0x29, 0x00, 0x00, 0xff, 0x29, 0x00, 0x00, 0xff,
    0x29, 0x00, 0x00, 0xff, 0x29, 0x00, 0x00, 0xff, 0x37, 0x00, 0x00, 0xff,
    0x37, 0x00, 0x00, 0xff, 0x4b, 0x00, 0x00, 0xff, 0x5b, 0x00, 0x00, 0xff,
    0x50, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff,
    0x03, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x03, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x0b, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff,
    0x0e, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff,
    0x1f, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x27, 0x00, 0x00, 0xff,
    0x2a, 0x00, 0x00, 0xff, 0x2e, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff,
    0x3b, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff,
    0x50, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0xff,
    0x44, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff,
    0x01, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff,
    0x01, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x07, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff,
    0x0e, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff,
    0x19, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff,
    0x19, 0x00, 0x00, 0xff, 0x27, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff,
    0x30, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff,
    0x40, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0xff,
    0x5c, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff,
    0x34, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff,
    0x0b, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff,
    0x15, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff,
    0x1f, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff,
    0x27, 0x00, 0x00, 0xff, 0x2e, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff,
    0x38, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x46, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff,
    0x5c, 0x00, 0x00, 0xff, 0x44, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff,
    0x34, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x07, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff,
    0x10, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff,
    0x20, 0x00, 0x00, 0xff, 0x19, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x27, 0x00, 0x00, 0xff,
    0x30, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff,
    0x41, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff, 0x4a, 0x00, 0x00, 0xff,
    0x50, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff, 0x49, 0x00, 0x00, 0xff,
    0x49, 0x00, 0x00, 0xff, 0x2d, 0x00, 0x00, 0xff, 0x2d, 0x00, 0x00, 0xff,
    0x28, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x03, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff,
    0x15, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff, 0x2b, 0x00, 0x00, 0xff,
    0x23, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff,
    0x28, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff,
    0x3a, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x42, 0x00, 0x00, 0xff,
    0x40, 0x00, 0x00, 0xff, 0x48, 0x00, 0x00, 0xff, 0x54, 0x00, 0x00, 0xff,
    0x68, 0x00, 0x00, 0xff, 0x49, 0x00, 0x00, 0xff, 0x2d, 0x00, 0x00, 0xff,
    0x2d, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff,
    0x0a, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x03, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff,
    0x03, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff,
    0x15, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff, 0x2b, 0x00, 0x00, 0xff,
    0x28, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff,
    0x31, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff,
    0x3f, 0x00, 0x00, 0xff, 0x42, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x48, 0x00, 0x00, 0xff, 0x54, 0x00, 0x00, 0xff, 0x68, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0x11, 0x00, 0x00, 0xff,
    0x09, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff,
    0x0a, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x0b, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x16, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0x2b, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff,
    0x28, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff,
    0x3a, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff,
    0x42, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff, 0x48, 0x00, 0x00, 0xff,
    0x54, 0x00, 0x00, 0xff, 0x68, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0x11, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x0b, 0x00, 0x00, 0xff, 0x19, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff,
    0x1a, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x15, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff,
    0x31, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3f, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff,
    0x40, 0x00, 0x00, 0xff, 0x48, 0x00, 0x00, 0xff, 0x54, 0x00, 0x00, 0xff,
    0x68, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff, 0x18, 0x00, 0x00, 0xff,
    0x18, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff,
    0x08, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff,
    0x0b, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff,
    0x1b, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff,
    0x23, 0x00, 0x00, 0xff, 0x18, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff,
    0x1f, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff,
    0x29, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff,
    0x3f, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x41, 0x00, 0x00, 0xff, 0x41, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x48, 0x00, 0x00, 0xff, 0x52, 0x00, 0x00, 0xff, 0x64, 0x00, 0x00, 0xff,
    0x45, 0x00, 0x00, 0xff, 0x18, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff,
    0x0e, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff, 0x08, 0x00, 0x00, 0xff,
    0x08, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff,
    0x23, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff, 0x18, 0x00, 0x00, 0xff,
    0x23, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff,
    0x24, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff, 0x29, 0x00, 0x00, 0xff,
    0x33, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff,
    0x3e, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x41, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff, 0x48, 0x00, 0x00, 0xff,
    0x52, 0x00, 0x00, 0xff, 0x64, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff,
    0x22, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff, 0x18, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x26, 0x00, 0x00, 0xff,
    0x26, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff,
    0x1f, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff,
    0x24, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff,
    0x3c, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff,
    0x3e, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x40, 0x00, 0x00, 0xff, 0x48, 0x00, 0x00, 0xff, 0x52, 0x00, 0x00, 0xff,
    0x64, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff,
    0x18, 0x00, 0x00, 0xff, 0x18, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff,
    0x1b, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff,
    0x20, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff,
    0x2a, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff,
    0x33, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff,
    0x38, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff,
    0x3e, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x48, 0x00, 0x00, 0xff, 0x52, 0x00, 0x00, 0xff, 0x64, 0x00, 0x00, 0xff,
    0x45, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff, 0x29, 0x00, 0x00, 0xff,
    0x17, 0x00, 0x00, 0xff, 0x19, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff,
    0x1a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff,
    0x23, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff, 0x27, 0x00, 0x00, 0xff,
    0x24, 0x00, 0x00, 0xff, 0x26, 0x00, 0x00, 0xff, 0x2c, 0x00, 0x00, 0xff,
    0x32, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff, 0x36, 0x00, 0x00, 0xff,
    0x37, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3b, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff, 0x3e, 0x00, 0x00, 0xff,
    0x3f, 0x00, 0x00, 0xff, 0x44, 0x00, 0x00, 0xff, 0x4d, 0x00, 0x00, 0xff,
    0x56, 0x00, 0x00, 0xff, 0x6b, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff,
    0x51, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x29, 0x00, 0x00, 0xff,
    0x1c, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x19, 0x00, 0x00, 0xff,
    0x19, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff,
    0x27, 0x00, 0x00, 0xff, 0x27, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff,
    0x2c, 0x00, 0x00, 0xff, 0x2c, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff,
    0x37, 0x00, 0x00, 0xff, 0x37, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff,
    0x39, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3c, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff,
    0x44, 0x00, 0x00, 0xff, 0x4d, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff,
    0x71, 0x00, 0x00, 0xff, 0x51, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff,
    0x3f, 0x00, 0x00, 0xff, 0x29, 0x00, 0x00, 0xff, 0x22, 0x00, 0x00, 0xff,
    0x22, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff,
    0x1e, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x2e, 0x00, 0x00, 0xff, 0x2e, 0x00, 0x00, 0xff,
    0x2e, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff,
    0x32, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff, 0x37, 0x00, 0x00, 0xff,
    0x38, 0x00, 0x00, 0xff, 0x39, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3b, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff,
    0x3d, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x44, 0x00, 0x00, 0xff,
    0x4d, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff, 0x7a, 0x00, 0x00, 0xff,
    0x51, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff,
    0x29, 0x00, 0x00, 0xff, 0x27, 0x00, 0x00, 0xff, 0x27, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff,
    0x35, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff, 0x35, 0x00, 0x00, 0xff,
    0x35, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3d, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff, 0x39, 0x00, 0x00, 0xff,
    0x3a, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff,
    0x3a, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff,
    0x3f, 0x00, 0x00, 0xff, 0x44, 0x00, 0x00, 0xff, 0x56, 0x00, 0x00, 0xff,
    0x6b, 0x00, 0x00, 0xff, 0x83, 0x00, 0x00, 0xff, 0x60, 0x00, 0x00, 0xff,
    0x48, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff,
    0x3a, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff, 0x2b, 0x00, 0x00, 0xff,
    0x2b, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff,
    0x32, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff,
    0x3a, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3f, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff,
    0x3f, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff,
    0x3d, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff,
    0x3c, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x50, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0xff, 0x5f, 0x00, 0x00, 0xff,
    0x71, 0x00, 0x00, 0xff, 0x78, 0x00, 0x00, 0xff, 0x60, 0x00, 0x00, 0xff,
    0x48, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3a, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3e, 0x00, 0x00, 0xff, 0x3e, 0x00, 0x00, 0xff, 0x3e, 0x00, 0x00, 0xff,
    0x3e, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x40, 0x00, 0x00, 0xff, 0x44, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff,
    0x45, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff,
    0x43, 0x00, 0x00, 0xff, 0x43, 0x00, 0x00, 0xff, 0x43, 0x00, 0x00, 0xff,
    0x43, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff, 0x44, 0x00, 0x00, 0xff,
    0x44, 0x00, 0x00, 0xff, 0x4c, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0xff,
    0x5f, 0x00, 0x00, 0xff, 0x68, 0x00, 0x00, 0xff, 0x7a, 0x00, 0x00, 0xff,
    0x98, 0x00, 0x00, 0xff, 0x78, 0x00, 0x00, 0xff, 0x60, 0x00, 0x00, 0xff,
    0x48, 0x00, 0x00, 0xff, 0x53, 0x00, 0x00, 0xff, 0x53, 0x00, 0x00, 0xff,
    0x53, 0x00, 0x00, 0xff, 0x53, 0x00, 0x00, 0xff, 0x4e, 0x00, 0x00, 0xff,
    0x4e, 0x00, 0x00, 0xff, 0x4e, 0x00, 0x00, 0xff, 0x4e, 0x00, 0x00, 0xff,
    0x4e, 0x00, 0x00, 0xff, 0x4e, 0x00, 0x00, 0xff, 0x4e, 0x00, 0x00, 0xff,
    0x52, 0x00, 0x00, 0xff, 0x4f, 0x00, 0x00, 0xff, 0x4f, 0x00, 0x00, 0xff,
    0x4f, 0x00, 0x00, 0xff, 0x4f, 0x00, 0x00, 0xff, 0x4d, 0x00, 0x00, 0xff,
    0x4d, 0x00, 0x00, 0xff, 0x4d, 0x00, 0x00, 0xff, 0x4d, 0x00, 0x00, 0xff,
    0x4c, 0x00, 0x00, 0xff, 0x4c, 0x00, 0x00, 0xff, 0x56, 0x00, 0x00, 0xff,
    0x56, 0x00, 0x00, 0xff, 0x5f, 0x00, 0x00, 0xff, 0x68, 0x00, 0x00, 0xff,
    0x7a, 0x00, 0x00, 0xff, 0x8c, 0x00, 0x00, 0xff, 0x98, 0x00, 0x00, 0xff,
    0x98, 0x00, 0x00, 0xff, 0x78, 0x00, 0x00, 0xff, 0x78, 0x00, 0x00, 0xff,
    0x6c, 0x00, 0x00, 0xff, 0x6c, 0x00, 0x00, 0xff, 0x6c, 0x00, 0x00, 0xff,
    0x6c, 0x00, 0x00, 0xff, 0x66, 0x00, 0x00, 0xff, 0x62, 0x00, 0x00, 0xff,
    0x62, 0x00, 0x00, 0xff, 0x62, 0x00, 0x00, 0xff, 0x5e, 0x00, 0x00, 0xff,
    0x5e, 0x00, 0x00, 0xff, 0x5e, 0x00, 0x00, 0xff, 0x5e, 0x00, 0x00, 0xff,
    0x5f, 0x00, 0x00, 0xff, 0x5b, 0x00, 0x00, 0xff, 0x5b, 0x00, 0x00, 0xff,
    0x5b, 0x00, 0x00, 0xff, 0x5d, 0x00, 0x00, 0xff, 0x5d, 0x00, 0x00, 0xff,
    0x5d, 0x00, 0x00, 0xff, 0x5d, 0x00, 0x00, 0xff, 0x56, 0x00, 0x00, 0xff,
    0x5e, 0x00, 0x00, 0xff, 0x62, 0x00, 0x00, 0xff, 0x66, 0x00, 0x00, 0xff,
    0x68, 0x00, 0x00, 0xff, 0x7a, 0x00, 0x00, 0xff, 0x8c, 0x00, 0x00, 0xff,
    0x9b, 0x00, 0x00, 0xff,
  ]),
};

var img_32x32_signed_r11_eac = {
  compressed: new Uint8Array([
    0xef, 0x61, 0x92, 0x08, 0x02, 0x01, 0x12, 0x53, 0xa2, 0x32, 0xf2, 0x8d,
    0x01, 0xf0, 0x9f, 0x02, 0xab, 0x4b, 0xd0, 0x9d, 0x41, 0xf0, 0x29, 0x12,
    0xa0, 0x30, 0xc0, 0x2e, 0x0a, 0xf0, 0xad, 0x02, 0xa1, 0x34, 0xf0, 0x1b,
    0x42, 0xb6, 0x1a, 0x02, 0x9f, 0x34, 0xb0, 0x8d, 0x0a, 0xb0, 0x3f, 0x0a,
    0xaa, 0x21, 0xf1, 0xbf, 0x1a, 0xf1, 0x3e, 0x0b, 0xc8, 0x32, 0x29, 0xb0,
    0x52, 0xb0, 0x1f, 0xac, 0xb2, 0x4f, 0x9f, 0xc0, 0x49, 0x49, 0xb0, 0xdb,
    0x8a, 0x16, 0xfe, 0x1e, 0x08, 0x1d, 0x20, 0x22, 0x88, 0x2d, 0x08, 0x0c,
    0x92, 0x91, 0x10, 0x02, 0x85, 0x1d, 0x20, 0x60, 0x46, 0x20, 0x20, 0x56,
    0x8c, 0x1c, 0x61, 0x30, 0xd2, 0x61, 0x3a, 0x83, 0x93, 0x11, 0x81, 0x9c,
    0x8b, 0x50, 0xb4, 0x39, 0x94, 0x2f, 0x42, 0xc8, 0x2d, 0xf2, 0x79, 0xe7,
    0xaf, 0x33, 0x42, 0x02, 0x64, 0xb6, 0xdf, 0xff, 0xb5, 0x31, 0x82, 0x62,
    0x08, 0x48, 0xb6, 0x9b, 0x84, 0x1a, 0xd7, 0x51, 0xac, 0x83, 0x0b, 0x25,
    0x8a, 0x16, 0x66, 0xa4, 0x85, 0x49, 0x22, 0x5b, 0x83, 0x1d, 0xa0, 0x2a,
    0x08, 0xc4, 0xe2, 0x8c, 0x8d, 0x15, 0x2d, 0x86, 0xd1, 0x09, 0x41, 0x00,
    0x96, 0x19, 0x4a, 0xdf, 0x6d, 0xbe, 0xd7, 0x6d, 0xa1, 0x11, 0x4f, 0xe6,
    0xb6, 0xef, 0x6f, 0xf6, 0xb0, 0x44, 0xb2, 0xc9, 0x24, 0xbb, 0x6f, 0xff,
    0xad, 0x41, 0xdb, 0xf9, 0x65, 0x12, 0x44, 0x8c, 0x82, 0x1d, 0xd2, 0x78,
    0x49, 0xa0, 0x90, 0x08, 0x82, 0x00, 0x6c, 0xe2, 0xd9, 0x91, 0xb9, 0x24,
    0x8e, 0x15, 0x64, 0x96, 0x40, 0x28, 0x41, 0x24, 0x95, 0x13, 0x6a, 0x48,
    0xe7, 0x5c, 0x7f, 0xbe, 0xa1, 0x18, 0x00, 0x51, 0x45, 0x0a, 0x8d, 0xb6,
    0xb7, 0x14, 0x6d, 0x14, 0x40, 0x12, 0x5b, 0xb7, 0xcf, 0x10, 0x6d, 0xa4,
    0x89, 0x92, 0x4f, 0xff, 0x99, 0x43, 0xfe, 0xdf, 0xa4, 0xd8, 0x0d, 0x09,
    0x90, 0x21, 0xf0, 0x10, 0x00, 0x44, 0x02, 0x89, 0x89, 0x2d, 0x49, 0x24,
    0xaa, 0x56, 0xd4, 0xaf, 0x91, 0x18, 0x6c, 0x00, 0x07, 0xe2, 0xdf, 0xed,
    0xa1, 0x23, 0x40, 0x28, 0x84, 0xd0, 0x49, 0xb0, 0x93, 0x36, 0x9b, 0x6d,
    0x36, 0xdf, 0xff, 0xff, 0xbc, 0x12, 0x48, 0x01, 0x6d, 0xb6, 0x4d, 0xb5,
    0xe1, 0x44, 0x49, 0x22, 0x49, 0x00, 0x09, 0x24, 0xad, 0x53, 0x9b, 0x62,
    0x44, 0x29, 0x14, 0x89, 0x8b, 0x1c, 0x93, 0xf0, 0x3f, 0x82, 0xd9, 0xfd,
    0x91, 0x16, 0x1f, 0xf3, 0x3f, 0x12, 0x4f, 0xe4, 0x9e, 0x10, 0xb7, 0x27,
    0x74, 0xa4, 0x43, 0x62, 0xa1, 0x1a, 0x00, 0x50, 0x07, 0x17, 0xfb, 0x6f,
    0xb6, 0x11, 0x6c, 0x0c, 0x00, 0x96, 0xcd, 0x6c, 0xc0, 0x1d, 0x05, 0x28,
    0x0a, 0xb0, 0x1d, 0x60, 0xcd, 0x23, 0x49, 0x20, 0x00, 0xb6, 0xdf, 0xff,
    0xb6, 0x20, 0xdb, 0xfd, 0xed, 0x36, 0xd6, 0x49, 0x9f, 0x19, 0x22, 0xf4,
    0x67, 0x66, 0x66, 0x66, 0x99, 0x13, 0x3b, 0x6b, 0xb7, 0xbf, 0xfd, 0xbf,
    0xab, 0x17, 0x4e, 0xf6, 0x2e, 0x02, 0xf2, 0xb7, 0xb1, 0x11, 0x42, 0x60,
    0x26, 0x93, 0xf9, 0x6f, 0xba, 0x1d, 0x48, 0x84, 0x44, 0x22, 0x59, 0x2e,
    0xbd, 0x1d, 0x29, 0x20, 0x09, 0xb2, 0x4d, 0xb6, 0xe6, 0x37, 0x6d, 0xb4,
    0x91, 0x20, 0x49, 0x77, 0xe8, 0x42, 0x17, 0xf4, 0x2f, 0x68, 0x56, 0xd5,
    0xc9, 0x54, 0x02, 0x60, 0x26, 0x22, 0x62, 0x26, 0xcc, 0x21, 0x66, 0x76,
    0x67, 0x66, 0x76, 0x67, 0xcb, 0x27, 0x66, 0x74, 0x67, 0x46, 0x74, 0x2f,
    0xd4, 0x2b, 0x68, 0x66, 0x85, 0x68, 0x56, 0x85, 0xd2, 0x2b, 0x68, 0x66,
    0x86, 0x68, 0x66, 0x86, 0xd3, 0x25, 0x68, 0x46, 0x45, 0x66, 0x64, 0x27,
    0xf8, 0x32, 0x6d, 0x16, 0x8c, 0x46, 0x61, 0x37,
  ]),
  decompressed: new Uint8Array([
    0x7b, 0x00, 0x00, 0xff, 0x7b, 0x00, 0x00, 0xff, 0x5d, 0x00, 0x00, 0xff,
    0x45, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff, 0x37, 0x00, 0x00, 0xff,
    0x46, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff, 0x43, 0x00, 0x00, 0xff,
    0x43, 0x00, 0x00, 0xff, 0x4f, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff,
    0x38, 0x00, 0x00, 0xff, 0x4a, 0x00, 0x00, 0xff, 0x4a, 0x00, 0x00, 0xff,
    0x38, 0x00, 0x00, 0xff, 0x42, 0x00, 0x00, 0xff, 0x30, 0x00, 0x00, 0xff,
    0x30, 0x00, 0x00, 0xff, 0x30, 0x00, 0x00, 0xff, 0x2e, 0x00, 0x00, 0xff,
    0x34, 0x00, 0x00, 0xff, 0x2e, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x42, 0x00, 0x00, 0xff, 0x42, 0x00, 0x00, 0xff, 0x42, 0x00, 0x00, 0xff,
    0x42, 0x00, 0x00, 0xff, 0x39, 0x00, 0x00, 0xff, 0x42, 0x00, 0x00, 0xff,
    0x54, 0x00, 0x00, 0xff, 0x6c, 0x00, 0x00, 0xff, 0x7b, 0x00, 0x00, 0xff,
    0x5d, 0x00, 0x00, 0xff, 0x5d, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff,
    0x2f, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff, 0x17, 0x00, 0x00, 0xff,
    0x17, 0x00, 0x00, 0xff, 0x26, 0x00, 0x00, 0xff, 0x26, 0x00, 0x00, 0xff,
    0x27, 0x00, 0x00, 0xff, 0x30, 0x00, 0x00, 0xff, 0x30, 0x00, 0x00, 0xff,
    0x18, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff, 0x2e, 0x00, 0x00, 0xff,
    0x2e, 0x00, 0x00, 0xff, 0x2e, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff,
    0x30, 0x00, 0x00, 0xff, 0x39, 0x00, 0x00, 0xff, 0x4b, 0x00, 0x00, 0xff,
    0x5d, 0x00, 0x00, 0xff, 0x7b, 0x00, 0x00, 0xff, 0x5d, 0x00, 0x00, 0xff,
    0x33, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff, 0x2e, 0x00, 0x00, 0xff,
    0x1c, 0x00, 0x00, 0xff, 0x13, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff,
    0x17, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x17, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff,
    0x0e, 0x00, 0x00, 0xff, 0x17, 0x00, 0x00, 0xff, 0x18, 0x00, 0x00, 0xff,
    0x18, 0x00, 0x00, 0xff, 0x27, 0x00, 0x00, 0xff, 0x18, 0x00, 0x00, 0xff,
    0x0d, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x0d, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff,
    0x16, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x21, 0x00, 0x00, 0xff,
    0x30, 0x00, 0x00, 0xff, 0x42, 0x00, 0x00, 0xff, 0x54, 0x00, 0x00, 0xff,
    0x5d, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff,
    0x21, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x13, 0x00, 0x00, 0xff,
    0x13, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff, 0x17, 0x00, 0x00, 0xff,
    0x17, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff,
    0x05, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff,
    0x05, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x07, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x10, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff,
    0x10, 0x00, 0x00, 0xff, 0x21, 0x00, 0x00, 0xff, 0x30, 0x00, 0x00, 0xff,
    0x39, 0x00, 0x00, 0xff, 0x4b, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x26, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff, 0x26, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x06, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff, 0x0c, 0x00, 0x00, 0xff,
    0x08, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff,
    0x09, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x18, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff, 0x18, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff,
    0x53, 0x00, 0x00, 0xff, 0x52, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff,
    0x16, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff,
    0x06, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x08, 0x00, 0x00, 0xff,
    0x06, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff,
    0x10, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff,
    0x10, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff,
    0x18, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff, 0x29, 0x00, 0x00, 0xff,
    0x23, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff, 0x53, 0x00, 0x00, 0xff,
    0x52, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff,
    0x0e, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff,
    0x05, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x0c, 0x00, 0x00, 0xff, 0x0c, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff,
    0x1c, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x18, 0x00, 0x00, 0xff,
    0x18, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff,
    0x38, 0x00, 0x00, 0xff, 0x53, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x1e, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff,
    0x03, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x07, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x0c, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x06, 0x00, 0x00, 0xff, 0x0c, 0x00, 0x00, 0xff, 0x18, 0x00, 0x00, 0xff,
    0x1c, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff,
    0x29, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff,
    0x53, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff,
    0x17, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x03, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff,
    0x05, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff,
    0x0e, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff,
    0x0c, 0x00, 0x00, 0xff, 0x17, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff,
    0x2d, 0x00, 0x00, 0xff, 0x2d, 0x00, 0x00, 0xff, 0x44, 0x00, 0x00, 0xff,
    0x38, 0x00, 0x00, 0xff, 0x44, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff,
    0x2c, 0x00, 0x00, 0xff, 0x2c, 0x00, 0x00, 0xff, 0x17, 0x00, 0x00, 0xff,
    0x17, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x04, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff,
    0x1a, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x17, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff,
    0x2d, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff,
    0x4c, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff,
    0x20, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff,
    0x0b, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff,
    0x05, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff, 0x06, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x01, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff,
    0x0a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff,
    0x1a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x2d, 0x00, 0x00, 0xff,
    0x2a, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff,
    0x44, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff, 0x4c, 0x00, 0x00, 0xff,
    0x5c, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0xff, 0x2c, 0x00, 0x00, 0xff,
    0x0e, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x05, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x05, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff,
    0x06, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff,
    0x1a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff,
    0x1a, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff,
    0x2a, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff,
    0x38, 0x00, 0x00, 0xff, 0x4c, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff,
    0x51, 0x00, 0x00, 0xff, 0x35, 0x00, 0x00, 0xff, 0x21, 0x00, 0x00, 0xff,
    0x05, 0x00, 0x00, 0xff, 0x04, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x03, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x01, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x03, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x0b, 0x00, 0x00, 0xff, 0x08, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x21, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff,
    0x1f, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff,
    0x2b, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff,
    0x3c, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff,
    0x51, 0x00, 0x00, 0xff, 0x5d, 0x00, 0x00, 0xff, 0x51, 0x00, 0x00, 0xff,
    0x45, 0x00, 0x00, 0xff, 0x35, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff,
    0x01, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x07, 0x00, 0x00, 0xff, 0x05, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x08, 0x00, 0x00, 0xff, 0x21, 0x00, 0x00, 0xff,
    0x1a, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x26, 0x00, 0x00, 0xff,
    0x19, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff, 0x2b, 0x00, 0x00, 0xff,
    0x31, 0x00, 0x00, 0xff, 0x39, 0x00, 0x00, 0xff, 0x3e, 0x00, 0x00, 0xff,
    0x40, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff, 0x51, 0x00, 0x00, 0xff,
    0x5d, 0x00, 0x00, 0xff, 0x5d, 0x00, 0x00, 0xff, 0x35, 0x00, 0x00, 0xff,
    0x35, 0x00, 0x00, 0xff, 0x11, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x01, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff,
    0x0b, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x16, 0x00, 0x00, 0xff, 0x13, 0x00, 0x00, 0xff, 0x21, 0x00, 0x00, 0xff,
    0x1f, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x26, 0x00, 0x00, 0xff,
    0x28, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff,
    0x39, 0x00, 0x00, 0xff, 0x3e, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x49, 0x00, 0x00, 0xff, 0x51, 0x00, 0x00, 0xff, 0x5d, 0x00, 0x00, 0xff,
    0x5d, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff, 0x35, 0x00, 0x00, 0xff,
    0x35, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x01, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff,
    0x07, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0xff,
    0x10, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff, 0x21, 0x00, 0x00, 0xff,
    0x21, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x26, 0x00, 0x00, 0xff,
    0x26, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff,
    0x31, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff,
    0x42, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff, 0x49, 0x00, 0x00, 0xff,
    0x51, 0x00, 0x00, 0xff, 0x5d, 0x00, 0x00, 0xff, 0x49, 0x00, 0x00, 0xff,
    0x49, 0x00, 0x00, 0xff, 0x2d, 0x00, 0x00, 0xff, 0x2d, 0x00, 0x00, 0xff,
    0x28, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x03, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff,
    0x15, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff, 0x2b, 0x00, 0x00, 0xff,
    0x23, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff,
    0x28, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff,
    0x3a, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff, 0x43, 0x00, 0x00, 0xff,
    0x41, 0x00, 0x00, 0xff, 0x49, 0x00, 0x00, 0xff, 0x55, 0x00, 0x00, 0xff,
    0x69, 0x00, 0x00, 0xff, 0x49, 0x00, 0x00, 0xff, 0x2d, 0x00, 0x00, 0xff,
    0x2d, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff,
    0x0a, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x03, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff,
    0x03, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff,
    0x15, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff, 0x2b, 0x00, 0x00, 0xff,
    0x28, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff,
    0x31, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x40, 0x00, 0x00, 0xff, 0x43, 0x00, 0x00, 0xff, 0x41, 0x00, 0x00, 0xff,
    0x49, 0x00, 0x00, 0xff, 0x55, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0x11, 0x00, 0x00, 0xff,
    0x09, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff,
    0x0a, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x0b, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff, 0x0b, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x16, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff, 0x1d, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0x2b, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff,
    0x28, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff,
    0x3a, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff,
    0x43, 0x00, 0x00, 0xff, 0x41, 0x00, 0x00, 0xff, 0x49, 0x00, 0x00, 0xff,
    0x55, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0x11, 0x00, 0x00, 0xff, 0x09, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff,
    0x02, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0xff,
    0x0b, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff,
    0x1a, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff, 0x16, 0x00, 0x00, 0xff,
    0x15, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff,
    0x31, 0x00, 0x00, 0xff, 0x31, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x40, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x41, 0x00, 0x00, 0xff, 0x49, 0x00, 0x00, 0xff, 0x55, 0x00, 0x00, 0xff,
    0x69, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff, 0x19, 0x00, 0x00, 0xff,
    0x19, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff,
    0x08, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff,
    0x0d, 0x00, 0x00, 0xff, 0x0a, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff,
    0x1b, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff,
    0x23, 0x00, 0x00, 0xff, 0x18, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff,
    0x1f, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff,
    0x29, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff,
    0x3f, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x41, 0x00, 0x00, 0xff, 0x42, 0x00, 0x00, 0xff, 0x41, 0x00, 0x00, 0xff,
    0x49, 0x00, 0x00, 0xff, 0x53, 0x00, 0x00, 0xff, 0x65, 0x00, 0x00, 0xff,
    0x46, 0x00, 0x00, 0xff, 0x19, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff,
    0x0f, 0x00, 0x00, 0xff, 0x0d, 0x00, 0x00, 0xff, 0x08, 0x00, 0x00, 0xff,
    0x08, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff,
    0x23, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff, 0x18, 0x00, 0x00, 0xff,
    0x23, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff,
    0x24, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff, 0x29, 0x00, 0x00, 0xff,
    0x33, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff,
    0x3e, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x41, 0x00, 0x00, 0xff, 0x41, 0x00, 0x00, 0xff, 0x49, 0x00, 0x00, 0xff,
    0x53, 0x00, 0x00, 0xff, 0x65, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff,
    0x23, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0xff, 0x19, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff, 0x26, 0x00, 0x00, 0xff,
    0x26, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff,
    0x1f, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff,
    0x24, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff,
    0x3c, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff,
    0x3e, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x41, 0x00, 0x00, 0xff, 0x49, 0x00, 0x00, 0xff, 0x53, 0x00, 0x00, 0xff,
    0x65, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff,
    0x19, 0x00, 0x00, 0xff, 0x19, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff, 0x0e, 0x00, 0x00, 0xff,
    0x1b, 0x00, 0x00, 0xff, 0x1b, 0x00, 0x00, 0xff, 0x14, 0x00, 0x00, 0xff,
    0x14, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff,
    0x20, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0xff,
    0x2a, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff,
    0x33, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff,
    0x38, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff,
    0x3e, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x41, 0x00, 0x00, 0xff,
    0x49, 0x00, 0x00, 0xff, 0x53, 0x00, 0x00, 0xff, 0x65, 0x00, 0x00, 0xff,
    0x46, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff,
    0x18, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x17, 0x00, 0x00, 0xff,
    0x15, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff, 0x15, 0x00, 0x00, 0xff,
    0x1c, 0x00, 0x00, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff,
    0x23, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff,
    0x26, 0x00, 0x00, 0xff, 0x27, 0x00, 0x00, 0xff, 0x2e, 0x00, 0x00, 0xff,
    0x33, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff, 0x37, 0x00, 0x00, 0xff,
    0x37, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3b, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff, 0x3e, 0x00, 0x00, 0xff,
    0x3f, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff, 0x4e, 0x00, 0x00, 0xff,
    0x57, 0x00, 0x00, 0xff, 0x6c, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff,
    0x52, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff,
    0x1d, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff, 0x1a, 0x00, 0x00, 0xff,
    0x1a, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff,
    0x28, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff,
    0x2e, 0x00, 0x00, 0xff, 0x2e, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff,
    0x37, 0x00, 0x00, 0xff, 0x37, 0x00, 0x00, 0xff, 0x38, 0x00, 0x00, 0xff,
    0x39, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3c, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff,
    0x45, 0x00, 0x00, 0xff, 0x4e, 0x00, 0x00, 0xff, 0x5d, 0x00, 0x00, 0xff,
    0x72, 0x00, 0x00, 0xff, 0x52, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x40, 0x00, 0x00, 0xff, 0x2a, 0x00, 0x00, 0xff, 0x23, 0x00, 0x00, 0xff,
    0x20, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff, 0x20, 0x00, 0x00, 0xff,
    0x1e, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff, 0x2f, 0x00, 0x00, 0xff,
    0x2f, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff,
    0x33, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff, 0x37, 0x00, 0x00, 0xff,
    0x38, 0x00, 0x00, 0xff, 0x39, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3b, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff,
    0x3d, 0x00, 0x00, 0xff, 0x3f, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff,
    0x4e, 0x00, 0x00, 0xff, 0x5d, 0x00, 0x00, 0xff, 0x7b, 0x00, 0x00, 0xff,
    0x52, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x2a, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff, 0x28, 0x00, 0x00, 0xff,
    0x26, 0x00, 0x00, 0xff, 0x26, 0x00, 0x00, 0xff, 0x1e, 0x00, 0x00, 0xff,
    0x25, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff, 0x25, 0x00, 0x00, 0xff,
    0x35, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff, 0x35, 0x00, 0x00, 0xff,
    0x35, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3d, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff, 0x39, 0x00, 0x00, 0xff,
    0x3a, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff, 0x3c, 0x00, 0x00, 0xff,
    0x3a, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff,
    0x3f, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff, 0x57, 0x00, 0x00, 0xff,
    0x6c, 0x00, 0x00, 0xff, 0x83, 0x00, 0x00, 0xff, 0x60, 0x00, 0x00, 0xff,
    0x48, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff,
    0x3a, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff, 0x2b, 0x00, 0x00, 0xff,
    0x2b, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff,
    0x32, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00, 0xff, 0x35, 0x00, 0x00, 0xff,
    0x3b, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff, 0x3b, 0x00, 0x00, 0xff,
    0x40, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0xff,
    0x40, 0x00, 0x00, 0xff, 0x3e, 0x00, 0x00, 0xff, 0x3e, 0x00, 0x00, 0xff,
    0x3e, 0x00, 0x00, 0xff, 0x3e, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff,
    0x3d, 0x00, 0x00, 0xff, 0x3d, 0x00, 0x00, 0xff, 0x41, 0x00, 0x00, 0xff,
    0x51, 0x00, 0x00, 0xff, 0x51, 0x00, 0x00, 0xff, 0x60, 0x00, 0x00, 0xff,
    0x72, 0x00, 0x00, 0xff, 0x78, 0x00, 0x00, 0xff, 0x60, 0x00, 0x00, 0xff,
    0x48, 0x00, 0x00, 0xff, 0x34, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3a, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff,
    0x3e, 0x00, 0x00, 0xff, 0x3e, 0x00, 0x00, 0xff, 0x3e, 0x00, 0x00, 0xff,
    0x3e, 0x00, 0x00, 0xff, 0x41, 0x00, 0x00, 0xff, 0x41, 0x00, 0x00, 0xff,
    0x41, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff,
    0x46, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0xff,
    0x44, 0x00, 0x00, 0xff, 0x44, 0x00, 0x00, 0xff, 0x44, 0x00, 0x00, 0xff,
    0x44, 0x00, 0x00, 0xff, 0x41, 0x00, 0x00, 0xff, 0x45, 0x00, 0x00, 0xff,
    0x45, 0x00, 0x00, 0xff, 0x4d, 0x00, 0x00, 0xff, 0x51, 0x00, 0x00, 0xff,
    0x60, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff, 0x7b, 0x00, 0x00, 0xff,
    0x97, 0x00, 0x00, 0xff, 0x78, 0x00, 0x00, 0xff, 0x60, 0x00, 0x00, 0xff,
    0x48, 0x00, 0x00, 0xff, 0x53, 0x00, 0x00, 0xff, 0x53, 0x00, 0x00, 0xff,
    0x53, 0x00, 0x00, 0xff, 0x53, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0xff,
    0x50, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0xff,
    0x4f, 0x00, 0x00, 0xff, 0x4f, 0x00, 0x00, 0xff, 0x4f, 0x00, 0x00, 0xff,
    0x53, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0xff,
    0x50, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0xff, 0x4e, 0x00, 0x00, 0xff,
    0x4e, 0x00, 0x00, 0xff, 0x4e, 0x00, 0x00, 0xff, 0x4e, 0x00, 0x00, 0xff,
    0x4d, 0x00, 0x00, 0xff, 0x4d, 0x00, 0x00, 0xff, 0x57, 0x00, 0x00, 0xff,
    0x57, 0x00, 0x00, 0xff, 0x60, 0x00, 0x00, 0xff, 0x69, 0x00, 0x00, 0xff,
    0x7b, 0x00, 0x00, 0xff, 0x8c, 0x00, 0x00, 0xff, 0x97, 0x00, 0x00, 0xff,
    0x97, 0x00, 0x00, 0xff, 0x78, 0x00, 0x00, 0xff, 0x78, 0x00, 0x00, 0xff,
    0x6c, 0x00, 0x00, 0xff, 0x6c, 0x00, 0x00, 0xff, 0x6c, 0x00, 0x00, 0xff,
    0x6c, 0x00, 0x00, 0xff, 0x64, 0x00, 0x00, 0xff, 0x64, 0x00, 0x00, 0xff,
    0x64, 0x00, 0x00, 0xff, 0x64, 0x00, 0x00, 0xff, 0x5f, 0x00, 0x00, 0xff,
    0x5f, 0x00, 0x00, 0xff, 0x5f, 0x00, 0x00, 0xff, 0x5f, 0x00, 0x00, 0xff,
    0x60, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff, 0x5c, 0x00, 0x00, 0xff,
    0x5c, 0x00, 0x00, 0xff, 0x5e, 0x00, 0x00, 0xff, 0x5e, 0x00, 0x00, 0xff,
    0x5e, 0x00, 0x00, 0xff, 0x5e, 0x00, 0x00, 0xff, 0x57, 0x00, 0x00, 0xff,
    0x5f, 0x00, 0x00, 0xff, 0x63, 0x00, 0x00, 0xff, 0x67, 0x00, 0x00, 0xff,
    0x69, 0x00, 0x00, 0xff, 0x7b, 0x00, 0x00, 0xff, 0x8c, 0x00, 0x00, 0xff,
    0x9b, 0x00, 0x00, 0xff,
  ]),
};

var img_32x32_rg11_eac = {
  compressed: new Uint8Array([
    0xa3, 0x8b, 0x92, 0x08, 0x02, 0x01, 0x12, 0x53, 0x88, 0x72, 0xdb, 0x5d,
    0x68, 0xb4, 0x49, 0x01, 0x54, 0x30, 0xf2, 0x8d, 0x02, 0xf1, 0x2f, 0x03,
    0x64, 0x30, 0xf2, 0x8d, 0x02, 0xf1, 0x2f, 0x03, 0x5f, 0x47, 0xd1, 0x1d,
    0x42, 0xf0, 0x39, 0x1b, 0x70, 0x47, 0xd1, 0x1d, 0x42, 0xf0, 0x39, 0x1b,
    0x57, 0x62, 0xa0, 0x2c, 0x0a, 0xd0, 0xab, 0x02, 0x69, 0x67, 0xa0, 0xbc,
    0x13, 0xd1, 0x3b, 0x0b, 0x54, 0x30, 0xf0, 0x2d, 0x83, 0xda, 0xac, 0x43,
    0x64, 0x30, 0xf0, 0x2d, 0x83, 0xda, 0xac, 0x43, 0x4a, 0x7b, 0xd4, 0x4d,
    0x41, 0xd6, 0x2f, 0x41, 0x4a, 0x7b, 0xd4, 0x4d, 0x41, 0xd6, 0x2f, 0x41,
    0x71, 0xbd, 0xd1, 0x2d, 0x11, 0xd0, 0xac, 0x02, 0x5e, 0x44, 0xf5, 0x2f,
    0x51, 0xf4, 0xaf, 0x02, 0x9f, 0x49, 0x48, 0x92, 0x04, 0x92, 0xdb, 0xb7,
    0x85, 0x6b, 0x05, 0x38, 0x0a, 0xb0, 0x1d, 0x60, 0x69, 0x69, 0xbb, 0x58,
    0x00, 0x25, 0x20, 0x9a, 0x69, 0x69, 0xbb, 0x58, 0x00, 0x25, 0x20, 0x9a,
    0x1c, 0x32, 0xfe, 0xae, 0x10, 0x9c, 0x99, 0x31, 0x33, 0x44, 0xda, 0x2c,
    0x10, 0x19, 0x20, 0x22, 0x17, 0x22, 0x8a, 0x4e, 0x92, 0xb5, 0x90, 0x03,
    0x24, 0x20, 0x86, 0x4e, 0x49, 0x91, 0xa0, 0x03, 0x13, 0x3d, 0x18, 0xea,
    0x0e, 0x14, 0xbc, 0x1e, 0x0c, 0x20, 0x9b, 0x7b, 0x37, 0x97, 0x0d, 0x07,
    0x01, 0x8f, 0x96, 0x4b, 0x24, 0x96, 0x4d, 0x2c, 0x29, 0x3a, 0x54, 0x2a,
    0x80, 0x54, 0x2e, 0x2a, 0x5c, 0x47, 0x29, 0x00, 0xc2, 0x64, 0x26, 0xb0,
    0x41, 0x34, 0xb1, 0x9c, 0x0b, 0x14, 0xb1, 0x31, 0x6a, 0x44, 0x6a, 0xc0,
    0xad, 0x82, 0x61, 0x26, 0x45, 0x20, 0x66, 0x0a, 0x64, 0xf4, 0x6b, 0xc6,
    0xb4, 0x4b, 0x64, 0x14, 0x80, 0x92, 0x4f, 0xff, 0x64, 0x47, 0x64, 0x14,
    0x80, 0x00, 0x0b, 0x6d, 0x5d, 0x62, 0xb2, 0xe1, 0x04, 0x24, 0x24, 0x52,
    0x6d, 0x62, 0xb2, 0xe1, 0x04, 0x24, 0x24, 0x52, 0x17, 0x2a, 0xf7, 0xd5,
    0xe8, 0x0b, 0xaa, 0x05, 0x20, 0x2a, 0xf7, 0xd5, 0xe8, 0x0b, 0xaa, 0x05,
    0x0e, 0x3d, 0x77, 0xb4, 0xe7, 0x49, 0xbb, 0x5b, 0x1f, 0x30, 0x63, 0x82,
    0xaf, 0x24, 0x00, 0x1b, 0x0d, 0x42, 0x80, 0x18, 0x08, 0xd2, 0x68, 0x25,
    0x0f, 0x2a, 0xf6, 0xaf, 0x45, 0xe0, 0x70, 0x85, 0x3f, 0x42, 0x09, 0x44,
    0x88, 0xa0, 0x6b, 0xad, 0x17, 0x2a, 0xa9, 0x74, 0x85, 0xa9, 0x7b, 0xed,
    0x6f, 0x23, 0x6f, 0xfb, 0xff, 0xf7, 0xf3, 0xff, 0x06, 0xb2, 0xb6, 0xdd,
    0x6d, 0xba, 0xd9, 0x6d, 0xa3, 0x37, 0x2e, 0xf6, 0x7f, 0xaf, 0xfb, 0x7f,
    0x1c, 0x5d, 0x73, 0x88, 0xc0, 0xf0, 0x0f, 0xc0, 0x7a, 0xb5, 0xdb, 0x6d,
    0xb6, 0xdf, 0xff, 0xff, 0x5a, 0xbd, 0x8a, 0x24, 0x92, 0x80, 0x0d, 0xb6,
    0x63, 0x50, 0xb7, 0x69, 0x24, 0x12, 0x46, 0xd4, 0x71, 0x67, 0xdb, 0xfb,
    0xae, 0x12, 0x46, 0xd4, 0x1a, 0x3c, 0x84, 0xf2, 0xdb, 0x2d, 0xb6, 0xdb,
    0x1a, 0x3c, 0x84, 0xf2, 0xdb, 0x2d, 0xb6, 0xdb, 0x01, 0x2f, 0x02, 0x78,
    0x04, 0xb4, 0x0b, 0x6d, 0x01, 0x20, 0x02, 0x68, 0x04, 0xd8, 0x0d, 0xb6,
    0x2e, 0x42, 0x40, 0x04, 0x24, 0x82, 0xeb, 0xb6, 0x28, 0x2a, 0x56, 0xd5,
    0x7f, 0x0a, 0xfb, 0xff, 0x64, 0x47, 0x42, 0x48, 0xa6, 0x9e, 0xff, 0xbe,
    0x31, 0x20, 0x66, 0xda, 0xef, 0x58, 0x6d, 0x34, 0xab, 0x20, 0x49, 0x04,
    0x10, 0x4c, 0x2d, 0xb6, 0x2e, 0x20, 0x92, 0x69, 0xa6, 0x83, 0x46, 0xdb,
    0xd9, 0x2b, 0x6d, 0x12, 0x44, 0x12, 0xeb, 0xbf, 0x0a, 0x19, 0x25, 0x28,
    0x01, 0xb6, 0x4f, 0xb5, 0xe5, 0x1f, 0x97, 0x79, 0x77, 0x97, 0x79, 0x77,
    0x4c, 0x4c, 0x6d, 0xb0, 0x49, 0xb6, 0xcf, 0xff, 0x55, 0x47, 0xff, 0x6f,
    0x24, 0x90, 0x08, 0x52, 0x4d, 0x62, 0xfe, 0xdf, 0xa4, 0xd8, 0x0d, 0x49,
    0x2f, 0x5a, 0xf4, 0x20, 0x00, 0x66, 0xd4, 0xd1, 0x32, 0x52, 0xfa, 0x19,
    0x24, 0x68, 0x06, 0xda, 0x03, 0x85, 0x92, 0xd9, 0x2d, 0x96, 0xdb, 0x2f,
    0x03, 0x85, 0x90, 0x09, 0x28, 0x96, 0xd1, 0x2f, 0x5b, 0x20, 0x6c, 0x00,
    0x06, 0xc3, 0xfd, 0xbf, 0x39, 0x20, 0x6c, 0x00, 0x06, 0xc0, 0x0d, 0x80,
    0x89, 0x42, 0x46, 0x00, 0xa5, 0x82, 0x51, 0x34, 0x47, 0x42, 0x10, 0xaa,
    0x08, 0xd4, 0x8b, 0xa1, 0xc1, 0x36, 0x60, 0x00, 0xc0, 0x16, 0xdb, 0x6d,
    0x15, 0x22, 0x9f, 0xff, 0x3f, 0xe9, 0x24, 0x92, 0xe4, 0x11, 0x6c, 0x01,
    0xb6, 0xb6, 0x4f, 0xfd, 0x07, 0x1a, 0x49, 0x24, 0x00, 0xb4, 0x0f, 0xfd,
    0xee, 0x2d, 0x48, 0x92, 0x04, 0x92, 0xdb, 0xb6, 0x33, 0xb2, 0x00, 0x09,
    0x24, 0xb6, 0xdd, 0xb6, 0x75, 0x31, 0x9b, 0x64, 0x84, 0x2d, 0x96, 0xc9,
    0x58, 0x72, 0xbb, 0x60, 0x25, 0x04, 0x82, 0x40, 0x4b, 0x3a, 0x02, 0xd4,
    0xad, 0x0b, 0xf1, 0x6f, 0x1b, 0x45, 0xb7, 0xf9, 0x3f, 0xb0, 0x0b, 0xf8,
    0x46, 0x8f, 0x9b, 0x6b, 0xf6, 0x9f, 0xfd, 0xbf, 0x1f, 0x32, 0x9f, 0xf6,
    0x7f, 0x84, 0x9f, 0xc9, 0x85, 0x47, 0x93, 0xc5, 0x3e, 0x82, 0xe1, 0x34,
    0x2e, 0x4a, 0xda, 0x21, 0xa0, 0xd4, 0x8b, 0x82, 0xa5, 0x20, 0x00, 0x60,
    0x07, 0x1b, 0xfd, 0xb7, 0x1a, 0x10, 0xff, 0xbf, 0xf8, 0xec, 0x06, 0xd8,
    0xdb, 0x24, 0x6c, 0x0c, 0x00, 0x96, 0xcd, 0x6c, 0x02, 0xfd, 0x00, 0x0a,
    0x00, 0x00, 0x08, 0x00, 0xeb, 0x2d, 0x80, 0xab, 0x01, 0xb0, 0x1d, 0x60,
    0x09, 0x1a, 0x69, 0x22, 0x48, 0x92, 0x5d, 0xb6, 0xed, 0x03, 0x6d, 0xb4,
    0x92, 0xb6, 0xdf, 0xff, 0x4d, 0x5c, 0x6d, 0xb0, 0x49, 0xb6, 0xdf, 0xff,
    0x9a, 0x33, 0x92, 0xd9, 0x40, 0x3b, 0x66, 0x49, 0x65, 0x5f, 0xdb, 0xfd,
    0xed, 0x12, 0x46, 0x00, 0x94, 0x37, 0x66, 0x66, 0x66, 0x42, 0xf4, 0x2f,
    0x30, 0x29, 0xdb, 0xf9, 0x2d, 0x24, 0x06, 0xd2, 0x94, 0x20, 0x5b, 0x61,
    0xb7, 0x1f, 0xfd, 0xbf, 0x00, 0x46, 0xdb, 0x6f, 0xb7, 0xff, 0xfd, 0xbf,
    0xc3, 0x27, 0x4e, 0xf6, 0x2e, 0x02, 0xf2, 0xb7, 0x06, 0x2b, 0xb2, 0xf9,
    0xee, 0xfe, 0xfd, 0x77, 0xd3, 0x2b, 0x66, 0x62, 0x66, 0x93, 0xf9, 0x6f,
    0x0b, 0x10, 0x6a, 0x74, 0xa7, 0x6e, 0xd6, 0x4d, 0xe1, 0x2d, 0x44, 0x82,
    0x04, 0x12, 0x59, 0x6e, 0x07, 0x19, 0x42, 0x64, 0x2e, 0x32, 0xf3, 0x2f,
    0xe6, 0x2d, 0x04, 0xa8, 0x01, 0xb2, 0x0d, 0x6c, 0x11, 0x10, 0x6d, 0x14,
    0x44, 0x12, 0xeb, 0xbf, 0xed, 0x2d, 0x05, 0x28, 0x0a, 0xb0, 0x1d, 0x60,
    0x64, 0x51, 0x68, 0x92, 0x04, 0x92, 0xdb, 0xbf, 0xdc, 0x37, 0x17, 0xf4,
    0x2f, 0x66, 0x66, 0xce, 0x87, 0x62, 0x97, 0x61, 0x2e, 0x44, 0x44, 0x8c,
    0xc7, 0x72, 0x92, 0xe9, 0x2e, 0x12, 0xe1, 0x2e, 0x55, 0x47, 0x02, 0xf0,
    0x2f, 0x42, 0xf4, 0x2f, 0xd8, 0xdd, 0x12, 0xe1, 0x2e, 0x12, 0xe1, 0x2e,
    0x51, 0x4c, 0x62, 0xf6, 0x2f, 0x66, 0x76, 0x67, 0xe5, 0x12, 0x68, 0x56,
    0x66, 0x42, 0xf3, 0x37, 0x03, 0xef, 0x97, 0x79, 0x77, 0x97, 0x79, 0x77,
    0xe5, 0x1f, 0x97, 0x79, 0x77, 0x97, 0x79, 0x77, 0x4a, 0x47, 0x62, 0xf6,
    0x67, 0x66, 0x76, 0x66, 0xdf, 0x2f, 0x97, 0x79, 0x77, 0x97, 0x79, 0x77,
    0x02, 0xdf, 0x97, 0x79, 0x77, 0x97, 0x79, 0x77, 0xe9, 0x1b, 0x64, 0x46,
    0x45, 0x46, 0x54, 0x26, 0x4d, 0x41, 0x66, 0x54, 0x26, 0x42, 0xf3, 0x2f,
    0xea, 0x2d, 0x46, 0x54, 0x26, 0x22, 0xe3, 0x2e, 0x8c, 0x40, 0x68, 0x84,
    0x44, 0x12, 0xe9, 0x77,
  ]),
  decompressed: new Uint8Array([
    0xab, 0xb9, 0x00, 0xff, 0xab, 0xb9, 0x00, 0xff, 0x93, 0xa4, 0x00, 0xff,
    0x7b, 0x8f, 0x00, 0xff, 0x7e, 0x8e, 0x00, 0xff, 0x6c, 0x7c, 0x00, 0xff,
    0x7e, 0x8e, 0x00, 0xff, 0x7e, 0x8e, 0x00, 0xff, 0x7b, 0x8c, 0x00, 0xff,
    0x7b, 0x8c, 0x00, 0xff, 0x87, 0x98, 0x00, 0xff, 0x67, 0x78, 0x00, 0xff,
    0x6f, 0x81, 0x00, 0xff, 0x81, 0x93, 0x00, 0xff, 0x81, 0x93, 0x00, 0xff,
    0x6f, 0x81, 0x00, 0xff, 0x7e, 0x8e, 0x00, 0xff, 0x6c, 0x7c, 0x00, 0xff,
    0x6c, 0x7c, 0x00, 0xff, 0x6c, 0x7c, 0x00, 0xff, 0x74, 0x74, 0x00, 0xff,
    0x74, 0x74, 0x00, 0xff, 0x74, 0x74, 0x00, 0xff, 0x89, 0x89, 0x00, 0xff,
    0x87, 0x8a, 0x00, 0xff, 0x87, 0x8a, 0x00, 0xff, 0x87, 0x8a, 0x00, 0xff,
    0x87, 0x8a, 0x00, 0xff, 0x7f, 0x79, 0x00, 0xff, 0x8b, 0x8b, 0x00, 0xff,
    0xa3, 0x9d, 0x00, 0xff, 0xaf, 0xa9, 0x00, 0xff, 0xab, 0xb9, 0x00, 0xff,
    0x93, 0xa4, 0x00, 0xff, 0x93, 0xa4, 0x00, 0xff, 0x7b, 0x8f, 0x00, 0xff,
    0x5a, 0x6a, 0x00, 0xff, 0x5a, 0x6a, 0x00, 0xff, 0x5a, 0x6a, 0x00, 0xff,
    0x5a, 0x6a, 0x00, 0xff, 0x67, 0x78, 0x00, 0xff, 0x6f, 0x80, 0x00, 0xff,
    0x67, 0x78, 0x00, 0xff, 0x67, 0x78, 0x00, 0xff, 0x4b, 0x57, 0x00, 0xff,
    0x4b, 0x57, 0x00, 0xff, 0x5d, 0x75, 0x00, 0xff, 0x5d, 0x75, 0x00, 0xff,
    0x5a, 0x6a, 0x00, 0xff, 0x6c, 0x7c, 0x00, 0xff, 0x6c, 0x7c, 0x00, 0xff,
    0x42, 0x52, 0x00, 0xff, 0x66, 0x66, 0x00, 0xff, 0x66, 0x66, 0x00, 0xff,
    0x66, 0x66, 0x00, 0xff, 0x66, 0x66, 0x00, 0xff, 0x71, 0x72, 0x00, 0xff,
    0x71, 0x72, 0x00, 0xff, 0x71, 0x72, 0x00, 0xff, 0x66, 0x66, 0x00, 0xff,
    0x7f, 0x67, 0x00, 0xff, 0x97, 0x79, 0x00, 0xff, 0xa3, 0x8b, 0x00, 0xff,
    0xbb, 0x9d, 0x00, 0xff, 0xab, 0xb9, 0x00, 0xff, 0x93, 0xa4, 0x00, 0xff,
    0x6b, 0x7a, 0x00, 0xff, 0x6b, 0x7a, 0x00, 0xff, 0x63, 0x73, 0x00, 0xff,
    0x4b, 0x5b, 0x00, 0xff, 0x39, 0x49, 0x00, 0xff, 0x4b, 0x5b, 0x00, 0xff,
    0x3f, 0x50, 0x00, 0xff, 0x53, 0x64, 0x00, 0xff, 0x53, 0x64, 0x00, 0xff,
    0x33, 0x44, 0x00, 0xff, 0x4b, 0x4b, 0x00, 0xff, 0x39, 0x39, 0x00, 0xff,
    0x39, 0x39, 0x00, 0xff, 0x4b, 0x4b, 0x00, 0xff, 0x4b, 0x5b, 0x00, 0xff,
    0x4b, 0x5b, 0x00, 0xff, 0x63, 0x73, 0x00, 0xff, 0x4b, 0x5b, 0x00, 0xff,
    0x3c, 0x3c, 0x00, 0xff, 0x3c, 0x3c, 0x00, 0xff, 0x51, 0x51, 0x00, 0xff,
    0x3c, 0x3c, 0x00, 0xff, 0x50, 0x3e, 0x00, 0xff, 0x50, 0x3e, 0x00, 0xff,
    0x5b, 0x46, 0x00, 0xff, 0x66, 0x52, 0x00, 0xff, 0x8b, 0x5b, 0x00, 0xff,
    0x97, 0x67, 0x00, 0xff, 0xaf, 0x79, 0x00, 0xff, 0xbb, 0x8b, 0x00, 0xff,
    0x93, 0xa4, 0x00, 0xff, 0x6b, 0x7a, 0x00, 0xff, 0x7b, 0x8f, 0x00, 0xff,
    0x53, 0x65, 0x00, 0xff, 0x4b, 0x5b, 0x00, 0xff, 0x39, 0x49, 0x00, 0xff,
    0x39, 0x49, 0x00, 0xff, 0x27, 0x37, 0x00, 0xff, 0x4b, 0x5c, 0x00, 0xff,
    0x3f, 0x50, 0x00, 0xff, 0x33, 0x44, 0x00, 0xff, 0x33, 0x44, 0x00, 0xff,
    0x27, 0x27, 0x00, 0xff, 0x27, 0x27, 0x00, 0xff, 0x27, 0x27, 0x00, 0xff,
    0x27, 0x27, 0x00, 0xff, 0x39, 0x49, 0x00, 0xff, 0x27, 0x37, 0x00, 0xff,
    0x39, 0x49, 0x00, 0xff, 0x27, 0x37, 0x00, 0xff, 0x51, 0x51, 0x00, 0xff,
    0x27, 0x27, 0x00, 0xff, 0x19, 0x19, 0x00, 0xff, 0x27, 0x27, 0x00, 0xff,
    0x50, 0x3e, 0x00, 0xff, 0x5b, 0x46, 0x00, 0xff, 0x50, 0x3e, 0x00, 0xff,
    0x50, 0x3e, 0x00, 0xff, 0x8b, 0x49, 0x00, 0xff, 0xa3, 0x5b, 0x00, 0xff,
    0xaf, 0x67, 0x00, 0xff, 0xc3, 0x79, 0x00, 0xff, 0x81, 0x81, 0x00, 0xff,
    0x6f, 0x6f, 0x00, 0xff, 0x4b, 0x4b, 0x00, 0xff, 0x5d, 0x5d, 0x00, 0xff,
    0x40, 0x4f, 0x00, 0xff, 0x40, 0x4f, 0x00, 0xff, 0x1f, 0x27, 0x00, 0xff,
    0x1f, 0x27, 0x00, 0xff, 0x19, 0x28, 0x00, 0xff, 0x2f, 0x40, 0x00, 0xff,
    0x1f, 0x28, 0x00, 0xff, 0x13, 0x1e, 0x00, 0xff, 0x10, 0x10, 0x00, 0xff,
    0x16, 0x16, 0x00, 0xff, 0x10, 0x10, 0x00, 0xff, 0x19, 0x1c, 0x00, 0xff,
    0x11, 0x11, 0x00, 0xff, 0x21, 0x32, 0x00, 0xff, 0x11, 0x11, 0x00, 0xff,
    0x31, 0x44, 0x00, 0xff, 0x48, 0x50, 0x00, 0xff, 0x50, 0x56, 0x00, 0xff,
    0x30, 0x38, 0x00, 0xff, 0x30, 0x38, 0x00, 0xff, 0x3a, 0x27, 0x00, 0xff,
    0x5e, 0x4f, 0x00, 0xff, 0x72, 0x61, 0x00, 0xff, 0x5e, 0x4f, 0x00, 0xff,
    0x8c, 0x38, 0x00, 0xff, 0x98, 0x44, 0x00, 0xff, 0xb8, 0x58, 0x00, 0xff,
    0xd8, 0x74, 0x00, 0xff, 0x93, 0x93, 0x00, 0xff, 0x5d, 0x5d, 0x00, 0xff,
    0x4b, 0x4b, 0x00, 0xff, 0x39, 0x39, 0x00, 0xff, 0x40, 0x4f, 0x00, 0xff,
    0x16, 0x27, 0x00, 0xff, 0x40, 0x4f, 0x00, 0xff, 0x1f, 0x27, 0x00, 0xff,
    0x07, 0x18, 0x00, 0xff, 0x07, 0x18, 0x00, 0xff, 0x1f, 0x28, 0x00, 0xff,
    0x13, 0x1e, 0x00, 0xff, 0x19, 0x1c, 0x00, 0xff, 0x10, 0x10, 0x00, 0xff,
    0x16, 0x16, 0x00, 0xff, 0x10, 0x10, 0x00, 0xff, 0x21, 0x32, 0x00, 0xff,
    0x11, 0x11, 0x00, 0xff, 0x21, 0x32, 0x00, 0xff, 0x11, 0x23, 0x00, 0xff,
    0x3c, 0x47, 0x00, 0xff, 0x30, 0x38, 0x00, 0xff, 0x48, 0x50, 0x00, 0xff,
    0x3c, 0x47, 0x00, 0xff, 0x4a, 0x39, 0x00, 0xff, 0x4a, 0x39, 0x00, 0xff,
    0x5e, 0x4f, 0x00, 0xff, 0x72, 0x61, 0x00, 0xff, 0xa0, 0x50, 0x00, 0xff,
    0x98, 0x44, 0x00, 0xff, 0xb8, 0x58, 0x00, 0xff, 0xd8, 0x74, 0x00, 0xff,
    0x93, 0x93, 0x00, 0xff, 0x5d, 0x5d, 0x00, 0xff, 0x39, 0x39, 0x00, 0xff,
    0x2d, 0x2d, 0x00, 0xff, 0x28, 0x3b, 0x00, 0xff, 0x04, 0x13, 0x00, 0xff,
    0x0d, 0x13, 0x00, 0xff, 0x31, 0x3b, 0x00, 0xff, 0x19, 0x28, 0x00, 0xff,
    0x07, 0x18, 0x00, 0xff, 0x00, 0x06, 0x00, 0xff, 0x13, 0x1e, 0x00, 0xff,
    0x0d, 0x1c, 0x00, 0xff, 0x0d, 0x1c, 0x00, 0xff, 0x0d, 0x1c, 0x00, 0xff,
    0x00, 0x06, 0x00, 0xff, 0x11, 0x23, 0x00, 0xff, 0x11, 0x23, 0x00, 0xff,
    0x11, 0x23, 0x00, 0xff, 0x21, 0x32, 0x00, 0xff, 0x3c, 0x1d, 0x00, 0xff,
    0x50, 0x2f, 0x00, 0xff, 0x50, 0x2f, 0x00, 0xff, 0x78, 0x56, 0x00, 0xff,
    0x7e, 0x49, 0x00, 0xff, 0x7e, 0x49, 0x00, 0xff, 0x72, 0x3f, 0x00, 0xff,
    0x72, 0x3f, 0x00, 0xff, 0xac, 0x58, 0x00, 0xff, 0xac, 0x58, 0x00, 0xff,
    0xb8, 0x58, 0x00, 0xff, 0xd8, 0x74, 0x00, 0xff, 0x81, 0x81, 0x00, 0xff,
    0x5d, 0x5d, 0x00, 0xff, 0x39, 0x39, 0x00, 0xff, 0x39, 0x39, 0x00, 0xff,
    0x04, 0x13, 0x00, 0xff, 0x16, 0x27, 0x00, 0xff, 0x0d, 0x13, 0x00, 0xff,
    0x0d, 0x13, 0x00, 0xff, 0x19, 0x28, 0x00, 0xff, 0x07, 0x18, 0x00, 0xff,
    0x0d, 0x12, 0x00, 0xff, 0x00, 0x06, 0x00, 0xff, 0x19, 0x28, 0x00, 0xff,
    0x19, 0x28, 0x00, 0xff, 0x00, 0x06, 0x00, 0xff, 0x19, 0x28, 0x00, 0xff,
    0x11, 0x11, 0x00, 0xff, 0x11, 0x23, 0x00, 0xff, 0x11, 0x11, 0x00, 0xff,
    0x11, 0x11, 0x00, 0xff, 0x50, 0x2f, 0x00, 0xff, 0x3c, 0x1d, 0x00, 0xff,
    0x3c, 0x1d, 0x00, 0xff, 0x50, 0x2f, 0x00, 0xff, 0x72, 0x3f, 0x00, 0xff,
    0x7e, 0x49, 0x00, 0xff, 0x86, 0x55, 0x00, 0xff, 0x86, 0x55, 0x00, 0xff,
    0xa0, 0x50, 0x00, 0xff, 0xac, 0x58, 0x00, 0xff, 0xb8, 0x58, 0x00, 0xff,
    0xd8, 0x74, 0x00, 0xff, 0x75, 0x85, 0x00, 0xff, 0x51, 0x61, 0x00, 0xff,
    0x3f, 0x4f, 0x00, 0xff, 0x2d, 0x3d, 0x00, 0xff, 0x29, 0x32, 0x00, 0xff,
    0x07, 0x10, 0x00, 0xff, 0x13, 0x1c, 0x00, 0xff, 0x1d, 0x26, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x05, 0x0d, 0x00, 0xff, 0x05, 0x0d, 0x00, 0xff,
    0x11, 0x16, 0x00, 0xff, 0x11, 0x21, 0x00, 0xff, 0x11, 0x21, 0x00, 0xff,
    0x29, 0x21, 0x00, 0xff, 0x11, 0x0b, 0x00, 0xff, 0x37, 0x1d, 0x00, 0xff,
    0x1f, 0x07, 0x00, 0xff, 0x4f, 0x1d, 0x00, 0xff, 0x4f, 0x1d, 0x00, 0xff,
    0x55, 0x32, 0x00, 0xff, 0x75, 0x53, 0x00, 0xff, 0x87, 0x32, 0x00, 0xff,
    0x67, 0x11, 0x00, 0xff, 0x94, 0x00, 0x00, 0xff, 0x82, 0x1c, 0x00, 0xff,
    0xaf, 0x49, 0x00, 0xff, 0xaf, 0x49, 0x00, 0xff, 0xd2, 0x5a, 0x00, 0xff,
    0xd2, 0x39, 0x00, 0xff, 0xd2, 0x5a, 0x00, 0xff, 0xe8, 0x70, 0x00, 0xff,
    0x63, 0x73, 0x00, 0xff, 0x63, 0x73, 0x00, 0xff, 0x3f, 0x4f, 0x00, 0xff,
    0x3f, 0x4f, 0x00, 0xff, 0x1d, 0x26, 0x00, 0xff, 0x29, 0x32, 0x00, 0xff,
    0x07, 0x10, 0x00, 0xff, 0x13, 0x1c, 0x00, 0xff, 0x11, 0x16, 0x00, 0xff,
    0x00, 0x04, 0x00, 0xff, 0x05, 0x0d, 0x00, 0xff, 0x11, 0x16, 0x00, 0xff,
    0x05, 0x15, 0x00, 0xff, 0x05, 0x15, 0x00, 0xff, 0x11, 0x0b, 0x00, 0xff,
    0x05, 0x00, 0x00, 0xff, 0x1f, 0x07, 0x00, 0xff, 0x1f, 0x07, 0x00, 0xff,
    0x37, 0x07, 0x00, 0xff, 0x5b, 0x29, 0x00, 0xff, 0x55, 0x32, 0x00, 0xff,
    0x87, 0x32, 0x00, 0xff, 0x75, 0x53, 0x00, 0xff, 0x87, 0x32, 0x00, 0xff,
    0x82, 0x1c, 0x00, 0xff, 0x94, 0x00, 0x00, 0xff, 0x82, 0x1c, 0x00, 0xff,
    0xaf, 0x49, 0x00, 0xff, 0xd2, 0x39, 0x00, 0xff, 0xd2, 0x39, 0x00, 0xff,
    0xe8, 0x4f, 0x00, 0xff, 0xe8, 0x70, 0x00, 0xff, 0x75, 0x85, 0x00, 0xff,
    0x51, 0x61, 0x00, 0xff, 0x51, 0x61, 0x00, 0xff, 0x2d, 0x3d, 0x00, 0xff,
    0x29, 0x32, 0x00, 0xff, 0x1d, 0x26, 0x00, 0xff, 0x29, 0x32, 0x00, 0xff,
    0x13, 0x1c, 0x00, 0xff, 0x29, 0x49, 0x00, 0xff, 0x0e, 0x2e, 0x00, 0xff,
    0x00, 0x16, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x05, 0x15, 0x00, 0xff,
    0x00, 0x0b, 0x00, 0xff, 0x11, 0x0b, 0x00, 0xff, 0x11, 0x0b, 0x00, 0xff,
    0x1f, 0x07, 0x00, 0xff, 0x2b, 0x13, 0x00, 0xff, 0x37, 0x07, 0x00, 0xff,
    0x4f, 0x1d, 0x00, 0xff, 0x87, 0x32, 0x00, 0xff, 0x87, 0x32, 0x00, 0xff,
    0x87, 0x32, 0x00, 0xff, 0x87, 0x32, 0x00, 0xff, 0xaf, 0x49, 0x00, 0xff,
    0xc1, 0x17, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff,
    0xd2, 0x5a, 0x00, 0xff, 0xd2, 0x39, 0x00, 0xff, 0xe8, 0x4f, 0x00, 0xff,
    0xe8, 0x70, 0x00, 0xff, 0x87, 0x97, 0x00, 0xff, 0x63, 0x73, 0x00, 0xff,
    0x2d, 0x3d, 0x00, 0xff, 0x2d, 0x3d, 0x00, 0xff, 0x1d, 0x26, 0x00, 0xff,
    0x13, 0x1c, 0x00, 0xff, 0x07, 0x10, 0x00, 0xff, 0x1d, 0x26, 0x00, 0xff,
    0x00, 0x16, 0x00, 0xff, 0x29, 0x49, 0x00, 0xff, 0x00, 0x16, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x05, 0x15, 0x00, 0xff,
    0x29, 0x21, 0x00, 0xff, 0x1d, 0x15, 0x00, 0xff, 0x43, 0x29, 0x00, 0xff,
    0x37, 0x1d, 0x00, 0xff, 0x5b, 0x29, 0x00, 0xff, 0x4f, 0x1d, 0x00, 0xff,
    0x87, 0x32, 0x00, 0xff, 0x87, 0x32, 0x00, 0xff, 0x87, 0x32, 0x00, 0xff,
    0x87, 0x32, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff,
    0xc1, 0x17, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff, 0xd2, 0x39, 0x00, 0xff,
    0xd2, 0x39, 0x00, 0xff, 0xe8, 0x4f, 0x00, 0xff, 0xe8, 0x70, 0x00, 0xff,
    0x7c, 0x9b, 0x00, 0xff, 0x6d, 0x89, 0x00, 0xff, 0x54, 0x5f, 0x00, 0xff,
    0x18, 0x2f, 0x00, 0xff, 0x20, 0x20, 0x00, 0xff, 0x0e, 0x0e, 0x00, 0xff,
    0x0e, 0x0e, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x05, 0x05, 0x00, 0xff, 0x09, 0x11, 0x00, 0xff, 0x09, 0x11, 0x00, 0xff,
    0x0e, 0x18, 0x00, 0xff, 0x0e, 0x18, 0x00, 0xff, 0x32, 0x24, 0x00, 0xff,
    0x3e, 0x2e, 0x00, 0xff, 0x44, 0x13, 0x00, 0xff, 0x6c, 0x3b, 0x00, 0xff,
    0x6c, 0x1f, 0x00, 0xff, 0x8c, 0x41, 0x00, 0xff, 0x99, 0x32, 0x00, 0xff,
    0x99, 0x32, 0x00, 0xff, 0x99, 0x32, 0x00, 0xff, 0xbb, 0x10, 0x00, 0xff,
    0xc5, 0x05, 0x00, 0xff, 0xcf, 0x0b, 0x00, 0xff, 0xd5, 0x0e, 0x00, 0xff,
    0xe1, 0x13, 0x00, 0xff, 0xe7, 0x24, 0x00, 0xff, 0xe7, 0x40, 0x00, 0xff,
    0xe7, 0x58, 0x00, 0xff, 0xe7, 0x70, 0x00, 0xff, 0x7c, 0x9b, 0x00, 0xff,
    0x6d, 0x9b, 0x00, 0xff, 0x6d, 0x7d, 0x00, 0xff, 0x18, 0x2f, 0x00, 0xff,
    0x0e, 0x0e, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x09, 0x11, 0x00, 0xff, 0x09, 0x11, 0x00, 0xff, 0x26, 0x2e, 0x00, 0xff,
    0x26, 0x2e, 0x00, 0xff, 0x26, 0x18, 0x00, 0xff, 0x4a, 0x3a, 0x00, 0xff,
    0x58, 0x25, 0x00, 0xff, 0x44, 0x13, 0x00, 0xff, 0x8c, 0x41, 0x00, 0xff,
    0x80, 0x35, 0x00, 0xff, 0x99, 0x32, 0x00, 0xff, 0xa5, 0x3e, 0x00, 0xff,
    0x8d, 0x28, 0x00, 0xff, 0xbb, 0x10, 0x00, 0xff, 0xc5, 0x05, 0x00, 0xff,
    0xcf, 0x08, 0x00, 0xff, 0xdb, 0x0e, 0x00, 0xff, 0xe5, 0x11, 0x00, 0xff,
    0xe9, 0x24, 0x00, 0xff, 0xe9, 0x3c, 0x00, 0xff, 0xe9, 0x58, 0x00, 0xff,
    0xe9, 0x70, 0x00, 0xff, 0x8b, 0xad, 0x00, 0xff, 0x6d, 0x89, 0x00, 0xff,
    0x6d, 0x7d, 0x00, 0xff, 0x36, 0x41, 0x00, 0xff, 0x0e, 0x0e, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x05, 0x05, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x09, 0x11, 0x00, 0xff, 0x26, 0x2e, 0x00, 0xff, 0x32, 0x3a, 0x00, 0xff,
    0x3e, 0x2e, 0x00, 0xff, 0x4a, 0x3a, 0x00, 0xff, 0x6c, 0x3b, 0x00, 0xff,
    0x6c, 0x3b, 0x00, 0xff, 0x74, 0x2b, 0x00, 0xff, 0x8c, 0x41, 0x00, 0xff,
    0x99, 0x32, 0x00, 0xff, 0x99, 0x32, 0x00, 0xff, 0xa5, 0x3e, 0x00, 0xff,
    0xbb, 0x10, 0x00, 0xff, 0xcb, 0x02, 0x00, 0xff, 0xd5, 0x08, 0x00, 0xff,
    0xe1, 0x0b, 0x00, 0xff, 0xeb, 0x11, 0x00, 0xff, 0xeb, 0x24, 0x00, 0xff,
    0xeb, 0x3c, 0x00, 0xff, 0xeb, 0x58, 0x00, 0xff, 0xeb, 0x70, 0x00, 0xff,
    0x8b, 0xad, 0x00, 0xff, 0x6d, 0x9b, 0x00, 0xff, 0x6d, 0x7d, 0x00, 0xff,
    0x6d, 0x7d, 0x00, 0xff, 0x35, 0x35, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x11, 0x11, 0x00, 0xff,
    0x05, 0x05, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x09, 0x11, 0x00, 0xff,
    0x26, 0x2e, 0x00, 0xff, 0x32, 0x3a, 0x00, 0xff, 0x4a, 0x3a, 0x00, 0xff,
    0x4a, 0x3a, 0x00, 0xff, 0x6c, 0x3b, 0x00, 0xff, 0x80, 0x4d, 0x00, 0xff,
    0x8c, 0x41, 0x00, 0xff, 0x80, 0x35, 0x00, 0xff, 0xa5, 0x3e, 0x00, 0xff,
    0xa5, 0x3e, 0x00, 0xff, 0x99, 0x32, 0x00, 0xff, 0xbb, 0x10, 0x00, 0xff,
    0xcf, 0x02, 0x00, 0xff, 0xdb, 0x05, 0x00, 0xff, 0xe5, 0x0b, 0x00, 0xff,
    0xeb, 0x0e, 0x00, 0xff, 0xed, 0x24, 0x00, 0xff, 0xed, 0x3c, 0x00, 0xff,
    0xed, 0x54, 0x00, 0xff, 0xed, 0x70, 0x00, 0xff, 0x7d, 0x95, 0x00, 0xff,
    0x7d, 0x95, 0x00, 0xff, 0x5d, 0x77, 0x00, 0xff, 0x5d, 0x77, 0x00, 0xff,
    0x5c, 0x6e, 0x00, 0xff, 0x25, 0x37, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x07, 0x00, 0x00, 0xff, 0x13, 0x13, 0x00, 0xff, 0x13, 0x13, 0x00, 0xff,
    0x13, 0x13, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff, 0x3d, 0x1b, 0x00, 0xff,
    0x55, 0x33, 0x00, 0xff, 0x6b, 0x49, 0x00, 0xff, 0x6b, 0x49, 0x00, 0xff,
    0x69, 0x3f, 0x00, 0xff, 0x81, 0x57, 0x00, 0xff, 0x8d, 0x63, 0x00, 0xff,
    0x81, 0x57, 0x00, 0xff, 0xa0, 0x17, 0x00, 0xff, 0xb5, 0x2d, 0x00, 0xff,
    0xb5, 0x2d, 0x00, 0xff, 0xd3, 0x05, 0x00, 0xff, 0xd7, 0x00, 0x00, 0xff,
    0xe1, 0x00, 0x00, 0xff, 0xea, 0x0a, 0x00, 0xff, 0xf0, 0x10, 0x00, 0xff,
    0xe8, 0x1d, 0x00, 0xff, 0xea, 0x3e, 0x00, 0xff, 0xee, 0x5f, 0x00, 0xff,
    0xf0, 0x80, 0x00, 0xff, 0x7d, 0x95, 0x00, 0xff, 0x5d, 0x77, 0x00, 0xff,
    0x5d, 0x77, 0x00, 0xff, 0x41, 0x65, 0x00, 0xff, 0x3e, 0x55, 0x00, 0xff,
    0x25, 0x37, 0x00, 0xff, 0x1b, 0x0a, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x13, 0x13, 0x00, 0xff, 0x13, 0x13, 0x00, 0xff, 0x33, 0x33, 0x00, 0xff,
    0x13, 0x13, 0x00, 0xff, 0x3d, 0x1b, 0x00, 0xff, 0x55, 0x33, 0x00, 0xff,
    0x55, 0x33, 0x00, 0xff, 0x6b, 0x49, 0x00, 0xff, 0x75, 0x4b, 0x00, 0xff,
    0x69, 0x3f, 0x00, 0xff, 0x81, 0x57, 0x00, 0xff, 0x8d, 0x63, 0x00, 0xff,
    0xb5, 0x2d, 0x00, 0xff, 0xa0, 0x17, 0x00, 0xff, 0xd3, 0x05, 0x00, 0xff,
    0xd3, 0x05, 0x00, 0xff, 0xd7, 0x00, 0x00, 0xff, 0xed, 0x05, 0x00, 0xff,
    0xea, 0x0a, 0x00, 0xff, 0xf0, 0x10, 0x00, 0xff, 0xe8, 0x1d, 0x00, 0xff,
    0xec, 0x3e, 0x00, 0xff, 0xee, 0x5f, 0x00, 0xff, 0xf2, 0x80, 0x00, 0xff,
    0x71, 0x65, 0x00, 0xff, 0x5d, 0x53, 0x00, 0xff, 0x49, 0x41, 0x00, 0xff,
    0x35, 0x2f, 0x00, 0xff, 0x25, 0x37, 0x00, 0xff, 0x25, 0x37, 0x00, 0xff,
    0x3e, 0x28, 0x00, 0xff, 0x07, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff,
    0x33, 0x33, 0x00, 0xff, 0x33, 0x33, 0x00, 0xff, 0x33, 0x33, 0x00, 0xff,
    0x55, 0x33, 0x00, 0xff, 0x55, 0x33, 0x00, 0xff, 0x77, 0x33, 0x00, 0xff,
    0x77, 0x33, 0x00, 0xff, 0x8d, 0x33, 0x00, 0xff, 0x8d, 0x33, 0x00, 0xff,
    0x8d, 0x33, 0x00, 0xff, 0xa5, 0x4b, 0x00, 0xff, 0xb5, 0x2d, 0x00, 0xff,
    0xb5, 0x2d, 0x00, 0xff, 0xd3, 0x05, 0x00, 0xff, 0xd3, 0x05, 0x00, 0xff,
    0xe1, 0x00, 0x00, 0xff, 0xed, 0x05, 0x00, 0xff, 0xe6, 0x05, 0x00, 0xff,
    0xf0, 0x10, 0x00, 0xff, 0xea, 0x1d, 0x00, 0xff, 0xec, 0x3e, 0x00, 0xff,
    0xf0, 0x5f, 0x00, 0xff, 0xf2, 0x80, 0x00, 0xff, 0x71, 0x65, 0x00, 0xff,
    0x5d, 0x53, 0x00, 0xff, 0x49, 0x41, 0x00, 0xff, 0x35, 0x2f, 0x00, 0xff,
    0x07, 0x19, 0x00, 0xff, 0x25, 0x37, 0x00, 0xff, 0x3e, 0x28, 0x00, 0xff,
    0x1b, 0x0a, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff,
    0x33, 0x33, 0x00, 0xff, 0x53, 0x53, 0x00, 0xff, 0x55, 0x33, 0x00, 0xff,
    0x6b, 0x49, 0x00, 0xff, 0x77, 0x33, 0x00, 0xff, 0x77, 0x33, 0x00, 0xff,
    0x81, 0x27, 0x00, 0xff, 0x99, 0x3f, 0x00, 0xff, 0x99, 0x3f, 0x00, 0xff,
    0x8d, 0x33, 0x00, 0xff, 0xb5, 0x2d, 0x00, 0xff, 0xb5, 0x2d, 0x00, 0xff,
    0xd3, 0x05, 0x00, 0xff, 0xd3, 0x05, 0x00, 0xff, 0xe1, 0x00, 0x00, 0xff,
    0xed, 0x05, 0x00, 0xff, 0xe6, 0x05, 0x00, 0xff, 0xea, 0x0a, 0x00, 0xff,
    0xea, 0x1d, 0x00, 0xff, 0xee, 0x3e, 0x00, 0xff, 0xf0, 0x5f, 0x00, 0xff,
    0xf2, 0x80, 0x00, 0xff, 0x7b, 0x74, 0x00, 0xff, 0x57, 0x4a, 0x00, 0xff,
    0x60, 0x4a, 0x00, 0xff, 0x4e, 0x35, 0x00, 0xff, 0x45, 0x33, 0x00, 0xff,
    0x33, 0x23, 0x00, 0xff, 0x45, 0x33, 0x00, 0xff, 0x45, 0x33, 0x00, 0xff,
    0x56, 0x22, 0x00, 0xff, 0x66, 0x00, 0x00, 0xff, 0x56, 0x22, 0x00, 0xff,
    0x76, 0x43, 0x00, 0xff, 0x8d, 0x4a, 0x00, 0xff, 0x65, 0x26, 0x00, 0xff,
    0x8d, 0x4a, 0x00, 0xff, 0x79, 0x3a, 0x00, 0xff, 0x9f, 0x28, 0x00, 0xff,
    0x9f, 0x28, 0x00, 0xff, 0x9f, 0x28, 0x00, 0xff, 0xb5, 0x0b, 0x00, 0xff,
    0xc3, 0x00, 0x00, 0xff, 0xe9, 0x11, 0x00, 0xff, 0xdf, 0x00, 0x00, 0xff,
    0xe9, 0x02, 0x00, 0xff, 0xeb, 0x00, 0x00, 0xff, 0xed, 0x05, 0x00, 0xff,
    0xed, 0x0a, 0x00, 0xff, 0xef, 0x10, 0x00, 0xff, 0xeb, 0x1b, 0x00, 0xff,
    0xec, 0x3e, 0x00, 0xff, 0xed, 0x5c, 0x00, 0xff, 0xef, 0x7a, 0x00, 0xff,
    0x90, 0x89, 0x00, 0xff, 0x57, 0x4a, 0x00, 0xff, 0x4e, 0x35, 0x00, 0xff,
    0x4e, 0x35, 0x00, 0xff, 0x45, 0x33, 0x00, 0xff, 0x33, 0x23, 0x00, 0xff,
    0x33, 0x23, 0x00, 0xff, 0x54, 0x43, 0x00, 0xff, 0x76, 0x43, 0x00, 0xff,
    0x86, 0x10, 0x00, 0xff, 0x86, 0x10, 0x00, 0xff, 0x76, 0x43, 0x00, 0xff,
    0x8d, 0x4a, 0x00, 0xff, 0x8d, 0x4a, 0x00, 0xff, 0x79, 0x3a, 0x00, 0xff,
    0x8d, 0x4a, 0x00, 0xff, 0x9f, 0x28, 0x00, 0xff, 0x9f, 0x28, 0x00, 0xff,
    0xb5, 0x0b, 0x00, 0xff, 0xb5, 0x0b, 0x00, 0xff, 0xc3, 0x00, 0x00, 0xff,
    0xd5, 0x00, 0x00, 0xff, 0xe5, 0x00, 0x00, 0xff, 0xe5, 0x00, 0x00, 0xff,
    0xe9, 0x01, 0x00, 0xff, 0xeb, 0x05, 0x00, 0xff, 0xeb, 0x0a, 0x00, 0xff,
    0xed, 0x10, 0x00, 0xff, 0xeb, 0x1b, 0x00, 0xff, 0xec, 0x39, 0x00, 0xff,
    0xed, 0x5c, 0x00, 0xff, 0xef, 0x7a, 0x00, 0xff, 0x90, 0x89, 0x00, 0xff,
    0x6c, 0x5f, 0x00, 0xff, 0x4e, 0x35, 0x00, 0xff, 0x60, 0x4a, 0x00, 0xff,
    0x54, 0x43, 0x00, 0xff, 0x54, 0x43, 0x00, 0xff, 0x66, 0x0f, 0x00, 0xff,
    0x54, 0x43, 0x00, 0xff, 0x76, 0x43, 0x00, 0xff, 0x76, 0x43, 0x00, 0xff,
    0x86, 0x10, 0x00, 0xff, 0x86, 0x10, 0x00, 0xff, 0xad, 0x32, 0x00, 0xff,
    0xad, 0x32, 0x00, 0xff, 0x95, 0x1e, 0x00, 0xff, 0xa1, 0x26, 0x00, 0xff,
    0x9f, 0x28, 0x00, 0xff, 0x9f, 0x28, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff,
    0xb5, 0x0b, 0x00, 0xff, 0xd5, 0x00, 0x00, 0xff, 0xd5, 0x00, 0x00, 0xff,
    0xe5, 0x00, 0x00, 0xff, 0xe5, 0x00, 0x00, 0xff, 0xe7, 0x01, 0x00, 0xff,
    0xe9, 0x05, 0x00, 0xff, 0xe9, 0x0a, 0x00, 0xff, 0xeb, 0x10, 0x00, 0xff,
    0xeb, 0x1b, 0x00, 0xff, 0xec, 0x39, 0x00, 0xff, 0xed, 0x5c, 0x00, 0xff,
    0xef, 0x7a, 0x00, 0xff, 0x90, 0x89, 0x00, 0xff, 0x7b, 0x74, 0x00, 0xff,
    0x60, 0x4a, 0x00, 0xff, 0x60, 0x4a, 0x00, 0xff, 0x54, 0x43, 0x00, 0xff,
    0x54, 0x43, 0x00, 0xff, 0x66, 0x0f, 0x00, 0xff, 0x66, 0x0f, 0x00, 0xff,
    0x76, 0x43, 0x00, 0xff, 0x76, 0x43, 0x00, 0xff, 0x86, 0x10, 0x00, 0xff,
    0x86, 0x10, 0x00, 0xff, 0x8d, 0x0e, 0x00, 0xff, 0xa1, 0x26, 0x00, 0xff,
    0xa1, 0x26, 0x00, 0xff, 0x8d, 0x0e, 0x00, 0xff, 0xb5, 0x0b, 0x00, 0xff,
    0xc1, 0x17, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff,
    0xd5, 0x00, 0x00, 0xff, 0xd5, 0x00, 0x00, 0xff, 0xdf, 0x00, 0x00, 0xff,
    0xdf, 0x00, 0x00, 0xff, 0xe5, 0x01, 0x00, 0xff, 0xe7, 0x07, 0x00, 0xff,
    0xe7, 0x0c, 0x00, 0xff, 0xe9, 0x10, 0x00, 0xff, 0xeb, 0x1b, 0x00, 0xff,
    0xec, 0x39, 0x00, 0xff, 0xed, 0x5c, 0x00, 0xff, 0xef, 0x7a, 0x00, 0xff,
    0x9d, 0x83, 0x00, 0xff, 0x9d, 0x83, 0x00, 0xff, 0x8e, 0x56, 0x00, 0xff,
    0x73, 0x38, 0x00, 0xff, 0x73, 0x3e, 0x00, 0xff, 0x73, 0x32, 0x00, 0xff,
    0x7c, 0x26, 0x00, 0xff, 0x7c, 0x1c, 0x00, 0xff, 0x82, 0x1c, 0x00, 0xff,
    0x8e, 0x28, 0x00, 0xff, 0x8e, 0x28, 0x00, 0xff, 0xa4, 0x1c, 0x00, 0xff,
    0xb3, 0x0e, 0x00, 0xff, 0xad, 0x08, 0x00, 0xff, 0xbd, 0x18, 0x00, 0xff,
    0xb9, 0x12, 0x00, 0xff, 0xbf, 0x00, 0x00, 0xff, 0xc9, 0x02, 0x00, 0xff,
    0xd5, 0x00, 0x00, 0xff, 0xd5, 0x00, 0x00, 0xff, 0xdb, 0x00, 0x00, 0xff,
    0xdd, 0x00, 0x00, 0xff, 0xdf, 0x02, 0x00, 0xff, 0xe1, 0x02, 0x00, 0xff,
    0xe4, 0x02, 0x00, 0xff, 0xe6, 0x08, 0x00, 0xff, 0xe8, 0x0e, 0x00, 0xff,
    0xea, 0x16, 0x00, 0xff, 0xeb, 0x23, 0x00, 0xff, 0xed, 0x41, 0x00, 0xff,
    0xef, 0x6e, 0x00, 0xff, 0xf1, 0x82, 0x00, 0xff, 0x9d, 0x83, 0x00, 0xff,
    0xa3, 0x8d, 0x00, 0xff, 0xa9, 0x6f, 0x00, 0xff, 0x8e, 0x56, 0x00, 0xff,
    0x85, 0x3e, 0x00, 0xff, 0x85, 0x32, 0x00, 0xff, 0x8b, 0x26, 0x00, 0xff,
    0x8b, 0x1c, 0x00, 0xff, 0xa4, 0x1c, 0x00, 0xff, 0xa4, 0x1c, 0x00, 0xff,
    0xb0, 0x28, 0x00, 0xff, 0xa4, 0x1c, 0x00, 0xff, 0xad, 0x08, 0x00, 0xff,
    0xbd, 0x18, 0x00, 0xff, 0xbd, 0x18, 0x00, 0xff, 0xb3, 0x0e, 0x00, 0xff,
    0xc9, 0x02, 0x00, 0xff, 0xc9, 0x02, 0x00, 0xff, 0xd5, 0x00, 0x00, 0xff,
    0xdb, 0x05, 0x00, 0xff, 0xdd, 0x05, 0x00, 0xff, 0xdf, 0x05, 0x00, 0xff,
    0xe1, 0x08, 0x00, 0xff, 0xe3, 0x08, 0x00, 0xff, 0xe2, 0x02, 0x00, 0xff,
    0xe4, 0x0b, 0x00, 0xff, 0xe6, 0x13, 0x00, 0xff, 0xe8, 0x19, 0x00, 0xff,
    0xe9, 0x32, 0x00, 0xff, 0xeb, 0x55, 0x00, 0xff, 0xed, 0x6e, 0x00, 0xff,
    0xef, 0x91, 0x00, 0xff, 0xa3, 0x8d, 0x00, 0xff, 0x94, 0x79, 0x00, 0xff,
    0xa9, 0x6f, 0x00, 0xff, 0x8e, 0x56, 0x00, 0xff, 0x9a, 0x42, 0x00, 0xff,
    0x9a, 0x38, 0x00, 0xff, 0xa0, 0x2c, 0x00, 0xff, 0xa0, 0x20, 0x00, 0xff,
    0xa4, 0x1c, 0x00, 0xff, 0xa4, 0x1c, 0x00, 0xff, 0xb0, 0x28, 0x00, 0xff,
    0xb0, 0x28, 0x00, 0xff, 0xcb, 0x0e, 0x00, 0xff, 0xcb, 0x0e, 0x00, 0xff,
    0xcb, 0x0e, 0x00, 0xff, 0xd1, 0x12, 0x00, 0xff, 0xd5, 0x0d, 0x00, 0xff,
    0xd5, 0x0d, 0x00, 0xff, 0xe5, 0x10, 0x00, 0xff, 0xdb, 0x05, 0x00, 0xff,
    0xdd, 0x08, 0x00, 0xff, 0xdf, 0x0b, 0x00, 0xff, 0xe1, 0x0b, 0x00, 0xff,
    0xe3, 0x0b, 0x00, 0xff, 0xe2, 0x08, 0x00, 0xff, 0xe4, 0x0e, 0x00, 0xff,
    0xe6, 0x16, 0x00, 0xff, 0xe8, 0x1f, 0x00, 0xff, 0xe7, 0x41, 0x00, 0xff,
    0xe9, 0x55, 0x00, 0xff, 0xeb, 0x82, 0x00, 0xff, 0xed, 0xa0, 0x00, 0xff,
    0xa3, 0x8d, 0x00, 0xff, 0x94, 0x79, 0x00, 0xff, 0xa9, 0x6f, 0x00, 0xff,
    0x8e, 0x56, 0x00, 0xff, 0xa9, 0x42, 0x00, 0xff, 0xa9, 0x38, 0x00, 0xff,
    0xb2, 0x2c, 0x00, 0xff, 0xb2, 0x20, 0x00, 0xff, 0xa4, 0x1c, 0x00, 0xff,
    0xb0, 0x28, 0x00, 0xff, 0xb0, 0x28, 0x00, 0xff, 0xb0, 0x28, 0x00, 0xff,
    0xd7, 0x18, 0x00, 0xff, 0xd1, 0x12, 0x00, 0xff, 0xd7, 0x18, 0x00, 0xff,
    0xd7, 0x18, 0x00, 0xff, 0xdf, 0x19, 0x00, 0xff, 0xdf, 0x19, 0x00, 0xff,
    0xe5, 0x10, 0x00, 0xff, 0xe5, 0x10, 0x00, 0xff, 0xdf, 0x0e, 0x00, 0xff,
    0xe1, 0x0e, 0x00, 0xff, 0xe3, 0x10, 0x00, 0xff, 0xe5, 0x10, 0x00, 0xff,
    0xe0, 0x0b, 0x00, 0xff, 0xe2, 0x13, 0x00, 0xff, 0xe4, 0x19, 0x00, 0xff,
    0xe6, 0x1f, 0x00, 0xff, 0xe7, 0x41, 0x00, 0xff, 0xe7, 0x6e, 0x00, 0xff,
    0xe9, 0x82, 0x00, 0xff, 0xeb, 0xa0, 0x00, 0xff, 0xd3, 0x8d, 0x00, 0xff,
    0xc4, 0x7b, 0x00, 0xff, 0xbb, 0x57, 0x00, 0xff, 0xbb, 0x57, 0x00, 0xff,
    0xce, 0x49, 0x00, 0xff, 0xce, 0x49, 0x00, 0xff, 0xb9, 0x35, 0x00, 0xff,
    0xb9, 0x35, 0x00, 0xff, 0xcb, 0x29, 0x00, 0xff, 0xcb, 0x29, 0x00, 0xff,
    0xcb, 0x29, 0x00, 0xff, 0xcb, 0x29, 0x00, 0xff, 0xd8, 0x1f, 0x00, 0xff,
    0xd8, 0x1f, 0x00, 0xff, 0xdd, 0x1f, 0x00, 0xff, 0xe0, 0x1f, 0x00, 0xff,
    0xe7, 0x1e, 0x00, 0xff, 0xe7, 0x1e, 0x00, 0xff, 0xe7, 0x1e, 0x00, 0xff,
    0xe7, 0x1e, 0x00, 0xff, 0xe3, 0x1c, 0x00, 0xff, 0xe3, 0x1c, 0x00, 0xff,
    0xe3, 0x1c, 0x00, 0xff, 0xe3, 0x1c, 0x00, 0xff, 0xdf, 0x19, 0x00, 0xff,
    0xdf, 0x25, 0x00, 0xff, 0xe2, 0x25, 0x00, 0xff, 0xe2, 0x31, 0x00, 0xff,
    0xe4, 0x50, 0x00, 0xff, 0xe4, 0x68, 0x00, 0xff, 0xe6, 0x80, 0x00, 0xff,
    0xe6, 0x94, 0x00, 0xff, 0xe8, 0x9f, 0x00, 0xff, 0xd3, 0x8d, 0x00, 0xff,
    0xcd, 0x69, 0x00, 0xff, 0xbb, 0x57, 0x00, 0xff, 0xce, 0x49, 0x00, 0xff,
    0xce, 0x49, 0x00, 0xff, 0xce, 0x49, 0x00, 0xff, 0xce, 0x49, 0x00, 0xff,
    0xd8, 0x45, 0x00, 0xff, 0xd8, 0x45, 0x00, 0xff, 0xd8, 0x41, 0x00, 0xff,
    0xd8, 0x41, 0x00, 0xff, 0xdd, 0x3b, 0x00, 0xff, 0xe0, 0x3b, 0x00, 0xff,
    0xe3, 0x3b, 0x00, 0xff, 0xe6, 0x3b, 0x00, 0xff, 0xe9, 0x3e, 0x00, 0xff,
    0xe9, 0x36, 0x00, 0xff, 0xe9, 0x36, 0x00, 0xff, 0xe9, 0x36, 0x00, 0xff,
    0xe7, 0x36, 0x00, 0xff, 0xe7, 0x36, 0x00, 0xff, 0xe7, 0x36, 0x00, 0xff,
    0xe7, 0x36, 0x00, 0xff, 0xe4, 0x31, 0x00, 0xff, 0xe4, 0x41, 0x00, 0xff,
    0xe4, 0x41, 0x00, 0xff, 0xe7, 0x55, 0x00, 0xff, 0xe6, 0x68, 0x00, 0xff,
    0xe8, 0x74, 0x00, 0xff, 0xe8, 0x94, 0x00, 0xff, 0xea, 0xa0, 0x00, 0xff,
    0xfa, 0xb1, 0x00, 0xff, 0xe8, 0x9f, 0x00, 0xff, 0xe2, 0x7b, 0x00, 0xff,
    0xcd, 0x69, 0x00, 0xff, 0xe3, 0x65, 0x00, 0xff, 0xe3, 0x65, 0x00, 0xff,
    0xe3, 0x65, 0x00, 0xff, 0xe3, 0x65, 0x00, 0xff, 0xe5, 0x5d, 0x00, 0xff,
    0xe5, 0x5d, 0x00, 0xff, 0xe5, 0x59, 0x00, 0xff, 0xe5, 0x59, 0x00, 0xff,
    0xe3, 0x57, 0x00, 0xff, 0xe6, 0x57, 0x00, 0xff, 0xe9, 0x57, 0x00, 0xff,
    0xec, 0x57, 0x00, 0xff, 0xeb, 0x5a, 0x00, 0xff, 0xeb, 0x52, 0x00, 0xff,
    0xeb, 0x52, 0x00, 0xff, 0xeb, 0x52, 0x00, 0xff, 0xeb, 0x50, 0x00, 0xff,
    0xeb, 0x50, 0x00, 0xff, 0xeb, 0x50, 0x00, 0xff, 0xeb, 0x50, 0x00, 0xff,
    0xe7, 0x55, 0x00, 0xff, 0xe7, 0x55, 0x00, 0xff, 0xea, 0x65, 0x00, 0xff,
    0xea, 0x65, 0x00, 0xff, 0xea, 0x74, 0x00, 0xff, 0xea, 0x80, 0x00, 0xff,
    0xec, 0xa0, 0x00, 0xff, 0xec, 0xac, 0x00, 0xff, 0xfa, 0xb1, 0x00, 0xff,
    0xfa, 0xb1, 0x00, 0xff, 0xf1, 0x8d, 0x00, 0xff, 0xf1, 0x8d, 0x00, 0xff,
    0xf8, 0x7d, 0x00, 0xff, 0xf8, 0x7d, 0x00, 0xff, 0xf8, 0x7d, 0x00, 0xff,
    0xf8, 0x7d, 0x00, 0xff, 0xf2, 0x75, 0x00, 0xff, 0xf2, 0x75, 0x00, 0xff,
    0xf2, 0x75, 0x00, 0xff, 0xf2, 0x75, 0x00, 0xff, 0xe9, 0x73, 0x00, 0xff,
    0xec, 0x73, 0x00, 0xff, 0xf1, 0x73, 0x00, 0xff, 0xf1, 0x73, 0x00, 0xff,
    0xed, 0x72, 0x00, 0xff, 0xed, 0x72, 0x00, 0xff, 0xed, 0x72, 0x00, 0xff,
    0xed, 0x66, 0x00, 0xff, 0xef, 0x6a, 0x00, 0xff, 0xef, 0x6a, 0x00, 0xff,
    0xef, 0x6a, 0x00, 0xff, 0xef, 0x6a, 0x00, 0xff, 0xea, 0x65, 0x00, 0xff,
    0xed, 0x71, 0x00, 0xff, 0xed, 0x7d, 0x00, 0xff, 0xef, 0x7d, 0x00, 0xff,
    0xec, 0x80, 0x00, 0xff, 0xee, 0x94, 0x00, 0xff, 0xee, 0xac, 0x00, 0xff,
    0xee, 0xc4, 0x00, 0xff,
  ]),
};

var img_32x32_signed_rg11_eac = {
  compressed: new Uint8Array([
    0x24, 0x8b, 0x92, 0x08, 0x02, 0x01, 0x12, 0x53, 0x09, 0x72, 0xdb, 0x5d,
    0x68, 0xb4, 0x49, 0x01, 0xd6, 0x62, 0xd2, 0x0b, 0x01, 0xd0, 0x9d, 0x02,
    0xe6, 0x62, 0xd2, 0x0b, 0x01, 0xd0, 0x9d, 0x02, 0xe0, 0x47, 0xd1, 0x1d,
    0x42, 0xf0, 0x39, 0x1b, 0xf1, 0x47, 0xd1, 0x1d, 0x42, 0xf0, 0x39, 0x1b,
    0xd8, 0x62, 0xa0, 0x2c, 0x0a, 0xd0, 0xab, 0x02, 0xd8, 0x69, 0xd0, 0x2f,
    0x0a, 0xf4, 0xad, 0x42, 0xd4, 0x30, 0xf0, 0x2d, 0x83, 0xda, 0xac, 0x43,
    0xe4, 0x30, 0xf0, 0x2d, 0x83, 0xda, 0xac, 0x43, 0xcb, 0x7b, 0xd4, 0x4d,
    0x41, 0xd6, 0x2f, 0x41, 0xcb, 0x7b, 0xd4, 0x4d, 0x41, 0xd6, 0x2f, 0x41,
    0xf2, 0xbd, 0xd1, 0x2d, 0x11, 0xd0, 0xac, 0x02, 0xe0, 0x47, 0xf5, 0x2f,
    0x51, 0xf4, 0xaf, 0x02, 0x1f, 0x49, 0x48, 0x92, 0x04, 0x92, 0xdb, 0xb7,
    0xf5, 0x6b, 0x80, 0xab, 0x01, 0xd6, 0x0f, 0xac, 0xe9, 0x69, 0xbb, 0x58,
    0x00, 0x25, 0x20, 0x9a, 0xe9, 0x69, 0xbb, 0x58, 0x00, 0x25, 0x20, 0x9a,
    0x9d, 0x32, 0xfe, 0xae, 0x10, 0x9c, 0x99, 0x31, 0xb2, 0x3c, 0xfe, 0xbe,
    0x18, 0x1d, 0xb0, 0x2b, 0x90, 0x3c, 0xa2, 0xde, 0x00, 0xd9, 0x09, 0x22,
    0xa5, 0x20, 0x86, 0x4e, 0x49, 0x91, 0xa0, 0x03, 0x93, 0x3d, 0x18, 0xea,
    0x0e, 0x14, 0xbc, 0x1e, 0x98, 0x2a, 0x32, 0xf0, 0x6f, 0x22, 0xa8, 0x57,
    0x82, 0x8f, 0x96, 0x4b, 0x24, 0x96, 0x4d, 0x2c, 0xa9, 0x3a, 0x54, 0x2a,
    0x80, 0x54, 0x2e, 0x2a, 0xdd, 0x47, 0x29, 0x00, 0xc2, 0x64, 0x26, 0xb0,
    0xb7, 0x4b, 0xd5, 0x0f, 0x02, 0x98, 0x29, 0x78, 0xea, 0x44, 0x6a, 0xc0,
    0xad, 0x82, 0x61, 0x26, 0xc5, 0x20, 0x66, 0x0a, 0x64, 0xf4, 0x6b, 0xc6,
    0x35, 0x4b, 0x64, 0x14, 0x80, 0x92, 0x4f, 0xff, 0xe5, 0x47, 0x64, 0x14,
    0x80, 0x00, 0x0b, 0x6d, 0xdd, 0x62, 0xb2, 0xe1, 0x04, 0x24, 0x24, 0x52,
    0xed, 0x62, 0xb2, 0xe1, 0x04, 0x24, 0x24, 0x52, 0x97, 0x2a, 0xf7, 0xd5,
    0xe8, 0x0b, 0xaa, 0x05, 0xa0, 0x2a, 0xf7, 0xd5, 0xe8, 0x0b, 0xaa, 0x05,
    0x8e, 0x3d, 0x77, 0xb4, 0xe7, 0x49, 0xbb, 0x5b, 0xa0, 0x30, 0x63, 0x82,
    0xaf, 0x24, 0x00, 0x1b, 0x8e, 0x42, 0x80, 0x18, 0x08, 0xd2, 0x68, 0x25,
    0x8f, 0x2a, 0xf6, 0xaf, 0x45, 0xe0, 0x70, 0x85, 0xc0, 0x42, 0x09, 0x44,
    0x88, 0xa0, 0x6b, 0xad, 0x97, 0x2a, 0xa9, 0x74, 0x85, 0xa9, 0x7b, 0xed,
    0xf0, 0x23, 0x6f, 0xfb, 0xff, 0xf7, 0xf3, 0xff, 0x87, 0xb2, 0xb6, 0xdd,
    0x6d, 0xba, 0xd9, 0x6d, 0x24, 0x37, 0x2e, 0xf6, 0x7f, 0xaf, 0xfb, 0x7f,
    0xa7, 0x4c, 0x63, 0x90, 0xc9, 0xe0, 0x9f, 0xc9, 0xfb, 0xb5, 0xdb, 0x6d,
    0xb6, 0xdf, 0xff, 0xff, 0xdb, 0xbd, 0x8a, 0x24, 0x92, 0x80, 0x0d, 0xb6,
    0xe3, 0x50, 0xb7, 0x69, 0x24, 0x12, 0x46, 0xd4, 0xf1, 0x67, 0xdb, 0xfb,
    0xae, 0x12, 0x46, 0xd4, 0x9b, 0x3c, 0x84, 0xf2, 0xdb, 0x2d, 0xb6, 0xdb,
    0x9b, 0x3c, 0x84, 0xf2, 0xdb, 0x2d, 0xb6, 0xdb, 0x80, 0x2f, 0x02, 0x78,
    0x04, 0xb4, 0x0b, 0x6d, 0x80, 0x20, 0x02, 0x68, 0x04, 0xd8, 0x0d, 0xb6,
    0xaf, 0x42, 0x40, 0x04, 0x24, 0x82, 0xeb, 0xb6, 0xa8, 0x2a, 0x56, 0xd5,
    0x7f, 0x0a, 0xfb, 0xff, 0xe5, 0x47, 0x42, 0x48, 0xa6, 0x9e, 0xff, 0xbe,
    0xb2, 0x20, 0x66, 0xda, 0xef, 0x58, 0x6d, 0x34, 0x20, 0x20, 0x00, 0x41,
    0x04, 0x0a, 0x0f, 0xff, 0xaf, 0x20, 0x92, 0x69, 0xa6, 0x83, 0x46, 0xdb,
    0x5a, 0x2b, 0x6d, 0x14, 0x44, 0x12, 0xdb, 0xbf, 0x8b, 0x19, 0x25, 0x28,
    0x01, 0xb6, 0x4f, 0xb5, 0x66, 0x1f, 0x97, 0x79, 0x77, 0x97, 0x79, 0x77,
    0xcd, 0x4c, 0x6d, 0xb0, 0x49, 0xb6, 0xcf, 0xff, 0xd5, 0x47, 0xff, 0x6f,
    0x24, 0x90, 0x08, 0x12, 0xcd, 0x62, 0xfe, 0xdf, 0xa4, 0xd8, 0x0d, 0x49,
    0xb0, 0x5a, 0xf4, 0x20, 0x00, 0x66, 0xd4, 0xd1, 0xb3, 0x52, 0xfa, 0x19,
    0x24, 0x68, 0x06, 0xda, 0x83, 0x85, 0x92, 0xd9, 0x2d, 0x96, 0xdb, 0x2f,
    0x83, 0x85, 0x90, 0x09, 0x28, 0x96, 0xd1, 0x2f, 0xdc, 0x20, 0x6c, 0x00,
    0x06, 0xc3, 0xfd, 0xbf, 0xaf, 0x20, 0x4a, 0x49, 0x27, 0xf2, 0x4f, 0xe4,
    0x0a, 0x42, 0x46, 0x00, 0xa5, 0x82, 0x51, 0x34, 0xc8, 0x42, 0x10, 0xaa,
    0x08, 0xd4, 0x8b, 0xa1, 0x41, 0x36, 0x60, 0x00, 0xc0, 0x16, 0xdb, 0x6d,
    0x92, 0x3c, 0x9f, 0xff, 0x3f, 0xe4, 0x92, 0x49, 0x64, 0x11, 0x6c, 0x01,
    0xb6, 0xb6, 0x4f, 0xfd, 0x89, 0x1a, 0x6d, 0xb6, 0x49, 0x90, 0x0d, 0xb4,
    0x6f, 0x2d, 0x49, 0x12, 0x40, 0x12, 0x5b, 0x76, 0xb3, 0xb2, 0x00, 0x09,
    0x24, 0xb6, 0xdd, 0xb6, 0xf6, 0x31, 0x9b, 0x64, 0x84, 0x2d, 0x96, 0xc9,
    0xd9, 0x72, 0xbb, 0x60, 0x25, 0x04, 0x82, 0x40, 0xcb, 0x3a, 0x02, 0xd4,
    0xad, 0x0b, 0xf1, 0x6f, 0xa9, 0x3a, 0xb7, 0xf0, 0x3f, 0xa1, 0x2b, 0xfa,
    0xf0, 0x23, 0x76, 0xd3, 0xed, 0x7f, 0xfb, 0x7f, 0x9f, 0x32, 0x9f, 0xf6,
    0x7f, 0x84, 0x9f, 0xc9, 0x06, 0x47, 0x93, 0xc5, 0x3e, 0x82, 0xe1, 0x34,
    0xb6, 0x32, 0xd8, 0x33, 0x81, 0xd1, 0x19, 0x8b, 0x26, 0x20, 0x00, 0x60,
    0x07, 0x1b, 0xfd, 0xb7, 0x9a, 0x10, 0xff, 0xbf, 0xf8, 0xec, 0x06, 0xd8,
    0x5b, 0x24, 0x6c, 0x0c, 0x00, 0x96, 0xcd, 0x6c, 0x82, 0xfd, 0x00, 0x0a,
    0x00, 0x00, 0x08, 0x00, 0x6b, 0x2d, 0x80, 0xab, 0x01, 0xb0, 0x1d, 0x60,
    0x89, 0x1a, 0x69, 0x22, 0x00, 0x96, 0xdd, 0xb7, 0x6d, 0x00, 0x49, 0x20,
    0x00, 0xdb, 0x6f, 0xff, 0xce, 0x5c, 0x6d, 0xb2, 0x49, 0xb6, 0xcf, 0xff,
    0x1b, 0x33, 0x92, 0xd9, 0x40, 0x3b, 0x66, 0x49, 0xe6, 0x5f, 0xdb, 0xfd,
    0xed, 0x12, 0x46, 0x00, 0x15, 0x37, 0x66, 0x66, 0x66, 0x42, 0xf4, 0x2f,
    0xb1, 0x29, 0xdb, 0xf9, 0x2d, 0x24, 0x06, 0xd2, 0x15, 0x20, 0x5b, 0x61,
    0xb7, 0x1f, 0xfd, 0xbf, 0x84, 0x41, 0xb6, 0xdd, 0x6e, 0xdb, 0x6b, 0x76,
    0x43, 0x27, 0x4e, 0xf6, 0x2e, 0x02, 0xf2, 0xb7, 0x86, 0x2b, 0xb2, 0xf9,
    0xee, 0xfe, 0xfd, 0x77, 0x54, 0x2b, 0x66, 0x62, 0x66, 0x93, 0xf9, 0x6f,
    0x8b, 0x2a, 0x46, 0x62, 0x66, 0x4a, 0xd4, 0x05, 0x61, 0x2d, 0x44, 0x82,
    0x04, 0x12, 0x59, 0x6e, 0x88, 0x1b, 0x62, 0x64, 0x26, 0x22, 0xf3, 0x2f,
    0x66, 0x2d, 0x04, 0xa8, 0x01, 0xb2, 0x0d, 0x6c, 0x91, 0x10, 0x6d, 0x14,
    0x44, 0x12, 0xeb, 0xbf, 0x6c, 0x2d, 0x80, 0xab, 0x01, 0xd6, 0x0d, 0xac,
    0xe7, 0x6b, 0x6d, 0x12, 0x44, 0x92, 0xed, 0xbf, 0x5d, 0x37, 0x17, 0xf4,
    0x2f, 0x66, 0x66, 0xce, 0x07, 0x62, 0x97, 0x61, 0x2e, 0x44, 0x44, 0x8c,
    0x47, 0x72, 0x92, 0xe9, 0x2e, 0x12, 0xe1, 0x2e, 0xd5, 0x47, 0x02, 0xf0,
    0x2f, 0x42, 0xf4, 0x2f, 0x59, 0xdd, 0x12, 0xe1, 0x2e, 0x12, 0xe1, 0x2e,
    0xd2, 0x4c, 0x62, 0xf6, 0x2f, 0x66, 0x76, 0x67, 0x66, 0x12, 0x68, 0x56,
    0x66, 0x42, 0xf3, 0x37, 0x83, 0xef, 0x97, 0x79, 0x77, 0x97, 0x79, 0x77,
    0x66, 0x1f, 0x97, 0x79, 0x77, 0x97, 0x79, 0x77, 0xc7, 0x47, 0x42, 0xf6,
    0x2f, 0x62, 0xf6, 0x67, 0x60, 0x2f, 0x97, 0x79, 0x77, 0x97, 0x79, 0x77,
    0x83, 0xdf, 0x97, 0x79, 0x77, 0x97, 0x79, 0x77, 0x66, 0x1b, 0x42, 0x62,
    0x2e, 0x32, 0xf1, 0x2f, 0xcd, 0x5b, 0x66, 0x64, 0x26, 0x42, 0xf3, 0x37,
    0x6b, 0x2d, 0x44, 0x54, 0x65, 0x42, 0x62, 0x2e, 0x0d, 0x40, 0x68, 0x84,
    0x44, 0x12, 0xe9, 0x77,
  ]),
  decompressed: new Uint8Array([
    0xab, 0xb9, 0x00, 0xff, 0xab, 0xb9, 0x00, 0xff, 0x93, 0xa4, 0x00, 0xff,
    0x7c, 0x8f, 0x00, 0xff, 0x80, 0x8f, 0x00, 0xff, 0x6e, 0x7e, 0x00, 0xff,
    0x80, 0x8f, 0x00, 0xff, 0x80, 0x8f, 0x00, 0xff, 0x7c, 0x8c, 0x00, 0xff,
    0x7c, 0x8c, 0x00, 0xff, 0x87, 0x98, 0x00, 0xff, 0x68, 0x79, 0x00, 0xff,
    0x70, 0x81, 0x00, 0xff, 0x81, 0x8d, 0x00, 0xff, 0x81, 0x8d, 0x00, 0xff,
    0x70, 0x81, 0x00, 0xff, 0x7e, 0x8d, 0x00, 0xff, 0x6c, 0x7c, 0x00, 0xff,
    0x6c, 0x7c, 0x00, 0xff, 0x6c, 0x7c, 0x00, 0xff, 0x75, 0x75, 0x00, 0xff,
    0x75, 0x75, 0x00, 0xff, 0x75, 0x75, 0x00, 0xff, 0x89, 0x89, 0x00, 0xff,
    0x87, 0x87, 0x00, 0xff, 0x87, 0x87, 0x00, 0xff, 0x87, 0x87, 0x00, 0xff,
    0x87, 0x87, 0x00, 0xff, 0x7f, 0x7b, 0x00, 0xff, 0x8a, 0x8c, 0x00, 0xff,
    0xa2, 0x98, 0x00, 0xff, 0xae, 0xaa, 0x00, 0xff, 0xab, 0xb9, 0x00, 0xff,
    0x93, 0xa4, 0x00, 0xff, 0x93, 0xa4, 0x00, 0xff, 0x7c, 0x8f, 0x00, 0xff,
    0x5c, 0x6c, 0x00, 0xff, 0x5c, 0x6c, 0x00, 0xff, 0x5c, 0x6c, 0x00, 0xff,
    0x5c, 0x6c, 0x00, 0xff, 0x68, 0x79, 0x00, 0xff, 0x70, 0x80, 0x00, 0xff,
    0x68, 0x79, 0x00, 0xff, 0x68, 0x79, 0x00, 0xff, 0x4c, 0x5e, 0x00, 0xff,
    0x4c, 0x5e, 0x00, 0xff, 0x5e, 0x70, 0x00, 0xff, 0x5e, 0x70, 0x00, 0xff,
    0x5a, 0x6a, 0x00, 0xff, 0x6c, 0x7c, 0x00, 0xff, 0x6c, 0x7c, 0x00, 0xff,
    0x42, 0x52, 0x00, 0xff, 0x67, 0x67, 0x00, 0xff, 0x67, 0x67, 0x00, 0xff,
    0x67, 0x67, 0x00, 0xff, 0x67, 0x67, 0x00, 0xff, 0x72, 0x70, 0x00, 0xff,
    0x72, 0x70, 0x00, 0xff, 0x72, 0x70, 0x00, 0xff, 0x67, 0x68, 0x00, 0xff,
    0x7f, 0x69, 0x00, 0xff, 0x96, 0x7b, 0x00, 0xff, 0xa2, 0x8c, 0x00, 0xff,
    0xba, 0x98, 0x00, 0xff, 0xab, 0xb9, 0x00, 0xff, 0x93, 0xa4, 0x00, 0xff,
    0x6c, 0x7b, 0x00, 0xff, 0x6c, 0x7b, 0x00, 0xff, 0x5c, 0x6c, 0x00, 0xff,
    0x4a, 0x5a, 0x00, 0xff, 0x38, 0x48, 0x00, 0xff, 0x4a, 0x5a, 0x00, 0xff,
    0x40, 0x51, 0x00, 0xff, 0x54, 0x65, 0x00, 0xff, 0x54, 0x65, 0x00, 0xff,
    0x34, 0x45, 0x00, 0xff, 0x4c, 0x4c, 0x00, 0xff, 0x3a, 0x3a, 0x00, 0xff,
    0x3a, 0x3a, 0x00, 0xff, 0x4c, 0x4c, 0x00, 0xff, 0x4b, 0x5b, 0x00, 0xff,
    0x4b, 0x5b, 0x00, 0xff, 0x63, 0x73, 0x00, 0xff, 0x4b, 0x5b, 0x00, 0xff,
    0x3d, 0x3d, 0x00, 0xff, 0x3d, 0x3d, 0x00, 0xff, 0x52, 0x52, 0x00, 0xff,
    0x3d, 0x3d, 0x00, 0xff, 0x51, 0x40, 0x00, 0xff, 0x51, 0x40, 0x00, 0xff,
    0x5c, 0x4c, 0x00, 0xff, 0x67, 0x54, 0x00, 0xff, 0x8a, 0x57, 0x00, 0xff,
    0x96, 0x69, 0x00, 0xff, 0xae, 0x7b, 0x00, 0xff, 0xba, 0x8c, 0x00, 0xff,
    0x93, 0xa4, 0x00, 0xff, 0x6c, 0x7b, 0x00, 0xff, 0x7c, 0x8f, 0x00, 0xff,
    0x54, 0x66, 0x00, 0xff, 0x4a, 0x5a, 0x00, 0xff, 0x38, 0x48, 0x00, 0xff,
    0x38, 0x48, 0x00, 0xff, 0x26, 0x36, 0x00, 0xff, 0x4c, 0x5d, 0x00, 0xff,
    0x40, 0x51, 0x00, 0xff, 0x34, 0x45, 0x00, 0xff, 0x34, 0x45, 0x00, 0xff,
    0x28, 0x28, 0x00, 0xff, 0x28, 0x28, 0x00, 0xff, 0x28, 0x28, 0x00, 0xff,
    0x28, 0x28, 0x00, 0xff, 0x39, 0x49, 0x00, 0xff, 0x27, 0x37, 0x00, 0xff,
    0x39, 0x49, 0x00, 0xff, 0x27, 0x37, 0x00, 0xff, 0x52, 0x52, 0x00, 0xff,
    0x28, 0x28, 0x00, 0xff, 0x1a, 0x1a, 0x00, 0xff, 0x28, 0x28, 0x00, 0xff,
    0x51, 0x40, 0x00, 0xff, 0x5c, 0x4c, 0x00, 0xff, 0x51, 0x40, 0x00, 0xff,
    0x51, 0x40, 0x00, 0xff, 0x8a, 0x4b, 0x00, 0xff, 0xa2, 0x57, 0x00, 0xff,
    0xae, 0x69, 0x00, 0xff, 0xc2, 0x7b, 0x00, 0xff, 0x80, 0x80, 0x00, 0xff,
    0x6f, 0x6f, 0x00, 0xff, 0x4b, 0x4b, 0x00, 0xff, 0x5d, 0x5d, 0x00, 0xff,
    0x41, 0x4d, 0x00, 0xff, 0x41, 0x4d, 0x00, 0xff, 0x20, 0x29, 0x00, 0xff,
    0x20, 0x29, 0x00, 0xff, 0x19, 0x29, 0x00, 0xff, 0x2b, 0x41, 0x00, 0xff,
    0x22, 0x29, 0x00, 0xff, 0x16, 0x1f, 0x00, 0xff, 0x10, 0x10, 0x00, 0xff,
    0x16, 0x14, 0x00, 0xff, 0x10, 0x10, 0x00, 0xff, 0x19, 0x1a, 0x00, 0xff,
    0x12, 0x11, 0x00, 0xff, 0x22, 0x32, 0x00, 0xff, 0x12, 0x11, 0x00, 0xff,
    0x32, 0x44, 0x00, 0xff, 0x49, 0x4f, 0x00, 0xff, 0x51, 0x5b, 0x00, 0xff,
    0x31, 0x3b, 0x00, 0xff, 0x31, 0x3b, 0x00, 0xff, 0x3a, 0x27, 0x00, 0xff,
    0x5e, 0x4f, 0x00, 0xff, 0x72, 0x61, 0x00, 0xff, 0x5e, 0x4f, 0x00, 0xff,
    0x8c, 0x39, 0x00, 0xff, 0x98, 0x45, 0x00, 0xff, 0xb8, 0x59, 0x00, 0xff,
    0xd8, 0x75, 0x00, 0xff, 0x92, 0x92, 0x00, 0xff, 0x5d, 0x5d, 0x00, 0xff,
    0x4b, 0x4b, 0x00, 0xff, 0x39, 0x39, 0x00, 0xff, 0x41, 0x4d, 0x00, 0xff,
    0x17, 0x29, 0x00, 0xff, 0x41, 0x4d, 0x00, 0xff, 0x20, 0x29, 0x00, 0xff,
    0x07, 0x19, 0x00, 0xff, 0x07, 0x19, 0x00, 0xff, 0x22, 0x29, 0x00, 0xff,
    0x16, 0x1f, 0x00, 0xff, 0x19, 0x1a, 0x00, 0xff, 0x10, 0x10, 0x00, 0xff,
    0x16, 0x14, 0x00, 0xff, 0x10, 0x10, 0x00, 0xff, 0x22, 0x32, 0x00, 0xff,
    0x12, 0x11, 0x00, 0xff, 0x22, 0x32, 0x00, 0xff, 0x12, 0x23, 0x00, 0xff,
    0x3d, 0x47, 0x00, 0xff, 0x31, 0x3b, 0x00, 0xff, 0x49, 0x4f, 0x00, 0xff,
    0x3d, 0x47, 0x00, 0xff, 0x4a, 0x39, 0x00, 0xff, 0x4a, 0x39, 0x00, 0xff,
    0x5e, 0x4f, 0x00, 0xff, 0x72, 0x61, 0x00, 0xff, 0xa0, 0x51, 0x00, 0xff,
    0x98, 0x45, 0x00, 0xff, 0xb8, 0x59, 0x00, 0xff, 0xd8, 0x75, 0x00, 0xff,
    0x92, 0x92, 0x00, 0xff, 0x5d, 0x5d, 0x00, 0xff, 0x39, 0x39, 0x00, 0xff,
    0x2d, 0x2d, 0x00, 0xff, 0x29, 0x3b, 0x00, 0xff, 0x05, 0x14, 0x00, 0xff,
    0x0e, 0x14, 0x00, 0xff, 0x32, 0x3b, 0x00, 0xff, 0x19, 0x29, 0x00, 0xff,
    0x07, 0x19, 0x00, 0xff, 0x00, 0x07, 0x00, 0xff, 0x16, 0x1f, 0x00, 0xff,
    0x0d, 0x1e, 0x00, 0xff, 0x0d, 0x1e, 0x00, 0xff, 0x0d, 0x1e, 0x00, 0xff,
    0x00, 0x08, 0x00, 0xff, 0x12, 0x23, 0x00, 0xff, 0x12, 0x23, 0x00, 0xff,
    0x12, 0x23, 0x00, 0xff, 0x22, 0x32, 0x00, 0xff, 0x3d, 0x1b, 0x00, 0xff,
    0x51, 0x2f, 0x00, 0xff, 0x51, 0x2f, 0x00, 0xff, 0x79, 0x5b, 0x00, 0xff,
    0x7e, 0x49, 0x00, 0xff, 0x7e, 0x49, 0x00, 0xff, 0x72, 0x3f, 0x00, 0xff,
    0x72, 0x3f, 0x00, 0xff, 0xac, 0x59, 0x00, 0xff, 0xac, 0x59, 0x00, 0xff,
    0xb8, 0x59, 0x00, 0xff, 0xd8, 0x75, 0x00, 0xff, 0x80, 0x80, 0x00, 0xff,
    0x5d, 0x5d, 0x00, 0xff, 0x39, 0x39, 0x00, 0xff, 0x39, 0x39, 0x00, 0xff,
    0x05, 0x14, 0x00, 0xff, 0x17, 0x29, 0x00, 0xff, 0x0e, 0x14, 0x00, 0xff,
    0x0e, 0x14, 0x00, 0xff, 0x19, 0x29, 0x00, 0xff, 0x07, 0x19, 0x00, 0xff,
    0x07, 0x13, 0x00, 0xff, 0x00, 0x07, 0x00, 0xff, 0x19, 0x2a, 0x00, 0xff,
    0x19, 0x2a, 0x00, 0xff, 0x00, 0x08, 0x00, 0xff, 0x19, 0x2a, 0x00, 0xff,
    0x12, 0x11, 0x00, 0xff, 0x12, 0x23, 0x00, 0xff, 0x12, 0x11, 0x00, 0xff,
    0x12, 0x11, 0x00, 0xff, 0x51, 0x2f, 0x00, 0xff, 0x3d, 0x1b, 0x00, 0xff,
    0x3d, 0x1b, 0x00, 0xff, 0x51, 0x2f, 0x00, 0xff, 0x72, 0x3f, 0x00, 0xff,
    0x7e, 0x49, 0x00, 0xff, 0x85, 0x55, 0x00, 0xff, 0x85, 0x55, 0x00, 0xff,
    0xa0, 0x51, 0x00, 0xff, 0xac, 0x59, 0x00, 0xff, 0xb8, 0x59, 0x00, 0xff,
    0xd8, 0x75, 0x00, 0xff, 0x75, 0x84, 0x00, 0xff, 0x51, 0x61, 0x00, 0xff,
    0x3f, 0x4f, 0x00, 0xff, 0x2d, 0x3d, 0x00, 0xff, 0x29, 0x32, 0x00, 0xff,
    0x07, 0x10, 0x00, 0xff, 0x13, 0x1c, 0x00, 0xff, 0x1d, 0x26, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x05, 0x0e, 0x00, 0xff, 0x05, 0x0e, 0x00, 0xff,
    0x11, 0x17, 0x00, 0xff, 0x12, 0x21, 0x00, 0xff, 0x12, 0x21, 0x00, 0xff,
    0x2a, 0x21, 0x00, 0xff, 0x12, 0x0b, 0x00, 0xff, 0x38, 0x1d, 0x00, 0xff,
    0x20, 0x07, 0x00, 0xff, 0x50, 0x1d, 0x00, 0xff, 0x50, 0x1d, 0x00, 0xff,
    0x56, 0x33, 0x00, 0xff, 0x76, 0x54, 0x00, 0xff, 0x87, 0x33, 0x00, 0xff,
    0x68, 0x12, 0x00, 0xff, 0x94, 0x00, 0x00, 0xff, 0x82, 0x1b, 0x00, 0xff,
    0xaf, 0x4b, 0x00, 0xff, 0xaf, 0x4b, 0x00, 0xff, 0xd2, 0x5b, 0x00, 0xff,
    0xd2, 0x3a, 0x00, 0xff, 0xd2, 0x5b, 0x00, 0xff, 0xe8, 0x71, 0x00, 0xff,
    0x63, 0x73, 0x00, 0xff, 0x63, 0x73, 0x00, 0xff, 0x3f, 0x4f, 0x00, 0xff,
    0x3f, 0x4f, 0x00, 0xff, 0x1d, 0x26, 0x00, 0xff, 0x29, 0x32, 0x00, 0xff,
    0x07, 0x10, 0x00, 0xff, 0x13, 0x1c, 0x00, 0xff, 0x11, 0x17, 0x00, 0xff,
    0x00, 0x05, 0x00, 0xff, 0x05, 0x0e, 0x00, 0xff, 0x11, 0x17, 0x00, 0xff,
    0x06, 0x15, 0x00, 0xff, 0x06, 0x15, 0x00, 0xff, 0x12, 0x0b, 0x00, 0xff,
    0x06, 0x00, 0x00, 0xff, 0x20, 0x07, 0x00, 0xff, 0x20, 0x07, 0x00, 0xff,
    0x38, 0x07, 0x00, 0xff, 0x5c, 0x29, 0x00, 0xff, 0x56, 0x33, 0x00, 0xff,
    0x87, 0x33, 0x00, 0xff, 0x76, 0x54, 0x00, 0xff, 0x87, 0x33, 0x00, 0xff,
    0x82, 0x1b, 0x00, 0xff, 0x94, 0x00, 0x00, 0xff, 0x82, 0x1b, 0x00, 0xff,
    0xaf, 0x4b, 0x00, 0xff, 0xd2, 0x3a, 0x00, 0xff, 0xd2, 0x3a, 0x00, 0xff,
    0xe8, 0x50, 0x00, 0xff, 0xe8, 0x71, 0x00, 0xff, 0x75, 0x84, 0x00, 0xff,
    0x51, 0x61, 0x00, 0xff, 0x51, 0x61, 0x00, 0xff, 0x2d, 0x3d, 0x00, 0xff,
    0x29, 0x32, 0x00, 0xff, 0x1d, 0x26, 0x00, 0xff, 0x29, 0x32, 0x00, 0xff,
    0x13, 0x1c, 0x00, 0xff, 0x29, 0x4a, 0x00, 0xff, 0x0e, 0x2f, 0x00, 0xff,
    0x00, 0x17, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x06, 0x15, 0x00, 0xff,
    0x00, 0x0b, 0x00, 0xff, 0x12, 0x0b, 0x00, 0xff, 0x12, 0x0b, 0x00, 0xff,
    0x20, 0x07, 0x00, 0xff, 0x2c, 0x13, 0x00, 0xff, 0x38, 0x07, 0x00, 0xff,
    0x50, 0x1d, 0x00, 0xff, 0x87, 0x33, 0x00, 0xff, 0x87, 0x33, 0x00, 0xff,
    0x87, 0x33, 0x00, 0xff, 0x87, 0x33, 0x00, 0xff, 0xaf, 0x4b, 0x00, 0xff,
    0xc1, 0x17, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff,
    0xd2, 0x5b, 0x00, 0xff, 0xd2, 0x3a, 0x00, 0xff, 0xe8, 0x50, 0x00, 0xff,
    0xe8, 0x71, 0x00, 0xff, 0x86, 0x96, 0x00, 0xff, 0x63, 0x73, 0x00, 0xff,
    0x2d, 0x3d, 0x00, 0xff, 0x2d, 0x3d, 0x00, 0xff, 0x1d, 0x26, 0x00, 0xff,
    0x13, 0x1c, 0x00, 0xff, 0x07, 0x10, 0x00, 0xff, 0x1d, 0x26, 0x00, 0xff,
    0x00, 0x17, 0x00, 0xff, 0x29, 0x4a, 0x00, 0xff, 0x00, 0x17, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x06, 0x15, 0x00, 0xff,
    0x2a, 0x21, 0x00, 0xff, 0x1e, 0x15, 0x00, 0xff, 0x44, 0x29, 0x00, 0xff,
    0x38, 0x1d, 0x00, 0xff, 0x5c, 0x29, 0x00, 0xff, 0x50, 0x1d, 0x00, 0xff,
    0x87, 0x33, 0x00, 0xff, 0x87, 0x33, 0x00, 0xff, 0x87, 0x33, 0x00, 0xff,
    0x87, 0x33, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff,
    0xc1, 0x17, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff, 0xd2, 0x3a, 0x00, 0xff,
    0xd2, 0x3a, 0x00, 0xff, 0xe8, 0x50, 0x00, 0xff, 0xe8, 0x71, 0x00, 0xff,
    0x7c, 0x9a, 0x00, 0xff, 0x6d, 0x88, 0x00, 0xff, 0x54, 0x5f, 0x00, 0xff,
    0x18, 0x2f, 0x00, 0xff, 0x21, 0x21, 0x00, 0xff, 0x0f, 0x0f, 0x00, 0xff,
    0x0f, 0x0f, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x05, 0x05, 0x00, 0xff, 0x09, 0x11, 0x00, 0xff, 0x09, 0x11, 0x00, 0xff,
    0x0f, 0x18, 0x00, 0xff, 0x0f, 0x18, 0x00, 0xff, 0x33, 0x24, 0x00, 0xff,
    0x3f, 0x2e, 0x00, 0xff, 0x45, 0x14, 0x00, 0xff, 0x6d, 0x3c, 0x00, 0xff,
    0x6d, 0x20, 0x00, 0xff, 0x8c, 0x42, 0x00, 0xff, 0x99, 0x33, 0x00, 0xff,
    0x99, 0x33, 0x00, 0xff, 0x99, 0x33, 0x00, 0xff, 0xbb, 0x11, 0x00, 0xff,
    0xc5, 0x06, 0x00, 0xff, 0xcb, 0x0c, 0x00, 0xff, 0xd5, 0x0f, 0x00, 0xff,
    0xe1, 0x14, 0x00, 0xff, 0xe7, 0x25, 0x00, 0xff, 0xe7, 0x41, 0x00, 0xff,
    0xe7, 0x59, 0x00, 0xff, 0xe7, 0x71, 0x00, 0xff, 0x7c, 0x9a, 0x00, 0xff,
    0x6d, 0x9a, 0x00, 0xff, 0x6d, 0x7d, 0x00, 0xff, 0x18, 0x2f, 0x00, 0xff,
    0x0f, 0x0f, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x09, 0x11, 0x00, 0xff, 0x09, 0x11, 0x00, 0xff, 0x27, 0x2e, 0x00, 0xff,
    0x27, 0x2e, 0x00, 0xff, 0x27, 0x18, 0x00, 0xff, 0x4b, 0x3a, 0x00, 0xff,
    0x59, 0x26, 0x00, 0xff, 0x45, 0x14, 0x00, 0xff, 0x8c, 0x42, 0x00, 0xff,
    0x80, 0x36, 0x00, 0xff, 0x99, 0x33, 0x00, 0xff, 0xa3, 0x3f, 0x00, 0xff,
    0x8d, 0x29, 0x00, 0xff, 0xbb, 0x11, 0x00, 0xff, 0xc5, 0x06, 0x00, 0xff,
    0xcf, 0x09, 0x00, 0xff, 0xdb, 0x0f, 0x00, 0xff, 0xe5, 0x12, 0x00, 0xff,
    0xe9, 0x25, 0x00, 0xff, 0xe9, 0x3d, 0x00, 0xff, 0xe9, 0x59, 0x00, 0xff,
    0xe9, 0x71, 0x00, 0xff, 0x8a, 0xac, 0x00, 0xff, 0x6d, 0x88, 0x00, 0xff,
    0x6d, 0x7d, 0x00, 0xff, 0x36, 0x41, 0x00, 0xff, 0x0f, 0x0f, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x05, 0x05, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x09, 0x11, 0x00, 0xff, 0x27, 0x2e, 0x00, 0xff, 0x33, 0x3a, 0x00, 0xff,
    0x3f, 0x2e, 0x00, 0xff, 0x4b, 0x3a, 0x00, 0xff, 0x6d, 0x3c, 0x00, 0xff,
    0x6d, 0x3c, 0x00, 0xff, 0x75, 0x2c, 0x00, 0xff, 0x8c, 0x42, 0x00, 0xff,
    0x99, 0x33, 0x00, 0xff, 0x99, 0x33, 0x00, 0xff, 0xa3, 0x3f, 0x00, 0xff,
    0xbb, 0x11, 0x00, 0xff, 0xcb, 0x03, 0x00, 0xff, 0xd5, 0x09, 0x00, 0xff,
    0xe1, 0x0c, 0x00, 0xff, 0xeb, 0x12, 0x00, 0xff, 0xeb, 0x25, 0x00, 0xff,
    0xeb, 0x3d, 0x00, 0xff, 0xeb, 0x59, 0x00, 0xff, 0xeb, 0x71, 0x00, 0xff,
    0x8a, 0xac, 0x00, 0xff, 0x6d, 0x9a, 0x00, 0xff, 0x6d, 0x7d, 0x00, 0xff,
    0x6d, 0x7d, 0x00, 0xff, 0x36, 0x36, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x11, 0x11, 0x00, 0xff,
    0x05, 0x05, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x09, 0x11, 0x00, 0xff,
    0x27, 0x2e, 0x00, 0xff, 0x33, 0x3a, 0x00, 0xff, 0x4b, 0x3a, 0x00, 0xff,
    0x4b, 0x3a, 0x00, 0xff, 0x6d, 0x3c, 0x00, 0xff, 0x80, 0x4e, 0x00, 0xff,
    0x8c, 0x42, 0x00, 0xff, 0x80, 0x36, 0x00, 0xff, 0xa3, 0x3f, 0x00, 0xff,
    0xa3, 0x3f, 0x00, 0xff, 0x99, 0x33, 0x00, 0xff, 0xbb, 0x11, 0x00, 0xff,
    0xcf, 0x03, 0x00, 0xff, 0xdb, 0x06, 0x00, 0xff, 0xe1, 0x0c, 0x00, 0xff,
    0xeb, 0x0f, 0x00, 0xff, 0xed, 0x25, 0x00, 0xff, 0xed, 0x3d, 0x00, 0xff,
    0xed, 0x55, 0x00, 0xff, 0xed, 0x71, 0x00, 0xff, 0x7d, 0x94, 0x00, 0xff,
    0x7d, 0x94, 0x00, 0xff, 0x5d, 0x77, 0x00, 0xff, 0x5d, 0x77, 0x00, 0xff,
    0x5d, 0x6f, 0x00, 0xff, 0x26, 0x38, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x08, 0x00, 0x00, 0xff, 0x13, 0x13, 0x00, 0xff, 0x13, 0x13, 0x00, 0xff,
    0x13, 0x13, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff, 0x3e, 0x1d, 0x00, 0xff,
    0x56, 0x33, 0x00, 0xff, 0x6c, 0x4b, 0x00, 0xff, 0x6c, 0x4b, 0x00, 0xff,
    0x6a, 0x40, 0x00, 0xff, 0x81, 0x58, 0x00, 0xff, 0x8d, 0x64, 0x00, 0xff,
    0x81, 0x58, 0x00, 0xff, 0x9f, 0x18, 0x00, 0xff, 0xb4, 0x2d, 0x00, 0xff,
    0xb4, 0x2d, 0x00, 0xff, 0xd2, 0x06, 0x00, 0xff, 0xd6, 0x00, 0x00, 0xff,
    0xe0, 0x00, 0x00, 0xff, 0xe9, 0x0a, 0x00, 0xff, 0xef, 0x10, 0x00, 0xff,
    0xe8, 0x1d, 0x00, 0xff, 0xea, 0x3e, 0x00, 0xff, 0xec, 0x5f, 0x00, 0xff,
    0xf0, 0x80, 0x00, 0xff, 0x7d, 0x94, 0x00, 0xff, 0x5d, 0x77, 0x00, 0xff,
    0x5d, 0x77, 0x00, 0xff, 0x49, 0x65, 0x00, 0xff, 0x3f, 0x56, 0x00, 0xff,
    0x26, 0x38, 0x00, 0xff, 0x1c, 0x0b, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff,
    0x13, 0x13, 0x00, 0xff, 0x13, 0x13, 0x00, 0xff, 0x33, 0x33, 0x00, 0xff,
    0x13, 0x13, 0x00, 0xff, 0x3e, 0x1d, 0x00, 0xff, 0x56, 0x33, 0x00, 0xff,
    0x56, 0x33, 0x00, 0xff, 0x6c, 0x4b, 0x00, 0xff, 0x76, 0x4c, 0x00, 0xff,
    0x6a, 0x40, 0x00, 0xff, 0x81, 0x58, 0x00, 0xff, 0x8d, 0x64, 0x00, 0xff,
    0xb4, 0x2d, 0x00, 0xff, 0x9f, 0x18, 0x00, 0xff, 0xd2, 0x06, 0x00, 0xff,
    0xd2, 0x06, 0x00, 0xff, 0xd6, 0x00, 0x00, 0xff, 0xec, 0x05, 0x00, 0xff,
    0xe9, 0x0a, 0x00, 0xff, 0xef, 0x10, 0x00, 0xff, 0xe8, 0x1d, 0x00, 0xff,
    0xea, 0x3e, 0x00, 0xff, 0xee, 0x5f, 0x00, 0xff, 0xf0, 0x80, 0x00, 0xff,
    0x71, 0x65, 0x00, 0xff, 0x5d, 0x53, 0x00, 0xff, 0x49, 0x41, 0x00, 0xff,
    0x35, 0x2f, 0x00, 0xff, 0x26, 0x38, 0x00, 0xff, 0x26, 0x38, 0x00, 0xff,
    0x3f, 0x29, 0x00, 0xff, 0x08, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff,
    0x33, 0x33, 0x00, 0xff, 0x33, 0x33, 0x00, 0xff, 0x33, 0x33, 0x00, 0xff,
    0x56, 0x33, 0x00, 0xff, 0x56, 0x33, 0x00, 0xff, 0x78, 0x33, 0x00, 0xff,
    0x78, 0x33, 0x00, 0xff, 0x8d, 0x34, 0x00, 0xff, 0x8d, 0x34, 0x00, 0xff,
    0x8d, 0x34, 0x00, 0xff, 0xa5, 0x4c, 0x00, 0xff, 0xb4, 0x2d, 0x00, 0xff,
    0xb4, 0x2d, 0x00, 0xff, 0xd2, 0x06, 0x00, 0xff, 0xd2, 0x06, 0x00, 0xff,
    0xe0, 0x00, 0x00, 0xff, 0xec, 0x05, 0x00, 0xff, 0xe5, 0x07, 0x00, 0xff,
    0xef, 0x10, 0x00, 0xff, 0xe8, 0x1d, 0x00, 0xff, 0xec, 0x3e, 0x00, 0xff,
    0xee, 0x5f, 0x00, 0xff, 0xf2, 0x80, 0x00, 0xff, 0x71, 0x65, 0x00, 0xff,
    0x5d, 0x53, 0x00, 0xff, 0x49, 0x41, 0x00, 0xff, 0x35, 0x2f, 0x00, 0xff,
    0x08, 0x1a, 0x00, 0xff, 0x26, 0x38, 0x00, 0xff, 0x3f, 0x29, 0x00, 0xff,
    0x1c, 0x0b, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff, 0x33, 0x00, 0x00, 0xff,
    0x33, 0x33, 0x00, 0xff, 0x53, 0x53, 0x00, 0xff, 0x56, 0x33, 0x00, 0xff,
    0x6c, 0x4b, 0x00, 0xff, 0x78, 0x33, 0x00, 0xff, 0x78, 0x33, 0x00, 0xff,
    0x81, 0x28, 0x00, 0xff, 0x99, 0x40, 0x00, 0xff, 0x99, 0x40, 0x00, 0xff,
    0x8d, 0x34, 0x00, 0xff, 0xb4, 0x2d, 0x00, 0xff, 0xb4, 0x2d, 0x00, 0xff,
    0xd2, 0x06, 0x00, 0xff, 0xd2, 0x06, 0x00, 0xff, 0xe0, 0x00, 0x00, 0xff,
    0xec, 0x05, 0x00, 0xff, 0xe5, 0x07, 0x00, 0xff, 0xe9, 0x0a, 0x00, 0xff,
    0xea, 0x1d, 0x00, 0xff, 0xec, 0x3e, 0x00, 0xff, 0xf0, 0x5f, 0x00, 0xff,
    0xf2, 0x80, 0x00, 0xff, 0x7c, 0x75, 0x00, 0xff, 0x58, 0x4b, 0x00, 0xff,
    0x61, 0x4b, 0x00, 0xff, 0x4f, 0x36, 0x00, 0xff, 0x45, 0x32, 0x00, 0xff,
    0x33, 0x23, 0x00, 0xff, 0x45, 0x32, 0x00, 0xff, 0x45, 0x32, 0x00, 0xff,
    0x56, 0x22, 0x00, 0xff, 0x68, 0x00, 0x00, 0xff, 0x56, 0x22, 0x00, 0xff,
    0x76, 0x43, 0x00, 0xff, 0x8d, 0x4b, 0x00, 0xff, 0x66, 0x27, 0x00, 0xff,
    0x8d, 0x4b, 0x00, 0xff, 0x7a, 0x39, 0x00, 0xff, 0x9f, 0x28, 0x00, 0xff,
    0x9f, 0x28, 0x00, 0xff, 0x9f, 0x28, 0x00, 0xff, 0xb5, 0x0b, 0x00, 0xff,
    0xc2, 0x00, 0x00, 0xff, 0xe8, 0x11, 0x00, 0xff, 0xde, 0x00, 0x00, 0xff,
    0xe8, 0x02, 0x00, 0xff, 0xea, 0x00, 0x00, 0xff, 0xec, 0x05, 0x00, 0xff,
    0xec, 0x0a, 0x00, 0xff, 0xee, 0x10, 0x00, 0xff, 0xeb, 0x1c, 0x00, 0xff,
    0xec, 0x3a, 0x00, 0xff, 0xed, 0x5d, 0x00, 0xff, 0xee, 0x7b, 0x00, 0xff,
    0x90, 0x89, 0x00, 0xff, 0x58, 0x4b, 0x00, 0xff, 0x4f, 0x36, 0x00, 0xff,
    0x4f, 0x36, 0x00, 0xff, 0x45, 0x32, 0x00, 0xff, 0x33, 0x23, 0x00, 0xff,
    0x33, 0x23, 0x00, 0xff, 0x54, 0x44, 0x00, 0xff, 0x76, 0x43, 0x00, 0xff,
    0x87, 0x10, 0x00, 0xff, 0x87, 0x10, 0x00, 0xff, 0x76, 0x43, 0x00, 0xff,
    0x8d, 0x4b, 0x00, 0xff, 0x8d, 0x4b, 0x00, 0xff, 0x7a, 0x39, 0x00, 0xff,
    0x8d, 0x4b, 0x00, 0xff, 0x9f, 0x28, 0x00, 0xff, 0x9f, 0x28, 0x00, 0xff,
    0xb5, 0x0b, 0x00, 0xff, 0xb5, 0x0b, 0x00, 0xff, 0xc2, 0x00, 0x00, 0xff,
    0xd4, 0x00, 0x00, 0xff, 0xe4, 0x00, 0x00, 0xff, 0xe4, 0x00, 0x00, 0xff,
    0xe8, 0x01, 0x00, 0xff, 0xea, 0x07, 0x00, 0xff, 0xea, 0x0c, 0x00, 0xff,
    0xec, 0x10, 0x00, 0xff, 0xeb, 0x1c, 0x00, 0xff, 0xec, 0x3a, 0x00, 0xff,
    0xed, 0x5d, 0x00, 0xff, 0xee, 0x7b, 0x00, 0xff, 0x90, 0x89, 0x00, 0xff,
    0x6d, 0x60, 0x00, 0xff, 0x4f, 0x36, 0x00, 0xff, 0x61, 0x4b, 0x00, 0xff,
    0x54, 0x44, 0x00, 0xff, 0x54, 0x44, 0x00, 0xff, 0x66, 0x11, 0x00, 0xff,
    0x54, 0x44, 0x00, 0xff, 0x76, 0x43, 0x00, 0xff, 0x76, 0x43, 0x00, 0xff,
    0x87, 0x10, 0x00, 0xff, 0x87, 0x10, 0x00, 0xff, 0xad, 0x30, 0x00, 0xff,
    0xad, 0x30, 0x00, 0xff, 0x95, 0x1e, 0x00, 0xff, 0xa1, 0x27, 0x00, 0xff,
    0x9f, 0x28, 0x00, 0xff, 0x9f, 0x28, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff,
    0xb5, 0x0b, 0x00, 0xff, 0xd4, 0x00, 0x00, 0xff, 0xd4, 0x00, 0x00, 0xff,
    0xe4, 0x00, 0x00, 0xff, 0xe4, 0x00, 0x00, 0xff, 0xe6, 0x01, 0x00, 0xff,
    0xe8, 0x07, 0x00, 0xff, 0xe8, 0x0c, 0x00, 0xff, 0xea, 0x10, 0x00, 0xff,
    0xeb, 0x1c, 0x00, 0xff, 0xec, 0x3a, 0x00, 0xff, 0xed, 0x5d, 0x00, 0xff,
    0xee, 0x7b, 0x00, 0xff, 0x90, 0x89, 0x00, 0xff, 0x7c, 0x75, 0x00, 0xff,
    0x61, 0x4b, 0x00, 0xff, 0x61, 0x4b, 0x00, 0xff, 0x54, 0x44, 0x00, 0xff,
    0x54, 0x44, 0x00, 0xff, 0x66, 0x11, 0x00, 0xff, 0x66, 0x11, 0x00, 0xff,
    0x76, 0x43, 0x00, 0xff, 0x76, 0x43, 0x00, 0xff, 0x87, 0x10, 0x00, 0xff,
    0x87, 0x10, 0x00, 0xff, 0x8d, 0x0f, 0x00, 0xff, 0xa1, 0x27, 0x00, 0xff,
    0xa1, 0x27, 0x00, 0xff, 0x8d, 0x0f, 0x00, 0xff, 0xb5, 0x0b, 0x00, 0xff,
    0xc1, 0x17, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff, 0xc1, 0x17, 0x00, 0xff,
    0xd4, 0x00, 0x00, 0xff, 0xd4, 0x00, 0x00, 0xff, 0xde, 0x00, 0x00, 0xff,
    0xde, 0x00, 0x00, 0xff, 0xe4, 0x01, 0x00, 0xff, 0xe6, 0x07, 0x00, 0xff,
    0xe6, 0x0c, 0x00, 0xff, 0xe8, 0x12, 0x00, 0xff, 0xeb, 0x1c, 0x00, 0xff,
    0xec, 0x3a, 0x00, 0xff, 0xed, 0x58, 0x00, 0xff, 0xee, 0x7b, 0x00, 0xff,
    0x9d, 0x83, 0x00, 0xff, 0x9d, 0x83, 0x00, 0xff, 0x8e, 0x57, 0x00, 0xff,
    0x74, 0x39, 0x00, 0xff, 0x74, 0x3f, 0x00, 0xff, 0x74, 0x33, 0x00, 0xff,
    0x7d, 0x27, 0x00, 0xff, 0x7d, 0x1d, 0x00, 0xff, 0x82, 0x1c, 0x00, 0xff,
    0x8e, 0x28, 0x00, 0xff, 0x8e, 0x28, 0x00, 0xff, 0xa4, 0x1c, 0x00, 0xff,
    0xb2, 0x0e, 0x00, 0xff, 0xac, 0x08, 0x00, 0xff, 0xbc, 0x18, 0x00, 0xff,
    0xb8, 0x12, 0x00, 0xff, 0xbf, 0x00, 0x00, 0xff, 0xc9, 0x03, 0x00, 0xff,
    0xd5, 0x00, 0x00, 0xff, 0xd5, 0x00, 0x00, 0xff, 0xda, 0x00, 0x00, 0xff,
    0xdc, 0x01, 0x00, 0xff, 0xde, 0x03, 0x00, 0xff, 0xe0, 0x03, 0x00, 0xff,
    0xe3, 0x02, 0x00, 0xff, 0xe5, 0x08, 0x00, 0xff, 0xe7, 0x0e, 0x00, 0xff,
    0xe9, 0x16, 0x00, 0xff, 0xeb, 0x2b, 0x00, 0xff, 0xed, 0x49, 0x00, 0xff,
    0xef, 0x6d, 0x00, 0xff, 0xef, 0x8a, 0x00, 0xff, 0x9d, 0x83, 0x00, 0xff,
    0xa3, 0x8d, 0x00, 0xff, 0xa9, 0x70, 0x00, 0xff, 0x8e, 0x57, 0x00, 0xff,
    0x85, 0x3f, 0x00, 0xff, 0x85, 0x33, 0x00, 0xff, 0x8b, 0x27, 0x00, 0xff,
    0x8b, 0x1d, 0x00, 0xff, 0xa4, 0x1c, 0x00, 0xff, 0xa4, 0x1c, 0x00, 0xff,
    0xb0, 0x28, 0x00, 0xff, 0xa4, 0x1c, 0x00, 0xff, 0xac, 0x08, 0x00, 0xff,
    0xbc, 0x18, 0x00, 0xff, 0xbc, 0x18, 0x00, 0xff, 0xb2, 0x0e, 0x00, 0xff,
    0xc9, 0x03, 0x00, 0xff, 0xc9, 0x03, 0x00, 0xff, 0xd5, 0x00, 0x00, 0xff,
    0xdb, 0x07, 0x00, 0xff, 0xdc, 0x06, 0x00, 0xff, 0xde, 0x06, 0x00, 0xff,
    0xe0, 0x06, 0x00, 0xff, 0xe2, 0x09, 0x00, 0xff, 0xe1, 0x02, 0x00, 0xff,
    0xe3, 0x0b, 0x00, 0xff, 0xe5, 0x13, 0x00, 0xff, 0xe7, 0x19, 0x00, 0xff,
    0xe9, 0x2b, 0x00, 0xff, 0xeb, 0x49, 0x00, 0xff, 0xed, 0x6d, 0x00, 0xff,
    0xef, 0x8a, 0x00, 0xff, 0xa3, 0x8d, 0x00, 0xff, 0x94, 0x7a, 0x00, 0xff,
    0xa9, 0x70, 0x00, 0xff, 0x8e, 0x57, 0x00, 0xff, 0x9a, 0x43, 0x00, 0xff,
    0x9a, 0x39, 0x00, 0xff, 0xa0, 0x2d, 0x00, 0xff, 0xa0, 0x21, 0x00, 0xff,
    0xa4, 0x1c, 0x00, 0xff, 0xa4, 0x1c, 0x00, 0xff, 0xb0, 0x28, 0x00, 0xff,
    0xb0, 0x28, 0x00, 0xff, 0xca, 0x0e, 0x00, 0xff, 0xca, 0x0e, 0x00, 0xff,
    0xca, 0x0e, 0x00, 0xff, 0xd0, 0x12, 0x00, 0xff, 0xd5, 0x0d, 0x00, 0xff,
    0xd5, 0x0d, 0x00, 0xff, 0xe5, 0x11, 0x00, 0xff, 0xdb, 0x07, 0x00, 0xff,
    0xdc, 0x09, 0x00, 0xff, 0xde, 0x09, 0x00, 0xff, 0xe0, 0x0c, 0x00, 0xff,
    0xe2, 0x0c, 0x00, 0xff, 0xe1, 0x08, 0x00, 0xff, 0xe3, 0x0e, 0x00, 0xff,
    0xe5, 0x16, 0x00, 0xff, 0xe7, 0x1f, 0x00, 0xff, 0xe7, 0x3d, 0x00, 0xff,
    0xe9, 0x5b, 0x00, 0xff, 0xeb, 0x7f, 0x00, 0xff, 0xed, 0x9c, 0x00, 0xff,
    0xa3, 0x8d, 0x00, 0xff, 0x94, 0x7a, 0x00, 0xff, 0xa9, 0x70, 0x00, 0xff,
    0x8e, 0x57, 0x00, 0xff, 0xa9, 0x43, 0x00, 0xff, 0xa9, 0x39, 0x00, 0xff,
    0xb2, 0x2d, 0x00, 0xff, 0xb2, 0x21, 0x00, 0xff, 0xa4, 0x1c, 0x00, 0xff,
    0xb0, 0x28, 0x00, 0xff, 0xb0, 0x28, 0x00, 0xff, 0xb0, 0x28, 0x00, 0xff,
    0xd6, 0x18, 0x00, 0xff, 0xd0, 0x12, 0x00, 0xff, 0xd6, 0x18, 0x00, 0xff,
    0xd6, 0x18, 0x00, 0xff, 0xdf, 0x19, 0x00, 0xff, 0xdf, 0x19, 0x00, 0xff,
    0xe5, 0x11, 0x00, 0xff, 0xe5, 0x11, 0x00, 0xff, 0xde, 0x0e, 0x00, 0xff,
    0xe0, 0x0e, 0x00, 0xff, 0xe2, 0x11, 0x00, 0xff, 0xe4, 0x11, 0x00, 0xff,
    0xdf, 0x0b, 0x00, 0xff, 0xe1, 0x13, 0x00, 0xff, 0xe3, 0x19, 0x00, 0xff,
    0xe5, 0x1f, 0x00, 0xff, 0xe5, 0x49, 0x00, 0xff, 0xe7, 0x6d, 0x00, 0xff,
    0xe9, 0x8a, 0x00, 0xff, 0xeb, 0x9c, 0x00, 0xff, 0xd3, 0x8c, 0x00, 0xff,
    0xc4, 0x7b, 0x00, 0xff, 0xbb, 0x57, 0x00, 0xff, 0xbb, 0x57, 0x00, 0xff,
    0xcd, 0x49, 0x00, 0xff, 0xcd, 0x49, 0x00, 0xff, 0xb8, 0x35, 0x00, 0xff,
    0xb8, 0x35, 0x00, 0xff, 0xcb, 0x2a, 0x00, 0xff, 0xcb, 0x2a, 0x00, 0xff,
    0xcb, 0x2a, 0x00, 0xff, 0xcb, 0x2a, 0x00, 0xff, 0xd8, 0x1f, 0x00, 0xff,
    0xd8, 0x1f, 0x00, 0xff, 0xdd, 0x1f, 0x00, 0xff, 0xe0, 0x1f, 0x00, 0xff,
    0xe7, 0x27, 0x00, 0xff, 0xe7, 0x1b, 0x00, 0xff, 0xe7, 0x1b, 0x00, 0xff,
    0xe7, 0x1b, 0x00, 0xff, 0xe3, 0x1d, 0x00, 0xff, 0xe3, 0x1d, 0x00, 0xff,
    0xe3, 0x1d, 0x00, 0xff, 0xe3, 0x1d, 0x00, 0xff, 0xde, 0x1b, 0x00, 0xff,
    0xe0, 0x2a, 0x00, 0xff, 0xe0, 0x2a, 0x00, 0xff, 0xe3, 0x34, 0x00, 0xff,
    0xe4, 0x51, 0x00, 0xff, 0xe4, 0x69, 0x00, 0xff, 0xe4, 0x80, 0x00, 0xff,
    0xe6, 0x94, 0x00, 0xff, 0xe8, 0x9e, 0x00, 0xff, 0xd3, 0x8c, 0x00, 0xff,
    0xcd, 0x69, 0x00, 0xff, 0xbb, 0x57, 0x00, 0xff, 0xcd, 0x49, 0x00, 0xff,
    0xcd, 0x49, 0x00, 0xff, 0xcd, 0x49, 0x00, 0xff, 0xcd, 0x49, 0x00, 0xff,
    0xd8, 0x46, 0x00, 0xff, 0xd8, 0x46, 0x00, 0xff, 0xd8, 0x42, 0x00, 0xff,
    0xd8, 0x42, 0x00, 0xff, 0xdd, 0x3b, 0x00, 0xff, 0xe0, 0x3b, 0x00, 0xff,
    0xe3, 0x3b, 0x00, 0xff, 0xe6, 0x3b, 0x00, 0xff, 0xe9, 0x3b, 0x00, 0xff,
    0xe9, 0x3b, 0x00, 0xff, 0xe9, 0x3b, 0x00, 0xff, 0xe9, 0x33, 0x00, 0xff,
    0xe7, 0x37, 0x00, 0xff, 0xe7, 0x37, 0x00, 0xff, 0xe7, 0x37, 0x00, 0xff,
    0xe7, 0x37, 0x00, 0xff, 0xe3, 0x34, 0x00, 0xff, 0xe3, 0x43, 0x00, 0xff,
    0xe6, 0x43, 0x00, 0xff, 0xe6, 0x52, 0x00, 0xff, 0xe6, 0x69, 0x00, 0xff,
    0xe6, 0x75, 0x00, 0xff, 0xe8, 0x94, 0x00, 0xff, 0xe8, 0xa0, 0x00, 0xff,
    0xfa, 0xb0, 0x00, 0xff, 0xe8, 0x9e, 0x00, 0xff, 0xe2, 0x7b, 0x00, 0xff,
    0xcd, 0x69, 0x00, 0xff, 0xe2, 0x65, 0x00, 0xff, 0xe2, 0x65, 0x00, 0xff,
    0xe2, 0x65, 0x00, 0xff, 0xe2, 0x65, 0x00, 0xff, 0xe5, 0x5e, 0x00, 0xff,
    0xe5, 0x5e, 0x00, 0xff, 0xe5, 0x5a, 0x00, 0xff, 0xe5, 0x5a, 0x00, 0xff,
    0xe3, 0x57, 0x00, 0xff, 0xe6, 0x57, 0x00, 0xff, 0xe9, 0x57, 0x00, 0xff,
    0xec, 0x57, 0x00, 0xff, 0xeb, 0x57, 0x00, 0xff, 0xeb, 0x57, 0x00, 0xff,
    0xeb, 0x57, 0x00, 0xff, 0xeb, 0x4f, 0x00, 0xff, 0xeb, 0x51, 0x00, 0xff,
    0xeb, 0x51, 0x00, 0xff, 0xeb, 0x51, 0x00, 0xff, 0xeb, 0x51, 0x00, 0xff,
    0xe6, 0x52, 0x00, 0xff, 0xe9, 0x52, 0x00, 0xff, 0xe9, 0x61, 0x00, 0xff,
    0xe9, 0x6b, 0x00, 0xff, 0xe8, 0x75, 0x00, 0xff, 0xea, 0x80, 0x00, 0xff,
    0xea, 0xa0, 0x00, 0xff, 0xec, 0xac, 0x00, 0xff, 0xfa, 0xb0, 0x00, 0xff,
    0xfa, 0xb0, 0x00, 0xff, 0xf1, 0x8c, 0x00, 0xff, 0xf1, 0x8c, 0x00, 0xff,
    0xf7, 0x7d, 0x00, 0xff, 0xf7, 0x7d, 0x00, 0xff, 0xf7, 0x7d, 0x00, 0xff,
    0xf7, 0x7d, 0x00, 0xff, 0xf2, 0x76, 0x00, 0xff, 0xf2, 0x76, 0x00, 0xff,
    0xf2, 0x76, 0x00, 0xff, 0xf2, 0x76, 0x00, 0xff, 0xe9, 0x73, 0x00, 0xff,
    0xec, 0x73, 0x00, 0xff, 0xf1, 0x73, 0x00, 0xff, 0xf1, 0x73, 0x00, 0xff,
    0xed, 0x6f, 0x00, 0xff, 0xed, 0x6f, 0x00, 0xff, 0xed, 0x6f, 0x00, 0xff,
    0xed, 0x6f, 0x00, 0xff, 0xef, 0x6b, 0x00, 0xff, 0xef, 0x6b, 0x00, 0xff,
    0xef, 0x6b, 0x00, 0xff, 0xef, 0x6b, 0x00, 0xff, 0xeb, 0x6b, 0x00, 0xff,
    0xeb, 0x6b, 0x00, 0xff, 0xee, 0x7a, 0x00, 0xff, 0xee, 0x7a, 0x00, 0xff,
    0xec, 0x80, 0x00, 0xff, 0xec, 0x94, 0x00, 0xff, 0xee, 0xac, 0x00, 0xff,
    0xee, 0xc4, 0x00, 0xff,
  ]),
};

var img_32x32_rgb_etc2 = {
  compressed: new Uint8Array([
    0x8d, 0x9d, 0xb6, 0x4a, 0xc4, 0x80, 0x83, 0x97, 0x64, 0x74, 0x95, 0x4b,
    0xae, 0xa2, 0x91, 0x05, 0x74, 0x85, 0xa7, 0x25, 0xfa, 0xa6, 0xff, 0x42,
    0x64, 0x74, 0x85, 0x49, 0xae, 0xea, 0x89, 0xba, 0x64, 0x74, 0x7c, 0x4b,
    0xa8, 0x8a, 0xa4, 0x81, 0x73, 0x73, 0x85, 0x29, 0xab, 0xa3, 0x3e, 0x2a,
    0x75, 0x74, 0x86, 0x25, 0xaa, 0x6e, 0x71, 0x11, 0xbe, 0x7f, 0x04, 0x62,
    0xbb, 0x6c, 0x86, 0xcf,

    0x74, 0x74, 0x97, 0x48, 0xec, 0xf0, 0x50, 0xe6, 0x21, 0x30, 0x5f, 0x4a,
    0xbd, 0xe8, 0x8e, 0x5b, 0x10, 0x27, 0x3a, 0x46, 0x8c, 0xe2, 0x87, 0x10,
    0x1e, 0x18, 0x48, 0x07, 0x6b, 0x31, 0xe9, 0xa9, 0x05, 0x13, 0x23, 0x57,
    0x66, 0xd6, 0x34, 0xc4, 0x43, 0x4e, 0x5c, 0x2b, 0xbd, 0xee, 0x59, 0xb4,
    0x57, 0x44, 0x55, 0x45, 0x44, 0x2b, 0xa9, 0x01, 0x9a, 0x48, 0x41, 0x2e,
    0x00, 0x31, 0xf0, 0xc5,

    0x6c, 0x7c, 0x9e, 0x4a, 0xfb, 0xf2, 0xd8, 0x58, 0x18, 0x20, 0x4a, 0x27,
    0x6b, 0x90, 0x0e, 0x35, 0x00, 0x0b, 0x29, 0x2f, 0xcc, 0x29, 0xf0, 0x87,
    0x03, 0x10, 0x2f, 0x26, 0x76, 0x48, 0x29, 0x19, 0x33, 0x18, 0x40, 0x26,
    0x06, 0x76, 0x2e, 0x3e, 0xb9, 0x06, 0x32, 0x2b, 0x02, 0x13, 0x10, 0x03,
    0x49, 0x15, 0xd0, 0x06, 0xcc, 0xe9, 0x02, 0x33, 0x6a, 0x06, 0x6b, 0x33,
    0xf1, 0x05, 0x01, 0xff,

    0x74, 0x95, 0xa6, 0x2c, 0x70, 0xf0, 0xbe, 0x5c, 0x1d, 0x1d, 0x32, 0x4e,
    0xfe, 0xf6, 0x4c, 0xe8, 0x00, 0x01, 0x37, 0x2a, 0x0c, 0x63, 0x0c, 0x6b,
    0x23, 0x28, 0x43, 0x26, 0x03, 0x11, 0xea, 0xd1, 0x63, 0x30, 0x66, 0x46,
    0x05, 0x23, 0x5b, 0xa1, 0xf3, 0x12, 0x93, 0x46, 0x0b, 0x57, 0x06, 0xa8,
    0x60, 0x86, 0x04, 0xf6, 0x18, 0x46, 0x80, 0x00, 0x72, 0xa6, 0x0d, 0x73,
    0x8b, 0x2f, 0x64, 0x48,

    0x50, 0x6c, 0x85, 0x6b, 0xec, 0x00, 0xc0, 0x1f, 0x31, 0x40, 0x63, 0x6c,
    0x71, 0xfc, 0x2d, 0x09, 0x07, 0x01, 0x33, 0x6b, 0x6f, 0x73, 0xa1, 0x33,
    0xeb, 0x35, 0x53, 0x5a, 0x02, 0x7f, 0x31, 0x83, 0x7b, 0x55, 0x67, 0x27,
    0x84, 0x6f, 0x61, 0x29, 0x51, 0x05, 0x68, 0x8b, 0xfe, 0x00, 0xfe, 0x21,
    0xe0, 0x01, 0x09, 0x22, 0x0c, 0x1f, 0x70, 0x03, 0x72, 0x9e, 0x0c, 0x7a,
    0xa1, 0x2f, 0x43, 0x87,

    0x77, 0x6d, 0x8f, 0x4a, 0xff, 0x70, 0x36, 0x3e, 0x0e, 0x15, 0x43, 0x67,
    0x13, 0x33, 0x62, 0xfc, 0xb8, 0x04, 0xb1, 0xb3, 0x31, 0xcf, 0x01, 0x11,
    0x83, 0x44, 0x64, 0x47, 0x96, 0x18, 0x80, 0x5c, 0x58, 0x14, 0xc9, 0x1a,
    0x01, 0x77, 0x72, 0x08, 0xd9, 0x0f, 0x08, 0x42, 0xef, 0xef, 0x89, 0x03,
    0x74, 0x80, 0x04, 0xf7, 0x14, 0x3f, 0x00, 0x42, 0x74, 0x9c, 0x07, 0xf7,
    0x9b, 0x2f, 0x43, 0x47,

    0x98, 0x84, 0xa5, 0x0e, 0xf1, 0xd2, 0x10, 0xec, 0xb8, 0xbc, 0xfa, 0xc2,
    0x10, 0x85, 0xc8, 0xd2, 0x51, 0x05, 0x41, 0x2a, 0x01, 0x11, 0x30, 0x6f,
    0xb3, 0x10, 0x10, 0x03, 0x24, 0x57, 0x8b, 0x3a, 0xca, 0x08, 0x10, 0x22,
    0x73, 0x33, 0x9f, 0x89, 0x6c, 0x80, 0x05, 0x72, 0x04, 0x0e, 0xe2, 0x46,
    0x70, 0x80, 0x04, 0x76, 0x1c, 0x56, 0xe2, 0x03, 0x74, 0xa6, 0x0c, 0xfa,
    0xa5, 0x37, 0x0a, 0x50,

    0xdf, 0x94, 0x8d, 0x4a, 0x73, 0x31, 0xb9, 0x9c, 0xd2, 0x53, 0x53, 0x47,
    0x77, 0x77, 0x99, 0x88, 0x64, 0xae, 0x0d, 0xe6, 0x26, 0x5f, 0xf1, 0xe4,
    0x6a, 0xa0, 0x0c, 0xf2, 0x1e, 0x47, 0x71, 0xe3, 0x72, 0xa2, 0x0c, 0xf3,
    0x18, 0x4f, 0x71, 0xa0, 0x70, 0x9c, 0x0c, 0x72, 0x1c, 0x47, 0x90, 0xa2,
    0x6e, 0x9a, 0x0c, 0x72, 0x3c, 0x6f, 0x70, 0x61, 0x70, 0x54, 0x15, 0x73,
    0xa7, 0x3f, 0x72, 0x22,
  ]),
  decompressed: new Uint8Array([
    0xa9, 0xb9, 0xd2, 0xff, 0xa9, 0xb9, 0xd2, 0xff, 0x90, 0xa1, 0xc2, 0xff,
    0x7c, 0x8d, 0xae, 0xff, 0x80, 0x90, 0xb1, 0xff, 0x6c, 0x7c, 0x9d, 0xff,
    0x80, 0x90, 0xb1, 0xff, 0x80, 0x90, 0xb1, 0xff, 0x7c, 0x8d, 0xaf, 0xff,
    0x7c, 0x8d, 0xaf, 0xff, 0x88, 0x99, 0xbb, 0xff, 0x66, 0x77, 0x99, 0xff,
    0x6f, 0x80, 0x91, 0xff, 0x83, 0x94, 0xa5, 0xff, 0x83, 0x94, 0xa5, 0xff,
    0x6f, 0x80, 0x91, 0xff, 0x80, 0x90, 0x98, 0xff, 0x6c, 0x7c, 0x84, 0xff,
    0x6c, 0x7c, 0x84, 0xff, 0x6c, 0x7c, 0x84, 0xff, 0x72, 0x72, 0x83, 0xff,
    0x7c, 0x7c, 0x8d, 0xff, 0x72, 0x72, 0x83, 0xff, 0x88, 0x88, 0x99, 0xff,
    0x88, 0x88, 0x99, 0xff, 0x88, 0x88, 0x99, 0xff, 0x88, 0x88, 0x99, 0xff,
    0x88, 0x88, 0x99, 0xff, 0x7d, 0x7e, 0x82, 0xff, 0x8f, 0x8d, 0x8f, 0xff,
    0xa0, 0x9d, 0x9c, 0xff, 0xb2, 0xac, 0xa9, 0xff, 0xa9, 0xb9, 0xd2, 0xff,
    0x95, 0xa5, 0xbe, 0xff, 0x90, 0xa1, 0xc2, 0xff, 0x7c, 0x8d, 0xae, 0xff,
    0x5a, 0x6a, 0x8b, 0xff, 0x5a, 0x6a, 0x8b, 0xff, 0x5a, 0x6a, 0x8b, 0xff,
    0x5a, 0x6a, 0x8b, 0xff, 0x66, 0x77, 0x99, 0xff, 0x72, 0x83, 0xa5, 0xff,
    0x66, 0x77, 0x99, 0xff, 0x66, 0x77, 0x99, 0xff, 0x49, 0x5a, 0x6b, 0xff,
    0x49, 0x5a, 0x6b, 0xff, 0x5d, 0x6e, 0x7f, 0xff, 0x5d, 0x6e, 0x7f, 0xff,
    0x5a, 0x6a, 0x72, 0xff, 0x6c, 0x7c, 0x84, 0xff, 0x6c, 0x7c, 0x84, 0xff,
    0x46, 0x56, 0x5e, 0xff, 0x66, 0x66, 0x77, 0xff, 0x66, 0x66, 0x77, 0xff,
    0x66, 0x66, 0x77, 0xff, 0x66, 0x66, 0x77, 0xff, 0x72, 0x72, 0x83, 0xff,
    0x72, 0x72, 0x83, 0xff, 0x72, 0x72, 0x83, 0xff, 0x66, 0x66, 0x77, 0xff,
    0x82, 0x6c, 0x71, 0xff, 0x94, 0x7b, 0x7e, 0xff, 0xa5, 0x8b, 0x8b, 0xff,
    0xb7, 0x9a, 0x98, 0xff, 0xa9, 0xb9, 0xd2, 0xff, 0x95, 0xa5, 0xbe, 0xff,
    0x6a, 0x7b, 0x9c, 0xff, 0x6a, 0x7b, 0x9c, 0xff, 0x5f, 0x6f, 0x98, 0xff,
    0x4b, 0x5b, 0x84, 0xff, 0x39, 0x49, 0x72, 0xff, 0x4b, 0x5b, 0x84, 0xff,
    0x3f, 0x50, 0x72, 0xff, 0x55, 0x66, 0x88, 0xff, 0x55, 0x66, 0x88, 0xff,
    0x33, 0x44, 0x66, 0xff, 0x4d, 0x4d, 0x5e, 0xff, 0x3b, 0x3b, 0x4c, 0xff,
    0x3b, 0x3b, 0x4c, 0xff, 0x4d, 0x4d, 0x5e, 0xff, 0x4b, 0x5b, 0x63, 0xff,
    0x4b, 0x5b, 0x63, 0xff, 0x5f, 0x6f, 0x77, 0xff, 0x4b, 0x5b, 0x63, 0xff,
    0x3c, 0x3c, 0x5e, 0xff, 0x3c, 0x3c, 0x5e, 0xff, 0x50, 0x50, 0x72, 0xff,
    0x3c, 0x3c, 0x5e, 0xff, 0x50, 0x3f, 0x61, 0xff, 0x50, 0x3f, 0x61, 0xff,
    0x5a, 0x49, 0x6b, 0xff, 0x66, 0x55, 0x77, 0xff, 0x88, 0x5a, 0x5f, 0xff,
    0x99, 0x69, 0x6c, 0xff, 0xab, 0x79, 0x79, 0xff, 0xbc, 0x88, 0x86, 0xff,
    0x95, 0xa5, 0xbe, 0xff, 0x6f, 0x7f, 0x98, 0xff, 0x7c, 0x8d, 0xae, 0xff,
    0x56, 0x67, 0x88, 0xff, 0x4b, 0x5b, 0x84, 0xff, 0x39, 0x49, 0x72, 0xff,
    0x39, 0x49, 0x72, 0xff, 0x25, 0x35, 0x5e, 0xff, 0x49, 0x5a, 0x7c, 0xff,
    0x3f, 0x50, 0x72, 0xff, 0x33, 0x44, 0x66, 0xff, 0x33, 0x44, 0x66, 0xff,
    0x27, 0x27, 0x38, 0xff, 0x27, 0x27, 0x38, 0xff, 0x27, 0x27, 0x38, 0xff,
    0x27, 0x27, 0x38, 0xff, 0x39, 0x49, 0x51, 0xff, 0x25, 0x35, 0x3d, 0xff,
    0x39, 0x49, 0x51, 0xff, 0x25, 0x35, 0x3d, 0xff, 0x50, 0x50, 0x72, 0xff,
    0x2a, 0x2a, 0x4c, 0xff, 0x16, 0x16, 0x38, 0xff, 0x2a, 0x2a, 0x4c, 0xff,
    0x50, 0x3f, 0x61, 0xff, 0x5a, 0x49, 0x6b, 0xff, 0x50, 0x3f, 0x61, 0xff,
    0x50, 0x3f, 0x61, 0xff, 0x8d, 0x48, 0x4e, 0xff, 0x9e, 0x57, 0x5b, 0xff,
    0xb0, 0x67, 0x68, 0xff, 0xc1, 0x76, 0x75, 0xff, 0x80, 0x80, 0xa2, 0xff,
    0x6e, 0x6e, 0x90, 0xff, 0x4d, 0x4d, 0x80, 0xff, 0x61, 0x61, 0x94, 0xff,
    0x3e, 0x4e, 0x77, 0xff, 0x3e, 0x4e, 0x77, 0xff, 0x20, 0x28, 0x49, 0xff,
    0x20, 0x28, 0x49, 0xff, 0x19, 0x2a, 0x42, 0xff, 0x2d, 0x3e, 0x56, 0xff,
    0x21, 0x29, 0x5b, 0xff, 0x15, 0x1d, 0x4f, 0xff, 0x10, 0x10, 0x42, 0xff,
    0x16, 0x16, 0x48, 0xff, 0x10, 0x10, 0x42, 0xff, 0x1a, 0x1a, 0x4c, 0xff,
    0x11, 0x11, 0x33, 0xff, 0x22, 0x33, 0x55, 0xff, 0x11, 0x11, 0x33, 0xff,
    0x32, 0x43, 0x65, 0xff, 0x47, 0x4f, 0x5f, 0xff, 0x53, 0x5b, 0x6b, 0xff,
    0x31, 0x39, 0x49, 0xff, 0x31, 0x39, 0x49, 0xff, 0x38, 0x27, 0x38, 0xff,
    0x5e, 0x4d, 0x5e, 0xff, 0x72, 0x61, 0x72, 0xff, 0x5e, 0x4d, 0x5e, 0xff,
    0x8b, 0x39, 0x31, 0xff, 0x97, 0x45, 0x3d, 0xff, 0xba, 0x57, 0x57, 0xff,
    0xd7, 0x74, 0x74, 0xff, 0x94, 0x94, 0xb6, 0xff, 0x5a, 0x5a, 0x7c, 0xff,
    0x4d, 0x4d, 0x80, 0xff, 0x3b, 0x3b, 0x6e, 0xff, 0x3e, 0x4e, 0x77, 0xff,
    0x18, 0x28, 0x51, 0xff, 0x46, 0x4e, 0x6f, 0xff, 0x20, 0x28, 0x49, 0xff,
    0x07, 0x18, 0x30, 0xff, 0x07, 0x18, 0x30, 0xff, 0x21, 0x29, 0x5b, 0xff,
    0x15, 0x1d, 0x4f, 0xff, 0x1a, 0x1a, 0x4c, 0xff, 0x10, 0x10, 0x42, 0xff,
    0x16, 0x16, 0x48, 0xff, 0x10, 0x10, 0x42, 0xff, 0x22, 0x33, 0x55, 0xff,
    0x11, 0x11, 0x33, 0xff, 0x22, 0x33, 0x55, 0xff, 0x12, 0x23, 0x45, 0xff,
    0x3d, 0x45, 0x55, 0xff, 0x31, 0x39, 0x49, 0xff, 0x47, 0x4f, 0x5f, 0xff,
    0x3d, 0x45, 0x55, 0xff, 0x4c, 0x3b, 0x4c, 0xff, 0x4c, 0x3b, 0x4c, 0xff,
    0x5e, 0x4d, 0x5e, 0xff, 0x72, 0x61, 0x72, 0xff, 0xa1, 0x4f, 0x47, 0xff,
    0x97, 0x45, 0x3d, 0xff, 0xba, 0x57, 0x57, 0xff, 0xd7, 0x74, 0x74, 0xff,
    0x94, 0x94, 0xb6, 0xff, 0x5a, 0x5a, 0x7c, 0xff, 0x3b, 0x3b, 0x6e, 0xff,
    0x27, 0x27, 0x5a, 0xff, 0x2a, 0x3a, 0x63, 0xff, 0x04, 0x14, 0x3d, 0xff,
    0x0c, 0x14, 0x35, 0xff, 0x32, 0x3a, 0x5b, 0xff, 0x19, 0x2a, 0x42, 0xff,
    0x07, 0x18, 0x30, 0xff, 0x00, 0x07, 0x39, 0xff, 0x15, 0x1d, 0x4f, 0xff,
    0x0d, 0x1d, 0x4f, 0xff, 0x0d, 0x1d, 0x4f, 0xff, 0x0d, 0x1d, 0x4f, 0xff,
    0x00, 0x07, 0x39, 0xff, 0x12, 0x23, 0x45, 0xff, 0x12, 0x23, 0x45, 0xff,
    0x12, 0x23, 0x45, 0xff, 0x22, 0x33, 0x55, 0xff, 0x3d, 0x1c, 0x1c, 0xff,
    0x51, 0x30, 0x30, 0xff, 0x51, 0x30, 0x30, 0xff, 0x77, 0x56, 0x56, 0xff,
    0x7c, 0x49, 0x5a, 0xff, 0x7c, 0x49, 0x5a, 0xff, 0x72, 0x3f, 0x50, 0xff,
    0x72, 0x3f, 0x50, 0xff, 0xad, 0x5b, 0x53, 0xff, 0xad, 0x5b, 0x53, 0xff,
    0xba, 0x57, 0x57, 0xff, 0xd7, 0x74, 0x74, 0xff, 0x80, 0x80, 0xa2, 0xff,
    0x5a, 0x5a, 0x7c, 0xff, 0x3b, 0x3b, 0x6e, 0xff, 0x3b, 0x3b, 0x6e, 0xff,
    0x04, 0x14, 0x3d, 0xff, 0x18, 0x28, 0x51, 0xff, 0x0c, 0x14, 0x35, 0xff,
    0x0c, 0x14, 0x35, 0xff, 0x19, 0x2a, 0x42, 0xff, 0x07, 0x18, 0x30, 0xff,
    0x0b, 0x13, 0x45, 0xff, 0x00, 0x07, 0x39, 0xff, 0x19, 0x29, 0x5b, 0xff,
    0x19, 0x29, 0x5b, 0xff, 0x00, 0x07, 0x39, 0xff, 0x19, 0x29, 0x5b, 0xff,
    0x11, 0x11, 0x33, 0xff, 0x12, 0x23, 0x45, 0xff, 0x11, 0x11, 0x33, 0xff,
    0x11, 0x11, 0x33, 0xff, 0x51, 0x30, 0x30, 0xff, 0x3d, 0x1c, 0x1c, 0xff,
    0x3d, 0x1c, 0x1c, 0xff, 0x51, 0x30, 0x30, 0xff, 0x72, 0x3f, 0x50, 0xff,
    0x7c, 0x49, 0x5a, 0xff, 0x88, 0x55, 0x66, 0xff, 0x88, 0x55, 0x66, 0xff,
    0xa1, 0x4f, 0x47, 0xff, 0xad, 0x5b, 0x53, 0xff, 0xba, 0x57, 0x57, 0xff,
    0xd7, 0x74, 0x74, 0xff, 0x74, 0x84, 0xa5, 0xff, 0x4e, 0x5e, 0x7f, 0xff,
    0x41, 0x51, 0x83, 0xff, 0x2d, 0x3d, 0x6f, 0xff, 0x29, 0x32, 0x5b, 0xff,
    0x07, 0x10, 0x39, 0xff, 0x13, 0x1c, 0x45, 0xff, 0x1d, 0x26, 0x4f, 0xff,
    0x00, 0x00, 0x18, 0xff, 0x05, 0x0d, 0x2e, 0xff, 0x05, 0x0d, 0x2e, 0xff,
    0x11, 0x19, 0x3a, 0xff, 0x11, 0x21, 0x3a, 0xff, 0x11, 0x21, 0x3a, 0xff,
    0x29, 0x21, 0x32, 0xff, 0x13, 0x0b, 0x1c, 0xff, 0x36, 0x1d, 0x47, 0xff,
    0x20, 0x07, 0x31, 0xff, 0x4f, 0x1d, 0x47, 0xff, 0x4f, 0x1d, 0x47, 0xff,
    0x56, 0x34, 0x45, 0xff, 0x76, 0x54, 0x65, 0xff, 0x87, 0x32, 0x54, 0xff,
    0x67, 0x12, 0x34, 0xff, 0x93, 0x00, 0x00, 0xff, 0x82, 0x1c, 0x1c, 0xff,
    0xb0, 0x4a, 0x4a, 0xff, 0xb0, 0x4a, 0x4a, 0xff, 0xd2, 0x5b, 0x5b, 0xff,
    0xd2, 0x39, 0x39, 0xff, 0xd2, 0x5b, 0x5b, 0xff, 0xe8, 0x71, 0x71, 0xff,
    0x62, 0x72, 0x93, 0xff, 0x62, 0x72, 0x93, 0xff, 0x41, 0x51, 0x83, 0xff,
    0x41, 0x51, 0x83, 0xff, 0x1d, 0x26, 0x4f, 0xff, 0x29, 0x32, 0x5b, 0xff,
    0x07, 0x10, 0x39, 0xff, 0x13, 0x1c, 0x45, 0xff, 0x11, 0x19, 0x3a, 0xff,
    0x00, 0x03, 0x24, 0xff, 0x05, 0x0d, 0x2e, 0xff, 0x11, 0x19, 0x3a, 0xff,
    0x05, 0x15, 0x2e, 0xff, 0x05, 0x15, 0x2e, 0xff, 0x13, 0x0b, 0x1c, 0xff,
    0x07, 0x00, 0x10, 0xff, 0x20, 0x07, 0x31, 0xff, 0x20, 0x07, 0x31, 0xff,
    0x39, 0x07, 0x31, 0xff, 0x5b, 0x29, 0x53, 0xff, 0x56, 0x34, 0x45, 0xff,
    0x87, 0x32, 0x54, 0xff, 0x76, 0x54, 0x65, 0xff, 0x87, 0x32, 0x54, 0xff,
    0x82, 0x1c, 0x1c, 0xff, 0x93, 0x00, 0x00, 0xff, 0x82, 0x1c, 0x1c, 0xff,
    0xb0, 0x4a, 0x4a, 0xff, 0xd2, 0x39, 0x39, 0xff, 0xd2, 0x39, 0x39, 0xff,
    0xe8, 0x4f, 0x4f, 0xff, 0xe8, 0x71, 0x71, 0xff, 0x74, 0x84, 0xa5, 0xff,
    0x4e, 0x5e, 0x7f, 0xff, 0x53, 0x63, 0x95, 0xff, 0x2d, 0x3d, 0x6f, 0xff,
    0x29, 0x32, 0x6b, 0xff, 0x1d, 0x26, 0x5f, 0xff, 0x29, 0x32, 0x6b, 0xff,
    0x13, 0x1c, 0x55, 0xff, 0x2a, 0x4b, 0x5b, 0xff, 0x0d, 0x2e, 0x3e, 0xff,
    0x00, 0x14, 0x24, 0xff, 0x00, 0x00, 0x07, 0xff, 0x05, 0x15, 0x2e, 0xff,
    0x00, 0x0b, 0x24, 0xff, 0x13, 0x0b, 0x1c, 0xff, 0x13, 0x0b, 0x1c, 0xff,
    0x20, 0x07, 0x31, 0xff, 0x2c, 0x13, 0x3d, 0xff, 0x39, 0x07, 0x31, 0xff,
    0x4f, 0x1d, 0x47, 0xff, 0x87, 0x32, 0x54, 0xff, 0x87, 0x32, 0x54, 0xff,
    0x87, 0x32, 0x54, 0xff, 0x87, 0x32, 0x54, 0xff, 0xb0, 0x4a, 0x4a, 0xff,
    0xc1, 0x17, 0x17, 0xff, 0xc1, 0x17, 0x17, 0xff, 0xc1, 0x17, 0x17, 0xff,
    0xd2, 0x5b, 0x5b, 0xff, 0xd2, 0x39, 0x39, 0xff, 0xe8, 0x4f, 0x4f, 0xff,
    0xe8, 0x71, 0x71, 0xff, 0x88, 0x98, 0xb9, 0xff, 0x62, 0x72, 0x93, 0xff,
    0x2d, 0x3d, 0x6f, 0xff, 0x2d, 0x3d, 0x6f, 0xff, 0x1d, 0x26, 0x5f, 0xff,
    0x13, 0x1c, 0x55, 0xff, 0x07, 0x10, 0x49, 0xff, 0x1d, 0x26, 0x5f, 0xff,
    0x00, 0x14, 0x24, 0xff, 0x2a, 0x4b, 0x5b, 0xff, 0x00, 0x14, 0x24, 0xff,
    0x00, 0x00, 0x07, 0xff, 0x00, 0x00, 0x18, 0xff, 0x05, 0x15, 0x2e, 0xff,
    0x29, 0x21, 0x32, 0xff, 0x1d, 0x15, 0x26, 0xff, 0x42, 0x29, 0x53, 0xff,
    0x36, 0x1d, 0x47, 0xff, 0x5b, 0x29, 0x53, 0xff, 0x4f, 0x1d, 0x47, 0xff,
    0x87, 0x32, 0x54, 0xff, 0x87, 0x32, 0x54, 0xff, 0x87, 0x32, 0x54, 0xff,
    0x87, 0x32, 0x54, 0xff, 0xc1, 0x17, 0x17, 0xff, 0xc1, 0x17, 0x17, 0xff,
    0xc1, 0x17, 0x17, 0xff, 0xc1, 0x17, 0x17, 0xff, 0xd2, 0x39, 0x39, 0xff,
    0xd2, 0x39, 0x39, 0xff, 0xe8, 0x4f, 0x4f, 0xff, 0xe8, 0x71, 0x71, 0xff,
    0x7c, 0x9e, 0xaf, 0xff, 0x66, 0x88, 0x99, 0xff, 0x51, 0x62, 0x73, 0xff,
    0x1a, 0x2b, 0x3c, 0xff, 0x21, 0x21, 0x3a, 0xff, 0x0f, 0x0f, 0x28, 0xff,
    0x0d, 0x0d, 0x4f, 0xff, 0x00, 0x00, 0x35, 0xff, 0x00, 0x00, 0x20, 0xff,
    0x05, 0x05, 0x36, 0xff, 0x09, 0x11, 0x32, 0xff, 0x09, 0x11, 0x32, 0xff,
    0x10, 0x18, 0x31, 0xff, 0x10, 0x18, 0x31, 0xff, 0x34, 0x24, 0x55, 0xff,
    0x3e, 0x2e, 0x5f, 0xff, 0x46, 0x14, 0x46, 0xff, 0x6c, 0x3a, 0x6c, 0xff,
    0x6a, 0x20, 0x41, 0xff, 0x8c, 0x42, 0x63, 0xff, 0x99, 0x33, 0x44, 0xff,
    0x99, 0x33, 0x44, 0xff, 0x99, 0x33, 0x44, 0xff, 0xbb, 0x11, 0x22, 0xff,
    0xc3, 0x06, 0x04, 0xff, 0xcd, 0x0b, 0x0b, 0xff, 0xd7, 0x0f, 0x12, 0xff,
    0xe1, 0x14, 0x19, 0xff, 0xe7, 0x26, 0x28, 0xff, 0xe7, 0x3f, 0x44, 0xff,
    0xe7, 0x59, 0x5f, 0xff, 0xe7, 0x72, 0x7b, 0xff, 0x7c, 0x9e, 0xaf, 0xff,
    0x72, 0x94, 0xa5, 0xff, 0x6e, 0x7f, 0x90, 0xff, 0x1a, 0x2b, 0x3c, 0xff,
    0x0f, 0x0f, 0x28, 0xff, 0x00, 0x00, 0x14, 0xff, 0x00, 0x00, 0x35, 0xff,
    0x00, 0x00, 0x35, 0xff, 0x00, 0x00, 0x20, 0xff, 0x00, 0x00, 0x20, 0xff,
    0x09, 0x11, 0x32, 0xff, 0x09, 0x11, 0x32, 0xff, 0x26, 0x2e, 0x47, 0xff,
    0x26, 0x2e, 0x47, 0xff, 0x28, 0x18, 0x49, 0xff, 0x4a, 0x3a, 0x6b, 0xff,
    0x5a, 0x28, 0x5a, 0xff, 0x46, 0x14, 0x46, 0xff, 0x8c, 0x42, 0x63, 0xff,
    0x80, 0x36, 0x57, 0xff, 0x99, 0x33, 0x44, 0xff, 0xa4, 0x3e, 0x4f, 0xff,
    0x8e, 0x28, 0x39, 0xff, 0xbb, 0x11, 0x22, 0xff, 0xc7, 0x05, 0x03, 0xff,
    0xd1, 0x09, 0x0a, 0xff, 0xdb, 0x0e, 0x11, 0xff, 0xe5, 0x12, 0x18, 0xff,
    0xe9, 0x25, 0x26, 0xff, 0xe9, 0x3e, 0x42, 0xff, 0xe9, 0x58, 0x5d, 0xff,
    0xe9, 0x71, 0x79, 0xff, 0x88, 0xaa, 0xbb, 0xff, 0x66, 0x88, 0x99, 0xff,
    0x6e, 0x7f, 0x90, 0xff, 0x37, 0x48, 0x59, 0xff, 0x0f, 0x0f, 0x28, 0xff,
    0x00, 0x00, 0x14, 0xff, 0x00, 0x00, 0x18, 0xff, 0x00, 0x00, 0x18, 0xff,
    0x05, 0x05, 0x36, 0xff, 0x00, 0x00, 0x20, 0xff, 0x00, 0x00, 0x0c, 0xff,
    0x09, 0x11, 0x32, 0xff, 0x26, 0x2e, 0x47, 0xff, 0x32, 0x3a, 0x53, 0xff,
    0x3e, 0x2e, 0x5f, 0xff, 0x4a, 0x3a, 0x6b, 0xff, 0x6c, 0x3a, 0x6c, 0xff,
    0x6c, 0x3a, 0x6c, 0xff, 0x76, 0x2c, 0x4d, 0xff, 0x8c, 0x42, 0x63, 0xff,
    0x99, 0x33, 0x44, 0xff, 0x99, 0x33, 0x44, 0xff, 0xa4, 0x3e, 0x4f, 0xff,
    0xbb, 0x11, 0x22, 0xff, 0xcb, 0x03, 0x02, 0xff, 0xd5, 0x08, 0x09, 0xff,
    0xdf, 0x0c, 0x10, 0xff, 0xe9, 0x11, 0x17, 0xff, 0xeb, 0x24, 0x24, 0xff,
    0xeb, 0x3d, 0x40, 0xff, 0xeb, 0x57, 0x5b, 0xff, 0xeb, 0x70, 0x77, 0xff,
    0x88, 0xaa, 0xbb, 0xff, 0x72, 0x94, 0xa5, 0xff, 0x6e, 0x7f, 0x90, 0xff,
    0x6e, 0x7f, 0x90, 0xff, 0x35, 0x35, 0x4e, 0xff, 0x00, 0x00, 0x14, 0xff,
    0x00, 0x00, 0x18, 0xff, 0x00, 0x00, 0x35, 0xff, 0x11, 0x11, 0x42, 0xff,
    0x05, 0x05, 0x36, 0xff, 0x00, 0x00, 0x0c, 0xff, 0x09, 0x11, 0x32, 0xff,
    0x26, 0x2e, 0x47, 0xff, 0x32, 0x3a, 0x53, 0xff, 0x4a, 0x3a, 0x6b, 0xff,
    0x4a, 0x3a, 0x6b, 0xff, 0x6c, 0x3a, 0x6c, 0xff, 0x80, 0x4e, 0x80, 0xff,
    0x8c, 0x42, 0x63, 0xff, 0x80, 0x36, 0x57, 0xff, 0xa4, 0x3e, 0x4f, 0xff,
    0xa4, 0x3e, 0x4f, 0xff, 0x99, 0x33, 0x44, 0xff, 0xbb, 0x11, 0x22, 0xff,
    0xcf, 0x02, 0x01, 0xff, 0xd9, 0x06, 0x08, 0xff, 0xe3, 0x0b, 0x0f, 0xff,
    0xed, 0x0f, 0x16, 0xff, 0xed, 0x23, 0x22, 0xff, 0xed, 0x3c, 0x3e, 0xff,
    0xed, 0x56, 0x59, 0xff, 0xed, 0x6f, 0x75, 0xff, 0x7c, 0x95, 0xae, 0xff,
    0x7c, 0x95, 0xae, 0xff, 0x5f, 0x78, 0x91, 0xff, 0x5f, 0x78, 0x91, 0xff,
    0x5d, 0x6e, 0x90, 0xff, 0x26, 0x37, 0x59, 0xff, 0x00, 0x00, 0x09, 0xff,
    0x04, 0x00, 0x26, 0xff, 0x13, 0x13, 0x46, 0xff, 0x13, 0x13, 0x46, 0xff,
    0x13, 0x13, 0x46, 0xff, 0x33, 0x00, 0x11, 0xff, 0x3e, 0x1c, 0x3e, 0xff,
    0x55, 0x33, 0x55, 0xff, 0x6c, 0x4a, 0x6c, 0xff, 0x6c, 0x4a, 0x6c, 0xff,
    0x6a, 0x41, 0x52, 0xff, 0x80, 0x57, 0x68, 0xff, 0x8c, 0x63, 0x74, 0xff,
    0x80, 0x57, 0x68, 0xff, 0x9f, 0x17, 0x17, 0xff, 0xb5, 0x2d, 0x2d, 0xff,
    0xb5, 0x2d, 0x2d, 0xff, 0xd2, 0x06, 0x06, 0xff, 0xd6, 0x00, 0x00, 0xff,
    0xe2, 0x00, 0x03, 0xff, 0xe9, 0x0a, 0x12, 0xff, 0xef, 0x10, 0x18, 0xff,
    0xe7, 0x1e, 0x20, 0xff, 0xea, 0x3f, 0x3e, 0xff, 0xed, 0x60, 0x5b, 0xff,
    0xf0, 0x80, 0x79, 0xff, 0x7c, 0x95, 0xae, 0xff, 0x5f, 0x78, 0x91, 0xff,
    0x5f, 0x78, 0x91, 0xff, 0x45, 0x5e, 0x77, 0xff, 0x40, 0x51, 0x73, 0xff,
    0x26, 0x37, 0x59, 0xff, 0x1e, 0x0d, 0x40, 0xff, 0x00, 0x00, 0x09, 0xff,
    0x13, 0x13, 0x46, 0xff, 0x13, 0x13, 0x46, 0xff, 0x33, 0x33, 0x66, 0xff,
    0x13, 0x13, 0x46, 0xff, 0x3e, 0x1c, 0x3e, 0xff, 0x55, 0x33, 0x55, 0xff,
    0x55, 0x33, 0x55, 0xff, 0x6c, 0x4a, 0x6c, 0xff, 0x76, 0x4d, 0x5e, 0xff,
    0x6a, 0x41, 0x52, 0xff, 0x80, 0x57, 0x68, 0xff, 0x8c, 0x63, 0x74, 0xff,
    0xb5, 0x2d, 0x2d, 0xff, 0x9f, 0x17, 0x17, 0xff, 0xd2, 0x06, 0x06, 0xff,
    0xd2, 0x06, 0x06, 0xff, 0xd6, 0x00, 0x00, 0xff, 0xec, 0x05, 0x0d, 0xff,
    0xe9, 0x0a, 0x12, 0xff, 0xef, 0x10, 0x18, 0xff, 0xe8, 0x1e, 0x1f, 0xff,
    0xeb, 0x3e, 0x3d, 0xff, 0xee, 0x5f, 0x5a, 0xff, 0xf1, 0x80, 0x78, 0xff,
    0x6f, 0x67, 0x88, 0xff, 0x5b, 0x53, 0x74, 0xff, 0x49, 0x41, 0x62, 0xff,
    0x35, 0x2d, 0x4e, 0xff, 0x26, 0x37, 0x59, 0xff, 0x26, 0x37, 0x59, 0xff,
    0x3b, 0x2a, 0x5d, 0xff, 0x04, 0x00, 0x26, 0xff, 0x33, 0x00, 0x11, 0xff,
    0x33, 0x33, 0x66, 0xff, 0x33, 0x33, 0x66, 0xff, 0x33, 0x33, 0x66, 0xff,
    0x55, 0x33, 0x55, 0xff, 0x55, 0x33, 0x55, 0xff, 0x77, 0x33, 0x55, 0xff,
    0x77, 0x33, 0x55, 0xff, 0x8f, 0x34, 0x55, 0xff, 0x8f, 0x34, 0x55, 0xff,
    0x8f, 0x34, 0x55, 0xff, 0xa5, 0x4a, 0x6b, 0xff, 0xb5, 0x2d, 0x2d, 0xff,
    0xb5, 0x2d, 0x2d, 0xff, 0xd2, 0x06, 0x06, 0xff, 0xd2, 0x06, 0x06, 0xff,
    0xe2, 0x00, 0x03, 0xff, 0xec, 0x05, 0x0d, 0xff, 0xe5, 0x06, 0x0e, 0xff,
    0xef, 0x10, 0x18, 0xff, 0xe9, 0x1d, 0x1e, 0xff, 0xec, 0x3e, 0x3c, 0xff,
    0xef, 0x5f, 0x59, 0xff, 0xf2, 0x7f, 0x77, 0xff, 0x6f, 0x67, 0x88, 0xff,
    0x5b, 0x53, 0x74, 0xff, 0x49, 0x41, 0x62, 0xff, 0x35, 0x2d, 0x4e, 0xff,
    0x09, 0x1a, 0x3c, 0xff, 0x26, 0x37, 0x59, 0xff, 0x3b, 0x2a, 0x5d, 0xff,
    0x1e, 0x0d, 0x40, 0xff, 0x33, 0x00, 0x11, 0xff, 0x33, 0x00, 0x11, 0xff,
    0x33, 0x33, 0x66, 0xff, 0x53, 0x53, 0x86, 0xff, 0x55, 0x33, 0x55, 0xff,
    0x6c, 0x4a, 0x6c, 0xff, 0x77, 0x33, 0x55, 0xff, 0x77, 0x33, 0x55, 0xff,
    0x83, 0x28, 0x49, 0xff, 0x99, 0x3e, 0x5f, 0xff, 0x99, 0x3e, 0x5f, 0xff,
    0x8f, 0x34, 0x55, 0xff, 0xb5, 0x2d, 0x2d, 0xff, 0xb5, 0x2d, 0x2d, 0xff,
    0xd2, 0x06, 0x06, 0xff, 0xd2, 0x06, 0x06, 0xff, 0xe2, 0x00, 0x03, 0xff,
    0xec, 0x05, 0x0d, 0xff, 0xe5, 0x06, 0x0e, 0xff, 0xe9, 0x0a, 0x12, 0xff,
    0xea, 0x1d, 0x1d, 0xff, 0xed, 0x3d, 0x3b, 0xff, 0xf0, 0x5e, 0x58, 0xff,
    0xf3, 0x7f, 0x76, 0xff, 0x7c, 0x74, 0x95, 0xff, 0x56, 0x4e, 0x6f, 0xff,
    0x62, 0x49, 0x7b, 0xff, 0x4e, 0x35, 0x67, 0xff, 0x44, 0x33, 0x66, 0xff,
    0x34, 0x23, 0x56, 0xff, 0x44, 0x33, 0x66, 0xff, 0x44, 0x33, 0x66, 0xff,
    0x56, 0x23, 0x56, 0xff, 0x67, 0x00, 0x01, 0xff, 0x56, 0x23, 0x56, 0xff,
    0x76, 0x43, 0x76, 0xff, 0x8d, 0x4b, 0x6c, 0xff, 0x67, 0x25, 0x46, 0xff,
    0x8d, 0x4b, 0x6c, 0xff, 0x7b, 0x39, 0x5a, 0xff, 0x9f, 0x28, 0x39, 0xff,
    0x9f, 0x28, 0x39, 0xff, 0x9f, 0x28, 0x39, 0xff, 0xb5, 0x0b, 0x0b, 0xff,
    0xc1, 0x00, 0x00, 0xff, 0xe7, 0x11, 0x11, 0xff, 0xdf, 0x00, 0x00, 0xff,
    0xe9, 0x02, 0x0a, 0xff, 0xeb, 0x00, 0x04, 0xff, 0xec, 0x05, 0x0a, 0xff,
    0xed, 0x0a, 0x10, 0xff, 0xee, 0x0f, 0x16, 0xff, 0xeb, 0x1c, 0x1c, 0xff,
    0xec, 0x3c, 0x3b, 0xff, 0xed, 0x5c, 0x59, 0xff, 0xee, 0x7b, 0x78, 0xff,
    0x90, 0x88, 0xa9, 0xff, 0x56, 0x4e, 0x6f, 0xff, 0x4e, 0x35, 0x67, 0xff,
    0x4e, 0x35, 0x67, 0xff, 0x44, 0x33, 0x66, 0xff, 0x34, 0x23, 0x56, 0xff,
    0x34, 0x23, 0x56, 0xff, 0x54, 0x43, 0x76, 0xff, 0x76, 0x43, 0x76, 0xff,
    0x87, 0x10, 0x21, 0xff, 0x87, 0x10, 0x21, 0xff, 0x76, 0x43, 0x76, 0xff,
    0x8d, 0x4b, 0x6c, 0xff, 0x8d, 0x4b, 0x6c, 0xff, 0x7b, 0x39, 0x5a, 0xff,
    0x8d, 0x4b, 0x6c, 0xff, 0x9f, 0x28, 0x39, 0xff, 0x9f, 0x28, 0x39, 0xff,
    0xb5, 0x0b, 0x0b, 0xff, 0xb5, 0x0b, 0x0b, 0xff, 0xc1, 0x00, 0x00, 0xff,
    0xd5, 0x00, 0x00, 0xff, 0xe5, 0x00, 0x06, 0xff, 0xe5, 0x00, 0x06, 0xff,
    0xe9, 0x01, 0x05, 0xff, 0xea, 0x06, 0x0b, 0xff, 0xeb, 0x0b, 0x11, 0xff,
    0xec, 0x10, 0x17, 0xff, 0xeb, 0x1c, 0x1c, 0xff, 0xec, 0x3b, 0x3b, 0xff,
    0xed, 0x5b, 0x59, 0xff, 0xee, 0x7b, 0x78, 0xff, 0x90, 0x88, 0xa9, 0xff,
    0x6a, 0x62, 0x83, 0xff, 0x4e, 0x35, 0x67, 0xff, 0x62, 0x49, 0x7b, 0xff,
    0x54, 0x43, 0x76, 0xff, 0x54, 0x43, 0x76, 0xff, 0x66, 0x11, 0x55, 0xff,
    0x54, 0x43, 0x76, 0xff, 0x76, 0x43, 0x76, 0xff, 0x76, 0x43, 0x76, 0xff,
    0x87, 0x10, 0x21, 0xff, 0x87, 0x10, 0x21, 0xff, 0xad, 0x32, 0x53, 0xff,
    0xad, 0x32, 0x53, 0xff, 0x97, 0x1c, 0x3d, 0xff, 0xa1, 0x26, 0x47, 0xff,
    0x9f, 0x28, 0x39, 0xff, 0x9f, 0x28, 0x39, 0xff, 0xc1, 0x17, 0x17, 0xff,
    0xb5, 0x0b, 0x0b, 0xff, 0xd5, 0x00, 0x00, 0xff, 0xd5, 0x00, 0x00, 0xff,
    0xe5, 0x00, 0x06, 0xff, 0xe5, 0x00, 0x06, 0xff, 0xe7, 0x01, 0x06, 0xff,
    0xe8, 0x06, 0x0c, 0xff, 0xe9, 0x0b, 0x12, 0xff, 0xea, 0x10, 0x18, 0xff,
    0xeb, 0x1b, 0x1c, 0xff, 0xec, 0x3b, 0x3b, 0xff, 0xed, 0x5b, 0x59, 0xff,
    0xee, 0x7a, 0x78, 0xff, 0x90, 0x88, 0xa9, 0xff, 0x7c, 0x74, 0x95, 0xff,
    0x62, 0x49, 0x7b, 0xff, 0x62, 0x49, 0x7b, 0xff, 0x54, 0x43, 0x76, 0xff,
    0x54, 0x43, 0x76, 0xff, 0x66, 0x11, 0x55, 0xff, 0x66, 0x11, 0x55, 0xff,
    0x76, 0x43, 0x76, 0xff, 0x76, 0x43, 0x76, 0xff, 0x87, 0x10, 0x21, 0xff,
    0x87, 0x10, 0x21, 0xff, 0x8b, 0x10, 0x31, 0xff, 0xa1, 0x26, 0x47, 0xff,
    0xa1, 0x26, 0x47, 0xff, 0x8b, 0x10, 0x31, 0xff, 0xb5, 0x0b, 0x0b, 0xff,
    0xc1, 0x17, 0x17, 0xff, 0xc1, 0x17, 0x17, 0xff, 0xc1, 0x17, 0x17, 0xff,
    0xd5, 0x00, 0x00, 0xff, 0xd5, 0x00, 0x00, 0xff, 0xdf, 0x00, 0x00, 0xff,
    0xdf, 0x00, 0x00, 0xff, 0xe5, 0x02, 0x07, 0xff, 0xe6, 0x07, 0x0d, 0xff,
    0xe7, 0x0c, 0x13, 0xff, 0xe8, 0x11, 0x19, 0xff, 0xeb, 0x1b, 0x1c, 0xff,
    0xec, 0x3a, 0x3b, 0xff, 0xed, 0x5a, 0x59, 0xff, 0xee, 0x7a, 0x78, 0xff,
    0x9e, 0x86, 0xa7, 0xff, 0x9a, 0x82, 0xa3, 0xff, 0x8f, 0x56, 0x7f, 0xff,
    0x72, 0x39, 0x62, 0xff, 0x71, 0x3c, 0x75, 0xff, 0x75, 0x31, 0x68, 0xff,
    0x7a, 0x26, 0x5b, 0xff, 0x7e, 0x1b, 0x4e, 0xff, 0x82, 0x1c, 0x4f, 0xff,
    0x8e, 0x28, 0x5b, 0xff, 0x8e, 0x28, 0x5b, 0xff, 0xa4, 0x1c, 0x1c, 0xff,
    0xb3, 0x0e, 0x0e, 0xff, 0xad, 0x08, 0x08, 0xff, 0xbd, 0x18, 0x18, 0xff,
    0xb7, 0x12, 0x12, 0xff, 0xbd, 0x00, 0x00, 0xff, 0xc9, 0x03, 0x0b, 0xff,
    0xd6, 0x00, 0x08, 0xff, 0xd6, 0x00, 0x08, 0xff, 0xdb, 0x00, 0x08, 0xff,
    0xdd, 0x01, 0x07, 0xff, 0xdf, 0x02, 0x06, 0xff, 0xe1, 0x03, 0x05, 0xff,
    0xe3, 0x00, 0x00, 0xff, 0xe5, 0x07, 0x0a, 0xff, 0xe7, 0x0e, 0x14, 0xff,
    0xe9, 0x15, 0x1e, 0xff, 0xeb, 0x26, 0x24, 0xff, 0xed, 0x46, 0x42, 0xff,
    0xef, 0x66, 0x5f, 0xff, 0xf1, 0x85, 0x7d, 0xff, 0x9a, 0x82, 0xa3, 0xff,
    0xa4, 0x8c, 0xad, 0xff, 0xa9, 0x70, 0x99, 0xff, 0x8f, 0x56, 0x7f, 0xff,
    0x83, 0x3f, 0x6a, 0xff, 0x88, 0x34, 0x5d, 0xff, 0x8c, 0x29, 0x50, 0xff,
    0x90, 0x1e, 0x43, 0xff, 0xa4, 0x1c, 0x1c, 0xff, 0xa4, 0x1c, 0x1c, 0xff,
    0xb0, 0x28, 0x28, 0xff, 0xa4, 0x1c, 0x1c, 0xff, 0xad, 0x08, 0x08, 0xff,
    0xbd, 0x18, 0x18, 0xff, 0xbd, 0x18, 0x18, 0xff, 0xb3, 0x0e, 0x0e, 0xff,
    0xc9, 0x03, 0x0b, 0xff, 0xc9, 0x03, 0x0b, 0xff, 0xd6, 0x00, 0x08, 0xff,
    0xdc, 0x06, 0x0e, 0xff, 0xdc, 0x05, 0x0c, 0xff, 0xde, 0x06, 0x0b, 0xff,
    0xe0, 0x07, 0x0a, 0xff, 0xe2, 0x08, 0x09, 0xff, 0xe2, 0x04, 0x03, 0xff,
    0xe4, 0x0b, 0x0d, 0xff, 0xe6, 0x12, 0x17, 0xff, 0xe8, 0x19, 0x21, 0xff,
    0xe9, 0x31, 0x2b, 0xff, 0xeb, 0x51, 0x49, 0xff, 0xed, 0x71, 0x66, 0xff,
    0xef, 0x90, 0x84, 0xff, 0xa4, 0x8c, 0xad, 0xff, 0x94, 0x7c, 0x9d, 0xff,
    0xa9, 0x70, 0x99, 0xff, 0x8f, 0x56, 0x7f, 0xff, 0x96, 0x41, 0x5f, 0xff,
    0x9a, 0x36, 0x52, 0xff, 0x9e, 0x2b, 0x45, 0xff, 0xa2, 0x20, 0x38, 0xff,
    0xa4, 0x1c, 0x1c, 0xff, 0xa4, 0x1c, 0x1c, 0xff, 0xb0, 0x28, 0x28, 0xff,
    0xb0, 0x28, 0x28, 0xff, 0xcc, 0x0e, 0x0e, 0xff, 0xcc, 0x0e, 0x0e, 0xff,
    0xcc, 0x0e, 0x0e, 0xff, 0xd0, 0x12, 0x12, 0xff, 0xd3, 0x0d, 0x15, 0xff,
    0xd3, 0x0d, 0x15, 0xff, 0xe6, 0x10, 0x18, 0xff, 0xdc, 0x06, 0x0e, 0xff,
    0xdd, 0x09, 0x10, 0xff, 0xdf, 0x0a, 0x0f, 0xff, 0xe1, 0x0b, 0x0e, 0xff,
    0xe3, 0x0c, 0x0d, 0xff, 0xe1, 0x08, 0x06, 0xff, 0xe3, 0x0f, 0x10, 0xff,
    0xe5, 0x16, 0x1a, 0xff, 0xe7, 0x1d, 0x24, 0xff, 0xe7, 0x3c, 0x33, 0xff,
    0xe9, 0x5c, 0x50, 0xff, 0xeb, 0x7c, 0x6e, 0xff, 0xed, 0x9b, 0x8b, 0xff,
    0xa4, 0x8c, 0xad, 0xff, 0x94, 0x7c, 0x9d, 0xff, 0xa9, 0x70, 0x99, 0xff,
    0x8f, 0x56, 0x7f, 0xff, 0xa8, 0x44, 0x54, 0xff, 0xac, 0x39, 0x47, 0xff,
    0xb0, 0x2e, 0x3a, 0xff, 0xb5, 0x23, 0x2d, 0xff, 0xa4, 0x1c, 0x1c, 0xff,
    0xb0, 0x28, 0x28, 0xff, 0xb0, 0x28, 0x28, 0xff, 0xb0, 0x28, 0x28, 0xff,
    0xd6, 0x18, 0x18, 0xff, 0xd0, 0x12, 0x12, 0xff, 0xd6, 0x18, 0x18, 0xff,
    0xd6, 0x18, 0x18, 0xff, 0xdf, 0x19, 0x21, 0xff, 0xdf, 0x19, 0x21, 0xff,
    0xe6, 0x10, 0x18, 0xff, 0xe6, 0x10, 0x18, 0xff, 0xde, 0x0e, 0x14, 0xff,
    0xe0, 0x0f, 0x13, 0xff, 0xe2, 0x10, 0x12, 0xff, 0xe4, 0x11, 0x11, 0xff,
    0xe0, 0x0c, 0x09, 0xff, 0xe2, 0x13, 0x13, 0xff, 0xe4, 0x1a, 0x1d, 0xff,
    0xe6, 0x21, 0x27, 0xff, 0xe5, 0x47, 0x3a, 0xff, 0xe7, 0x67, 0x57, 0xff,
    0xe9, 0x87, 0x75, 0xff, 0xeb, 0xa6, 0x92, 0xff, 0xd5, 0x8b, 0x83, 0xff,
    0xc1, 0x77, 0x6f, 0xff, 0xb9, 0x56, 0x56, 0xff, 0xb9, 0x56, 0x56, 0xff,
    0xcd, 0x49, 0x49, 0xff, 0xcd, 0x49, 0x49, 0xff, 0xb9, 0x35, 0x35, 0xff,
    0xb9, 0x35, 0x35, 0xff, 0xcb, 0x2e, 0x2c, 0xff, 0xcb, 0x2c, 0x2c, 0xff,
    0xcb, 0x2a, 0x2c, 0xff, 0xcb, 0x28, 0x2c, 0xff, 0xd7, 0x20, 0x24, 0xff,
    0xda, 0x20, 0x23, 0xff, 0xdd, 0x1f, 0x22, 0xff, 0xe0, 0x1f, 0x21, 0xff,
    0xe7, 0x22, 0x24, 0xff, 0xe7, 0x20, 0x24, 0xff, 0xe7, 0x1d, 0x24, 0xff,
    0xe7, 0x1b, 0x24, 0xff, 0xe3, 0x1c, 0x20, 0xff, 0xe3, 0x1c, 0x20, 0xff,
    0xe3, 0x1c, 0x20, 0xff, 0xe3, 0x1c, 0x20, 0xff, 0xdf, 0x1a, 0x20, 0xff,
    0xe0, 0x23, 0x25, 0xff, 0xe1, 0x2b, 0x2a, 0xff, 0xe2, 0x34, 0x2f, 0xff,
    0xe3, 0x54, 0x49, 0xff, 0xe4, 0x69, 0x5e, 0xff, 0xe5, 0x7e, 0x74, 0xff,
    0xe6, 0x92, 0x89, 0xff, 0xe7, 0x9d, 0x95, 0xff, 0xd5, 0x8b, 0x83, 0xff,
    0xcd, 0x6a, 0x6a, 0xff, 0xb9, 0x56, 0x56, 0xff, 0xcd, 0x49, 0x49, 0xff,
    0xcd, 0x49, 0x49, 0xff, 0xcd, 0x49, 0x49, 0xff, 0xcd, 0x49, 0x49, 0xff,
    0xd8, 0x46, 0x46, 0xff, 0xd8, 0x44, 0x46, 0xff, 0xd8, 0x42, 0x46, 0xff,
    0xd8, 0x40, 0x46, 0xff, 0xdd, 0x3c, 0x3f, 0xff, 0xe0, 0x3b, 0x3e, 0xff,
    0xe3, 0x3b, 0x3d, 0xff, 0xe6, 0x3a, 0x3c, 0xff, 0xe9, 0x3d, 0x3c, 0xff,
    0xe9, 0x3a, 0x3c, 0xff, 0xe9, 0x38, 0x3c, 0xff, 0xe9, 0x35, 0x3c, 0xff,
    0xe7, 0x36, 0x3b, 0xff, 0xe7, 0x36, 0x3b, 0xff, 0xe7, 0x36, 0x3b, 0xff,
    0xe7, 0x36, 0x3b, 0xff, 0xe3, 0x34, 0x3a, 0xff, 0xe4, 0x3d, 0x3f, 0xff,
    0xe5, 0x45, 0x44, 0xff, 0xe6, 0x4e, 0x49, 0xff, 0xe6, 0x63, 0x59, 0xff,
    0xe7, 0x78, 0x6f, 0xff, 0xe8, 0x8d, 0x84, 0xff, 0xe9, 0xa2, 0x99, 0xff,
    0xfb, 0xb1, 0xa9, 0xff, 0xe7, 0x9d, 0x95, 0xff, 0xdf, 0x7c, 0x7c, 0xff,
    0xcd, 0x6a, 0x6a, 0xff, 0xe2, 0x66, 0x66, 0xff, 0xe2, 0x66, 0x66, 0xff,
    0xe2, 0x66, 0x66, 0xff, 0xe2, 0x66, 0x66, 0xff, 0xe5, 0x5f, 0x5f, 0xff,
    0xe5, 0x5d, 0x5f, 0xff, 0xe5, 0x5b, 0x5f, 0xff, 0xe5, 0x59, 0x5f, 0xff,
    0xe3, 0x58, 0x59, 0xff, 0xe6, 0x57, 0x58, 0xff, 0xe9, 0x57, 0x57, 0xff,
    0xec, 0x56, 0x56, 0xff, 0xeb, 0x58, 0x53, 0xff, 0xeb, 0x55, 0x53, 0xff,
    0xeb, 0x53, 0x53, 0xff, 0xeb, 0x50, 0x53, 0xff, 0xeb, 0x51, 0x55, 0xff,
    0xeb, 0x51, 0x55, 0xff, 0xeb, 0x51, 0x55, 0xff, 0xeb, 0x51, 0x55, 0xff,
    0xe7, 0x4f, 0x53, 0xff, 0xe8, 0x57, 0x58, 0xff, 0xe9, 0x60, 0x5d, 0xff,
    0xea, 0x68, 0x62, 0xff, 0xe9, 0x73, 0x6a, 0xff, 0xea, 0x87, 0x7f, 0xff,
    0xeb, 0x9c, 0x94, 0xff, 0xec, 0xb1, 0xa9, 0xff, 0xfb, 0xb1, 0xa9, 0xff,
    0xfb, 0xb1, 0xa9, 0xff, 0xf3, 0x90, 0x90, 0xff, 0xf3, 0x90, 0x90, 0xff,
    0xf8, 0x7c, 0x7c, 0xff, 0xf8, 0x7c, 0x7c, 0xff, 0xf8, 0x7c, 0x7c, 0xff,
    0xf8, 0x7c, 0x7c, 0xff, 0xf2, 0x77, 0x79, 0xff, 0xf2, 0x75, 0x79, 0xff,
    0xf2, 0x73, 0x79, 0xff, 0xf2, 0x71, 0x79, 0xff, 0xe9, 0x73, 0x74, 0xff,
    0xec, 0x73, 0x73, 0xff, 0xef, 0x72, 0x72, 0xff, 0xf2, 0x72, 0x71, 0xff,
    0xed, 0x72, 0x6b, 0xff, 0xed, 0x70, 0x6b, 0xff, 0xed, 0x6d, 0x6b, 0xff,
    0xed, 0x6b, 0x6b, 0xff, 0xef, 0x6b, 0x70, 0xff, 0xef, 0x6b, 0x70, 0xff,
    0xef, 0x6b, 0x70, 0xff, 0xef, 0x6b, 0x70, 0xff, 0xeb, 0x69, 0x6d, 0xff,
    0xec, 0x71, 0x72, 0xff, 0xed, 0x7a, 0x77, 0xff, 0xee, 0x82, 0x7c, 0xff,
    0xec, 0x82, 0x7a, 0xff, 0xed, 0x97, 0x8f, 0xff, 0xee, 0xab, 0xa4, 0xff,
    0xef, 0xc0, 0xba, 0xff,
  ]),
};

var img_32x32_rgb_punchthrough_etc2 = {
  compressed: new Uint8Array([
    0x84, 0x94, 0xb4, 0x05, 0xf6, 0xff, 0x99, 0x00, 0x74, 0x84, 0xa4, 0x05,
    0xff, 0xf6, 0x08, 0x91, 0x5f, 0x6f, 0x8f, 0x00, 0xff, 0xff, 0x00, 0x00,
    0x4b, 0x5b, 0x6b, 0x00, 0xff, 0xfd, 0x20, 0x00, 0x56, 0x66, 0x6e, 0x00,
    0xdf, 0xfd, 0x00, 0x02, 0x0e, 0x67, 0x33, 0x54, 0xff, 0xb9, 0x00, 0xc4,
    0xeb, 0x78, 0x54, 0x61, 0xff, 0xff, 0x08, 0x00, 0x8b, 0x4b, 0x53, 0x00,
    0xff, 0xf7, 0x00, 0x00, 0xeb, 0x79, 0x44, 0x74, 0xff, 0xff, 0x80, 0x00,
    0x01, 0x10, 0x3f, 0x00, 0xfb, 0xb7, 0x00, 0x00, 0x10, 0x27, 0x3a, 0x00,
    0xff, 0xfb, 0x00, 0xc4, 0x05, 0x24, 0x00, 0x38, 0xff, 0xef, 0x00, 0x10,
    0x05, 0x13, 0x23, 0x50, 0xfe, 0xff, 0x00, 0x00, 0x41, 0x4c, 0x5c, 0x25,
    0xff, 0xa7, 0x00, 0xb0, 0x61, 0x43, 0x53, 0x00, 0xfe, 0xff, 0x01, 0x00,
    0x8b, 0x3b, 0x33, 0x01, 0xff, 0x9e, 0x00, 0x60, 0x0e, 0x79, 0x34, 0x71,
    0xff, 0xff, 0x80, 0x00, 0x18, 0x20, 0x58, 0x04, 0xbb, 0xbf, 0x04, 0x40,
    0x16, 0x25, 0x3d, 0x00, 0xff, 0xff, 0x00, 0x00, 0x03, 0x10, 0x2f, 0x00,
    0xff, 0xdf, 0x00, 0x60, 0x0c, 0x24, 0x21, 0x31, 0xee, 0xff, 0x00, 0x10,
    0x79, 0x3f, 0x50, 0x00, 0xff, 0xff, 0x00, 0x00, 0x93, 0x34, 0x34, 0x21,
    0xfa, 0xf7, 0x07, 0x08, 0xf9, 0x66, 0xc3, 0x31, 0xff, 0x3f, 0x00, 0xc0,
    0x74, 0x94, 0xa4, 0x00, 0xff, 0xff, 0x00, 0x00, 0x0f, 0x0f, 0x21, 0x00,
    0xff, 0xff, 0x00, 0x00, 0x01, 0x01, 0x22, 0x0d, 0x7f, 0x70, 0x08, 0x00,
    0x23, 0x28, 0x43, 0x00, 0xff, 0xf7, 0x00, 0x08, 0x6a, 0x3f, 0x6d, 0x04,
    0xe7, 0xef, 0x19, 0x00, 0xa6, 0x46, 0x56, 0x00, 0xf7, 0x77, 0x00, 0x00,
    0xc3, 0x08, 0x09, 0x00, 0xff, 0xfc, 0x00, 0x00, 0xef, 0x43, 0x4b, 0x00,
    0xff, 0xff, 0x00, 0x70, 0x6c, 0x74, 0x94, 0x00, 0xff, 0xff, 0x00, 0x00,
    0x21, 0x35, 0x57, 0x04, 0xf7, 0xcf, 0x88, 0x30, 0x06, 0x13, 0x33, 0x65,
    0x77, 0x77, 0x88, 0x00, 0x0e, 0x35, 0x42, 0x4c, 0xea, 0x3f, 0x11, 0x80,
    0x88, 0x64, 0x74, 0x01, 0xf2, 0xbb, 0x08, 0x00, 0x1c, 0x00, 0xa2, 0x24,
    0xf0, 0xff, 0x01, 0x00, 0xd2, 0x01, 0x01, 0x01, 0xff, 0xfc, 0x00, 0x04,
    0xe1, 0x3b, 0x3b, 0x00, 0xff, 0x1f, 0x00, 0x60, 0x58, 0x4f, 0x70, 0x01,
    0x7f, 0xff, 0x80, 0x00, 0x3b, 0x2d, 0x5f, 0x01, 0xfa, 0xff, 0x07, 0x10,
    0x6a, 0x2e, 0x55, 0x00, 0xff, 0xff, 0x00, 0x00, 0x88, 0x30, 0x50, 0x00,
    0xff, 0xff, 0x00, 0x00, 0x15, 0x23, 0xb1, 0x11, 0xf2, 0xff, 0x0e, 0x00,
    0xdf, 0x00, 0x00, 0x01, 0xfc, 0xbf, 0x02, 0x20, 0xe0, 0x02, 0x0a, 0x00,
    0x7f, 0xff, 0x00, 0x00, 0xe0, 0x27, 0x27, 0x21, 0xff, 0xe8, 0x00, 0x10,
    0x90, 0x6e, 0x96, 0x01, 0xff, 0xff, 0xc0, 0x00, 0x8e, 0x3c, 0x5e, 0x00,
    0xef, 0xff, 0x00, 0x00, 0xf2, 0x22, 0x82, 0x51, 0xff, 0xff, 0x00, 0x01,
    0xb2, 0x17, 0x17, 0x01, 0xaa, 0xba, 0x45, 0x54, 0xc2, 0x0f, 0x08, 0x04,
    0x7e, 0xef, 0x80, 0x01, 0xd9, 0x09, 0x10, 0x00, 0xff, 0xb3, 0x00, 0x00,
    0xe0, 0x12, 0x1a, 0x01, 0x6c, 0xff, 0x10, 0x20, 0xef, 0x4b, 0x43, 0x00,
    0xff, 0xff, 0x00, 0x00, 0xb3, 0x53, 0x53, 0x01, 0xef, 0xff, 0x00, 0x00,
    0xc0, 0x40, 0x40, 0x00, 0xdd, 0xdd, 0x22, 0x22, 0xd0, 0x40, 0x40, 0x00,
    0xdd, 0xdd, 0x00, 0x00, 0xd8, 0x38, 0x38, 0x00, 0xfd, 0xdd, 0x00, 0x00,
    0xe0, 0x33, 0x3b, 0x01, 0xdb, 0xbf, 0x04, 0x40, 0xe0, 0x47, 0x4e, 0x00,
    0xdf, 0xff, 0x00, 0x00, 0xd8, 0x37, 0x3e, 0x00, 0xee, 0xdd, 0x10, 0x20,
    0xe0, 0x73, 0x6b, 0x00, 0xff, 0xff, 0x00, 0x00,
  ]),
  decompressed: new Uint8Array([
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x9c, 0xbd, 0xff,
    0x7c, 0x8c, 0xad, 0xff, 0x7b, 0x8c, 0xad, 0xff, 0x6b, 0x7c, 0x9d, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x5a, 0x6b, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5b, 0x6b, 0x7c, 0xff,
    0x5a, 0x6b, 0x73, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x52, 0x5a, 0xff, 0x66, 0x66, 0x77, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3e, 0x3e, 0x60, 0xff, 0x3e, 0x3e, 0x60, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x84, 0xa5, 0xff,
    0x52, 0x62, 0x83, 0xff, 0x52, 0x63, 0x84, 0xff, 0x41, 0x52, 0x73, 0xff,
    0x41, 0x52, 0x73, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x28, 0x28, 0x4a, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x3e, 0x60, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x8c, 0x4a, 0x52, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x17, 0x17, 0x4a, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x33, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x5b, 0x6b, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x73, 0x62, 0x73, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x8c, 0x39, 0x31, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x31, 0x39, 0x49, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x94, 0x41, 0x39, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x39, 0xff,
    0x08, 0x10, 0x31, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0x29, 0x41, 0xff,
    0x08, 0x19, 0x31, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x4a, 0x29, 0x39, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xad, 0x5a, 0x52, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x39, 0x6c, 0xff,
    0x00, 0x10, 0x39, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x19, 0x31, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x4a, 0x29, 0x39, 0xff, 0x39, 0x18, 0x28, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x1c, 0x0b, 0x2d, 0xff, 0x44, 0x22, 0x44, 0xff, 0x44, 0x22, 0x44, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xa5, 0x42, 0x42, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x31, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0x20, 0x20, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x20, 0x29, 0x62, 0xff, 0x29, 0x32, 0x6b, 0xff,
    0x18, 0x21, 0x5a, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x21, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xb5, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xd2, 0x39, 0x39, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x2d, 0x3e, 0x71, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xb5, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xd2, 0x39, 0x39, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x39, 0x6b, 0xff,
    0x6a, 0x20, 0x41, 0xff, 0x8c, 0x42, 0x63, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xc6, 0x08, 0x08, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x3a, 0x42, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x08, 0x08, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xe7, 0x3a, 0x42, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x08, 0x31, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xe7, 0x3a, 0x42, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x31, 0xff,
    0x08, 0x08, 0x31, 0xff, 0x00, 0x00, 0x07, 0xff, 0x08, 0x08, 0x31, 0xff,
    0x29, 0x31, 0x4a, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x8c, 0x42, 0x63, 0xff, 0x00, 0x00, 0x00, 0x00, 0xa5, 0x42, 0x52, 0xff,
    0xa5, 0x42, 0x52, 0xff, 0x94, 0x31, 0x42, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x29, 0x39, 0x5a, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x6d, 0x4b, 0x6d, 0xff, 0x6d, 0x4b, 0x6d, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x63, 0x73, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xb5, 0x2d, 0x2d, 0xff, 0x00, 0x00, 0x00, 0x00, 0xd6, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x29, 0x39, 0x5a, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0x00, 0xd6, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xef, 0x41, 0x41, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x66, 0x33, 0x55, 0xff, 0x66, 0x33, 0x55, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x8c, 0x42, 0x52, 0xff, 0x8c, 0x42, 0x52, 0xff,
    0x8c, 0x42, 0x52, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xcc, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
    0xdf, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x41, 0x41, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x29, 0x5b, 0xff,
    0x18, 0x07, 0x39, 0xff, 0x22, 0x11, 0x33, 0xff, 0x22, 0x11, 0x33, 0xff,
    0x43, 0x43, 0x76, 0xff, 0x43, 0x43, 0x76, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x6d, 0x4b, 0x6d, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0x4a, 0x5a, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xcc, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xe7, 0x39, 0x39, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x31, 0x21, 0x52, 0xff, 0x41, 0x31, 0x62, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x99, 0x22, 0x33, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x21, 0x21, 0xff,
    0xf8, 0x32, 0x32, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x31, 0x21, 0x52, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xb5, 0x0b, 0x0b, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xd6, 0x00, 0x00, 0xff, 0xe6, 0x08, 0x08, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xe7, 0x21, 0x21, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x18, 0x5a, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc1, 0x17, 0x17, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xe7, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x62, 0x4a, 0x7b, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xc1, 0x17, 0x17, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xe7, 0x10, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x7b, 0x18, 0x4a, 0xff, 0x82, 0x1c, 0x4f, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xb5, 0x10, 0x10, 0xff, 0xad, 0x08, 0x08, 0xff, 0xbd, 0x18, 0x18, 0xff,
    0xb5, 0x10, 0x10, 0xff, 0xbe, 0x00, 0x00, 0xff, 0xc6, 0x08, 0x08, 0xff,
    0xd6, 0x00, 0x08, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x10, 0x18, 0xff,
    0xef, 0x18, 0x20, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xdf, 0x08, 0x10, 0xff, 0xe7, 0x10, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x8c, 0x52, 0x7c, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xce, 0x10, 0x10, 0xff, 0xce, 0x10, 0x10, 0xff,
    0xce, 0x10, 0x10, 0xff, 0xce, 0x10, 0x10, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xde, 0x08, 0x10, 0xff, 0xde, 0x08, 0x10, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x8c, 0x52, 0x7c, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xe7, 0x11, 0x19, 0xff, 0xde, 0x08, 0x10, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xe7, 0x21, 0x29, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb5, 0x52, 0x52, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xde, 0x29, 0x29, 0xff, 0xe6, 0x31, 0x31, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0x4a, 0x4a, 0xff,
    0xce, 0x4a, 0x4a, 0xff, 0xce, 0x4a, 0x4a, 0xff, 0xce, 0x4a, 0x4a, 0xff,
    0xd6, 0x42, 0x42, 0xff, 0xd6, 0x42, 0x42, 0xff, 0xd6, 0x42, 0x42, 0xff,
    0xd6, 0x42, 0x42, 0xff, 0xde, 0x39, 0x39, 0xff, 0xde, 0x39, 0x39, 0xff,
    0xde, 0x39, 0x39, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x31, 0x39, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xe7, 0x39, 0x39, 0xff, 0xde, 0x31, 0x39, 0xff, 0xe6, 0x39, 0x41, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x52, 0x5a, 0xff,
    0xef, 0x52, 0x5a, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
  ]),
};

var img_32x32_rgba_etc2 = {
  compressed: new Uint8Array([
    0x04, 0x1d, 0x6d, 0x26, 0x91, 0x48, 0x84, 0x45, 0x8d, 0x9d, 0xb6, 0x4a,
    0xc4, 0x80, 0x83, 0x97, 0x0b, 0x12, 0x48, 0x94, 0x88, 0x44, 0x42, 0x25,
    0x64, 0x74, 0x95, 0x4b, 0xae, 0xa2, 0x91, 0x05, 0x15, 0x11, 0x68, 0x86,
    0x84, 0x44, 0x54, 0x26, 0x74, 0x85, 0xa7, 0x25, 0xfa, 0xa6, 0xff, 0x42,
    0x1b, 0x12, 0x68, 0x66, 0xa7, 0x66, 0xf6, 0x6f, 0x64, 0x74, 0x85, 0x49,
    0xae, 0xea, 0x89, 0xba, 0x1d, 0x12, 0x66, 0x76, 0xa7, 0x6a, 0x76, 0x86,
    0x64, 0x74, 0x7c, 0x4b, 0xa8, 0x8a, 0xa4, 0x81, 0x15, 0x11, 0x22, 0xf4,
    0x26, 0x44, 0x56, 0x84, 0x73, 0x73, 0x85, 0x29, 0xab, 0xa3, 0x3e, 0x2a,
    0x0b, 0x1b, 0x22, 0xf2, 0x25, 0x44, 0x44, 0x88, 0x75, 0x74, 0x86, 0x25,
    0xaa, 0x6e, 0x71, 0x11, 0x04, 0x1d, 0x22, 0xe4, 0x45, 0x48, 0x86, 0x91,
    0xbe, 0x7f, 0x04, 0x62, 0xbb, 0x6c, 0x86, 0xcf, 0x0b, 0x1b, 0x6d, 0x24,
    0x89, 0x44, 0x02, 0x25, 0x74, 0x74, 0x97, 0x48, 0xec, 0xf0, 0x50, 0xe6,
    0x1a, 0x10, 0x6d, 0x16, 0x88, 0x42, 0x63, 0x37, 0x21, 0x30, 0x5f, 0x4a,
    0xbd, 0xe8, 0x8e, 0x5b, 0x37, 0x21, 0x68, 0x86, 0x44, 0x42, 0x52, 0x2f,
    0x10, 0x27, 0x3a, 0x46, 0x8c, 0xe2, 0x87, 0x10, 0x4a, 0x3b, 0x64, 0x54,
    0x66, 0x42, 0x74, 0x2f, 0x1e, 0x18, 0x48, 0x07, 0x6b, 0x31, 0xe9, 0xa9,
    0x4b, 0x3a, 0x42, 0xf4, 0x2f, 0x46, 0x64, 0x66, 0x05, 0x13, 0x23, 0x57,
    0x66, 0xd6, 0x34, 0xc4, 0x38, 0x22, 0x33, 0x74, 0x2f, 0x46, 0x66, 0x84,
    0x43, 0x4e, 0x5c, 0x2b, 0xbd, 0xee, 0x59, 0xb4, 0x1f, 0x2b, 0x12, 0xf2,
    0x25, 0x44, 0x46, 0x88, 0x57, 0x44, 0x55, 0x45, 0x44, 0x2b, 0xa9, 0x01,
    0x0b, 0x1b, 0x12, 0xf2, 0x25, 0x44, 0x04, 0x89, 0x9a, 0x48, 0x41, 0x2e,
    0x00, 0x31, 0xf0, 0xc5, 0x10, 0x19, 0x6d, 0x24, 0x48, 0x22, 0x59, 0x77,
    0x6c, 0x7c, 0x9e, 0x4a, 0xfb, 0xf2, 0xd8, 0x58, 0x32, 0x22, 0x6d, 0x24,
    0x88, 0x22, 0x51, 0x77, 0x18, 0x20, 0x4a, 0x27, 0x6b, 0x90, 0x0e, 0x35,
    0x59, 0x42, 0x44, 0x02, 0x25, 0x12, 0xe9, 0x77, 0x00, 0x0b, 0x29, 0x2f,
    0xcc, 0x29, 0xf0, 0x87, 0x8c, 0x32, 0x68, 0x54, 0x66, 0x42, 0xf3, 0x37,
    0x03, 0x10, 0x2f, 0x26, 0x76, 0x48, 0x29, 0x19, 0x96, 0x4a, 0x42, 0xf4,
    0x2e, 0x46, 0x66, 0x45, 0x33, 0x18, 0x40, 0x26, 0x06, 0x76, 0x2e, 0x3e,
    0x71, 0x31, 0x12, 0xf2, 0x25, 0x44, 0x46, 0x88, 0xb9, 0x06, 0x32, 0x2b,
    0x02, 0x13, 0x10, 0x03, 0x38, 0x22, 0x9b, 0xf1, 0x2e, 0x44, 0x46, 0x91,
    0x49, 0x15, 0xd0, 0x06, 0xcc, 0xe9, 0x02, 0x33, 0x15, 0x11, 0x97, 0x70,
    0x25, 0x44, 0x06, 0x91, 0x6a, 0x06, 0x6b, 0x33, 0xf1, 0x05, 0x01, 0xff,
    0x15, 0x17, 0x6d, 0xb4, 0x49, 0x12, 0x4d, 0xff, 0x74, 0x95, 0xa6, 0x2c,
    0x70, 0xf0, 0xbe, 0x5c, 0x40, 0x24, 0x6d, 0xb4, 0x49, 0x12, 0x4d, 0xbf,
    0x1d, 0x1d, 0x32, 0x4e, 0xfe, 0xf6, 0x4c, 0xe8, 0x7f, 0x4b, 0x69, 0x22,
    0x00, 0x92, 0xdb, 0xbf, 0x00, 0x01, 0x37, 0x2a, 0x0c, 0x63, 0x0c, 0x6b,
    0xc7, 0x32, 0x68, 0x94, 0x24, 0x13, 0x69, 0xbf, 0x23, 0x28, 0x43, 0x26,
    0x03, 0x11, 0xea, 0xd1, 0xd9, 0x32, 0x33, 0x73, 0x2e, 0x42, 0x46, 0x89,
    0x63, 0x30, 0x66, 0x46, 0x05, 0x23, 0x5b, 0xa1, 0x95, 0x4b, 0xbb, 0xf1,
    0x2d, 0x24, 0x06, 0x92, 0xf3, 0x12, 0x93, 0x46, 0x0b, 0x57, 0x06, 0xa8,
    0x4b, 0x3a, 0xdb, 0xf9, 0x2d, 0x20, 0x04, 0x92, 0x60, 0x86, 0x04, 0xf6,
    0x18, 0x46, 0x80, 0x00, 0x1c, 0x12, 0xdf, 0xf9, 0x2d, 0x44, 0x96, 0xdb,
    0x72, 0xa6, 0x0d, 0x73, 0x8b, 0x2f, 0x64, 0x48, 0x15, 0x17, 0x6d, 0xb2,
    0x52, 0x90, 0x0f, 0xf5, 0x50, 0x6c, 0x85, 0x6b, 0xec, 0x00, 0xc0, 0x1f,
    0x3d, 0x21, 0x49, 0xb0, 0x09, 0x92, 0x0f, 0xb5, 0x31, 0x40, 0x63, 0x6c,
    0x71, 0xfc, 0x2d, 0x09, 0x7d, 0x34, 0x49, 0xb0, 0x0a, 0xb2, 0x0f, 0xf4,
    0x07, 0x01, 0x33, 0x6b, 0x6f, 0x73, 0xa1, 0x33, 0xbb, 0x5a, 0x00, 0xab,
    0x01, 0xd6, 0x0f, 0xa8, 0xeb, 0x35, 0x53, 0x5a, 0x02, 0x7f, 0x31, 0x83,
    0xc7, 0x32, 0xfa, 0x1f, 0xa1, 0xd4, 0x28, 0x13, 0x7b, 0x55, 0x67, 0x27,
    0x84, 0x6f, 0x61, 0x29, 0x91, 0x4b, 0xfa, 0xcb, 0x20, 0x00, 0xa4, 0x9b,
    0x51, 0x05, 0x68, 0x8b, 0xfe, 0x00, 0xfe, 0x21, 0x4a, 0x21, 0xff, 0x5b,
    0x20, 0x00, 0x94, 0x9b, 0xe0, 0x01, 0x09, 0x22, 0x0c, 0x1f, 0x70, 0x03,
    0x1b, 0x12, 0xff, 0xeb, 0x60, 0x25, 0x26, 0xdb, 0x72, 0x9e, 0x0c, 0x7a,
    0xa1, 0x2f, 0x43, 0x87, 0x0d, 0x19, 0x29, 0x20, 0x09, 0xb0, 0x0f, 0xac,
    0x77, 0x6d, 0x8f, 0x4a, 0xff, 0x70, 0x36, 0x3e, 0x2f, 0x21, 0x29, 0xb0,
    0x4a, 0x80, 0x1d, 0x60, 0x0e, 0x15, 0x43, 0x67, 0x13, 0x33, 0x62, 0xfc,
    0x59, 0x49, 0x05, 0x38, 0x0a, 0xb0, 0x1d, 0x60, 0xb8, 0x04, 0xb1, 0xb3,
    0x31, 0xcf, 0x01, 0x11, 0x7d, 0x34, 0x81, 0x3d, 0x0b, 0xf4, 0x2f, 0x42,
    0x83, 0x44, 0x64, 0x47, 0x96, 0x18, 0x80, 0x5c, 0x84, 0x37, 0xf4, 0x3f,
    0x0b, 0xd0, 0xba, 0x13, 0x58, 0x14, 0xc9, 0x1a, 0x01, 0x77, 0x72, 0x08,
    0x63, 0x4b, 0xf6, 0x0d, 0x01, 0x80, 0xa0, 0x53, 0xd9, 0x0f, 0x08, 0x42,
    0xef, 0xef, 0x89, 0x03, 0x37, 0x22, 0xfa, 0x0b, 0x02, 0x05, 0x34, 0x9b,
    0x74, 0x80, 0x04, 0xf7, 0x14, 0x3f, 0x00, 0x42, 0x15, 0x11, 0xd6, 0x08,
    0x01, 0x05, 0x24, 0x9b, 0x74, 0x9c, 0x07, 0xf7, 0x9b, 0x2f, 0x43, 0x47,
    0x0a, 0x12, 0x49, 0x22, 0x52, 0x04, 0xa8, 0x01, 0x98, 0x84, 0xa5, 0x0e,
    0xf1, 0xd2, 0x10, 0xec, 0x14, 0x11, 0x05, 0x38, 0x0a, 0xb0, 0x1f, 0x60,
    0xb8, 0xbc, 0xfa, 0xc2, 0x10, 0x85, 0xc8, 0xd2, 0x2f, 0x21, 0x05, 0x38,
    0x0b, 0xa0, 0xad, 0x01, 0x51, 0x05, 0x41, 0x2a, 0x01, 0x11, 0x30, 0x6f,
    0x39, 0x3b, 0xb0, 0xad, 0x02, 0xf4, 0x1f, 0x41, 0xb3, 0x10, 0x10, 0x03,
    0x24, 0x57, 0x8b, 0x3a, 0x3d, 0x21, 0xf0, 0x2f, 0x02, 0xd0, 0x2d, 0x0b,
    0xca, 0x08, 0x10, 0x22, 0x73, 0x33, 0x9f, 0x89, 0x30, 0x22, 0xf4, 0x1d,
    0x02, 0xa0, 0xa8, 0x53, 0x6c, 0x80, 0x05, 0x72, 0x04, 0x0e, 0xe2, 0x46,
    0x1f, 0x2b, 0xb0, 0x18, 0x0a, 0x05, 0x32, 0x9b, 0x70, 0x80, 0x04, 0x76,
    0x1c, 0x56, 0xe2, 0x03, 0x0b, 0x12, 0xb0, 0x18, 0x09, 0x05, 0x22, 0x92,
    0x74, 0xa6, 0x0c, 0xfa, 0xa5, 0x37, 0x0a, 0x50, 0x04, 0x1d, 0x4d, 0xb4,
    0x9b, 0x29, 0x30, 0x52, 0xdf, 0x94, 0x8d, 0x4a, 0x73, 0x31, 0xb9, 0x9c,
    0x0f, 0x11, 0x4d, 0xb2, 0x9b, 0x29, 0x30, 0x53, 0xd2, 0x53, 0x53, 0x47,
    0x77, 0x77, 0x99, 0x88, 0x0d, 0x19, 0x80, 0xaa, 0x0a, 0xd0, 0x2f, 0x41,
    0x64, 0xae, 0x0d, 0xe6, 0x26, 0x5f, 0xf1, 0xe4, 0x11, 0x12, 0xd0, 0xaf,
    0x42, 0xf4, 0x2f, 0x82, 0x6a, 0xa0, 0x0c, 0xf2, 0x1e, 0x47, 0x71, 0xe3,
    0x19, 0x10, 0xa1, 0x3a, 0x13, 0xa1, 0x38, 0x53, 0x72, 0xa2, 0x0c, 0xf3,
    0x18, 0x4f, 0x71, 0xa0, 0x10, 0x19, 0xf0, 0x2d, 0x0a, 0xa0, 0xb8, 0x53,
    0x70, 0x9c, 0x0c, 0x72, 0x1c, 0x47, 0x90, 0xa2, 0x0b, 0x1b, 0xa0, 0xa8,
    0x0a, 0x05, 0x32, 0x93, 0x6e, 0x9a, 0x0c, 0x72, 0x3c, 0x6f, 0x70, 0x61,
    0x04, 0x1d, 0xa0, 0xa0, 0x52, 0x29, 0x34, 0x9b, 0x70, 0x54, 0x15, 0x73,
    0xa7, 0x3f, 0x72, 0x22,
  ]),
  decompressed: new Uint8Array([
    0xa9, 0xb9, 0xd2, 0x00, 0xa9, 0xb9, 0xd2, 0x00, 0x90, 0xa1, 0xc2, 0x01,
    0x7c, 0x8d, 0xae, 0x01, 0x80, 0x90, 0xb1, 0x03, 0x6c, 0x7c, 0x9d, 0x03,
    0x80, 0x90, 0xb1, 0x03, 0x80, 0x90, 0xb1, 0x06, 0x7c, 0x8d, 0xaf, 0x08,
    0x7c, 0x8d, 0xaf, 0x08, 0x88, 0x99, 0xbb, 0x0b, 0x66, 0x77, 0x99, 0x0b,
    0x6f, 0x80, 0x91, 0x0e, 0x83, 0x94, 0xa5, 0x0e, 0x83, 0x94, 0xa5, 0x0e,
    0x6f, 0x80, 0x91, 0x0e, 0x80, 0x90, 0x98, 0x10, 0x6c, 0x7c, 0x84, 0x10,
    0x6c, 0x7c, 0x84, 0x10, 0x6c, 0x7c, 0x84, 0x10, 0x72, 0x72, 0x83, 0x0e,
    0x7c, 0x7c, 0x8d, 0x0b, 0x72, 0x72, 0x83, 0x0b, 0x88, 0x88, 0x99, 0x08,
    0x88, 0x88, 0x99, 0x06, 0x88, 0x88, 0x99, 0x06, 0x88, 0x88, 0x99, 0x04,
    0x88, 0x88, 0x99, 0x04, 0x7d, 0x7e, 0x82, 0x02, 0x8f, 0x8d, 0x8f, 0x01,
    0xa0, 0x9d, 0x9c, 0x01, 0xb2, 0xac, 0xa9, 0x00, 0xa9, 0xb9, 0xd2, 0x00,
    0x95, 0xa5, 0xbe, 0x01, 0x90, 0xa1, 0xc2, 0x01, 0x7c, 0x8d, 0xae, 0x02,
    0x5a, 0x6a, 0x8b, 0x03, 0x5a, 0x6a, 0x8b, 0x03, 0x5a, 0x6a, 0x8b, 0x06,
    0x5a, 0x6a, 0x8b, 0x09, 0x66, 0x77, 0x99, 0x0b, 0x72, 0x83, 0xa5, 0x0b,
    0x66, 0x77, 0x99, 0x0e, 0x66, 0x77, 0x99, 0x12, 0x49, 0x5a, 0x6b, 0x13,
    0x49, 0x5a, 0x6b, 0x13, 0x5d, 0x6e, 0x7f, 0x16, 0x5d, 0x6e, 0x7f, 0x16,
    0x5a, 0x6a, 0x72, 0x18, 0x6c, 0x7c, 0x84, 0x15, 0x6c, 0x7c, 0x84, 0x15,
    0x46, 0x56, 0x5e, 0x15, 0x66, 0x66, 0x77, 0x12, 0x66, 0x66, 0x77, 0x12,
    0x66, 0x66, 0x77, 0x0e, 0x66, 0x66, 0x77, 0x0b, 0x72, 0x72, 0x83, 0x09,
    0x72, 0x72, 0x83, 0x09, 0x72, 0x72, 0x83, 0x06, 0x66, 0x66, 0x77, 0x04,
    0x82, 0x6c, 0x71, 0x03, 0x94, 0x7b, 0x7e, 0x02, 0xa5, 0x8b, 0x8b, 0x01,
    0xb7, 0x9a, 0x98, 0x01, 0xa9, 0xb9, 0xd2, 0x01, 0x95, 0xa5, 0xbe, 0x01,
    0x6a, 0x7b, 0x9c, 0x02, 0x6a, 0x7b, 0x9c, 0x03, 0x5f, 0x6f, 0x98, 0x06,
    0x4b, 0x5b, 0x84, 0x06, 0x39, 0x49, 0x72, 0x09, 0x4b, 0x5b, 0x84, 0x0c,
    0x3f, 0x50, 0x72, 0x0e, 0x55, 0x66, 0x88, 0x12, 0x55, 0x66, 0x88, 0x12,
    0x33, 0x44, 0x66, 0x17, 0x4d, 0x4d, 0x5e, 0x19, 0x3b, 0x3b, 0x4c, 0x1c,
    0x3b, 0x3b, 0x4c, 0x1f, 0x4d, 0x4d, 0x5e, 0x1f, 0x4b, 0x5b, 0x63, 0x1e,
    0x4b, 0x5b, 0x63, 0x1e, 0x5f, 0x6f, 0x77, 0x1e, 0x4b, 0x5b, 0x63, 0x1b,
    0x3c, 0x3c, 0x5e, 0x1b, 0x3c, 0x3c, 0x5e, 0x17, 0x50, 0x50, 0x72, 0x12,
    0x3c, 0x3c, 0x5e, 0x12, 0x50, 0x3f, 0x61, 0x0f, 0x50, 0x3f, 0x61, 0x0c,
    0x5a, 0x49, 0x6b, 0x09, 0x66, 0x55, 0x77, 0x06, 0x88, 0x5a, 0x5f, 0x05,
    0x99, 0x69, 0x6c, 0x03, 0xab, 0x79, 0x79, 0x02, 0xbc, 0x88, 0x86, 0x01,
    0x95, 0xa5, 0xbe, 0x01, 0x6f, 0x7f, 0x98, 0x02, 0x7c, 0x8d, 0xae, 0x03,
    0x56, 0x67, 0x88, 0x05, 0x4b, 0x5b, 0x84, 0x06, 0x39, 0x49, 0x72, 0x09,
    0x39, 0x49, 0x72, 0x0c, 0x25, 0x35, 0x5e, 0x0f, 0x49, 0x5a, 0x7c, 0x12,
    0x3f, 0x50, 0x72, 0x17, 0x33, 0x44, 0x66, 0x1b, 0x33, 0x44, 0x66, 0x1e,
    0x27, 0x27, 0x38, 0x22, 0x27, 0x27, 0x38, 0x27, 0x27, 0x27, 0x38, 0x27,
    0x27, 0x27, 0x38, 0x27, 0x39, 0x49, 0x51, 0x29, 0x25, 0x35, 0x3d, 0x29,
    0x39, 0x49, 0x51, 0x29, 0x25, 0x35, 0x3d, 0x24, 0x50, 0x50, 0x72, 0x21,
    0x2a, 0x2a, 0x4c, 0x1e, 0x16, 0x16, 0x38, 0x1b, 0x2a, 0x2a, 0x4c, 0x17,
    0x50, 0x3f, 0x61, 0x14, 0x5a, 0x49, 0x6b, 0x0f, 0x50, 0x3f, 0x61, 0x0c,
    0x50, 0x3f, 0x61, 0x09, 0x8d, 0x48, 0x4e, 0x06, 0x9e, 0x57, 0x5b, 0x05,
    0xb0, 0x67, 0x68, 0x03, 0xc1, 0x76, 0x75, 0x02, 0x80, 0x80, 0xa2, 0x01,
    0x6e, 0x6e, 0x90, 0x04, 0x4d, 0x4d, 0x80, 0x04, 0x61, 0x61, 0x94, 0x06,
    0x3e, 0x4e, 0x77, 0x0b, 0x3e, 0x4e, 0x77, 0x0b, 0x20, 0x28, 0x49, 0x11,
    0x20, 0x28, 0x49, 0x14, 0x19, 0x2a, 0x42, 0x1d, 0x2d, 0x3e, 0x56, 0x1d,
    0x21, 0x29, 0x5b, 0x23, 0x15, 0x1d, 0x4f, 0x29, 0x10, 0x10, 0x42, 0x2c,
    0x16, 0x16, 0x48, 0x35, 0x10, 0x10, 0x42, 0x35, 0x1a, 0x1a, 0x4c, 0x35,
    0x11, 0x11, 0x33, 0x33, 0x22, 0x33, 0x55, 0x33, 0x11, 0x11, 0x33, 0x33,
    0x32, 0x43, 0x65, 0x33, 0x47, 0x4f, 0x5f, 0x2e, 0x53, 0x5b, 0x6b, 0x28,
    0x31, 0x39, 0x49, 0x28, 0x31, 0x39, 0x49, 0x1e, 0x38, 0x27, 0x38, 0x1b,
    0x5e, 0x4d, 0x5e, 0x15, 0x72, 0x61, 0x72, 0x11, 0x5e, 0x4d, 0x5e, 0x0b,
    0x8b, 0x39, 0x31, 0x09, 0x97, 0x45, 0x3d, 0x06, 0xba, 0x57, 0x57, 0x04,
    0xd7, 0x74, 0x74, 0x04, 0x94, 0x94, 0xb6, 0x01, 0x5a, 0x5a, 0x7c, 0x04,
    0x4d, 0x4d, 0x80, 0x06, 0x3b, 0x3b, 0x6e, 0x09, 0x3e, 0x4e, 0x77, 0x0b,
    0x18, 0x28, 0x51, 0x11, 0x46, 0x4e, 0x6f, 0x17, 0x20, 0x28, 0x49, 0x1c,
    0x07, 0x18, 0x30, 0x23, 0x07, 0x18, 0x30, 0x29, 0x21, 0x29, 0x5b, 0x31,
    0x15, 0x1d, 0x4f, 0x31, 0x1a, 0x1a, 0x4c, 0x3b, 0x10, 0x10, 0x42, 0x3b,
    0x16, 0x16, 0x48, 0x44, 0x10, 0x10, 0x42, 0x44, 0x22, 0x33, 0x55, 0x45,
    0x11, 0x11, 0x33, 0x45, 0x22, 0x33, 0x55, 0x3f, 0x12, 0x23, 0x45, 0x3f,
    0x3d, 0x45, 0x55, 0x3a, 0x31, 0x39, 0x49, 0x34, 0x47, 0x4f, 0x5f, 0x2e,
    0x3d, 0x45, 0x55, 0x28, 0x4c, 0x3b, 0x4c, 0x21, 0x4c, 0x3b, 0x4c, 0x1b,
    0x5e, 0x4d, 0x5e, 0x15, 0x72, 0x61, 0x72, 0x11, 0xa1, 0x4f, 0x47, 0x0c,
    0x97, 0x45, 0x3d, 0x09, 0xba, 0x57, 0x57, 0x06, 0xd7, 0x74, 0x74, 0x04,
    0x94, 0x94, 0xb6, 0x04, 0x5a, 0x5a, 0x7c, 0x06, 0x3b, 0x3b, 0x6e, 0x09,
    0x27, 0x27, 0x5a, 0x0c, 0x2a, 0x3a, 0x63, 0x11, 0x04, 0x14, 0x3d, 0x14,
    0x0c, 0x14, 0x35, 0x1c, 0x32, 0x3a, 0x5b, 0x22, 0x19, 0x2a, 0x42, 0x29,
    0x07, 0x18, 0x30, 0x31, 0x00, 0x07, 0x39, 0x3b, 0x15, 0x1d, 0x4f, 0x43,
    0x0d, 0x1d, 0x4f, 0x44, 0x0d, 0x1d, 0x4f, 0x4d, 0x0d, 0x1d, 0x4f, 0x4d,
    0x00, 0x07, 0x39, 0x56, 0x12, 0x23, 0x45, 0x54, 0x12, 0x23, 0x45, 0x54,
    0x12, 0x23, 0x45, 0x4e, 0x22, 0x33, 0x55, 0x4e, 0x3d, 0x1c, 0x1c, 0x46,
    0x51, 0x30, 0x30, 0x40, 0x51, 0x30, 0x30, 0x3a, 0x77, 0x56, 0x56, 0x34,
    0x7c, 0x49, 0x5a, 0x27, 0x7c, 0x49, 0x5a, 0x21, 0x72, 0x3f, 0x50, 0x1b,
    0x72, 0x3f, 0x50, 0x15, 0xad, 0x5b, 0x53, 0x0f, 0xad, 0x5b, 0x53, 0x0c,
    0xba, 0x57, 0x57, 0x09, 0xd7, 0x74, 0x74, 0x06, 0x80, 0x80, 0xa2, 0x04,
    0x5a, 0x5a, 0x7c, 0x06, 0x3b, 0x3b, 0x6e, 0x09, 0x3b, 0x3b, 0x6e, 0x0f,
    0x04, 0x14, 0x3d, 0x14, 0x18, 0x28, 0x51, 0x17, 0x0c, 0x14, 0x35, 0x22,
    0x0c, 0x14, 0x35, 0x28, 0x19, 0x2a, 0x42, 0x31, 0x07, 0x18, 0x30, 0x3b,
    0x0b, 0x13, 0x45, 0x43, 0x00, 0x07, 0x39, 0x4f, 0x19, 0x29, 0x5b, 0x56,
    0x19, 0x29, 0x5b, 0x5c, 0x00, 0x07, 0x39, 0x65, 0x19, 0x29, 0x5b, 0x65,
    0x11, 0x11, 0x33, 0x66, 0x12, 0x23, 0x45, 0x66, 0x11, 0x11, 0x33, 0x60,
    0x11, 0x11, 0x33, 0x60, 0x51, 0x30, 0x30, 0x50, 0x3d, 0x1c, 0x1c, 0x50,
    0x3d, 0x1c, 0x1c, 0x46, 0x51, 0x30, 0x30, 0x3a, 0x72, 0x3f, 0x50, 0x31,
    0x7c, 0x49, 0x5a, 0x27, 0x88, 0x55, 0x66, 0x21, 0x88, 0x55, 0x66, 0x1b,
    0xa1, 0x4f, 0x47, 0x14, 0xad, 0x5b, 0x53, 0x0f, 0xba, 0x57, 0x57, 0x09,
    0xd7, 0x74, 0x74, 0x06, 0x74, 0x84, 0xa5, 0x06, 0x4e, 0x5e, 0x7f, 0x08,
    0x41, 0x51, 0x83, 0x0b, 0x2d, 0x3d, 0x6f, 0x11, 0x29, 0x32, 0x5b, 0x18,
    0x07, 0x10, 0x39, 0x22, 0x13, 0x1c, 0x45, 0x28, 0x1d, 0x26, 0x4f, 0x2e,
    0x00, 0x00, 0x18, 0x39, 0x05, 0x0d, 0x2e, 0x45, 0x05, 0x0d, 0x2e, 0x51,
    0x11, 0x19, 0x3a, 0x5d, 0x11, 0x21, 0x3a, 0x65, 0x11, 0x21, 0x3a, 0x74,
    0x29, 0x21, 0x32, 0x74, 0x13, 0x0b, 0x1c, 0x7d, 0x36, 0x1d, 0x47, 0x76,
    0x20, 0x07, 0x31, 0x76, 0x4f, 0x1d, 0x47, 0x76, 0x4f, 0x1d, 0x47, 0x6e,
    0x56, 0x34, 0x45, 0x68, 0x76, 0x54, 0x65, 0x5c, 0x87, 0x32, 0x54, 0x53,
    0x67, 0x12, 0x34, 0x4a, 0x93, 0x00, 0x00, 0x3a, 0x82, 0x1c, 0x1c, 0x34,
    0xb0, 0x4a, 0x4a, 0x28, 0xb0, 0x4a, 0x4a, 0x1e, 0xd2, 0x5b, 0x5b, 0x17,
    0xd2, 0x39, 0x39, 0x12, 0xd2, 0x5b, 0x5b, 0x0b, 0xe8, 0x71, 0x71, 0x08,
    0x62, 0x72, 0x93, 0x06, 0x62, 0x72, 0x93, 0x0b, 0x41, 0x51, 0x83, 0x0e,
    0x41, 0x51, 0x83, 0x14, 0x1d, 0x26, 0x4f, 0x18, 0x29, 0x32, 0x5b, 0x22,
    0x07, 0x10, 0x39, 0x2e, 0x13, 0x1c, 0x45, 0x3a, 0x11, 0x19, 0x3a, 0x45,
    0x00, 0x03, 0x24, 0x51, 0x05, 0x0d, 0x2e, 0x5d, 0x11, 0x19, 0x3a, 0x69,
    0x05, 0x15, 0x2e, 0x74, 0x05, 0x15, 0x2e, 0x7d, 0x13, 0x0b, 0x1c, 0x86,
    0x07, 0x00, 0x10, 0x8f, 0x20, 0x07, 0x31, 0x8e, 0x20, 0x07, 0x31, 0x8e,
    0x39, 0x07, 0x31, 0x86, 0x5b, 0x29, 0x53, 0x86, 0x56, 0x34, 0x45, 0x77,
    0x87, 0x32, 0x54, 0x68, 0x76, 0x54, 0x65, 0x5c, 0x87, 0x32, 0x54, 0x53,
    0x82, 0x1c, 0x1c, 0x46, 0x93, 0x00, 0x00, 0x3a, 0x82, 0x1c, 0x1c, 0x2e,
    0xb0, 0x4a, 0x4a, 0x28, 0xd2, 0x39, 0x39, 0x1b, 0xd2, 0x39, 0x39, 0x12,
    0xe8, 0x4f, 0x4f, 0x0e, 0xe8, 0x71, 0x71, 0x0b, 0x74, 0x84, 0xa5, 0x08,
    0x4e, 0x5e, 0x7f, 0x0b, 0x53, 0x63, 0x95, 0x11, 0x2d, 0x3d, 0x6f, 0x17,
    0x29, 0x32, 0x6b, 0x22, 0x1d, 0x26, 0x5f, 0x28, 0x29, 0x32, 0x6b, 0x34,
    0x13, 0x1c, 0x55, 0x40, 0x2a, 0x4b, 0x5b, 0x51, 0x0d, 0x2e, 0x3e, 0x5d,
    0x00, 0x14, 0x24, 0x69, 0x00, 0x00, 0x07, 0x75, 0x05, 0x15, 0x2e, 0x86,
    0x00, 0x0b, 0x24, 0x8f, 0x13, 0x0b, 0x1c, 0x98, 0x13, 0x0b, 0x1c, 0xa1,
    0x20, 0x07, 0x31, 0xa2, 0x2c, 0x13, 0x3d, 0xa2, 0x39, 0x07, 0x31, 0x9a,
    0x4f, 0x1d, 0x47, 0x8e, 0x87, 0x32, 0x54, 0x83, 0x87, 0x32, 0x54, 0x77,
    0x87, 0x32, 0x54, 0x68, 0x87, 0x32, 0x54, 0x5c, 0xb0, 0x4a, 0x4a, 0x50,
    0xc1, 0x17, 0x17, 0x40, 0xc1, 0x17, 0x17, 0x34, 0xc1, 0x17, 0x17, 0x28,
    0xd2, 0x5b, 0x5b, 0x1e, 0xd2, 0x39, 0x39, 0x17, 0xe8, 0x4f, 0x4f, 0x12,
    0xe8, 0x71, 0x71, 0x0b, 0x88, 0x98, 0xb9, 0x08, 0x62, 0x72, 0x93, 0x0e,
    0x2d, 0x3d, 0x6f, 0x14, 0x2d, 0x3d, 0x6f, 0x19, 0x1d, 0x26, 0x5f, 0x22,
    0x13, 0x1c, 0x55, 0x2e, 0x07, 0x10, 0x49, 0x3a, 0x1d, 0x26, 0x5f, 0x4a,
    0x00, 0x14, 0x24, 0x51, 0x2a, 0x4b, 0x5b, 0x69, 0x00, 0x14, 0x24, 0x75,
    0x00, 0x00, 0x07, 0x89, 0x00, 0x00, 0x18, 0x98, 0x05, 0x15, 0x2e, 0xa1,
    0x29, 0x21, 0x32, 0xb0, 0x1d, 0x15, 0x26, 0xb0, 0x42, 0x29, 0x53, 0xba,
    0x36, 0x1d, 0x47, 0xb2, 0x5b, 0x29, 0x53, 0xb2, 0x4f, 0x1d, 0x47, 0xa2,
    0x87, 0x32, 0x54, 0x95, 0x87, 0x32, 0x54, 0x83, 0x87, 0x32, 0x54, 0x77,
    0x87, 0x32, 0x54, 0x68, 0xc1, 0x17, 0x17, 0x50, 0xc1, 0x17, 0x17, 0x46,
    0xc1, 0x17, 0x17, 0x3a, 0xc1, 0x17, 0x17, 0x2e, 0xd2, 0x39, 0x39, 0x21,
    0xd2, 0x39, 0x39, 0x1b, 0xe8, 0x4f, 0x4f, 0x12, 0xe8, 0x71, 0x71, 0x0e,
    0x7c, 0x9e, 0xaf, 0x0a, 0x66, 0x88, 0x99, 0x0d, 0x51, 0x62, 0x73, 0x12,
    0x1a, 0x2b, 0x3c, 0x1c, 0x21, 0x21, 0x3a, 0x28, 0x0f, 0x0f, 0x28, 0x30,
    0x0d, 0x0d, 0x4f, 0x3a, 0x00, 0x00, 0x35, 0x4e, 0x00, 0x00, 0x20, 0x57,
    0x05, 0x05, 0x36, 0x6b, 0x09, 0x11, 0x32, 0x83, 0x09, 0x11, 0x32, 0x8f,
    0x10, 0x18, 0x31, 0xa0, 0x10, 0x18, 0x31, 0xaf, 0x34, 0x24, 0x55, 0xc1,
    0x3e, 0x2e, 0x5f, 0xca, 0x46, 0x14, 0x46, 0xca, 0x6c, 0x3a, 0x6c, 0xca,
    0x6a, 0x20, 0x41, 0xc1, 0x8c, 0x42, 0x63, 0xb2, 0x99, 0x33, 0x44, 0xa5,
    0x99, 0x33, 0x44, 0x8d, 0x99, 0x33, 0x44, 0x81, 0xbb, 0x11, 0x22, 0x6d,
    0xc3, 0x06, 0x04, 0x60, 0xcd, 0x0b, 0x0b, 0x4e, 0xd7, 0x0f, 0x12, 0x3f,
    0xe1, 0x14, 0x19, 0x33, 0xe7, 0x26, 0x28, 0x23, 0xe7, 0x3f, 0x44, 0x1d,
    0xe7, 0x59, 0x5f, 0x14, 0xe7, 0x72, 0x7b, 0x0f, 0x7c, 0x9e, 0xaf, 0x0a,
    0x72, 0x94, 0xa5, 0x10, 0x6e, 0x7f, 0x90, 0x17, 0x1a, 0x2b, 0x3c, 0x1f,
    0x0f, 0x0f, 0x28, 0x28, 0x00, 0x00, 0x14, 0x34, 0x00, 0x00, 0x35, 0x44,
    0x00, 0x00, 0x35, 0x4e, 0x00, 0x00, 0x20, 0x63, 0x00, 0x00, 0x20, 0x77,
    0x09, 0x11, 0x32, 0x83, 0x09, 0x11, 0x32, 0x97, 0x26, 0x2e, 0x47, 0xaf,
    0x26, 0x2e, 0x47, 0xc1, 0x28, 0x18, 0x49, 0xca, 0x4a, 0x3a, 0x6b, 0xdc,
    0x5a, 0x28, 0x5a, 0xdc, 0x46, 0x14, 0x46, 0xdc, 0x8c, 0x42, 0x63, 0xd3,
    0x80, 0x36, 0x57, 0xc1, 0x99, 0x33, 0x44, 0xad, 0xa4, 0x3e, 0x4f, 0x99,
    0x8e, 0x28, 0x39, 0x81, 0xbb, 0x11, 0x22, 0x79, 0xc7, 0x05, 0x03, 0x60,
    0xd1, 0x09, 0x0a, 0x4e, 0xdb, 0x0e, 0x11, 0x45, 0xe5, 0x12, 0x18, 0x33,
    0xe9, 0x25, 0x26, 0x28, 0xe9, 0x3e, 0x42, 0x1d, 0xe9, 0x58, 0x5d, 0x17,
    0xe9, 0x71, 0x79, 0x0f, 0x88, 0xaa, 0xbb, 0x0a, 0x66, 0x88, 0x99, 0x10,
    0x6e, 0x7f, 0x90, 0x17, 0x37, 0x48, 0x59, 0x1f, 0x0f, 0x0f, 0x28, 0x28,
    0x00, 0x00, 0x14, 0x34, 0x00, 0x00, 0x18, 0x44, 0x00, 0x00, 0x18, 0x56,
    0x05, 0x05, 0x36, 0x63, 0x00, 0x00, 0x20, 0x77, 0x00, 0x00, 0x0c, 0x8f,
    0x09, 0x11, 0x32, 0xa3, 0x26, 0x2e, 0x47, 0xb8, 0x32, 0x3a, 0x53, 0xca,
    0x3e, 0x2e, 0x5f, 0xdc, 0x4a, 0x3a, 0x6b, 0xeb, 0x6c, 0x3a, 0x6c, 0xee,
    0x6c, 0x3a, 0x6c, 0xe5, 0x76, 0x2c, 0x4d, 0xdc, 0x8c, 0x42, 0x63, 0xca,
    0x99, 0x33, 0x44, 0xb9, 0x99, 0x33, 0x44, 0xa5, 0xa4, 0x3e, 0x4f, 0x8d,
    0xbb, 0x11, 0x22, 0x79, 0xcb, 0x03, 0x02, 0x66, 0xd5, 0x08, 0x09, 0x54,
    0xdf, 0x0c, 0x10, 0x45, 0xe9, 0x11, 0x17, 0x33, 0xeb, 0x24, 0x24, 0x28,
    0xeb, 0x3d, 0x40, 0x20, 0xeb, 0x57, 0x5b, 0x17, 0xeb, 0x70, 0x77, 0x0f,
    0x88, 0xaa, 0xbb, 0x0a, 0x72, 0x94, 0xa5, 0x10, 0x6e, 0x7f, 0x90, 0x17,
    0x6e, 0x7f, 0x90, 0x1f, 0x35, 0x35, 0x4e, 0x28, 0x00, 0x00, 0x14, 0x34,
    0x00, 0x00, 0x18, 0x44, 0x00, 0x00, 0x35, 0x56, 0x11, 0x11, 0x42, 0x63,
    0x05, 0x05, 0x36, 0x77, 0x00, 0x00, 0x0c, 0x8f, 0x09, 0x11, 0x32, 0xa3,
    0x26, 0x2e, 0x47, 0xb8, 0x32, 0x3a, 0x53, 0xca, 0x4a, 0x3a, 0x6b, 0xdc,
    0x4a, 0x3a, 0x6b, 0xeb, 0x6c, 0x3a, 0x6c, 0xfd, 0x80, 0x4e, 0x80, 0xee,
    0x8c, 0x42, 0x63, 0xdc, 0x80, 0x36, 0x57, 0xca, 0xa4, 0x3e, 0x4f, 0xb9,
    0xa4, 0x3e, 0x4f, 0xa5, 0x99, 0x33, 0x44, 0x8d, 0xbb, 0x11, 0x22, 0x79,
    0xcf, 0x02, 0x01, 0x66, 0xd9, 0x06, 0x08, 0x54, 0xe3, 0x0b, 0x0f, 0x45,
    0xed, 0x0f, 0x16, 0x33, 0xed, 0x23, 0x22, 0x28, 0xed, 0x3c, 0x3e, 0x20,
    0xed, 0x56, 0x59, 0x17, 0xed, 0x6f, 0x75, 0x0f, 0x7c, 0x95, 0xae, 0x0a,
    0x7c, 0x95, 0xae, 0x10, 0x5f, 0x78, 0x91, 0x17, 0x5f, 0x78, 0x91, 0x1f,
    0x5d, 0x6e, 0x90, 0x29, 0x26, 0x37, 0x59, 0x37, 0x00, 0x00, 0x09, 0x41,
    0x04, 0x00, 0x26, 0x55, 0x13, 0x13, 0x46, 0x65, 0x13, 0x13, 0x46, 0x74,
    0x13, 0x13, 0x46, 0x8c, 0x33, 0x00, 0x11, 0x9e, 0x3e, 0x1c, 0x3e, 0xb1,
    0x55, 0x33, 0x55, 0xca, 0x6c, 0x4a, 0x6c, 0xde, 0x6c, 0x4a, 0x6c, 0xe8,
    0x6a, 0x41, 0x52, 0xeb, 0x80, 0x57, 0x68, 0xeb, 0x8c, 0x63, 0x74, 0xdc,
    0x80, 0x57, 0x68, 0xca, 0x9f, 0x17, 0x17, 0xb5, 0xb5, 0x2d, 0x2d, 0xa1,
    0xb5, 0x2d, 0x2d, 0x89, 0xd2, 0x06, 0x06, 0x75, 0xd6, 0x00, 0x00, 0x62,
    0xe2, 0x00, 0x03, 0x56, 0xe9, 0x0a, 0x12, 0x44, 0xef, 0x10, 0x18, 0x36,
    0xe7, 0x1e, 0x20, 0x27, 0xea, 0x3f, 0x3e, 0x1f, 0xed, 0x60, 0x5b, 0x16,
    0xf0, 0x80, 0x79, 0x0e, 0x7c, 0x95, 0xae, 0x0a, 0x5f, 0x78, 0x91, 0x10,
    0x5f, 0x78, 0x91, 0x17, 0x45, 0x5e, 0x77, 0x1f, 0x40, 0x51, 0x73, 0x29,
    0x26, 0x37, 0x59, 0x37, 0x1e, 0x0d, 0x40, 0x41, 0x00, 0x00, 0x09, 0x4f,
    0x13, 0x13, 0x46, 0x65, 0x13, 0x13, 0x46, 0x74, 0x33, 0x33, 0x66, 0x83,
    0x13, 0x13, 0x46, 0x9e, 0x3e, 0x1c, 0x3e, 0xb1, 0x55, 0x33, 0x55, 0xc0,
    0x55, 0x33, 0x55, 0xca, 0x6c, 0x4a, 0x6c, 0xde, 0x76, 0x4d, 0x5e, 0xdc,
    0x6a, 0x41, 0x52, 0xdc, 0x80, 0x57, 0x68, 0xd3, 0x8c, 0x63, 0x74, 0xc1,
    0xb5, 0x2d, 0x2d, 0xa9, 0x9f, 0x17, 0x17, 0x95, 0xd2, 0x06, 0x06, 0x89,
    0xd2, 0x06, 0x06, 0x75, 0xd6, 0x00, 0x00, 0x62, 0xec, 0x05, 0x0d, 0x4e,
    0xe9, 0x0a, 0x12, 0x44, 0xef, 0x10, 0x18, 0x36, 0xe8, 0x1e, 0x1f, 0x27,
    0xeb, 0x3e, 0x3d, 0x1f, 0xee, 0x5f, 0x5a, 0x16, 0xf1, 0x80, 0x78, 0x0e,
    0x6f, 0x67, 0x88, 0x0a, 0x5b, 0x53, 0x74, 0x0d, 0x49, 0x41, 0x62, 0x12,
    0x35, 0x2d, 0x4e, 0x1c, 0x26, 0x37, 0x59, 0x23, 0x26, 0x37, 0x59, 0x2f,
    0x3b, 0x2a, 0x5d, 0x41, 0x04, 0x00, 0x26, 0x4f, 0x33, 0x00, 0x11, 0x59,
    0x33, 0x33, 0x66, 0x6b, 0x33, 0x33, 0x66, 0x83, 0x33, 0x33, 0x66, 0x92,
    0x55, 0x33, 0x55, 0xa7, 0x55, 0x33, 0x55, 0xb1, 0x77, 0x33, 0x55, 0xc0,
    0x77, 0x33, 0x55, 0xca, 0x8f, 0x34, 0x55, 0xca, 0x8f, 0x34, 0x55, 0xca,
    0x8f, 0x34, 0x55, 0xc1, 0xa5, 0x4a, 0x6b, 0xaf, 0xb5, 0x2d, 0x2d, 0xa1,
    0xb5, 0x2d, 0x2d, 0x95, 0xd2, 0x06, 0x06, 0x7d, 0xd2, 0x06, 0x06, 0x69,
    0xe2, 0x00, 0x03, 0x5c, 0xec, 0x05, 0x0d, 0x4e, 0xe5, 0x06, 0x0e, 0x3c,
    0xef, 0x10, 0x18, 0x30, 0xe9, 0x1d, 0x1e, 0x27, 0xec, 0x3e, 0x3c, 0x1c,
    0xef, 0x5f, 0x59, 0x13, 0xf2, 0x7f, 0x77, 0x0e, 0x6f, 0x67, 0x88, 0x0a,
    0x5b, 0x53, 0x74, 0x0d, 0x49, 0x41, 0x62, 0x12, 0x35, 0x2d, 0x4e, 0x19,
    0x09, 0x1a, 0x3c, 0x23, 0x26, 0x37, 0x59, 0x2f, 0x3b, 0x2a, 0x5d, 0x37,
    0x1e, 0x0d, 0x40, 0x49, 0x33, 0x00, 0x11, 0x59, 0x33, 0x00, 0x11, 0x65,
    0x33, 0x33, 0x66, 0x74, 0x53, 0x53, 0x86, 0x83, 0x55, 0x33, 0x55, 0x93,
    0x6c, 0x4a, 0x6c, 0xa7, 0x77, 0x33, 0x55, 0xb1, 0x77, 0x33, 0x55, 0xb1,
    0x83, 0x28, 0x49, 0xb8, 0x99, 0x3e, 0x5f, 0xb8, 0x99, 0x3e, 0x5f, 0xaf,
    0x8f, 0x34, 0x55, 0xa0, 0xb5, 0x2d, 0x2d, 0x95, 0xb5, 0x2d, 0x2d, 0x89,
    0xd2, 0x06, 0x06, 0x75, 0xd2, 0x06, 0x06, 0x69, 0xe2, 0x00, 0x03, 0x56,
    0xec, 0x05, 0x0d, 0x44, 0xe5, 0x06, 0x0e, 0x3c, 0xe9, 0x0a, 0x12, 0x30,
    0xea, 0x1d, 0x1d, 0x22, 0xed, 0x3d, 0x3b, 0x19, 0xf0, 0x5e, 0x58, 0x13,
    0xf3, 0x7f, 0x76, 0x0e, 0x7c, 0x74, 0x95, 0x08, 0x56, 0x4e, 0x6f, 0x0b,
    0x62, 0x49, 0x7b, 0x11, 0x4e, 0x35, 0x67, 0x16, 0x44, 0x33, 0x66, 0x21,
    0x34, 0x23, 0x56, 0x29, 0x44, 0x33, 0x66, 0x33, 0x44, 0x33, 0x66, 0x41,
    0x56, 0x23, 0x56, 0x51, 0x67, 0x00, 0x01, 0x5d, 0x56, 0x23, 0x56, 0x69,
    0x76, 0x43, 0x76, 0x75, 0x8d, 0x4b, 0x6c, 0x83, 0x67, 0x25, 0x46, 0x92,
    0x8d, 0x4b, 0x6c, 0x9e, 0x7b, 0x39, 0x5a, 0x9e, 0x9f, 0x28, 0x39, 0xa2,
    0x9f, 0x28, 0x39, 0xa2, 0x9f, 0x28, 0x39, 0x99, 0xb5, 0x0b, 0x0b, 0x90,
    0xc1, 0x00, 0x00, 0x87, 0xe7, 0x11, 0x11, 0x7b, 0xdf, 0x00, 0x00, 0x67,
    0xe9, 0x02, 0x0a, 0x5b, 0xeb, 0x00, 0x04, 0x4f, 0xec, 0x05, 0x0a, 0x3f,
    0xed, 0x0a, 0x10, 0x33, 0xee, 0x0f, 0x16, 0x27, 0xeb, 0x1c, 0x1c, 0x1e,
    0xec, 0x3c, 0x3b, 0x17, 0xed, 0x5c, 0x59, 0x12, 0xee, 0x7b, 0x78, 0x0b,
    0x90, 0x88, 0xa9, 0x05, 0x56, 0x4e, 0x6f, 0x0b, 0x4e, 0x35, 0x67, 0x0e,
    0x4e, 0x35, 0x67, 0x14, 0x44, 0x33, 0x66, 0x1b, 0x34, 0x23, 0x56, 0x21,
    0x34, 0x23, 0x56, 0x29, 0x54, 0x43, 0x76, 0x3b, 0x76, 0x43, 0x76, 0x45,
    0x87, 0x10, 0x21, 0x51, 0x87, 0x10, 0x21, 0x5d, 0x76, 0x43, 0x76, 0x69,
    0x8d, 0x4b, 0x6c, 0x74, 0x8d, 0x4b, 0x6c, 0x83, 0x7b, 0x39, 0x5a, 0x8c,
    0x8d, 0x4b, 0x6c, 0x8c, 0x9f, 0x28, 0x39, 0x90, 0x9f, 0x28, 0x39, 0x8a,
    0xb5, 0x0b, 0x0b, 0x8a, 0xb5, 0x0b, 0x0b, 0x7b, 0xc1, 0x00, 0x00, 0x73,
    0xd5, 0x00, 0x00, 0x67, 0xe5, 0x00, 0x06, 0x5b, 0xe5, 0x00, 0x06, 0x4f,
    0xe9, 0x01, 0x05, 0x45, 0xea, 0x06, 0x0b, 0x39, 0xeb, 0x0b, 0x11, 0x2d,
    0xec, 0x10, 0x17, 0x27, 0xeb, 0x1c, 0x1c, 0x1b, 0xec, 0x3b, 0x3b, 0x12,
    0xed, 0x5b, 0x59, 0x0e, 0xee, 0x7b, 0x78, 0x0b, 0x90, 0x88, 0xa9, 0x05,
    0x6a, 0x62, 0x83, 0x08, 0x4e, 0x35, 0x67, 0x0b, 0x62, 0x49, 0x7b, 0x11,
    0x54, 0x43, 0x76, 0x15, 0x54, 0x43, 0x76, 0x21, 0x66, 0x11, 0x55, 0x29,
    0x54, 0x43, 0x76, 0x33, 0x76, 0x43, 0x76, 0x39, 0x76, 0x43, 0x76, 0x45,
    0x87, 0x10, 0x21, 0x51, 0x87, 0x10, 0x21, 0x5d, 0xad, 0x32, 0x53, 0x65,
    0xad, 0x32, 0x53, 0x6b, 0x97, 0x1c, 0x3d, 0x74, 0xa1, 0x26, 0x47, 0x74,
    0x9f, 0x28, 0x39, 0x7b, 0x9f, 0x28, 0x39, 0x75, 0xc1, 0x17, 0x17, 0x75,
    0xb5, 0x0b, 0x0b, 0x6c, 0xd5, 0x00, 0x00, 0x67, 0xd5, 0x00, 0x00, 0x5b,
    0xe5, 0x00, 0x06, 0x4f, 0xe5, 0x00, 0x06, 0x47, 0xe7, 0x01, 0x06, 0x39,
    0xe8, 0x06, 0x0c, 0x33, 0xe9, 0x0b, 0x12, 0x27, 0xea, 0x10, 0x18, 0x1d,
    0xeb, 0x1b, 0x1c, 0x17, 0xec, 0x3b, 0x3b, 0x12, 0xed, 0x5b, 0x59, 0x0b,
    0xee, 0x7a, 0x78, 0x08, 0x90, 0x88, 0xa9, 0x05, 0x7c, 0x74, 0x95, 0x08,
    0x62, 0x49, 0x7b, 0x0b, 0x62, 0x49, 0x7b, 0x0e, 0x54, 0x43, 0x76, 0x15,
    0x54, 0x43, 0x76, 0x1b, 0x66, 0x11, 0x55, 0x21, 0x66, 0x11, 0x55, 0x29,
    0x76, 0x43, 0x76, 0x31, 0x76, 0x43, 0x76, 0x39, 0x87, 0x10, 0x21, 0x45,
    0x87, 0x10, 0x21, 0x51, 0x8b, 0x10, 0x31, 0x59, 0xa1, 0x26, 0x47, 0x59,
    0xa1, 0x26, 0x47, 0x65, 0x8b, 0x10, 0x31, 0x65, 0xb5, 0x0b, 0x0b, 0x63,
    0xc1, 0x17, 0x17, 0x63, 0xc1, 0x17, 0x17, 0x63, 0xc1, 0x17, 0x17, 0x63,
    0xd5, 0x00, 0x00, 0x5b, 0xd5, 0x00, 0x00, 0x4f, 0xdf, 0x00, 0x00, 0x47,
    0xdf, 0x00, 0x00, 0x3b, 0xe5, 0x02, 0x07, 0x33, 0xe6, 0x07, 0x0d, 0x27,
    0xe7, 0x0c, 0x13, 0x1d, 0xe8, 0x11, 0x19, 0x1d, 0xeb, 0x1b, 0x1c, 0x12,
    0xec, 0x3a, 0x3b, 0x0e, 0xed, 0x5a, 0x59, 0x0b, 0xee, 0x7a, 0x78, 0x08,
    0x9e, 0x86, 0xa7, 0x02, 0x9a, 0x82, 0xa3, 0x05, 0x8f, 0x56, 0x7f, 0x08,
    0x72, 0x39, 0x62, 0x0b, 0x71, 0x3c, 0x75, 0x11, 0x75, 0x31, 0x68, 0x16,
    0x7a, 0x26, 0x5b, 0x1a, 0x7e, 0x1b, 0x4e, 0x20, 0x82, 0x1c, 0x4f, 0x29,
    0x8e, 0x28, 0x5b, 0x33, 0x8e, 0x28, 0x5b, 0x3b, 0xa4, 0x1c, 0x1c, 0x41,
    0xb3, 0x0e, 0x0e, 0x45, 0xad, 0x08, 0x08, 0x4b, 0xbd, 0x18, 0x18, 0x54,
    0xb7, 0x12, 0x12, 0x54, 0xbd, 0x00, 0x00, 0x55, 0xc9, 0x03, 0x0b, 0x55,
    0xd6, 0x00, 0x08, 0x4f, 0xd6, 0x00, 0x08, 0x4f, 0xdb, 0x00, 0x08, 0x48,
    0xdd, 0x01, 0x07, 0x3e, 0xdf, 0x02, 0x06, 0x38, 0xe1, 0x03, 0x05, 0x32,
    0xe3, 0x00, 0x00, 0x27, 0xe5, 0x07, 0x0a, 0x21, 0xe7, 0x0e, 0x14, 0x1b,
    0xe9, 0x15, 0x1e, 0x15, 0xeb, 0x26, 0x24, 0x0f, 0xed, 0x46, 0x42, 0x0c,
    0xef, 0x66, 0x5f, 0x09, 0xf1, 0x85, 0x7d, 0x06, 0x9a, 0x82, 0xa3, 0x02,
    0xa4, 0x8c, 0xad, 0x05, 0xa9, 0x70, 0x99, 0x05, 0x8f, 0x56, 0x7f, 0x08,
    0x83, 0x3f, 0x6a, 0x0d, 0x88, 0x34, 0x5d, 0x11, 0x8c, 0x29, 0x50, 0x16,
    0x90, 0x1e, 0x43, 0x1a, 0xa4, 0x1c, 0x1c, 0x21, 0xa4, 0x1c, 0x1c, 0x29,
    0xb0, 0x28, 0x28, 0x29, 0xa4, 0x1c, 0x1c, 0x33, 0xad, 0x08, 0x08, 0x3c,
    0xbd, 0x18, 0x18, 0x3c, 0xbd, 0x18, 0x18, 0x45, 0xb3, 0x0e, 0x0e, 0x45,
    0xc9, 0x03, 0x0b, 0x41, 0xc9, 0x03, 0x0b, 0x41, 0xd6, 0x00, 0x08, 0x41,
    0xdc, 0x06, 0x0e, 0x41, 0xdc, 0x05, 0x0c, 0x38, 0xde, 0x06, 0x0b, 0x32,
    0xe0, 0x07, 0x0a, 0x2c, 0xe2, 0x08, 0x09, 0x26, 0xe2, 0x04, 0x03, 0x21,
    0xe4, 0x0b, 0x0d, 0x1b, 0xe6, 0x12, 0x17, 0x15, 0xe8, 0x19, 0x21, 0x11,
    0xe9, 0x31, 0x2b, 0x0c, 0xeb, 0x51, 0x49, 0x09, 0xed, 0x71, 0x66, 0x06,
    0xef, 0x90, 0x84, 0x03, 0xa4, 0x8c, 0xad, 0x02, 0x94, 0x7c, 0x9d, 0x02,
    0xa9, 0x70, 0x99, 0x05, 0x8f, 0x56, 0x7f, 0x08, 0x96, 0x41, 0x5f, 0x0a,
    0x9a, 0x36, 0x52, 0x0d, 0x9e, 0x2b, 0x45, 0x11, 0xa2, 0x20, 0x38, 0x16,
    0xa4, 0x1c, 0x1c, 0x1b, 0xa4, 0x1c, 0x1c, 0x21, 0xb0, 0x28, 0x28, 0x21,
    0xb0, 0x28, 0x28, 0x29, 0xcc, 0x0e, 0x0e, 0x2a, 0xcc, 0x0e, 0x0e, 0x33,
    0xcc, 0x0e, 0x0e, 0x33, 0xd0, 0x12, 0x12, 0x33, 0xd3, 0x0d, 0x15, 0x37,
    0xd3, 0x0d, 0x15, 0x37, 0xe6, 0x10, 0x18, 0x37, 0xdc, 0x06, 0x0e, 0x2f,
    0xdd, 0x09, 0x10, 0x2c, 0xdf, 0x0a, 0x0f, 0x2c, 0xe1, 0x0b, 0x0e, 0x26,
    0xe3, 0x0c, 0x0d, 0x20, 0xe1, 0x08, 0x06, 0x1b, 0xe3, 0x0f, 0x10, 0x15,
    0xe5, 0x16, 0x1a, 0x11, 0xe7, 0x1d, 0x24, 0x0b, 0xe7, 0x3c, 0x33, 0x09,
    0xe9, 0x5c, 0x50, 0x06, 0xeb, 0x7c, 0x6e, 0x03, 0xed, 0x9b, 0x8b, 0x03,
    0xa4, 0x8c, 0xad, 0x02, 0x94, 0x7c, 0x9d, 0x02, 0xa9, 0x70, 0x99, 0x02,
    0x8f, 0x56, 0x7f, 0x05, 0xa8, 0x44, 0x54, 0x07, 0xac, 0x39, 0x47, 0x0a,
    0xb0, 0x2e, 0x3a, 0x0d, 0xb5, 0x23, 0x2d, 0x11, 0xa4, 0x1c, 0x1c, 0x15,
    0xb0, 0x28, 0x28, 0x15, 0xb0, 0x28, 0x28, 0x1b, 0xb0, 0x28, 0x28, 0x21,
    0xd6, 0x18, 0x18, 0x24, 0xd0, 0x12, 0x12, 0x24, 0xd6, 0x18, 0x18, 0x2a,
    0xd6, 0x18, 0x18, 0x2a, 0xdf, 0x19, 0x21, 0x29, 0xdf, 0x19, 0x21, 0x29,
    0xe6, 0x10, 0x18, 0x29, 0xe6, 0x10, 0x18, 0x23, 0xde, 0x0e, 0x14, 0x26,
    0xe0, 0x0f, 0x13, 0x20, 0xe2, 0x10, 0x12, 0x20, 0xe4, 0x11, 0x11, 0x16,
    0xe0, 0x0c, 0x09, 0x15, 0xe2, 0x13, 0x13, 0x11, 0xe4, 0x1a, 0x1d, 0x0b,
    0xe6, 0x21, 0x27, 0x0b, 0xe5, 0x47, 0x3a, 0x06, 0xe7, 0x67, 0x57, 0x06,
    0xe9, 0x87, 0x75, 0x03, 0xeb, 0xa6, 0x92, 0x03, 0xd5, 0x8b, 0x83, 0x01,
    0xc1, 0x77, 0x6f, 0x01, 0xb9, 0x56, 0x56, 0x02, 0xb9, 0x56, 0x56, 0x03,
    0xcd, 0x49, 0x49, 0x05, 0xcd, 0x49, 0x49, 0x08, 0xb9, 0x35, 0x35, 0x08,
    0xb9, 0x35, 0x35, 0x0c, 0xcb, 0x2e, 0x2c, 0x0e, 0xcb, 0x2c, 0x2c, 0x11,
    0xcb, 0x2a, 0x2c, 0x14, 0xcb, 0x28, 0x2c, 0x16, 0xd7, 0x20, 0x24, 0x18,
    0xda, 0x20, 0x23, 0x1d, 0xdd, 0x1f, 0x22, 0x1d, 0xe0, 0x1f, 0x21, 0x1d,
    0xe7, 0x22, 0x24, 0x1e, 0xe7, 0x20, 0x24, 0x1e, 0xe7, 0x1d, 0x24, 0x1e,
    0xe7, 0x1b, 0x24, 0x1b, 0xe3, 0x1c, 0x20, 0x19, 0xe3, 0x1c, 0x20, 0x17,
    0xe3, 0x1c, 0x20, 0x14, 0xe3, 0x1c, 0x20, 0x11, 0xdf, 0x1a, 0x20, 0x0f,
    0xe0, 0x23, 0x25, 0x0c, 0xe1, 0x2b, 0x2a, 0x09, 0xe2, 0x34, 0x2f, 0x06,
    0xe3, 0x54, 0x49, 0x05, 0xe4, 0x69, 0x5e, 0x03, 0xe5, 0x7e, 0x74, 0x02,
    0xe6, 0x92, 0x89, 0x01, 0xe7, 0x9d, 0x95, 0x00, 0xd5, 0x8b, 0x83, 0x01,
    0xcd, 0x6a, 0x6a, 0x01, 0xb9, 0x56, 0x56, 0x02, 0xcd, 0x49, 0x49, 0x02,
    0xcd, 0x49, 0x49, 0x05, 0xcd, 0x49, 0x49, 0x05, 0xcd, 0x49, 0x49, 0x08,
    0xd8, 0x46, 0x46, 0x0b, 0xd8, 0x44, 0x46, 0x0b, 0xd8, 0x42, 0x46, 0x0e,
    0xd8, 0x40, 0x46, 0x11, 0xdd, 0x3c, 0x3f, 0x12, 0xe0, 0x3b, 0x3e, 0x15,
    0xe3, 0x3b, 0x3d, 0x15, 0xe6, 0x3a, 0x3c, 0x18, 0xe9, 0x3d, 0x3c, 0x16,
    0xe9, 0x3a, 0x3c, 0x16, 0xe9, 0x38, 0x3c, 0x16, 0xe9, 0x35, 0x3c, 0x13,
    0xe7, 0x36, 0x3b, 0x11, 0xe7, 0x36, 0x3b, 0x11, 0xe7, 0x36, 0x3b, 0x0e,
    0xe7, 0x36, 0x3b, 0x0b, 0xe3, 0x34, 0x3a, 0x09, 0xe4, 0x3d, 0x3f, 0x09,
    0xe5, 0x45, 0x44, 0x06, 0xe6, 0x4e, 0x49, 0x04, 0xe6, 0x63, 0x59, 0x03,
    0xe7, 0x78, 0x6f, 0x02, 0xe8, 0x8d, 0x84, 0x01, 0xe9, 0xa2, 0x99, 0x01,
    0xfb, 0xb1, 0xa9, 0x00, 0xe7, 0x9d, 0x95, 0x00, 0xdf, 0x7c, 0x7c, 0x01,
    0xcd, 0x6a, 0x6a, 0x01, 0xe2, 0x66, 0x66, 0x02, 0xe2, 0x66, 0x66, 0x02,
    0xe2, 0x66, 0x66, 0x05, 0xe2, 0x66, 0x66, 0x05, 0xe5, 0x5f, 0x5f, 0x08,
    0xe5, 0x5d, 0x5f, 0x08, 0xe5, 0x5b, 0x5f, 0x0b, 0xe5, 0x59, 0x5f, 0x0b,
    0xe3, 0x58, 0x59, 0x0c, 0xe6, 0x57, 0x58, 0x0f, 0xe9, 0x57, 0x57, 0x0f,
    0xec, 0x56, 0x56, 0x0f, 0xeb, 0x58, 0x53, 0x10, 0xeb, 0x55, 0x53, 0x10,
    0xeb, 0x53, 0x53, 0x10, 0xeb, 0x50, 0x53, 0x10, 0xeb, 0x51, 0x55, 0x0e,
    0xeb, 0x51, 0x55, 0x0b, 0xeb, 0x51, 0x55, 0x0b, 0xeb, 0x51, 0x55, 0x08,
    0xe7, 0x4f, 0x53, 0x06, 0xe8, 0x57, 0x58, 0x06, 0xe9, 0x60, 0x5d, 0x04,
    0xea, 0x68, 0x62, 0x04, 0xe9, 0x73, 0x6a, 0x02, 0xea, 0x87, 0x7f, 0x01,
    0xeb, 0x9c, 0x94, 0x01, 0xec, 0xb1, 0xa9, 0x00, 0xfb, 0xb1, 0xa9, 0x00,
    0xfb, 0xb1, 0xa9, 0x00, 0xf3, 0x90, 0x90, 0x00, 0xf3, 0x90, 0x90, 0x01,
    0xf8, 0x7c, 0x7c, 0x02, 0xf8, 0x7c, 0x7c, 0x02, 0xf8, 0x7c, 0x7c, 0x02,
    0xf8, 0x7c, 0x7c, 0x02, 0xf2, 0x77, 0x79, 0x05, 0xf2, 0x75, 0x79, 0x05,
    0xf2, 0x73, 0x79, 0x05, 0xf2, 0x71, 0x79, 0x08, 0xe9, 0x73, 0x74, 0x09,
    0xec, 0x73, 0x73, 0x09, 0xef, 0x72, 0x72, 0x09, 0xf2, 0x72, 0x71, 0x09,
    0xed, 0x72, 0x6b, 0x0a, 0xed, 0x70, 0x6b, 0x0a, 0xed, 0x6d, 0x6b, 0x0a,
    0xed, 0x6b, 0x6b, 0x0a, 0xef, 0x6b, 0x70, 0x08, 0xef, 0x6b, 0x70, 0x08,
    0xef, 0x6b, 0x70, 0x06, 0xef, 0x6b, 0x70, 0x06, 0xeb, 0x69, 0x6d, 0x04,
    0xec, 0x71, 0x72, 0x04, 0xed, 0x7a, 0x77, 0x01, 0xee, 0x82, 0x7c, 0x01,
    0xec, 0x82, 0x7a, 0x01, 0xed, 0x97, 0x8f, 0x01, 0xee, 0xab, 0xa4, 0x00,
    0xef, 0xc0, 0xba, 0x00,
  ]),
};
