/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * This file is used to temporarily disable newly added stylelint rules for existing files.
 * This allows us to enable new stylelint rules immediately for newly added files,
 * without having to fix errors in existing files.
 *
 * Newly added style files should NOT be added to this list,
 * and existing files should be removed from this list as they are fixed.
 */
module.exports = [
  {
    name: "rollout-use-border-radius-tokens",
    rules: {
      "stylelint-plugin-mozilla/use-border-radius-tokens": null,
    },
    files: [
      "browser/base/content/sanitizeDialog.css",
      "browser/components/aboutlogins/content/components/confirmation-dialog.css",
      "browser/components/aboutlogins/content/components/generic-dialog.css",
      "browser/components/aboutlogins/content/components/remove-logins-dialog.css",
      "browser/components/aboutwelcome/content-src/aboutwelcome.scss",
      "browser/components/asrouter/content-src/components/ASRouterAdmin/ASRouterAdmin.scss",
      "browser/components/asrouter/content-src/styles/_feature-callout.scss",
      "browser/components/contextualidentity/content/usercontext.css",
      "browser/components/firefoxview/card-container.css",
      "browser/components/firefoxview/view-syncedtabs.css",
      "browser/components/genai/content/link-preview-card.css",
      "browser/components/preferences/dialogs/clearSiteData.css",
      "browser/components/profiles/content/profile-card.css",
      "browser/components/profiles/content/profiles-theme-card.css",
      "browser/components/protections/content/protections.css",
      "browser/components/screenshots/overlay/overlay.css",
      "browser/components/screenshots/screenshots-buttons.css",
      "browser/components/search/test/browser/telemetry/serp.css",
      "browser/components/textrecognition/textrecognition.css",
      "browser/components/urlbar/tests/browser/dynamicResult0.css",
      "browser/components/urlbar/tests/browser/dynamicResult1.css",
      "browser/extensions/formautofill/content/manageDialog.css",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/TopicSelection/_TopicSelection.scss",
      "browser/fxr/content/fxrui.css",
      "browser/fxr/content/prefs.css",
      "browser/themes/linux/browser.css",
      "browser/themes/osx/browser.css",
      "browser/themes/osx/customizableui/panelUI.css",
      "browser/themes/shared/UITour.css",
      "browser/themes/shared/aboutTabCrashed.css",
      "browser/themes/shared/addons/unified-extensions.css",
      "browser/themes/shared/browser-shared.css",
      "browser/themes/shared/controlcenter/panel.css",
      "browser/themes/shared/customizableui/customizeMode.css",
      "browser/themes/shared/customizableui/panelUI-shared.css",
      "browser/themes/shared/downloads/progressmeter.css",
      "browser/themes/shared/formautofill-notification.css",
      "browser/themes/shared/identity-block/identity-block.css",
      "browser/themes/shared/migration/migration-wizard.css",
      "browser/themes/shared/notification-icons.css",
      "browser/themes/shared/pageInfo.css",
      "browser/themes/shared/places/sidebar.css",
      "browser/themes/shared/preferences/preferences.css",
      "browser/themes/shared/preferences/privacy.css",
      "browser/themes/shared/privatebrowsing/aboutPrivateBrowsing.css",
      "browser/themes/shared/sanitizeDialog_v2.css",
      "browser/themes/shared/search/searchbar.css",
      "browser/themes/shared/sidebar.css",
      "browser/themes/shared/syncedtabs/sidebar.css",
      "browser/themes/shared/tabbrowser/ctrlTab.css",
      "browser/themes/shared/tabbrowser/tabs.css",
      "browser/themes/shared/toolbarbuttons.css",
      "browser/themes/shared/urlbar-dynamic-results.css",
      "browser/themes/shared/urlbar-searchbar.css",
      "browser/themes/shared/urlbarView.css",
      "browser/themes/shared/webRTC-indicator.css",
      "browser/themes/windows/downloads/allDownloadsView.css",
      "docs/_static/custom_theme.css",
      "layout/style/res/forms.css",
      "mobile/android/android-components/components/browser/errorpages/src/main/assets/error_style.css",
      "mobile/android/fenix/app/src/main/assets/shared_error_style.css",
      "mobile/android/focus-android/app/src/main/assets/error_style.css",
      "mobile/android/themes/geckoview/config.css",
      "security/manager/pki/resources/content/clientauthask.css",
      "toolkit/components/aboutinference/content/aboutInference.css",
      "toolkit/components/normandy/content/about-studies/about-studies.css",
      "toolkit/components/printing/content/printPagination.css",
      "toolkit/components/satchel/megalist/content/components/login-line/login-line.css",
      "toolkit/content/aboutTelemetry.css",
      "toolkit/content/aboutwebrtc/aboutWebrtc.css",
      "toolkit/content/widgets/datetimebox.css",
      "toolkit/content/widgets/moz-visual-picker/moz-visual-picker-item.css",
      "toolkit/content/xul.css",
      "toolkit/mozapps/extensions/content/aboutaddons.css",
      "toolkit/mozapps/extensions/content/shortcuts.css",
      "toolkit/themes/mobile/global/aboutMemory.css",
      "toolkit/themes/shared/aboutReader.css",
      "toolkit/themes/shared/aboutServiceWorkers.css",
      "toolkit/themes/shared/alert.css",
      "toolkit/themes/shared/datetimeinputpickers.css",
      "toolkit/themes/shared/design-system/tokens-table.css",
      "toolkit/themes/shared/dirListing/dirListing.css",
      "toolkit/themes/shared/global-shared.css",
      "toolkit/themes/shared/in-content/common-shared.css",
      "toolkit/themes/shared/media/pipToggle.css",
      "toolkit/themes/shared/media/videocontrols.css",
      "toolkit/themes/shared/menu.css",
      "toolkit/themes/shared/pictureinpicture/player.css",
      "toolkit/themes/shared/popup.css",
      "toolkit/themes/shared/toolbarbutton.css",
      "toolkit/themes/shared/tree/tree.css",
    ],
  },
];
