/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

use std::path::Path;

fn main() {
    set_generated_files();
    set_coverage_cfg();
}

/// Set the GLEAN_METRICS_FILE and CONVERSIONS_FILE environment variables to the locations of the
/// generated files.
///
/// We do this here to avoid a hardcoded path in the source (just in case this crate's src dir
/// moves, not that it's likely).
fn set_generated_files() {
    let full_path = Path::new(env!("CARGO_MANIFEST_DIR"));
    let relative_path = full_path
        .strip_prefix(mozbuild::TOPSRCDIR)
        .expect("CARGO_MANIFEST_DIR not a child of TOPSRCDIR");

    for (file, env) in [
        // Generated by glean_rust.py
        ("glean_metrics.rs", "GLEAN_METRICS_FILE"),
        // Generated by conversions.py
        ("conversions.rs", "CONVERSIONS_FILE"),
    ] {
        let objpath = mozbuild::TOPOBJDIR.join(relative_path).join(file);
        // We don't really need anything like `rerun-if-env-changed=CARGO_MANIFEST_DIR` because that
        // will inevitably mean the entire crate has moved or the srcdir has moved, which would result
        // in a rebuild anyway.
        println!("cargo:rustc-env={env}={}", objpath.display());
    }
}

fn set_coverage_cfg() {
    println!("cargo:rustc-check-cfg=cfg(ccov)");
    if mozbuild::config::MOZ_CODE_COVERAGE {
        println!("cargo:rustc-cfg=ccov");
    }
}
