// generated by diplomat-tool
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `EastAsianWidth`](https://docs.rs/icu/latest/icu/properties/props/struct.EastAsianWidth.html) for more information.
 */


export class EastAsianWidth {
    #value = undefined;

    static #values = new Map([
        ["Neutral", 0],
        ["Ambiguous", 1],
        ["Halfwidth", 2],
        ["Fullwidth", 3],
        ["Narrow", 4],
        ["Wide", 5]
    ]);

    static getAllEntries() {
        return EastAsianWidth.#values.entries();
    }

    #internalConstructor(value) {
        if (arguments.length > 1 && arguments[0] === diplomatRuntime.internalConstructor) {
            // We pass in two internalConstructor arguments to create *new*
            // instances of this type, otherwise the enums are treated as singletons.
            if (arguments[1] === diplomatRuntime.internalConstructor ) {
                this.#value = arguments[2];
                return this;
            }
            return EastAsianWidth.#objectValues[arguments[1]];
        }

        if (value instanceof EastAsianWidth) {
            return value;
        }

        let intVal = EastAsianWidth.#values.get(value);

        // Nullish check, checks for null or undefined
        if (intVal != null) {
            return EastAsianWidth.#objectValues[intVal];
        }

        throw TypeError(value + " is not a EastAsianWidth and does not correspond to any of its enumerator values.");
    }

    static fromValue(value) {
        return new EastAsianWidth(value);
    }

    get value(){
        return [...EastAsianWidth.#values.keys()][this.#value];
    }

    get ffiValue(){
        return this.#value;
    }
    static #objectValues = [
        new EastAsianWidth(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 0),
        new EastAsianWidth(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 1),
        new EastAsianWidth(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 2),
        new EastAsianWidth(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 3),
        new EastAsianWidth(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 4),
        new EastAsianWidth(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 5),
    ];

    static Neutral = EastAsianWidth.#objectValues[0];
    static Ambiguous = EastAsianWidth.#objectValues[1];
    static Halfwidth = EastAsianWidth.#objectValues[2];
    static Fullwidth = EastAsianWidth.#objectValues[3];
    static Narrow = EastAsianWidth.#objectValues[4];
    static Wide = EastAsianWidth.#objectValues[5];


    /**
     * See the [Rust documentation for `for_char`](https://docs.rs/icu/latest/icu/properties/props/trait.EnumeratedProperty.html#tymethod.for_char) for more information.
     */
    static forChar(ch) {

        const result = wasm.icu4x_EastAsianWidth_for_char_mv1(ch);

        try {
            return new EastAsianWidth(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    /**
     * Get the "long" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesLongBorrowed.html#method.get) for more information.
     */
    longName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_EastAsianWidth_long_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Get the "short" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesShortBorrowed.html#method.get) for more information.
     */
    shortName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_EastAsianWidth_short_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Convert to an integer value usable with ICU4C and CodePointMapData
     *
     * See the [Rust documentation for `to_icu4c_value`](https://docs.rs/icu/latest/icu/properties/props/struct.EastAsianWidth.html#method.to_icu4c_value) for more information.
     */
    toIntegerValue() {

        const result = wasm.icu4x_EastAsianWidth_to_integer_value_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Convert from an integer value from ICU4C or CodePointMapData
     *
     * See the [Rust documentation for `from_icu4c_value`](https://docs.rs/icu/latest/icu/properties/props/struct.EastAsianWidth.html#method.from_icu4c_value) for more information.
     */
    static fromIntegerValue(other) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_EastAsianWidth_from_integer_value_mv1(diplomatReceive.buffer, other);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new EastAsianWidth(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
        }

        finally {
            diplomatReceive.free();
        }
    }

    constructor(value) {
        return this.#internalConstructor(...arguments)
    }
}