/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

package org.mozilla.fenix.onboarding.store

import mozilla.components.lib.state.Middleware
import mozilla.components.lib.state.Store
import org.mozilla.fenix.GleanMetrics.Onboarding

/**
 * [Middleware] for recording telemetry based on [PrivacyPreferencesAction]s.
 */
class PrivacyPreferencesTelemetryMiddleware :
    Middleware<PrivacyPreferencesState, PrivacyPreferencesAction> {
    override fun invoke(
        store: Store<PrivacyPreferencesState, PrivacyPreferencesAction>,
        next: (PrivacyPreferencesAction) -> Unit,
        action: PrivacyPreferencesAction,
    ) {
        next(action)

        when (action) {
            is PrivacyPreferencesAction.CrashReportingPreferenceUpdatedTo ->
                Onboarding.privacyPreferencesModalCrashReportingEnabled.record(
                    Onboarding.PrivacyPreferencesModalCrashReportingEnabledExtra(action.enabled),
                )

            is PrivacyPreferencesAction.UsageDataPreferenceUpdatedTo ->
                Onboarding.privacyPreferencesModalUsageDataEnabled.record(
                    Onboarding.PrivacyPreferencesModalUsageDataEnabledExtra(action.enabled),
                )

            is PrivacyPreferencesAction.CrashReportingLearnMore ->
                Onboarding.privacyPreferencesModalCrashReportingLearnMore.record()

            is PrivacyPreferencesAction.UsageDataUserLearnMore ->
                Onboarding.privacyPreferencesModalUsageDataLearnMore.record()

            // no-ops
            is PrivacyPreferencesAction.Init -> {}
        }
    }
}
