/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

add_task(async function test_auth_switchtab() {
  let tab = BrowserTestUtils.addTab(gBrowser);
  // initial about:blank won't be canceled by subsequent load. So ensure it is
  // finished. Otherwise, locationchange notification from content can cancel
  // the auth dialog opened in the parent
  await BrowserTestUtils.browserLoaded(tab.linkedBrowser, {
    wantLoad: "about:blank",
  });
  isnot(tab, gBrowser.selectedTab, "New tab shouldn't be selected");

  let authPromptShown = PromptTestUtils.waitForPrompt(tab.linkedBrowser, {
    modalType: Ci.nsIPrompt.MODAL_TYPE_TAB,
    promptType: "promptUserAndPass",
  });

  let loadPromise = BrowserTestUtils.browserLoaded(tab.linkedBrowser);
  BrowserTestUtils.startLoadingURIString(
    tab.linkedBrowser,
    "https://example.com/browser/toolkit/components/passwordmgr/test/browser/authenticate.sjs"
  );

  // Wait for the basic auth prompt
  let dialog = await authPromptShown;

  Assert.equal(gBrowser.selectedTab, tab, "Should have selected the new tab");

  // Cancel the auth prompt
  PromptTestUtils.handlePrompt(dialog, { buttonNumClick: 1 });

  // After closing the prompt the load should finish
  await loadPromise;

  gBrowser.removeTab(tab);
});
