// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!

import {
  ArrayBufferDataStream,
  FfiConverter,
  FfiConverterArrayBuffer,
  FfiConverterInt8,
  FfiConverterUInt8,
  FfiConverterInt16,
  FfiConverterUInt16,
  FfiConverterInt32,
  FfiConverterUInt32,
  FfiConverterInt64,
  FfiConverterUInt64,
  FfiConverterFloat32,
  FfiConverterFloat64,
  FfiConverterBoolean,
  FfiConverterBytes,
  FfiConverterString,
  UniFFICallbackHandler,
  UniFFICallbackMethodHandler,
  UniFFIError,
  UniFFIInternalError,
  UniFFITypeError,
  constructUniffiObject,
  handleRustResult,
  uniffiObjectPtr,
} from "moz-src:///toolkit/components/uniffi-js/js/UniFFI.sys.mjs";

// Objects intended to be used in the unit tests
export var UnitTestObjs = {
    uniffiObjectPtr,
};
/**
 * Allow non-HTTPS requests to the emulator loopback URL
 */
export function allowAndroidEmulatorLoopback() {
   
const result = UniFFIScaffolding.callSync(
    140, // uniffi_viaduct_fn_func_allow_android_emulator_loopback
)
return handleRustResult(
    result,
    (result) => undefined,
    null,
)
}

/**
 * initBackend
 * @param {Backend} backend
 */
export function initBackend(
    backend) {
   
FfiConverterTypeBackend.checkType(backend);
const result = UniFFIScaffolding.callSync(
    141, // uniffi_viaduct_fn_func_init_backend
    FfiConverterTypeBackend.lower(backend),
)
return handleRustResult(
    result,
    (result) => undefined,
    FfiConverterTypeViaductError.lift.bind(FfiConverterTypeViaductError),
)
}




/**
 * ClientSettings
 */
export class ClientSettings {
    constructor(
        {
            timeout= 0, 
            redirectLimit= 10
        } = {
            timeout: undefined, 
            redirectLimit: undefined
        }
    ) {
        try {
            FfiConverterUInt32.checkType(timeout)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("timeout");
            }
            throw e;
        }
        try {
            FfiConverterUInt32.checkType(redirectLimit)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("redirectLimit");
            }
            throw e;
        }
        /**
         * timeout
         */
        this.timeout = timeout;
        /**
         * redirectLimit
         */
        this.redirectLimit = redirectLimit;
    }

    equals(other) {
        return (
            this.timeout == other.timeout
            && this.redirectLimit == other.redirectLimit
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeClientSettings extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new ClientSettings({
            timeout: FfiConverterUInt32.read(dataStream),
            redirectLimit: FfiConverterUInt32.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterUInt32.write(dataStream, value.timeout);
        FfiConverterUInt32.write(dataStream, value.redirectLimit);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterUInt32.computeSize(value.timeout);
        totalSize += FfiConverterUInt32.computeSize(value.redirectLimit);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof ClientSettings)) {
            throw new UniFFITypeError(`Expected 'ClientSettings', found '${typeof value}'`);
        }
        try {
            FfiConverterUInt32.checkType(value.timeout);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".timeout");
            }
            throw e;
        }
        try {
            FfiConverterUInt32.checkType(value.redirectLimit);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".redirectLimit");
            }
            throw e;
        }
    }
}

/**
 * HTTP Methods.
 * 
 * The supported methods are the limited to what's supported by android-components.
 */
export const Method = {
    /**
     * GET
     */
    GET: 0,
    /**
     * HEAD
     */
    HEAD: 1,
    /**
     * POST
     */
    POST: 2,
    /**
     * PUT
     */
    PUT: 3,
    /**
     * DELETE
     */
    DELETE: 4,
    /**
     * CONNECT
     */
    CONNECT: 5,
    /**
     * OPTIONS
     */
    OPTIONS: 6,
    /**
     * TRACE
     */
    TRACE: 7,
    /**
     * PATCH
     */
    PATCH: 8,
};
Object.freeze(Method);

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeMethod extends FfiConverterArrayBuffer {
    static #validValues = Object.values(Method)

    static read(dataStream) {
        // Use sequential indices (1-based) for the wire format to match the Rust scaffolding
        switch (dataStream.readInt32()) {
            case 1:
                return Method.GET
            case 2:
                return Method.HEAD
            case 3:
                return Method.POST
            case 4:
                return Method.PUT
            case 5:
                return Method.DELETE
            case 6:
                return Method.CONNECT
            case 7:
                return Method.OPTIONS
            case 8:
                return Method.TRACE
            case 9:
                return Method.PATCH
            default:
                throw new UniFFITypeError("Unknown Method variant");
        }
    }

    static write(dataStream, value) {
        // Use sequential indices (1-based) for the wire format to match the Rust scaffolding
        if (value === Method.GET) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === Method.HEAD) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === Method.POST) {
            dataStream.writeInt32(3);
            return;
        }
        if (value === Method.PUT) {
            dataStream.writeInt32(4);
            return;
        }
        if (value === Method.DELETE) {
            dataStream.writeInt32(5);
            return;
        }
        if (value === Method.CONNECT) {
            dataStream.writeInt32(6);
            return;
        }
        if (value === Method.OPTIONS) {
            dataStream.writeInt32(7);
            return;
        }
        if (value === Method.TRACE) {
            dataStream.writeInt32(8);
            return;
        }
        if (value === Method.PATCH) {
            dataStream.writeInt32(9);
            return;
        }
        throw new UniFFITypeError("Unknown Method variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      // Check that the value is a valid enum variant
      if (!this.#validValues.includes(value)) {
          throw new UniFFITypeError(`${value} is not a valid value for Method`);
      }
    }
}


export class FfiConverterTypeViaductUrl extends FfiConverter {
    static lift(value) {
        return FfiConverterString.lift(value);
    }

    static lower(value) {
        return FfiConverterString.lower(value);
    }

    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value);
    }

    static read(dataStream) {
        const builtinVal = FfiConverterString.read(dataStream);
        return builtinVal;
    }

    static computeSize(value) {
        return FfiConverterString.computeSize(value);
    }

    static checkType(value) {
        if (value === null || value === undefined) {
            throw new TypeError("value is null or undefined");
        }
    }
}
// Export the FFIConverter object to make external types work.
export class FfiConverterMapStringString extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const map = new Map();
        for (let i = 0; i < len; i++) {
            const key = FfiConverterString.read(dataStream);
            const value = FfiConverterString.read(dataStream);
            map.set(key, value);
        }

        return map;
    }

     static write(dataStream, map) {
        dataStream.writeInt32(map.size);
        for (const [key, value] of map) {
            FfiConverterString.write(dataStream, key);
            FfiConverterString.write(dataStream, value);
        }
    }

    static computeSize(map) {
        // The size of the length
        let size = 4;
        for (const [key, value] of map) {
            size += FfiConverterString.computeSize(key);
            size += FfiConverterString.computeSize(value);
        }
        return size;
    }

    static checkType(map) {
        for (const [key, value] of map) {
            try {
                FfiConverterString.checkType(key);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("(key)");
                }
                throw e;
            }

            try {
                FfiConverterString.checkType(value);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${key}]`);
                }
                throw e;
            }
        }
    }
}
export class FfiConverterTypeHeaders extends FfiConverter {
    static lift(value) {
        return FfiConverterMapStringString.lift(value);
    }

    static lower(value) {
        return FfiConverterMapStringString.lower(value);
    }

    static write(dataStream, value) {
        FfiConverterMapStringString.write(dataStream, value);
    }

    static read(dataStream) {
        const builtinVal = FfiConverterMapStringString.read(dataStream);
        return builtinVal;
    }

    static computeSize(value) {
        return FfiConverterMapStringString.computeSize(value);
    }

    static checkType(value) {
        if (value === null || value === undefined) {
            throw new TypeError("value is null or undefined");
        }
    }
}


// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalBytes extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterBytes.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterBytes.read(dataStream)
            default:
                throw new UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterBytes.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterBytes.computeSize(value)
    }
}
/**
 * Request
 */
export class Request {
    constructor(
        {
            method, 
            url, 
            headers, 
            body
        } = {
            method: undefined, 
            url: undefined, 
            headers: undefined, 
            body: undefined
        }
    ) {
        try {
            FfiConverterTypeMethod.checkType(method)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("method");
            }
            throw e;
        }
        try {
            FfiConverterTypeViaductUrl.checkType(url)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("url");
            }
            throw e;
        }
        try {
            FfiConverterTypeHeaders.checkType(headers)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("headers");
            }
            throw e;
        }
        try {
            FfiConverterOptionalBytes.checkType(body)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("body");
            }
            throw e;
        }
        /**
         * method
         */
        this.method = method;
        /**
         * url
         */
        this.url = url;
        /**
         * headers
         */
        this.headers = headers;
        /**
         * body
         */
        this.body = body;
    }

    equals(other) {
        return (
            this.method == other.method
            && this.url == other.url
            && this.headers == other.headers
            && this.body == other.body
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeRequest extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new Request({
            method: FfiConverterTypeMethod.read(dataStream),
            url: FfiConverterTypeViaductUrl.read(dataStream),
            headers: FfiConverterTypeHeaders.read(dataStream),
            body: FfiConverterOptionalBytes.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterTypeMethod.write(dataStream, value.method);
        FfiConverterTypeViaductUrl.write(dataStream, value.url);
        FfiConverterTypeHeaders.write(dataStream, value.headers);
        FfiConverterOptionalBytes.write(dataStream, value.body);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterTypeMethod.computeSize(value.method);
        totalSize += FfiConverterTypeViaductUrl.computeSize(value.url);
        totalSize += FfiConverterTypeHeaders.computeSize(value.headers);
        totalSize += FfiConverterOptionalBytes.computeSize(value.body);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof Request)) {
            throw new UniFFITypeError(`Expected 'Request', found '${typeof value}'`);
        }
        try {
            FfiConverterTypeMethod.checkType(value.method);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".method");
            }
            throw e;
        }
        try {
            FfiConverterTypeViaductUrl.checkType(value.url);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".url");
            }
            throw e;
        }
        try {
            FfiConverterTypeHeaders.checkType(value.headers);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".headers");
            }
            throw e;
        }
        try {
            FfiConverterOptionalBytes.checkType(value.body);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".body");
            }
            throw e;
        }
    }
}


/**
 * A response from the server.
 */
export class Response {
    constructor(
        {
            requestMethod, 
            url, 
            status, 
            headers, 
            body
        } = {
            requestMethod: undefined, 
            url: undefined, 
            status: undefined, 
            headers: undefined, 
            body: undefined
        }
    ) {
        try {
            FfiConverterTypeMethod.checkType(requestMethod)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("requestMethod");
            }
            throw e;
        }
        try {
            FfiConverterTypeViaductUrl.checkType(url)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("url");
            }
            throw e;
        }
        try {
            FfiConverterUInt16.checkType(status)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("status");
            }
            throw e;
        }
        try {
            FfiConverterTypeHeaders.checkType(headers)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("headers");
            }
            throw e;
        }
        try {
            FfiConverterBytes.checkType(body)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("body");
            }
            throw e;
        }
        /**
         * The method used to request this response.
         */
        this.requestMethod = requestMethod;
        /**
         * The URL of this response.
         */
        this.url = url;
        /**
         * The HTTP Status code of this response.
         */
        this.status = status;
        /**
         * The headers returned with this response.
         */
        this.headers = headers;
        /**
         * The body of the response.
         */
        this.body = body;
    }

    equals(other) {
        return (
            this.requestMethod == other.requestMethod
            && this.url == other.url
            && this.status == other.status
            && this.headers == other.headers
            && this.body == other.body
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeResponse extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new Response({
            requestMethod: FfiConverterTypeMethod.read(dataStream),
            url: FfiConverterTypeViaductUrl.read(dataStream),
            status: FfiConverterUInt16.read(dataStream),
            headers: FfiConverterTypeHeaders.read(dataStream),
            body: FfiConverterBytes.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterTypeMethod.write(dataStream, value.requestMethod);
        FfiConverterTypeViaductUrl.write(dataStream, value.url);
        FfiConverterUInt16.write(dataStream, value.status);
        FfiConverterTypeHeaders.write(dataStream, value.headers);
        FfiConverterBytes.write(dataStream, value.body);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterTypeMethod.computeSize(value.requestMethod);
        totalSize += FfiConverterTypeViaductUrl.computeSize(value.url);
        totalSize += FfiConverterUInt16.computeSize(value.status);
        totalSize += FfiConverterTypeHeaders.computeSize(value.headers);
        totalSize += FfiConverterBytes.computeSize(value.body);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof Response)) {
            throw new UniFFITypeError(`Expected 'Response', found '${typeof value}'`);
        }
        try {
            FfiConverterTypeMethod.checkType(value.requestMethod);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".requestMethod");
            }
            throw e;
        }
        try {
            FfiConverterTypeViaductUrl.checkType(value.url);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".url");
            }
            throw e;
        }
        try {
            FfiConverterUInt16.checkType(value.status);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".status");
            }
            throw e;
        }
        try {
            FfiConverterTypeHeaders.checkType(value.headers);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".headers");
            }
            throw e;
        }
        try {
            FfiConverterBytes.checkType(value.body);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".body");
            }
            throw e;
        }
    }
}

/**
 * ViaductError
 */
export class ViaductError extends Error {}


/**
 * RequestHeaderError
 */
export class RequestHeaderError extends ViaductError {

    constructor(
        v0,
        ...params
    ) {
        const message = `v0: ${ v0 }`;
        super(message, ...params);
        this.v0 = v0;
    }
    toString() {
        return `RequestHeaderError: ${super.toString()}`
    }
}

/**
 * BackendError
 */
export class BackendError extends ViaductError {

    constructor(
        v0,
        ...params
    ) {
        const message = `v0: ${ v0 }`;
        super(message, ...params);
        this.v0 = v0;
    }
    toString() {
        return `BackendError: ${super.toString()}`
    }
}

/**
 * NetworkError
 */
export class NetworkError extends ViaductError {

    constructor(
        v0,
        ...params
    ) {
        const message = `v0: ${ v0 }`;
        super(message, ...params);
        this.v0 = v0;
    }
    toString() {
        return `NetworkError: ${super.toString()}`
    }
}

/**
 * BackendAlreadyInitialized
 */
export class BackendAlreadyInitialized extends ViaductError {

    constructor(
        ...params
    ) {
        super(...params);
    }
    toString() {
        return `BackendAlreadyInitialized: ${super.toString()}`
    }
}

/**
 * BackendNotInitialized
 */
export class BackendNotInitialized extends ViaductError {

    constructor(
        ...params
    ) {
        super(...params);
    }
    toString() {
        return `BackendNotInitialized: ${super.toString()}`
    }
}

/**
 * SetBackendError
 */
export class SetBackendError extends ViaductError {

    constructor(
        ...params
    ) {
        super(...params);
    }
    toString() {
        return `SetBackendError: ${super.toString()}`
    }
}

/**
 * Note: we return this if the server returns a bad URL with
 * its response. This *probably* should never happen, but who knows.
 */
export class UrlError extends ViaductError {

    constructor(
        v0,
        ...params
    ) {
        const message = `v0: ${ v0 }`;
        super(message, ...params);
        this.v0 = v0;
    }
    toString() {
        return `UrlError: ${super.toString()}`
    }
}

/**
 * NonTlsUrl
 */
export class NonTlsUrl extends ViaductError {

    constructor(
        ...params
    ) {
        super(...params);
    }
    toString() {
        return `NonTlsUrl: ${super.toString()}`
    }
}

/**
 * OhttpChannelNotConfigured
 */
export class OhttpChannelNotConfigured extends ViaductError {

    constructor(
        v0,
        ...params
    ) {
        const message = `v0: ${ v0 }`;
        super(message, ...params);
        this.v0 = v0;
    }
    toString() {
        return `OhttpChannelNotConfigured: ${super.toString()}`
    }
}

/**
 * OhttpConfigFetchFailed
 */
export class OhttpConfigFetchFailed extends ViaductError {

    constructor(
        v0,
        ...params
    ) {
        const message = `v0: ${ v0 }`;
        super(message, ...params);
        this.v0 = v0;
    }
    toString() {
        return `OhttpConfigFetchFailed: ${super.toString()}`
    }
}

/**
 * OhttpRequestError
 */
export class OhttpRequestError extends ViaductError {

    constructor(
        v0,
        ...params
    ) {
        const message = `v0: ${ v0 }`;
        super(message, ...params);
        this.v0 = v0;
    }
    toString() {
        return `OhttpRequestError: ${super.toString()}`
    }
}

/**
 * OhttpResponseError
 */
export class OhttpResponseError extends ViaductError {

    constructor(
        v0,
        ...params
    ) {
        const message = `v0: ${ v0 }`;
        super(message, ...params);
        this.v0 = v0;
    }
    toString() {
        return `OhttpResponseError: ${super.toString()}`
    }
}

/**
 * OhttpNotSupported
 */
export class OhttpNotSupported extends ViaductError {

    constructor(
        ...params
    ) {
        super(...params);
    }
    toString() {
        return `OhttpNotSupported: ${super.toString()}`
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeViaductError extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new RequestHeaderError(
                    FfiConverterString.read(dataStream)
                    );
            case 2:
                return new BackendError(
                    FfiConverterString.read(dataStream)
                    );
            case 3:
                return new NetworkError(
                    FfiConverterString.read(dataStream)
                    );
            case 4:
                return new BackendAlreadyInitialized(
                    );
            case 5:
                return new BackendNotInitialized(
                    );
            case 6:
                return new SetBackendError(
                    );
            case 7:
                return new UrlError(
                    FfiConverterString.read(dataStream)
                    );
            case 8:
                return new NonTlsUrl(
                    );
            case 9:
                return new OhttpChannelNotConfigured(
                    FfiConverterString.read(dataStream)
                    );
            case 10:
                return new OhttpConfigFetchFailed(
                    FfiConverterString.read(dataStream)
                    );
            case 11:
                return new OhttpRequestError(
                    FfiConverterString.read(dataStream)
                    );
            case 12:
                return new OhttpResponseError(
                    FfiConverterString.read(dataStream)
                    );
            case 13:
                return new OhttpNotSupported(
                    );
            default:
                throw new UniFFITypeError("Unknown ViaductError variant");
        }
    }
    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof RequestHeaderError) {
            totalSize += FfiConverterString.computeSize(value.v0);
            return totalSize;
        }
        if (value instanceof BackendError) {
            totalSize += FfiConverterString.computeSize(value.v0);
            return totalSize;
        }
        if (value instanceof NetworkError) {
            totalSize += FfiConverterString.computeSize(value.v0);
            return totalSize;
        }
        if (value instanceof BackendAlreadyInitialized) {
            return totalSize;
        }
        if (value instanceof BackendNotInitialized) {
            return totalSize;
        }
        if (value instanceof SetBackendError) {
            return totalSize;
        }
        if (value instanceof UrlError) {
            totalSize += FfiConverterString.computeSize(value.v0);
            return totalSize;
        }
        if (value instanceof NonTlsUrl) {
            return totalSize;
        }
        if (value instanceof OhttpChannelNotConfigured) {
            totalSize += FfiConverterString.computeSize(value.v0);
            return totalSize;
        }
        if (value instanceof OhttpConfigFetchFailed) {
            totalSize += FfiConverterString.computeSize(value.v0);
            return totalSize;
        }
        if (value instanceof OhttpRequestError) {
            totalSize += FfiConverterString.computeSize(value.v0);
            return totalSize;
        }
        if (value instanceof OhttpResponseError) {
            totalSize += FfiConverterString.computeSize(value.v0);
            return totalSize;
        }
        if (value instanceof OhttpNotSupported) {
            return totalSize;
        }
        throw new UniFFITypeError("Unknown ViaductError variant");
    }
    static write(dataStream, value) {
        if (value instanceof RequestHeaderError) {
            dataStream.writeInt32(1);
            FfiConverterString.write(dataStream, value.v0);
            return;
        }
        if (value instanceof BackendError) {
            dataStream.writeInt32(2);
            FfiConverterString.write(dataStream, value.v0);
            return;
        }
        if (value instanceof NetworkError) {
            dataStream.writeInt32(3);
            FfiConverterString.write(dataStream, value.v0);
            return;
        }
        if (value instanceof BackendAlreadyInitialized) {
            dataStream.writeInt32(4);
            return;
        }
        if (value instanceof BackendNotInitialized) {
            dataStream.writeInt32(5);
            return;
        }
        if (value instanceof SetBackendError) {
            dataStream.writeInt32(6);
            return;
        }
        if (value instanceof UrlError) {
            dataStream.writeInt32(7);
            FfiConverterString.write(dataStream, value.v0);
            return;
        }
        if (value instanceof NonTlsUrl) {
            dataStream.writeInt32(8);
            return;
        }
        if (value instanceof OhttpChannelNotConfigured) {
            dataStream.writeInt32(9);
            FfiConverterString.write(dataStream, value.v0);
            return;
        }
        if (value instanceof OhttpConfigFetchFailed) {
            dataStream.writeInt32(10);
            FfiConverterString.write(dataStream, value.v0);
            return;
        }
        if (value instanceof OhttpRequestError) {
            dataStream.writeInt32(11);
            FfiConverterString.write(dataStream, value.v0);
            return;
        }
        if (value instanceof OhttpResponseError) {
            dataStream.writeInt32(12);
            FfiConverterString.write(dataStream, value.v0);
            return;
        }
        if (value instanceof OhttpNotSupported) {
            dataStream.writeInt32(13);
            return;
        }
        throw new UniFFITypeError("Unknown ViaductError variant");
    }

    static errorClass = ViaductError;
}

/**
 * Backend
 */
export class Backend {
    /**
     * sendRequest
     * @param {Request} request
     * @param {ClientSettings} settings
     * @returns {Promise<Response>}}
     */
    async sendRequest(
        request, 
        settings) {
      throw Error("sendRequest not implemented");
    }

}

/**
 * Backend
 */
export class BackendImpl extends Backend {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        super();
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an int using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!(opts[constructUniffiObject] instanceof UniFFIPointer)) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }

    /**
     * sendRequest
     * @param {Request} request
     * @param {ClientSettings} settings
     * @returns {Promise<Response>}}
     */
    async sendRequest(
        request, 
        settings) {
       
        FfiConverterTypeRequest.checkType(request);
        FfiConverterTypeClientSettings.checkType(settings);
        const result = await UniFFIScaffolding.callAsync(
            142, // uniffi_viaduct_fn_method_backend_send_request
            FfiConverterTypeBackend.lowerReceiver(this),
            FfiConverterTypeRequest.lower(request),
            FfiConverterTypeClientSettings.lower(settings),
        )
        return handleRustResult(
            result,
            FfiConverterTypeResponse.lift.bind(FfiConverterTypeResponse),
            FfiConverterTypeViaductError.lift.bind(FfiConverterTypeViaductError),
        )
    }

}

// FfiConverter for a trait interface.  This is a hybrid of the FFIConverter regular interfaces and
// for callback interfaces.
//
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeBackend extends FfiConverter {
    // lift works like a regular interface
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new BackendImpl(opts);
    }

    // lower treats value like a callback interface
    static lower(value) {
        if (!(value instanceof Backend)) {
            throw new UniFFITypeError("expected 'Backend' subclass");
        }
        return uniffiCallbackHandlerViaductBackend.storeCallbackObj(value)
    }

    // lowerReceiver is used when calling methods on an interface we got from Rust, 
    // it treats value like a regular interface.
    static lowerReceiver(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'BackendImpl' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointer(20));
    }

    static write(dataStream, value) {
        dataStream.writePointer(20, this.lower(value));
    }

    static computeSize(value) {
        return 8;
    }
}

const uniffiCallbackHandlerViaductBackend = new UniFFICallbackHandler(
    "Backend",
    6,
    [
        new UniFFICallbackMethodHandler(
            "sendRequest",
            [
                FfiConverterTypeRequest,
                FfiConverterTypeClientSettings,
            ],
            FfiConverterTypeResponse.lower.bind(FfiConverterTypeResponse),
            (e) => {
              if (e instanceof ViaductError) {
                return FfiConverterTypeViaductError.lower(e);
              }
              throw e;
            }
        ),
    ]
);

// Allow the shutdown-related functionality to be tested in the unit tests
UnitTestObjs.uniffiCallbackHandlerViaductBackend = uniffiCallbackHandlerViaductBackend;


