/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * This file is used to temporarily disable newly added stylelint rules for existing files.
 * This allows us to enable new stylelint rules immediately for newly added files,
 * without having to fix errors in existing files.
 *
 * Newly added style files should NOT be added to this list,
 * and existing files should be removed from this list as they are fixed.
 */
module.exports = [
  {
    name: "rollout-use-size-tokens",
    rules: {
      "stylelint-plugin-mozilla/use-size-tokens": null,
    },
    files: [
      "browser/base/content/aboutDialog.css",
      "browser/base/content/pageinfo/pageInfo.css",
      "browser/components/aboutlogins/content/aboutLogins.css",
      "browser/components/aboutlogins/content/aboutLoginsImportReport.css",
      "browser/components/aboutlogins/content/components/confirmation-dialog.css",
      "browser/components/aboutlogins/content/components/fxaccounts-button.css",
      "browser/components/aboutlogins/content/components/generic-dialog.css",
      "browser/components/aboutlogins/content/components/login-alert.css",
      "browser/components/aboutlogins/content/components/login-filter.css",
      "browser/components/aboutlogins/content/components/login-intro.css",
      "browser/components/aboutlogins/content/components/login-item.css",
      "browser/components/aboutlogins/content/components/login-list-lit-item.css",
      "browser/components/aboutlogins/content/components/login-list.css",
      "browser/components/aboutlogins/content/components/login-message-popup.css",
      "browser/components/aboutlogins/content/components/login-timeline.css",
      "browser/components/aboutlogins/content/components/menu-button.css",
      "browser/components/aboutlogins/content/components/remove-logins-dialog.css",
      "browser/components/aboutwelcome/content-src/aboutwelcome.scss",
      "browser/components/asrouter/content-src/components/ASRouterAdmin/ASRouterAdmin.scss",
      "browser/components/asrouter/content-src/styles/_feature-callout.scss",
      "browser/components/backup/content/backup-settings.css",
      "browser/components/backup/content/password-rules-tooltip.css",
      "browser/components/backup/content/password-validation-inputs.css",
      "browser/components/backup/content/restore-from-backup.css",
      "browser/components/backup/content/turn-on-scheduled-backups.css",
      "browser/components/contextualidentity/content/usercontext.css",
      "browser/components/enterprisepolicies/content/aboutPolicies.css",
      "browser/components/firefoxview/card-container.css",
      "browser/components/firefoxview/firefoxview.css",
      "browser/components/firefoxview/fxview-empty-state.css",
      "browser/components/firefoxview/fxview-tab-row.css",
      "browser/components/firefoxview/opentabs-tab-row.css",
      "browser/components/firefoxview/view-syncedtabs.css",
      "browser/components/genai/chat.css",
      "browser/components/genai/content/link-preview-card.css",
      "browser/components/genai/content/model-optin.css",
      "browser/components/messagepreview/messagepreview.css",
      "browser/components/places/content/clearDataForSite.css",
      "browser/components/places/metadataViewer/interactionsViewer.css",
      "browser/components/preferences/dialogs/sitePermissions.css",
      "browser/components/preferences/widgets/placeholder-message/placeholder-message.css",
      "browser/components/preferences/widgets/security-privacy/security-privacy-card/security-privacy-card.css",
      "browser/components/profiles/content/avatar.css",
      "browser/components/profiles/content/edit-profile-card.css",
      "browser/components/profiles/content/profile-avatar-selector.css",
      "browser/components/profiles/content/profile-card.css",
      "browser/components/profiles/content/profile-selector.css",
      "browser/components/profiles/content/profiles-pages.css",
      "browser/components/profiles/content/profiles-theme-card.css",
      "browser/components/protections/content/protections.css",
      "browser/components/screenshots/overlay/overlay.css",
      "browser/components/screenshots/screenshots-buttons.css",
      "browser/components/search/test/browser/telemetry/serp.css",
      "browser/components/sidebar/sidebar-main.css",
      "browser/components/sidebar/sidebar-pins-promo.css",
      "browser/components/sidebar/sidebar.css",
      "browser/components/textrecognition/textrecognition.css",
      "browser/components/urlbar/tests/browser/dynamicResult0.css",
      "browser/components/urlbar/tests/browser/dynamicResult1.css",
      "browser/components/webrtc/content/webrtc-preview/webrtc-preview.css",
      "browser/extensions/formautofill/content/formautofill.css",
      "browser/extensions/formautofill/content/manageDialog.css",
      "browser/extensions/formautofill/skin/shared/editAddress.css",
      "browser/extensions/formautofill/skin/shared/editDialog-shared.css",
      "browser/extensions/newtab/content-src/components/Base/_Base.scss",
      "browser/extensions/newtab/content-src/components/Card/_Card.scss",
      "browser/extensions/newtab/content-src/components/CollapsibleSection/_CollapsibleSection.scss",
      "browser/extensions/newtab/content-src/components/ConfirmDialog/_ConfirmDialog.scss",
      "browser/extensions/newtab/content-src/components/ContextMenu/_ContextMenu.scss",
      "browser/extensions/newtab/content-src/components/CustomizeMenu/_CustomizeMenu.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamAdmin/DiscoveryStreamAdmin.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/AdBanner/_AdBanner.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/AdBannerContextMenu/AdBannerContextMenu.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/CardGrid/_CardGrid.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/CardSections/_CardSections.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSCard/_DSCard.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSContextFooter/_DSContextFooter.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSEmptyState/_DSEmptyState.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSImage/_DSImage.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSMessage/_DSMessage.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/FeatureHighlight/_DownloadMobilePromoHighlight.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/FeatureHighlight/_FeatureHighlight.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/FeatureHighlight/_FollowSectionButtonHighlight.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/FeatureHighlight/_ShortcutFeatureHighlight.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/FeatureHighlight/_WallpaperFeatureHighlight.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/Highlights/_Highlights.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/Navigation/_Navigation.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/PersonalizedCard/_PersonalizedCard.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/PromoCard/_PromoCard.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/ReportContent/ReportContent.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/SectionContextMenu/_SectionContextMenu.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/TopSites/_TopSites.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/TopicSelection/_TopicSelection.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/TopicsWidget/_TopicsWidget.scss",
      "browser/extensions/newtab/content-src/components/DownloadModalToggle/_DownloadModalToggle.scss",
      "browser/extensions/newtab/content-src/components/Logo/_Logo.scss",
      "browser/extensions/newtab/content-src/components/ModalOverlay/_ModalOverlay.scss",
      "browser/extensions/newtab/content-src/components/MoreRecommendations/_MoreRecommendations.scss",
      "browser/extensions/newtab/content-src/components/Notifications/_Notifications.scss",
      "browser/extensions/newtab/content-src/components/Search/_Search.scss",
      "browser/extensions/newtab/content-src/components/Sections/_Sections.scss",
      "browser/extensions/newtab/content-src/components/TopSites/_TopSites.scss",
      "browser/extensions/newtab/content-src/components/WallpaperCategories/_WallpaperCategories.scss",
      "browser/extensions/newtab/content-src/components/Weather/_Weather.scss",
      "browser/extensions/newtab/content-src/components/Widgets/FocusTimer/_FocusTimer.scss",
      "browser/extensions/newtab/content-src/components/Widgets/Lists/_Lists.scss",
      "browser/extensions/newtab/content-src/components/Widgets/WeatherForecast/WeatherForecast.scss",
      "browser/extensions/newtab/content-src/components/Widgets/_Widgets.scss",
      "browser/extensions/newtab/content-src/styles/_icons.scss",
      "browser/extensions/newtab/content-src/styles/_mixins.scss",
      "browser/extensions/newtab/content-src/styles/_variables.scss",
      "browser/extensions/newtab/content-src/styles/activity-stream.scss",
      "browser/themes/linux/browser.css",
      "browser/themes/linux/places/organizer.css",
      "browser/themes/osx/browser.css",
      "browser/themes/osx/places/organizer.css",
      "browser/themes/shared/UITour.css",
      "browser/themes/shared/aboutSessionRestore.css",
      "browser/themes/shared/addon-notification.css",
      "browser/themes/shared/addons/extension-controlled.css",
      "browser/themes/shared/addons/unified-extensions.css",
      "browser/themes/shared/aiWindowSidebar.css",
      "browser/themes/shared/autocomplete.css",
      "browser/themes/shared/blockedSite.css",
      "browser/themes/shared/browser-shared.css",
      "browser/themes/shared/controlcenter/panel.css",
      "browser/themes/shared/customizableui/customizeMode.css",
      "browser/themes/shared/customizableui/panelUI-shared.css",
      "browser/themes/shared/downloads/allDownloadsView.inc.css",
      "browser/themes/shared/downloads/download-blockedStates.css",
      "browser/themes/shared/downloads/downloads.inc.css",
      "browser/themes/shared/downloads/indicator.css",
      "browser/themes/shared/downloads/progressmeter.css",
      "browser/themes/shared/formautofill-notification.css",
      "browser/themes/shared/identity-block/identity-block.css",
      "browser/themes/shared/identity-credential-notification.css",
      "browser/themes/shared/migration/migration-wizard.css",
      "browser/themes/shared/notification-icons.css",
      "browser/themes/shared/pageInfo.css",
      "browser/themes/shared/places/editBookmark.css",
      "browser/themes/shared/places/editBookmarkPanel.css",
      "browser/themes/shared/places/organizer-shared.css",
      "browser/themes/shared/places/sidebar.css",
      "browser/themes/shared/places/tree-icons.css",
      "browser/themes/shared/preferences/applications.css",
      "browser/themes/shared/preferences/containers-dialog.css",
      "browser/themes/shared/preferences/containers.css",
      "browser/themes/shared/preferences/fxaPairDevice.css",
      "browser/themes/shared/preferences/preferences.css",
      "browser/themes/shared/preferences/privacy.css",
      "browser/themes/shared/preferences/search.css",
      "browser/themes/shared/preferences/siteDataSettings.css",
      "browser/themes/shared/privatebrowsing/aboutPrivateBrowsing.css",
      "browser/themes/shared/search/searchbar.css",
      "browser/themes/shared/sidebar.css",
      "browser/themes/shared/smartbar.css",
      "browser/themes/shared/syncedtabs/sidebar.css",
      "browser/themes/shared/tab-list-tree.css",
      "browser/themes/shared/tabbrowser/content-area.css",
      "browser/themes/shared/tabbrowser/ctrlTab.css",
      "browser/themes/shared/tabbrowser/fullscreen-and-pointerlock.css",
      "browser/themes/shared/tabbrowser/tab-hover-preview.css",
      "browser/themes/shared/tabbrowser/tabs.css",
      "browser/themes/shared/toolbarbuttons.css",
      "browser/themes/shared/translations/panel.css",
      "browser/themes/shared/urlbar-dynamic-results.css",
      "browser/themes/shared/urlbar-searchbar.css",
      "browser/themes/shared/urlbarView.css",
      "browser/themes/shared/webRTC-indicator.css",
      "browser/themes/windows/places/organizer.css",
      "devtools/client/aboutdebugging/src/base.css",
      "devtools/client/aboutdebugging/src/components/App.css",
      "devtools/client/aboutdebugging/src/components/ProfilerDialog.css",
      "devtools/client/aboutdebugging/src/components/debugtarget/ExtensionDetail.css",
      "devtools/client/aboutdebugging/src/components/debugtarget/ServiceWorkerAction.css",
      "devtools/client/aboutdebugging/src/components/shared/IconLabel.css",
      "devtools/client/aboutdebugging/src/components/sidebar/Sidebar.css",
      "devtools/client/aboutdebugging/src/components/sidebar/SidebarFixedItem.css",
      "devtools/client/aboutdebugging/src/components/sidebar/SidebarItem.css",
      "devtools/client/aboutdebugging/src/components/sidebar/SidebarRuntimeItem.css",
      "gfx/layers/apz/test/mochitest/helper_subframe_style.css",
      "security/manager/pki/resources/content/certManager.css",
      "toolkit/components/aboutcheckerboard/content/aboutCheckerboard.css",
      "toolkit/components/aboutconfig/content/aboutconfig.css",
      "toolkit/components/aboutinference/content/aboutInference.css",
      "toolkit/components/aboutinference/content/model-files-view.css",
      "toolkit/components/aboutprocesses/content/aboutProcesses.css",
      "toolkit/components/aboutthirdparty/content/aboutThirdParty.css",
      "toolkit/components/certviewer/content/certviewer.css",
      "toolkit/components/certviewer/content/components/error-section.css",
      "toolkit/components/certviewer/content/components/info-group.css",
      "toolkit/components/normandy/content/about-studies/about-studies.css",
      "toolkit/components/printing/content/print.css",
      "toolkit/components/printing/content/printPagination.css",
      "toolkit/components/printing/content/printPreview.css",
      "toolkit/components/printing/content/toggle-group.css",
      "toolkit/components/reader/moz-slider.css",
      "toolkit/components/resistfingerprinting/content/letterboxing.css",
      "toolkit/components/satchel/megalist/content/components/login-line/login-line.css",
      "toolkit/components/satchel/megalist/content/components/password-card/password-card.css",
      "toolkit/components/satchel/megalist/content/megalist.css",
      "toolkit/components/translations/content/about-translations.css",
      "toolkit/content/aboutGlean.css",
      "toolkit/content/aboutLogging/aboutLogging.css",
      "toolkit/content/aboutTelemetry.css",
      "toolkit/content/aboutwebrtc/aboutWebrtc.css",
      "toolkit/content/tests/widgets/videomask.css",
      "toolkit/content/widgets/infobar.css",
      "toolkit/content/widgets/moz-box-group/moz-box-group.css",
      "toolkit/content/widgets/moz-button/moz-button.css",
      "toolkit/content/widgets/moz-input-color/moz-input-color.css",
      "toolkit/content/widgets/moz-input-folder/moz-input-folder.css",
      "toolkit/content/widgets/moz-input-text/moz-input-text.css",
      "toolkit/content/widgets/moz-message-bar/moz-message-bar.css",
      "toolkit/content/widgets/moz-page-nav/moz-page-nav-button.css",
      "toolkit/content/widgets/moz-page-nav/moz-page-nav.css",
      "toolkit/content/widgets/moz-promo/moz-promo.css",
      "toolkit/content/widgets/moz-reorderable-list/moz-reorderable-list.css",
      "toolkit/content/widgets/moz-select/moz-select.css",
      "toolkit/content/widgets/moz-toggle/moz-toggle.css",
      "toolkit/content/widgets/panel-list/panel-item.css",
      "toolkit/content/widgets/panel-list/panel-list.css",
      "toolkit/content/xul.css",
      "toolkit/crashreporter/content/crashes.css",
      "toolkit/mozapps/extensions/content/aboutaddons.css",
      "toolkit/mozapps/extensions/content/components/mlmodel-card-header-additions.css",
      "toolkit/mozapps/extensions/content/shortcuts.css",
      "toolkit/themes/linux/global/autocomplete.css",
      "toolkit/themes/linux/mozapps/update/updates.css",
      "toolkit/themes/osx/global/autocomplete.css",
      "toolkit/themes/osx/global/button.css",
      "toolkit/themes/osx/global/global.css",
      "toolkit/themes/osx/global/in-content/common.css",
      "toolkit/themes/osx/global/wizard.css",
      "toolkit/themes/osx/mozapps/handling/handling.css",
      "toolkit/themes/osx/mozapps/update/updates.css",
      "toolkit/themes/shared/aboutHttpsOnlyError.css",
      "toolkit/themes/shared/aboutLicense.css",
      "toolkit/themes/shared/aboutNetError.css",
      "toolkit/themes/shared/aboutReader.css",
      "toolkit/themes/shared/aboutServiceWorkers.css",
      "toolkit/themes/shared/aboutSupport.css",
      "toolkit/themes/shared/alert.css",
      "toolkit/themes/shared/appPicker.css",
      "toolkit/themes/shared/checkbox.css",
      "toolkit/themes/shared/close-icon.css",
      "toolkit/themes/shared/commonDialog.css",
      "toolkit/themes/shared/datetimeinputpickers.css",
      "toolkit/themes/shared/design-system/storybook/tokens-table.css",
      "toolkit/themes/shared/dirListing/dirListing.css",
      "toolkit/themes/shared/downloads/unknownContentType.css",
      "toolkit/themes/shared/error-pages.css",
      "toolkit/themes/shared/findbar.css",
      "toolkit/themes/shared/global-shared.css",
      "toolkit/themes/shared/in-content/common-shared.css",
      "toolkit/themes/shared/menu.css",
      "toolkit/themes/shared/menulist.css",
      "toolkit/themes/shared/narrate.css",
      "toolkit/themes/shared/offlineSupportPages.css",
      "toolkit/themes/shared/pictureinpicture/player.css",
      "toolkit/themes/shared/pictureinpicture/texttracks.css",
      "toolkit/themes/shared/popup.css",
      "toolkit/themes/shared/popupnotification.css",
      "toolkit/themes/shared/profileDowngrade.css",
      "toolkit/themes/shared/radio.css",
      "toolkit/themes/shared/splitter.css",
      "toolkit/themes/shared/toolbar.css",
      "toolkit/themes/shared/toolbarbutton.css",
      "toolkit/themes/shared/tree/tree.css",
      "toolkit/themes/windows/global/autocomplete.css",
      "toolkit/themes/windows/global/global.css",
      "toolkit/themes/windows/global/wizard.css",
      "toolkit/themes/windows/mozapps/handling/handling.css",
      "toolkit/themes/windows/mozapps/update/updates.css",
      "tools/tryselect/selectors/chooser/static/style.css",
    ],
  },
  {
    name: "rollout-no-non-semantic-token-usage",
    rules: {
      "stylelint-plugin-mozilla/no-non-semantic-token-usage": null,
    },
    files: [
      "browser/components/aboutlogins/content/components/input-field/input-field.css",
      "browser/components/aboutlogins/content/components/login-list.css",
      "browser/components/aboutlogins/content/components/login-message-popup.css",
      "browser/components/aboutlogins/content/components/login-timeline.css",
      "browser/components/aboutlogins/content/components/menu-button.css",
      "browser/components/aboutwelcome/content-src/aboutwelcome.scss",
      "browser/components/backup/content/backup-common.css",
      "browser/components/backup/content/restore-from-backup.css",
      "browser/components/genai/chat.css",
      "browser/components/genai/content/link-preview-card.css",
      "browser/components/profiles/content/profile-avatar-selector.css",
      "browser/components/profiles/content/profile-card.css",
      "browser/components/protections/content/protections.css",
      "browser/components/sidebar/sidebar-main.css",
      "browser/components/textrecognition/textrecognition.css",
      "browser/extensions/newtab/content-src/components/Base/_Base.scss",
      "browser/extensions/newtab/content-src/components/Card/_Card.scss",
      "browser/extensions/newtab/content-src/components/CustomizeMenu/_CustomizeMenu.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/CardGrid/_CardGrid.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/CardSections/_CardSections.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSCard/_DSCard.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/InterestPicker/_InterestPicker.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/Navigation/_Navigation.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/PromoCard/_PromoCard.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/TopicSelection/_TopicSelection.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/TopicsWidget/_TopicsWidget.scss",
      "browser/extensions/newtab/content-src/components/Search/_Search.scss",
      "browser/extensions/newtab/content-src/components/Sections/_Sections.scss",
      "browser/extensions/newtab/content-src/components/TopSites/_TopSites.scss",
      "browser/extensions/newtab/content-src/components/WallpaperCategories/_WallpaperCategories.scss",
      "browser/extensions/newtab/content-src/components/Weather/_Weather.scss",
      "browser/extensions/newtab/content-src/components/Widgets/FocusTimer/_FocusTimer.scss",
      "browser/extensions/newtab/content-src/components/Widgets/Lists/_Lists.scss",
      "browser/extensions/newtab/content-src/styles/_variables.scss",
      "browser/themes/linux/browser.css",
      "browser/themes/shared/addons/unified-extensions.css",
      "browser/themes/shared/controlcenter/panel.css",
      "browser/themes/shared/customizableui/panelUI-shared.css",
      "browser/themes/shared/downloads/downloads.inc.css",
      "browser/themes/shared/formautofill-notification.css",
      "browser/themes/shared/identity-block/identity-block.css",
      "browser/themes/shared/notification-icons.css",
      "browser/themes/shared/pageInfo.css",
      "browser/themes/shared/places/editBookmarkPanel.css",
      "browser/themes/shared/preferences/containers-dialog.css",
      "browser/themes/shared/sidebar.css",
      "browser/themes/shared/tabbrowser/tabs.css",
      "browser/themes/shared/toolbarbuttons.css",
      "browser/themes/shared/translations/panel.css",
      "browser/themes/shared/urlbar-dynamic-results.css",
      "browser/themes/shared/urlbar-searchbar.css",
      "browser/themes/shared/urlbarView.css",
      "browser/themes/windows/browser.css",
      "devtools/client/aboutdebugging/src/base.css",
      "toolkit/components/printing/content/toggle-group.css",
      "toolkit/components/satchel/megalist/content/megalist.css",
      "toolkit/content/aboutGlean.css",
      "toolkit/content/widgets/moz-box-common.css",
      "toolkit/content/widgets/moz-button/moz-button.css",
      "toolkit/content/widgets/moz-input-color/moz-input-color.css",
      "toolkit/content/widgets/moz-input-text/moz-input-text.css",
      "toolkit/content/widgets/moz-message-bar/moz-message-bar.css",
      "toolkit/content/widgets/moz-page-nav/moz-page-nav.css",
      "toolkit/content/widgets/moz-select/moz-select.css",
      "toolkit/content/widgets/moz-toggle/moz-toggle.css",
      "toolkit/content/widgets/moz-visual-picker/moz-visual-picker-item.css",
      "toolkit/content/widgets/panel-list/panel-item.css",
      "toolkit/content/widgets/panel-list/panel-list.css",
      "toolkit/themes/shared/aboutReader.css",
      "toolkit/themes/shared/design-system/storybook/tokens-table.css",
      "toolkit/themes/shared/findbar.css",
      "toolkit/themes/shared/global-shared.css",
      "toolkit/themes/shared/in-content/common-shared.css",
      "toolkit/themes/shared/menulist.css",
    ],
  },
  {
    name: "rollout-use-design-tokens",
    rules: {
      "stylelint-plugin-mozilla/use-design-tokens": null,
    },
    files: [
      "browser/base/content/aboutDialog.css",
      "browser/base/content/pageinfo/pageInfo.css",
      "browser/base/content/sanitizeDialog.css",
      "browser/components/aboutlogins/content/aboutLogins.css",
      "browser/components/aboutlogins/content/aboutLoginsImportReport.css",
      "browser/components/aboutlogins/content/components/confirmation-dialog.css",
      "browser/components/aboutlogins/content/components/fxaccounts-button.css",
      "browser/components/aboutlogins/content/components/generic-dialog.css",
      "browser/components/aboutlogins/content/components/import-error-dialog.css",
      "browser/components/aboutlogins/content/components/import-summary-dialog.css",
      "browser/components/aboutlogins/content/components/login-alert.css",
      "browser/components/aboutlogins/content/components/login-command-button.css",
      "browser/components/aboutlogins/content/components/login-filter.css",
      "browser/components/aboutlogins/content/components/login-item.css",
      "browser/components/aboutlogins/content/components/login-list-lit-item.css",
      "browser/components/aboutlogins/content/components/login-list.css",
      "browser/components/aboutlogins/content/components/login-message-popup.css",
      "browser/components/aboutlogins/content/components/login-timeline.css",
      "browser/components/aboutlogins/content/components/menu-button.css",
      "browser/components/aboutlogins/content/components/remove-logins-dialog.css",
      "browser/components/aboutwelcome/content-src/aboutwelcome.scss",
      "browser/components/asrouter/content-src/components/ASRouterAdmin/ASRouterAdmin.scss",
      "browser/components/asrouter/content-src/styles/_feature-callout.scss",
      "browser/components/backup/content/backup-settings.css",
      "browser/components/backup/content/password-rules-tooltip.css",
      "browser/components/backup/content/password-validation-inputs.css",
      "browser/components/backup/content/turn-on-scheduled-backups.css",
      "browser/components/contextualidentity/content/usercontext.css",
      "browser/components/downloads/content/downloads.css",
      "browser/components/enterprisepolicies/content/aboutPolicies.css",
      "browser/components/firefoxview/card-container.css",
      "browser/components/firefoxview/firefoxview.css",
      "browser/components/firefoxview/fxview-empty-state.css",
      "browser/components/firefoxview/fxview-tab-row.css",
      "browser/components/firefoxview/history.css",
      "browser/components/firefoxview/opentabs-tab-row.css",
      "browser/components/firefoxview/view-opentabs.css",
      "browser/components/firefoxview/view-syncedtabs.css",
      "browser/components/genai/chat.css",
      "browser/components/genai/content/link-preview-card.css",
      "browser/components/genai/content/model-optin.css",
      "browser/components/genai/content/smart-assist.css",
      "browser/components/ipprotection/content/ipprotection-content.css",
      "browser/components/ipprotection/content/ipprotection-status-card.css",
      "browser/components/messagepreview/messagepreview.css",
      "browser/components/places/metadataViewer/interactionsViewer.css",
      "browser/components/preferences/dialogs/clearSiteData.css",
      "browser/components/preferences/dialogs/sitePermissions.css",
      "browser/components/preferences/widgets/nav-notice/nav-notice.css",
      "browser/components/preferences/widgets/security-privacy/security-privacy-card/security-privacy-card.css",
      "browser/components/profiles/content/avatar.css",
      "browser/components/profiles/content/edit-profile-card.css",
      "browser/components/profiles/content/profile-avatar-selector.css",
      "browser/components/profiles/content/profile-card.css",
      "browser/components/profiles/content/profile-selector.css",
      "browser/components/profiles/content/profiles-pages.css",
      "browser/components/profiles/content/profiles-theme-card.css",
      "browser/components/protections/content/protections.css",
      "browser/components/screenshots/overlay/overlay.css",
      "browser/components/screenshots/screenshots-buttons.css",
      "browser/components/screenshots/screenshots-preview.css",
      "browser/components/search/content/addEngine.css",
      "browser/components/search/test/browser/telemetry/serp.css",
      "browser/components/security/unexpectedScriptLoad.css",
      "browser/components/sidebar/sidebar-customize.css",
      "browser/components/sidebar/sidebar-main.css",
      "browser/components/sidebar/sidebar-panel-header.css",
      "browser/components/sidebar/sidebar-pins-promo.css",
      "browser/components/sidebar/sidebar-tab-row.css",
      "browser/components/sidebar/sidebar.css",
      "browser/components/tabunloader/content/aboutUnloads.css",
      "browser/components/textrecognition/textrecognition.css",
      "browser/components/urlbar/tests/browser/dynamicResult0.css",
      "browser/components/urlbar/tests/browser/dynamicResult1.css",
      "browser/components/webrtc/content/webrtc-preview/webrtc-preview.css",
      "browser/extensions/formautofill/content/formautofill.css",
      "browser/extensions/formautofill/content/manageDialog.css",
      "browser/extensions/formautofill/skin/shared/editAddress.css",
      "browser/extensions/formautofill/skin/shared/editDialog-shared.css",
      "browser/extensions/newtab/content-src/components/A11yLinkButton/_A11yLinkButton.scss",
      "browser/extensions/newtab/content-src/components/Base/_Base.scss",
      "browser/extensions/newtab/content-src/components/Card/_Card.scss",
      "browser/extensions/newtab/content-src/components/CollapsibleSection/_CollapsibleSection.scss",
      "browser/extensions/newtab/content-src/components/ConfirmDialog/_ConfirmDialog.scss",
      "browser/extensions/newtab/content-src/components/ContextMenu/_ContextMenu.scss",
      "browser/extensions/newtab/content-src/components/CustomizeMenu/_CustomizeMenu.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamAdmin/DiscoveryStreamAdmin.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamBase/_DiscoveryStreamBase.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/AdBanner/_AdBanner.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/AdBannerContextMenu/AdBannerContextMenu.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/CardGrid/_CardGrid.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/CardSections/_CardSections.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSCard/_DSCard.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSContextFooter/_DSContextFooter.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSEmptyState/_DSEmptyState.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSImage/_DSImage.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSMessage/_DSMessage.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSThumbsUpDownButtons/_DSThumbsUpDownButtons.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/FeatureHighlight/_DownloadMobilePromoHighlight.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/FeatureHighlight/_FeatureHighlight.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/FeatureHighlight/_FollowSectionButtonHighlight.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/FeatureHighlight/_WallpaperFeatureHighlight.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/Highlights/_Highlights.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/InterestPicker/_InterestPicker.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/Navigation/_Navigation.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/PromoCard/_PromoCard.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/ReportContent/ReportContent.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/SectionContextMenu/_SectionContextMenu.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/SectionTitle/_SectionTitle.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/TopicSelection/_TopicSelection.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/TopicsWidget/_TopicsWidget.scss",
      "browser/extensions/newtab/content-src/components/DownloadModalToggle/_DownloadModalToggle.scss",
      "browser/extensions/newtab/content-src/components/ErrorBoundary/_ErrorBoundary.scss",
      "browser/extensions/newtab/content-src/components/ModalOverlay/_ModalOverlay.scss",
      "browser/extensions/newtab/content-src/components/Notifications/_Notifications.scss",
      "browser/extensions/newtab/content-src/components/Search/_Search.scss",
      "browser/extensions/newtab/content-src/components/Sections/_Sections.scss",
      "browser/extensions/newtab/content-src/components/TopSites/_TopSites.scss",
      "browser/extensions/newtab/content-src/components/WallpaperCategories/_WallpaperCategories.scss",
      "browser/extensions/newtab/content-src/components/Weather/_Weather.scss",
      "browser/extensions/newtab/content-src/components/Widgets/FocusTimer/_FocusTimer.scss",
      "browser/extensions/newtab/content-src/components/Widgets/Lists/_Lists.scss",
      "browser/extensions/newtab/content-src/components/Widgets/WeatherForecast/WeatherForecast.scss",
      "browser/extensions/newtab/content-src/components/Widgets/_Widgets.scss",
      "browser/extensions/newtab/content-src/styles/_icons.scss",
      "browser/extensions/newtab/content-src/styles/_mixins.scss",
      "browser/extensions/newtab/content-src/styles/_variables.scss",
      "browser/extensions/newtab/content-src/styles/activity-stream.scss",
      "browser/extensions/webcompat/about-compat/aboutCompat.css",
      "browser/themes/linux/browser.css",
      "browser/themes/linux/customizableui/panelUI.css",
      "browser/themes/linux/places/organizer.css",
      "browser/themes/linux/sanitizeDialog.css",
      "browser/themes/osx/browser.css",
      "browser/themes/osx/customizableui/panelUI.css",
      "browser/themes/osx/downloads/allDownloadsView.css",
      "browser/themes/osx/places/organizer.css",
      "browser/themes/osx/sanitizeDialog.css",
      "browser/themes/shared/UITour.css",
      "browser/themes/shared/aboutRestartRequired.css",
      "browser/themes/shared/aboutSessionRestore.css",
      "browser/themes/shared/aboutTabCrashed.css",
      "browser/themes/shared/aboutWelcomeBack.css",
      "browser/themes/shared/addon-notification.css",
      "browser/themes/shared/addons/unified-extensions.css",
      "browser/themes/shared/aiWindowSidebar.css",
      "browser/themes/shared/autocomplete.css",
      "browser/themes/shared/blockedSite.css",
      "browser/themes/shared/browser-shared.css",
      "browser/themes/shared/contextmenu.css",
      "browser/themes/shared/controlcenter/panel.css",
      "browser/themes/shared/customizableui/customizeMode.css",
      "browser/themes/shared/customizableui/panelUI-shared.css",
      "browser/themes/shared/downloads/allDownloadsView.inc.css",
      "browser/themes/shared/downloads/contentAreaDownloadsView.css",
      "browser/themes/shared/downloads/download-blockedStates.css",
      "browser/themes/shared/downloads/downloads.inc.css",
      "browser/themes/shared/downloads/indicator.css",
      "browser/themes/shared/downloads/progressmeter.css",
      "browser/themes/shared/formautofill-notification.css",
      "browser/themes/shared/identity-block/identity-block.css",
      "browser/themes/shared/identity-credential-notification.css",
      "browser/themes/shared/migration/migration-dialog-window.css",
      "browser/themes/shared/migration/migration-wizard.css",
      "browser/themes/shared/notification-icons.css",
      "browser/themes/shared/pageInfo.css",
      "browser/themes/shared/places/editBookmark.css",
      "browser/themes/shared/places/editBookmarkPanel.css",
      "browser/themes/shared/places/organizer-shared.css",
      "browser/themes/shared/places/sidebar.css",
      "browser/themes/shared/places/tree-icons.css",
      "browser/themes/shared/preferences/applications.css",
      "browser/themes/shared/preferences/containers-dialog.css",
      "browser/themes/shared/preferences/containers.css",
      "browser/themes/shared/preferences/dialog.css",
      "browser/themes/shared/preferences/fxaPairDevice.css",
      "browser/themes/shared/preferences/preferences.css",
      "browser/themes/shared/preferences/privacy.css",
      "browser/themes/shared/preferences/search.css",
      "browser/themes/shared/preferences/siteDataSettings.css",
      "browser/themes/shared/privatebrowsing/aboutPrivateBrowsing.css",
      "browser/themes/shared/sanitizeDialog_v2.css",
      "browser/themes/shared/search/searchbar.css",
      "browser/themes/shared/setDesktopBackground.css",
      "browser/themes/shared/sidebar.css",
      "browser/themes/shared/syncedtabs/sidebar.css",
      "browser/themes/shared/tab-list-tree.css",
      "browser/themes/shared/tabbrowser/content-area.css",
      "browser/themes/shared/tabbrowser/ctrlTab.css",
      "browser/themes/shared/tabbrowser/fullscreen-and-pointerlock.css",
      "browser/themes/shared/tabbrowser/tab-hover-preview.css",
      "browser/themes/shared/tabbrowser/tabs.css",
      "browser/themes/shared/toolbarbutton-icons.css",
      "browser/themes/shared/toolbarbuttons.css",
      "browser/themes/shared/translations/panel.css",
      "browser/themes/shared/urlbar-dynamic-results.css",
      "browser/themes/shared/urlbar-searchbar.css",
      "browser/themes/shared/urlbarView.css",
      "browser/themes/shared/webRTC-indicator.css",
      "browser/themes/windows/browser.css",
      "browser/themes/windows/customizableui/panelUI.css",
      "browser/themes/windows/downloads/allDownloadsView.css",
      "browser/themes/windows/downloads/downloads.css",
      "browser/themes/windows/places/organizer.css",
      "browser/themes/windows/sanitizeDialog.css",
      "browser/tools/mozscreenshots/mozscreenshots/extension/lib/mozscreenshots-style.css",
      "devtools/client/aboutdebugging/src/base.css",
      "devtools/client/aboutdebugging/src/components/App.css",
      "devtools/client/aboutdebugging/src/components/ProfilerDialog.css",
      "devtools/client/aboutdebugging/src/components/RuntimeActions.css",
      "devtools/client/aboutdebugging/src/components/RuntimeInfo.css",
      "devtools/client/aboutdebugging/src/components/connect/ConnectPage.css",
      "devtools/client/aboutdebugging/src/components/connect/ConnectSection.css",
      "devtools/client/aboutdebugging/src/components/connect/ConnectSteps.css",
      "devtools/client/aboutdebugging/src/components/connect/NetworkLocationsForm.css",
      "devtools/client/aboutdebugging/src/components/connect/NetworkLocationsList.css",
      "devtools/client/aboutdebugging/src/components/debugtarget/DebugTargetItem.css",
      "devtools/client/aboutdebugging/src/components/debugtarget/DebugTargetList.css",
      "devtools/client/aboutdebugging/src/components/debugtarget/DebugTargetPane.css",
      "devtools/client/aboutdebugging/src/components/debugtarget/ExtensionDetail.css",
      "devtools/client/aboutdebugging/src/components/debugtarget/FieldPair.css",
      "devtools/client/aboutdebugging/src/components/debugtarget/ServiceWorkerAction.css",
      "devtools/client/aboutdebugging/src/components/shared/IconLabel.css",
      "devtools/client/aboutdebugging/src/components/shared/Message.css",
      "devtools/client/aboutdebugging/src/components/sidebar/Sidebar.css",
      "devtools/client/aboutdebugging/src/components/sidebar/SidebarFixedItem.css",
      "devtools/client/aboutdebugging/src/components/sidebar/SidebarItem.css",
      "devtools/client/aboutdebugging/src/components/sidebar/SidebarRuntimeItem.css",
      "gfx/layers/apz/test/mochitest/helper_subframe_style.css",
      "gfx/layers/layerviewer/tree.css",
      "netwerk/test/browser/res.css",
      "security/manager/pki/resources/content/clientauthask.css",
      "security/manager/pki/resources/content/deletecert.css",
      "security/manager/pki/resources/content/exceptionDialog.css",
      "security/manager/ssl/tests/mochitest/mixedcontent/somestyle.css",
      "toolkit/components/aboutcheckerboard/content/aboutCheckerboard.css",
      "toolkit/components/aboutconfig/content/aboutconfig.css",
      "toolkit/components/aboutinference/content/aboutInference.css",
      "toolkit/components/aboutinference/content/model-files-view.css",
      "toolkit/components/aboutmemory/content/aboutMemory.css",
      "toolkit/components/aboutprocesses/content/aboutProcesses.css",
      "toolkit/components/aboutthirdparty/content/aboutThirdParty.css",
      "toolkit/components/aboutwebauthn/content/aboutWebauthn.css",
      "toolkit/components/aboutwindowsmessages/content/aboutWindowsMessages.css",
      "toolkit/components/certviewer/content/components/about-certificate-section.css",
      "toolkit/components/certviewer/content/components/certificate-section.css",
      "toolkit/components/certviewer/content/components/error-section.css",
      "toolkit/components/certviewer/content/components/info-group.css",
      "toolkit/components/certviewer/content/components/info-item.css",
      "toolkit/components/certviewer/content/components/list-item.css",
      "toolkit/components/cleardata/tests/browser/file_css_cache.css",
      "toolkit/components/extensions/test/mochitest/file_style_bad.css",
      "toolkit/components/extensions/test/mochitest/file_style_good.css",
      "toolkit/components/extensions/test/mochitest/file_style_redirect.css",
      "toolkit/components/extensions/test/xpcshell/data/file_style_bad.css",
      "toolkit/components/extensions/test/xpcshell/data/file_style_good.css",
      "toolkit/components/extensions/test/xpcshell/data/file_style_redirect.css",
      "toolkit/components/extensions/test/xpcshell/data/file_stylesheet_cache.css",
      "toolkit/components/normandy/content/about-studies/about-studies.css",
      "toolkit/components/normandy/skin/shared/Heartbeat.css",
      "toolkit/components/printing/content/print.css",
      "toolkit/components/printing/content/printPagination.css",
      "toolkit/components/printing/content/printPreview.css",
      "toolkit/components/printing/content/simplifyMode.css",
      "toolkit/components/printing/content/toggle-group.css",
      "toolkit/components/prompts/content/commonDialog.css",
      "toolkit/components/prompts/content/selectDialog.css",
      "toolkit/components/resistfingerprinting/content/letterboxing.css",
      "toolkit/components/resistfingerprinting/content/usercharacteristics.css",
      "toolkit/components/satchel/megalist/content/components/login-form/login-form.css",
      "toolkit/components/satchel/megalist/content/components/login-line/login-line.css",
      "toolkit/components/satchel/megalist/content/components/password-card/password-card.css",
      "toolkit/components/satchel/megalist/content/megalist.css",
      "toolkit/components/translations/content/about-translations.css",
      "toolkit/content/aboutGlean.css",
      "toolkit/content/aboutLogging/aboutLogging.css",
      "toolkit/content/aboutMozilla.css",
      "toolkit/content/aboutTelemetry.css",
      "toolkit/content/aboutUrlClassifier.css",
      "toolkit/content/aboutwebrtc/aboutWebrtc.css",
      "toolkit/content/buildconfig.css",
      "toolkit/content/resetProfile.css",
      "toolkit/content/tests/widgets/videomask.css",
      "toolkit/content/widgets/infobar.css",
      "toolkit/content/widgets/moz-box-common.css",
      "toolkit/content/widgets/moz-box-item/moz-box-item.css",
      "toolkit/content/widgets/moz-button/moz-button.css",
      "toolkit/content/widgets/moz-five-star/moz-five-star.css",
      "toolkit/content/widgets/moz-input-common.css",
      "toolkit/content/widgets/moz-input-text/moz-input-text.css",
      "toolkit/content/widgets/moz-message-bar/moz-message-bar.css",
      "toolkit/content/widgets/moz-page-nav/moz-page-nav-button.css",
      "toolkit/content/widgets/moz-page-nav/moz-page-nav.css",
      "toolkit/content/widgets/moz-reorderable-list/moz-reorderable-list.css",
      "toolkit/content/widgets/moz-select/moz-select.css",
      "toolkit/content/widgets/moz-toggle/moz-toggle.css",
      "toolkit/content/widgets/moz-visual-picker/moz-visual-picker-item.css",
      "toolkit/content/widgets/panel-list/panel-item.css",
      "toolkit/content/widgets/panel-list/panel-list.css",
      "toolkit/content/xul.css",
      "toolkit/crashreporter/content/crashes.css",
      "toolkit/mozapps/extensions/content/aboutaddons.css",
      "toolkit/mozapps/extensions/content/shortcuts.css",
      "toolkit/mozapps/handling/content/handler.css",
      "toolkit/themes/linux/global/autocomplete.css",
      "toolkit/themes/linux/global/global.css",
      "toolkit/themes/linux/global/richlistbox.css",
      "toolkit/themes/linux/mozapps/update/updates.css",
      "toolkit/themes/mobile/global/aboutMemory.css",
      "toolkit/themes/mobile/global/aboutNetworking.css",
      "toolkit/themes/mobile/global/aboutSupport.css",
      "toolkit/themes/osx/global/autocomplete.css",
      "toolkit/themes/osx/global/button.css",
      "toolkit/themes/osx/global/dialog.css",
      "toolkit/themes/osx/global/global.css",
      "toolkit/themes/osx/global/in-content/common.css",
      "toolkit/themes/osx/global/richlistbox.css",
      "toolkit/themes/osx/global/wizard.css",
      "toolkit/themes/osx/mozapps/handling/handling.css",
      "toolkit/themes/osx/mozapps/update/updates.css",
      "toolkit/themes/shared/aboutCache.css",
      "toolkit/themes/shared/aboutHttpsOnlyError.css",
      "toolkit/themes/shared/aboutLicense.css",
      "toolkit/themes/shared/aboutNetError.css",
      "toolkit/themes/shared/aboutNetworking.css",
      "toolkit/themes/shared/aboutProfiles.css",
      "toolkit/themes/shared/aboutReader.css",
      "toolkit/themes/shared/aboutServiceWorkers.css",
      "toolkit/themes/shared/aboutSupport.css",
      "toolkit/themes/shared/alert.css",
      "toolkit/themes/shared/appPicker.css",
      "toolkit/themes/shared/arrowscrollbox.css",
      "toolkit/themes/shared/checkbox.css",
      "toolkit/themes/shared/close-icon.css",
      "toolkit/themes/shared/commonDialog.css",
      "toolkit/themes/shared/datetimeinputpickers.css",
      "toolkit/themes/shared/design-system/storybook/tokens-table.css",
      "toolkit/themes/shared/dirListing/dirListing.css",
      "toolkit/themes/shared/downloads/unknownContentType.css",
      "toolkit/themes/shared/error-pages.css",
      "toolkit/themes/shared/findbar.css",
      "toolkit/themes/shared/global-shared.css",
      "toolkit/themes/shared/in-content/common-shared.css",
      "toolkit/themes/shared/in-content/info-pages.css",
      "toolkit/themes/shared/menu.css",
      "toolkit/themes/shared/menulist.css",
      "toolkit/themes/shared/narrate.css",
      "toolkit/themes/shared/offlineSupportPages.css",
      "toolkit/themes/shared/pictureinpicture/player.css",
      "toolkit/themes/shared/pictureinpicture/texttracks.css",
      "toolkit/themes/shared/popup.css",
      "toolkit/themes/shared/popupnotification.css",
      "toolkit/themes/shared/profileSelection.css",
      "toolkit/themes/shared/radio.css",
      "toolkit/themes/shared/splitter.css",
      "toolkit/themes/shared/tabbox.css",
      "toolkit/themes/shared/toolbar.css",
      "toolkit/themes/shared/toolbarbutton.css",
      "toolkit/themes/shared/tree/tree.css",
      "toolkit/themes/windows/global/autocomplete.css",
      "toolkit/themes/windows/global/button.css",
      "toolkit/themes/windows/global/dialog.css",
      "toolkit/themes/windows/global/global.css",
      "toolkit/themes/windows/global/printPageSetup.css",
      "toolkit/themes/windows/global/richlistbox.css",
      "toolkit/themes/windows/global/wizard.css",
      "toolkit/themes/windows/mozapps/handling/handling.css",
      "toolkit/themes/windows/mozapps/update/updates.css",
      "tools/tryselect/selectors/chooser/static/style.css",
    ],
  },
];
